/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/axios/index.js":
/*!*************************************!*\
  !*** ./node_modules/axios/index.js ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! ./lib/axios */ "./node_modules/axios/lib/axios.js");

/***/ }),

/***/ "./node_modules/axios/lib/adapters/xhr.js":
/*!************************************************!*\
  !*** ./node_modules/axios/lib/adapters/xhr.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var settle = __webpack_require__(/*! ./../core/settle */ "./node_modules/axios/lib/core/settle.js");
var buildURL = __webpack_require__(/*! ./../helpers/buildURL */ "./node_modules/axios/lib/helpers/buildURL.js");
var buildFullPath = __webpack_require__(/*! ../core/buildFullPath */ "./node_modules/axios/lib/core/buildFullPath.js");
var parseHeaders = __webpack_require__(/*! ./../helpers/parseHeaders */ "./node_modules/axios/lib/helpers/parseHeaders.js");
var isURLSameOrigin = __webpack_require__(/*! ./../helpers/isURLSameOrigin */ "./node_modules/axios/lib/helpers/isURLSameOrigin.js");
var createError = __webpack_require__(/*! ../core/createError */ "./node_modules/axios/lib/core/createError.js");

module.exports = function xhrAdapter(config) {
  return new Promise(function dispatchXhrRequest(resolve, reject) {
    var requestData = config.data;
    var requestHeaders = config.headers;

    if (utils.isFormData(requestData)) {
      delete requestHeaders['Content-Type']; // Let the browser set it
    }

    var request = new XMLHttpRequest();

    // HTTP basic authentication
    if (config.auth) {
      var username = config.auth.username || '';
      var password = config.auth.password || '';
      requestHeaders.Authorization = 'Basic ' + btoa(username + ':' + password);
    }

    var fullPath = buildFullPath(config.baseURL, config.url);
    request.open(config.method.toUpperCase(), buildURL(fullPath, config.params, config.paramsSerializer), true);

    // Set the request timeout in MS
    request.timeout = config.timeout;

    // Listen for ready state
    request.onreadystatechange = function handleLoad() {
      if (!request || request.readyState !== 4) {
        return;
      }

      // The request errored out and we didn't get a response, this will be
      // handled by onerror instead
      // With one exception: request that using file: protocol, most browsers
      // will return status as 0 even though it's a successful request
      if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf('file:') === 0)) {
        return;
      }

      // Prepare the response
      var responseHeaders = 'getAllResponseHeaders' in request ? parseHeaders(request.getAllResponseHeaders()) : null;
      var responseData = !config.responseType || config.responseType === 'text' ? request.responseText : request.response;
      var response = {
        data: responseData,
        status: request.status,
        statusText: request.statusText,
        headers: responseHeaders,
        config: config,
        request: request
      };

      settle(resolve, reject, response);

      // Clean up request
      request = null;
    };

    // Handle browser request cancellation (as opposed to a manual cancellation)
    request.onabort = function handleAbort() {
      if (!request) {
        return;
      }

      reject(createError('Request aborted', config, 'ECONNABORTED', request));

      // Clean up request
      request = null;
    };

    // Handle low level network errors
    request.onerror = function handleError() {
      // Real errors are hidden from us by the browser
      // onerror should only fire if it's a network error
      reject(createError('Network Error', config, null, request));

      // Clean up request
      request = null;
    };

    // Handle timeout
    request.ontimeout = function handleTimeout() {
      var timeoutErrorMessage = 'timeout of ' + config.timeout + 'ms exceeded';
      if (config.timeoutErrorMessage) {
        timeoutErrorMessage = config.timeoutErrorMessage;
      }
      reject(createError(timeoutErrorMessage, config, 'ECONNABORTED',
        request));

      // Clean up request
      request = null;
    };

    // Add xsrf header
    // This is only done if running in a standard browser environment.
    // Specifically not if we're in a web worker, or react-native.
    if (utils.isStandardBrowserEnv()) {
      var cookies = __webpack_require__(/*! ./../helpers/cookies */ "./node_modules/axios/lib/helpers/cookies.js");

      // Add xsrf header
      var xsrfValue = (config.withCredentials || isURLSameOrigin(fullPath)) && config.xsrfCookieName ?
        cookies.read(config.xsrfCookieName) :
        undefined;

      if (xsrfValue) {
        requestHeaders[config.xsrfHeaderName] = xsrfValue;
      }
    }

    // Add headers to the request
    if ('setRequestHeader' in request) {
      utils.forEach(requestHeaders, function setRequestHeader(val, key) {
        if (typeof requestData === 'undefined' && key.toLowerCase() === 'content-type') {
          // Remove Content-Type if data is undefined
          delete requestHeaders[key];
        } else {
          // Otherwise add header to the request
          request.setRequestHeader(key, val);
        }
      });
    }

    // Add withCredentials to request if needed
    if (!utils.isUndefined(config.withCredentials)) {
      request.withCredentials = !!config.withCredentials;
    }

    // Add responseType to request if needed
    if (config.responseType) {
      try {
        request.responseType = config.responseType;
      } catch (e) {
        // Expected DOMException thrown by browsers not compatible XMLHttpRequest Level 2.
        // But, this can be suppressed for 'json' type as it can be parsed by default 'transformResponse' function.
        if (config.responseType !== 'json') {
          throw e;
        }
      }
    }

    // Handle progress if needed
    if (typeof config.onDownloadProgress === 'function') {
      request.addEventListener('progress', config.onDownloadProgress);
    }

    // Not all browsers support upload events
    if (typeof config.onUploadProgress === 'function' && request.upload) {
      request.upload.addEventListener('progress', config.onUploadProgress);
    }

    if (config.cancelToken) {
      // Handle cancellation
      config.cancelToken.promise.then(function onCanceled(cancel) {
        if (!request) {
          return;
        }

        request.abort();
        reject(cancel);
        // Clean up request
        request = null;
      });
    }

    if (requestData === undefined) {
      requestData = null;
    }

    // Send the request
    request.send(requestData);
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/axios.js":
/*!*****************************************!*\
  !*** ./node_modules/axios/lib/axios.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./utils */ "./node_modules/axios/lib/utils.js");
var bind = __webpack_require__(/*! ./helpers/bind */ "./node_modules/axios/lib/helpers/bind.js");
var Axios = __webpack_require__(/*! ./core/Axios */ "./node_modules/axios/lib/core/Axios.js");
var mergeConfig = __webpack_require__(/*! ./core/mergeConfig */ "./node_modules/axios/lib/core/mergeConfig.js");
var defaults = __webpack_require__(/*! ./defaults */ "./node_modules/axios/lib/defaults.js");

/**
 * Create an instance of Axios
 *
 * @param {Object} defaultConfig The default config for the instance
 * @return {Axios} A new instance of Axios
 */
function createInstance(defaultConfig) {
  var context = new Axios(defaultConfig);
  var instance = bind(Axios.prototype.request, context);

  // Copy axios.prototype to instance
  utils.extend(instance, Axios.prototype, context);

  // Copy context to instance
  utils.extend(instance, context);

  return instance;
}

// Create the default instance to be exported
var axios = createInstance(defaults);

// Expose Axios class to allow class inheritance
axios.Axios = Axios;

// Factory for creating new instances
axios.create = function create(instanceConfig) {
  return createInstance(mergeConfig(axios.defaults, instanceConfig));
};

// Expose Cancel & CancelToken
axios.Cancel = __webpack_require__(/*! ./cancel/Cancel */ "./node_modules/axios/lib/cancel/Cancel.js");
axios.CancelToken = __webpack_require__(/*! ./cancel/CancelToken */ "./node_modules/axios/lib/cancel/CancelToken.js");
axios.isCancel = __webpack_require__(/*! ./cancel/isCancel */ "./node_modules/axios/lib/cancel/isCancel.js");

// Expose all/spread
axios.all = function all(promises) {
  return Promise.all(promises);
};
axios.spread = __webpack_require__(/*! ./helpers/spread */ "./node_modules/axios/lib/helpers/spread.js");

module.exports = axios;

// Allow use of default import syntax in TypeScript
module.exports["default"] = axios;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/Cancel.js":
/*!*************************************************!*\
  !*** ./node_modules/axios/lib/cancel/Cancel.js ***!
  \*************************************************/
/***/ ((module) => {

"use strict";


/**
 * A `Cancel` is an object that is thrown when an operation is canceled.
 *
 * @class
 * @param {string=} message The message.
 */
function Cancel(message) {
  this.message = message;
}

Cancel.prototype.toString = function toString() {
  return 'Cancel' + (this.message ? ': ' + this.message : '');
};

Cancel.prototype.__CANCEL__ = true;

module.exports = Cancel;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/CancelToken.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/cancel/CancelToken.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var Cancel = __webpack_require__(/*! ./Cancel */ "./node_modules/axios/lib/cancel/Cancel.js");

/**
 * A `CancelToken` is an object that can be used to request cancellation of an operation.
 *
 * @class
 * @param {Function} executor The executor function.
 */
function CancelToken(executor) {
  if (typeof executor !== 'function') {
    throw new TypeError('executor must be a function.');
  }

  var resolvePromise;
  this.promise = new Promise(function promiseExecutor(resolve) {
    resolvePromise = resolve;
  });

  var token = this;
  executor(function cancel(message) {
    if (token.reason) {
      // Cancellation has already been requested
      return;
    }

    token.reason = new Cancel(message);
    resolvePromise(token.reason);
  });
}

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
CancelToken.prototype.throwIfRequested = function throwIfRequested() {
  if (this.reason) {
    throw this.reason;
  }
};

/**
 * Returns an object that contains a new `CancelToken` and a function that, when called,
 * cancels the `CancelToken`.
 */
CancelToken.source = function source() {
  var cancel;
  var token = new CancelToken(function executor(c) {
    cancel = c;
  });
  return {
    token: token,
    cancel: cancel
  };
};

module.exports = CancelToken;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/isCancel.js":
/*!***************************************************!*\
  !*** ./node_modules/axios/lib/cancel/isCancel.js ***!
  \***************************************************/
/***/ ((module) => {

"use strict";


module.exports = function isCancel(value) {
  return !!(value && value.__CANCEL__);
};


/***/ }),

/***/ "./node_modules/axios/lib/core/Axios.js":
/*!**********************************************!*\
  !*** ./node_modules/axios/lib/core/Axios.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var buildURL = __webpack_require__(/*! ../helpers/buildURL */ "./node_modules/axios/lib/helpers/buildURL.js");
var InterceptorManager = __webpack_require__(/*! ./InterceptorManager */ "./node_modules/axios/lib/core/InterceptorManager.js");
var dispatchRequest = __webpack_require__(/*! ./dispatchRequest */ "./node_modules/axios/lib/core/dispatchRequest.js");
var mergeConfig = __webpack_require__(/*! ./mergeConfig */ "./node_modules/axios/lib/core/mergeConfig.js");

/**
 * Create a new instance of Axios
 *
 * @param {Object} instanceConfig The default config for the instance
 */
function Axios(instanceConfig) {
  this.defaults = instanceConfig;
  this.interceptors = {
    request: new InterceptorManager(),
    response: new InterceptorManager()
  };
}

/**
 * Dispatch a request
 *
 * @param {Object} config The config specific for this request (merged with this.defaults)
 */
Axios.prototype.request = function request(config) {
  /*eslint no-param-reassign:0*/
  // Allow for axios('example/url'[, config]) a la fetch API
  if (typeof config === 'string') {
    config = arguments[1] || {};
    config.url = arguments[0];
  } else {
    config = config || {};
  }

  config = mergeConfig(this.defaults, config);

  // Set config.method
  if (config.method) {
    config.method = config.method.toLowerCase();
  } else if (this.defaults.method) {
    config.method = this.defaults.method.toLowerCase();
  } else {
    config.method = 'get';
  }

  // Hook up interceptors middleware
  var chain = [dispatchRequest, undefined];
  var promise = Promise.resolve(config);

  this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
    chain.unshift(interceptor.fulfilled, interceptor.rejected);
  });

  this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
    chain.push(interceptor.fulfilled, interceptor.rejected);
  });

  while (chain.length) {
    promise = promise.then(chain.shift(), chain.shift());
  }

  return promise;
};

Axios.prototype.getUri = function getUri(config) {
  config = mergeConfig(this.defaults, config);
  return buildURL(config.url, config.params, config.paramsSerializer).replace(/^\?/, '');
};

// Provide aliases for supported request methods
utils.forEach(['delete', 'get', 'head', 'options'], function forEachMethodNoData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, config) {
    return this.request(utils.merge(config || {}, {
      method: method,
      url: url
    }));
  };
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, data, config) {
    return this.request(utils.merge(config || {}, {
      method: method,
      url: url,
      data: data
    }));
  };
});

module.exports = Axios;


/***/ }),

/***/ "./node_modules/axios/lib/core/InterceptorManager.js":
/*!***********************************************************!*\
  !*** ./node_modules/axios/lib/core/InterceptorManager.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

function InterceptorManager() {
  this.handlers = [];
}

/**
 * Add a new interceptor to the stack
 *
 * @param {Function} fulfilled The function to handle `then` for a `Promise`
 * @param {Function} rejected The function to handle `reject` for a `Promise`
 *
 * @return {Number} An ID used to remove interceptor later
 */
InterceptorManager.prototype.use = function use(fulfilled, rejected) {
  this.handlers.push({
    fulfilled: fulfilled,
    rejected: rejected
  });
  return this.handlers.length - 1;
};

/**
 * Remove an interceptor from the stack
 *
 * @param {Number} id The ID that was returned by `use`
 */
InterceptorManager.prototype.eject = function eject(id) {
  if (this.handlers[id]) {
    this.handlers[id] = null;
  }
};

/**
 * Iterate over all the registered interceptors
 *
 * This method is particularly useful for skipping over any
 * interceptors that may have become `null` calling `eject`.
 *
 * @param {Function} fn The function to call for each interceptor
 */
InterceptorManager.prototype.forEach = function forEach(fn) {
  utils.forEach(this.handlers, function forEachHandler(h) {
    if (h !== null) {
      fn(h);
    }
  });
};

module.exports = InterceptorManager;


/***/ }),

/***/ "./node_modules/axios/lib/core/buildFullPath.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/core/buildFullPath.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var isAbsoluteURL = __webpack_require__(/*! ../helpers/isAbsoluteURL */ "./node_modules/axios/lib/helpers/isAbsoluteURL.js");
var combineURLs = __webpack_require__(/*! ../helpers/combineURLs */ "./node_modules/axios/lib/helpers/combineURLs.js");

/**
 * Creates a new URL by combining the baseURL with the requestedURL,
 * only when the requestedURL is not already an absolute URL.
 * If the requestURL is absolute, this function returns the requestedURL untouched.
 *
 * @param {string} baseURL The base URL
 * @param {string} requestedURL Absolute or relative URL to combine
 * @returns {string} The combined full path
 */
module.exports = function buildFullPath(baseURL, requestedURL) {
  if (baseURL && !isAbsoluteURL(requestedURL)) {
    return combineURLs(baseURL, requestedURL);
  }
  return requestedURL;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/createError.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/core/createError.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var enhanceError = __webpack_require__(/*! ./enhanceError */ "./node_modules/axios/lib/core/enhanceError.js");

/**
 * Create an Error with the specified message, config, error code, request and response.
 *
 * @param {string} message The error message.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 * @returns {Error} The created error.
 */
module.exports = function createError(message, config, code, request, response) {
  var error = new Error(message);
  return enhanceError(error, config, code, request, response);
};


/***/ }),

/***/ "./node_modules/axios/lib/core/dispatchRequest.js":
/*!********************************************************!*\
  !*** ./node_modules/axios/lib/core/dispatchRequest.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var transformData = __webpack_require__(/*! ./transformData */ "./node_modules/axios/lib/core/transformData.js");
var isCancel = __webpack_require__(/*! ../cancel/isCancel */ "./node_modules/axios/lib/cancel/isCancel.js");
var defaults = __webpack_require__(/*! ../defaults */ "./node_modules/axios/lib/defaults.js");

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
function throwIfCancellationRequested(config) {
  if (config.cancelToken) {
    config.cancelToken.throwIfRequested();
  }
}

/**
 * Dispatch a request to the server using the configured adapter.
 *
 * @param {object} config The config that is to be used for the request
 * @returns {Promise} The Promise to be fulfilled
 */
module.exports = function dispatchRequest(config) {
  throwIfCancellationRequested(config);

  // Ensure headers exist
  config.headers = config.headers || {};

  // Transform request data
  config.data = transformData(
    config.data,
    config.headers,
    config.transformRequest
  );

  // Flatten headers
  config.headers = utils.merge(
    config.headers.common || {},
    config.headers[config.method] || {},
    config.headers
  );

  utils.forEach(
    ['delete', 'get', 'head', 'post', 'put', 'patch', 'common'],
    function cleanHeaderConfig(method) {
      delete config.headers[method];
    }
  );

  var adapter = config.adapter || defaults.adapter;

  return adapter(config).then(function onAdapterResolution(response) {
    throwIfCancellationRequested(config);

    // Transform response data
    response.data = transformData(
      response.data,
      response.headers,
      config.transformResponse
    );

    return response;
  }, function onAdapterRejection(reason) {
    if (!isCancel(reason)) {
      throwIfCancellationRequested(config);

      // Transform response data
      if (reason && reason.response) {
        reason.response.data = transformData(
          reason.response.data,
          reason.response.headers,
          config.transformResponse
        );
      }
    }

    return Promise.reject(reason);
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/core/enhanceError.js":
/*!*****************************************************!*\
  !*** ./node_modules/axios/lib/core/enhanceError.js ***!
  \*****************************************************/
/***/ ((module) => {

"use strict";


/**
 * Update an Error with the specified config, error code, and response.
 *
 * @param {Error} error The error to update.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 * @returns {Error} The error.
 */
module.exports = function enhanceError(error, config, code, request, response) {
  error.config = config;
  if (code) {
    error.code = code;
  }

  error.request = request;
  error.response = response;
  error.isAxiosError = true;

  error.toJSON = function() {
    return {
      // Standard
      message: this.message,
      name: this.name,
      // Microsoft
      description: this.description,
      number: this.number,
      // Mozilla
      fileName: this.fileName,
      lineNumber: this.lineNumber,
      columnNumber: this.columnNumber,
      stack: this.stack,
      // Axios
      config: this.config,
      code: this.code
    };
  };
  return error;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/mergeConfig.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/core/mergeConfig.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ../utils */ "./node_modules/axios/lib/utils.js");

/**
 * Config-specific merge-function which creates a new config-object
 * by merging two configuration objects together.
 *
 * @param {Object} config1
 * @param {Object} config2
 * @returns {Object} New object resulting from merging config2 to config1
 */
module.exports = function mergeConfig(config1, config2) {
  // eslint-disable-next-line no-param-reassign
  config2 = config2 || {};
  var config = {};

  var valueFromConfig2Keys = ['url', 'method', 'params', 'data'];
  var mergeDeepPropertiesKeys = ['headers', 'auth', 'proxy'];
  var defaultToConfig2Keys = [
    'baseURL', 'url', 'transformRequest', 'transformResponse', 'paramsSerializer',
    'timeout', 'withCredentials', 'adapter', 'responseType', 'xsrfCookieName',
    'xsrfHeaderName', 'onUploadProgress', 'onDownloadProgress',
    'maxContentLength', 'validateStatus', 'maxRedirects', 'httpAgent',
    'httpsAgent', 'cancelToken', 'socketPath'
  ];

  utils.forEach(valueFromConfig2Keys, function valueFromConfig2(prop) {
    if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    }
  });

  utils.forEach(mergeDeepPropertiesKeys, function mergeDeepProperties(prop) {
    if (utils.isObject(config2[prop])) {
      config[prop] = utils.deepMerge(config1[prop], config2[prop]);
    } else if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    } else if (utils.isObject(config1[prop])) {
      config[prop] = utils.deepMerge(config1[prop]);
    } else if (typeof config1[prop] !== 'undefined') {
      config[prop] = config1[prop];
    }
  });

  utils.forEach(defaultToConfig2Keys, function defaultToConfig2(prop) {
    if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    } else if (typeof config1[prop] !== 'undefined') {
      config[prop] = config1[prop];
    }
  });

  var axiosKeys = valueFromConfig2Keys
    .concat(mergeDeepPropertiesKeys)
    .concat(defaultToConfig2Keys);

  var otherKeys = Object
    .keys(config2)
    .filter(function filterAxiosKeys(key) {
      return axiosKeys.indexOf(key) === -1;
    });

  utils.forEach(otherKeys, function otherKeysDefaultToConfig2(prop) {
    if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    } else if (typeof config1[prop] !== 'undefined') {
      config[prop] = config1[prop];
    }
  });

  return config;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/settle.js":
/*!***********************************************!*\
  !*** ./node_modules/axios/lib/core/settle.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var createError = __webpack_require__(/*! ./createError */ "./node_modules/axios/lib/core/createError.js");

/**
 * Resolve or reject a Promise based on response status.
 *
 * @param {Function} resolve A function that resolves the promise.
 * @param {Function} reject A function that rejects the promise.
 * @param {object} response The response.
 */
module.exports = function settle(resolve, reject, response) {
  var validateStatus = response.config.validateStatus;
  if (!validateStatus || validateStatus(response.status)) {
    resolve(response);
  } else {
    reject(createError(
      'Request failed with status code ' + response.status,
      response.config,
      null,
      response.request,
      response
    ));
  }
};


/***/ }),

/***/ "./node_modules/axios/lib/core/transformData.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/core/transformData.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

/**
 * Transform the data for a request or a response
 *
 * @param {Object|String} data The data to be transformed
 * @param {Array} headers The headers for the request or response
 * @param {Array|Function} fns A single function or Array of functions
 * @returns {*} The resulting transformed data
 */
module.exports = function transformData(data, headers, fns) {
  /*eslint no-param-reassign:0*/
  utils.forEach(fns, function transform(fn) {
    data = fn(data, headers);
  });

  return data;
};


/***/ }),

/***/ "./node_modules/axios/lib/defaults.js":
/*!********************************************!*\
  !*** ./node_modules/axios/lib/defaults.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process/browser.js */ "./node_modules/process/browser.js");


var utils = __webpack_require__(/*! ./utils */ "./node_modules/axios/lib/utils.js");
var normalizeHeaderName = __webpack_require__(/*! ./helpers/normalizeHeaderName */ "./node_modules/axios/lib/helpers/normalizeHeaderName.js");

var DEFAULT_CONTENT_TYPE = {
  'Content-Type': 'application/x-www-form-urlencoded'
};

function setContentTypeIfUnset(headers, value) {
  if (!utils.isUndefined(headers) && utils.isUndefined(headers['Content-Type'])) {
    headers['Content-Type'] = value;
  }
}

function getDefaultAdapter() {
  var adapter;
  if (typeof XMLHttpRequest !== 'undefined') {
    // For browsers use XHR adapter
    adapter = __webpack_require__(/*! ./adapters/xhr */ "./node_modules/axios/lib/adapters/xhr.js");
  } else if (typeof process !== 'undefined' && Object.prototype.toString.call(process) === '[object process]') {
    // For node use HTTP adapter
    adapter = __webpack_require__(/*! ./adapters/http */ "./node_modules/axios/lib/adapters/xhr.js");
  }
  return adapter;
}

var defaults = {
  adapter: getDefaultAdapter(),

  transformRequest: [function transformRequest(data, headers) {
    normalizeHeaderName(headers, 'Accept');
    normalizeHeaderName(headers, 'Content-Type');
    if (utils.isFormData(data) ||
      utils.isArrayBuffer(data) ||
      utils.isBuffer(data) ||
      utils.isStream(data) ||
      utils.isFile(data) ||
      utils.isBlob(data)
    ) {
      return data;
    }
    if (utils.isArrayBufferView(data)) {
      return data.buffer;
    }
    if (utils.isURLSearchParams(data)) {
      setContentTypeIfUnset(headers, 'application/x-www-form-urlencoded;charset=utf-8');
      return data.toString();
    }
    if (utils.isObject(data)) {
      setContentTypeIfUnset(headers, 'application/json;charset=utf-8');
      return JSON.stringify(data);
    }
    return data;
  }],

  transformResponse: [function transformResponse(data) {
    /*eslint no-param-reassign:0*/
    if (typeof data === 'string') {
      try {
        data = JSON.parse(data);
      } catch (e) { /* Ignore */ }
    }
    return data;
  }],

  /**
   * A timeout in milliseconds to abort a request. If set to 0 (default) a
   * timeout is not created.
   */
  timeout: 0,

  xsrfCookieName: 'XSRF-TOKEN',
  xsrfHeaderName: 'X-XSRF-TOKEN',

  maxContentLength: -1,

  validateStatus: function validateStatus(status) {
    return status >= 200 && status < 300;
  }
};

defaults.headers = {
  common: {
    'Accept': 'application/json, text/plain, */*'
  }
};

utils.forEach(['delete', 'get', 'head'], function forEachMethodNoData(method) {
  defaults.headers[method] = {};
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  defaults.headers[method] = utils.merge(DEFAULT_CONTENT_TYPE);
});

module.exports = defaults;


/***/ }),

/***/ "./node_modules/axios/lib/helpers/bind.js":
/*!************************************************!*\
  !*** ./node_modules/axios/lib/helpers/bind.js ***!
  \************************************************/
/***/ ((module) => {

"use strict";


module.exports = function bind(fn, thisArg) {
  return function wrap() {
    var args = new Array(arguments.length);
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }
    return fn.apply(thisArg, args);
  };
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/buildURL.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/helpers/buildURL.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

function encode(val) {
  return encodeURIComponent(val).
    replace(/%40/gi, '@').
    replace(/%3A/gi, ':').
    replace(/%24/g, '$').
    replace(/%2C/gi, ',').
    replace(/%20/g, '+').
    replace(/%5B/gi, '[').
    replace(/%5D/gi, ']');
}

/**
 * Build a URL by appending params to the end
 *
 * @param {string} url The base of the url (e.g., http://www.google.com)
 * @param {object} [params] The params to be appended
 * @returns {string} The formatted url
 */
module.exports = function buildURL(url, params, paramsSerializer) {
  /*eslint no-param-reassign:0*/
  if (!params) {
    return url;
  }

  var serializedParams;
  if (paramsSerializer) {
    serializedParams = paramsSerializer(params);
  } else if (utils.isURLSearchParams(params)) {
    serializedParams = params.toString();
  } else {
    var parts = [];

    utils.forEach(params, function serialize(val, key) {
      if (val === null || typeof val === 'undefined') {
        return;
      }

      if (utils.isArray(val)) {
        key = key + '[]';
      } else {
        val = [val];
      }

      utils.forEach(val, function parseValue(v) {
        if (utils.isDate(v)) {
          v = v.toISOString();
        } else if (utils.isObject(v)) {
          v = JSON.stringify(v);
        }
        parts.push(encode(key) + '=' + encode(v));
      });
    });

    serializedParams = parts.join('&');
  }

  if (serializedParams) {
    var hashmarkIndex = url.indexOf('#');
    if (hashmarkIndex !== -1) {
      url = url.slice(0, hashmarkIndex);
    }

    url += (url.indexOf('?') === -1 ? '?' : '&') + serializedParams;
  }

  return url;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/combineURLs.js":
/*!*******************************************************!*\
  !*** ./node_modules/axios/lib/helpers/combineURLs.js ***!
  \*******************************************************/
/***/ ((module) => {

"use strict";


/**
 * Creates a new URL by combining the specified URLs
 *
 * @param {string} baseURL The base URL
 * @param {string} relativeURL The relative URL
 * @returns {string} The combined URL
 */
module.exports = function combineURLs(baseURL, relativeURL) {
  return relativeURL
    ? baseURL.replace(/\/+$/, '') + '/' + relativeURL.replace(/^\/+/, '')
    : baseURL;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/cookies.js":
/*!***************************************************!*\
  !*** ./node_modules/axios/lib/helpers/cookies.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

module.exports = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs support document.cookie
    (function standardBrowserEnv() {
      return {
        write: function write(name, value, expires, path, domain, secure) {
          var cookie = [];
          cookie.push(name + '=' + encodeURIComponent(value));

          if (utils.isNumber(expires)) {
            cookie.push('expires=' + new Date(expires).toGMTString());
          }

          if (utils.isString(path)) {
            cookie.push('path=' + path);
          }

          if (utils.isString(domain)) {
            cookie.push('domain=' + domain);
          }

          if (secure === true) {
            cookie.push('secure');
          }

          document.cookie = cookie.join('; ');
        },

        read: function read(name) {
          var match = document.cookie.match(new RegExp('(^|;\\s*)(' + name + ')=([^;]*)'));
          return (match ? decodeURIComponent(match[3]) : null);
        },

        remove: function remove(name) {
          this.write(name, '', Date.now() - 86400000);
        }
      };
    })() :

  // Non standard browser env (web workers, react-native) lack needed support.
    (function nonStandardBrowserEnv() {
      return {
        write: function write() {},
        read: function read() { return null; },
        remove: function remove() {}
      };
    })()
);


/***/ }),

/***/ "./node_modules/axios/lib/helpers/isAbsoluteURL.js":
/*!*********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/isAbsoluteURL.js ***!
  \*********************************************************/
/***/ ((module) => {

"use strict";


/**
 * Determines whether the specified URL is absolute
 *
 * @param {string} url The URL to test
 * @returns {boolean} True if the specified URL is absolute, otherwise false
 */
module.exports = function isAbsoluteURL(url) {
  // A URL is considered absolute if it begins with "<scheme>://" or "//" (protocol-relative URL).
  // RFC 3986 defines scheme name as a sequence of characters beginning with a letter and followed
  // by any combination of letters, digits, plus, period, or hyphen.
  return /^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url);
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/isURLSameOrigin.js":
/*!***********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/isURLSameOrigin.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

module.exports = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs have full support of the APIs needed to test
  // whether the request URL is of the same origin as current location.
    (function standardBrowserEnv() {
      var msie = /(msie|trident)/i.test(navigator.userAgent);
      var urlParsingNode = document.createElement('a');
      var originURL;

      /**
    * Parse a URL to discover it's components
    *
    * @param {String} url The URL to be parsed
    * @returns {Object}
    */
      function resolveURL(url) {
        var href = url;

        if (msie) {
        // IE needs attribute set twice to normalize properties
          urlParsingNode.setAttribute('href', href);
          href = urlParsingNode.href;
        }

        urlParsingNode.setAttribute('href', href);

        // urlParsingNode provides the UrlUtils interface - http://url.spec.whatwg.org/#urlutils
        return {
          href: urlParsingNode.href,
          protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, '') : '',
          host: urlParsingNode.host,
          search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, '') : '',
          hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, '') : '',
          hostname: urlParsingNode.hostname,
          port: urlParsingNode.port,
          pathname: (urlParsingNode.pathname.charAt(0) === '/') ?
            urlParsingNode.pathname :
            '/' + urlParsingNode.pathname
        };
      }

      originURL = resolveURL(window.location.href);

      /**
    * Determine if a URL shares the same origin as the current location
    *
    * @param {String} requestURL The URL to test
    * @returns {boolean} True if URL shares the same origin, otherwise false
    */
      return function isURLSameOrigin(requestURL) {
        var parsed = (utils.isString(requestURL)) ? resolveURL(requestURL) : requestURL;
        return (parsed.protocol === originURL.protocol &&
            parsed.host === originURL.host);
      };
    })() :

  // Non standard browser envs (web workers, react-native) lack needed support.
    (function nonStandardBrowserEnv() {
      return function isURLSameOrigin() {
        return true;
      };
    })()
);


/***/ }),

/***/ "./node_modules/axios/lib/helpers/normalizeHeaderName.js":
/*!***************************************************************!*\
  !*** ./node_modules/axios/lib/helpers/normalizeHeaderName.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ../utils */ "./node_modules/axios/lib/utils.js");

module.exports = function normalizeHeaderName(headers, normalizedName) {
  utils.forEach(headers, function processHeader(value, name) {
    if (name !== normalizedName && name.toUpperCase() === normalizedName.toUpperCase()) {
      headers[normalizedName] = value;
      delete headers[name];
    }
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/parseHeaders.js":
/*!********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/parseHeaders.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

// Headers whose duplicates are ignored by node
// c.f. https://nodejs.org/api/http.html#http_message_headers
var ignoreDuplicateOf = [
  'age', 'authorization', 'content-length', 'content-type', 'etag',
  'expires', 'from', 'host', 'if-modified-since', 'if-unmodified-since',
  'last-modified', 'location', 'max-forwards', 'proxy-authorization',
  'referer', 'retry-after', 'user-agent'
];

/**
 * Parse headers into an object
 *
 * ```
 * Date: Wed, 27 Aug 2014 08:58:49 GMT
 * Content-Type: application/json
 * Connection: keep-alive
 * Transfer-Encoding: chunked
 * ```
 *
 * @param {String} headers Headers needing to be parsed
 * @returns {Object} Headers parsed into an object
 */
module.exports = function parseHeaders(headers) {
  var parsed = {};
  var key;
  var val;
  var i;

  if (!headers) { return parsed; }

  utils.forEach(headers.split('\n'), function parser(line) {
    i = line.indexOf(':');
    key = utils.trim(line.substr(0, i)).toLowerCase();
    val = utils.trim(line.substr(i + 1));

    if (key) {
      if (parsed[key] && ignoreDuplicateOf.indexOf(key) >= 0) {
        return;
      }
      if (key === 'set-cookie') {
        parsed[key] = (parsed[key] ? parsed[key] : []).concat([val]);
      } else {
        parsed[key] = parsed[key] ? parsed[key] + ', ' + val : val;
      }
    }
  });

  return parsed;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/spread.js":
/*!**************************************************!*\
  !*** ./node_modules/axios/lib/helpers/spread.js ***!
  \**************************************************/
/***/ ((module) => {

"use strict";


/**
 * Syntactic sugar for invoking a function and expanding an array for arguments.
 *
 * Common use case would be to use `Function.prototype.apply`.
 *
 *  ```js
 *  function f(x, y, z) {}
 *  var args = [1, 2, 3];
 *  f.apply(null, args);
 *  ```
 *
 * With `spread` this example can be re-written.
 *
 *  ```js
 *  spread(function(x, y, z) {})([1, 2, 3]);
 *  ```
 *
 * @param {Function} callback
 * @returns {Function}
 */
module.exports = function spread(callback) {
  return function wrap(arr) {
    return callback.apply(null, arr);
  };
};


/***/ }),

/***/ "./node_modules/axios/lib/utils.js":
/*!*****************************************!*\
  !*** ./node_modules/axios/lib/utils.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(/*! ./helpers/bind */ "./node_modules/axios/lib/helpers/bind.js");

/*global toString:true*/

// utils is a library of generic helper functions non-specific to axios

var toString = Object.prototype.toString;

/**
 * Determine if a value is an Array
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Array, otherwise false
 */
function isArray(val) {
  return toString.call(val) === '[object Array]';
}

/**
 * Determine if a value is undefined
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if the value is undefined, otherwise false
 */
function isUndefined(val) {
  return typeof val === 'undefined';
}

/**
 * Determine if a value is a Buffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Buffer, otherwise false
 */
function isBuffer(val) {
  return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor)
    && typeof val.constructor.isBuffer === 'function' && val.constructor.isBuffer(val);
}

/**
 * Determine if a value is an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an ArrayBuffer, otherwise false
 */
function isArrayBuffer(val) {
  return toString.call(val) === '[object ArrayBuffer]';
}

/**
 * Determine if a value is a FormData
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an FormData, otherwise false
 */
function isFormData(val) {
  return (typeof FormData !== 'undefined') && (val instanceof FormData);
}

/**
 * Determine if a value is a view on an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a view on an ArrayBuffer, otherwise false
 */
function isArrayBufferView(val) {
  var result;
  if ((typeof ArrayBuffer !== 'undefined') && (ArrayBuffer.isView)) {
    result = ArrayBuffer.isView(val);
  } else {
    result = (val) && (val.buffer) && (val.buffer instanceof ArrayBuffer);
  }
  return result;
}

/**
 * Determine if a value is a String
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a String, otherwise false
 */
function isString(val) {
  return typeof val === 'string';
}

/**
 * Determine if a value is a Number
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Number, otherwise false
 */
function isNumber(val) {
  return typeof val === 'number';
}

/**
 * Determine if a value is an Object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Object, otherwise false
 */
function isObject(val) {
  return val !== null && typeof val === 'object';
}

/**
 * Determine if a value is a Date
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Date, otherwise false
 */
function isDate(val) {
  return toString.call(val) === '[object Date]';
}

/**
 * Determine if a value is a File
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a File, otherwise false
 */
function isFile(val) {
  return toString.call(val) === '[object File]';
}

/**
 * Determine if a value is a Blob
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Blob, otherwise false
 */
function isBlob(val) {
  return toString.call(val) === '[object Blob]';
}

/**
 * Determine if a value is a Function
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Function, otherwise false
 */
function isFunction(val) {
  return toString.call(val) === '[object Function]';
}

/**
 * Determine if a value is a Stream
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Stream, otherwise false
 */
function isStream(val) {
  return isObject(val) && isFunction(val.pipe);
}

/**
 * Determine if a value is a URLSearchParams object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a URLSearchParams object, otherwise false
 */
function isURLSearchParams(val) {
  return typeof URLSearchParams !== 'undefined' && val instanceof URLSearchParams;
}

/**
 * Trim excess whitespace off the beginning and end of a string
 *
 * @param {String} str The String to trim
 * @returns {String} The String freed of excess whitespace
 */
function trim(str) {
  return str.replace(/^\s*/, '').replace(/\s*$/, '');
}

/**
 * Determine if we're running in a standard browser environment
 *
 * This allows axios to run in a web worker, and react-native.
 * Both environments support XMLHttpRequest, but not fully standard globals.
 *
 * web workers:
 *  typeof window -> undefined
 *  typeof document -> undefined
 *
 * react-native:
 *  navigator.product -> 'ReactNative'
 * nativescript
 *  navigator.product -> 'NativeScript' or 'NS'
 */
function isStandardBrowserEnv() {
  if (typeof navigator !== 'undefined' && (navigator.product === 'ReactNative' ||
                                           navigator.product === 'NativeScript' ||
                                           navigator.product === 'NS')) {
    return false;
  }
  return (
    typeof window !== 'undefined' &&
    typeof document !== 'undefined'
  );
}

/**
 * Iterate over an Array or an Object invoking a function for each item.
 *
 * If `obj` is an Array callback will be called passing
 * the value, index, and complete array for each item.
 *
 * If 'obj' is an Object callback will be called passing
 * the value, key, and complete object for each property.
 *
 * @param {Object|Array} obj The object to iterate
 * @param {Function} fn The callback to invoke for each item
 */
function forEach(obj, fn) {
  // Don't bother if no value provided
  if (obj === null || typeof obj === 'undefined') {
    return;
  }

  // Force an array if not already something iterable
  if (typeof obj !== 'object') {
    /*eslint no-param-reassign:0*/
    obj = [obj];
  }

  if (isArray(obj)) {
    // Iterate over array values
    for (var i = 0, l = obj.length; i < l; i++) {
      fn.call(null, obj[i], i, obj);
    }
  } else {
    // Iterate over object keys
    for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        fn.call(null, obj[key], key, obj);
      }
    }
  }
}

/**
 * Accepts varargs expecting each argument to be an object, then
 * immutably merges the properties of each object and returns result.
 *
 * When multiple objects contain the same key the later object in
 * the arguments list will take precedence.
 *
 * Example:
 *
 * ```js
 * var result = merge({foo: 123}, {foo: 456});
 * console.log(result.foo); // outputs 456
 * ```
 *
 * @param {Object} obj1 Object to merge
 * @returns {Object} Result of all merge properties
 */
function merge(/* obj1, obj2, obj3, ... */) {
  var result = {};
  function assignValue(val, key) {
    if (typeof result[key] === 'object' && typeof val === 'object') {
      result[key] = merge(result[key], val);
    } else {
      result[key] = val;
    }
  }

  for (var i = 0, l = arguments.length; i < l; i++) {
    forEach(arguments[i], assignValue);
  }
  return result;
}

/**
 * Function equal to merge with the difference being that no reference
 * to original objects is kept.
 *
 * @see merge
 * @param {Object} obj1 Object to merge
 * @returns {Object} Result of all merge properties
 */
function deepMerge(/* obj1, obj2, obj3, ... */) {
  var result = {};
  function assignValue(val, key) {
    if (typeof result[key] === 'object' && typeof val === 'object') {
      result[key] = deepMerge(result[key], val);
    } else if (typeof val === 'object') {
      result[key] = deepMerge({}, val);
    } else {
      result[key] = val;
    }
  }

  for (var i = 0, l = arguments.length; i < l; i++) {
    forEach(arguments[i], assignValue);
  }
  return result;
}

/**
 * Extends object a by mutably adding to it the properties of object b.
 *
 * @param {Object} a The object to be extended
 * @param {Object} b The object to copy properties from
 * @param {Object} thisArg The object to bind function to
 * @return {Object} The resulting value of object a
 */
function extend(a, b, thisArg) {
  forEach(b, function assignValue(val, key) {
    if (thisArg && typeof val === 'function') {
      a[key] = bind(val, thisArg);
    } else {
      a[key] = val;
    }
  });
  return a;
}

module.exports = {
  isArray: isArray,
  isArrayBuffer: isArrayBuffer,
  isBuffer: isBuffer,
  isFormData: isFormData,
  isArrayBufferView: isArrayBufferView,
  isString: isString,
  isNumber: isNumber,
  isObject: isObject,
  isUndefined: isUndefined,
  isDate: isDate,
  isFile: isFile,
  isBlob: isBlob,
  isFunction: isFunction,
  isStream: isStream,
  isURLSearchParams: isURLSearchParams,
  isStandardBrowserEnv: isStandardBrowserEnv,
  forEach: forEach,
  merge: merge,
  deepMerge: deepMerge,
  extend: extend,
  trim: trim
};


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/App.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/App.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      Loading: false
    };
  },
  computed: _objectSpread(_objectSpread({}, (0,vuex__WEBPACK_IMPORTED_MODULE_0__.mapGetters)(["getThemeMode", "isAuthenticated"])), {}, {
    themeName: function themeName() {
      return this.getThemeMode.dark ? "dark-theme" : " ";
    },
    rtl: function rtl() {
      return this.getThemeMode.rtl ? "rtl" : " ";
    }
  }),
  metaInfo: function metaInfo() {
    return {
      // if no subcomponents specify a metaInfo.title, this title will be used
      title: "Dugeet Orbit",
      // all titles will be injected into this template
      titleTemplate: "%s | Application",
      bodyAttrs: {
        "class": [this.themeName, "text-left"]
      },
      htmlAttrs: {
        dir: this.rtl
      }
    };
  },
  methods: _objectSpread({}, (0,vuex__WEBPACK_IMPORTED_MODULE_0__.mapActions)(["refreshUserPermissions"])),
  beforeMount: function beforeMount() {
    var _this = this;
    // if(this.isAuthenticated){
    this.refreshUserPermissions();
    setTimeout(function () {
      return _this.Loading = true;
    }, 300);
    // }
    // else{
    //   setTimeout(() => this.Loading= true, 300);
    // }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/components/breadcumb.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/components/breadcumb.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ['page', 'folder']
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/App.vue?vue&type=template&id=ab9f5064":
/*!**********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/App.vue?vue&type=template&id=ab9f5064 ***!
  \**********************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render),
/* harmony export */   staticRenderFns: () => (/* binding */ staticRenderFns)
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _vm.Loading ? _c("div", [_c("router-view"), _vm._v(" "), _c("customizer")], 1) : _vm._e();
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/components/breadcumb.vue?vue&type=template&id=630e5b49":
/*!***************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/lib/loaders/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/src/components/breadcumb.vue?vue&type=template&id=630e5b49 ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render),
/* harmony export */   staticRenderFns: () => (/* binding */ staticRenderFns)
/* harmony export */ });
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c("div", [_c("div", {
    staticClass: "breadcrumb"
  }, [_vm._t("header", function () {
    return [_c("h1", [_vm._v(_vm._s(_vm.page))]), _vm._v(" "), _c("ul", [_c("li", [_c("a", {
      attrs: {
        href: ""
      }
    }, [_vm._v(" " + _vm._s(_vm.folder) + " ")])]), _vm._v(" "), _c("li", [_vm._v(" " + _vm._s(_vm.page) + " ")])])];
  })], 2), _vm._v(" "), _c("div", {
    staticClass: "separator-breadcrumb border-top"
  })]);
};
var staticRenderFns = [];
render._withStripped = true;


/***/ }),

/***/ "./resources/src/auth/IsConnected.js":
/*!*******************************************!*\
  !*** ./resources/src/auth/IsConnected.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vue_cookies__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-cookies */ "./node_modules/vue-cookies/vue-cookies.js");
/* harmony import */ var vue_cookies__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(vue_cookies__WEBPACK_IMPORTED_MODULE_0__);


vue__WEBPACK_IMPORTED_MODULE_1__["default"].use((vue_cookies__WEBPACK_IMPORTED_MODULE_0___default()));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (function (to, from, next) {
  var accessToken = vue_cookies__WEBPACK_IMPORTED_MODULE_0___default().isKey("Stocky_token");
  if (accessToken) {
    next("/app/dashboard");
  } else {
    return next();
  }
});

/***/ }),

/***/ "./resources/src/auth/authenticate.js":
/*!********************************************!*\
  !*** ./resources/src/auth/authenticate.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vue_cookies__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-cookies */ "./node_modules/vue-cookies/vue-cookies.js");
/* harmony import */ var vue_cookies__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(vue_cookies__WEBPACK_IMPORTED_MODULE_0__);


vue__WEBPACK_IMPORTED_MODULE_1__["default"].use((vue_cookies__WEBPACK_IMPORTED_MODULE_0___default()));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (function (to, from, next) {
  var accessToken = vue_cookies__WEBPACK_IMPORTED_MODULE_0___default().isKey("Stocky_token");
  if (!accessToken) {
    next("/app/sessions/signIn");
  } else {
    return next();
  }
});

/***/ }),

/***/ "./resources/src/auth/index.js":
/*!*************************************!*\
  !*** ./resources/src/auth/index.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Auth)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _store_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../store/index.js */ "./resources/src/store/index.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }


var Auth = /*#__PURE__*/function () {
  function Auth() {
    _classCallCheck(this, Auth);
  }
  _createClass(Auth, [{
    key: "login",
    value: function login(token) {
      _store_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].dispatch('setLoginCred', {
        token: token
      });
    }
  }, {
    key: "setAuthToken",
    value: function setAuthToken(token) {
      var tokenIsSet = (axios__WEBPACK_IMPORTED_MODULE_0___default().defaults).headers.common['Authorization'] = 'Bearer ' + token;
    }

    // checks for login status, returns boolean
  }, {
    key: "check",
    value: function check() {
      return !!_store_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].state.auth.token;
    }
  }]);
  return Auth;
}();


/***/ }),

/***/ "./resources/src/plugins/i18n.js":
/*!***************************************!*\
  !*** ./resources/src/plugins/i18n.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   i18n: () => (/* binding */ i18n)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vue_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue-i18n */ "./node_modules/vue-i18n/dist/vue-i18n.esm.js");
/* harmony import */ var _translations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../translations */ "./resources/src/translations/index.js");



vue__WEBPACK_IMPORTED_MODULE_1__["default"].use(vue_i18n__WEBPACK_IMPORTED_MODULE_2__["default"]);
var i18n = new vue_i18n__WEBPACK_IMPORTED_MODULE_2__["default"]({
  locale: 'en',
  fallbackLocale: 'en',
  messages: _translations__WEBPACK_IMPORTED_MODULE_0__["default"]
});

/***/ }),

/***/ "./resources/src/plugins/stocky.kit.js":
/*!*********************************************!*\
  !*** ./resources/src/plugins/stocky.kit.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var bootstrap_vue_dist_bootstrap_vue_esm__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! bootstrap-vue/dist/bootstrap-vue.esm */ "./node_modules/bootstrap-vue/dist/bootstrap-vue.esm.js");
/* harmony import */ var vue_good_table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vue-good-table */ "./node_modules/vue-good-table/dist/vue-good-table.esm.js");
/* harmony import */ var vue_meta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-meta */ "./node_modules/vue-meta/dist/vue-meta.esm.js");
/* harmony import */ var _assets_styles_sass_themes_lite_purple_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../assets/styles/sass/themes/lite-purple.scss */ "./resources/src/assets/styles/sass/themes/lite-purple.scss");
/* harmony import */ var _sweetalert2_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sweetalert2.js */ "./resources/src/plugins/sweetalert2.js");
/* harmony import */ var vue_html_to_paper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vue-html-to-paper */ "./node_modules/vue-html-to-paper/dist/index.js");






var options = {
  name: '_blank',
  specs: ['fullscreen=yes', 'titlebar=yes', 'scrollbars=yes'],
  styles: ['https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css', 'https://unpkg.com/kidlat-css/css/kidlat.css'],
  timeout: 1000,
  // default timeout before the print window appears
  autoClose: true,
  // if false, the window will not close after printing
  windowTitle: window.document.title // override the window title
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  install: function install(Vue) {
    Vue.use(bootstrap_vue_dist_bootstrap_vue_esm__WEBPACK_IMPORTED_MODULE_4__["default"]);
    Vue.component("large-sidebar",
    // The `import` function returns a Promise.
    function () {
      return __webpack_require__.e(/*! import() | largeSidebar */ "largeSidebar").then(__webpack_require__.bind(__webpack_require__, /*! ../containers/layouts/largeSidebar */ "./resources/src/containers/layouts/largeSidebar/index.vue"));
    });
    Vue.component("customizer",
    // The `import` function returns a Promise.
    function () {
      return __webpack_require__.e(/*! import() | customizer */ "customizer").then(__webpack_require__.bind(__webpack_require__, /*! ../components/common/customizer.vue */ "./resources/src/components/common/customizer.vue"));
    });
    Vue.component("vue-perfect-scrollbar", function () {
      return __webpack_require__.e(/*! import() | vue-perfect-scrollbar */ "vue-perfect-scrollbar").then(__webpack_require__.t.bind(__webpack_require__, /*! vue-perfect-scrollbar */ "./node_modules/vue-perfect-scrollbar/dist/index.js", 23));
    });
    Vue.use(vue_meta__WEBPACK_IMPORTED_MODULE_0__["default"], {
      keyName: "metaInfo",
      attribute: "data-vue-meta",
      ssrAttribute: "data-vue-meta-server-rendered",
      tagIDKeyName: "vmid",
      refreshOnceOnNavigation: true
    });
    Vue.use(vue_good_table__WEBPACK_IMPORTED_MODULE_5__["default"]);
    Vue.use(vue_html_to_paper__WEBPACK_IMPORTED_MODULE_3__["default"], options);
  }
});

/***/ }),

/***/ "./resources/src/plugins/sweetalert2.js":
/*!**********************************************!*\
  !*** ./resources/src/plugins/sweetalert2.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vue_sweetalert2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-sweetalert2 */ "./node_modules/vue-sweetalert2/dist/index.js");
/* harmony import */ var sweetalert2_dist_sweetalert2_min_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! sweetalert2/dist/sweetalert2.min.css */ "./node_modules/sweetalert2/dist/sweetalert2.min.css");
// main.js



// If you don't need the styles, do not connect

var options = {
  confirmButtonColor: '#41b882',
  cancelButtonColor: '#ff7674'
};
vue__WEBPACK_IMPORTED_MODULE_2__["default"].use(vue_sweetalert2__WEBPACK_IMPORTED_MODULE_0__["default"], options);

/***/ }),

/***/ "./resources/src/router.js":
/*!*********************************!*\
  !*** ./resources/src/router.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./store */ "./resources/src/store/index.js");
/* harmony import */ var vue_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! vue-router */ "./node_modules/vue-router/dist/vue-router.esm.js");
/* harmony import */ var _plugins_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plugins/i18n */ "./resources/src/plugins/i18n.js");
/* harmony import */ var _auth_authenticate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./auth/authenticate */ "./resources/src/auth/authenticate.js");
/* harmony import */ var _auth_IsConnected__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./auth/IsConnected */ "./resources/src/auth/IsConnected.js");
/* harmony import */ var nprogress__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! nprogress */ "./node_modules/nprogress/nprogress.js");
/* harmony import */ var nprogress__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(nprogress__WEBPACK_IMPORTED_MODULE_4__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }







vue__WEBPACK_IMPORTED_MODULE_5__["default"].use(vue_router__WEBPACK_IMPORTED_MODULE_6__["default"]);

// create new router

var routes = [{
  path: "/",
  component: function component() {
    return __webpack_require__.e(/*! import() */ "resources_src_views_app_index_vue").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app */ "./resources/src/views/app/index.vue"));
  },
  redirect: "/app/dashboard",
  children: [{
    path: "/app/dashboard",
    name: "dashboard",
    component: function component() {
      return __webpack_require__.e(/*! import() | dashboard */ "dashboard").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/dashboard/dashboard */ "./resources/src/views/app/dashboard/dashboard.vue"));
    }
  },
  //Products
  {
    path: "/app/products",
    component: function component() {
      return __webpack_require__.e(/*! import() | products */ "products").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products */ "./resources/src/views/app/pages/products/index.vue"));
    },
    redirect: "app/products/list",
    children: [{
      name: "index_products",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_products */ "index_products").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/index_products */ "./resources/src/views/app/pages/products/index_products.vue"));
      }
    }, {
      path: "store",
      name: "store_product",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_product */ "store_product").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/Add_product */ "./resources/src/views/app/pages/products/Add_product.vue"));
      }
    }, {
      path: "edit/:id",
      name: "edit_product",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_product */ "edit_product").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/Edit_product */ "./resources/src/views/app/pages/products/Edit_product.vue"));
      }
    }, {
      path: "detail/:id",
      name: "detail_product",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_product */ "detail_product").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/Detail_Product */ "./resources/src/views/app/pages/products/Detail_Product.vue"));
      }
    }, {
      path: "barcode",
      name: "barcode",
      component: function component() {
        return __webpack_require__.e(/*! import() | barcode */ "barcode").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/barcode */ "./resources/src/views/app/pages/products/barcode.vue"));
      }
    },
    // categories
    {
      name: "categories",
      path: "Categories",
      component: function component() {
        return __webpack_require__.e(/*! import() | Categories */ "Categories").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/categorie */ "./resources/src/views/app/pages/products/categorie.vue"));
      }
    },
    // brands
    {
      name: "brands",
      path: "Brands",
      component: function component() {
        return __webpack_require__.e(/*! import() | Brands */ "Brands").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/brands */ "./resources/src/views/app/pages/products/brands.vue"));
      }
    },
    // units
    {
      name: "units",
      path: "Units",
      component: function component() {
        return __webpack_require__.e(/*! import() | units */ "units").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/products/units */ "./resources/src/views/app/pages/products/units.vue"));
      }
    }]
  },
  //Adjustement
  {
    path: "/app/adjustments",
    component: function component() {
      return __webpack_require__.e(/*! import() | adjustments */ "adjustments").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/adjustment */ "./resources/src/views/app/pages/adjustment/index.vue"));
    },
    redirect: "/app/adjustments/list",
    children: [{
      name: "index_adjustment",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_adjustment */ "index_adjustment").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/adjustment/index_Adjustment */ "./resources/src/views/app/pages/adjustment/index_Adjustment.vue"));
      }
    }, {
      name: "store_adjustment",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_adjustment */ "store_adjustment").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/adjustment/Create_Adjustment */ "./resources/src/views/app/pages/adjustment/Create_Adjustment.vue"));
      }
    }, {
      name: "edit_adjustment",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_adjustment */ "edit_adjustment").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/adjustment/Edit_Adjustment */ "./resources/src/views/app/pages/adjustment/Edit_Adjustment.vue"));
      }
    }]
  },
  //Transfer
  {
    path: "/app/transfers",
    component: function component() {
      return __webpack_require__.e(/*! import() | transfers */ "transfers").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/transfers */ "./resources/src/views/app/pages/transfers/index.vue"));
    },
    redirect: "/app/transfers/list",
    children: [{
      name: "index_transfer",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_transfer */ "index_transfer").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/transfers/index_transfer */ "./resources/src/views/app/pages/transfers/index_transfer.vue"));
      }
    }, {
      name: "store_transfer",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_transfer */ "store_transfer").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/transfers/create_transfer */ "./resources/src/views/app/pages/transfers/create_transfer.vue"));
      }
    }, {
      name: "edit_transfer",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_transfer */ "edit_transfer").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/transfers/edit_transfer */ "./resources/src/views/app/pages/transfers/edit_transfer.vue"));
      }
    }]
  },
  //Expense
  {
    path: "/app/expenses",
    component: function component() {
      return __webpack_require__.e(/*! import() | expenses */ "expenses").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/expense */ "./resources/src/views/app/pages/expense/index.vue"));
    },
    redirect: "/app/expenses/list",
    children: [{
      name: "index_expense",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_expense */ "index_expense").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/expense/index_expense */ "./resources/src/views/app/pages/expense/index_expense.vue"));
      }
    }, {
      name: "store_expense",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_expense */ "store_expense").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/expense/create_expense */ "./resources/src/views/app/pages/expense/create_expense.vue"));
      }
    }, {
      name: "edit_expense",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_expense */ "edit_expense").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/expense/edit_expense */ "./resources/src/views/app/pages/expense/edit_expense.vue"));
      }
    }, {
      name: "expense_category",
      path: "category",
      component: function component() {
        return __webpack_require__.e(/*! import() | expense_category */ "expense_category").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/expense/category_expense */ "./resources/src/views/app/pages/expense/category_expense.vue"));
      }
    }]
  },
  //Quotation
  {
    path: "/app/quotations",
    component: function component() {
      return __webpack_require__.e(/*! import() | quotations */ "quotations").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/quotations */ "./resources/src/views/app/pages/quotations/index.vue"));
    },
    redirect: "/app/quotations/list",
    children: [{
      name: "index_quotation",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() */ "resources_src_views_app_pages_quotations_index_quotation_vue").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/quotations/index_quotation */ "./resources/src/views/app/pages/quotations/index_quotation.vue"));
      }
    }, {
      name: "store_quotation",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_quotation */ "store_quotation").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/quotations/create_quotation */ "./resources/src/views/app/pages/quotations/create_quotation.vue"));
      }
    }, {
      name: "edit_quotation",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_quotation */ "edit_quotation").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/quotations/edit_quotation */ "./resources/src/views/app/pages/quotations/edit_quotation.vue"));
      }
    }, {
      name: "detail_quotation",
      path: "detail/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_quotation */ "detail_quotation").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/quotations/detail_quotation */ "./resources/src/views/app/pages/quotations/detail_quotation.vue"));
      }
    }, {
      name: "change_to_sale",
      path: "create_sale/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | change_to_sale */ "change_to_sale").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/change_to_sale.vue */ "./resources/src/views/app/pages/sales/change_to_sale.vue"));
      }
    }]
  },
  //Purchase
  {
    path: "/app/purchases",
    component: function component() {
      return __webpack_require__.e(/*! import() | purchases */ "purchases").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchases */ "./resources/src/views/app/pages/purchases/index.vue"));
    },
    redirect: "/app/purchases/list",
    children: [{
      name: "index_purchases",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_purchases */ "index_purchases").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchases/index_purchase */ "./resources/src/views/app/pages/purchases/index_purchase.vue"));
      }
    }, {
      name: "store_purchase",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_purchase */ "store_purchase").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchases/create_purchase */ "./resources/src/views/app/pages/purchases/create_purchase.vue"));
      }
    }, {
      name: "edit_purchase",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_purchase */ "edit_purchase").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchases/edit_purchase */ "./resources/src/views/app/pages/purchases/edit_purchase.vue"));
      }
    }, {
      name: "purchase_return",
      path: "purchase_return/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | create_purchase_return */ "create_purchase_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchase_return/create_purchase_return */ "./resources/src/views/app/pages/purchase_return/create_purchase_return.vue"));
      }
    }, {
      name: "detail_purchase",
      path: "detail/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_purchase */ "detail_purchase").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchases/detail_purchase */ "./resources/src/views/app/pages/purchases/detail_purchase.vue"));
      }
    }]
  },
  //Sale
  {
    path: "/app/sales",
    component: function component() {
      return __webpack_require__.e(/*! import() | sales */ "sales").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales */ "./resources/src/views/app/pages/sales/index.vue"));
    },
    redirect: "/app/sales/list",
    children: [{
      name: "index_sales",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_sales */ "index_sales").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/index_sale */ "./resources/src/views/app/pages/sales/index_sale.vue"));
      }
    }, {
      name: "store_sale",
      path: "store",
      component: function component() {
        return __webpack_require__.e(/*! import() | store_sale */ "store_sale").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/create_sale */ "./resources/src/views/app/pages/sales/create_sale.vue"));
      }
    }, {
      name: "edit_sale",
      path: "edit/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_sale */ "edit_sale").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/edit_sale */ "./resources/src/views/app/pages/sales/edit_sale.vue"));
      }
    }, {
      name: "sale_return",
      path: "sale_return/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | create_sale_return */ "create_sale_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sale_return/create_sale_return */ "./resources/src/views/app/pages/sale_return/create_sale_return.vue"));
      }
    }, {
      name: "detail_sale",
      path: "detail/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_sale */ "detail_sale").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/detail_sale */ "./resources/src/views/app/pages/sales/detail_sale.vue"));
      }
    }, {
      name: "shipment",
      path: "shipment",
      component: function component() {
        return __webpack_require__.e(/*! import() | shipment */ "shipment").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sales/shipments */ "./resources/src/views/app/pages/sales/shipments.vue"));
      }
    }]
  },
  // Sales Return
  {
    path: "/app/sale_return",
    component: function component() {
      return __webpack_require__.e(/*! import() | sale_return */ "sale_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sale_return */ "./resources/src/views/app/pages/sale_return/index.vue"));
    },
    redirect: "/app/sale_return/list",
    children: [{
      name: "index_sale_return",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_sale_return */ "index_sale_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sale_return/index_sale_return */ "./resources/src/views/app/pages/sale_return/index_sale_return.vue"));
      }
    },
    // {
    //     name: "store_sale_return",
    //     path: "store",
    //     component: () =>
    //         import(
    //             /* webpackChunkName: "store_sale_return" */
    //             "./views/app/pages/sale_return/create_sale_return"
    //         )
    // },
    {
      name: "edit_sale_return",
      path: "edit/:id/:sale_id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_sale_return */ "edit_sale_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sale_return/edit_sale_return */ "./resources/src/views/app/pages/sale_return/edit_sale_return.vue"));
      }
    }, {
      name: "detail_sale_return",
      path: "detail/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_sale_return */ "detail_sale_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/sale_return/detail_sale_return */ "./resources/src/views/app/pages/sale_return/detail_sale_return.vue"));
      }
    }]
  },
  // purchase Return
  {
    path: "/app/purchase_return",
    component: function component() {
      return __webpack_require__.e(/*! import() | purchase_return */ "purchase_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchase_return */ "./resources/src/views/app/pages/purchase_return/index.vue"));
    },
    redirect: "/app/purchase_return/list",
    children: [{
      name: "index_purchase_return",
      path: "list",
      component: function component() {
        return __webpack_require__.e(/*! import() | index_purchase_return */ "index_purchase_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchase_return/index_purchase_return */ "./resources/src/views/app/pages/purchase_return/index_purchase_return.vue"));
      }
    },
    // {
    //     name: "store_purchase_return",
    //     path: "store",
    //     component: () =>
    //         import(
    //             /* webpackChunkName: "store_purchase_return" */
    //             "./views/app/pages/purchase_return/create_purchase_return"
    //         )
    // },
    {
      name: "edit_purchase_return",
      path: "edit/:id/:purchase_id",
      component: function component() {
        return __webpack_require__.e(/*! import() | edit_purchase_return */ "edit_purchase_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchase_return/edit_purchase_return */ "./resources/src/views/app/pages/purchase_return/edit_purchase_return.vue"));
      }
    }, {
      name: "detail_purchase_return",
      path: "detail/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_purchase_return */ "detail_purchase_return").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/purchase_return/detail_purchase_return */ "./resources/src/views/app/pages/purchase_return/detail_purchase_return.vue"));
      }
    }]
  },
  // Hrm
  {
    path: "/app/hrm",
    component: function component() {
      return __webpack_require__.e(/*! import() | hrm */ "hrm").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm */ "./resources/src/views/app/pages/hrm/index.vue"));
    },
    redirect: "/app/hrm/employees",
    children: [
    // employees
    {
      path: "employees",
      component: function component() {
        return __webpack_require__.e(/*! import() | employees */ "employees").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/employees */ "./resources/src/views/app/pages/hrm/employees/index.vue"));
      },
      redirect: "/app/hrm/employees/list",
      children: [{
        name: "employees_list",
        path: "list",
        component: function component() {
          return __webpack_require__.e(/*! import() | index_employee */ "index_employee").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/employees/index_employee */ "./resources/src/views/app/pages/hrm/employees/index_employee.vue"));
        }
      }, {
        name: "store_employee",
        path: "store",
        component: function component() {
          return __webpack_require__.e(/*! import() | store_employee */ "store_employee").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/employees/employee_create */ "./resources/src/views/app/pages/hrm/employees/employee_create.vue"));
        }
      }, {
        name: "edit_employee",
        path: "edit/:id",
        component: function component() {
          return __webpack_require__.e(/*! import() | edit_employee */ "edit_employee").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/employees/employee_edit */ "./resources/src/views/app/pages/hrm/employees/employee_edit.vue"));
        }
      }, {
        name: "detail_employee",
        path: "detail/:id",
        component: function component() {
          return __webpack_require__.e(/*! import() | detail_employee */ "detail_employee").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/employees/employee_details */ "./resources/src/views/app/pages/hrm/employees/employee_details.vue"));
        }
      }]
    },
    // company
    {
      name: "company",
      path: "company",
      component: function component() {
        return __webpack_require__.e(/*! import() | company */ "company").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/company */ "./resources/src/views/app/pages/hrm/company.vue"));
      }
    },
    // departments
    {
      name: "departments",
      path: "departments",
      component: function component() {
        return __webpack_require__.e(/*! import() | departments */ "departments").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/department */ "./resources/src/views/app/pages/hrm/department.vue"));
      }
    },
    // designations
    {
      name: "designations",
      path: "designations",
      component: function component() {
        return __webpack_require__.e(/*! import() | designations */ "designations").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/designation */ "./resources/src/views/app/pages/hrm/designation.vue"));
      }
    },
    // office_shift
    {
      name: "office_shift",
      path: "office_shift",
      component: function component() {
        return __webpack_require__.e(/*! import() | office_shift */ "office_shift").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/office_shift */ "./resources/src/views/app/pages/hrm/office_shift.vue"));
      }
    },
    // attendance
    {
      name: "attendance",
      path: "attendance",
      component: function component() {
        return __webpack_require__.e(/*! import() | attendance */ "attendance").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/attendance */ "./resources/src/views/app/pages/hrm/attendance.vue"));
      }
    },
    // holidays
    {
      name: "holidays",
      path: "holidays",
      component: function component() {
        return __webpack_require__.e(/*! import() | holidays */ "holidays").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/holidays */ "./resources/src/views/app/pages/hrm/holidays.vue"));
      }
    }, {
      path: "leaves",
      component: function component() {
        return __webpack_require__.e(/*! import() | leaves */ "leaves").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/leaves */ "./resources/src/views/app/pages/hrm/leaves/index.vue"));
      },
      redirect: "/app/hrm/leaves/list",
      children: [{
        name: "leave_list",
        path: "list",
        component: function component() {
          return __webpack_require__.e(/*! import() | leave_list */ "leave_list").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/leaves/leave_list */ "./resources/src/views/app/pages/hrm/leaves/leave_list.vue"));
        }
      }, {
        name: "leave_type",
        path: "type",
        component: function component() {
          return __webpack_require__.e(/*! import() | leave_type */ "leave_type").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/hrm/leaves/leave_type */ "./resources/src/views/app/pages/hrm/leaves/leave_type.vue"));
        }
      }]
    }]
  },
  // People
  {
    path: "/app/People",
    component: function component() {
      return __webpack_require__.e(/*! import() | People */ "People").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/people */ "./resources/src/views/app/pages/people/index.vue"));
    },
    redirect: "/app/People/Customers",
    children: [
    // Customers
    {
      name: "Customers",
      path: "Customers",
      component: function component() {
        return __webpack_require__.e(/*! import() | Customers */ "Customers").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/people/customers */ "./resources/src/views/app/pages/people/customers.vue"));
      }
    },
    // Suppliers
    {
      name: "Suppliers",
      path: "Suppliers",
      component: function component() {
        return __webpack_require__.e(/*! import() | Suppliers */ "Suppliers").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/people/providers */ "./resources/src/views/app/pages/people/providers.vue"));
      }
    },
    // Users
    {
      name: "user",
      path: "Users",
      component: function component() {
        return __webpack_require__.e(/*! import() | Users */ "Users").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/people/users */ "./resources/src/views/app/pages/people/users.vue"));
      }
    }]
  },
  // Settings
  {
    path: "/app/settings",
    component: function component() {
      return __webpack_require__.e(/*! import() | settings */ "settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings */ "./resources/src/views/app/pages/settings/index.vue"));
    },
    redirect: "/app/settings/System_settings",
    children: [
    // Permissions
    {
      path: "permissions",
      component: function component() {
        return __webpack_require__.e(/*! import() | permissions */ "permissions").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/permissions */ "./resources/src/views/app/pages/settings/permissions/index.vue"));
      },
      redirect: "/app/settings/permissions/list",
      children: [{
        name: "groupPermission",
        path: "list",
        component: function component() {
          return __webpack_require__.e(/*! import() | groupPermission */ "groupPermission").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/permissions/Permissions */ "./resources/src/views/app/pages/settings/permissions/Permissions.vue"));
        }
      }, {
        name: "store_permission",
        path: "store",
        component: function component() {
          return __webpack_require__.e(/*! import() | store_permission */ "store_permission").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/permissions/Create_permission */ "./resources/src/views/app/pages/settings/permissions/Create_permission.vue"));
        }
      }, {
        name: "edit_permission",
        path: "edit/:id",
        component: function component() {
          return __webpack_require__.e(/*! import() | edit_permission */ "edit_permission").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/permissions/Edit_permission */ "./resources/src/views/app/pages/settings/permissions/Edit_permission.vue"));
        }
      }]
    },
    // sms_settings
    {
      name: "sms_settings",
      path: "sms_settings",
      component: function component() {
        return __webpack_require__.e(/*! import() | sms_settings */ "sms_settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/sms_settings */ "./resources/src/views/app/pages/settings/sms_settings.vue"));
      }
    },
    // sms_templates
    {
      name: "sms_templates",
      path: "sms_templates",
      component: function component() {
        return __webpack_require__.e(/*! import() | sms_templates */ "sms_templates").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/sms_templates */ "./resources/src/views/app/pages/settings/sms_templates.vue"));
      }
    },
    // email_templates
    {
      name: "email_templates",
      path: "email_templates",
      component: function component() {
        return __webpack_require__.e(/*! import() | email_templates */ "email_templates").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/email_templates */ "./resources/src/views/app/pages/settings/email_templates.vue"));
      }
    },
    // pos_settings
    {
      name: "pos_settings",
      path: "pos_settings",
      component: function component() {
        return __webpack_require__.e(/*! import() | pos_settings */ "pos_settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/pos_settings */ "./resources/src/views/app/pages/settings/pos_settings.vue"));
      }
    },
    // payment_gateway
    {
      name: "payment_gateway",
      path: "payment_gateway",
      component: function component() {
        return __webpack_require__.e(/*! import() | payment_gateway */ "payment_gateway").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/payment_gateway */ "./resources/src/views/app/pages/settings/payment_gateway.vue"));
      }
    },
    // mail_settings
    {
      name: "mail_settings",
      path: "mail_settings",
      component: function component() {
        return __webpack_require__.e(/*! import() | mail_settings */ "mail_settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/mail_settings */ "./resources/src/views/app/pages/settings/mail_settings.vue"));
      }
    },
    // update_settings
    {
      name: "update_settings",
      path: "update_settings",
      component: function component() {
        return __webpack_require__.e(/*! import() | update_settings */ "update_settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/update_settings */ "./resources/src/views/app/pages/settings/update_settings.vue"));
      }
    },
    // currencies
    {
      name: "currencies",
      path: "Currencies",
      component: function component() {
        return __webpack_require__.e(/*! import() | Currencies */ "Currencies").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/currencies */ "./resources/src/views/app/pages/settings/currencies.vue"));
      }
    },
    // Backup
    {
      name: "Backup",
      path: "Backup",
      component: function component() {
        return __webpack_require__.e(/*! import() | Backup */ "Backup").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/backup */ "./resources/src/views/app/pages/settings/backup.vue"));
      }
    },
    // Warehouses
    {
      name: "Warehouses",
      path: "Warehouses",
      component: function component() {
        return __webpack_require__.e(/*! import() | Warehouses */ "Warehouses").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/warehouses */ "./resources/src/views/app/pages/settings/warehouses.vue"));
      }
    },
    // System Settings
    {
      name: "system_settings",
      path: "System_settings",
      component: function component() {
        return __webpack_require__.e(/*! import() | System_settings */ "System_settings").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/settings/system_settings */ "./resources/src/views/app/pages/settings/system_settings.vue"));
      }
    }]
  },
  // Reports
  {
    path: "/app/reports",
    component: function component() {
      return __webpack_require__.e(/*! import() */ "resources_src_views_app_pages_reports_index_vue").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports */ "./resources/src/views/app/pages/reports/index.vue"));
    },
    redirect: "/app/reports/profit_and_loss",
    children: [{
      name: "payments_purchases",
      path: "payments_purchase",
      component: function component() {
        return __webpack_require__.e(/*! import() | payments_purchases */ "payments_purchases").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/payments/payments_purchases */ "./resources/src/views/app/pages/reports/payments/payments_purchases.vue"));
      }
    }, {
      name: "payments_sales",
      path: "payments_sale",
      component: function component() {
        return __webpack_require__.e(/*! import() | payments_sales */ "payments_sales").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/payments/payments_sales */ "./resources/src/views/app/pages/reports/payments/payments_sales.vue"));
      }
    }, {
      name: "payments_purchases_returns",
      path: "payments_purchases_returns",
      component: function component() {
        return __webpack_require__.e(/*! import() | payments_purchases_returns */ "payments_purchases_returns").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/payments/payments_purchases_returns */ "./resources/src/views/app/pages/reports/payments/payments_purchases_returns.vue"));
      }
    }, {
      name: "payments_sales_returns",
      path: "payments_sales_returns",
      component: function component() {
        return __webpack_require__.e(/*! import() | payments_sales_returns */ "payments_sales_returns").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/payments/payments_sales_returns */ "./resources/src/views/app/pages/reports/payments/payments_sales_returns.vue"));
      }
    }, {
      name: "profit_and_loss",
      path: "profit_and_loss",
      component: function component() {
        return __webpack_require__.e(/*! import() | profit_and_loss */ "profit_and_loss").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/profit_and_loss */ "./resources/src/views/app/pages/reports/profit_and_loss.vue"));
      }
    }, {
      name: "quantity_alerts",
      path: "quantity_alerts",
      component: function component() {
        return __webpack_require__.e(/*! import() | quantity_alerts */ "quantity_alerts").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/quantity_alerts */ "./resources/src/views/app/pages/reports/quantity_alerts.vue"));
      }
    }, {
      name: "warehouse_report",
      path: "warehouse_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | warehouse_report */ "warehouse_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/warehouse_report */ "./resources/src/views/app/pages/reports/warehouse_report.vue"));
      }
    }, {
      name: "sales_report",
      path: "sales_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | sales_report */ "sales_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/sales_report */ "./resources/src/views/app/pages/reports/sales_report.vue"));
      }
    }, {
      name: "product_sales_report",
      path: "product_sales_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | product_sales_report */ "product_sales_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/product_sales_report */ "./resources/src/views/app/pages/reports/product_sales_report.vue"));
      }
    }, {
      name: "purchase_report",
      path: "purchase_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | purchase_report */ "purchase_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/purchase_report */ "./resources/src/views/app/pages/reports/purchase_report.vue"));
      }
    }, {
      name: "product_purchases_report",
      path: "product_purchases_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | product_purchases_report */ "product_purchases_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/product_purchases_report */ "./resources/src/views/app/pages/reports/product_purchases_report.vue"));
      }
    }, {
      name: "customers_report",
      path: "customers_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | customers_report */ "customers_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/customers_report */ "./resources/src/views/app/pages/reports/customers_report.vue"));
      }
    }, {
      name: "detail_customer_report",
      path: "detail_customer/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_customer_report */ "detail_customer_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/detail_Customer_Report */ "./resources/src/views/app/pages/reports/detail_Customer_Report.vue"));
      }
    }, {
      name: "providers_report",
      path: "providers_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | providers_report */ "providers_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/providers_report */ "./resources/src/views/app/pages/reports/providers_report.vue"));
      }
    }, {
      name: "detail_supplier_report",
      path: "detail_supplier/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_supplier_report */ "detail_supplier_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/detail_Supplier_Report */ "./resources/src/views/app/pages/reports/detail_Supplier_Report.vue"));
      }
    }, {
      name: "top_selling_products",
      path: "top_selling_products",
      component: function component() {
        return __webpack_require__.e(/*! import() | top_selling_products */ "top_selling_products").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/top_selling_products */ "./resources/src/views/app/pages/reports/top_selling_products.vue"));
      }
    }, {
      name: "product_report",
      path: "product_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | product_report */ "product_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/product_report */ "./resources/src/views/app/pages/reports/product_report.vue"));
      }
    }, {
      name: "detail_product_report",
      path: "detail_product/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_product_report */ "detail_product_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/detail_product_report */ "./resources/src/views/app/pages/reports/detail_product_report.vue"));
      }
    }, {
      name: "top_customers",
      path: "top_customers",
      component: function component() {
        return __webpack_require__.e(/*! import() | top_customers */ "top_customers").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/top_customers */ "./resources/src/views/app/pages/reports/top_customers.vue"));
      }
    }, {
      name: "stock_report",
      path: "stock_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | stock_report */ "stock_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/stock_report */ "./resources/src/views/app/pages/reports/stock_report.vue"));
      }
    }, {
      name: "detail_stock_report",
      path: "detail_stock/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_stock_report */ "detail_stock_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/detail_stock_report */ "./resources/src/views/app/pages/reports/detail_stock_report.vue"));
      }
    }, {
      name: "users_report",
      path: "users_report",
      component: function component() {
        return __webpack_require__.e(/*! import() | users_report */ "users_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/users_report */ "./resources/src/views/app/pages/reports/users_report.vue"));
      }
    }, {
      name: "detail_user_report",
      path: "detail_user/:id",
      component: function component() {
        return __webpack_require__.e(/*! import() | detail_user_report */ "detail_user_report").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/reports/detail_user_report */ "./resources/src/views/app/pages/reports/detail_user_report.vue"));
      }
    }]
  }, {
    name: "profile",
    path: "/app/profile",
    component: function component() {
      return __webpack_require__.e(/*! import() | profile */ "profile").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/profile */ "./resources/src/views/app/pages/profile.vue"));
    }
  }]
}, {
  name: "pos",
  path: "/app/pos",
  // beforeEnter: authenticate,
  component: function component() {
    return __webpack_require__.e(/*! import() | pos */ "pos").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/pos */ "./resources/src/views/app/pages/pos.vue"));
  }
}, {
  path: "*",
  name: "NotFound",
  component: function component() {
    return __webpack_require__.e(/*! import() | NotFound */ "NotFound").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/notFound */ "./resources/src/views/app/pages/notFound.vue"));
  }
}, {
  path: "not_authorize",
  name: "not_authorize",
  component: function component() {
    return __webpack_require__.e(/*! import() | not_authorize */ "not_authorize").then(__webpack_require__.bind(__webpack_require__, /*! ./views/app/pages/NotAuthorize */ "./resources/src/views/app/pages/NotAuthorize.vue"));
  }
}];
var router = new vue_router__WEBPACK_IMPORTED_MODULE_6__["default"]({
  mode: "history",
  linkActiveClass: "open",
  routes: routes,
  scrollBehavior: function scrollBehavior(to, from, savedPosition) {
    return {
      x: 0,
      y: 0
    };
  }
});
var originalPush = vue_router__WEBPACK_IMPORTED_MODULE_6__["default"].prototype.push;
vue_router__WEBPACK_IMPORTED_MODULE_6__["default"].prototype.push = function push(location, onResolve, onReject) {
  if (onResolve || onReject) return originalPush.call(this, location, onResolve, onReject);
  return originalPush.call(this, location)["catch"](function (err) {
    return err;
  });
};
router.beforeEach(function (to, from, next) {
  // If this isn't an initial page load.
  if (to.path) {
    // Start the route progress bar.
    nprogress__WEBPACK_IMPORTED_MODULE_4___default().start();
    nprogress__WEBPACK_IMPORTED_MODULE_4___default().set(0.1);
  }
  next();
  if (_store__WEBPACK_IMPORTED_MODULE_0__["default"].state.language.language && _store__WEBPACK_IMPORTED_MODULE_0__["default"].state.language.language !== _plugins_i18n__WEBPACK_IMPORTED_MODULE_1__.i18n.locale) {
    _plugins_i18n__WEBPACK_IMPORTED_MODULE_1__.i18n.locale = _store__WEBPACK_IMPORTED_MODULE_0__["default"].state.language.language;
    next();
  } else if (!_store__WEBPACK_IMPORTED_MODULE_0__["default"].state.language.language) {
    _store__WEBPACK_IMPORTED_MODULE_0__["default"].dispatch("language/setLanguage", navigator.languages).then(function () {
      _plugins_i18n__WEBPACK_IMPORTED_MODULE_1__.i18n.locale = _store__WEBPACK_IMPORTED_MODULE_0__["default"].state.language.language;
      next();
    });
  } else {
    next();
  }
});
router.afterEach(function () {
  // Remove initial loading
  var gullPreLoading = document.getElementById("loading_wrap");
  if (gullPreLoading) {
    gullPreLoading.style.display = "none";
  }
  // Complete the animation of the route progress bar.
  setTimeout(function () {
    return nprogress__WEBPACK_IMPORTED_MODULE_4___default().done();
  }, 500);
  // NProgress.done();

  if (window.innerWidth <= 1200) {
    _store__WEBPACK_IMPORTED_MODULE_0__["default"].dispatch("changeSidebarProperties");
    if (_store__WEBPACK_IMPORTED_MODULE_0__["default"].getters.getSideBarToggleProperties.isSecondarySideNavOpen) {
      _store__WEBPACK_IMPORTED_MODULE_0__["default"].dispatch("changeSecondarySidebarProperties");
    }
    if (_store__WEBPACK_IMPORTED_MODULE_0__["default"].getters.getCompactSideBarToggleProperties.isSideNavOpen) {
      _store__WEBPACK_IMPORTED_MODULE_0__["default"].dispatch("changeCompactSidebarProperties");
    }
  } else {
    if (_store__WEBPACK_IMPORTED_MODULE_0__["default"].getters.getSideBarToggleProperties.isSecondarySideNavOpen) {
      _store__WEBPACK_IMPORTED_MODULE_0__["default"].dispatch("changeSecondarySidebarProperties");
    }
  }
});
function Check_Token(_x, _x2, _x3) {
  return _Check_Token.apply(this, arguments);
}
function _Check_Token() {
  _Check_Token = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(to, from, next) {
    var token, res;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          token = to.params.token;
          _context.next = 3;
          return axios.get("password/find/" + token).then(function (response) {
            return response.data;
          });
        case 3:
          res = _context.sent;
          if (res.success) {
            _context.next = 8;
            break;
          }
          next("/app/sessions/signIn");
          _context.next = 9;
          break;
        case 8:
          return _context.abrupt("return", next());
        case 9:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return _Check_Token.apply(this, arguments);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (router);

/***/ }),

/***/ "./resources/src/store/index.js":
/*!**************************************!*\
  !*** ./resources/src/store/index.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _modules_largeSidebar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modules/largeSidebar */ "./resources/src/store/modules/largeSidebar.js");
/* harmony import */ var _modules_compactSidebar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modules/compactSidebar */ "./resources/src/store/modules/compactSidebar.js");
/* harmony import */ var _modules_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modules/config */ "./resources/src/store/modules/config.js");
/* harmony import */ var _modules_auth__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modules/auth */ "./resources/src/store/modules/auth.js");
/* harmony import */ var _modules_language__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modules/language */ "./resources/src/store/modules/language.js");







// Load Vuex
vue__WEBPACK_IMPORTED_MODULE_5__["default"].use(vuex__WEBPACK_IMPORTED_MODULE_6__["default"]);

// Create store
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new vuex__WEBPACK_IMPORTED_MODULE_6__["default"].Store({
  modules: {
    language: _modules_language__WEBPACK_IMPORTED_MODULE_4__["default"],
    auth: _modules_auth__WEBPACK_IMPORTED_MODULE_3__["default"],
    largeSidebar: _modules_largeSidebar__WEBPACK_IMPORTED_MODULE_0__["default"],
    compactSidebar: _modules_compactSidebar__WEBPACK_IMPORTED_MODULE_1__["default"],
    config: _modules_config__WEBPACK_IMPORTED_MODULE_2__["default"]
  }
}));

/***/ }),

/***/ "./resources/src/store/modules/auth.js":
/*!*********************************************!*\
  !*** ./resources/src/store/modules/auth.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../../router */ "./resources/src/router.js");
/* harmony import */ var _store_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../store/index.js */ "./resources/src/store/index.js");
/* harmony import */ var _plugins_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../plugins/i18n */ "./resources/src/plugins/i18n.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }






vue__WEBPACK_IMPORTED_MODULE_4__["default"].use(vuex__WEBPACK_IMPORTED_MODULE_5__["default"]);
var state = {
  isAuthenticated: false,
  Permissions: null,
  user: {},
  loading: false,
  error: null,
  notifs: 0,
  Default_Language: 'en'
};
var getters = {
  isAuthenticated: function isAuthenticated(state) {
    return state.isAuthenticated;
  },
  currentUser: function currentUser(state) {
    return state.user;
  },
  currentUserPermissions: function currentUserPermissions(state) {
    return state.Permissions;
  },
  loading: function loading(state) {
    return state.loading;
  },
  notifs_alert: function notifs_alert(state) {
    return state.notifs;
  },
  DefaultLanguage: function DefaultLanguage(state) {
    return state.Default_Language;
  },
  error: function error(state) {
    return state.error;
  }
};
var mutations = {
  setLoading: function setLoading(state, data) {
    state.loading = data;
    state.error = null;
  },
  setError: function setError(state, data) {
    state.error = data;
    state.loggedInUser = null;
    state.loading = false;
  },
  clearError: function clearError(state) {
    state.error = null;
  },
  setPermissions: function setPermissions(state, Permissions) {
    state.Permissions = Permissions;
  },
  setUser: function setUser(state, user) {
    state.user = user;
  },
  SetDefaultLanguage: function SetDefaultLanguage(state, Language) {
    _plugins_i18n__WEBPACK_IMPORTED_MODULE_3__.i18n.locale = Language;
    _store_index_js__WEBPACK_IMPORTED_MODULE_2__["default"].dispatch("language/setLanguage", Language);
    state.Default_Language = Language;
  },
  Notifs_alert: function Notifs_alert(state, notifs) {
    state.notifs = notifs;
  },
  logout: function logout(state) {
    state.user = null;
    state.Permissions = null;
    state.loggedInUser = null;
    state.loading = false;
    state.error = null;
  }
};
var actions = {
  refreshUserPermissions: function refreshUserPermissions(context) {
    return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return axios__WEBPACK_IMPORTED_MODULE_0___default().get("get_user_auth").then(function (userAuth) {
              var Permissions = userAuth.data.permissions;
              var user = userAuth.data.user;
              var notifs = userAuth.data.notifs;
              var default_language = userAuth.data.user.default_language;
              context.commit('setPermissions', Permissions);
              context.commit('setUser', user);
              context.commit('Notifs_alert', notifs);
              context.commit('SetDefaultLanguage', default_language);
            })["catch"](function () {
              context.commit('setPermissions', null);
              context.commit('setallmodules', null);
              context.commit('setUser', null);
              context.commit('Notifs_alert', null);
              context.commit('SetDefaultLanguage', 'en');
            });
          case 2:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))();
  },
  logout: function logout(_ref) {
    var commit = _ref.commit;
    axios__WEBPACK_IMPORTED_MODULE_0___default()({
      method: 'post',
      url: '/logout',
      baseURL: ''
    }).then(function (userData) {
      window.location.href = '/login';
    });
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  state: state,
  getters: getters,
  actions: actions,
  mutations: mutations
});

/***/ }),

/***/ "./resources/src/store/modules/compactSidebar.js":
/*!*******************************************************!*\
  !*** ./resources/src/store/modules/compactSidebar.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var state = {
  compactSidebarToggleProperties: {
    isSideNavOpen: true,
    isActiveSecondarySideNav: false
  },
  compactLeftSideBarBgColor: "sidebar-dark-purple"
};
var getters = {
  getCompactSideBarToggleProperties: function getCompactSideBarToggleProperties(state) {
    return state.compactSidebarToggleProperties;
  },
  getcompactLeftSideBarBgColor: function getcompactLeftSideBarBgColor(state) {
    return state.compactLeftSideBarBgColor;
  }
};
var actions = {
  changeCompactSidebarProperties: function changeCompactSidebarProperties(_ref) {
    var commit = _ref.commit;
    commit("toggleCompactSidebarProperties");
  },
  changecompactLeftSideBarBgColor: function changecompactLeftSideBarBgColor(_ref2, data) {
    var commit = _ref2.commit;
    commit("togglecompactLeftSideBarBgColor", data);
  }
};
var mutations = {
  toggleCompactSidebarProperties: function toggleCompactSidebarProperties(state) {
    return state.compactSidebarToggleProperties.isSideNavOpen = !state.compactSidebarToggleProperties.isSideNavOpen;
  },
  togglecompactLeftSideBarBgColor: function togglecompactLeftSideBarBgColor(state, data) {
    state.compactLeftSideBarBgColor = data;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  state: state,
  getters: getters,
  actions: actions,
  mutations: mutations
});

/***/ }),

/***/ "./resources/src/store/modules/config.js":
/*!***********************************************!*\
  !*** ./resources/src/store/modules/config.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var state = {
  themeMode: {
    dark: false,
    light: true,
    semi_dark: false,
    theme_color: 'lite-purple',
    layout: 'large-sidebar',
    rtl: false
  }
};
var getters = {
  getThemeMode: function getThemeMode(state) {
    return state.themeMode;
  }
};
var actions = {
  changeThemeMode: function changeThemeMode(_ref) {
    var commit = _ref.commit;
    commit('toggleThemeMode');
  },
  changeThemeLayout: function changeThemeLayout(_ref2, data) {
    var commit = _ref2.commit;
    commit('toggleThemeLayout', data);
  },
  changeThemeRtl: function changeThemeRtl(_ref3) {
    var commit = _ref3.commit;
    commit('toggleThemeRtl');
  }
};
var mutations = {
  toggleThemeMode: function toggleThemeMode(state) {
    state.themeMode.dark = !state.themeMode.dark;
  },
  toggleThemeLayout: function toggleThemeLayout(state, data) {
    state.themeMode.layout = data;
  },
  toggleThemeRtl: function toggleThemeRtl(state) {
    state.themeMode.rtl = !state.themeMode.rtl;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  state: state,
  getters: getters,
  actions: actions,
  mutations: mutations
});

/***/ }),

/***/ "./resources/src/store/modules/language.js":
/*!*************************************************!*\
  !*** ./resources/src/store/modules/language.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vue_localstorage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-localstorage */ "./node_modules/vue-localstorage/dist/vue-local-storage.js");
/* harmony import */ var vue_localstorage__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(vue_localstorage__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _translations__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../translations */ "./resources/src/translations/index.js");



vue__WEBPACK_IMPORTED_MODULE_2__["default"].use((vue_localstorage__WEBPACK_IMPORTED_MODULE_0___default()));
var supportedLanguages = Object.getOwnPropertyNames(_translations__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  namespaced: true,
  state: {
    language: vue__WEBPACK_IMPORTED_MODULE_2__["default"].localStorage.get('language')
  },
  mutations: {
    SET_LANGUAGE: function SET_LANGUAGE(state, lang) {
      vue__WEBPACK_IMPORTED_MODULE_2__["default"].localStorage.set('language', lang);
      state.language = lang;
    }
  },
  actions: {
    setLanguage: function setLanguage(_ref, languages) {
      var commit = _ref.commit;
      if (typeof languages === 'string') {
        commit('SET_LANGUAGE', languages);
      } else {
        var language = supportedLanguages.find(function (sl) {
          return languages.find(function (l) {
            return l.split(new RegExp(sl, 'gi')).length - 1 > 0 ? sl : null;
          });
        });
        commit('SET_LANGUAGE', language);
      }
    }
  }
});

/***/ }),

/***/ "./resources/src/store/modules/largeSidebar.js":
/*!*****************************************************!*\
  !*** ./resources/src/store/modules/largeSidebar.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var state = {
  sidebarToggleProperties: {
    isSideNavOpen: true,
    isSecondarySideNavOpen: false,
    isActiveSecondarySideNav: false
  }
};
var getters = {
  getSideBarToggleProperties: function getSideBarToggleProperties(state) {
    return state.sidebarToggleProperties;
  }
};
var actions = {
  changeSidebarProperties: function changeSidebarProperties(_ref) {
    var commit = _ref.commit;
    commit("toggleSidebarProperties");
  },
  changeSecondarySidebarProperties: function changeSecondarySidebarProperties(_ref2) {
    var commit = _ref2.commit;
    commit("toggleSecondarySidebarProperties");
  },
  changeSecondarySidebarPropertiesViaMenuItem: function changeSecondarySidebarPropertiesViaMenuItem(_ref3, data) {
    var commit = _ref3.commit;
    commit("toggleSecondarySidebarPropertiesViaMenuItem", data);
  },
  changeSecondarySidebarPropertiesViaOverlay: function changeSecondarySidebarPropertiesViaOverlay(_ref4) {
    var commit = _ref4.commit;
    commit("toggleSecondarySidebarPropertiesViaOverlay");
  }
};
var mutations = {
  toggleSidebarProperties: function toggleSidebarProperties(state) {
    return state.sidebarToggleProperties.isSideNavOpen = !state.sidebarToggleProperties.isSideNavOpen;
  },
  toggleSecondarySidebarProperties: function toggleSecondarySidebarProperties(state) {
    return state.sidebarToggleProperties.isSecondarySideNavOpen = !state.sidebarToggleProperties.isSecondarySideNavOpen;
  },
  toggleSecondarySidebarPropertiesViaMenuItem: function toggleSecondarySidebarPropertiesViaMenuItem(state, data) {
    state.sidebarToggleProperties.isSecondarySideNavOpen = data;
    state.sidebarToggleProperties.isActiveSecondarySideNav = data;
  },
  toggleSecondarySidebarPropertiesViaOverlay: function toggleSecondarySidebarPropertiesViaOverlay(state) {
    state.sidebarToggleProperties.isSecondarySideNavOpen = !state.sidebarToggleProperties.isSecondarySideNavOpen;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  state: state,
  getters: getters,
  actions: actions,
  mutations: mutations
});

/***/ }),

/***/ "./resources/src/translations/index.js":
/*!*********************************************!*\
  !*** ./resources/src/translations/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _locales_en__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./locales/en */ "./resources/src/translations/locales/en.js");
/* harmony import */ var _locales_fr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./locales/fr */ "./resources/src/translations/locales/fr.js");
/* harmony import */ var _locales_ar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./locales/ar */ "./resources/src/translations/locales/ar.js");
/* harmony import */ var _locales_de__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./locales/de */ "./resources/src/translations/locales/de.js");
/* harmony import */ var _locales_es__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./locales/es */ "./resources/src/translations/locales/es.js");
/* harmony import */ var _locales_it__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./locales/it */ "./resources/src/translations/locales/it.js");
/* harmony import */ var _locales_Ind__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./locales/Ind */ "./resources/src/translations/locales/Ind.js");
/* harmony import */ var _locales_thai__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./locales/thai */ "./resources/src/translations/locales/thai.js");
/* harmony import */ var _locales_tr_ch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./locales/tr_ch */ "./resources/src/translations/locales/tr_ch.js");
/* harmony import */ var _locales_sm_ch__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./locales/sm_ch */ "./resources/src/translations/locales/sm_ch.js");
/* harmony import */ var _locales_tur__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./locales/tur */ "./resources/src/translations/locales/tur.js");
/* harmony import */ var _locales_ru__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./locales/ru */ "./resources/src/translations/locales/ru.js");
/* harmony import */ var _locales_hn__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./locales/hn */ "./resources/src/translations/locales/hn.js");
/* harmony import */ var _locales_vn__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./locales/vn */ "./resources/src/translations/locales/vn.js");
/* harmony import */ var _locales_kr__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./locales/kr */ "./resources/src/translations/locales/kr.js");
/* harmony import */ var _locales_ba__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./locales/ba */ "./resources/src/translations/locales/ba.js");
/* harmony import */ var _locales_br__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./locales/br */ "./resources/src/translations/locales/br.js");
/* harmony import */ var _locales_da__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./locales/da */ "./resources/src/translations/locales/da.js");


















/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  en: _locales_en__WEBPACK_IMPORTED_MODULE_0__["default"],
  fr: _locales_fr__WEBPACK_IMPORTED_MODULE_1__["default"],
  ar: _locales_ar__WEBPACK_IMPORTED_MODULE_2__["default"],
  de: _locales_de__WEBPACK_IMPORTED_MODULE_3__["default"],
  es: _locales_es__WEBPACK_IMPORTED_MODULE_4__["default"],
  it: _locales_it__WEBPACK_IMPORTED_MODULE_5__["default"],
  Ind: _locales_Ind__WEBPACK_IMPORTED_MODULE_6__["default"],
  thai: _locales_thai__WEBPACK_IMPORTED_MODULE_7__["default"],
  tr_ch: _locales_tr_ch__WEBPACK_IMPORTED_MODULE_8__["default"],
  sm_ch: _locales_sm_ch__WEBPACK_IMPORTED_MODULE_9__["default"],
  tur: _locales_tur__WEBPACK_IMPORTED_MODULE_10__["default"],
  ru: _locales_ru__WEBPACK_IMPORTED_MODULE_11__["default"],
  hn: _locales_hn__WEBPACK_IMPORTED_MODULE_12__["default"],
  vn: _locales_vn__WEBPACK_IMPORTED_MODULE_13__["default"],
  kr: _locales_kr__WEBPACK_IMPORTED_MODULE_14__["default"],
  ba: _locales_ba__WEBPACK_IMPORTED_MODULE_15__["default"],
  br: _locales_br__WEBPACK_IMPORTED_MODULE_16__["default"],
  da: _locales_da__WEBPACK_IMPORTED_MODULE_17__["default"]
});

/***/ }),

/***/ "./resources/src/translations/locales/Ind.js":
/*!***************************************************!*\
  !*** ./resources/src/translations/locales/Ind.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Indonesian

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Kuitansi',
  Pos_Settings: 'Pengaturan titik penjualan',
  Note_to_customer: 'Catatan untuk pelanggan',
  Show_Note_to_customer: 'Tunjukkan Catatan kepada pelanggan',
  Show_barcode: 'Tampilkan kode batang',
  Show_Tax_and_Discount: 'Tampilkan Pajak & Diskon & Pengiriman',
  Show_Customer: 'Tampilkan Pelanggan',
  Show_Email: 'Tampilkan Email',
  Show_Phone: 'Tampilkan Telepon',
  Show_Address: 'Tampilkan Alamat',
  DefaultLanguage: 'Bahasa Bawaan',
  footer: 'catatan kaki',
  Received_Amount: 'Jumlah yang Diterima',
  Paying_Amount: 'Membayar Jumlah',
  Change: 'Mengubah',
  Paying_amount_is_greater_than_Received_amount: 'Jumlah pembayaran lebih besar dari jumlah yang diterima',
  Paying_amount_is_greater_than_Grand_Total: 'Jumlah pembayaran lebih besar dari total keseluruhan',
  code_must_be_not_exist_already: 'kode harus belum ada',
  You_will_find_your_backup_on: 'Anda akan menemukan cadangan Anda di',
  and_save_it_to_your_pc: 'dan simpan ke pc Anda',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Pindai kode batang Anda dan pilih simbologi yang benar di bawah ini',
  Scan_Search_Product_by_Code_Name: 'Pindai/Cari Produk dengan Nama Kode',
  Paper_size: 'Ukuran kertas',
  Clear_Cache: 'Hapus Cache',
  Cache_cleared_successfully: 'Cache berhasil dibersihkan',
  Failed_to_clear_cache: 'Gagal menghapus cache',
  Scan_Barcode: 'Pemindai kode batang',
  Please_use_short_name_of_unit: 'Silakan gunakan nama pendek unit',
  DefaultCustomer: 'Pelanggan Default',
  DefaultWarehouse: 'Gudang Bawaan',
  Payment_Gateway: 'Payment Gateway',
  SMS_Configuration: 'Konfigurasi SMS',
  Gateway: 'Payment Gateway',
  Choose_Gateway: 'Pilih Payment Gateway',
  Send_SMS: 'Pesan berhasil dikirim',
  sms_config_invalid: 'konfigurasi sms salah tidak valid',
  Remove_Stripe_Key_Secret: 'Hapus kunci API Stripe',
  credit_card_account_not_available: 'Rekening kartu kredit tidak tersedia',
  Credit_Card_Info: 'Info Kartu Kredit',
  developed_by: 'Dikembangkan oleh',
  Unit_already_linked_with_sub_unit: 'Unit sudah terhubung dengan sub unit',
  Total_Items_Quantity: 'Total Item dan Kuantitas',
  Value_by_Cost_and_Price: 'Nilai berdasarkan Biaya dan Harga',
  Search_this_table: 'Cari tabel ini',
  import_products: 'Produk impor',
  Field_optional: 'Bidang opsional',
  Download_exemple: 'Unduh contoh',
  field_must_be_in_csv_format: 'Bidang harus dalam format csv',
  Successfully_Imported: 'Berhasil Diimpor',
  file_size_must_be_less_than_1_mega: 'Ukuran file harus kurang dari 1 mega',
  Please_follow_the_import_instructions: 'Harap ikuti petunjuk impor',
  must_be_exist: 'unit harus sudah dibuat',
  Import_Customers: 'Impor Pelanggan',
  Import_Suppliers: 'Pemasok Impor',
  Recent_Sales: 'Penjualan Terbaru',
  Create_Transfer: 'Buat Transfer',
  order_products: 'Item pesanan',
  Search_Product_by_Code_Name: 'Cari Produk dengan Kode atau Nama',
  Reports_payments_Purchase_Return: 'Melaporkan Pembayaran Pengembalian Pembelian',
  Reports_payments_Sale_Return: 'Laporan Pembayaran Retur Penjualan',
  payments_Sales_Return: 'Pembayaran retur penjualan',
  payments_Purchases_Return: 'Pembayaran pembelian kembali',
  CreateSaleReturn: 'Buat Retur Penjualan',
  EditSaleReturn: 'Edit Pengembalian Penjualan',
  SalesReturn: 'Retur Penjualan',
  CreatePurchaseReturn: 'Buat Pengembalian Pembelian',
  EditPurchaseReturn: 'Edit Pengembalian Pembelian',
  PurchasesReturn: 'Pembelian Kembali',
  Due: 'jatuh tempo',
  Profit: 'Keuntungan',
  Revenue: 'Pendapatan',
  Sales_today: 'Penjualan hari ini',
  People: 'Orang-orang',
  Successfully_Created: 'Berhasil Dibuat',
  Successfully_Updated: 'Berhasil diperbaharui',
  Success: 'sukses',
  Failed: 'Gagal',
  Warning: 'Peringatan',
  Please_fill_the_form_correctly: 'Harap isi formulir dengan benar',
  Field_is_required: 'Bidang wajib diisi',
  Error: 'Kesalahan!',
  you_are_not_authorized: 'Maaf! Anda tidak berwenang.',
  Go_back_to_home: 'Kembali ke beranda',
  page_not_exist: 'Maaf! Halaman yang Anda cari tidak ada.',
  Choose_Status: 'Pilih status',
  Choose_Method: 'Pilih Metode',
  Choose_Symbology: 'Pilih simbologi',
  Choose_Category: 'Pilih Kategori',
  Choose_Customer: 'Pilih Pelanggan',
  Choose_Supplier: 'Pilih Pemasok',
  Choose_Unit_Purchase: 'Pilih Unit Pembelian',
  Choose_Sub_Category: 'Pilih Subkategori',
  Choose_Brand: 'Pilih Merek',
  Choose_Warehouse: 'Pilih Gudang',
  Choose_Unit_Sale: 'Pilih Unit Penjualan',
  Enter_Product_Cost: 'Masukkan Biaya Produk',
  Enter_Stock_alert: 'Masuk ke Stock alert',
  Choose_Unit_Product: 'Pilih Unit Produk',
  Enter_Product_Price: 'Masukkan Harga Produk',
  Enter_Name_Product: 'Masukkan Nama Produk',
  Enter_Role_Name: 'Masukkan Nama Peran',
  Enter_Role_Description: 'Masukkan Deskripsi Peran',
  Enter_name_category: 'Masukkan Nama kategori',
  Enter_Code_category: 'Masukkan Kode kategori',
  Enter_Name_Brand: 'Masukkan Nama Merek',
  Enter_Description_Brand: 'Masukkan Deskripsi Merek',
  Enter_Code_Currency: 'Masukkan Mata Uang Kode',
  Enter_name_Currency: 'Masukkan nama Mata uang',
  Enter_Symbol_Currency: 'Masukkan Mata Uang Simbol',
  Enter_Name_Unit: 'Masukkan Nama Unit',
  Enter_ShortName_Unit: 'Masukkan Unit nama pendek',
  Choose_Base_Unit: 'Pilih Unit Dudukan',
  Choose_Operator: 'Pilih Operator',
  Enter_Operation_Value: 'Masukkan Nilai Operasi',
  Enter_Name_Warehouse: 'Masukkan Nama Gudang',
  Enter_Phone_Warehouse: 'Masukkan Telepon Gudang',
  Enter_Country_Warehouse: 'Masukkan Negara Gudang',
  Enter_City_Warehouse: 'Masuk kota gudang',
  Enter_Email_Warehouse: 'Masukkan email Gudang',
  Enter_ZipCode_Warehouse: 'Masukkan Kode Pos Gudang',
  Choose_Currency: 'Pilih mata uang',
  Thank_you_for_your_business: 'Terima kasih atas bisnis Anda!',
  Cancel: 'Membatalkan',
  New_Customer: 'Pelanggan baru',
  Incorrect_Login: 'Login Salah',
  Successfully_Logged_In: 'Berhasil Masuk',
  This_user_not_active: 'Pengguna ini tidak aktif',
  SignIn: 'Masuk',
  Create_an_account: 'Buat sebuah akun',
  Forgot_Password: 'Tidak ingat kata sandi ?',
  Email_Address: 'Alamat email',
  SignUp: 'Daftar',
  Already_have_an_account: 'Sudah memiliki akun ?',
  Reset_Password: 'Setel Ulang Kata Sandi',
  Failed_to_authenticate_on_SMTP_server: 'Gagal mengautentikasi di server SMTP',
  We_cant_find_a_user_with_that_email_addres: 'Kami tidak dapat menemukan pengguna dengan alamat email itu',
  We_have_emailed_your_password_reset_link: 'Kami telah mengirimkan email tautan pengaturan ulang kata sandi Anda',
  Please_fill_the_Email_Adress: 'Silahkan isi Alamat Email',
  Confirm_password: 'Setujui password',
  Your_Password_has_been_changed: 'Kata sandi Anda telah diubah',
  The_password_confirmation_does_not_match: 'Konfirmasi kata sandi tidak cocok',
  This_password_reset_token_is_invalid: 'Token penyetelan ulang sandi ini tidak valid',
  Warehouse_report: 'Laporan gudang',
  All_Warehouses: 'Semua Gudang',
  Expense_List: 'Daftar Biaya',
  Expenses: 'Beban',
  This_Week_Sales_Purchases: 'Penjualan & Pembelian Minggu Ini',
  Top_Selling_Products: 'Produk Terlaris',
  View_all: 'Lihat semua',
  Payment_Sent_Received: 'Pembayaran Dikirim & Diterima',
  Filter: 'Saring',
  Invoice_POS: 'POS Faktur',
  Invoice: 'Faktur',
  Customer_Info: 'Info Pelanggan',
  Company_Info: 'Info perusahaan',
  Invoice_Info: 'Info Faktur',
  Order_Summary: 'Ringkasan Pesanan',
  Quote_Info: 'Info Kutipan',
  Del: 'Menghapus',
  SuppliersPaiementsReport: 'Laporan Pembayaran Pemasok',
  Purchase_Info: 'Beli Info',
  Supplier_Info: 'Info Pemasok',
  Return_Info: 'info Kembali',
  Expense_Category: 'Kategori Biaya',
  Create_Expense: 'Buat Beban',
  Details: 'rincian',
  Discount_Method: 'Metode Diskon',
  Net_Unit_Cost: 'Biaya Satuan Net',
  Net_Unit_Price: 'Harga Satuan Bersih',
  Edit_Expense: 'Edit Biaya',
  All_Brand: 'Semua Merek',
  All_Category: 'Semua Kategori',
  ListExpenses: 'Daftar Biaya',
  Create_Permission: 'Buat Izin',
  Edit_Permission: 'Edit Izin',
  Reports_payments_Sales: 'Laporan pembayaran Penjualan',
  Reports_payments_Purchases: 'Melaporkan pembayaran Pembelian',
  Reports_payments_Return_Customers: 'Laporan pembayaran Retur Pelanggan',
  Reports_payments_Return_Suppliers: 'Laporan pembayaran Kembali Pemasok',
  Expense_Deleted: 'Pengeluaran ini telah dihapus',
  Expense_Updated: 'Biaya ini telah Diperbarui',
  Expense_Created: 'Pengeluaran Ini Telah Dibuat',
  DemoVersion: 'Anda tidak dapat melakukan ini di versi demo',
  OrderStatistics: 'Statistik Penjualan',
  AlreadyAdd: 'Produk Ini Sudah Ditambahkan !!',
  AddProductToList: 'Silakan Tambahkan Produk Ke Daftar !!',
  AddQuantity: 'Tambahkan jumlah Detail !!',
  InvalidData: 'Data Tidak Valid !!',
  LowStock: 'kuantitas melebihi kuantitas yang tersedia dalam stok',
  WarehouseIdentical: 'Kedua gudang itu tidak mungkin sama !!',
  VariantDuplicate: 'Varian Ini Duplikat !!',
  Filesize: 'Ukuran file',
  GenerateBackup: 'Hasilkan Cadangan',
  BackupDatabase: 'Database cadangan',
  Backup: 'Cadangan',
  Paid: 'Dibayar',
  Unpaid: 'Belum dibayar',
  Today: 'Hari ini',
  Income: 'Pendapatan'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'Beban'), "Sale", 'Penjualan'), "Actif", 'Aktif'), "Inactif", 'Tidak aktif'), "Customers", 'Pelanggan'), "Phone", 'Telepon'), "SearchByPhone", 'Cari lewat Telepon'), "Suppliers", 'Pemasok'), "Quotations", 'Kutipan'), "Sales", 'Penjualan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'Pembelian'), "Returns", 'Kembali'), "Settings", 'Pengaturan'), "SystemSettings", 'Pengaturan sistem'), "Users", 'Pengguna'), "GroupPermissions", 'Izin Grup'), "Currencies", 'Mata Uang'), "Warehouses", 'Gudang'), "Units", 'Unit'), "UnitsPrchases", ' Pembelian Unit'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Unit Penjualan'), "Reports", 'Laporan'), "PaymentsReport", 'Laporan Pembayaran'), "PaymentsPurchases", 'Pembelian Pembayaran'), "PaymentsSales", 'Pembayaran Penjualan'), "ProfitandLoss", 'Laba rugi'), "WarehouseStockChart", 'Grafik Stok Gudang'), "SalesReport", 'Laporan penjualan'), "PurchasesReport", 'Laporan Pembelian'), "CustomersReport", 'Laporan Pelanggan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Laporan Pemasok'), "SupplierReport", 'Laporan Pemasok'), "DailySalesData", 'Data Penjualan Harian'), "DailyPurchasesData", 'Data Pembelian Harian'), "Derni\xE8rescinqrecords", 'Lima rekor terakhir'), "Filters", 'Filter'), "date", 'tanggal'), "Reference", 'Referensi'), "Supplier", 'Pemasok'), "PaymentStatus", 'Status pembayaran'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", 'Pelanggan'), "CustomerCode", 'Kode pelanggan'), "Status", 'Status'), "SupplierCode", 'Kode penyuplai'), "Categorie", 'Kategori'), "Categories", 'Kategori'), "StockTransfers", 'Transfer Saham'), "StockManagement", 'Manajemen Stok'), "dashboard", 'Dasbor'), "Products", 'Produk'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'Daftar produk'), "ProductManagement", 'Manajemen Produk'), "ProductQuantityAlerts", 'Peringatan Kuantitas Produk'), "CodeProduct", 'Kode Produk'), "ProductTax", 'Pajak Produk'), "SubCategorie", 'Subkategori'), "Name_product", 'Penunjukan'), "StockAlert", 'Peringatan Stok'), "warehouse", 'gudang'), "Tax", 'Pajak'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Harga beli'), "SellPrice", 'Harga jual'), "Quantity", 'Kuantitas'), "UnitSale", 'Penjualan Unit'), "UnitPurchase", 'Pembelian Unit'), "ManagementCurrencies", 'Manajemen Mata Uang'), "CurrencyCode", 'Kode mata uang'), "CurrencyName", 'Nama Mata Uang'), "Symbol", 'Simbol'), "All", 'Semua'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Edit Produk'), "SearchByCode", 'Cari berdasarkan Kode'), "SearchByName", 'Cari berdasarkan nama'), "ProductDetails", 'Rincian Produk'), "CustomerName", 'Nama Pelanggan'), "CustomerManagement", 'Manajemen pelanggan'), "Add", 'Membuat'), "add", 'Membuat'), "Edit", 'Edit'), "Close", 'Menutup'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Silahkan pilih'), "Action", 'Tindakan'), "Email", 'Surel'), "EditCustomer", 'Edit Pelanggan'), "AddCustomer", 'Buat Pelanggan'), "Country", 'Negara'), "City", 'Kota'), "Adress", 'Alamat'), "CustomerDetails", 'detil pelanggan'), "CustomersList", 'Daftar Pelanggan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Kode penyuplai'), "SupplierName", 'nama pemasok'), "SuppliersManagement", 'Manajemen Pemasok'), "SupplierDetails", 'Detail Pemasok'), "QuotationsManagement", 'Manajemen Kutipan'), "SubTotal", 'Subtotal'), "MontantReste", 'Jumlah tersisa'), "complete", 'lengkap'), "EnAttendant", 'tertunda'), "Recu", 'Diterima'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", 'Sebagian'), "Retournee", 'Kembali'), "DetailQuote", 'Detail kutipan'), "EditQuote", 'Edit Kutipan'), "CreateSale", 'Buat Penjualan'), "DownloadPdf", 'Unduh PDF'), "QuoteEmail", 'Kutipan Terkirim di Email'), "DeleteQuote", 'Hapus Kutipan'), "AddQuote", 'Buat Kutipan'), "SelectProduct", 'Pilih Produk'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Produk (Kode - Nama)'), "Price", 'Harga'), "CurrentStock", 'persediaan'), "Total", 'Total'), "Num", 'N°'), "Unitcost", 'Biaya unit'), "to", 'ke'), "Subject", 'Subyek'), "Message", 'Pesan'), "EmailCustomer", 'Email Pelanggan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", 'Kirim'), "Quote", 'Kutipan'), "Hello", 'Halo'), "AttachmentQuote", 'Silakan temukan lampiran untuk Quotation Anda'), "AddProducts", 'Tambahkan Produk ke Daftar Pesanan'), "SelectWarehouse", 'Pilih gudang'), "SelectCustomer", 'silahkan Pilih Pelanggan'), "SalesManagement", 'Manajemen penjualan'), "Balance", 'Keseimbangan'), "QtyBack", 'Kuantitas Kembali'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Total Pengembalian'), "Amount", 'Jumlah'), "SaleDetail", 'Detail penjualan'), "EditSale", 'Edit Obral'), "AddSale", 'Buat Penjualan'), "ShowPayment", 'Tunjukkan Pembayaran'), "AddPayment", 'Buat Pembayaran'), "EditPayment", 'Edit Pembayaran'), "EmailSale", 'Kirim Obral melalui Email'), "DeleteSale", 'Hapus Obral'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Dibayar oleh'), "Paymentchoice", 'Pilihan pembayaran'), "Note", 'Catatan'), "PaymentComplete", 'Pembayaran selesai!'), "PurchasesManagement", 'Manajemen Pembelian'), "Ordered", 'Dipesan'), "DeletePurchase", 'Hapus Pembelian'), "EmailPurchase", 'Kirim Pembelian melalui Email'), "EditPurchase", 'Edit Pembelian'), "PurchaseDetail", 'Detail pembelian'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Buat Pembelian'), "EmailSupplier", 'Email Pemasok'), "PurchaseInvoice", 'Membeli pembayaran'), "PurchasesInvoicesData", 'Membeli data pembayaran'), "SalesInvoice", 'Pembayaran penjualan'), "SalesInvoicesData", 'Data pembayaran penjualan'), "UserManagement", 'manajemen pengguna'), "Firstname", 'Nama depan'), "lastname", 'nama keluarga'), "username", 'Nama pengguna'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", 'Kata sandi'), "Newpassword", 'Kata sandi baru'), "ChangeAvatar", 'Mengubah avatar'), "LeaveBlank", 'Harap kosongkan bidang ini jika Anda belum mengubahnya'), "type", 'Tipe'), "UserPermissions", 'Izin Pengguna'), "RoleName", 'Wewenang'), "RoleDescription", 'Deskripsi peran'), "AddPermissions", 'Buat Izin'), "View", 'Melihat'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", 'Menghapus'), "NewAdjustement", 'Penyesuaian Baru'), "EditAdjustement", 'Edit Penyesuaian'), "CannotSubstraction", 'Anda tidak dapat mengurangi produk yang memiliki stok 0'), "Addition", 'Tambahan'), "Subtraction", 'Pengurangan'), "profil", 'profil'), "logout", 'keluar'), "PurchaseAlreadyPaid", 'Anda tidak dapat mengubah karena Pembelian ini sudah dibayar'), "SaleAlreadyPaid", 'Anda tidak dapat mengubah karena Obral ini sudah dibayar'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'Anda tidak dapat mengubah karena Pengembalian ini sudah dibayar'), "QuoteAlready", 'Kutipan ini sudah menghasilkan penjualan'), "AddProduct", 'Buat produk'), "QuotationComplete", 'Kutipan Ini Lengkap'), "SiteConfiguration", 'Konfigurasi Situs'), "Language", 'Bahasa'), "DefaultCurrency", 'Mata Uang Default'), "LoginCaptcha", 'Masuk Captcha'), "DefaultEmail", 'Default Email'), "SiteName", 'Nama situs'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Ubah Logo'), "SMTPConfiguration", 'Konfigurasi SMTP'), "HOST", 'TUAN RUMAH'), "PORT", 'PELABUHAN'), "encryption", 'Enkripsi'), "SMTPIncorrect", 'Konfigurasi SMTP Salah'), "PaymentsReturns", 'Pembayaran Kembali'), "ReturnsInvoices", 'Mengembalikan Faktur'), "ReturnsInvoicesData", 'Mengembalikan Data Faktur'), "ShowAll", 'Tampilkan semua catatan dari semua Pengguna'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", 'Diskon'), "OrderTax", 'Pajak Pesanan'), "Shipping", 'pengiriman'), "CompanyName", 'Nama Perusahaan'), "CompanyPhone", 'Telepon Perusahaan'), "CompanyAdress", 'Alamat perusahaan'), "Code", 'Kode'), "image", 'gambar'), "Printbarcode", 'Cetak kode batang'), "ReturnsCustomers", 'Mengembalikan Pelanggan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Pengembalian Pemasok'), "FactureReturnCustomers", 'Kembalikan Faktur Pelanggan'), "FactureReturnSuppliers", 'Faktur Pemasok Kembali'), "NodataAvailable", 'Tidak ada data yang tersedia'), "ProductImage", 'gambar produk'), "Barcode", 'Barcode'), "pointofsales", 'titik Penjualan'), "CustomUpload", 'Unggah Ubahsuaian'), "pointofsaleManagement", 'Point of Sale Management'), "Adjustment", 'Pengaturan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", 'Memperbarui'), "Reset", 'Setel ulang'), "print", 'Mencetak'), "SearchByEmail", 'Cari Melalui Email'), "ChooseProduct", 'Choose Product'), "Qty", 'Jml'), "Items", 'Item'), "AmountHT", 'Jumlah'), "AmountTTC", 'jumlah total'), "PleaseSelectSupplier", 'Silakan Pilih Pemasok'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Silakan Pilih Status'), "PayeBy", 'Dibayar oleh'), "ChooseWarehouse", 'Pilih Gudang'), "payNow", 'Bayar sekarang'), "ListofCategory", 'Daftar Kategori'), "Description", 'Deskripsi'), "submit", 'Kirimkan'), "ProblemCreatingThisInvoice", 'Terjadi masalah saat membuat Faktur ini. Silakan coba lagi'), "ProblemPayment", 'Ada masalah pembayaran. Silakan coba lagi.'), "IncomeExpenses", 'Pendapatan & Beban'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'Penjualan & Pembelian Harian'), "ProductsExpired", 'Produk Kedaluwarsa'), "ListofBrand", 'Daftar Merek'), "CreateAdjustment", 'Buat Penyesuaian'), "Afewwords", 'Beberapa kata ...'), "UserImage", 'Gambar Pengguna'), "UpdateProduct", 'Perbarui Produk'), "Brand", 'Merek'), "BarcodeSymbology", 'Simbologi Barcode'), "ProductCost", 'Biaya Produk'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Harga Produk'), "UnitProduct", 'Produk Satuan'), "TaxMethod", 'Metode Perpajakan'), "MultipleImage", 'Beberapa Gambar'), "ProductHasMultiVariants", 'Produk Memiliki Banyak Varian'), "ProductHasPromotion", 'Produk Memiliki Promosi'), "PromotionStart", 'Promosi Mulai'), "PromotionEnd", 'Promosi Berakhir'), "PromotionPrice", 'Harga promosi'), "Price", 'Harga'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Cost", 'Biaya'), "Unit", 'Satuan'), "ProductVariant", 'Variasi Produk'), "Variant", 'Varian'), "UnitPrice", 'Patokan harga'), "CreateReturnCustomer", 'Buat Pelanggan Kembali'), "EditReturnCustomer", 'Edit Pelanggan Kembali'), "CreateReturnSupplier", 'Buat Pemasok Pengembalian'), "Documentation", 'Dokumentasi'), "EditReturnSupplier", 'Edit Pemasok Pengembalian'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'Dari Gudang'), "ToWarehouse", 'Ke Gudang'), "EditTransfer", 'Edit Transfer'), "TransferDetail", 'Transfer Detail'), "Pending", 'tertunda'), "Received", 'Diterima'), "Ordered", 'Dipesan'), "PermissionsManager", 'Manajemen Izin'), "BrandManager", 'Merek'), "BrandImage", 'Citra Merek'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BrandName", 'Nama merk'), "BrandDescription", 'Deskripsi Merek'), "BaseUnit", 'Unit dasar'), "ManagerUnits", 'Manajemen Unit'), "OperationValue", 'Nilai Operasi'), "Operator", 'Operator'), "Top5Products", 'Lima Produk Teratas'), "Last5Sales", 'Lima Penjualan terakhir'), "ListAdjustments", 'Penyesuaian Daftar'), "ListTransfers", 'Daftar Transfer'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Buat Transfer'), "OrdersManager", 'Manajemen Pesanan'), "ListQuotations", 'Daftar Kutipan'), "ListPurchases", 'Daftar Pembelian'), "ListSales", 'Daftar Penjualan'), "ListReturns", 'Daftar Pengembalian'), "PeopleManager", 'Manajemen Orang'), "Delete", {
  Title: 'Apakah kamu yakin',
  Text: 'Anda tidak akan dapat mengembalikan ini!',
  confirmButtonText: 'Ya, hapus!',
  cancelButtonText: 'Membatalkan',
  Deleted: 'Dihapus!',
  Failed: 'Gagal!',
  Therewassomethingwronge: 'Ada yang salah',
  CustomerDeleted: 'Klien ini telah dihapus.',
  SupplierDeleted: 'Pemasok ini telah dihapus.',
  QuoteDeleted: 'Kutipan ini telah dihapus.',
  SaleDeleted: 'Obral ini telah dihapus.',
  PaymentDeleted: 'Pembayaran ini telah dihapus.',
  PurchaseDeleted: 'Pembelian ini telah dihapus.',
  ReturnDeleted: 'Pengembalian ini telah dihapus.',
  ProductDeleted: 'Produk ini telah dihapus.',
  ClientError: 'Klien ini sudah terhubung dengan Operasi lain',
  ProviderError: 'Pemasok ini sudah terhubung dengan Operasi lain',
  UserDeleted: 'Pengguna ini telah dihapus.',
  UnitDeleted: 'Unit ini telah dihapus.',
  RoleDeleted: 'Peran ini telah dihapus.',
  TaxeDeleted: 'Pajak ini telah dihapus.',
  SubCatDeleted: 'Sub Kategori ini telah dihapus.',
  CatDeleted: 'Kategori ini telah dihapus.',
  WarehouseDeleted: 'Gudang ini telah dihapus.',
  AlreadyLinked: 'produk ini sudah ditautkan dengan Operasi lain',
  AdjustDeleted: 'Penyesuaian ini telah dihapus.',
  TitleCurrency: 'Mata Uang ini telah dihapus.',
  TitleTransfer: 'Transfer berhasil dihapus',
  BackupDeleted: 'Cadangan berhasil dihapus',
  TitleBrand: 'Merek ini telah dihapus'
}), "Update", {
  TitleProfile: 'Profil Anda berhasil diperbarui',
  TitleAdjust: 'Penyesuaian Berhasil diperbarui',
  TitleRole: 'Peran berhasil diperbarui',
  TitleUnit: 'Unit Berhasil Diperbarui',
  TitleUser: 'Pengguna Berhasil Diperbarui',
  TitleCustomer: 'Pembaruan Pelanggan berhasil',
  TitleQuote: 'Kutipan Berhasil Diperbarui',
  TitleSale: 'Obral Berhasil Diperbarui',
  TitlePayment: 'Pembayaran berhasil diperbarui',
  TitlePurchase: 'Pembelian Berhasil Diperbarui',
  TitleReturn: 'Kembali Diperbarui dengan sukses',
  TitleProduct: 'Pembaruan Produk berhasil',
  TitleSupplier: 'Pemasok berhasil diperbarui',
  TitleTaxe: 'Pajak berhasil diperbarui',
  TitleCat: 'Kategori Berhasil diperbarui',
  TitleWarhouse: 'Gudang berhasil diperbarui',
  TitleSetting: 'Pengaturan Berhasil Diperbarui',
  TitleCurrency: 'Pembaruan Mata Uang berhasil',
  TitleTransfer: 'Transfer Berhasil diperbarui',
  TitleBrand: 'Merek ini telah diperbarui'
}), "Create", {
  TitleBrand: 'Merek Ini Telah Dibuat',
  TitleRole: 'Peran berhasil dibuat',
  TitleUnit: 'Unit Berhasil Dibuat',
  TitleUser: 'Pengguna Berhasil Dibuat di',
  TitleCustomer: 'Pelanggan Dibuat dengan sukses',
  TitleQuote: 'Kutipan Berhasil dibuat',
  TitleSale: 'Penjualan Berhasil dibuat',
  TitlePayment: 'Pembayaran Berhasil Dibuat',
  TitlePurchase: 'Pembelian Berhasil dibuat',
  TitleReturn: 'Kembali Dibuat dengan sukses',
  TitleProduct: 'Produk Berhasil Dibuat di',
  TitleSupplier: 'Pemasok Dibuat dengan sukses',
  TitleTaxe: 'Pajak berhasil dibuat',
  TitleCat: 'Kategori Berhasil dibuat',
  TitleWarhouse: 'Gudang Dibuat dengan sukses',
  TitleAdjust: 'Penyesuaian Berhasil Dibuat',
  TitleCurrency: 'Mata uang Dibuat dengan sukses',
  TitleTransfer: 'Transfer Dibuat dengan sukses'
}), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'Email Berhasil dikirim'
}), "return", {
  TitleSale: 'penjualan ini sudah ditautkan dengan Return!'
}), "ReturnManagement", 'Manajemen Pengembalian'), "ReturnDetail", 'detail pengembalian'), "EditReturn", 'Edit Kembali'), "AddReturn", 'Buat Pengembalian'), "EmailReturn", 'Kirim Pengembalian melalui Email'), "DeleteReturn", 'Hapus Kembali'), "Retoursurcharge", 'Biaya Tambahan Pengembalian'), "Laivrison", 'pengiriman'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Pilih Sale'), "ZeroPardefault", 'Anda dapat menghapus item atau mengatur kuantitas dikembalikan ke nol jika tidak dikembalikan'), "Return", 'Kembali'), "Purchase", 'Membeli'), "TotalSales", 'Total Penjualan'), "TotalPurchases", 'Total Pembelian'), "TotalReturns", 'Total Pengembalian'), "PaiementsNet", 'Pembayaran Bersih'), "PaiementsSent", 'Paiements Sent'), "PaiementsReceived", 'Pembayaran diterima'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Recieved", 'Diterima'), "Sent", 'Terkirim'), "ProductQuantityAlerts", 'Peringatan Kuantitas Produk'), "ProductCode", 'Kode'), "ProductName", 'Produk'), "AlertQuantity", 'Kuantitas Peringatan'), "WarehouseStockChart", 'Grafik Stok Gudang'), "TotalProducts", 'Total Produk'), "TotalQuantity", 'Jumlah total'), "TopCustomers", 'Lima Pelanggan Teratas'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Jumlah total'), "TotalPaid", 'Total Dibayar'), "CustomerSalesReport", 'Laporan Penjualan Pelanggan'), "CustomerPaiementsReport", 'Laporan Pembayaran Pelanggan'), "CustomerQuotationsReport", 'Laporan Kutipan Pelanggan'), "Payments", 'Pembayaran'), "TopSuppliers", 'Lima Pemasok Teratas'), "SupplierPurchasesReport", 'Laporan Pembelian Pemasok'), "SupplierPaiementsReport", 'Laporan Pembayaran Pemasok'), "Name", 'Nama'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Code", 'Kode'), "ManagementWarehouse", 'Manajemen Gudang'), "ZipCode", 'Kode Pos'), "managementCategories", 'Manajemen kategori'), "Codecategorie", 'Kategori kode'), "Namecategorie", 'Kategori nama'), "Parentcategorie", 'Kategori Induk'), "managementTax", 'Manajemen pajak'), "TaxName", 'Nama Pajak'), "TaxRate", 'Persentase pajak'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Pembelian Unit'), "managementUnitSales", 'Unit penjualan'), "ShortName", 'Nama pendek'), "PleaseSelectThesebeforeaddinganyproduct", 'Harap Pilih Ini sebelum menambahkan produk apa pun'), "StockAdjustement", 'Penyesuaian Stok'), "PleaseSelectWarehouse", 'Pilih gudang sebelum memilih produk apa pun'), "StockTransfer", 'Transfer Saham'), "SelectPeriod", 'Pilih Periode'), "ThisYear", 'Tahun ini'), "ThisToday", 'Hari Ini'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'Bulan ini'), "ThisWeek", 'Minggu ini'), "AdjustmentDetail", 'Detail Penyesuaian'), "ActivateUser", 'Pengguna Ini Telah Diaktifkan'), "DisActivateUser", 'Pengguna Ini Telah Dinonaktifkan'), "NotFound", 'Halaman tidak ditemukan.'), "oops", 'kesalahan! Halaman tidak ditemukan.'), "couldNotFind", 'Kami tidak dapat menemukan halaman yang Anda cari. Sementara itu, Anda mungkin'), "ReturnDashboard", 'kembali ke dasbor'), "hrm", 'HRM'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Employees", 'Para karyawan'), "Attendance", 'Kehadiran'), "Leave_request", 'Tinggalkan Permintaan'), "Leave_type", 'Tinggalkan Jenis'), "Company", 'Perusahaan'), "Departments", 'Departemen'), "Designations", 'sebutan'), "Office_Shift", 'Pergeseran Kantor'), "Holidays", 'Liburan'), "Enter_Company_Name", 'Masukkan nama perusahaan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Masukkan alamat email'), "Enter_Company_Phone", 'Masukkan telepon perusahaan'), "Enter_Company_Country", 'Masukkan negara perusahaan'), "Created_in_successfully", 'Berhasil dibuat'), "Updated_in_successfully", 'Berhasil diperbarui'), "Deleted_in_successfully", 'Berhasil dihapus'), "department", 'Departemen'), "Enter_Department_Name", 'Masukkan nama departemen'), "Choose_Company", 'Pilih Perusahaan'), "Department_Head", 'Kepala Departemen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Pilih Kepala Departemen'), "Enter_Shift_name", 'Masukkan nama Shift'), "Monday_In", 'Monday In'), "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'Liburan'), "Enter_title", 'Masukkan judul'), "title", 'judul'), "start_date", 'Mulai tanggal'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Masukkan tanggal mulai'), "Finish_Date", 'Tanggal selesai'), "Enter_Finish_date", 'Masukkan tanggal selesai'), "Please_provide_any_details", 'Harap berikan detail apa pun'), "Attendances", 'Kehadiran'), "Enter_Attendance_date", 'Masukkan tanggal kehadiran'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", 'Pilih Karyawan'), "Employee", 'Karyawan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Lama pengerjaan'), "remaining_leaves_are_insufficient", 'Daun yang tersisa tidak mencukupi'), "Leave_Type", 'Tinggalkan Jenis'), "Days", 'hari'), "Department", 'Departemen'), "Choose_leave_type", 'Pilih jenis cuti'), "Choose_status", 'Pilih status'), "Leave_Reason", 'Tinggalkan Alasan'), "Enter_Reason_Leave", 'Masuk Alasan Keluar'), "Add_Employee", 'Tambahkan Karyawan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FirstName", 'Nama depan'), "Enter_FirstName", 'Masukkan Nama Depan'), "LastName", 'Nama keluarga'), "Enter_LastName", 'Masukkan Nama Belakang'), "Gender", 'Jenis kelamin'), "Choose_Gender", 'Pilih Jenis Kelamin'), "Enter_Birth_date", 'Masukkan tanggal lahir'), "Birth_date", 'Tanggal lahir'), "Enter_Country", 'Masukkan Negara'), "Enter_Phone_Number", 'Masukkan nomor telepon'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "joining_date", 'Tanggal Bergabung'), "Enter_joining_date", 'Masukkan tanggal bergabung'), "Choose_Designation", 'Pilih Penunjukan'), "Designation", 'Penamaan'), "Office_Shift", 'Pergeseran Kantor'), "Choose_Office_Shift", 'Pilih Shift Kantor'), "Enter_Leaving_Date", 'Masukkan Tanggal Keluar'), "Leaving_Date", 'Tanggal Keluar'), "Annual_Leave", 'Cuti tahunan'), "Enter_Annual_Leave", 'Masuk Cuti Tahunan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Sisa cuti'), "Employee_Details", 'Detail Karyawan'), "Basic_Information", 'Informasi dasar'), "Family_status", 'Status keluarga'), "Choose_Family_status", 'Pilih status Keluarga'), "Employment_type", 'Jenis Pekerjaan'), "Select_Employment_type", 'Pilih jenis Pekerjaan'), "Enter_City", 'Masukkan Kota'), "Province", 'Propinsi'), "Enter_Province", 'Masuk Provinsi'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Masukkan alamat'), "Enter_Zip_code", 'Masukkan kode pos'), "Zip_code", 'Kode Pos'), "Hourly_rate", 'Tarif per jam'), "Enter_Hourly_rate", 'Masukkan tarif Per Jam'), "Basic_salary", 'Gaji pokok'), "Enter_Basic_salary", 'Masukkan Gaji Pokok'), "Social_Media", 'Media sosial'), "Skype", 'Skype'), "Enter_Skype", 'Masuk ke Skype'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), "Enter_Facebook", 'Masuk ke Facebook'), "WhatsApp", 'WhatsApp'), "Enter_WhatsApp", 'Masuk ke WhatsApp'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", 'Masuk ke LinkedIn'), "Twitter", 'Twitter'), "Enter_Twitter", 'Masuk ke Twitter'), "Experiences", 'Pengalaman'), "bank_account", 'akun bank'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Company_Name", 'Nama perusahaan'), "Location", 'Lokasi'), "Enter_location", 'Masukkan lokasi'), "Enter_Description", 'Masukkan Deskripsi'), "Bank_Name", 'Nama Bank'), "Enter_Bank_Name", 'Masukkan Nama Bank'), "Bank_Branch", 'Cabang Bank'), "Enter_Bank_Branch", 'Masuk Cabang Bank'), "Bank_Number", 'Nomor Bank'), "Enter_Bank_Number", 'Masukkan Nomor Bank'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'gudang yang ditugaskan'), "Top_customers", 'Pelanggan teratas'), "Attachment", 'Lampiran'), "view_employee", 'lihat karyawan'), "edit_employee", 'edit karyawan'), "delete_employee", 'hapus karyawan'), "Created_by", 'Ditambahkan oleh'), "Add_product_IMEI_Serial_number", 'Tambahkan IMEI/Nomor Seri produk'), "Product_Has_Imei_Serial_number", 'Produk Memiliki Imei/Nomor Seri'), "IMEI_SN", 'IMEI/SN'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Shipments", 'pengiriman'), "delivered_to", 'Dikirim ke'), "shipment_ref", 'Referensi Pengiriman'), "sale_ref", 'Referensi Penjualan'), "Edit_Shipping", 'Sunting Pengiriman'), "Packed", 'Penuh sesak'), "Shipped", 'Dikirim'), "Delivered", 'Terkirim'), "Cancelled", 'Dibatalkan'), "Shipping_status", 'Status pengiriman'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Laporan Pengguna'), "stock_report", 'Laporan Stok'), "TotalPurchases", 'Jumlah Pembelian'), "Total_quotations", 'Jumlah Kutipan'), "Total_return_sales", 'Jumlah penjualan retur'), "Total_return_purchases", 'Jumlah pengembalian pembelian'), "Total_transfers", 'Jumlah transfer'), "Total_adjustments", 'Penyesuaian total'), "User_report", 'Laporan Pengguna'), "Current_stock", 'Saham saat ini'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_name", 'Nama Produk'), "Total_Customers_Due", 'Jumlah Hutang'), "Total_Suppliers_Due", 'Jumlah Hutang'), "Some_warehouses", 'Beberapa Gudang'), "All_Warehouses", 'Semua Gudang'), "Product_Cost", 'Biaya Produk'), "sms_settings", 'Pengaturan SMS'), "pos_settings", 'Pengaturan POS'), "payment_gateway", 'Gerbang pembayaran'), "mail_settings", 'Pengaturan Surat'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'Gerbang SMS Standar'), "module_settings", 'Pengaturan Modul'), "Module_enabled_success", 'Modul berhasil diaktifkan'), "Module_Disabled_success", 'Modul berhasil Dinonaktifkan'), "update_settings", 'Perbarui Pengaturan'), "Please_Upload_the_Correct_Module", 'Silakan Unggah Modul yang Benar'), "Uploaded_Success", 'Berhasil diunggah'), "Customer_details", 'detil pelanggan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Sunting Pelanggan'), "Delete_Customer", 'Hapus Pelanggan'), "Pay_Due", 'membayar Jatuh tempo'), "Paying_amount_is_greater_than_Total_Due", 'Jumlah pembayaran lebih besar dari Total Hutang'), "Customer_Invoice", 'Faktur pelanggan'), "This_Product_Not_For_Selling", 'Produk Ini Bukan Untuk Dijual'), "Welcome_to_your_Dashboard", 'Selamat datang di Dasbor Anda'), "Total_Payable", 'Total yang harus dibayar'), "Choose_Sale_Ref", 'Pilih Ref Penjualan'), "Please_Select_Sale", 'Silahkan Pilih Dijual'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Referensi Penjualan'), "list_product_returns", 'daftar pengembalian produk'), "Qty_return", 'qty kembali'), "Choose_Purchase_Ref", 'Pilih Referensi Pembelian'), "Purchase_Ref", 'Referensi Pembelian'), "please_select_purchase", 'Silahkan Pilih Pembelian'), "qty_return_is_greater_than_qty_purchased", 'Qty return lebih besar dari Qty yang dibeli'), "qty_return_is_greater_than_qty_sold", 'Qty return lebih besar dari Qty yang terjual'), "Quantity_sold", 'Qty terjual'), "qty_purchased", 'Kuantitas yang dibeli'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Nama pengirim'), "The_module_must_be_uploaded_as_zip_file", 'Modul harus diunggah sebagai file zip'), "Upload_Module", 'Unggah Modul'), "All_Modules_Installed", 'Semua Modul Terpasang'), "Current_Version", 'Versi sekarang'), "You_already_have_the_latest_version", 'Anda sudah memiliki versi terbaru'), "Update_Available", 'Pembaruan tersedia'), "Update_Log", 'Perbarui Log'), "Update_Now", 'Memperbarui sekarang'), "View_Change_Log", 'Lihat Ubah Log'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'Footer faktur'), "Please_Wait_for_the_update", 'CATATAN: Harap Tunggu hingga pembaruan selesai sepenuhnya. Tidak disarankan untuk menutup browser atau menghentikan proses Upgrade'), "Note_update", 'Catatan: Pastikan Anda membuat cadangan versi & basis data Anda saat ini sebelum menjalankan Peningkatan, Untuk memulihkannya jika ada kesalahan'), "Time_Zone", 'Zona waktu'), "Payment_note", 'catatan pembayaran'), "sale_note", 'nota penjualan'), "Total_Sale_Due", 'Total Penjualan hutang'), "Total_Sell_Return_Due", 'Total Jual Kembalikan hutang'), "pay_all_sell_due_at_a_time", 'bayar semua hutang jual sekaligus'), "pay_all_sell_return_due_at_a_time", 'bayar semua hutang retur penjualan sekaligus'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Laba kotor'), "pay_all_purchase_due_at_a_time", 'membayar semua utang pembelian sekaligus'), "Delete_Provider", 'Hapus Penyedia'), "Edit_Provider", 'Sunting Penyedia'), "Provider_details", 'Detail penyedia'), "Total_Purchase_Due", 'Total Pembelian jatuh tempo'), "Provider_Credit_Note", 'Nota kredit'), "Customer_Credit_Note", 'Nota kredit'), "Sell_Return", 'Kembalikan penjualan'), "Purchase_Return", 'Pengembalian Pembelian'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Nomor pajak'), "Please_add_return_quantity", 'Silakan tambahkan jumlah pengembalian'), "Return_exist_for_the_Transaction", 'Pengembalian ada untuk Transaksi'), "qty_return_is_greater_than_Quantity_Remaining", 'Qty return lebih besar dari Quantity Remaining'), "products_refunded_alert", 'Produk apa pun dengan jumlah yang disetel ke 0 tidak akan dikembalikan dananya'), "pay_all_purchase_return_due_at_a_time", 'bayar semua retur pembelian yang jatuh tempo sekaligus'), "Total_Purchase_Return_Due", 'Total Pengembalian Pembelian yang jatuh tempo'), "Purchase_return_due", 'Pengembalian pembelian jatuh tempo'), "Sell_return_due", 'Jual retur jatuh tempo'), "product_report", 'Laporan produk'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'laporan penjualan produk'), "Product_purchases_report", 'laporan pembelian produk'), "Qty_sold", 'Qty terjual'), "Qty_purchased", 'Qty dibeli'), "Filter_by_warehouse", 'Saring menurut gudang'), "Enable_Print_Invoice", 'Cetak Faktur secara otomatis'), "Show_Warehouse", 'melihat gudang'), "credit_card_info", 'Info Kartu Kredit'), "Saved_Credit_Card_Info", 'Info Kartu Kredit Tersimpan'), "Credit_card_changed_successfully", 'Kartu kredit berhasil diubah'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "notification_template", 'Template Notifikasi'), "email_notification", 'Notifikasi Email'), "sms_notification", 'Notifikasi SMS'), "Change_product_details", 'Ubah Detail Produk'), "edit_tax_and_discount_and_shipping", 'Ubah Pajak, Diskon, dan Pengiriman'), "Create_Quotation_with_Stock", 'Buat Kutipan dengan Stok'), "Variant_Name", 'Nama Variabel'), "Variant_cost", 'Biaya Variabel'), "Variant_price", 'Harga Variabel'), "Variant_code", 'Kode Variabel'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Harap tunggu hingga produk dimuat'), "Choose_SMS_Gateway", 'Pilih Gateway SMS'), "Notification_Client", 'Notifikasi Klien'), "Available_Tags", 'Tag yang Tersedia'), "Email_Subject", 'Subjek Email'), "Email_body", 'Isi Email'), "Notification_Supplier", 'Notifikasi Pemasok'), "sms_body", 'Isi SMS'), "sms_templates", 'SMS Templates'), "email_templates", 'Email Templates'));

/***/ }),

/***/ "./resources/src/translations/locales/ar.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/ar.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Update, _Create, _Pos_Settings$Receipt;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Arabe

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Pos_Settings$Receipt = {
  Pos_Settings: 'إعدادات نقاط البيع',
  Receipt: 'الإيصال',
  Note_to_customer: 'ملاحظة للعميل',
  Show_Note_to_customer: 'إظهار ملاحظة للعميل',
  Show_barcode: 'إظهار الشفرة',
  Show_Tax_and_Discount: 'إظهار الضرائب والخصم والشحن',
  Show_Customer: 'إظهار العميل',
  Show_Email: 'إظهار البريد الإلكتروني',
  Show_Phone: 'إظهار الهاتف',
  Show_Address: 'إظهار العنوان',
  DefaultLanguage: 'اللغة الافتراضية',
  footer: 'تذييل',
  Received_Amount: 'المبلغ المستلم',
  Paying_Amount: 'مبلغ الدفع',
  Change: 'الصرف',
  Paying_amount_is_greater_than_Received_amount: 'مبلغ الدفع أكبر من المبلغ المستلم',
  Paying_amount_is_greater_than_Grand_Total: 'مبلغ الدفع أكبر من المبلغ الإجمالي الكلي',
  code_must_be_not_exist_already: 'يجب أن يكون الرمز غير موجود بالفعل',
  You_will_find_your_backup_on: 'سوف تجد النسخة الاحتياطية الخاصة بك على',
  and_save_it_to_your_pc: 'و قم بحفظه على جهاز الكمبيوتر الخاص بك',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'امسح الرمز الشريطي ضوئيًا وحدد الترميز الصحيح أدناه',
  Scan_Search_Product_by_Code_Name: 'مسح / بحث عن المنتج حسب الاسم الرمزي',
  Paper_size: 'حجم الورق',
  Clear_Cache: 'مسح ذاكرة التخزين المؤقت',
  Cache_cleared_successfully: 'تم مسح ذاكرة التخزين المؤقت بنجاح',
  Failed_to_clear_cache: 'فشل مسح ذاكرة التخزين المؤقت',
  Scan_Barcode: 'ماسح الباركود',
  Please_use_short_name_of_unit: 'الرجاء استخدام الاسم المختصر للوحدة',
  DefaultCustomer: 'العميل الافتراضي',
  DefaultWarehouse: 'المستودع الافتراضي',
  Payment_Gateway: 'بوابة الدفع',
  SMS_Configuration: 'إعدادات الرسائل القصيرة',
  Gateway: 'بوابة الدفع',
  Choose_Gateway: 'اختر بوابة الدفع',
  Send_SMS: 'تم ارسال الرسالة بنجاح',
  sms_config_invalid: 'إعدادات الرسائل القصيرة غير صالحة',
  Remove_Stripe_Key_Secret: 'حذف مفاتيح Stripe API',
  credit_card_account_not_available: 'حساب بطاقة الائتمان غير متوفر',
  Credit_Card_Info: 'معلومات بطاقة الائتمان',
  developed_by: 'طورت بواسطة',
  Unit_already_linked_with_sub_unit: 'الوحدة مرتبطة بالفعل بوحدة فرعية',
  Total_Items_Quantity: 'مجموع العناصر والكمية',
  Value_by_Cost_and_Price: 'القيمة حسب التكلفة والسعر',
  Search_this_table: 'ابحث في هذا الجدول',
  import_products: 'استيراد المنتجات',
  Field_optional: 'حقل اختياري',
  Download_exemple: 'تحميل المثال',
  field_must_be_in_csv_format: 'يجب أن يكون الحقل بتنسيق csv',
  Successfully_Imported: 'تم الاستيراد بنجاح',
  file_size_must_be_less_than_1_mega: 'يجب أن يكون حجم الملف أقل من 1 ميغا',
  Please_follow_the_import_instructions: 'يرجى اتباع تعليمات الاستيراد',
  must_be_exist: 'يجب أن تكون الوحدة قد تم إنشاؤها بالفعل',
  Import_Customers: 'استيراد العملاء',
  Import_Suppliers: 'استيراد الموردين',
  Recent_Sales: 'المبيعات الأخيرة',
  Create_Transfer: 'إنشاء تحويل',
  order_products: 'طلب المنتجات',
  Search_Product_by_Code_Name: 'ابحث عن المنتج بالكود أو الاسم',
  Reports_payments_Purchase_Return: 'تقارير مدفوعات مرتجعات الشراء',
  Reports_payments_Sale_Return: 'تقارير مدفوعات مرتجعات البيع',
  payments_Sales_Return: 'مدفوعات إرجاع المبيعات',
  payments_Purchases_Return: 'مدفوعات مشتريات العودة',
  CreateSaleReturn: 'إنشاء عائد بيع',
  EditSaleReturn: 'تحرير إرجاع البيع',
  SalesReturn: 'عائد المبيعات',
  CreatePurchaseReturn: 'إنشاء إرجاع الشراء',
  EditPurchaseReturn: 'تحرير إرجاع الشراء',
  PurchasesReturn: 'عائد المشتريات',
  Due: 'دين',
  Profit: 'ربح',
  Revenue: 'دخل',
  Sales_today: 'مبيعات اليوم',
  People: 'اشخاص',
  Successfully_Created: 'تم إنشاؤه بنجاح',
  Successfully_Updated: 'تم التحديث بنجاح',
  Success: 'نجاح',
  Failed: 'باءت بالفشل',
  Warning: 'إنذار',
  Please_fill_the_form_correctly: 'يرجى ملء النموذج بشكل صحيح',
  Field_is_required: 'هذا الحقل مطلوب',
  Choose_Status: 'اختر الحالة',
  Choose_Method: 'اختر الطريقة',
  Choose_Symbology: 'اختر الترميز',
  Choose_Category: 'اختر الفئة',
  Choose_Customer: 'اختر الزبون',
  Choose_Supplier: 'اختر المورد',
  Choose_Unit_Purchase: 'اختر وحدة الشراء',
  Choose_Sub_Category: 'اختر الفئة الفرعية',
  Choose_Brand: 'اختر الماركة',
  Choose_Warehouse: 'اختر المستودع',
  Choose_Unit_Sale: 'اختر وحدة البيع',
  Enter_Product_Cost: 'أدخل تكلفة المنتج',
  Enter_Stock_alert: 'أدخل تنبيه المخزون',
  Choose_Unit_Product: 'اختر وحدة المنتج',
  Enter_Product_Price: 'أدخل سعر المنتج',
  Enter_Name_Product: 'أدخل اسم المنتج',
  Enter_Role_Name: 'أدخل اسم الدور',
  Enter_Role_Description: 'أدخل وصف الدور',
  Enter_name_category: 'أدخل اسم الفئة',
  Enter_Code_category: 'أدخل رمز الفئة',
  Enter_Name_Brand: 'أدخل اسم الماركة',
  Enter_Description_Brand: 'أدخل وصف الماركة ',
  Enter_Code_Currency: 'أدخل رمز العملة',
  Enter_name_Currency: 'أدخل اسم العملة',
  Enter_Symbol_Currency: 'أدخل رمز العملة',
  Enter_Name_Unit: 'أدخل اسم وحدة',
  Enter_ShortName_Unit: 'أدخل اسمًا قصيرًا للوحدة',
  Choose_Base_Unit: 'اختر وحدة القاعدة',
  Choose_Operator: 'اختر عامل التشغيل',
  Enter_Operation_Value: 'أدخل قيمة العملية',
  Enter_Name_Warehouse: 'أدخل اسم المستودع',
  Enter_Phone_Warehouse: 'أدخل هاتف المستودع',
  Enter_Country_Warehouse: 'أدخل بلد المستودع',
  Enter_City_Warehouse: 'أدخل مدينة المستودع',
  Enter_Email_Warehouse: 'أدخل البريد الإلكتروني للمستودع',
  Enter_ZipCode_Warehouse: 'أدخل الرمز البريدي للمستودع',
  Choose_Currency: 'اختر العملة',
  Thank_you_for_your_business: 'شكرا لك على عملك !',
  Cancel: 'إلغاء',
  New_Customer: 'عميل جديد',
  Incorrect_Login: 'تسجيل الدخول غير صحيح',
  Successfully_Logged_In: 'تم تسجيل الدخول بنجاح',
  This_user_not_active: 'هذا المستخدم غير نشط',
  SignIn: 'تسجيل الدخول',
  Create_an_account: 'انشئ حساب',
  Forgot_Password: 'هل نسيت كلمة السر',
  Email_Address: 'بريد الكتروني',
  SignUp: 'اشتراك',
  Already_have_an_account: 'هل لديك حساب ؟',
  Reset_Password: 'إعادة تعيين كلمة المرور',
  Failed_to_authenticate_on_SMTP_server: 'فشل المصادقة على خادم SMTP',
  We_cant_find_a_user_with_that_email_addres: 'لا يمكننا العثور على مستخدم بعنوان البريد الإلكتروني هذا',
  We_have_emailed_your_password_reset_link: 'لقد أرسلنا رابط إعادة تعيين كلمة المرور بالبريد الإلكتروني',
  Please_fill_the_Email_Adress: 'يرجى ملء عنوان البريد الإلكتروني',
  Confirm_password: 'تأكيد كلمة المرور',
  Your_Password_has_been_changed: 'تم تغيير كلمة السر الخاصة بك',
  The_password_confirmation_does_not_match: 'تأكيد كلمة المرور غير متطابق',
  This_password_reset_token_is_invalid: 'رمز إعادة تعيين كلمة المرور هذا غير صالح',
  Warehouse_report: 'تقرير المستودع',
  All_Warehouses: 'جميع المستودعات',
  Expense_List: 'قائمة المصاريف',
  Expenses: 'المصاريف',
  This_Week_Sales_Purchases: 'مبيعات ومشتريات هذا الأسبوع',
  Top_Selling_Products: 'المنتجات الأكثر مبيعًا',
  View_all: 'مشاهدة الكل',
  Payment_Sent_Received: 'الدفع - المرسل والمستلم',
  Error: 'خطأ !',
  you_are_not_authorized: 'آسف! أنك غير مخول.',
  Go_back_to_home: 'العودة الى الصفحة الرئيسية',
  page_not_exist: 'آسف! الصفحة التي تبحث عنها غير موجودة.',
  Filter: 'فلتر',
  Invoice_POS: 'فاتورة نقاط البيع',
  Invoice: 'فاتورة',
  Customer_Info: 'معلومات العميل',
  Company_Info: 'معلومات الشركة',
  Invoice_Info: 'معلومات الفاتورة',
  Order_Summary: 'ملخص الطلب',
  Quote_Info: 'معلومات الاقتباس',
  Del: 'حذف',
  SuppliersPaiementsReport: 'تقرير مدفوعات الموردين',
  Purchase_Info: 'معلومات الشراء',
  Supplier_Info: 'معلومات المورد',
  Return_Info: 'معلومات العودة',
  Expense_Category: 'فئة المصاريف',
  Create_Expense: 'أضف المصاريف',
  Details: 'تفاصيل',
  Discount_Method: 'طريقة الخصم',
  Net_Unit_Cost: 'صافي تكلفة الوحدة',
  Net_Unit_Price: 'صافي سعر الوحدة',
  Edit_Expense: 'تحرير المصاريف',
  All_Brand: 'جميع العلامات التجارية',
  All_Category: 'كل الفئات',
  ListExpenses: 'قائمة المصروفات',
  Create_Permission: 'إنشاء إذن',
  Edit_Permission: 'تحرير إذن',
  Reports_payments_Sales: 'تقارير مدفوعات المبيعات',
  Reports_payments_Purchases: 'تقارير مشتريات المدفوعات',
  Reports_payments_Return_Customers: 'تقارير المدفوعات المرتجعة للعملاء',
  Reports_payments_Return_Suppliers: 'تقارير المدفوعات عودة الموردين',
  Expense_Deleted: 'تم حذف هذه المصاريف',
  Expense_Updated: 'تم تحديث هذه المصاريف',
  Expense_Created: 'تم إنشاء هذه المصاريف',
  DemoVersion: 'لا يمكنك القيام بذلك في النسخة التجريبية',
  Filesize: 'حجم الملف',
  GenerateBackup: 'إنشاء نسخة احتياطية',
  BackupDatabase: 'النسخ الاحتياطية',
  Backup: 'النسخ الاحتياطية',
  OrderStatistics: 'إحصائيات المبيعات',
  AlreadyAdd: 'هذا المنتج مضاف بالفعل',
  AddProductToList: 'الرجاء إضافة المنتج إلى القائمة',
  AddQuantity: 'الرجاء إضافة الكمية للمنتج',
  InvalidData: 'بيانات غير صالحة',
  LowStock: 'الكمية تتجاوز الكمية المتوفرة في المخزون',
  WarehouseIdentical: 'لا يمكن أن يكون المستودعين متطابقين',
  VariantDuplicate: 'هذا المتغير مكرر',
  Paid: 'مدفوعة',
  Unpaid: 'غير مدفوعة',
  IncomeExpenses: 'الدخل مقابل المصروفات',
  dailySalesPurchases: 'المبيعات والمشتريات اليومية',
  ProductsExpired: 'المنتجات منتهية الصلاحية',
  Income: 'الدخل'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Expenses", 'المصروفات'), "Sale", 'المبيعة'), "Actif", 'فعال'), "Inactif", 'غير فعال'), "Phone", 'الهاتف'), "SearchByPhone", 'البحت بالهاتف'), "CustomerName", 'اسم العميل'), "StockManagement", 'إدارة المخزون'), "dashboard", 'لوحة الإستعلام'), "Products", 'منتجات'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "productsList", 'قائمة المنتجات'), "StockTransfers", 'تحويل المخزون'), "Customers", 'الزبائن'), "Suppliers", 'الموردون'), "Quotations", 'عرض الأسعار'), "Sales", 'المبيعات'), "Purchases", 'المشتريات'), "Returns", 'العوائد'), "Settings", 'الإعدادات'), "SystemSettings", 'إعدادات النظام'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Users", 'المستخدمين'), "GroupPermissions", 'صلاحية المجموعة'), "Currencies", 'العملات'), "ProductTax", 'ضريبة المنتج'), "Categories", 'التصنيفات'), "Warehouses", 'المستودعات'), "Units", 'الوحدات'), "UnitsPrchases", 'وحدات الشراء'), "UnitsSales", 'وحدات البيع'), "Reports", 'التقارير'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "PaymentsReport", 'تقرير المدفوعات'), "PaymentsPurchases", 'مدفوعات المشتريات'), "PaymentsSales", 'مدفوعات المبيعات'), "PaymentsReturns", 'مدفوعات المرتجعات'), "ProfitandLoss", 'الربح والخسارة'), "ProductQuantityAlerts", 'تنبيهات كمية المنتج'), "WarehouseStockChart", 'الرسم البياني لسهم المستودع'), "SalesReport", 'تقرير المبيعات'), "PurchasesReport", 'تقرير المشتريات'), "CustomersReport", 'تقرير العملاء'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "SuppliersReport", 'تقرير الموردين'), "SupplierReport", 'تقرير المورد'), "DailySalesData", 'بيانات المبيعات اليومية'), "DailyPurchasesData", 'بيانات المشتريات اليومية'), "Derni\xE8rescinqrecords", 'السجلات الخمسة الأخيرة'), "Filters", 'البحت'), "date", 'التاريخ'), "Reference", 'المرجع'), "Supplier", 'المورد'), "PaymentStatus", 'حالة الدفع'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Customer", 'الزبون'), "CustomerCode", 'رمز الزبون'), "Status", 'الحالة'), "SupplierCode", 'رمز المورد'), "ProductManagement", 'إدارة المنتجات'), "CodeProduct", 'رمز المنتج'), "Categorie", 'التصنيف'), "SubCategorie", 'التصنيف الفرعي'), "Name_product", 'إسم المنتج'), "StockAlert", 'تنبيه المخزون'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "warehouse", 'المستودع'), "Tax", 'الضريبة'), "BuyingPrice", 'سعر الشراء'), "SellPrice", 'سعر البيع'), "Quantity", 'كمية'), "Action", 'الإجراءات'), "UnitSale", 'وحدة البيع'), "UnitPurchase", 'وحدة الشراء'), "ProductDetails", 'تفاصيل المنتج'), "All", 'الكل'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "EditProduct", 'تعديل المنتج'), "AddProduct", 'إضافة منتج'), "SearchByCode", 'البحت بالرمز'), "SearchByName", 'البحت بالاسم'), "Edit", 'تعديل'), "Close", 'أغلق'), "PleaseSelect", 'يرجى التحديد'), "CustomerManagement", 'إدارة الزبائن'), "Email", 'البريد '), "EditCustomer", 'تحرير العميل'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "AddCustomer", 'إضافة عميل'), "Country", 'البلد'), "City", 'المدينة'), "Adress", 'العنوان'), "CustomerDetails", 'تفاصيل العميل'), "CustomersList", 'قائمة الزبائن'), "SupplierCode", 'رمز المورد'), "SupplierName", 'اسم المورد'), "SuppliersManagement", 'إدارة الموردين'), "SupplierDetails", 'تفاصيل المورد'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "QuotationsManagement", 'إدارة التسعيرات'), "SubTotal", 'المجموع الكلي'), "complete", 'مكتملة'), "EnAttendant", 'قيد الانتظار'), "Recu", 'تم الاستلام'), "partial", 'جزئي'), "Retournee", 'مسترجعة'), "DetailQuote", 'تفاصيل عرض السعر '), "EditQuote", 'تعديل عرض السعر'), "CreateSale", 'إنشاء مبيعة'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "DownloadPdf", 'تحميل PDF'), "QuoteEmail", 'ارسال عرض السعر بالبريد الالكتروني'), "DeleteQuote", 'حذف عرض السعر'), "AddQuote", 'إضافة عرض سعر'), "SelectProduct", 'حدد المنتج'), "Price", 'السعر'), "CurrentStock", 'المخزون '), "Total", 'مجموع'), "Num", 'رقم'), "Unitcost", 'تكلفة الوحدة'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "to", 'إلى'), "Subject", 'الموضوع'), "Message", 'الرسالة'), "EmailCustomer", 'البريد الإلكتروني للعميل'), "Sent", 'إرسال'), "ProductCodeName", 'المنتج'), "Quote", 'عرض الأسعار'), "Hello", 'أهلا'), "AttachmentQuote", 'يرجى العثور على المرفق لعرض الأسعار الخاص بك'), "AddProducts", 'إضافة منتجات إلى قائمة الطلبات'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "SelectWarehouse", 'الرجاء اختيار المستودع'), "SelectCustomer", 'اختر الزبون'), "SalesManagement", 'إدارة المبيعات'), "Balance", 'الرصيد'), "QtyBack", 'كمية العوائد'), "TotalReturn", 'مجموع العوائد'), "MontantReste", 'المبلغ المتبقي'), "SaleDetail", 'تفاصيل المبيعة'), "EditSale", 'تعديل المبيعة'), "AddSale", 'إضافة مبيعة'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "ShowPayment", 'إظهار المدفوعات'), "AddPayment", 'إضافة الدفع'), "EditPayment", 'تعديل الدفع'), "EmailSale", 'إرسال المبيعة في البريد الإلكتروني'), "DeleteSale", 'حذف المبيعة'), "Amount", 'المبلغ'), "ModePaiement", 'طريقة الدفع'), "Paymentchoice", 'طريقة الدفع'), "Note", 'ملحوظة'), "PaymentComplete", 'اكتمل الدفع'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "UserManagement", 'إدارة المستخدمين'), "Firstname", 'الاسم الأول'), "lastname", 'اسم العائلة'), "username", 'اسم المستخدم'), "type", 'النوع'), "UserPermissions", 'تراخيص المستخدمين'), "RoleName", 'اسم الدور'), "RoleDescription", 'وصف الدور'), "AddPermissions", 'اضافة التراخيص'), "View", 'عرض'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Add", 'إضافة'), "add", 'إضافة'), "Del", 'حذف'), "NewAdjustement", 'تعديل جديد'), "EditAdjustement", 'تحرير التعديل'), "CannotSubstraction", 'لا يمكنك طرح منتجات لها مخزون 0'), "Addition", 'إضافة'), "Subtraction", 'طرح'), "profil", 'الملف الشخصي'), "logout", 'تسجيل الخروج'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "PurchaseAlreadyPaid", 'لا يمكنك التعديل لأن هذا الشراء  مكتمل الدفع  بالفع'), "SaleAlreadyPaid", 'لا يمكنك التعديل لأن هذه المبيعة  مكتملة الدفع  بالفع'), "ReturnAlreadyPaid", 'لا يمكنك التعديل لأن هذه المرتجعة  مكتملة الدفع  بالفع'), "QuoteAlready", ' هذه التسعيرة أدت بالفعل إلى بيع'), "QuotationComplete", 'هده التسعيرة مكتملة'), "password", 'كلمة المرور'), "Newpassword", 'كلمة المرور جديدة'), "ChangeAvatar", 'تغيير الصورة'), "LeaveBlank", 'يرجى ترك هذا الحقل فارغًا إذا لم تقم بتغييره'), "SiteConfiguration", 'اعدادات عامة'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Language", 'اللغة'), "DefaultCurrency", 'العملة الرئيسية'), "LoginCaptcha", 'كلمة التحقق'), "DefaultEmail", 'البريد الرئيسي'), "SiteName", 'اسم الموقع'), "ChangeLogo", 'تغيير الشعار'), "SMTPConfiguration", 'اعدادات الارسال'), "HOST", 'مضيف'), "PORT", 'المنفذ'), "encryption", 'التشفير'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "SMTPIncorrect", 'اعدادات الارسال غير صحيحة'), "ReturnsInvoices", 'فواتير المرتجعات'), "ReturnsInvoicesData", 'بيانات فواتير المرتجعات'), "ShowAll", 'إظهار كافة سجلات كافة المستخدمين'), "Discount", 'الخصم'), "OrderTax", 'ضريبة الطلب'), "Shipping", 'الشحن'), "ManagementCurrencies", 'ادارة العملات'), "CurrencyCode", 'شفرة العملة'), "CurrencyName", 'اسم العملة'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Symbol", 'رمز العملة'), "CompanyName", 'اسم الشركة'), "CompanyPhone", 'هاتف الشركة'), "CompanyAdress", 'عنوان الشركة'), "Code", 'رمز'), "image", 'صورة'), "Printbarcode", 'طباعة الباركود'), "ReturnsCustomers", 'مرتجعات العملاء'), "ReturnsSuppliers", 'مرتجعات الموردين'), "FactureReturnCustomers", 'فواتير مرتجعات العملاء'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "FactureReturnSuppliers", 'فواتير مرتجعات الموردين'), "NodataAvailable", 'لا تتوافر بيانات'), "ProductImage", 'صورة المنتج'), "Barcode", 'الباركود'), "pointofsales", 'نقطة مبيعات'), "CustomUpload", 'تحميل مخصص'), "pointofsaleManagement", 'إدارة نقاط البيع'), "Adjustment", 'تعديل'), "Updat", 'تحديث'), "Reset", 'إعادة تعيين'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "print", 'طباعة'), "SearchByEmail", 'البحث بالبريد الإلكتروني'), "ChooseProduct", 'اختر المنتج'), "Qty", 'الكمية'), "Items", 'العناصر'), "AmountHT", 'المبلغ دون ضريبة'), "AmountTTC", 'المبلغ الإجمالي'), "PleaseSelectSupplier", 'الرجاء تحديد المورد'), "PleaseSelectStatut", 'يرجى تحديد الحالة'), "PayeBy", 'الدفع عن طريق'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "ChooseWarehouse", 'اختر المستودع'), "payNow", 'ادفع الآن'), "ListofCategory", 'قائمة الفئات'), "Description", 'وصف'), "submit", 'تأكيد'), "ProblemCreatingThisInvoice", 'حدثت مشكلة في إنشاء هذه الفاتورة. حاول مرة اخرى'), "ProblemPayment", 'كانت هناك مشكلة في الدفع. حاول مرة اخرى'), "CreateAdjustment", 'إنشاء تعديل'), "Afewwords", '... بضع كلمات عن'), "UserImage", 'صورة المستخدم'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "UpdateProduct", 'تحديث المنتج'), "Brand", 'الماركة'), "BarcodeSymbology", 'ترميز الباركود'), "ProductCost", 'تكلفة المنتج'), "ProductPrice", 'سعر المنتج'), "UnitProduct", 'منتج الوحدة'), "TaxMethod", 'الطريقة الضريبية'), "MultipleImage", 'صور متعددة'), "ProductHasMultiVariants", 'المنتج له متغيرات متعددة'), "ProductHasPromotion", 'المنتج له عرض ترويجي'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "PromotionStart", 'بدء الترويج'), "PromotionEnd", 'نهاية الترويج'), "PromotionPrice", 'سعر الترويج'), "Price", 'السعر'), "Cost", 'كلفة'), "Unit", 'وحدة'), "ProductVariant", 'متغير المنتج'), "Variant", 'متغير'), "UnitPrice", 'سعر الوحدة'), "CreateReturnCustomer", 'إنشاء إرجاع العميل'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "EditReturnCustomer", 'تحرير إرجاع العميل'), "CreateReturnSupplier", 'إنشاء إرجاع المورد'), "Documentation", 'توثيق'), "EditReturnSupplier", 'تحرير إرجاع المورد'), "FromWarehouse", 'من المستودع'), "ToWarehouse", 'إلى المستودع'), "EditTransfer", 'تحرير النقل'), "TransferDetail", 'تفاصيل النقل'), "Pending", 'قيد الانتظار'), "Received", 'تم الاستلام'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Ordered", 'طلب'), "PermissionsManager", 'مدير الأذونات'), "BrandManager", 'العلامة التجارية'), "BrandImage", 'صورة الماركة'), "BrandName", 'اسم الماركة'), "BrandDescription", 'ةصف الماركة'), "BaseUnit", 'الوحده الأساسيه'), "ManagerUnits", 'إدارة الوحدات'), "OperationValue", 'قيمة العملية'), "Operator", 'عامل'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Top5Products", 'أفضل 5 منتجات'), "Last5Sales", 'آخر 5 مبيعات'), "ListAdjustments", 'قائمة التعديلات'), "ListTransfers", 'قائمة التحويلات'), "CreateTransfer", 'إنشاء تحويل'), "OrdersManager", 'مدير الطلبات'), "ListQuotations", 'قائمة التسعيرات'), "ListPurchases", 'قائمة المشتريات'), "ListSales", 'قائمة المبيعات'), "ListReturns", 'قائمة المرتجعات'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "PeopleManager", 'إدارة الأفراد'), "ListofBrand", 'قائمة العلامة التجارية'), "Delete", {
  Title: 'هل أنت واثق؟',
  Text: ' !لن تتمكن من التراجع عن هذا',
  confirmButtonText: 'نعم ، احذفه!',
  cancelButtonText: 'إلغاء',
  Deleted: 'تم الحذف!',
  Failed: 'فشل',
  Therewassomethingwronge: 'كان هناك شيء خاطئ',
  CustomerDeleted: 'تم حذف هذا العميل',
  UserDeleted: 'تم حذف هذا المستخدم',
  SupplierDeleted: 'تم حذف هذا العميل المورد',
  QuoteDeleted: 'تم حذف هذه التسعيرة',
  SaleDeleted: 'تم حذف هذا البيع',
  PaymentDeleted: 'تم حذف هذا الدفع',
  PurchaseDeleted: 'تم حذف هذا الشراء',
  ReturnDeleted: 'تم حذف هذه المرتجعة',
  ProductDeleted: 'تم حذف هدا المنتوج',
  ClientError: 'هذا العميل مرتبط بالفعل بعملية أخرى',
  ProviderError: 'هذا المورد مرتبط بالفعل بعملية أخرى',
  UnitDeleted: 'تم حذف هذه الوحدة',
  RoleDeleted: 'تم حذف هدا الدور',
  TaxeDeleted: 'تم حذف هذه الضريبة بنجاح',
  SubCatDeleted: 'تم حذف هذا  التصنيف فرعي بنجاح',
  CatDeleted: 'تم حذف هذا التصنيف  بنجاح',
  WarehouseDeleted: 'تم حذف هذا المخزن  بنجاح',
  AlreadyLinked: 'هذا المنتج مرتبط بالفعل بعملية أخرى',
  AdjustDeleted: 'تم حذف هذا التعديل  بنجاح',
  TitleCurrency: 'تم حذف هذه العملة  بنجاح',
  TitleTransfer: 'تم حذف النقل  بنجاح',
  BackupDeleted: 'تمت إزالة النسخة الاحتياطية بنجاح',
  TitleBrand: 'تم حذف هذه العلامة التجارية'
}), "Update", (_Update = {
  TitleBrand: 'تم تحديث هذه العلامة التجارية',
  TitleSetting: 'تم تحديث الاعدادات بنجاح',
  TitleProfile: 'تم تحديث ملفك الشخصي بنجاح',
  TitleAdjust: 'تم تحديث التعديل بنجاح',
  TitleRole: 'تم تحديث الدور بنجاح',
  TitleUnit: 'تم تحديث الوحدة بنجاح',
  TitleCustomer: 'تم تحديث المستخدم بنجاح'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Update, "TitleCustomer", 'تم تحديث المستخدم بنجاح'), "TitleCustomer", 'تم تحديث العميل بنجاح'), "TitleQuote", 'تم تحديث التسعيرة بنجاح'), "TitleSale", 'تم تحديث البيع بنجاح'), "TitlePayment", 'تم تحديث الدفع بنجاح'), "TitlePurchase", 'تم تحديث الشراء بنجاح'), "TitleReturn", 'تم تحديث المرتجعة بنجاح'), "TitleProduct", 'تم تحديث المنتوج بنجاح'), "TitleSupplier", 'تم تحديث المورد بنجاح'), "TitleTaxe", 'تم تحديث الضريبة بنجاح'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_Update, "TitleCat", 'تم تحديث التصنيف بنجاح'), "TitleWarhouse", 'تم تحديث المخزن بنجاح'), "TitleCurrency", 'تم تحديث هذه العملة  بنجاح'), "TitleTransfer", 'تم تحديث النقل  بنجاح'))), "Create", (_Create = {
  TitleBrand: 'تم إنشاء هذه العلامة التجارية',
  TitleTransfer: 'تم إنشاء النقل بنجاح',
  TitleAdjust: 'تم إنشاء التعديل بنجاح',
  TitleRole: 'تم إنشاء الدور بنجاح',
  TitleUnit: 'تم إنشاء الوحدة بنجاح',
  TitleCustomer: 'تم إنشاء المستخدم بنجاح'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Create, "TitleCustomer", 'تم إنشاء العميل بنجاح'), "TitleQuote", 'تم إنشاء التسعيرة بنجاح'), "TitleSale", 'تم إنشاء البيع بنجاح'), "TitlePayment", 'تم إنشاء الدفع بنجاح'), "TitlePurchase", 'تم إنشاء الشراء بنجاح'), "TitleReturn", 'تم إنشاء المرتجعة بنجاح'), "TitleProduct", 'تم إنشاء المنتوج بنجاح'), "TitleSupplier", 'تم إنشاء المورد بنجاح'), "TitleTaxe", 'تم إنشاء الضريبة بنجاح'), "TitleCat", 'تم إنشاء التصنيف بنجاح'), _defineProperty(_defineProperty(_Create, "TitleWarhouse", 'تم إنشاء المخزن بنجاح'), "TitleCurrency", 'تم إنشاء هذه العملة  بنجاح'))), "Send", {
  TitleEmail: 'تم الارسال بنجاح'
}), "return", {
  TitleSale: 'هذا البيع مرتبط بالفعل بإرجاع'
}), "PurchasesManagement", 'إدارة المشتريات'), "Ordered", 'أمر'), "DeletePurchase", 'حذف الشراء'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "EmailPurchase", 'إرسال الشراء في البريد الإلكتروني'), "EditPurchase", 'تحرير الشراء'), "PurchaseDetail", 'تفاصيل الشراء'), "AddPurchase", 'أضف شراء'), "EmailSupplier", 'البريد الإلكتروني للمورد'), "ReturnManagement", 'إدارة المرتجعات'), "ReturnDetail", 'تفاصيل  المرتجعة'), "EditReturn", 'تحرير المرتجعة'), "AddReturn", 'إضافة مرتجعة'), "EmailReturn", 'إرسال المرتجعة في البريد الإلكتروني'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "DeleteReturn", 'حذف  المرتجعة'), "Retoursurcharge", 'تكلفة إضافية'), "Laivrison", 'التسليم'), "SelectSale", 'حدد المبيعة'), "ZeroPardefault", 'يمكنك حذف العنصر أو تعيين الكمية التي تم إرجاعها إلى الصفر إذا لم يتم إرجاعها'), "Return", 'مرتجعة'), "Purchase", 'شراء'), "PurchaseInvoice", 'مدفوعات المشتريات'), "PurchasesInvoicesData", 'بيانات مدفوعات المشتريات'), "SalesInvoice", 'مدفوعات المبيعات'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "SalesInvoicesData", 'بيانات مدفوعات المبيعات'), "TotalSales", 'إجمالي المبيعات'), "TotalPurchases", 'إجمالي المشتريات'), "TotalReturns", 'إجمالي العائدات'), "PaiementsNet", 'صافي المدفوعات'), "PaiementsSent", 'الدفعات المرسلة'), "PaiementsReceived", 'الدفعات المستلمة'), "Recieved", 'المستلمة'), "Sent", 'المرسلة'), "ProductQuantityAlerts", 'تنبيهات كمية المنتج'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "ProductCode", 'كود المنتج'), "ProductName", 'المنتج'), "AlertQuantity", 'كمية التنبيه'), "WarehouseStockChart", 'مخطط المخزون  المستودعات'), "TotalProducts", 'إجمالي المنتجات'), "TotalQuantity", 'إجمالي الكمية'), "TopCustomers", 'أفضل 5 عملاء'), "TotalAmount", 'المبلغ الإجمالي'), "TotalPaid", 'المبلغ المدفوع'), "CustomerSalesReport", 'تقرير المبيعات '), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "CustomerPaiementsReport", ' تقرير المدفوعات '), "CustomerQuotationsReport", 'تقرير عروض أسعار '), "Payments", 'المدفوعات'), "TopSuppliers", 'أفضل 5 الموردين'), "SupplierPurchasesReport", 'تقرير المشتريات '), "SupplierPaiementsReport", 'تقرير المدفوعات '), "Name", 'اسم'), "Code", 'الكود'), "ManagementWarehouse", 'إدارة المستودعات'), "ZipCode", 'الرمز البريدي'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "managementCategories", 'إدارة التصنيفات'), "Codecategorie", 'رمز الفئة'), "Namecategorie", 'اسم الفئة'), "Parentcategorie", 'اصل الفئة'), "managementTax", 'إدارة الضرائب'), "TaxName", 'اسم الضريبة'), "TaxRate", 'معدل الضريبة'), "managementUnitPurchases", 'إدارة وحدة المشتريات'), "managementUnitSales", 'إدارة وحدة المبيعات'), "ShortName", 'اسم قصير'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "PleaseSelectThesebeforeaddinganyproduct", 'يرجى تحديد هذه قبل إضافة أي منتج'), "StockAdjustement", 'تعديل المخزون'), "PleaseSelectWarehouse", 'يرجى تحديد المستودع قبل اختيار أي منتج'), "StockTransfer", 'تحويل المخزون'), "Today", 'اليوم'), "SelectPeriod", 'حدد الفترة'), "ThisToday", 'هذا اليوم'), "ThisYear", 'هذا العام'), "ThisMonth", 'هذا الشهر'), "ThisWeek", 'هذا الاسبوع'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "AdjustmentDetail", 'تفاصيل التعديل'), "ActivateUser", 'تم تنشيط هذا المستخدم'), "DisActivateUser", 'تم إلغاء تنشيط هذا المستخدم'), "NotFound", 'الصفحة غير موجودة.'), "oops", 'خطأ! الصفحة غير موجودة.'), "couldNotFind", 'لم نتمكن من العثور على الصفحة التي تبحث عنها ، وفي الوقت نفسه ، يمكنك ذلك'), "ReturnDashboard", 'العودة إلى لوحة القيادة'), "hrm", 'إدارة الموارد البشرية'), "Employees", 'الموظفين'), "Attendance", 'الحضور'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Leave_request", 'طلب إجازة'), "Leave_type", 'نوع الإجازة'), "Company", 'الشركة'), "Departments", 'الإدارات'), "Designations", 'التعيينات'), "Office_Shift", 'مكتب التحول'), "Holidays", 'العطل'), "Enter_Company_Name", 'ادخل اسم الشركة'), "Enter_email_address", 'أدخل عنوان البريد الالكتروني'), "Enter_Company_Phone", 'أدخل رقم هاتف الشركة'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Enter_Company_Country", 'أدخل بلد الشركة'), "Created_in_successfully", 'تم إنشاؤه بنجاح'), "Updated_in_successfully", 'تم التحديث بنجاح'), "Deleted_in_successfully", 'تم الحذف بنجاح'), "department", 'إدارة'), "Enter_Department_Name", 'أدخل اسم الإدارة'), "Choose_Company", 'اختر الشركة'), "Department_Head", 'رئيس القسم'), "Choose_Department_Head", 'اختر رئيس القسم'), "Enter_Shift_name", 'أدخل اسم التحول'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Monday_In", 'الاثنين من'), "Monday_Out", 'الاثنين الى'), "Tuesday_In", 'الثلاثاء من'), "tuesday_out", 'الثلاثاء الى'), "wednesday_in", 'الأربعاء من'), "wednesday_out", 'الأربعاء الى'), "thursday_in", 'الخميس الى'), "thursday_out", 'الخميس الى'), "friday_in", 'الجمعة من'), "friday_out", 'الجمعة الى'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "saturday_in", 'السبت من'), "saturday_out", 'السبت الى'), "sunday_in", 'الأحد من'), "sunday_out", 'الأحد الى'), "Holiday", 'الاجازة'), "Enter_title", 'أدخل العنوان'), "title", 'العنوان'), "start_date", 'تاريخ البداية'), "Enter_Start_date", 'أدخل تاريخ البدء'), "Finish_Date", 'تاريخ الانتهاء'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Enter_Finish_date", 'أدخل تاريخ الانتهاء'), "Please_provide_any_details", 'يرجى تقديم أي تفاصيل'), "Attendances", 'الحضور'), "Enter_Attendance_date", 'أدخل تاريخ الحضور'), "Time_In", 'وقت الدخول'), "Time_Out", 'وقت الخروج'), "Choose_Employee", 'اختر الموظف'), "Employee", 'الموظف'), "Work_Duration", 'مدة العمل'), "remaining_leaves_are_insufficient", 'الإجازات المتبقية غير كافية'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Leave_Type", 'نوع الإجازة'), "Days", 'الأيام'), "Department", 'إدارة'), "Choose_leave_type", 'اختر نوع الإجازة'), "Choose_status", 'اختر الحالة'), "Leave_Reason", 'سبب الإجازة'), "Enter_Reason_Leave", 'أدخل سبب الإجازة'), "Add_Employee", 'اضافة موظف'), "FirstName", 'الاسم الأول'), "Enter_FirstName", 'أدخل الاسم الأول'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "LastName", 'الاسم الاخير'), "Enter_LastName", 'أدخل الاسم الأخير'), "Gender", 'الجنس'), "Choose_Gender", 'اختر الجنس'), "Enter_Birth_date", 'أدخل تاريخ الميلاد'), "Birth_date", 'تاريخ الولادة'), "Enter_Country", 'أدخل الدولة'), "Enter_Phone_Number", 'أدخل رقم الهاتف'), "joining_date", 'تاريخ الانضمام'), "Enter_joining_date", 'أدخل تاريخ الانضمام'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Choose_Designation", 'اختر التعيين'), "Designation", 'التعيين'), "Office_Shift", 'مكتب التحول'), "Choose_Office_Shift", 'اختر مكتب التحول'), "Enter_Leaving_Date", 'أدخل تاريخ المغادرة'), "Leaving_Date", 'تاريخ المغادرة'), "Annual_Leave", 'الإجازة السنوية'), "Enter_Annual_Leave", 'أدخل الإجازة السنوية'), "Remaining_leave", 'الاجازة المتبقية'), "Employee_Details", 'تفاصيل الموظف'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Basic_Information", 'معلومات اساسية'), "Family_status", 'الوضع العائلي'), "Choose_Family_status", 'اختر الحالة العائلية'), "Employment_type", 'نوع الوظيفة'), "Select_Employment_type", 'حدد نوع التوظيف'), "Enter_City", 'أدخل المدينة'), "Province", 'مقاطعة'), "Enter_Province", 'أدخل المقاطعة'), "Enter_Address", 'أدخل العنوان'), "Enter_Zip_code", 'أدخل الرمز البريدي'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Zip_code", 'الرمز البريدي'), "Hourly_rate", 'السعر بالساعة'), "Enter_Hourly_rate", 'أدخل سعر الساعة'), "Basic_salary", 'الراتب الاساسي'), "Enter_Basic_salary", 'أدخل الراتب الأساسي'), "Social_Media", 'وسائل التواصل الاجتماعي'), "Skype", 'سكايب'), "Enter_Skype", 'أدخل سكايب'), "Facebook", 'فيسبوك'), "Enter_Facebook", 'أدخل الفيسبوك'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "WhatsApp", 'واتس اب'), "Enter_WhatsApp", 'أدخل واتسآب'), "LinkedIn", 'لينكد إن'), "Enter_LinkedIn", 'أدخل لينكد إن'), "Twitter", 'تويتر'), "Enter_Twitter", 'أدخل تويتر'), "Experiences", 'الخبرات'), "bank_account", 'حساب البنك'), "Company_Name", 'اسم الشركة'), "Location", 'الموقع'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Enter_location", 'أدخل الموقع'), "Enter_Description", 'أدخل الوصف'), "Bank_Name", 'اسم البنك'), "Enter_Bank_Name", 'أدخل اسم البنك'), "Bank_Branch", 'فرع البنك'), "Enter_Bank_Branch", 'أدخل فرع البنك'), "Bank_Number", 'رقم البنك'), "Enter_Bank_Number", 'أدخل رقم البنك'), "Assigned_warehouses", 'المخازن المخصصة'), "Top_customers", 'أفضل العملاء'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Attachment", 'المرفق'), "view_employee", 'مشاهدة الموظفين'), "edit_employee", 'تحرير الموظفين'), "delete_employee", 'حذف الموظفين'), "Created_by", 'تمت الإضافة بواسطة'), "Add_product_IMEI_Serial_number", 'أضف الرقم التسلسلي للمنتج'), "Product_Has_Imei_Serial_number", 'المنتج له رقم تسلسلي'), "IMEI_SN", 'الرقم التسلسلي'), "Shipments", 'الشحنات'), "delivered_to", 'سلمت إلى'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "shipment_ref", 'مرجع الشحنة'), "sale_ref", 'المرجع للبيع'), "Edit_Shipping", 'تحرير الشحن'), "Packed", 'معبأة'), "Shipped", 'تم الشحن'), "Delivered", 'تم التوصيل'), "Cancelled", 'ألغيت'), "Shipping_status", 'حالة الشحن'), "Users_Report", 'تقرير المستخدمين'), "stock_report", 'تقرير المخزون'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "TotalPurchases", 'إجمالي المشتريات'), "Total_quotations", 'إجمالي عروض الأسعار'), "Total_return_sales", 'إجمالي عوائد المبيعات'), "Total_return_purchases", 'إجمالي عوائد المشتريات'), "Total_transfers", 'إجمالي التحويلات'), "Total_adjustments", 'إجمالي التعديلات'), "User_report", 'تقرير المستخدم'), "Current_stock", 'المخزون الحالي'), "product_name", 'اسم المنتج'), "Total_Customers_Due", 'إجمالي الديون'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Total_Suppliers_Due", 'إجمالي الديون'), "Some_warehouses", 'بعض المستودعات'), "All_Warehouses", 'جميع المستودعات'), "Product_Cost", 'تكلفة المنتج'), "sms_settings", 'إعدادات الرسائل القصيرة'), "pos_settings", 'إعدادات نقاط البيع'), "payment_gateway", 'بوابة الدفع'), "mail_settings", 'إعدادات البريد'), "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Default_SMS_Gateway", 'بوابة الرسائل القصيرة الافتراضية'), "module_settings", 'إعدادات الوحدة'), "Module_enabled_success", 'تم تفعيل الوحدة بنجاح'), "Module_Disabled_success", 'تم تعطيل الوحدة النمطية بنجاح'), "update_settings", 'إعدادات التحديث'), "Please_Upload_the_Correct_Module", 'يرجى تحميل الوحدة الصحيحة'), "Uploaded_Success", 'تم الرفع بنجاح'), "Customer_details", 'تفاصيل العميل'), "Edit_Customer", 'تحرير العميل'), "Delete_Customer", 'حذف العميل'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Pay_Due", 'الدفع المستحق'), "Paying_amount_is_greater_than_Total_Due", 'مبلغ الدفع أكبر من إجمالي المبلغ المستحق'), "Customer_Invoice", 'فاتورة العميل'), "This_Product_Not_For_Selling", 'هذا المنتج ليس للبيع'), "Welcome_to_your_Dashboard", 'مرحبًا بك في لوحة التحكم'), "Total_Payable", 'إجمالي الدفع'), "Choose_Sale_Ref", 'اختر مرجع البيع'), "Please_Select_Sale", 'يرجى تحديد البيع'), "Sale_Ref", 'مرجع البيع'), "list_product_returns", 'قائمة المنتجات المرتجعة'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Qty_return", 'إرجاع الكمية'), "Choose_Purchase_Ref", 'اختر مرجع الشراء'), "Purchase_Ref", 'مرجع الشراء'), "please_select_purchase", 'يرجى تحديد شراء'), "qty_return_is_greater_than_qty_purchased", 'الكمية المرتجعة أكبر من الكمية المشتراة'), "qty_return_is_greater_than_qty_sold", 'الكمية المرتجعة أكبر من الكمية المباعة'), "Quantity_sold", 'الكمية المباعة'), "qty_purchased", 'الكمية المشتراة'), "Sender_Name", 'اسم المرسل'), "Upload_Module", 'تحميل الوحدة'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "The_module_must_be_uploaded_as_zip_file", 'يجب تحميل الوحدة كملف مضغوط'), "Upload_Module", 'تحميل الوحدة'), "All_Modules_Installed", 'جميع الوحدات المثبتة'), "Current_Version", 'النسخة الحالية'), "You_already_have_the_latest_version", 'لديك بالفعل أحدث إصدار'), "Update_Available", 'التحديث متاح'), "Update_Log", 'سجل التحديث'), "Update_Now", 'تحديث الان'), "View_Change_Log", 'مشاهدة سجل التغيير'), "invoice_footer", 'تذييل الفاتورة'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Please_Wait_for_the_update", 'ملاحظة: يرجى انتظار انتهاء التحديث تمامًا. لا يوصى بإغلاق المتصفح أو إيقاف عملية الترقية'), "Note_update", 'ملاحظة: تأكد من الاحتفاظ بنسخة احتياطية من الإصدار الحالي وقاعدة البيانات قبل تشغيل الترقية ، لاستعادتها إذا كان هناك خطأ'), "Time_Zone", 'المنطقة الزمنية'), "Payment_note", 'ملاحظات الدفع'), "sale_note", 'ملاحظات البيع'), "Total_Sale_Due", 'إجمالي ديون البيع'), "Total_Sell_Return_Due", 'إجمالي الديون عائد البيع'), "pay_all_sell_due_at_a_time", 'دفع جميع ديون البيع في وقت واحد'), "pay_all_sell_return_due_at_a_time", 'دفع جميع ديون عائد البيع في وقت واحد'), "Gross_Profit", 'اجمالي الربح'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "pay_all_purchase_due_at_a_time", 'دفع جميع ديون الشراء في وقت واحد'), "Delete_Provider", 'حذف المورد'), "Edit_Provider", 'تحرير المورد'), "Provider_details", 'تفاصيل المورد'), "Total_Purchase_Due", 'إجمالي ديون الشراء'), "Provider_Credit_Note", 'إشعار ائتمان المورد'), "Customer_Credit_Note", 'إشعار ائتمان العميل'), "Sell_Return", 'عائد بيع'), "Purchase_Return", 'إرجاع الشراء'), "Tax_Number", 'الرقم الضريبي'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Please_add_return_quantity", 'الرجاء إضافة الكمية المرتجعة'), "Return_exist_for_the_Transaction", 'العودة موجودة في هذه الصفقة'), "qty_return_is_greater_than_Quantity_Remaining", 'الكمية المرتجعة أكبر من الكمية المتبقية'), "products_refunded_alert", 'لن يتم رد أي منتجات ذات كمية محددة على 0'), "pay_all_purchase_return_due_at_a_time", 'دفع جميع ديون عوائد الشراء في وقت واحد'), "Total_Purchase_Return_Due", 'إجمالي ديون عوائد الشراء'), "Purchase_return_due", 'ديون عوائد الشراء'), "Sell_return_due", 'ديون عوائد البيع'), "product_report", 'تقرير المنتجات'), "product_sales_report", 'تقرير مبيعات المنتج'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Product_purchases_report", 'تقرير مشتريات المنتج'), "Qty_sold", 'الكمية المباعة'), "Qty_purchased", 'الكمية المشتراة'), "Filter_by_warehouse", 'تصفية بالمستودع'), "Enable_Print_Invoice", 'قم بتمكين طباعة الفاتورة تلقائيًا'), "Show_Warehouse", 'عرض المستودع'), "credit_card_info", 'معلومات بطاقة الائتمان'), "Saved_Credit_Card_Info", 'معلومات بطاقة الائتمان المحفوظة'), "Credit_card_changed_successfully", 'تم تغيير بطاقة الائتمان بنجاح'), "notification_template", 'قالب الإشعارات'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "email_notification", 'إشعار بالبريد الإلكتروني'), "sms_notification", 'إشعار بالرسائل القصيرة (SMS)'), "Change_product_details", 'تغيير تفاصيل المنتج'), "edit_tax_and_discount_and_shipping", 'تحرير الضرائب والخصومات والشحن'), "Create_Quotation_with_Stock", 'إنشاء عرض أسعار مع الأسهم'), "Variant_Name", 'اسم المتغير'), "Variant_cost", 'تكلفة المتغير'), "Variant_price", 'سعر المتغير'), "Variant_code", 'رمز المتغير'), "Please_wait_until_the_product_is_loaded", 'يرجى الانتظار حتى يتم تحميل المنتج'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Pos_Settings$Receipt, "Choose_SMS_Gateway", 'اختر بوابة SMS'), "Notification_Client", 'إشعار العميل'), "Available_Tags", 'العلامات المتاحة'), "Email_Subject", 'عنوان البريد الإلكتروني'), "Email_body", 'محتوى البريد الإلكتروني'), "Notification_Supplier", 'إشعار المورد'), "sms_body", 'محتوى الرسالة القصيرة (SMS)'), "sms_templates", 'قوالب الرسائل القصيرة'), "email_templates", 'قوالب البريد الإلكتروني'));

/***/ }),

/***/ "./resources/src/translations/locales/ba.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/ba.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language bangla

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'রসিদ',
  Pos_Settings: 'পদ সেটিংস (রসিদ)',
  Note_to_customer: 'গ্রাহককে নোট করুন',
  Show_Note_to_customer: 'গ্রাহককে নোট দেখান',
  Show_barcode: 'বারকোড দেখান',
  Show_Tax_and_Discount: 'ট্যাক্স এবং ডিসকাউন্ট এবং শিপিং দেখান',
  Show_Customer: 'গ্রাহক দেখান',
  Show_Email: 'ইমেইল দেখান',
  Show_Phone: 'ফোন দেখান',
  Show_Address: 'ঠিকানা দেখান',
  DefaultLanguage: 'নির্ধারিত ভাষা',
  footer: 'ফুটার',
  Received_Amount: 'প্রাপ্তির পরিমাণ',
  Paying_Amount: 'পরিশোধের পরিমাণ',
  Change: 'রিটার্ন পরিবর্তন',
  Paying_amount_is_greater_than_Received_amount: 'পরিশোধের পরিমাণ প্রাপ্ত পরিমাণের চেয়ে বেশি',
  Paying_amount_is_greater_than_Grand_Total: 'অর্থপ্রদানের পরিমাণ গ্র্যান্ড মোটের চেয়ে বেশি',
  code_must_be_not_exist_already: 'কোড ইতিমধ্যে বিদ্যমান না থাকা আবশ্যক',
  You_will_find_your_backup_on: 'আপনি আপনার ব্যাকআপ পাবেন',
  and_save_it_to_your_pc: 'এবং আপনার পিসিতে সংরক্ষণ করুন',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'আপনার বারকোড স্ক্যান করুন এবং নীচের সঠিক সিম্বলজি নির্বাচন করুন',
  Scan_Search_Product_by_Code_Name: 'কোড বা নাম দ্বারা পণ্য স্ক্যান/অনুসন্ধান করুন',
  Paper_size: 'কাগজের আকার',
  Clear_Cache: 'ক্যাশে সাফ করুন',
  Cache_cleared_successfully: 'ক্যাশে সফলভাবে সাফ করা হয়েছে৷',
  Failed_to_clear_cache: 'ক্যাশে সাফ করতে ব্যর্থ হয়েছে৷',
  Scan_Barcode: 'বারকোড স্ক্যানার',
  Please_use_short_name_of_unit: 'অনুগ্রহ করে ইউনিটের সংক্ষিপ্ত নাম ব্যবহার করুন',
  DefaultCustomer: 'ডিফল্ট গ্রাহক',
  DefaultWarehouse: 'ডিফল্ট গুদাম',
  Payment_Gateway: 'পেমেন্ট গেটওয়ে',
  SMS_Configuration: 'এসএমএস কনফিগারেশন',
  Gateway: 'এসএমএস গেটওয়ে',
  Choose_Gateway: 'এসএমএস গেটওয়ে নির্বাচন করুন',
  Send_SMS: 'বার্তা সফলভাবে পাঠানো হয়েছে',
  sms_config_invalid: 'ভুল এসএমএস কনফিগারেশন অবৈধ',
  Remove_Stripe_Key_Secret: 'স্ট্রাইপ এপিআই কী মুছুন',
  credit_card_account_not_available: 'ক্রেডিট কার্ড অ্যাকাউন্ট উপলব্ধ নেই',
  Credit_Card_Info: 'ক্রেডিট কার্ড তথ্য',
  developed_by: 'দ্বারা বিকশিত',
  Unit_already_linked_with_sub_unit: 'ইউনিট ইতিমধ্যে সাব ইউনিটের সাথে লিঙ্ক করা হয়েছে৷',
  Total_Items_Quantity: 'মোট আইটেম এবং পরিমাণ',
  Value_by_Cost_and_Price: 'খরচ এবং মূল্য',
  Search_this_table: 'এই টেবিল অনুসন্ধান করুন',
  import_products: 'পণ্য আমদানি করুন',
  Field_optional: 'ক্ষেত্র ঐচ্ছিক',
  Download_exemple: 'উদাহরণ ডাউনলোড করুন',
  field_must_be_in_csv_format: 'ক্ষেত্র অবশ্যই csv ফরম্যাটে হতে হবে',
  Successfully_Imported: 'সফলভাবে আমদানি করা হয়েছে',
  file_size_must_be_less_than_1_mega: 'ফাইলের আকার 1 মেগা থেকে কম হতে হবে',
  Please_follow_the_import_instructions: 'আমদানি নির্দেশাবলী অনুসরণ করুন',
  must_be_exist: 'ইউনিট ইতিমধ্যে তৈরি করতে হবে',
  Import_Customers: 'গ্রাহকদের আমদানি করুন',
  Import_Suppliers: 'আমদানি সরবরাহকারী',
  Recent_Sales: 'সাম্প্রতিক বিক্রয়',
  Create_Transfer: 'ট্রান্সফার তৈরি করুন',
  order_products: 'অর্ডার আইটেম',
  Search_Product_by_Code_Name: 'কোড বা নাম দ্বারা পণ্য অনুসন্ধান করুন',
  Reports_payments_Purchase_Return: 'রিপোর্ট ক্রয় রিটার্ন পেমেন্ট',
  Reports_payments_Sale_Return: 'রিপোর্ট বিক্রয় রিটার্ন পেমেন্ট',
  payments_Sales_Return: 'পেমেন্ট বিক্রয় রিটার্ন',
  payments_Purchases_Return: 'পেমেন্ট ক্রয় রিটার্ন',
  CreateSaleReturn: 'বিক্রয় রিটার্ন তৈরি করুন',
  EditSaleReturn: 'বিক্রয় রিটার্ন সম্পাদনা করুন',
  SalesReturn: 'বিক্রয় রিটার্ন',
  CreatePurchaseReturn: 'ক্রয় রিটার্ন তৈরি করুন',
  EditPurchaseReturn: 'ক্রয় রিটার্ন সম্পাদনা করুন',
  PurchasesReturn: 'ক্রয় রিটার্ন',
  Due: 'বাকি',
  Profit: 'লাভ',
  Revenue: 'রাজস্ব',
  Sales_today: 'আজ সেলস',
  People: 'মানুষ',
  Successfully_Created: 'সফলভাবে তৈরি',
  Successfully_Updated: 'সফলভাবে আপডেট',
  Success: 'সফলতা',
  Failed: 'ব্যর্থ হয়েছে',
  Warning: 'সতর্কবাণী',
  Please_fill_the_form_correctly: 'অনুগ্রহ করে ফর্মটি সঠিকভাবে পূরণ করুন',
  Field_is_required: 'এই ক্ষেত্র প্রয়োজন',
  Error: 'ত্রুটি!',
  you_are_not_authorized: 'দুঃখিত! আপনি অনুমোদিত নন।',
  Go_back_to_home: 'হোমপেজে ফিরে যান',
  page_not_exist: 'দুঃখিত! আপনি যে পৃষ্ঠাটি খুঁজছিলেন সেটি বিদ্যমান নেই৷',
  Choose_Status: 'স্থিতি চয়ন করুন',
  Choose_Method: 'পদ্ধতি বেছে নিন',
  Choose_Symbology: 'প্রতীকবিদ্যা চয়ন করুন',
  Choose_Category: 'বিভাগ চয়ন করুন',
  Choose_Customer: 'গ্রাহক চয়ন করুন',
  Choose_Supplier: 'সরবরাহকারী চয়ন করুন',
  Choose_Unit_Purchase: 'ক্রয় ইউনিট নির্বাচন করুন',
  Choose_Sub_Category: 'উপশ্রেণী নির্বাচন করুন',
  Choose_Brand: 'ব্র্যান্ড চয়ন করুন',
  Choose_Warehouse: 'ওয়্যারহাউস বেছে নিন',
  Choose_Unit_Sale: 'বিক্রয় ইউনিট নির্বাচন করুন',
  Enter_Product_Cost: 'পণ্য খরচ লিখুন',
  Enter_Stock_alert: 'স্টক সতর্কতা প্রবেশ করুন',
  Choose_Unit_Product: 'পণ্য ইউনিট চয়ন করুন',
  Enter_Product_Price: 'পণ্যের দাম লিখুন',
  Enter_Name_Product: 'পণ্যের নাম লিখুন',
  Enter_Role_Name: 'ভূমিকার নাম লিখুন',
  Enter_Role_Description: 'ভূমিকার বর্ণনা লিখুন',
  Enter_name_category: 'ক্যাটাগরির নাম লিখুন',
  Enter_Code_category: 'ক্যাটাগরি কোড লিখুন',
  Enter_Name_Brand: 'নাম ব্র্যান্ড লিখুন',
  Enter_Description_Brand: 'বিবরণ ব্র্যান্ড লিখুন',
  Enter_Code_Currency: 'কোড মুদ্রা লিখুন',
  Enter_name_Currency: 'নাম মুদ্রা লিখুন',
  Enter_Symbol_Currency: 'প্রতীক মুদ্রা লিখুন',
  Enter_Name_Unit: 'ইউনিটের নাম লিখুন',
  Enter_ShortName_Unit: 'সংক্ষিপ্ত নাম ইউনিট লিখুন',
  Choose_Base_Unit: 'বেস ইউনিট চয়ন করুন',
  Choose_Operator: 'অপারেটর চয়ন করুন',
  Enter_Operation_Value: 'অপারেশন মান লিখুন',
  Enter_Name_Warehouse: 'গুদাম নাম লিখুন',
  Enter_Phone_Warehouse: 'ওয়্যারহাউস ফোন লিখুন',
  Enter_Country_Warehouse: 'গুদাম দেশ লিখুন',
  Enter_City_Warehouse: 'ওয়্যারহাউস সিটিতে প্রবেশ করুন',
  Enter_Email_Warehouse: 'গুদাম ইমেল লিখুন',
  Enter_ZipCode_Warehouse: 'গুদাম জিপ কোড লিখুন',
  Choose_Currency: 'মুদ্রা পছন্দ করুন',
  Thank_you_for_your_business: 'আমাদের সাথে কেনাকাটা করার জন্য আপনাকে ধন্যবাদ . অনুগ্রহ করে আবার আসবেন',
  Cancel: 'বাতিল করুন',
  New_Customer: 'নতুন গ্রাহক',
  Incorrect_Login: 'ভুল লগইন',
  Successfully_Logged_In: 'সফলভাবে লগ ইন',
  This_user_not_active: 'এই ব্যবহারকারী সক্রিয় নয়',
  SignIn: 'সাইন ইন করুন',
  Create_an_account: 'একটি অ্যাকাউন্ট তৈরি করুন',
  Forgot_Password: 'পাসওয়ার্ড ভুলে গেছেন ?',
  Email_Address: 'ইমেইল ঠিকানা',
  SignUp: 'সাইন আপ করুন',
  Already_have_an_account: 'ইতিমধ্যে একটি একাউন্ট আছে ?',
  Reset_Password: 'পাসওয়ার্ড রিসেট করুন',
  Failed_to_authenticate_on_SMTP_server: 'মেল সার্ভারে প্রমাণীকরণ করতে ব্যর্থ হয়েছে৷',
  We_cant_find_a_user_with_that_email_addres: 'আমরা সেই ইমেল ঠিকানা সহ একজন ব্যবহারকারী খুঁজে পাচ্ছি না',
  We_have_emailed_your_password_reset_link: 'আমরা আপনার পাসওয়ার্ড রিসেট লিঙ্ক ই-মেইল করেছি',
  Please_fill_the_Email_Adress: 'অনুগ্রহ করে ইমেল ঠিকানা পূরণ করুন',
  Confirm_password: 'পাসওয়ার্ড নিশ্চিত করুন',
  Your_Password_has_been_changed: 'আপনার পাসওয়ার্ড পরিবর্তন করা হয়েছে',
  The_password_confirmation_does_not_match: 'পাসওয়ার্ড নিশ্চিতকরণ মেলে না',
  This_password_reset_token_is_invalid: 'এই পাসওয়ার্ড রিসেট টোকেন অবৈধ',
  Warehouse_report: 'গুদাম রিপোর্ট',
  All_Warehouses: 'সমস্ত গুদাম',
  Expense_List: 'সমস্ত ব্যয়',
  Expenses: 'ব্যয়',
  This_Week_Sales_Purchases: 'এই সপ্তাহে বিক্রয় এবং ক্রয়',
  Top_Selling_Products: 'শীর্ষ বিক্রয় পণ্য',
  View_all: 'সব দেখ',
  Payment_Sent_Received: 'পেমেন্ট পাঠানো এবং প্রাপ্ত',
  Filter: 'ছাঁকনি',
  Invoice_POS: 'চালান POS',
  Invoice: 'চালান',
  Customer_Info: 'গ্রাহক তথ্য',
  Company_Info: 'কোম্পানির তথ্য',
  Invoice_Info: 'চালান তথ্য',
  Order_Summary: 'অর্ডার সারাংশ',
  Quote_Info: 'কোটেশন তথ্য',
  Del: 'মুছে ফেলা',
  SuppliersPaiementsReport: 'সরবরাহকারী পেমেন্ট রিপোর্ট',
  Purchase_Info: 'ক্রয় তথ্য',
  Supplier_Info: 'সরবরাহকারীর তথ্য',
  Return_Info: 'প্রত্যাবর্তনের তথ্য',
  Expense_Category: 'বিভাগ',
  Create_Expense: 'ব্যয় তৈরি করুন',
  Details: 'বিস্তারিত',
  Discount_Method: 'ডিসকাউন্ট টাইপ',
  Net_Unit_Cost: 'নেট ইউনিট খরচ',
  Net_Unit_Price: 'নেট ইউনিট মূল্য',
  Edit_Expense: 'ব্যয় সম্পাদনা করুন',
  All_Brand: 'সমস্ত ব্র্যান্ড',
  All_Category: 'সমস্ত বিভাগ',
  ListExpenses: 'সমস্ত খরচ',
  Create_Permission: 'অনুমতি তৈরি করুন',
  Edit_Permission: 'সম্পাদনা অনুমতি',
  Reports_payments_Sales: 'পেমেন্ট বিক্রয় রিপোর্ট',
  Reports_payments_Purchases: 'রিপোর্ট পেমেন্ট ক্রয়',
  Reports_payments_Return_Customers: 'পেমেন্ট রিটার্ন গ্রাহকদের',
  Reports_payments_Return_Suppliers: 'পেমেন্ট রিটার্ন সরবরাহকারী',
  Expense_Deleted: 'এই ব্যয় মুছে ফেলা হয়েছে',
  Expense_Updated: 'এই ব্যয় আপডেট করা হয়েছে',
  Expense_Created: 'এই ব্যয় তৈরি করা হয়েছে',
  DemoVersion: 'আপনি ডেমো সংস্করণে এটি করতে পারবেন না',
  OrderStatistics: 'বিক্রয় পরিসংখ্যান',
  AlreadyAdd: 'এই পণ্য ইতিমধ্যে যোগ করা হয়েছে!!',
  AddProductToList: 'তালিকায় পণ্য যোগ করুন!',
  AddQuantity: 'অনুগ্রহ করে পণ্যের পরিমাণ যোগ করুন !!',
  InvalidData: 'অবৈধ তথ্য !!',
  LowStock: 'পরিমাণ স্টক উপলব্ধ পরিমাণ অতিক্রম',
  WarehouseIdentical: 'দুটি গুদাম একই হতে পারে না!!',
  VariantDuplicate: 'এই ভেরিয়েন্টটি ডুপ্লিকেট!!',
  Filesize: 'ফাইলের আকার',
  GenerateBackup: 'ব্যাকআপ জেনারেট করুন',
  BackupDatabase: 'ব্যাকআপ ডাটাবেস',
  Backup: 'ব্যাকআপ',
  Paid: 'পরিশোধিত পরিমাণ',
  Unpaid: 'অবৈতনিক',
  Today: 'আজ',
  Income: 'আয়'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'ব্যয়'), "Sale", 'বিক্রয়'), "Actif", 'সক্রিয়'), "Inactif", 'নিষ্ক্রিয়'), "Customers", 'গ্রাহকদের'), "Phone", 'ফোন'), "SearchByPhone", 'ফোন দ্বারা অনুসন্ধান করুন'), "Suppliers", 'সরবরাহকারীদের'), "Quotations", 'কোটেশন'), "Sales", 'সেলস'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'কেনাকাটা'), "Returns", 'প্রত্যাবর্তন'), "Settings", 'সেটিংস'), "SystemSettings", 'সিস্টেম সেটিংস'), "Users", 'ব্যবহারকারীদের'), "GroupPermissions", 'গ্রুপ অনুমতি'), "Currencies", 'কারেন্সি'), "Warehouses", 'গুদাম'), "Units", 'ইউনিট'), "UnitsPrchases", 'ক্রয় ইউনিট'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'বিক্রয় ইউনিট'), "Reports", 'রিপোর্ট'), "PaymentsReport", 'পেমেন্ট রিপোর্ট'), "PaymentsPurchases", 'পেমেন্ট ক্রয়'), "PaymentsSales", 'পেমেন্ট বিক্রয়'), "ProfitandLoss", 'লাভ এবং ক্ষতি'), "WarehouseStockChart", 'গুদাম স্টক চার্ট'), "SalesReport", 'বিক্রয় প্রতিবেদন'), "PurchasesReport", 'Purchase Reportক্রয় প্রতিবেদন'), "CustomersReport", 'গ্রাহক রিপোর্ট'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'সরবরাহকারী রিপোর্ট'), "SupplierReport", 'সরবরাহকারী রিপোর্ট'), "DailySalesData", 'দৈনিক বিক্রয় ডেটা'), "DailyPurchasesData", 'দৈনিক ক্রয় ডেটা'), "Derni\xE8rescinqrecords", 'সর্বশেষ পাঁচটি রেকর্ড'), "Filters", 'ফিল্টার'), "date", 'তারিখ'), "Reference", 'উল্লেখ'), "Supplier", 'সরবরাহকারী'), "PaymentStatus", 'পরিশোধের হাল'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", 'গ্রাহক'), "CustomerCode", 'গ্রাহক কোড'), "Status", 'স্ট্যাটাস'), "SupplierCode", 'সরবরাহকারী কোড'), "Categorie", 'ক্যাটাগরি'), "Categories", 'ক্যাটাগরি'), "StockTransfers", 'স্থানান্তর'), "StockManagement", 'স্টক ব্যবস্থাপনা'), "dashboard", 'ড্যাশবোর্ড'), "Products", 'পণ্য'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'সব পণ্য'), "ProductManagement", 'পণ্য ব্যবস্থাপনা'), "ProductQuantityAlerts", 'পণ্য পরিমাণ সতর্কতা'), "CodeProduct", 'কোড পণ্য'), "ProductTax", 'গুণফল ট্যাক্স'), "SubCategorie", 'সাব ক্যাটাগরি'), "Name_product", 'নাম'), "StockAlert", 'স্টক সতর্কতা'), "warehouse", 'গুদাম'), "Tax", 'ট্যাক্স'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'ক্রয় মূল্য'), "SellPrice", 'বিক্রয় মূল্য'), "Quantity", 'পরিমান'), "UnitSale", 'বিক্রয় ইউনিট'), "UnitPurchase", 'ক্রয় ইউনিট'), "ManagementCurrencies", 'মুদ্রা ব্যবস্থাপনা'), "CurrencyCode", 'মুদ্রা কোড'), "CurrencyName", 'মুদ্রার নাম'), "Symbol", 'প্রতীক'), "All", 'সব'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", 'পণ্য সম্পাদনা করুন'), "SearchByCode", 'কোড দ্বারা অনুসন্ধান করুন'), "SearchByName", 'নাম দ্বারা অনুসন্ধান'), "ProductDetails", 'পণ্যের বিবরণ'), "CustomerName", 'গ্রাহকের নাম'), "CustomerManagement", 'গ্রাহক ব্যবস্থাপনা'), "Add", 'তৈরি করুন'), "add", 'তৈরি করুন'), "Edit", 'সম্পাদনা'), "Close", 'ঘনিষ্ঠ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'অনুগ্রহ করে নির্বাচন করুন'), "Action", 'কর্ম'), "Email", 'ইমেইল'), "EditCustomer", 'গ্রাহক সম্পাদনা করুন'), "AddCustomer", 'গ্রাহক তৈরি করুন'), "Country", 'দেশ'), "City", 'শহর'), "Adress", 'ঠিকানা'), "CustomerDetails", 'গ্রাহক বিবরণ'), "CustomersList", 'গ্রাহকদের'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'সরবরাহকারী কোড'), "SupplierName", 'সরবরাহকারী নাম'), "SuppliersManagement", 'সরবরাহকারী ব্যবস্থাপনা'), "SupplierDetails", 'সরবরাহকারীর বিবরণ'), "QuotationsManagement", 'কোটেশন ম্যানেজমেন্ট'), "SubTotal", 'সাবটোটাল'), "MontantReste", 'পরিমাণ বাকি'), "complete", 'সম্পন্ন'), "EnAttendant", 'বিচারাধীন'), "Recu", 'গৃহীত'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", 'আংশিক'), "Retournee", 'প্রত্যাবর্তন'), "DetailQuote", 'বিস্তারিত উদ্ধৃতি'), "EditQuote", 'উদ্ধৃতি সম্পাদনা করুন'), "CreateSale", 'বিক্রয় তৈরি করুন'), "DownloadPdf", 'পিডিএফ ডাউনলোড করুন'), "QuoteEmail", 'ইমেইলে উদ্ধৃতি পাঠান'), "DeleteQuote", 'মুছে ফেলা উদ্ধৃতাংশ'), "AddQuote", 'তৈরি করুন উদ্ধৃতাংশ'), "SelectProduct", 'পণ্য নির্বাচন করুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'পণ্য (কোড - নাম)'), "Price", 'দাম'), "CurrentStock", 'স্টক'), "Total", 'গ্র্যান্ড টোটাল'), "Num", 'N°'), "Unitcost", 'ইউনিট খরচ'), "to", 'To'), "Subject", 'বিষয়'), "Message", 'বার্তা'), "EmailCustomer", 'গ্রাহককে ইমেল করুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", 'পাঠান'), "Quote", 'উদ্ধৃতাংশ'), "Hello", 'হ্যালো'), "AttachmentQuote", 'অনুগ্রহ করে আপনার উদ্ধৃতির জন্য সংযুক্তি খুঁজুন'), "AddProducts", 'অর্ডার তালিকায় পণ্য যোগ করুন'), "SelectWarehouse", 'অনুগ্রহ করে গুদাম নির্বাচন করুন'), "SelectCustomer", 'অনুগ্রহ করে গ্রাহক নির্বাচন করুন৷'), "SalesManagement", 'বিক্রয় ব্যবস্থাপনা'), "Balance", 'ভারসাম্য'), "QtyBack", 'Qty Back'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'টোটাল রিটার্ন'), "Amount", 'পরিমাণ'), "SaleDetail", 'বিক্রয় বিস্তারিত'), "EditSale", 'বিক্রয় সম্পাদনা করুন'), "AddSale", 'বিক্রয় তৈরি করুন'), "ShowPayment", 'পেমেন্ট দেখান'), "AddPayment", 'পেমেন্ট তৈরি করুন'), "EditPayment", 'অর্থপ্রদান সম্পাদনা করুন'), "EmailSale", 'ইমেইলে বিক্রয় পাঠান'), "DeleteSale", 'বিক্রয় মুছুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'দ্বারা পরিশোধ করা হয়'), "Paymentchoice", 'পেমেন্ট পছন্দ'), "Note", 'দ্রষ্টব্য'), "PaymentComplete", 'অর্থ প্রদান সম্পূর্ণ!'), "PurchasesManagement", 'ক্রয় ব্যবস্থাপনা'), "Ordered", 'আদেশ দিয়েছেন'), "DeletePurchase", 'ক্রয় মুছুন'), "EmailPurchase", 'ইমেল এ ক্রয় পাঠান'), "EditPurchase", 'ক্রয় সম্পাদনা করুন'), "PurchaseDetail", 'ক্রয় বিস্তারিত'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'ক্রয় তৈরি করুন'), "EmailSupplier", 'সরবরাহকারী ইমেল'), "PurchaseInvoice", 'পেমেন্ট ক্রয়'), "PurchasesInvoicesData", 'অর্থপ্রদানের ডেটা ক্রয় করে'), "SalesInvoice", 'বিক্রয় পেমেন্ট'), "SalesInvoicesData", 'বিক্রয় অর্থপ্রদানের ডেটা'), "UserManagement", 'ব্যবহারকারী ব্যবস্থাপনা'), "Firstname", 'প্রথম নাম'), "lastname", 'নামের শেষাংশ'), "username", 'ব্যবহারকারীর নাম'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", 'পাসওয়ার্ড'), "Newpassword", 'নতুন পাসওয়ার্ড'), "ChangeAvatar", 'অবতার পরিবর্তন করুন'), "LeaveBlank", 'আপনি যদি এটি পরিবর্তন না করে থাকেন তাহলে অনুগ্রহ করে এই ক্ষেত্রটি ফাঁকা রাখুন৷'), "type", 'টাইপ'), "UserPermissions", 'ব্যবহারকারীদের অনুমতি'), "RoleName", 'ভূমিকার নাম'), "RoleDescription", 'ভূমিকার বর্ণনা'), "AddPermissions", 'অনুমতি তৈরি করুন'), "View", 'দেখুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", 'মুছে ফেলা'), "NewAdjustement", 'নতুন সমন্বয়'), "EditAdjustement", 'সমন্বয় সম্পাদনা করুন'), "CannotSubstraction", 'আপনি স্টক 0 আছে এমন পণ্য বিয়োগ করতে পারবেন না'), "Addition", 'সংযোজন'), "Subtraction", 'বিয়োগ'), "profil", 'প্রোফাইল'), "logout", 'প্রস্থান'), "PurchaseAlreadyPaid", 'আপনি পরিবর্তন করতে পারবেন না কারণ এই ক্রয়টি ইতিমধ্যেই অর্থপ্রদান করেছে৷'), "SaleAlreadyPaid", 'আপনি পরিবর্তন করতে পারবেন না কারণ এই বিক্রয় ইতিমধ্যেই অর্থপ্রদান করেছে৷'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'আপনি পরিবর্তন করতে পারবেন না কারণ এই রিটার্ন ইতিমধ্যেই পরিশোধ করা হয়েছে'), "QuoteAlready", 'এই উদ্ধৃতি ইতিমধ্যে বিক্রয় উৎপন্ন হয়েছে'), "AddProduct", 'প্রোডাক্ট তৈরি করুন'), "QuotationComplete", 'এই উদ্ধৃতি সম্পূর্ণ'), "SiteConfiguration", 'সাইট কনফিগারেশন'), "Language", 'ভাষা'), "DefaultCurrency", 'ডিফল্ট মুদ্রা'), "LoginCaptcha", 'লগইন ক্যাপচা'), "DefaultEmail", 'ডিফল্ট ইমেল'), "SiteName", 'সাইটের নাম'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'লোগো পরিবর্তন করুন'), "SMTPConfiguration", 'মেইল কনফিগারেশন'), "HOST", 'হোস্ট'), "PORT", 'পোর্ট'), "encryption", 'এনক্রিপশন'), "SMTPIncorrect", 'কনফিগারেশন ভুল'), "PaymentsReturns", 'পেমেন্ট রিটার্ন'), "ReturnsInvoices", 'চালান রিটার্ন'), "ReturnsInvoicesData", 'ইনভয়েস ডেটা ফেরত দেয়'), "ShowAll", 'সমস্ত ব্যবহারকারীর সমস্ত রেকর্ড দেখুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", 'ছাড়'), "OrderTax", 'অর্ডার ট্যাক্স'), "Shipping", 'শিপিং'), "CompanyName", 'কোমপানির নাম'), "CompanyPhone", 'কোম্পানির ফোন'), "CompanyAdress", 'কোম্পানির ঠিকানা'), "Code", 'কোড'), "image", 'চিত্র'), "Printbarcode", 'বারকোড প্রিন্ট করুন'), "ReturnsCustomers", 'গ্রাহক রিটার্ন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'রিটার্ন সরবরাহকারী'), "FactureReturnCustomers", 'গ্রাহক চালান ফেরত দিন'), "FactureReturnSuppliers", 'সরবরাহকারী চালান ফেরত দিন'), "NodataAvailable", 'কোন তথ্য উপলব্ধ নেই'), "ProductImage", 'পণ্য ইমেজ'), "Barcode", 'বারকোড'), "pointofsales", 'বিক্রয় বিন্দু'), "CustomUpload", 'কাস্টম আপলোড'), "pointofsaleManagement", 'পয়েন্ট অফ সেল ম্যানেজমেন্ট'), "Adjustment", 'সমন্বয়'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", 'হালনাগাদ'), "Reset", 'রিসেট'), "print", 'প্রিন্ট'), "SearchByEmail", 'ইমেল দ্বারা অনুসন্ধান করুন'), "ChooseProduct", 'পণ্য নির্বাচন করুন'), "Qty", 'পরিমান'), "Items", 'আইটেমগুলি'), "AmountHT", 'Amount HT'), "AmountTTC", 'Amount TTC'), "PleaseSelectSupplier", 'অনুগ্রহ করে সরবরাহকারী নির্বাচন করুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'দয়া করে স্থিতি নির্বাচন করুন৷'), "PayeBy", 'দ্বারা অর্থপ্রদান'), "ChooseWarehouse", 'ওয়্যারহাউস বেছে নিন'), "payNow", 'এখন পরিশোধ করুন'), "ListofCategory", 'ক্যাটাগরির তালিকা'), "Description", 'বর্ণনা'), "submit", 'জমা দিন'), "ProblemCreatingThisInvoice", 'এই চালান তৈরিতে একটি সমস্যা হয়েছে৷ অনুগ্রহপূর্বক আবার চেষ্টা করুন'), "ProblemPayment", 'পেমেন্টে সমস্যা হয়েছে। অনুগ্রহপূর্বক আবার চেষ্টা করুন.'), "IncomeExpenses", 'আয় ও ব্যয়'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'দৈনিক বিক্রয় এবং ক্রয়'), "ProductsExpired", 'পণ্যের মেয়াদ শেষ'), "ListofBrand", 'ব্র্যান্ডস'), "CreateAdjustment", 'সমন্বয় তৈরি করুন'), "Afewwords", 'কয়েক শব্দ ...'), "UserImage", 'ব্যবহারকারীর ছবি'), "UpdateProduct", 'পণ্য আপডেট করুন'), "Brand", 'ব্র্যান্ড'), "BarcodeSymbology", 'বারকোড সিম্বোলজি'), "ProductCost", 'পণ্য খরচ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'পণ্য মূল্য'), "UnitProduct", 'পণ্য ইউনিট'), "TaxMethod", 'ট্যাক্স প্রকার'), "MultipleImage", 'একাধিক ছবি'), "ProductHasMultiVariants", 'এই পণ্যের মাল্টি বৈকল্পিক আছে'), "ProductHasPromotion", 'পণ্য প্রচার আছে'), "PromotionStart", 'Promotion Start'), "PromotionEnd", 'Promotion End'), "PromotionPrice", 'Promotion Price'), "Price", 'দাম'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Cost", 'খরচ'), "Unit", 'ইউনিট'), "ProductVariant", 'পণ্য বৈকল্পিক'), "Variant", 'বৈকল্পিক'), "UnitPrice", 'ইউনিট মূল্য'), "CreateReturnCustomer", 'রিটার্ন গ্রাহক তৈরি করুন'), "EditReturnCustomer", 'রিটার্ন গ্রাহক সম্পাদনা করুন'), "CreateReturnSupplier", 'রিটার্ন সরবরাহকারী তৈরি করুন'), "Documentation", 'ডক'), "EditReturnSupplier", 'রিটার্ন সরবরাহকারী সম্পাদনা করুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'গুদাম থেকে'), "ToWarehouse", 'গুদাম করার জন্য'), "EditTransfer", 'স্থানান্তর সম্পাদনা করুন'), "TransferDetail", 'স্থানান্তর বিবরণ'), "Pending", 'বিচারাধীন'), "Received", 'গৃহীত'), "Ordered", 'আদেশ দিয়েছেন'), "PermissionsManager", 'অনুমতি ব্যবস্থাপনা'), "BrandManager", 'ব্র্যান্ড'), "BrandImage", 'ব্র্যান্ড ইমেজ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BrandName", 'ব্র্যান্ডের নাম'), "BrandDescription", 'ব্র্যান্ডের বর্ণনা'), "BaseUnit", 'বেস একক'), "ManagerUnits", 'ইউনিট ব্যবস্থাপনা'), "OperationValue", 'অপারেশন ভ্যালু'), "Operator", 'অপারেটর'), "Top5Products", 'সেরা 5টি পণ্য'), "Last5Sales", 'শেষ 5 বিক্রয়'), "ListAdjustments", 'সমস্ত সমন্বয়'), "ListTransfers", 'সমস্ত স্থানান্তর'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'ট্রান্সফার তৈরি করুন'), "OrdersManager", 'আদেশ ব্যবস্থাপনা'), "ListQuotations", 'সব উদ্ধৃতি'), "ListPurchases", 'সমস্ত ক্রয়'), "ListSales", 'সমস্ত বিক্রয়'), "ListReturns", 'সব রিটার্ন'), "PeopleManager", 'মানুষ ব্যবস্থাপনা'), "Delete", {
  Title: 'তুমি কি নিশ্চিত?',
  Text: 'আপনি এটি প্রত্যাবর্তন করতে সক্ষম হবেন না!',
  confirmButtonText: 'হ্যাঁ, এটা মুছে ফেলুন!',
  cancelButtonText: 'বাতিল করুন',
  Deleted: 'মুছে ফেলা হয়েছে!',
  Failed: 'ব্যর্থ হয়েছে!',
  Therewassomethingwronge: 'কিছু ভুল ছিল',
  CustomerDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  SupplierDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  QuoteDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  SaleDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  PaymentDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  PurchaseDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  ReturnDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  ProductDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  ClientError: 'এই ক্লায়েন্টটি ইতিমধ্যেই অন্যান্য অপারেশনের সাথে লিঙ্ক করা হয়েছে৷',
  ProviderError: 'এই সরবরাহকারী ইতিমধ্যেই অন্যান্য অপারেশনের সাথে সংযুক্ত',
  UserDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  UnitDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  RoleDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  TaxeDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  SubCatDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  CatDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  WarehouseDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  AlreadyLinked: 'এই পণ্যটি ইতিমধ্যেই অন্যান্য অপারেশনের সাথে যুক্ত',
  AdjustDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  TitleCurrency: 'সফলভাবে মুছে ফেলা হয়েছে',
  TitleTransfer: 'সফলভাবে মুছে ফেলা হয়েছে',
  BackupDeleted: 'সফলভাবে মুছে ফেলা হয়েছে',
  TitleBrand: 'সফলভাবে মুছে ফেলা হয়েছে'
}), "Update", {
  TitleBrand: 'সফলভাবে আপডেট হয়েছে',
  TitleProfile: 'সফলভাবে আপডেট হয়েছে',
  TitleAdjust: 'সফলভাবে আপডেট হয়েছে',
  TitleRole: 'সফলভাবে আপডেট হয়েছে',
  TitleUnit: 'সফলভাবে আপডেট হয়েছে',
  TitleUser: 'সফলভাবে আপডেট হয়েছে',
  TitleCustomer: 'সফলভাবে আপডেট হয়েছে',
  TitleQuote: 'সফলভাবে আপডেট হয়েছে',
  TitleSale: 'সফলভাবে আপডেট হয়েছে',
  TitlePayment: 'সফলভাবে আপডেট হয়েছে',
  TitlePurchase: 'সফলভাবে আপডেট হয়েছে',
  TitleReturn: 'সফলভাবে আপডেট হয়েছে',
  TitleProduct: 'সফলভাবে আপডেট হয়েছে',
  TitleSupplier: 'সফলভাবে আপডেট হয়েছে',
  TitleTaxe: 'সফলভাবে আপডেট হয়েছে',
  TitleCat: 'সফলভাবে আপডেট হয়েছে',
  TitleWarhouse: 'সফলভাবে আপডেট হয়েছে',
  TitleSetting: 'সফলভাবে আপডেট হয়েছে',
  TitleCurrency: 'সফলভাবে আপডেট হয়েছে',
  TitleTransfer: 'সফলভাবে আপডেট হয়েছে'
}), "Create", {
  TitleBrand: 'সফলভাবে তৈরি করা হয়েছে',
  TitleRole: 'সফলভাবে তৈরি করা হয়েছে',
  TitleUnit: 'সফলভাবে তৈরি করা হয়েছে',
  TitleUser: 'সফলভাবে তৈরি করা হয়েছে',
  TitleCustomer: 'সফলভাবে তৈরি করা হয়েছে',
  TitleQuote: 'সফলভাবে তৈরি করা হয়েছে',
  TitleSale: 'সফলভাবে তৈরি করা হয়েছে',
  TitlePayment: 'সফলভাবে তৈরি করা হয়েছে',
  TitlePurchase: 'সফলভাবে তৈরি করা হয়েছে',
  TitleReturn: 'সফলভাবে তৈরি করা হয়েছে',
  TitleProduct: 'সফলভাবে তৈরি করা হয়েছে',
  TitleSupplier: 'সফলভাবে তৈরি করা হয়েছে',
  TitleTaxe: 'সফলভাবে তৈরি করা হয়েছে',
  TitleCat: 'সফলভাবে তৈরি করা হয়েছে',
  TitleWarhouse: 'সফলভাবে তৈরি করা হয়েছে',
  TitleAdjust: 'সফলভাবে তৈরি করা হয়েছে',
  TitleCurrency: 'সফলভাবে তৈরি করা হয়েছে',
  TitleTransfer: 'সফলভাবে তৈরি করা হয়েছে'
}), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'ইমেল সফলভাবে পাঠান'
}), "return", {
  TitleSale: 'এই বিক্রয় ইতিমধ্যে একটি রিটার্ন সঙ্গে লিঙ্ক!'
}), "ReturnManagement", 'রিটার্ন ম্যানেজমেন্ট'), "ReturnDetail", 'রিটার্ন বিস্তারিত'), "EditReturn", 'রিটার্ন সম্পাদনা করুন'), "AddReturn", 'রিটার্ন তৈরি করুন'), "EmailReturn", 'ইমেলে রিটার্ন পাঠান'), "DeleteReturn", 'রিটার্ন মুছুন'), "Retoursurcharge", 'রিটার্ন সারচার্জ'), "Laivrison", 'ডেলিভারি'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectSale", 'বিক্রয় নির্বাচন করুন'), "ZeroPardefault", 'আপনি আইটেমটি মুছে ফেলতে পারেন বা এটি ফেরত না দিলে পরিমাণটি শূন্যে সেট করতে পারেন'), "Return", 'প্রত্যাবর্তন'), "Purchase", 'ক্রয়'), "TotalSales", 'মোট বিক্রয়'), "TotalPurchases", 'মোট ক্রয়'), "TotalReturns", 'মোট রিটার্ন'), "PaiementsNet", 'পেমেন্ট নেট'), "PaiementsSent", 'পেমেন্ট পাঠানো হয়েছে'), "PaiementsReceived", 'পেমেন্ট পেয়েছি'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Recieved", 'গৃহীত'), "Sent", 'পাঠানো হয়েছে'), "ProductQuantityAlerts", 'পণ্য পরিমাণ সতর্কতা'), "ProductCode", 'কোড'), "ProductName", 'গুণফল'), "AlertQuantity", 'সতর্কতা পরিমাণ'), "WarehouseStockChart", 'গুদাম স্টক চার্ট'), "TotalProducts", 'মোট পণ্য'), "TotalQuantity", 'মোট পরিমাণ'), "TopCustomers", 'সেরা 5 গ্রাহক'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'মোট পরিমাণ'), "TotalPaid", 'মোট দেওয়া'), "CustomerSalesReport", 'গ্রাহক বিক্রয় রিপোর্ট'), "CustomerPaiementsReport", 'গ্রাহক পেমেন্ট রিপোর্ট'), "CustomerQuotationsReport", 'গ্রাহক উদ্ধৃতি রিপোর্ট'), "Payments", 'পেমেন্ট'), "TopSuppliers", 'শীর্ষ 5 সরবরাহকারী'), "SupplierPurchasesReport", 'সরবরাহকারী ক্রয় রিপোর্ট'), "SupplierPaiementsReport", 'সরবরাহকারী পেমেন্ট রিপোর্ট'), "Name", 'নাম'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Code", 'কোড'), "ManagementWarehouse", 'গুদাম ব্যবস্থাপনা'), "ZipCode", 'জিপ কোড'), "managementCategories", 'বিভাগসমূহ'), "Codecategorie", 'বিভাগ কোড'), "Namecategorie", 'বিভাগ নাম'), "Parentcategorie", 'অভিভাবক শ্রেণী'), "managementTax", 'ট্যাক্স ব্যবস্থাপনা'), "TaxName", 'ট্যাক্সের নাম'), "TaxRate", 'করের হার'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'ক্রয় ইউনিট'), "managementUnitSales", 'বিক্রয় ইউনিট'), "ShortName", 'সংক্ষিপ্ত নাম'), "PleaseSelectThesebeforeaddinganyproduct", 'কোন পণ্য যোগ করার আগে এই নির্বাচন করুন'), "StockAdjustement", 'সমন্বয়'), "PleaseSelectWarehouse", 'কোনো পণ্য নির্বাচন করার আগে গুদাম নির্বাচন করুন'), "StockTransfer", 'স্টক স্থানান্তর'), "SelectPeriod", 'পিরিয়ড নির্বাচন করুন'), "ThisYear", 'এই বছর'), "ThisToday", 'এই টুডে'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'এই মাস'), "ThisWeek", 'এই সপ্তাহ'), "AdjustmentDetail", 'সামঞ্জস্য বিস্তারিত'), "ActivateUser", 'এই ব্যবহারকারী সক্রিয় করা হয়েছে'), "DisActivateUser", 'এই ব্যবহারকারী নিষ্ক্রিয় করা হয়েছে'), "NotFound", 'পৃষ্ঠা খুঁজে পাওয়া যায়নি.'), "oops", 'উফ! পৃষ্ঠা খুঁজে পাওয়া যায়নি.'), "couldNotFind", 'আপনি যে পৃষ্ঠাটি খুঁজছিলেন তা আমরা খুঁজে পাইনি৷ এদিকে, আপনি হতে পারেন৷'), "ReturnDashboard", 'ড্যাশবোর্ডে ফিরে যান'), "hrm", 'এইচআরএম'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Employees", 'কর্মচারীদের'), "Attendance", 'হাজিরা'), "Leave_request", 'অনুরোধ ছেড়ে দিন'), "Leave_type", 'টাইপ'), "Company", 'কোম্পানি'), "Departments", 'বিভাগ'), "Designations", 'উপাধি'), "Office_Shift", 'অফিস শিফট'), "Holidays", 'ছুটির দিন'), "Enter_Company_Name", 'কোম্পানির নাম লিখুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'ইমেইল অ্যাড্রেস দিন'), "Enter_Company_Phone", 'কোম্পানির ফোন লিখুন'), "Enter_Company_Country", 'কোম্পানির দেশ লিখুন'), "Created_in_successfully", 'সফলভাবে তৈরি করা হয়েছে'), "Updated_in_successfully", 'সফলভাবে আপডেট করা হয়েছে৷'), "Deleted_in_successfully", 'সফলভাবে মুছে ফেলা হয়েছে'), "department", 'বিভাগ'), "Enter_Department_Name", 'বিভাগের নাম দিন'), "Choose_Company", 'কোম্পানি চয়ন করুন'), "Department_Head", 'বিভাগের প্রধান'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'বিভাগীয় প্রধান নির্বাচন করুন'), "Enter_Shift_name", 'শিফটের নাম লিখুন'), "Monday_In", 'Monday In'), "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'ছুটি'), "Enter_title", 'শিরোনাম লিখুন'), "title", 'শিরোনাম'), "start_date", 'শুরুর তারিখ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'শুরুর তারিখ লিখুন'), "Finish_Date", 'শেষ তারিখ'), "Enter_Finish_date", 'সমাপ্তির তারিখ লিখুন'), "Please_provide_any_details", 'কোন বিবরণ প্রদান করুন'), "Attendances", 'উপস্থিতি'), "Enter_Attendance_date", 'উপস্থিতির তারিখ লিখুন'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", 'কর্মচারী নির্বাচন করুন'), "Employee", 'কর্মচারী'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'কাজের সময়কাল'), "remaining_leaves_are_insufficient", 'অবশিষ্ট পাতা অপর্যাপ্ত'), "Leave_Type", 'টাইপ'), "Days", 'দিনগুলি'), "Department", 'বিভাগ'), "Choose_leave_type", 'টাইপ বেছে নিন'), "Choose_status", 'স্ট্যাটাস বেছে নিন'), "Leave_Reason", 'যুক্তি'), "Enter_Reason_Leave", 'কারণ ছুটি লিখুন'), "Add_Employee", 'কর্মচারী যোগ করুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FirstName", 'প্রথম নাম'), "Enter_FirstName", 'প্রথম নাম লিখুন'), "LastName", 'নামের শেষাংশ'), "Enter_LastName", 'শেষ নাম লিখুন'), "Gender", 'লিঙ্গ'), "Choose_Gender", 'লিঙ্গ চয়ন করুন'), "Enter_Birth_date", 'জন্ম তারিখ লিখুন'), "Birth_date", 'জন্ম তারিখ'), "Enter_Country", 'দেশে প্রবেশ করুন'), "Enter_Phone_Number", 'ফোন নম্বর লিখুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "joining_date", 'যোগদানের তারিখ'), "Enter_joining_date", 'যোগদানের তারিখ লিখুন'), "Choose_Designation", 'পদবী চয়ন করুন'), "Designation", 'উপাধি'), "Office_Shift", 'অফিস শিফট'), "Choose_Office_Shift", 'অফিস শিফট নির্বাচন করুন'), "Enter_Leaving_Date", 'ছেড়ে যাওয়ার তারিখ লিখুন'), "Leaving_Date", 'তারিখ ছাড়ার'), "Annual_Leave", 'বার্ষিক ছুটি'), "Enter_Annual_Leave", 'বার্ষিক ছুটি লিখুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'অবশিষ্ট ছুটি'), "Employee_Details", 'কর্মচারী বিবরণ'), "Basic_Information", 'মৌলিক তথ্য'), "Family_status", 'পারিবারিক মর্যাদা'), "Choose_Family_status", 'পারিবারিক অবস্থা চয়ন করুন'), "Employment_type", 'কর্মসংস্থান প্রকার'), "Select_Employment_type", 'কর্মসংস্থানের ধরন নির্বাচন করুন'), "Enter_City", 'শহরে প্রবেশ করুন'), "Province", 'প্রদেশ'), "Enter_Province", 'প্রদেশে প্রবেশ করুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'ঠিকানা লিখুন'), "Enter_Zip_code", 'জিপ কোড প্রবেশ'), "Zip_code", 'জিপ কোড'), "Hourly_rate", 'প্রতি ঘণ্টার হার'), "Enter_Hourly_rate", 'ঘন্টার হার লিখুন'), "Basic_salary", 'মূল বেতন'), "Enter_Basic_salary", 'বেসিক বেতন লিখুন'), "Social_Media", 'সামাজিক মাধ্যম'), "Skype", 'স্কাইপ'), "Enter_Skype", 'স্কাইপ লিখুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Facebook", 'ফেসবুক'), "Enter_Facebook", 'আপনার Facebook লিখুন'), "WhatsApp", 'হোয়াটসঅ্যাপ'), "Enter_WhatsApp", 'হোয়াটসঅ্যাপ লিখুন'), "LinkedIn", 'লিঙ্কডইন'), "Enter_LinkedIn", 'লিঙ্কডইন লিখুন'), "Twitter", 'টুইটার'), "Enter_Twitter", 'আপনার টুইটার লিখুন'), "Experiences", 'অভিজ্ঞতাসমূহ'), "bank_account", 'ব্যাংক হিসাব'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Company_Name", 'কোমপানির নাম'), "Location", 'অবস্থান'), "Enter_location", 'অবস্থান লিখুন'), "Enter_Description", 'বর্ণনা লিখুন'), "Bank_Name", 'ব্যাংকের নাম'), "Enter_Bank_Name", 'ব্যাঙ্কের নাম লিখুন'), "Bank_Branch", 'ব্যাংকের শাখা'), "Enter_Bank_Branch", 'ব্যাংক শাখায় প্রবেশ করুন'), "Bank_Number", 'ব্যাঙ্ক নম্বর'), "Enter_Bank_Number", 'ব্যাঙ্ক নম্বর লিখুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'অ্যাক্সেস গুদাম'), "Top_customers", 'সেরা গ্রাহকদের'), "Attachment", 'সংযুক্তি'), "view_employee", 'কর্মচারী দেখুন'), "edit_employee", 'কর্মচারী সম্পাদনা করুন'), "delete_employee", 'কর্মচারী মুছুন'), "Created_by", 'দ্বারা যোগ করা'), "Add_product_IMEI_Serial_number", 'পণ্যের IMEI/ক্রমিক নম্বর যোগ করুন'), "Product_Has_Imei_Serial_number", 'পণ্যের রয়েছে Imei/ক্রমিক নম্বর'), "IMEI_SN", 'IMEI/SN'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Shipments", 'প্রেরণ'), "delivered_to", 'বিতরণ করা হয়েছে'), "shipment_ref", 'ডেলিভারি রেফ'), "sale_ref", 'বিক্রয় রেফ'), "Edit_Shipping", 'শিপিং সম্পাদনা করুন'), "Packed", 'বস্তাবন্দী'), "Shipped", 'পাঠানো'), "Delivered", 'বিতরণ করা হয়েছে'), "Cancelled", 'বাতিল'), "Shipping_status", 'শিপিং অবস্থা'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users_Report", 'ব্যবহারকারীদের রিপোর্ট'), "stock_report", 'স্টক রিপোর্ট'), "TotalPurchases", 'মোট ক্রয়'), "Total_quotations", 'মোট কোটেশন'), "Total_return_sales", 'মোট রিটার্ন বিক্রয়'), "Total_return_purchases", 'মোট রিটার্ন ক্রয়'), "Total_transfers", 'মোট স্থানান্তর'), "Total_adjustments", 'মোট সমন্বয়'), "User_report", 'ব্যবহারকারীর প্রতিবেদন'), "Current_stock", 'বর্তমান স্টক'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_name", 'পণ্যের নাম'), "Total_Customers_Due", 'মোট ঋণ'), "Total_Suppliers_Due", 'মোট ঋণ'), "Some_warehouses", 'কিছু গুদাম'), "All_Warehouses", 'সমস্ত গুদাম'), "Product_Cost", 'পণ্য খরচ'), "sms_settings", 'এসএমএস সেটিংস'), "pos_settings", 'POS সেটিংস'), "payment_gateway", 'পেমেন্ট গেটওয়ে'), "mail_settings", 'মেল সেটিংস'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'নেক্সমো এসএমএস'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'ডিফল্ট এসএমএস গেটওয়ে'), "module_settings", 'মডিউল সেটিংস'), "Module_enabled_success", 'মডিউল সফলভাবে সক্ষম হয়েছে৷'), "Module_Disabled_success", 'মডিউল সফলভাবে নিষ্ক্রিয় হয়েছে৷'), "update_settings", 'সেটিংস আপডেট করুন'), "Please_Upload_the_Correct_Module", 'অনুগ্রহ করে সঠিক মডিউলটি আপলোড করুন'), "Uploaded_Success", 'সফলভাবে আপলোড করা হয়েছে'), "Customer_details", 'গ্রাহক বিবরণ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'গ্রাহক সম্পাদনা করুন'), "Delete_Customer", 'গ্রাহক মুছুন'), "Pay_Due", 'ক্লায়েন্ট বিশ্রামের পরিমাণ পরিশোধ করুন'), "Paying_amount_is_greater_than_Total_Due", 'অর্থপ্রদানের পরিমাণ মোট বিশ্রামের পরিমাণের চেয়ে বেশি৷'), "Customer_Invoice", 'গ্রাহক চালান'), "This_Product_Not_For_Selling", 'এই পণ্যটি বিক্রির জন্য নয়'), "Welcome_to_your_Dashboard", 'আপনার ড্যাশবোর্ডে স্বাগতম'), "Total_Payable", 'মোট প্রদেয়'), "Choose_Sale_Ref", 'বিক্রয় রেফ নির্বাচন করুন'), "Please_Select_Sale", 'বিক্রয় নির্বাচন করুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'বিক্রয় রেফ'), "list_product_returns", 'তালিকা পণ্য রিটার্ন'), "Qty_return", 'পরিমাণ রিটার্ন'), "Choose_Purchase_Ref", 'ক্রয় রেফ নির্বাচন করুন'), "Purchase_Ref", 'রেফ ক্রয়'), "please_select_purchase", 'ক্রয় নির্বাচন করুন'), "qty_return_is_greater_than_qty_purchased", 'পরিমাণ রিটার্ন ক্রয় করা পরিমাণের চেয়ে বেশি'), "qty_return_is_greater_than_qty_sold", 'পরিমাণ রিটার্ন বিক্রি করা পরিমাণের চেয়ে বেশি'), "Quantity_sold", 'পরিমাণ বিক্রি'), "qty_purchased", 'পরিমাণ ক্রয়'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'প্রেরক নাম'), "Upload_Module", 'আপলোড মডিউল'), "The_module_must_be_uploaded_as_zip_file", 'মডিউলটি অবশ্যই জিপ ফাইল হিসাবে আপলোড করতে হবে'), "All_Modules_Installed", 'সমস্ত মডিউল ইনস্টল'), "Current_Version", 'বর্তমান সংস্করণ'), "You_already_have_the_latest_version", 'আপনি ইতিমধ্যে সর্বশেষ সংস্করণ আছে'), "Update_Available", 'আপডেট উপলব্ধ'), "Update_Log", 'আপডেট লগ'), "Update_Now", 'এখন হালনাগাদ করুন'), "View_Change_Log", 'পরিবর্তন লগ দেখুন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'দ্রষ্টব্য: অনুগ্রহ করে আপডেট সম্পূর্ণভাবে শেষ হওয়ার জন্য অপেক্ষা করুন। এটি ব্রাউজার বন্ধ বা একটি প্রক্রিয়া আপগ্রেড বন্ধ করার সুপারিশ করা হয় না'), "Note_update", 'দ্রষ্টব্য: আপগ্রেড চালানোর আগে আপনি আপনার বর্তমান সংস্করণ এবং ডাটাবেস ব্যাকআপ করেছেন তা নিশ্চিত করুন, যদি কোনও ত্রুটি থাকে তবে এটি পুনরুদ্ধার করতে'), "invoice_footer", 'চালান ফুটার'), "Time_Zone", 'সময় অঞ্চল'), "Payment_note", 'পেমেন্ট নোট'), "sale_note", 'বিক্রয় নোট'), "Total_Sale_Due", 'মোট বিক্রয় ঋণ'), "Total_Sell_Return_Due", 'মোট বিক্রি রিটার্ন ঋণ'), "pay_all_sell_due_at_a_time", 'এক সময়ে সমস্ত বিক্রয় ঋণ পরিশোধ করুন'), "pay_all_sell_return_due_at_a_time", 'এক সময়ে সব বিক্রি রিটার্ন ঋণ পরিশোধ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'মোট মুনাফা'), "pay_all_purchase_due_at_a_time", 'এক সময়ে সমস্ত ক্রয় ঋণ পরিশোধ করুন'), "Delete_Provider", 'প্রদানকারী মুছুন'), "Edit_Provider", 'প্রদানকারী সম্পাদনা করুন'), "Provider_details", 'প্রদানকারীর বিবরণ'), "Total_Purchase_Due", 'মোট ক্রয় দেনা'), "Provider_Credit_Note", 'ক্রেডিট নোট'), "Customer_Credit_Note", 'ক্রেডিট নোট'), "Sell_Return", 'রিটার্ন বিক্রি করুন'), "Purchase_Return", 'ক্রয় রিটার্ন'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'কর নম্বর'), "Please_add_return_quantity", 'রিটার্ন পরিমাণ যোগ করুন'), "Return_exist_for_the_Transaction", 'লেনদেনের জন্য রিটার্ন বিদ্যমান'), "qty_return_is_greater_than_Quantity_Remaining", 'পরিমাণ রিটার্ন বাকি পরিমাণের চেয়ে বেশি'), "products_refunded_alert", '0 তে সেটের পরিমাণ সহ যেকোন পণ্য ফেরত দেওয়া হবে না'), "pay_all_purchase_return_due_at_a_time", 'এক সময়ে সমস্ত ক্রয় রিটার্ন পরিশোধ করুন'), "Total_Purchase_Return_Due", 'মোট ক্রয় রিটার্ন বকেয়া'), "Purchase_return_due", 'ক্রয় রিটার্ন ঋণ'), "Sell_return_due", 'বিক্রয় ফেরত ঋণ'), "product_report", 'পণ্য রিপোর্ট'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'পণ্য বিক্রয় রিপোর্ট'), "Product_purchases_report", 'পণ্য ক্রয় রিপোর্ট'), "Qty_sold", 'পরিমাণ বিক্রি'), "Qty_purchased", 'পরিমাণ ক্রয়'), "Filter_by_warehouse", 'গুদাম দ্বারা ফিল্টার'), "Enable_Print_Invoice", 'স্বয়ংক্রিয়ভাবে চালান প্রিন্ট করুন'), "Show_Warehouse", 'গুদাম দেখান'), "credit_card_info", 'ক্রেডিট কার্ড তথ্য'), "saved_credit_card_info", 'সংরক্ষিত ক্রেডিট কার্ড তথ্য'), "credit_card_changed_successfully", 'ক্রেডিট কার্ড সফলভাবে পরিবর্তিত হয়েছে'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "notification_template", 'বিজ্ঞপ্তি টেমপ্লেট'), "email_notification", 'ই-মেইল বিজ্ঞপ্তি'), "sms_notification", 'এসএমএস বিজ্ঞপ্তি'), "change_product_details", 'পণ্যের বিস্তারিত পরিবর্তন করুন'), "edit_tax_and_discount_and_shipping", 'কর এবং ছাড় এবং শিপিং সম্পাদনা করুন'), "create_quotation_with_stock", 'স্টক সহ উদ্ধৃতি তৈরি করুন'), "variant_name", 'পণ্যের পদক্ষেপের নাম'), "variant_cost", 'পণ্যের পদক্ষেপ খরচ'), "variant_price", 'পণ্যের পদক্ষেপ মূল্য'), "variant_code", 'পণ্যের পদক্ষেপ কোড'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "please_wait_until_the_product_is_loaded", 'পণ্য লোড হওয়া পর্যন্ত অপেক্ষা করুন'), "choose_sms_gateway", 'এসএমএস গেটওয়ে চয়ন করুন'), "notification_client", 'বিজ্ঞপ্তি ক্লায়েন্ট'), "available_tags", 'উপলব্ধ ট্যাগগুলি'), "email_subject", 'ই-মেইল বিষয়'), "email_body", 'ই-মেইল বডি'), "notification_supplier", 'বিজ্ঞপ্তি সাপ্লাইয়ার'), "sms_body", 'এসএমএস বডি'), "sms_templates", 'এসএমএস টেমপ্লেট'), "email_templates", 'ইমেল টেমপ্লেট'));

/***/ }),

/***/ "./resources/src/translations/locales/br.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/br.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language BR

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Recibo',
  Pos_Settings: 'Configurações de Pos (Recibo)',
  Note_to_customer: 'Nota ao cliente',
  Show_Note_to_customer: 'Mostrar nota ao cliente',
  Show_barcode: 'Mostre o código de barras',
  Show_Tax_and_Discount: 'Mostrar impostos e descontos e envios',
  Show_Customer: 'Mostrar cliente',
  Show_Email: 'Mostrar e-mail',
  Show_Phone: 'Mostrar telefone',
  Show_Address: 'Mostrar endereço',
  DefaultLanguage: 'Idioma padrão',
  footer: 'rodapé',
  Received_Amount: 'Valor recebido',
  Paying_Amount: 'Valor a pagar',
  Change: 'Alterar devolução',
  Paying_amount_is_greater_than_Received_amount: 'O valor pago é maior do que o valor recebido',
  Paying_amount_is_greater_than_Grand_Total: 'O valor do pagamento é maior que o total geral',
  code_must_be_not_exist_already: 'O código não deve existir já',
  You_will_find_your_backup_on: 'Você encontrará seu backup em',
  and_save_it_to_your_pc: 'e salve no seu pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Digitalize seu código de barras e selecione a simbologia correta abaixo',
  Scan_Search_Product_by_Code_Name: 'Digitalizar/pesquisar produto por código ou nome',
  Paper_size: 'Tamanho do papel',
  Clear_Cache: 'Limpar cache',
  Cache_cleared_successfully: 'Cache limpo com sucesso',
  Failed_to_clear_cache: 'Falha ao limpar o cache',
  Scan_Barcode: 'Leitor de códigos de barra',
  Please_use_short_name_of_unit: 'Por favor, use o nome abreviado da unidade',
  DefaultCustomer: 'Cliente padrão',
  DefaultWarehouse: 'Armazém padrão',
  Payment_Gateway: 'Gateway de pagamento',
  SMS_Configuration: 'Configuração de SMS',
  Gateway: 'Gateway SMS',
  Choose_Gateway: 'Escolha o Gateway SMS',
  Send_SMS: 'mensagem enviada com sucesso',
  sms_config_invalid: 'configuração de sms errada inválida',
  Remove_Stripe_Key_Secret: 'Excluir chaves da API Stripe',
  credit_card_account_not_available: 'Conta de cartão de crédito não disponível',
  Credit_Card_Info: 'Informações do cartão de crédito',
  developed_by: 'Desenvolvido por',
  Unit_already_linked_with_sub_unit: 'Unidade já vinculada à subunidade',
  Total_Items_Quantity: 'Total de Itens e Quantidade',
  Value_by_Cost_and_Price: 'Valor por Custo e Preço',
  Search_this_table: 'Pesquisar esta tabela',
  import_products: 'Importar produtos',
  Field_optional: 'Campo opcional',
  Download_exemple: 'Baixar exemplo',
  field_must_be_in_csv_format: 'O campo deve estar no formato csv',
  Successfully_Imported: 'Importado com sucesso',
  file_size_must_be_less_than_1_mega: 'O tamanho do arquivo deve ser menor que 1 mega',
  Please_follow_the_import_instructions: 'Por favor, siga as instruções de importação',
  must_be_exist: 'Unidade já deve ser criada',
  Import_Customers: 'Importar clientes',
  Import_Suppliers: 'Fornecedores de importação',
  Recent_Sales: 'Vendas recentes',
  Create_Transfer: 'Criar transferência',
  order_products: 'Itens de ordem',
  Search_Product_by_Code_Name: 'Pesquisar produto por código ou nome',
  Reports_payments_Purchase_Return: 'Relatórios de pagamentos de devolução de compra',
  Reports_payments_Sale_Return: 'Relatórios de Pagamentos de Devolução de Vendas',
  payments_Sales_Return: 'Devolução de vendas de pagamentos',
  payments_Purchases_Return: 'Pagamentos Devolução de Compras',
  CreateSaleReturn: 'Criar Devolução de Venda',
  EditSaleReturn: 'Editar devolução de venda',
  SalesReturn: 'Retorno de vendas',
  CreatePurchaseReturn: 'Criar devolução de compra',
  EditPurchaseReturn: 'Editar devolução de compra',
  PurchasesReturn: 'Devolução de compras',
  Due: 'Vencimento',
  Profit: 'Perfil',
  Revenue: 'receita',
  Sales_today: 'Vendas de hoje',
  People: 'Pessoas',
  Successfully_Created: 'Criado com sucesso',
  Successfully_Updated: 'Atualizado com sucesso',
  Success: 'Sucesso',
  Failed: 'Fracassado',
  Warning: 'Aviso',
  Please_fill_the_form_correctly: 'Por favor preencha o formulário corretamente',
  Field_is_required: 'Este campo é obrigatório',
  Error: 'Erro!',
  you_are_not_authorized: 'Desculpe! Você não está autorizado.',
  Go_back_to_home: 'Voltar para a página inicial',
  page_not_exist: 'Desculpe! A página que você estava procurando não existe.',
  Choose_Status: 'Escolha o status',
  Choose_Method: 'Escolha o método',
  Choose_Symbology: 'Escolha a simbologia',
  Choose_Category: 'Escolher categoria',
  Choose_Customer: 'Escolher categoria',
  Choose_Supplier: 'Escolha o fornecedor',
  Choose_Unit_Purchase: 'Escolha a unidade de compra',
  Choose_Sub_Category: 'Escolha a subcategoria',
  Choose_Brand: 'Escolha a marca',
  Choose_Warehouse: 'Escolher Armazém',
  Choose_Unit_Sale: 'Escolha a unidade de venda',
  Enter_Product_Cost: 'Insira o custo do produto',
  Enter_Stock_alert: 'Digite o alerta de estoque',
  Choose_Unit_Product: 'Escolha a unidade do produto',
  Enter_Product_Price: 'Insira o preço do produto',
  Enter_Name_Product: 'Digite o nome do produto',
  Enter_Role_Name: 'Digite o nome da função',
  Enter_Role_Description: 'Digite a descrição do papel',
  Enter_name_category: 'Digite o nome da categoriae',
  Enter_Code_category: 'Digite o código da categoria',
  Enter_Name_Brand: 'Digite o nome da marca',
  Enter_Description_Brand: 'Digite Descrição Marca',
  Enter_Code_Currency: 'Digite a moeda do código',
  Enter_name_Currency: 'Digite a moeda do código',
  Enter_Symbol_Currency: 'Insira a moeda do símbolo',
  Enter_Name_Unit: 'Digite o nome da unidade',
  Enter_ShortName_Unit: 'Insira a unidade de nome abreviado',
  Choose_Base_Unit: 'Escolha a unidade básica',
  Choose_Operator: 'Escolher Operador',
  Enter_Operation_Value: 'Enter Operation Value',
  Enter_Name_Warehouse: 'Enter Warehouse Name',
  Enter_Phone_Warehouse: 'Enter Warehouse Phone',
  Enter_Country_Warehouse: 'Enter Warehouse Country',
  Enter_City_Warehouse: 'Enter Warehouse City',
  Enter_Email_Warehouse: 'Enter Warehouse Email',
  Enter_ZipCode_Warehouse: 'Enter Warehouse Zip Code',
  Choose_Currency: 'Escolha a moeda',
  Thank_you_for_your_business: 'Obrigado por comprar conosco . Por favor, volte',
  Cancel: 'Cancelar',
  New_Customer: 'Novo cliente',
  Incorrect_Login: 'Login incorreto',
  Successfully_Logged_In: 'Logado com sucesso',
  This_user_not_active: 'Este usuário não está ativo',
  SignIn: 'Entrar',
  Create_an_account: 'Crie a sua conta aqui',
  Forgot_Password: 'Esqueceu a senha ?',
  Email_Address: 'Endereço de email',
  SignUp: 'Inscrever-se',
  Already_have_an_account: 'Já tem uma conta ?',
  Reset_Password: 'Redefinir senha',
  Failed_to_authenticate_on_SMTP_server: 'Falha ao autenticar no servidor SMTP',
  We_cant_find_a_user_with_that_email_addres: 'Não conseguimos encontrar um usuário com esse endereço de e-mail',
  We_have_emailed_your_password_reset_link: 'Enviamos o link de redefinição de senha por e-mail',
  Please_fill_the_Email_Adress: 'Por favor, preencha o endereço de e-mail',
  Confirm_password: 'Confirme a Senha',
  Your_Password_has_been_changed: 'Sua senha foi mudada',
  The_password_confirmation_does_not_match: 'A confirmação da senha não corresponde',
  This_password_reset_token_is_invalid: 'Este token de redefinição de senha é inválido',
  Warehouse_report: 'Relatório do armazém',
  All_Warehouses: 'Todos os Armazéns',
  Expense_List: 'Todas as despesas',
  Expenses: 'Despesas',
  This_Week_Sales_Purchases: 'Esta semana Vendas e compras',
  Top_Selling_Products: 'Produtos mais vendidos',
  View_all: 'Ver tudo',
  Payment_Sent_Received: 'Pagamento enviado e recebido',
  Filter: 'Filtro',
  Invoice_POS: 'Fatura PDV',
  Invoice: 'Fatura',
  Customer_Info: 'Informação do Cliente',
  Company_Info: 'Informação da companhia',
  Invoice_Info: 'Informações da fatura',
  Order_Summary: 'Resumo do pedido',
  Quote_Info: 'Informações da cotação',
  Del: 'Excluir',
  SuppliersPaiementsReport: 'Relatório de Pagamentos de Fornecedores',
  Purchase_Info: 'Informações de compra',
  Supplier_Info: 'Informações do fornecedor',
  Return_Info: 'Informações de Devolução',
  Expense_Category: 'Categoria de Despesa',
  Create_Expense: 'Criar Despesa',
  Details: 'Detalhes',
  Discount_Method: 'Tipo de desconto',
  Net_Unit_Cost: 'Custo unitário líquido',
  Net_Unit_Price: 'Preço unitário líquido',
  Edit_Expense: 'Edit Expense',
  All_Brand: 'Todas as marcas',
  All_Category: 'Todas as categorias',
  ListExpenses: 'Todas as despesas',
  Create_Permission: 'Criar permissão',
  Edit_Permission: 'Editar permissão',
  Reports_payments_Sales: 'Relatórios de pagamentos Vendas',
  Reports_payments_Purchases: 'Relatórios de pagamentos Compras',
  Reports_payments_Return_Customers: 'Clientes de Devolução de Pagamentos',
  Reports_payments_Return_Suppliers: 'Fornecedores de devolução de pagamentos',
  Expense_Deleted: 'Esta despesa foi excluída',
  Expense_Updated: 'Esta despesa contratada foi',
  Expense_Created: 'Esta despesa foi criada',
  DemoVersion: 'Você não pode fazer isso na versão demo',
  OrderStatistics: 'Estatísticas de vendas',
  AlreadyAdd: 'Este produto já foi adicionado !!',
  AddProductToList: 'Por favor, adicione o produto à lista !!',
  AddQuantity: 'Por favor, adicione a quantidade do produto !!',
  InvalidData: 'Dados inválidos !!',
  LowStock: 'A quantidade excede a quantidade disponível em estoque',
  WarehouseIdentical: 'Os dois armazéns não podem ser idênticos !!',
  VariantDuplicate: 'Esta variante é duplicada !!',
  Filesize: 'Tamanho do arquivo',
  GenerateBackup: 'Gerar Backup',
  BackupDatabase: 'Banco de dados de backup',
  Backup: 'Backup',
  Paid: 'Pago',
  Unpaid: 'Não pago',
  Today: 'Hoje',
  Income: 'Income'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'Despesas'), "Sale", 'Oferta'), "Actif", 'Ativo'), "Inactif", 'Inativo'), "Customers", 'Cliente'), "Phone", 'Telefone'), "SearchByPhone", 'Pesquisar por telefone'), "Suppliers", 'Fornecedores'), "Quotations", 'Cotações'), "Sales", 'Vendas'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'Compras'), "Returns", 'Retornar'), "Settings", 'Definições'), "SystemSettings", 'Configurações de sistema'), "Users", 'Usuários'), "GroupPermissions", 'Permissões de grupo'), "Currencies", 'Moeda'), "Warehouses", 'Armazém'), "Units", 'Unidade'), "UnitsPrchases", 'Unidades de compras'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Unidades de vendas'), "Reports", 'Relatórios'), "PaymentsReport", 'Relatório de pagamentos'), "PaymentsPurchases", 'Pagamentos Compras'), "PaymentsSales", 'Pagamentos Vendas'), "ProfitandLoss", 'Lucros e perdas'), "WarehouseStockChart", 'Gráfico de Estoque do Armazém'), "SalesReport", 'Relatório de vendas'), "PurchasesReport", 'Relatório de compra'), "CustomersReport", 'Relatório do cliente'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Relatório do Fornecedor'), "SupplierReport", 'Relatório do Fornecedor'), "DailySalesData", 'Dados diários de vendas'), "DailyPurchasesData", 'Dados de compras diárias'), "Derni\xE8rescinqrecords", 'Últimos cinco registros'), "Filters", 'Filtros'), "date", 'Encontro'), "Reference", 'Referência'), "Supplier", 'Fornecedor'), "PaymentStatus", 'Status do pagamento'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", 'Cliente'), "CustomerCode", 'Código do Consumidor'), "Status", 'Status'), "SupplierCode", 'Código de fornecedor'), "Categorie", 'Categoria'), "Categories", 'Categoria'), "StockTransfers", 'Transferir'), "StockManagement", 'Gestão de Estoque'), "dashboard", 'Dashboard'), "Products", 'Produtos'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'Todos os produtos'), "ProductManagement", 'Gestão de produtos'), "ProductQuantityAlerts", 'Alertas de quantidade de produtos'), "CodeProduct", 'Código do produto'), "ProductTax", 'Imposto sobre produtos'), "SubCategorie", 'Subcategoria'), "Name_product", 'Nome'), "StockAlert", 'Alerta de estoque'), "warehouse", 'Armazém'), "Tax", 'Imposto'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Preço de compra'), "SellPrice", 'Preço de venda'), "Quantity", 'Quantidade'), "UnitSale", 'Unidade de venda'), "UnitPurchase", 'Unidade de compra'), "ManagementCurrencies", 'Gerenciamento de moeda'), "CurrencyCode", 'Código da moeda'), "CurrencyName", 'Nome da moeda'), "Symbol", 'Símbolo'), "All", 'Tudo'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Editar produto'), "SearchByCode", 'Pesquisar por código'), "SearchByName", 'Procura por nome'), "ProductDetails", 'Detalhes do produto'), "CustomerName", 'nome do cliente'), "CustomerManagement", 'Gestão de Clientes'), "Add", 'Criar'), "add", 'Criar'), "Edit", 'Editar'), "Close", 'Fechar'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Por favor selecione'), "Action", 'Ação'), "Email", 'Email'), "EditCustomer", 'Editar cliente'), "AddCustomer", 'Criar cliente'), "Country", 'País'), "City", 'Cidade'), "Adress", 'Endereço'), "CustomerDetails", 'Detalhes do cliente'), "CustomersList", 'Clientes'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Código de fornecedor'), "SupplierName", 'Nome do Fornecedor'), "SuppliersManagement", 'Gestão de fornecedores'), "SupplierDetails", 'Detalhes do fornecedor'), "QuotationsManagement", 'Gerenciamento de Cotações'), "SubTotal", 'Subtotal'), "MontantReste", 'Quantidade restante'), "complete", 'Concluído'), "EnAttendant", 'Pendente'), "Recu", 'Recebido'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", 'Parcial'), "Retournee", 'Retornar'), "DetailQuote", 'Cotação detalhada'), "EditQuote", 'Editar cotação'), "CreateSale", 'Criar venda'), "DownloadPdf", 'Baixar PDF'), "QuoteEmail", 'Enviar cotação no e-mail'), "DeleteQuote", 'Excluir cotação'), "AddQuote", 'Criar cotação'), "SelectProduct", 'Selecionar produto'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Produto (Código - Nome)'), "Price", 'Preço'), "CurrentStock", 'Estoque'), "Total", 'Total geral'), "Num", 'N°'), "Unitcost", 'Custo unitário'), "to", 'Para'), "Subject", 'Sujeito'), "Message", 'Mensagem'), "EmailCustomer", 'E-mail do cliente'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", 'Mandar'), "Quote", 'cotação'), "Hello", 'Olá'), "AttachmentQuote", 'Por favor, encontre o anexo para sua cotação'), "AddProducts", 'Adicionar produtos à lista de pedidos'), "SelectWarehouse", 'Selecione o armazém'), "SelectCustomer", 'Por favor selecione o cliente'), "SalesManagement", 'Gerenciamento de vendas'), "Balance", 'Equilíbrio'), "QtyBack", 'Quantidade de volta'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Retorno total'), "Amount", 'Quantia'), "SaleDetail", 'Detalhe da venda'), "EditSale", 'Editar venda'), "AddSale", 'Criar venda'), "ShowPayment", 'Mostrar pagamentos'), "AddPayment", 'Criar pagamento'), "EditPayment", 'Editar pagamento'), "EmailSale", 'Enviar venda por e-mail'), "DeleteSale", 'Excluir venda'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Pago pelo'), "Paymentchoice", 'Opção de pagamento'), "Note", 'Observação'), "PaymentComplete", 'Pagamento concluído!'), "PurchasesManagement", 'Gestão de compras'), "Ordered", 'Encomendado'), "DeletePurchase", 'Excluir compra'), "EmailPurchase", 'Enviar compra por e-mail'), "EditPurchase", 'Editar compra'), "PurchaseDetail", 'Detalhe da compra'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Criar compra'), "EmailSupplier", 'E-mail do fornecedor'), "PurchaseInvoice", 'Pagamentos de compras'), "PurchasesInvoicesData", 'Dados de pagamentos de compras'), "SalesInvoice", 'Pagamentos de vendas'), "SalesInvoicesData", 'Dados de pagamentos de vendas'), "UserManagement", 'Gerenciamento de usuários'), "Firstname", 'Primeiro nome'), "lastname", 'Sobrenome'), "username", 'Nome de usuário'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", 'Senha'), "Newpassword", 'Nova Senha'), "ChangeAvatar", 'Mudar Avatar'), "LeaveBlank", 'Por favor, deixe este campo em branco se você não o alterou'), "type", 'Modelo'), "UserPermissions", 'Permissões de usuários'), "RoleName", 'Função'), "RoleDescription", 'Descrição do papel'), "AddPermissions", 'Criar permissões'), "View", 'Visão'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", 'Excluir'), "NewAdjustement", 'Novo ajuste'), "EditAdjustement", 'Editar ajuste'), "CannotSubstraction", 'Você não pode subtrair produtos que têm estoque 0'), "Addition", 'Adição'), "Subtraction", 'Subtração'), "profil", 'Perfil'), "logout", 'Sair'), "PurchaseAlreadyPaid", 'Você não pode modificar porque esta compra já foi paga'), "SaleAlreadyPaid", 'Você não pode modificar porque esta venda já foi paga'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'Você não pode modificar porque esta Devolução já foi paga'), "QuoteAlready", 'Esta cotação já gerou venda'), "AddProduct", 'Criar produto'), "QuotationComplete", 'Esta cotação completa'), "SiteConfiguration", 'Configuração do site'), "Language", 'Linguagem'), "DefaultCurrency", 'Moeda padrão'), "LoginCaptcha", 'Captcha de login'), "DefaultEmail", 'E-mail padrão'), "SiteName", 'Nome do site'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Alterar logotipo'), "SMTPConfiguration", 'Configuração SMTP'), "HOST", 'MAIL_HOST'), "PORT", 'MAIL_PORT'), "encryption", 'MAIL_ENCRYPTION'), "SMTPIncorrect", 'Configuração SMTP incorreta'), "PaymentsReturns", 'Devoluções de pagamentos'), "ReturnsInvoices", 'Devoluções de faturas'), "ReturnsInvoicesData", 'Devoluções de dados de faturas'), "ShowAll", 'Ver todos os registros de todos os usuários'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", 'Desconto'), "OrderTax", 'Imposto de pedido'), "Shipping", 'Envio'), "CompanyName", 'Nome da empresa'), "CompanyPhone", 'Telefone da empresa'), "CompanyAdress", 'Endereço da companhia'), "Code", 'Código'), "image", 'Imagem'), "Printbarcode", 'Imprimir código de barras'), "ReturnsCustomers", 'Cliente de Devoluções'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Fornecedor de devoluções'), "FactureReturnCustomers", 'Devolução da fatura do cliente'), "FactureReturnSuppliers", 'Devolução de fatura do fornecedor'), "NodataAvailable", 'Nenhum dado disponível'), "ProductImage", 'Imagem do Produto'), "Barcode", 'Código de barras'), "pointofsales", 'Ponto de Vendas'), "CustomUpload", 'Upload personalizado'), "pointofsaleManagement", 'Gerenciamento de ponto de venda'), "Adjustment", 'Ajustamento'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", 'Atualizar'), "Reset", 'Redefinir'), "print", 'Imprimir'), "SearchByEmail", 'Pesquisar por e-mail'), "ChooseProduct", 'Escolha o produto'), "Qty", 'Qty'), "Items", 'Itens'), "AmountHT", 'Quantidade HT'), "AmountTTC", 'Valor TTC'), "PleaseSelectSupplier", 'Selecione o fornecedorPlease Select Supplier'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Selecione o status'), "PayeBy", 'Pago pelo'), "ChooseWarehouse", 'Escolher Armazém'), "payNow", 'Pague agora'), "ListofCategory", 'Lista de Categoria'), "Description", 'Description'), "submit", 'Enviar'), "ProblemCreatingThisInvoice", 'Ocorreu um problema ao criar esta fatura. Por favor, tente novamente'), "ProblemPayment", 'Houve um problema no pagamento. Por favor, tente novamente..'), "IncomeExpenses", 'Receitas e despesas'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'Vendas e compras diárias'), "ProductsExpired", 'Produtos expirados'), "ListofBrand", 'Marcas'), "CreateAdjustment", 'Criar ajuste'), "Afewwords", 'Algumas palavras ...'), "UserImage", 'Imagem do usuário'), "UpdateProduct", 'Atualizar produto'), "Brand", 'Marca'), "BarcodeSymbology", 'Simbologia do código de barras'), "ProductCost", 'Custo do produto'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Preço do produto'), "UnitProduct", 'Unidade de produto'), "TaxMethod", 'Tipo de imposto'), "MultipleImage", 'Várias imagens'), "ProductHasMultiVariants", 'Este produto tem várias variantes'), "ProductHasPromotion", 'Produto Tem Promoção'), "PromotionStart", 'Início da promoção'), "PromotionEnd", 'Fim da promoção'), "PromotionPrice", 'Preço de promoção'), "Price", 'Preço'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Cost", 'Custo'), "Unit", 'Unidade'), "ProductVariant", 'Variante do produto'), "Variant", 'Variante'), "UnitPrice", 'Preço unitário'), "CreateReturnCustomer", 'Criar cliente de devolução'), "EditReturnCustomer", 'Editar cliente de retorno'), "CreateReturnSupplier", 'Criar fornecedor de devolução'), "Documentation", 'Doc'), "EditReturnSupplier", 'Editar fornecedor de devolução'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'Do armazém'), "ToWarehouse", 'Para Armazém'), "EditTransfer", 'Editar transferência'), "TransferDetail", 'Detalhe da transferência'), "Pending", 'Pendente'), "Received", 'Recebido'), "Ordered", 'Encomendado'), "PermissionsManager", 'Gerenciamento de permissões'), "BrandManager", 'Marca'), "BrandImage", 'Imagem de marca'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BrandName", 'Marca'), "BrandDescription", 'Descrição da marca'), "BaseUnit", 'Unidade base'), "ManagerUnits", 'Gestão de Unidades'), "OperationValue", 'Valor da operação'), "Operator", 'Operador'), "Top5Products", '5 principais produtos'), "Last5Sales", 'Últimas 5 vendas'), "ListAdjustments", 'Todos os ajustes'), "ListTransfers", 'Todas as transferências'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Criar transferência'), "OrdersManager", 'Gestão de Pedidos'), "ListQuotations", 'Todas as Cotações'), "ListPurchases", 'Todas as compras'), "ListSales", 'Todas as vendas'), "ListReturns", 'Todas as devoluções'), "PeopleManager", 'Gestão de Pessoas'), "Delete", {
  Title: 'Tem certeza?',
  Text: 'Você não poderá reverter isso!',
  confirmButtonText: 'Sim, exclua!',
  cancelButtonText: 'Cancelar',
  Deleted: 'Excluído!',
  Failed: 'Fracassado!',
  Therewassomethingwronge: 'Havia algo errado',
  CustomerDeleted: 'Este cliente foi excluído.',
  SupplierDeleted: 'Este fornecedor foi excluído.',
  QuoteDeleted: 'Esta cotação foi excluída.',
  SaleDeleted: 'Esta venda foi excluída.',
  PaymentDeleted: 'Este pagamento foi excluído.',
  PurchaseDeleted: 'Esta compra foi excluída.',
  ReturnDeleted: 'Este retorno foi excluído.',
  ProductDeleted: 'Este produto foi excluído.',
  ClientError: 'Este Cliente já está vinculado a outra Operação',
  ProviderError: 'Este Fornecedor já vinculado a outra Operação',
  UserDeleted: 'Este usuário foi excluído.',
  UnitDeleted: 'Esta unidade foi excluída.',
  RoleDeleted: 'Esta função foi excluída.',
  TaxeDeleted: 'Este imposto foi excluído.',
  SubCatDeleted: 'Esta subcategoria foi excluída.',
  CatDeleted: 'Esta categoria foi excluída.',
  WarehouseDeleted: 'Este Armazém foi excluído.',
  AlreadyLinked: 'Este produto já está vinculado a outra Operação',
  AdjustDeleted: 'Este ajuste foi excluído.',
  TitleCurrency: 'Esta moeda foi excluída.',
  TitleTransfer: 'A transferência foi removida com sucesso',
  BackupDeleted: 'O backup foi removido com sucesso',
  TitleBrand: 'Esta marca foi excluída'
}), "Update", {
  TitleBrand: 'Esta marca foi atualizada',
  TitleProfile: 'Seu perfil atualizado com sucesso',
  TitleAdjust: 'Ajuste atualizado com sucesso',
  TitleRole: 'Função atualizada com sucesso',
  TitleUnit: 'Unidade atualizada com sucesso',
  TitleUser: 'Usuário atualizado com sucesso',
  TitleCustomer: 'Cliente atualizado com sucesso',
  TitleQuote: 'Cotação atualizada com sucesso',
  TitleSale: 'Venda atualizada com sucesso',
  TitlePayment: 'Pagamento atualizado com sucesso',
  TitlePurchase: 'Compra atualizada com sucesso',
  TitleReturn: 'Devolução Atualizada com sucesso',
  TitleProduct: 'Produto atualizado com sucesso',
  TitleSupplier: 'Fornecedor atualizado com sucesso',
  TitleTaxe: 'Imposto atualizado com sucesso',
  TitleCat: 'Categoria atualizada com sucesso',
  TitleWarhouse: 'Armazém atualizado com sucesso',
  TitleSetting: 'Configurações atualizadas com sucesso',
  TitleCurrency: 'Moeda atualizada com sucesso',
  TitleTransfer: 'Transferência atualizada com sucesso'
}), "Create", {
  TitleBrand: 'Esta marca foi criada',
  TitleRole: 'Função criada com sucesso',
  TitleUnit: 'Unidade criada com sucesso',
  TitleUser: 'Usuário criado com sucesso',
  TitleCustomer: 'Cliente criado com sucesso',
  TitleQuote: 'Cotação criada com sucesso',
  TitleSale: 'Venda criada com sucesso',
  TitlePayment: 'Pagamento criado com sucesso',
  TitlePurchase: 'Compra criada com sucesso',
  TitleReturn: 'Retorno criado com sucesso',
  TitleProduct: 'Produto criado com sucesso',
  TitleSupplier: 'Fornecedor criado com sucesso',
  TitleTaxe: 'Imposto criado com sucesso',
  TitleCat: 'Categoria criada com sucesso',
  TitleWarhouse: 'Armazém criado com sucesso',
  TitleAdjust: 'Armazém criado com sucesso',
  TitleCurrency: 'Moeda criada com sucesso',
  TitleTransfer: 'Transferência criada com sucesso'
}), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'Email enviado com sucesso'
}), "return", {
  TitleSale: 'Esta venda já está vinculada a uma Devolução!'
}), "ReturnManagement", 'Gestão de Devolução'), "ReturnDetail", 'Return Detail'), "EditReturn", 'Editar retorno'), "AddReturn", 'Criar Devolução'), "EmailReturn", 'Enviar retorno no e-mail'), "DeleteReturn", 'Excluir Devolução'), "Retoursurcharge", 'Sobretaxa de devolução'), "Laivrison", 'Entrega'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Selecionar venda'), "ZeroPardefault", 'Você pode excluir o item ou definir a quantidade devolvida para zero se não for devolvida'), "Return", 'Retornar'), "Purchase", 'Comprar'), "TotalSales", 'Vendas totais'), "TotalPurchases", 'Total de Compras'), "TotalReturns", 'Devoluções totaiss'), "PaiementsNet", 'Pagamentos líquidos'), "PaiementsSent", 'Pagamentos enviados'), "PaiementsReceived", 'Pagamentos recebidos'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Recieved", 'Recebid'), "Sent", 'Enviado'), "ProductQuantityAlerts", 'Product Quantity Alerts'), "ProductCode", 'Código'), "ProductName", 'Produtos'), "AlertQuantity", 'Quantidade de alertas'), "WarehouseStockChart", 'Gráfico de Estoque do Armazém'), "TotalProducts", 'Produtos totais'), "TotalQuantity", 'Quantidade total'), "TopCustomers", '5 principais clientes'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalAmount", '5 principais clientes'), "TotalPaid", 'Total pago'), "CustomerSalesReport", 'Relatório de vendas do cliente'), "CustomerPaiementsReport", 'Relatório de pagamentos do cliente'), "CustomerQuotationsReport", 'Relatório de Cotações de Clientes'), "Payments", 'Pagamentos'), "TopSuppliers", '5 principais fornecedores'), "SupplierPurchasesReport", 'Relatório de Compras de Fornecedores'), "SupplierPaiementsReport", 'Relatório de Pagamentos de Fornecedores'), "Name", 'Nome'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Code", 'Código'), "ManagementWarehouse", 'Gerenciamento de armazenagem'), "ZipCode", 'Código postal'), "managementCategories", 'Gerenciamento de categorias'), "Codecategorie", 'Código da categoria'), "Namecategorie", 'Nome da Categoria'), "Parentcategorie", 'Categoria Parental'), "managementTax", 'Gestão tributária'), "TaxName", 'Nome Fiscal'), "TaxRate", 'Taxa de imposto'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Unidade de compras'), "managementUnitSales", 'Unidade de vendas'), "ShortName", 'Nome curto'), "PleaseSelectThesebeforeaddinganyproduct", 'Por favor, selecione estes antes de adicionar qualquer produto'), "StockAdjustement", 'Ajustamento'), "PleaseSelectWarehouse", 'Please Select warehouse before choose any product'), "StockTransfer", 'Stock Transfer'), "SelectPeriod", 'Select Period'), "ThisYear", 'This Year'), "ThisToday", 'This Today'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'This Month'), "ThisWeek", 'This Week'), "AdjustmentDetail", 'Adjustment Detail'), "ActivateUser", 'This User Has been Activated'), "DisActivateUser", 'This User Has been Deactivated'), "NotFound", 'Page not found.'), "oops", 'Ops! página não encontrada.'), "couldNotFind", 'Não foi possível encontrar a página que você estava procurando. Enquanto isso, você pode'), "ReturnDashboard", 'Voltar ao painel'), "hrm", 'HRM'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Employees", 'Funcionários'), "Attendance", 'Comparecimento'), "Leave_request", 'Deixar pedido'), "Leave_type", 'Tipo de licença'), "Company", 'Companhia'), "Departments", 'Departamentos'), "Designations", 'Designações'), "Office_Shift", 'Turno de escritório'), "Holidays", 'Feriados'), "Enter_Company_Name", 'Digite o nome da empresae'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Insira o endereço de e-mail'), "Enter_Company_Phone", 'Digite o telefone da empresa'), "Enter_Company_Country", 'Insira o país da empresa'), "Created_in_successfully", 'Criado com sucesso'), "Updated_in_successfully", 'Atualizado com sucesso'), "Deleted_in_successfully", 'Excluído com sucesso'), "department", 'Departamento'), "Enter_Department_Name", 'Digite o nome do departamento'), "Choose_Company", 'Escolha a empresa'), "Department_Head", 'Chefe de departamento'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Escolha o chefe de departamento'), "Enter_Shift_name", 'Digite o nome do turno'), "Monday_In", 'Segunda-feira'), "Monday_Out", 'Segunda-feira'), "Tuesday_In", 'Terça-feira In'), "tuesday_out", 'terça Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'Feriado'), "Enter_title", 'Digite o título'), "title", 'título'), "start_date", 'Data de início'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Enter start date'), "Finish_Date", 'Data de término'), "Enter_Finish_date", 'Insira a data de término'), "Please_provide_any_details", 'Por favor, forneça quaisquer detalhes'), "Attendances", 'Presenças'), "Enter_Attendance_date", 'Insira a data de atendimento'), "Time_In", 'Em vez'), "Time_Out", 'Tempo esgotado'), "Choose_Employee", 'Escolher funcionário'), "Employee", 'Empregado'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Duração do Trabalho'), "remaining_leaves_are_insufficient", 'As folhas restantes são insuficientes'), "Leave_Type", 'Tipo de licença'), "Days", 'Dias'), "Department", 'Departamento'), "Choose_leave_type", 'Escolha o tipo de licença'), "Choose_status", 'Escolha o status'), "Leave_Reason", 'Motivo de Saída'), "Enter_Reason_Leave", 'Digite o motivo da licença'), "Add_Employee", 'Adicionar funcionário'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FirstName", 'Primeiro nome'), "Enter_FirstName", 'Introduza o primeiro nome'), "LastName", 'Sobrenome'), "Enter_LastName", 'Insira o último nome'), "Gender", 'Gênero'), "Choose_Gender", 'Escolha o Gênero'), "Enter_Birth_date", 'Digite a data de nascimento'), "Birth_date", 'Data de nascimento'), "Enter_Country", 'Digite o país'), "Enter_Phone_Number", 'Digite o número de telefone'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "joining_date", 'Data de ingresso'), "Enter_joining_date", 'Insira a data de adesão'), "Choose_Designation", 'Escolha a designação'), "Designation", 'Designação'), "Office_Shift", 'Turno de escritório'), "Choose_Office_Shift", 'Escolha o turno do escritório'), "Enter_Leaving_Date", 'Digite a data de saída'), "Leaving_Date", 'Data partida'), "Annual_Leave", 'Banco de horas'), "Enter_Annual_Leave", 'Entrar férias anuais'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Licença restante'), "Employee_Details", 'Detalhes do funcionário'), "Basic_Information", 'Informação básica'), "Family_status", 'Situação familiar'), "Choose_Family_status", 'Escolha o status da família'), "Employment_type", 'Tipo de Emprego'), "Select_Employment_type", 'Selecione o tipo de emprego'), "Enter_City", 'Digite a cidade'), "Province", 'Província'), "Enter_Province", 'Digite a Província'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Insira o endereço'), "Enter_Zip_code", 'Digite o código postal'), "Zip_code", 'Código postal'), "Hourly_rate", 'Taxa horária'), "Enter_Hourly_rate", 'Insira a taxa por hora'), "Basic_salary", 'Salário básico'), "Enter_Basic_salary", 'Insira o salário base'), "Social_Media", 'Mídia social'), "Skype", 'Skype'), "Enter_Skype", 'Enter Skype'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), "Enter_Facebook", 'Enter Facebook'), "WhatsApp", 'WhatsApp'), "Enter_WhatsApp", 'Enter WhatsApp'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", 'Enter LinkedIn'), "Twitter", 'Twitter'), "Enter_Twitter", 'Enter Twitter'), "Experiences", 'Experiências'), "bank_account", 'conta bancária'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Company_Name", 'nome da empresa'), "Location", 'Location'), "Enter_location", 'Enter location'), "Enter_Description", 'Enter Description'), "Bank_Name", 'Nome do banco'), "Enter_Bank_Name", 'Digite o nome do banco'), "Bank_Branch", 'Agência bancária'), "Enter_Bank_Branch", 'Entrar na agência bancária'), "Bank_Number", 'Número do banco'), "Enter_Bank_Number", 'Digite o número do banco'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Acessar armazéns'), "Top_customers", 'Melhores clientes'), "Attachment", 'Acessório'), "view_employee", 'ver funcionário'), "edit_employee", 'Editar funcionário'), "delete_employee", 'Excluir funcionário'), "Created_by", 'Adicionado por'), "Add_product_IMEI_Serial_number", 'Adicionar IMEI/Número de Série do produto'), "Product_Has_Imei_Serial_number", 'O Produto Tem Imei/Número de Série'), "IMEI_SN", 'IMEI/SN'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Shipments", 'Remessos'), "delivered_to", 'Entregue a'), "shipment_ref", 'Referência de remessa'), "sale_ref", 'Referência de venda'), "Edit_Shipping", 'Editar envio'), "Packed", 'Embalado'), "Shipped", 'Enviado'), "Delivered", 'Entregue'), "Cancelled", 'Cancelado'), "Shipping_status", 'Status de envio'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Relatório de usuários'), "stock_report", 'Relatório de Estoque'), "TotalPurchases", 'Total de Compras'), "Total_quotations", 'Cotações totais'), "Total_return_sales", 'Vendas totais de retorno'), "Total_return_purchases", 'Total de compras de devolução'), "Total_transfers", 'Transferências totais'), "Total_adjustments", 'Ajustes totais'), "User_report", 'Relatório do usuário'), "Current_stock", 'Estoque atual'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_name", 'Nome do Produto'), "Total_Customers_Due", 'Dívida total'), "Total_Suppliers_Due", 'Dívida total'), "Some_warehouses", 'Alguns Armazéns'), "All_Warehouses", 'Todos os Armazéns'), "Product_Cost", 'Custo do produto'), "sms_settings", 'Configurações de SMS'), "pos_settings", 'Configurações de PDV'), "payment_gateway", 'Gateway de pagamento'), "mail_settings", 'Configurações de e-mail'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'Gateway de SMS padrão'), "module_settings", 'Configurações do módulo'), "Module_enabled_success", 'Módulo ativado com sucesso'), "Module_Disabled_success", 'Módulo desativado com sucesso'), "update_settings", 'Melhoria'), "Please_Upload_the_Correct_Module", 'Por favor, carregue o módulo correto'), "Uploaded_Success", 'Enviado com sucesso'), "Customer_details", 'Detalhes do cliente'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Editar cliente'), "Delete_Customer", 'Excluir cliente'), "Pay_Due", 'Pagamento devido'), "Paying_amount_is_greater_than_Total_Due", 'O valor do pagamento é maior que o total devido'), "Customer_Invoice", 'Fatura do cliente'), "This_Product_Not_For_Selling", 'Este Produto Não Para Venda'), "Welcome_to_your_Dashboard", 'Bem-vindo ao seu painel'), "Total_Payable", 'Total a pagar'), "Choose_Sale_Ref", 'Escolher referência de venda'), "Please_Select_Sale", 'Selecione a venda'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Referência de venda'), "list_product_returns", 'Listar devoluções de produtos'), "Qty_return", 'Devolução de quantidade'), "Choose_Purchase_Ref", 'Escolha a referência de compra'), "Purchase_Ref", 'Referência de compra'), "please_select_purchase", 'Por favor selecione a compra'), "qty_return_is_greater_than_qty_purchased", 'O retorno da quantidade é maior que a quantidade comprada'), "qty_return_is_greater_than_qty_sold", 'O retorno da quantidade é maior que a quantidade vendida'), "Quantity_sold", 'Quantidade vendida'), "qty_purchased", 'Quantidade comprada'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Nome do remetente'), "The_module_must_be_uploaded_as_zip_file", 'O módulo deve ser carregado como arquivo zip'), "Upload_Module", 'Módulo de upload'), "All_Modules_Installed", 'Todos os módulos instalados'), "Current_Version", 'Versão Atual'), "You_already_have_the_latest_version", 'Você já tem a versão mais recente'), "Update_Available", 'Atualização disponível'), "Update_Log", 'Atualizar registro'), "Update_Now", 'Atualizar agora'), "View_Change_Log", 'Visualizar registro de alteração'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'NOTA: Aguarde até que a atualização termine completamente. Não é recomendado fechar o navegador ou parar um processo Upgrade'), "Note_update", 'Nota: Certifique-se de fazer backup de sua versão atual e banco de dados antes de executar a atualização, para restaurá-la se houver um erro'), "invoice_footer", 'Rodapé da fatura'), "Time_Zone", 'Fuso horário'), "Payment_note", 'Notas de pagamento'), "sale_note", 'Notas de venda'), "Total_Sale_Due", 'Venda total devida'), "Total_Sell_Return_Due", 'Dívida Total de Devolução de Venda'), "pay_all_sell_due_at_a_time", 'pagar todas as dívidas de venda de uma só vez'), "pay_all_sell_return_due_at_a_time", 'pagar todas as dívidas de retorno de venda de uma só vez'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Lucro bruto'), "pay_all_purchase_due_at_a_time", 'pagar todas as dívidas de compra de uma só vez'), "Delete_Provider", 'Excluir provedor'), "Edit_Provider", 'Editar provedor'), "Provider_details", 'Detalhes do provedor'), "Total_Purchase_Due", 'Dívida total de compra'), "Provider_Credit_Note", 'Nota de crédito'), "Customer_Credit_Note", 'Nota de crédito'), "Sell_Return", 'Vender Devolução'), "Purchase_Return", 'Devolução de compra'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Número fiscal'), "Please_add_return_quantity", 'Adicione a quantidade de devolução'), "Return_exist_for_the_Transaction", 'O retorno existe para a transação'), "qty_return_is_greater_than_Quantity_Remaining", 'Qtde retorno é maior que Quantidade Restante'), "products_refunded_alert", 'Quaisquer produtos com uma quantidade definida como 0 não serão reembolsados'), "pay_all_purchase_return_due_at_a_time", 'pagar todas as dívidas de devolução de compra de uma só vez'), "Total_Purchase_Return_Due", 'Dívida total de devolução de compra'), "Purchase_return_due", 'Dívida de devolução de compra'), "Sell_return_due", 'dívida de retorno de venda'), "product_report", 'Relatório do produto'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'relatório de vendas de produtos'), "Product_purchases_report", 'Relatório de compras de produtos'), "Qty_sold", 'quantidade vendida'), "Qty_purchased", 'quantidade comprada'), "Filter_by_warehouse", 'Filtrar por armazém'), "Enable_Print_Invoice", 'Imprimir fatura automaticamente'), "Show_Warehouse", 'Mostrar armazém'), "credit_card_info", 'Informações do cartão de crédito'), "Saved_Credit_Card_Info", 'Informações do cartão de crédito salvas'), "Credit_card_changed_successfully", 'Cartão de crédito alterado com sucesso'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "notification_template", 'Modelo de notificação'), "email_notification", 'Notificação por e-mail'), "sms_notification", 'Notificação por SMS'), "Change_product_details", 'Alterar detalhes do produto'), "edit_tax_and_discount_and_shipping", 'Editar impostos, descontos e envio'), "Create_Quotation_with_Stock", 'Criar cotação com estoque'), "Variant_Name", 'Nome da variante'), "Variant_cost", 'Custo da variante'), "Variant_price", 'Preço da variante'), "Variant_code", 'Código da variante'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Por favor, aguarde até que o produto seja carregado'), "Choose_SMS_Gateway", 'Escolha um gateway SMS'), "Notification_Client", 'Notificação para o cliente'), "Available_Tags", 'Tags disponíveis'), "Email_Subject", 'Assunto do e-mail'), "Email_body", 'Corpo do e-mail'), "Notification_Supplier", 'Notificação para o fornecedor'), "sms_body", 'Corpo do SMS'), "sms_templates", 'Modelos de SMS'), "email_templates", 'Modelos de e-mail'));

/***/ }),

/***/ "./resources/src/translations/locales/da.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/da.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
// Danish language

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Kvittering',
  Pos_Settings: 'POS-indstillinger (kvittering)',
  Note_to_customer: 'Bemærkning til kunden',
  Show_Note_to_customer: 'Vis bemærkning til kunden',
  Show_barcode: 'Vis stregkode',
  Show_Tax_and_Discount: 'Vis moms & rabat & levering',
  Show_Customer: 'Vis kunde',
  Show_Email: 'Vis e-mail',
  Show_Phone: 'Vis telefon',
  Show_Address: 'Vis adresse',
  DefaultLanguage: 'Standardsprog',
  footer: 'footer',
  Received_Amount: 'Modtaget beløb',
  Paying_Amount: 'Betalingsbeløb',
  Change: 'Retur',
  Paying_amount_is_greater_than_Received_amount: 'Betalingsbeløb er større end modtaget beløb',
  Paying_amount_is_greater_than_Grand_Total: 'Betalingsbeløb er større end det samlede beløb',
  code_must_be_not_exist_already: 'koden skal ikke eksistere allerede',
  You_will_find_your_backup_on: 'Du finder din sikkerhedskopi på',
  and_save_it_to_your_pc: 'og gem det på din pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Scan din stregkode og vælg den korrekte symbologi nedenfor',
  Scan_Search_Product_by_Code_Name: 'Scan / Søg produkt ved kode eller navn',
  Paper_size: 'Papirstørrelse',
  Clear_Cache: 'Ryd cache',
  Cache_cleared_successfully: 'Cache ryddet med succes',
  Failed_to_clear_cache: 'Mislykkedes i at rydde cache',
  Scan_Barcode: 'Stregkode-scanner',
  Please_use_short_name_of_unit: 'Brug venligst en kort navneform for enheden',
  DefaultCustomer: 'Standardkunde',
  DefaultWarehouse: 'Standardlager',
  Payment_Gateway: 'Betalings-gateway',
  SMS_Configuration: 'SMS-konfiguration',
  Gateway: 'SMS-gateway',
  Choose_Gateway: 'Vælg SMS-gateway',
  Send_SMS: 'Besked sendt med succes',
  sms_config_invalid: 'forkert sms-konfig invalid',
  Remove_Stripe_Key_Secret: 'Slet Stripe API-nøgler',
  credit_card_account_not_available: 'Kreditkortkonto ikke tilgængelig',
  Credit_Card_Info: 'Kreditkort-oplysninger',
  developed_by: 'Udviklet af',
  Unit_already_linked_with_sub_unit: 'Unit already linked with sub unit',
  Total_Items_Quantity: 'Antal varer og mængde',
  Value_by_Cost_and_Price: 'Værdi efter omkostninger og pris',
  Search_this_table: 'Søg i denne tabel',
  import_products: 'Importere produkter',
  Field_optional: 'Valgfri felt',
  Download_exemple: 'Download eksempel',
  field_must_be_in_csv_format: 'Feltet skal være i csv-format',
  Successfully_Imported: 'Importeret med succes',
  file_size_must_be_less_than_1_mega: 'Filstørrelsen skal være mindre end 1 mega',
  Please_follow_the_import_instructions: 'Følg venligst importvejledningen',
  must_be_exist: 'enheden skal allerede være oprettet',
  Import_Customers: 'Importere kunder',
  Import_Suppliers: 'Importere leverandører',
  Recent_Sales: 'Seneste salg',
  Create_Transfer: 'Opret overførsel',
  order_products: 'Bestil varer',
  Search_Product_by_Code_Name: 'Søg efter produkt ved kode eller navn',
  Reports_payments_Purchase_Return: 'Rapporter købsreturbetalinger',
  Reports_payments_Sale_Return: 'Rapporter salgsreturbetalinger',
  payments_Sales_Return: 'Betalinger salgsreturnering',
  payments_Purchases_Return: 'Betalinger købsreturnering',
  CreateSaleReturn: 'Opret salgsreturnering',
  EditSaleReturn: 'Rediger salgsreturnering',
  SalesReturn: 'Salgsreturnering',
  CreatePurchaseReturn: 'Opret købsreturnering',
  EditPurchaseReturn: 'Rediger købsreturnering',
  PurchasesReturn: 'Købsreturnering',
  Due: 'Forfalden',
  Profit: 'Profit',
  Revenue: 'Indtægt',
  Sales_today: 'Dagens salg',
  People: 'Mennesker',
  Successfully_Created: 'Oprettet med succes',
  Successfully_Updated: 'Opdateret med succes',
  Success: 'Succes',
  Failed: 'Mislykkedes',
  Warning: 'Advarsel',
  Please_fill_the_form_correctly: 'Udfyld venligst formularen korrekt',
  Field_is_required: 'Dette felt er påkrævet',
  Error: 'Fejl!',
  you_are_not_authorized: 'Beklager! Du har ikke adgang.',
  Go_back_to_home: 'Gå tilbage til hjemmesiden',
  page_not_exist: 'Beklager! Siden du ledte efter eksisterer ikke.',
  Choose_Status: 'Vælg status',
  Choose_Method: 'Vælg metode',
  Choose_Symbology: 'Vælg symbolik',
  Choose_Category: 'Vælg kategori',
  Choose_Customer: 'Vælg kunde',
  Choose_Supplier: 'Vælg leverandør',
  Choose_Unit_Purchase: 'Vælg købsenhed',
  Choose_Sub_Category: 'Vælg underkategori',
  Choose_Brand: 'Vælg mærke',
  Choose_Warehouse: 'Vælg lager',
  Choose_Unit_Sale: 'Vælg salgsenhed',
  Enter_Product_Cost: 'Indtast produktomkostninger',
  Enter_Stock_alert: 'Indtast lageradvarsler',
  Choose_Unit_Product: 'Vælg produktenhed',
  Enter_Product_Price: 'Indtast produktpris',
  Enter_Name_Product: 'Indtast produktnavn',
  Enter_Role_Name: 'Indtast rolle navn',
  Enter_Role_Description: 'Indtast rolle beskrivelse',
  Enter_name_category: 'Indtast kategorinavn',
  Enter_Code_category: 'Indtast kategorikode',
  Enter_Name_Brand: 'Indtast mærkenavn',
  Enter_Description_Brand: 'Indtast mærkebeskrivelse',
  Enter_Code_Currency: 'Indtast valutakode',
  Enter_name_Currency: 'Indtast valutanavn',
  Enter_Symbol_Currency: 'Indtast valutasymbol',
  Enter_Name_Unit: 'Indtast enhedsnavn',
  Enter_ShortName_Unit: 'Indtast kort navn for enhed',
  Choose_Base_Unit: 'Vælg grundenhed',
  Choose_Operator: 'Vælg operatør',
  Enter_Operation_Value: 'Indtast operationens værdi',
  Enter_Name_Warehouse: 'Indtast lager navn',
  Enter_Phone_Warehouse: 'Indtast lager telefon',
  Enter_Country_Warehouse: 'Indtast lager land',
  Enter_City_Warehouse: 'Indtast lager by',
  Enter_Email_Warehouse: 'Indtast lager email',
  Enter_ZipCode_Warehouse: 'Indtast lager postnummer',
  Choose_Currency: 'Vælg valuta',
  Thank_you_for_your_business: 'Tak fordi du shoppede hos os. Kom igen',
  Cancel: 'Annuller',
  New_Customer: 'Ny kunde',
  Incorrect_Login: 'Forkert login',
  Successfully_Logged_In: 'Du er nu logget ind',
  This_user_not_active: 'Denne bruger er ikke aktiv',
  SignIn: 'Log ind',
  Create_an_account: 'Opret en konto',
  Forgot_Password: 'Glemt adgangskode?',
  Email_Address: 'E-mailadresse',
  SignUp: 'Tilmeld dig',
  Already_have_an_account: 'Har du allerede en konto?',
  Reset_Password: 'Nulstil adgangskode',
  Failed_to_authenticate_on_SMTP_server: 'Det lykkedes ikke at godkende på SMTP-server',
  We_cant_find_a_user_with_that_email_addres: 'Vi kan ikke finde en bruger med den e-mail-adresse',
  We_have_emailed_your_password_reset_link: 'Vi har sendt en e-mail med din link til nulstilling af adgangskode',
  Please_fill_the_Email_Adress: 'Udfyld venligst e-mail-adressen',
  Confirm_password: 'Bekræft adgangskode',
  Your_Password_has_been_changed: 'Din adgangskode er blevet ændret',
  The_password_confirmation_does_not_match: 'Bekræftelse af adgangskode passer ikke',
  This_password_reset_token_is_invalid: 'Token til nulstilling af adgangskode er ugyldig',
  Warehouse_report: 'Lagerrapport',
  All_Warehouses: 'Alle lagre',
  Expense_List: 'Alle udgifter',
  Expenses: 'Udgifter',
  This_Week_Sales_Purchases: 'Denne uges salg & køb',
  Top_Selling_Products: 'Top sælgende produkter',
  View_all: 'Vis alle',
  Payment_Sent_Received: 'Betaling sendt & modtaget',
  Filter: 'Filter',
  Invoice_POS: 'Faktura POS',
  Invoice: 'Faktura',
  Customer_Info: 'Kundeinfo',
  Company_Info: 'Firmainfo',
  Invoice_Info: 'Fakturainfo',
  Order_Summary: 'Ordreoversigt',
  Quote_Info: 'Tilbudsinfo',
  Del: 'Slet',
  SuppliersPaiementsReport: 'Rapport over leverandørbetalinger',
  Purchase_Info: 'Købsinfo',
  Supplier_Info: 'Leverandørinfo',
  Return_Info: 'Info om returnering',
  Expense_Category: 'Udgiftkategori',
  Create_Expense: 'Opret udgift',
  Details: 'Detaljer',
  Discount_Method: 'Rabattype',
  Net_Unit_Cost: 'Netto enhedskost',
  Net_Unit_Price: 'Netto enhedspris',
  Edit_Expense: 'Rediger udgift',
  All_Brand: 'Alle mærker',
  All_Category: 'Alle kategorier',
  ListExpenses: 'Alle udgifter',
  Create_Permission: 'Opret tilladelse',
  Edit_Permission: 'Rediger tilladelse',
  Reports_payments_Sales: 'Rapporter betalinger Salg',
  Reports_payments_Purchases: 'Rapporter betalinger Køb',
  Reports_payments_Return_Customers: 'Betalingsretur kunder',
  Reports_payments_Return_Suppliers: 'Betalingsretur leverandører',
  Expense_Deleted: 'Denne udgift er blevet slettet',
  Expense_Updated: 'Denne udgift er blevet opdateret',
  Expense_Created: 'Denne udgift er blevet oprettet',
  DemoVersion: 'Du kan ikke gøre dette i demo-versionen',
  OrderStatistics: 'Salgsstatistikker',
  AlreadyAdd: 'Dette produkt er allerede tilføjet !!',
  AddProductToList: 'Tilføj venligst produkt til liste !!',
  AddQuantity: 'Tilføj venligst mængde af produkt !!',
  InvalidData: 'Ugyldige data !!',
  LowStock: 'Antallet overstiger antallet, der er tilgængeligt på lageret',
  WarehouseIdentical: 'De to lagre kan ikke være identiske !!',
  VariantDuplicate: 'Denne variant er en duplikat !!',
  Filesize: 'Filstørrelse',
  GenerateBackup: 'Generer sikkerhedskopi',
  BackupDatabase: 'Sikkerhedskopier database',
  Backup: 'Sikkerhedskopi',
  Paid: 'Betalt',
  Unpaid: 'Ubetalte',
  Today: 'I dag',
  Income: 'Indtægt'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'Udgifter'), "Sale", 'Salg'), "Actif", 'Aktiv'), "Inactif", 'Inaktiv'), "Customers", 'Kunder'), "Phone", 'Telefon'), "SearchByPhone", 'Søg efter telefonnummer'), "Suppliers", 'Leverandører'), "Quotations", 'Tilbud'), "Sales", 'Salg'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'Køb'), "Returns", 'Returnering'), "Settings", 'Indstillinger'), "SystemSettings", 'Systemindstillinger'), "Users", 'Brugere'), "GroupPermissions", 'Gruppe tilladelser'), "Currencies", 'Valuta'), "Warehouses", 'Lager'), "Units", 'Enhed'), "UnitsPrchases", 'Køb enheder'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Salg enheder'), "Reports", 'Rapporter'), "PaymentsReport", 'Betalingsrapport'), "PaymentsPurchases", 'Betalinger køb'), "PaymentsSales", 'Betalinger salg'), "ProfitandLoss", 'Fortjeneste og tab'), "WarehouseStockChart", 'Lagerbeholdningsoversigt'), "SalesReport", 'Salgsrapport'), "PurchasesReport", 'Købsrapport'), "CustomersReport", 'Kunderapport'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Leverandørrapport'), "SupplierReport", 'Leverandørrapport'), "DailySalesData", 'Daglige salgsdata'), "DailyPurchasesData", 'Daglige købsdata'), "Derni\xE8rescinqrecords", 'Sidste fem poster'), "Filters", 'Filtre'), "date", 'Dato'), "Reference", 'Reference'), "Supplier", 'Leverandør'), "PaymentStatus", 'Betalingsstatus'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", 'Kunde'), "CustomerCode", 'Kundekode'), "Status", 'Status'), "SupplierCode", 'Leverandørkode'), "Categorie", 'Kategori'), "Categories", 'Kategorier'), "StockTransfers", 'Overførsel'), "StockManagement", 'Lagerstyring'), "dashboard", 'Dashboard'), "Products", 'Produkter'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'Alle produkter'), "ProductManagement", 'Produktstyring'), "ProductQuantityAlerts", 'Produktmængdealarmer'), "CodeProduct", 'Produktkode'), "ProductTax", 'Produktmoms'), "SubCategorie", 'Underkategori'), "Name_product", 'Navn'), "StockAlert", 'Lageralarm'), "warehouse", 'Lager'), "Tax", 'Moms'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Indkøbspris'), "SellPrice", 'Salgspris'), "Quantity", 'Mængde'), "UnitSale", 'Salgsenhed'), "UnitPurchase", 'Indkøbsenhed'), "ManagementCurrencies", 'Valutastyring'), "CurrencyCode", 'Valutakode'), "CurrencyName", 'Valutanavn'), "Symbol", 'Symbol'), "All", 'Alle'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Rediger produkt'), "SearchByCode", 'Søg efter kode'), "SearchByName", 'Søg efter navn'), "ProductDetails", 'Produktdetaljer'), "CustomerName", 'Kundenavn'), "CustomerManagement", 'Kundestyring'), "Add", 'Opret'), "add", 'Opret'), "Edit", 'Rediger'), "Close", 'Luk'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Vælg venligst'), "Action", 'Handling'), "Email", 'E-mail'), "EditCustomer", 'Rediger kunde'), "AddCustomer", 'Opret kunde'), "Country", 'Land'), "City", 'By'), "Adress", 'Adresse'), "CustomerDetails", 'Kundedetaljer'), "CustomersList", 'Kunder'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierName", 'Leverandørnavn'), "SuppliersManagement", 'Leverandørstyring'), "SupplierDetails", 'Leverandørdetaljer'), "QuotationsManagement", 'Tilbudsstyring'), "SupplierCode", 'Leverandørkode'), "SubTotal", 'Subtotal'), "MontantReste", 'Beløb tilbage'), "complete", 'Fuldført'), "EnAttendant", 'Afventer'), "Recu", 'Modtaget'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", 'Delvist'), "Retournee", 'Returneret'), "DetailQuote", 'Detaljeret tilbud'), "EditQuote", 'Rediger tilbud'), "CreateSale", 'Opret salg'), "DownloadPdf", 'Download PDF'), "QuoteEmail", 'Send tilbud på e-mail'), "DeleteQuote", 'Slet tilbud'), "AddQuote", 'Opret tilbud'), "SelectProduct", 'Vælg produkt'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Produkt (Kode - Navn)'), "Price", 'Pris'), "CurrentStock", 'Lagerbeholdning'), "Total", 'Total'), "Num", 'Nr.'), "Unitcost", 'Enhedsomkostninger'), "to", 'Til'), "Subject", 'Emne'), "Message", 'Besked'), "EmailCustomer", 'E-mail kunde'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", 'Sendt'), "Quote", 'Tilbud'), "Hello", 'Hej'), "AttachmentQuote", 'Vedhæftning af tilbud'), "AddProducts", 'Tilføj produkter til ordreliste'), "SelectWarehouse", 'Vælg venligst lager'), "SelectCustomer", 'Vælg venligst kunde'), "SalesManagement", 'Salgsstyring'), "Balance", 'Balance'), "QtyBack", 'Antal tilbage'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Total returnering'), "Amount", 'Beløb'), "SaleDetail", 'Salgsdetaljer'), "EditSale", 'Rediger salg'), "AddSale", 'Opret salg'), "ShowPayment", 'Vis betalinger'), "AddPayment", 'Opret betaling'), "EditPayment", 'Rediger betaling'), "EmailSale", 'Send salg pr. e-mail'), "DeleteSale", 'Slet salg'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Betalingsmåde'), "Paymentchoice", 'Betalingstype'), "Note", 'Bemærkning'), "PaymentComplete", 'Betaling fuldført!'), "PurchasesManagement", 'Indkøbsstyring'), "Ordered", 'Bestilt'), "DeletePurchase", 'Slet køb'), "EmailPurchase", 'Send køb pr. e-mail'), "EditPurchase", 'Rediger køb'), "PurchaseDetail", 'Købsdetaljer'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Opret køb'), "EmailSupplier", 'Leverandør e-mail'), "PurchaseInvoice", 'Indkøbsbetalinger'), "PurchasesInvoicesData", 'Data om indkøbsbetalinger'), "SalesInvoice", 'Salgsbetalinger'), "SalesInvoicesData", 'Data om salgsbetalinger'), "UserManagement", 'Brugerstyring'), "Firstname", 'Fornavn'), "lastname", 'Efternavn'), "username", 'Brugernavn'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", 'Adgangskode'), "Newpassword", 'Ny adgangskode'), "ChangeAvatar", 'Skift avatar'), "LeaveBlank", 'Lad dette felt være blankt, hvis du ikke har ændret det'), "type", 'Type'), "UserPermissions", 'Brugerrettigheder'), "RoleName", 'Rolle'), "RoleDescription", 'Rollebeskrivelse'), "AddPermissions", 'Opret rettigheder'), "View", 'Vis'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", 'Slet'), "NewAdjustement", 'Nye justeringer'), "EditAdjustement", 'Rediger justeringer'), "CannotSubstraction", 'Du kan ikke trække produkter fra med en lagerbeholdning på 0'), "Addition", 'Tilføjelse'), "Subtraction", 'Fratrækning'), "profil", 'Profil'), "logout", 'Log ud'), "PurchaseAlreadyPaid", 'Du kan ikke ændre dette, da købet allerede er betalt'), "SaleAlreadyPaid", 'Du kan ikke ændre dette, da salget allerede er betalt'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'Du kan ikke ændre dette, da returneringen allerede er betalt'), "QuoteAlready", 'Dette tilbud har allerede genereret et salg'), "AddProduct", 'Opret produkt'), "QuotationComplete", 'Dette tilbud er færdigt'), "SiteConfiguration", 'Webstedsopsætning'), "Language", 'Sprog'), "DefaultCurrency", 'Standardvaluta'), "LoginCaptcha", 'Login Captcha'), "DefaultEmail", 'Standard-email'), "SiteName", 'Webstedsnavn'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Skift logo'), "SMTPConfiguration", 'SMTP-opsætning'), "HOST", 'MAIL_HOST'), "PORT", 'MAIL_PORT'), "encryption", 'MAIL_ENCRYPTION'), "SMTPIncorrect", 'SMTP-opsætning er forkert'), "PaymentsReturns", 'Betaling og returnering'), "ReturnsInvoices", 'Returner fakturaer'), "ReturnsInvoicesData", 'Data for returnerede fakturaer'), "ShowAll", 'Vis alle poster for alle brugere'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", 'Rabat'), "OrderTax", 'Moms'), "Shipping", 'Forsendelse'), "CompanyName", 'Firmanavn'), "CompanyPhone", 'Firmaets telefon'), "CompanyAdress", 'Firmaadresse'), "Code", 'Kode'), "image", 'Billede'), "Printbarcode", 'Udskriv etiketter'), "ReturnsCustomers", 'Kundeafkast'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Leverandørafkast'), "FactureReturnCustomers", 'Faktura for kundeaftale'), "FactureReturnSuppliers", 'Faktura for leverandøraftale'), "NodataAvailable", 'Ingen data tilgængelige'), "ProductImage", 'Produktbillede'), "Barcode", 'Stregkode'), "pointofsales", 'Salgssted'), "CustomUpload", 'Brugerdefineret upload'), "pointofsaleManagement", 'Salgsstedshåndtering'), "Adjustment", 'Justering'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", 'Opdater'), "Reset", 'Nulstil'), "print", 'Udskriv'), "SearchByEmail", 'Søg efter e-mail'), "ChooseProduct", 'Vælg produkt'), "Qty", 'Antal'), "Items", 'Varer'), "AmountHT", 'Beløb ekskl. moms'), "AmountTTC", 'Beløb inkl. moms'), "PleaseSelectSupplier", 'Vælg venligst leverandør'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Vælg venligst status'), "PayeBy", 'Betalt af'), "ChooseWarehouse", 'Vælg lager'), "payNow", 'Betal nu'), "ListofCategory", 'Liste over kategorier'), "Description", 'Beskrivelse'), "submit", 'Indsend'), "ProblemCreatingThisInvoice", 'Der opstod et problem med at oprette denne faktura. Prøv igen'), "ProblemPayment", 'Der opstod et problem med betalingen. Prøv igen.'), "IncomeExpenses", 'Indtægter og Udgifter'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'Daglige Salg og Køb'), "ProductsExpired", 'Udløbne Produkter'), "ListofBrand", 'Mærker'), "CreateAdjustment", 'Opret Justering'), "Afewwords", 'Et par ord ...'), "UserImage", 'Bruger Billede'), "UpdateProduct", 'Opdater Produkt'), "Brand", 'Mærke'), "BarcodeSymbology", 'Stregkodesymbolik'), "ProductCost", 'Produktomkostninger'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Produktpris'), "UnitProduct", 'Produktenhed'), "TaxMethod", 'Momstype'), "MultipleImage", 'Flere Billeder'), "ProductHasMultiVariants", 'Dette produkt har flere varianter'), "ProductHasPromotion", 'Produktet har en kampagne'), "PromotionStart", 'Kampagnen starter'), "PromotionEnd", 'Kampagnen slutter'), "PromotionPrice", 'Kampagnepris'), "Price", 'Pris'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Cost", 'Omkostninger'), "Unit", 'Enhed'), "ProductVariant", 'Produktvariant'), "Variant", 'Variant'), "UnitPrice", 'Enhedspris'), "CreateReturnCustomer", 'Opret Tilbagevendende Kunde'), "EditReturnCustomer", 'Rediger Tilbagevendende Kunde'), "CreateReturnSupplier", 'Opret Tilbagevendende Leverandør'), "Documentation", 'Dokumentation'), "EditReturnSupplier", 'Rediger Tilbagevendende Leverandør'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'Fra Lager'), "ToWarehouse", 'Til Lager'), "EditTransfer", 'Rediger Overførsel'), "TransferDetail", 'Overførselsdetaljer'), "Pending", 'Afventer'), "Received", 'Modtaget'), "Ordered", 'Bestilt'), "PermissionsManager", 'Rettigheder'), "BrandManager", 'Mærke'), "BrandImage", 'Mærke Billede'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BrandName", 'Mærke Navn'), "BrandDescription", 'Mærke Beskrivelse'), "BaseUnit", 'Basisenhed'), "ManagerUnits", 'Enhedshåndtering'), "OperationValue", 'Operation Værdi'), "Operator", 'Operatør'), "Top5Products", 'Top 5 Produkter'), "Last5Sales", 'Sidste 5 Salg'), "ListAdjustments", 'Alle Justeringer'), "ListTransfers", 'Alle Overførsler'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Opret Overførsel'), "OrdersManager", 'Ordre Håndtering'), "ListQuotations", 'Alle Tilbud'), "ListPurchases", 'Alle Køb'), "ListSales", 'Alle Salg'), "ListReturns", 'Alle Returneringer'), "PeopleManager", 'Personhåndtering'), "Delete", {
  Titel: 'Er du sikker?',
  Tekst: 'Du kan ikke fortryde dette!',
  confirmButtonText: 'Ja, slet det!',
  cancelButtonText: 'Annuller',
  Slettet: 'Slettet!',
  Mislykkedes: 'Mislykkedes!',
  DerVarNogetGalt: 'Der var noget galt',
  KundeSlettet: 'Denne kunde er blevet slettet.',
  LeverandørSlettet: 'Denne leverandør er blevet slettet.',
  TilbudsSlettet: 'Dette tilbud er blevet slettet.',
  SalgSlettet: 'Dette salg er blevet slettet.',
  BetalingSlettet: 'Denne betaling er blevet slettet.',
  KøbSlettet: 'Dette køb er blevet slettet.',
  ReturneringSlettet: 'Denne returnering er blevet slettet.',
  ProduktSlettet: 'Dette produkt er blevet slettet.',
  KundeFejl: 'Denne kunde er allerede tilknyttet en anden operation',
  LeverandørFejl: 'Denne leverandør er allerede tilknyttet en anden operation',
  BrugerSlettet: 'Denne bruger er blevet slettet.',
  EnhedSlettet: 'Denne enhed er blevet slettet.',
  RolleSlettet: 'Denne rolle er blevet slettet.',
  SkatSlettet: 'Denne skat er blevet slettet.',
  UnderkategoriSlettet: 'Denne underkategori er blevet slettet.',
  KategoriSlettet: 'Denne kategori er blevet slettet.',
  LagerSlettet: 'Dette lager er blevet slettet.',
  AlleredeTilknyttet: 'Dette produkt er allerede tilknyttet en anden operation',
  JusteringSlettet: 'Denne justering er blevet slettet.',
  ValutaTitel: 'Denne valuta er blevet slettet.',
  Overførselstitel: 'Overførslen er blevet fjernet med succes',
  BackupSlettet: 'Backup er blevet fjernet med succes',
  MærkeTitel: 'Dette mærke er blevet slettet'
}), "Update", {
  TitleBrand: 'Dette brand er blevet opdateret',
  TitleProfile: 'Din profil er blevet opdateret succesfuldt',
  TitleAdjust: 'Justering er blevet opdateret succesfuldt',
  TitleRole: 'Rolle er blevet opdateret succesfuldt',
  TitleUnit: 'Enhed er blevet opdateret succesfuldt',
  TitleUser: 'Bruger er blevet opdateret succesfuldt',
  TitleCustomer: 'Kunde er blevet opdateret succesfuldt',
  TitleQuote: 'Tilbud er blevet opdateret succesfuldt',
  TitleSale: 'Salg er blevet opdateret succesfuldt',
  TitlePayment: 'Betaling er blevet opdateret succesfuldt',
  TitlePurchase: 'Køb er blevet opdateret succesfuldt',
  TitleReturn: 'Returnering er blevet opdateret succesfuldt',
  TitleProduct: 'Produkt er blevet opdateret succesfuldt',
  TitleSupplier: 'Leverandør er blevet opdateret succesfuldt',
  TitleTaxe: 'Skat er blevet opdateret succesfuldt',
  TitleCat: 'Kategori er blevet opdateret succesfuldt',
  TitleWarhouse: 'Lager er blevet opdateret succesfuldt',
  TitleSetting: 'Indstillinger er blevet opdateret succesfuldt',
  TitleCurrency: 'Valuta er blevet opdateret succesfuldt',
  TitleTransfer: 'Overførsel er blevet opdateret succesfuldt'
}), "Create", {
  TitleBrand: 'Dette brand er blevet oprettet',
  TitleRole: 'Rolle er blevet oprettet succesfuldt',
  TitleUnit: 'Enhed er blevet oprettet succesfuldt',
  TitleUser: 'Bruger er blevet oprettet succesfuldt',
  TitleCustomer: 'Kunde er blevet oprettet succesfuldt',
  TitleQuote: 'Tilbud er blevet oprettet succesfuldt',
  TitleSale: 'Salg er blevet oprettet succesfuldt',
  TitlePayment: 'Betaling er blevet oprettet succesfuldt',
  TitlePurchase: 'Køb er blevet oprettet succesfuldt',
  TitleReturn: 'Returnering er blevet oprettet succesfuldt',
  TitleProduct: 'Produkt er blevet oprettet succesfuldt',
  TitleSupplier: 'Leverandør er blevet oprettet succesfuldt',
  TitleTaxe: 'Skat er blevet oprettet succesfuldt',
  TitleCat: 'Kategori er blevet oprettet succesfuldt',
  TitleWarhouse: 'Lager er blevet oprettet succesfuldt',
  TitleAdjust: 'Justering er blevet oprettet succesfuldt',
  TitleCurrency: 'Valuta er blevet oprettet succesfuldt',
  TitleTransfer: 'Overførsel er blevet oprettet succesfuldt'
}), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'E-mail Sendt'
}), "return", {
  TitleSale: 'Dette salg er allerede forbundet med en retur!'
}), "ReturnManagement", 'Returhåndtering'), "ReturnDetail", 'Returdetaljer'), "EditReturn", 'Rediger Retur'), "AddReturn", 'Opret Retur'), "EmailReturn", 'Send Retur på E-mail'), "DeleteReturn", 'Slet Retur'), "Retoursurcharge", 'Returgebyr'), "Laivrison", 'Levering'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Vælg Salg'), "ZeroPardefault", 'Du kan slette varen eller sætte antallet returneret til nul, hvis den ikke er returneret'), "Return", 'Retur'), "Purchase", 'Køb'), "TotalSales", 'Total Salg'), "TotalPurchases", 'Total Køb'), "TotalReturns", 'Total Retur'), "PaiementsNet", 'Netto Betalinger'), "PaiementsSent", 'Betalinger Sendt'), "PaiementsReceived", 'Betalinger Modtaget'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Recieved", 'Modtaget'), "Sent", 'Sendt'), "ProductQuantityAlerts", 'Advarsler om Produktmængde'), "ProductCode", 'Kode'), "ProductName", 'Produkt'), "AlertQuantity", 'Advarsel Mængde'), "WarehouseStockChart", 'Lageroversigt for Lager'), "TotalProducts", 'Total Produkter'), "TotalQuantity", 'Total Mængde'), "TopCustomers", 'Top 5 Kunder'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Total Beløb'), "TotalPaid", 'Total Betalt'), "CustomerSalesReport", 'Rapport for Kundefordring'), "CustomerPaiementsReport", 'Rapport for Kundebetalinger'), "CustomerQuotationsReport", 'Rapport for Kundetilbud'), "Payments", 'Betalinger'), "TopSuppliers", 'Top 5 Leverandører'), "SupplierPurchasesReport", 'Rapport for Leverandørkøb'), "SupplierPaiementsReport", 'Rapport for Leverandørbetalinger'), "Name", 'Navn'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Code", 'Kode'), "ManagementWarehouse", 'Lagerstyring'), "ZipCode", 'Postnummer'), "managementCategories", 'Kategori styring'), "Codecategorie", 'Kategori Kode'), "Namecategorie", 'Kategori Navn'), "Parentcategorie", 'Overordnet Kategori'), "managementTax", 'Skatte styring'), "TaxName", 'Skatte Navn'), "TaxRate", 'Skatte Sats'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Indkøbsenhed'), "managementUnitSales", 'Salgsenhed'), "ShortName", 'Kort Navn'), "PleaseSelectThesebeforeaddinganyproduct", 'Vælg venligst disse før du tilføjer et produkt'), "StockAdjustement", 'Lagerjustering'), "PleaseSelectWarehouse", 'Vælg venligst lager før du vælger et produkt'), "StockTransfer", 'Lageroverførsel'), "SelectPeriod", 'Vælg Periode'), "ThisYear", 'Dette År'), "ThisToday", 'I Dag'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'Denne Måned'), "ThisWeek", 'Denne Uge'), "AdjustmentDetail", 'Justering Detaljer'), "ActivateUser", 'Brugeren er blevet aktiveret'), "DisActivateUser", 'Brugeren er blevet deaktiveret'), "NotFound", 'Siden kunne ikke findes.'), "oops", 'Ups! Siden blev ikke fundet.'), "couldNotFind", 'Vi kunne ikke finde den side, du ledte efter. Imens kan du'), "ReturnDashboard", 'vende tilbage til oversigten'), "hrm", 'HRM'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Employees", 'Medarbejdere'), "Attendance", 'Tilstedeværelse'), "Leave_request", 'Anmodning om orlov'), "Leave_type", 'Orlovstype'), "Company", 'Virksomhed'), "Departments", 'Afdelinger'), "Designations", 'Designationer'), "Office_Shift", 'Arbejdstid'), "Holidays", 'Ferie'), "Enter_Company_Name", 'Indtast firmanavn'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Indtast e-mailadresse'), "Enter_Company_Phone", 'Indtast virksomhedstelefon'), "Enter_Company_Country", 'Indtast land for virksomheden'), "Created_in_successfully", 'Oprettet med succes'), "Updated_in_successfully", 'Opdateret med succes'), "Deleted_in_successfully", 'Slettet med succes'), "department", 'Afdeling'), "Enter_Department_Name", 'Indtast afdelingsnavn'), "Choose_Company", 'Vælg virksomhed'), "Department_Head", 'Afdelingsleder'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Vælg afdelingsleder'), "Enter_Shift_name", 'Indtast vagtnavn'), "Monday_In", 'Mandag start'), "Monday_Out", 'Mandag slut'), "Tuesday_In", 'Tirsdag start'), "tuesday_out", 'Tirsdag slut'), "wednesday_in", 'Onsdag start'), "wednesday_out", 'Onsdag slut'), "thursday_in", 'Torsdag start'), "thursday_out", 'Torsdag slut'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "friday_in", 'Fredag start'), "friday_out", 'Fredag slut'), "saturday_in", 'Lørdag start'), "saturday_out", 'Lørdag slut'), "sunday_in", 'Søndag start'), "sunday_out", 'Søndag slut'), "Holiday", 'Ferie'), "Enter_title", 'Indtast titel'), "title", 'Titel'), "start_date", 'Startdato'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Indtast startdato'), "Finish_Date", 'Slutdato'), "Enter_Finish_date", 'Indtast slutdato'), "Please_provide_any_details", 'Giv venligst nogle detaljer'), "Attendances", 'Tilstedeværelser'), "Enter_Attendance_date", 'Indtast tilstedeværelsesdato'), "Time_In", 'Tid ind'), "Time_Out", 'Tid ud'), "Choose_Employee", 'Vælg medarbejder'), "Employee", 'Medarbejder'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Arbejdstid'), "remaining_leaves_are_insufficient", 'Resterende orlov er utilstrækkeligt'), "Leave_Type", 'Orlovstype'), "Days", 'Dage'), "Department", 'Afdeling'), "Choose_leave_type", 'Vælg fraværstype'), "Choose_status", 'Vælg status'), "Leave_Reason", 'Fraværsårsag'), "Enter_Reason_Leave", 'Indtast fraværsårsag'), "Add_Employee", 'Tilføj medarbejder'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FirstName", 'Fornavn'), "Enter_FirstName", 'Indtast fornavn'), "LastName", 'Efternavn'), "Enter_LastName", 'Indtast efternavn'), "Gender", 'Køn'), "Choose_Gender", 'Vælg køn'), "Enter_Birth_date", 'Indtast fødselsdato'), "Birth_date", 'Fødselsdato'), "Enter_Country", 'Indtast land'), "Enter_Phone_Number", 'Indtast telefonnummer'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "joining_date", 'Indtrædelsesdato'), "Enter_joining_date", 'Indtast indtrædelsesdato'), "Choose_Designation", 'Vælg stilling'), "Designation", 'Stilling'), "Office_Shift", 'Kontor skift'), "Choose_Office_Shift", 'Vælg kontor skift'), "Enter_Leaving_Date", 'Indtast fratrædelsesdato'), "Leaving_Date", 'Fratrædelsesdato'), "Annual_Leave", 'Årligt fravær'), "Enter_Annual_Leave", 'Indtast årligt fravær'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Resterende fravær'), "Employee_Details", 'Medarbejderoplysninger'), "Basic_Information", 'Grundlæggende oplysninger'), "Family_status", 'Familie status'), "Choose_Family_status", 'Vælg familie status'), "Employment_type", 'Ansættelsestype'), "Select_Employment_type", 'Vælg ansættelsestype'), "Enter_City", 'Indtast by'), "Province", 'Region'), "Enter_Province", 'Indtast region'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Indtast adresse'), "Enter_Zip_code", 'Indtast postnummer'), "Zip_code", 'Postnummer'), "Hourly_rate", 'Timeløn'), "Enter_Hourly_rate", 'Indtast timeløn'), "Basic_salary", 'Grundløn'), "Enter_Basic_salary", 'Indtast grundløn'), "Social_Media", 'Sociale medier'), "Skype", 'Skype'), "Enter_Skype", 'Indtast Skype'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), "Enter_Facebook", 'Indtast Facebook'), "WhatsApp", 'WhatsApp'), "Enter_WhatsApp", 'Indtast WhatsApp'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", 'Indtast LinkedIn'), "Twitter", 'Twitter'), "Enter_Twitter", 'Indtast Twitter'), "Experiences", 'Erfaringer'), "bank_account", 'Bankkonto'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Company_Name", 'Firmanavn'), "Location", 'Placering'), "Enter_location", 'Indtast placering'), "Enter_Description", 'Indtast beskrivelse'), "Bank_Name", 'Banknavn'), "Enter_Bank_Name", 'Indtast banknavn'), "Bank_Branch", 'Bankfilial'), "Enter_Bank_Branch", 'Indtast bankfilial'), "Bank_Number", 'Banknummer'), "Enter_Bank_Number", 'Indtast banknummer'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Adgang til lagre'), "Top_customers", 'Bedste kunder'), "Attachment", 'Vedhæftning'), "view_employee", 'Se medarbejder'), "edit_employee", 'Rediger medarbejder'), "delete_employee", 'Slet medarbejder'), "Created_by", 'Tilføjet af'), "Add_product_IMEI_Serial_number", 'Tilføj produkt IMEI/serienummer'), "Product_Has_Imei_Serial_number", 'Produkt har IMEI/serienummer'), "IMEI_SN", 'IMEI/SN'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Shipments", 'Forsendelser'), "delivered_to", 'Leveret til'), "shipment_ref", 'Forsendelsesreferance'), "sale_ref", 'Salgsreferance'), "Edit_Shipping", 'Rediger forsendelse'), "Packed", 'Pakket'), "Shipped", 'Afsendt'), "Delivered", 'Leveret'), "Cancelled", 'Annulleret'), "Shipping_status", 'Forsendelsesstatus'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Bruger rapport'), "stock_report", 'Lager rapport'), "TotalPurchases", 'Samlede indkøb'), "Total_quotations", 'Samlede tilbud'), "Total_return_sales", 'Samlet tilbagesalg'), "Total_return_purchases", 'Samlet tilbagekøb'), "Total_transfers", 'Samlede overførsler'), "Total_adjustments", 'Samlede justeringer'), "User_report", 'Brugerrapport'), "Current_stock", 'Nuværende lagerbeholdning'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_name", 'Produktnavn'), "Total_Customers_Due", 'Total gæld (kunder)'), "Total_Suppliers_Due", 'Total gæld (leverandører)'), "Some_warehouses", 'Nogle lagre'), "All_Warehouses", 'Alle lagre'), "Product_Cost", 'Produktomkostninger'), "sms_settings", 'SMS-indstillinger'), "pos_settings", 'POS-indstillinger'), "payment_gateway", 'Betalingsgateway'), "mail_settings", 'Mail-indstillinger'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'Standard-SMS-gateway'), "module_settings", 'Modulindstillinger'), "Module_enabled_success", 'Modul aktiveret med succes'), "Module_Disabled_success", 'Modul deaktiveret med succes'), "update_settings", 'Opdatering'), "Please_Upload_the_Correct_Module", 'Upload venligst det korrekte modul'), "Uploaded_Success", 'Uploadet med succes'), "Customer_details", 'Kundedetaljer'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Rediger kunde'), "Delete_Customer", 'Slet kunde'), "Pay_Due", 'Betal skyld'), "Paying_amount_is_greater_than_Total_Due", 'Betalt beløb er større end samlet skyld'), "Customer_Invoice", 'Kundefaktura'), "This_Product_Not_For_Selling", 'Dette produkt er ikke til salg'), "Welcome_to_your_Dashboard", 'Velkommen til dit kontrolpanel'), "Total_Payable", 'Total betalbart'), "Choose_Sale_Ref", 'Vælg salgsreference'), "Please_Select_Sale", 'Vælg venligst salg'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Salgsreference'), "list_product_returns", 'Liste over produktreturneringer'), "Qty_return", 'Antal returner'), "Choose_Purchase_Ref", 'Vælg købsreference'), "Purchase_Ref", 'Købsreference'), "please_select_purchase", 'Vælg venligst køb'), "qty_return_is_greater_than_qty_purchased", 'Antal returneringer er større end antal købt'), "qty_return_is_greater_than_qty_sold", 'Antal returneringer er større end antal solgt'), "Quantity_sold", 'Antal solgt'), "qty_purchased", 'Antal købt'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Afsenderens navn'), "The_module_must_be_uploaded_as_zip_file", 'Modulet skal uploades som en zip-fil'), "Upload_Module", 'Upload modul'), "All_Modules_Installed", 'Alle moduler installeret'), "Current_Version", 'Nuværende version'), "You_already_have_the_latest_version", 'Du har allerede den nyeste version'), "Update_Available", 'Opdatering tilgængelig'), "Update_Log", 'Opdateringslog'), "Update_Now", 'Opdater nu'), "View_Change_Log", 'Se ændringslog'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'BEMÆRK: Vent venligst, indtil opdateringen er fuldstændig færdig. Det anbefales ikke at lukke browseren eller stoppe en opgraderingsproces'), "Note_update", 'Bemærk: Sørg for at tage en sikkerhedskopi af din nuværende version og database, inden du kører opgraderingen, så du kan gendanne det, hvis der opstår en fejl'), "invoice_footer", 'Faktura fodnote'), "Time_Zone", 'Tidszone'), "Payment_note", 'Betalingsnoter'), "sale_note", 'Salgsnoter'), "Total_Sale_Due", 'Totalt salg skyldigt'), "Total_Sell_Return_Due", 'Totalt salgsretur skyldigt'), "pay_all_sell_due_at_a_time", 'Betal alle salg skyldige på én gang'), "pay_all_sell_return_due_at_a_time", 'Betal alle salgsretur skyldige på én gang'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Bruttogevinst'), "pay_all_purchase_due_at_a_time", 'Betal alle købs skyldige på én gang'), "Delete_Provider", 'Slet leverandør'), "Edit_Provider", 'Rediger leverandør'), "Provider_details", 'Leverandørdetaljer'), "Total_Purchase_Due", 'Totalt køb skyldigt'), "Provider_Credit_Note", 'Leverandør kreditnota'), "Customer_Credit_Note", 'Kunde kreditnota'), "Sell_Return", 'Salgsretur'), "Purchase_Return", 'Købsretur'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'CVR-nummer'), "Please_add_return_quantity", 'Tilføj venligst antal returneringer'), "Return_exist_for_the_Transaction", 'Der findes en returnering for transaktionen'), "qty_return_is_greater_than_Quantity_Remaining", 'Antal returneringer er større end resterende antal'), "products_refunded_alert", 'Eventuelle produkter med en mængde på 0 vil ikke blive refunderet'), "pay_all_purchase_return_due_at_a_time", 'Betal alle købsretur skyldige på én gang'), "Total_Purchase_Return_Due", 'Totalt købsretur skyldigt'), "Purchase_return_due", 'Købsretur skyldigt'), "Sell_return_due", 'Salgsreturnering skyldig'), "product_report", 'Produktrapport'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'Produktsalgsrapport'), "Product_purchases_report", 'Produktkøbsrapport'), "Qty_sold", 'Antal solgt'), "Qty_purchased", 'Antal købt'), "Filter_by_warehouse", 'Filtrer efter lager'), "Enable_Print_Invoice", 'Udskriv faktura automatisk'), "credit_card_info", 'Kreditkortoplysninger'), "Saved_Credit_Card_Info", 'Gemte kreditkortoplysninger'), "Credit_card_changed_successfully", 'Kreditkort ændret med succes'), "notification_template", 'Notifikationsskabelon'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "email_notification", 'E-mail notifikation'), "sms_notification", 'SMS notifikation'), "Change_product_details", 'Ændre produkt detaljer'), "edit_tax_and_discount_and_shipping", 'Rediger skat, rabat og forsendelse'), "Create_Quotation_with_Stock", 'Opret tilbud med lagerbeholdning'), "Variant_Name", 'Variantnavn'), "Variant_cost", 'Variantomkostninger'), "Variant_price", 'Variantpris'), "Variant_code", 'Variantkode'), "Please_wait_until_the_product_is_loaded", 'Vent venligst indtil produktet er indlæst'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_SMS_Gateway", 'Vælg SMS-gateway'), "Notification_Client", 'Notifikation til kunden'), "Available_Tags", 'Tilgængelige tags'), "Email_Subject", 'Emne i e-mail'), "Email_body", 'E-mail indhold'), "Notification_Supplier", 'Notifikation til leverandøren'), "sms_body", 'SMS indhold'), "sms_templates", 'SMS skabeloner'), "email_templates", 'Email skabeloner'));

/***/ }),

/***/ "./resources/src/translations/locales/de.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/de.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Allemand

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Erhalt',
  Pos_Settings: 'Pos-Einstellungen',
  Note_to_customer: 'Hinweis an den Kunden',
  Show_Note_to_customer: 'Hinweis für Kunden anzeigen',
  Show_barcode: 'Strichcode vorzeigen',
  Show_Tax_and_Discount: 'Steuern & Rabatt & Versand anzeigen',
  Show_Customer: 'Kunden anzeigen',
  Show_Email: 'E-Mail anzeigen',
  Show_Phone: 'Telefon anzeigen',
  Show_Address: 'Adresse anzeigen',
  DefaultLanguage: 'Standardsprache',
  footer: 'Fusszeile',
  Received_Amount: 'Erhaltener Betrag',
  Paying_Amount: 'Zahlungsbetrag',
  Change: 'Veränderung',
  Paying_amount_is_greater_than_Received_amount: 'Der Zahlungsbetrag ist höher als der erhaltene Betrag',
  Paying_amount_is_greater_than_Grand_Total: 'Der Zahlungsbetrag ist höher als die Gesamtsumme',
  code_must_be_not_exist_already: 'Code darf noch nicht vorhanden sein',
  You_will_find_your_backup_on: 'Sie finden Ihr Backup auf',
  and_save_it_to_your_pc: 'und speichere es auf deinem PC',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Scannen Sie Ihren Barcode und wählen Sie unten die richtige Symbologie aus',
  Scan_Search_Product_by_Code_Name: 'Produkt nach Codename scannen/durchsuchen',
  Paper_size: 'Papier größe',
  Clear_Cache: 'Cache leeren',
  Cache_cleared_successfully: 'Cache erfolgreich geleert',
  Failed_to_clear_cache: 'Cache konnte nicht gelöscht werden',
  Scan_Barcode: 'Barcodelesegerät',
  Please_use_short_name_of_unit: 'Bitte verwenden Sie die Kurzbezeichnung der Einheit',
  DefaultCustomer: 'Standardkunde',
  DefaultWarehouse: 'Standardlager',
  Payment_Gateway: 'Zahlungs-Gateways',
  SMS_Configuration: 'SMS-Konfiguration',
  Gateway: 'Zahlungs-Gateways',
  Choose_Gateway: 'Wählen Sie Zahlungs-Gateways',
  Send_SMS: 'Nachricht erfolgreich gesendet',
  sms_config_invalid: 'falsche SMS-Konfiguration ungültig',
  Remove_Stripe_Key_Secret: 'Löschen Sie die Stripe-API-Schlüssel',
  credit_card_account_not_available: 'Kreditkartenkonto nicht verfügbar',
  Credit_Card_Info: 'Kreditkarteninformationen',
  developed_by: 'Entwickelt von',
  Unit_already_linked_with_sub_unit: 'Einheit bereits mit Untereinheit verbunden',
  Total_Items_Quantity: 'Gesamtartikel und Menge',
  Value_by_Cost_and_Price: 'Wert nach Kosten und Preis',
  Search_this_table: 'Durchsuchen Sie diese Tabelle',
  import_products: 'Produkte importieren',
  Field_optional: 'Feld optional',
  Download_exemple: 'Beispiel herunterladen',
  field_must_be_in_csv_format: 'Das Feld muss im CSV-Format vorliegen',
  Successfully_Imported: 'Erfolgreich importiert',
  file_size_must_be_less_than_1_mega: 'Die Dateigröße muss weniger als 1 Mega betragen',
  Please_follow_the_import_instructions: 'Bitte folgen Sie den Importanweisungen',
  must_be_exist: 'Einheit muss bereits angelegt sein',
  Import_Customers: 'Kunden importieren',
  Import_Suppliers: 'Lieferanten importieren',
  Recent_Sales: 'Letzte Verkäufe',
  Create_Transfer: 'Übertragung erstellen',
  order_products: 'Auftragspositionen',
  Search_Product_by_Code_Name: 'Suchen Sie das Produkt nach Code oder Name',
  Reports_payments_Purchase_Return: 'Meldet Kaufrückzahlungen',
  Reports_payments_Sale_Return: 'Berichte Verkauf Rückzahlungen',
  payments_Sales_Return: 'Zahlungen Verkäufe Rückgabe',
  payments_Purchases_Return: 'Zahlungen Einkäufe Rückgabe',
  CreateSaleReturn: 'Verkaufsrendite erstellen',
  EditSaleReturn: 'Verkaufsrückgabe bearbeiten',
  SalesReturn: 'Umsatzrendite',
  CreatePurchaseReturn: 'Kaufretoure erstellen',
  EditPurchaseReturn: 'Kaufretoure bearbeiten',
  PurchasesReturn: 'Käufe zurück',
  Due: 'fällig',
  Profit: 'Profitieren',
  Revenue: 'Einnahmen',
  Sales_today: 'Verkauf heute',
  People: 'Menschen',
  Successfully_Created: 'Erfolgreich erstellt',
  Successfully_Updated: 'Erfolgreich aktualisiert',
  Success: 'Erfolg',
  Failed: 'Gescheitert',
  Warning: 'Warnung',
  Please_fill_the_form_correctly: 'Bitte füllen Sie das Formular korrekt aus',
  Field_is_required: 'Feld ist erforderlich',
  Error: 'Error!',
  you_are_not_authorized: 'Es tut uns leid! Sie sind nicht berechtigt.',
  Go_back_to_home: 'Gehen Sie zurück zur Homepage',
  page_not_exist: 'Es tut uns leid! Die gesuchte Seite existiert nicht.',
  Choose_Status: 'Wählen Sie Status',
  Choose_Method: 'Wählen Sie Methode',
  Choose_Symbology: 'Wählen Sie Symbologie',
  Choose_Category: 'Kategorie auswählen',
  Choose_Customer: 'Wählen Sie Kunde',
  Choose_Supplier: 'Wählen Sie Lieferant',
  Choose_Unit_Purchase: 'Wählen Sie Kaufeinheit',
  Choose_Sub_Category: 'Wählen Sie Unterkategorie',
  Choose_Brand: 'Wählen Sie Marke',
  Choose_Warehouse: 'Wählen Sie Lager',
  Choose_Unit_Sale: 'Wählen Sie Verkaufseinheit',
  Enter_Product_Cost: 'Produktkosten eingeben',
  Enter_Stock_alert: 'Bestandswarnung eingeben',
  Choose_Unit_Product: 'Wählen Sie Produkteinheit',
  Enter_Product_Price: 'Produktpreis eingeben',
  Enter_Name_Product: 'Geben Sie den Namen Produkt ein',
  Enter_Role_Name: 'Geben Sie den Rollennamen ein',
  Enter_Role_Description: 'Geben Sie die Rollenbeschreibung ein',
  Enter_name_category: 'Geben Sie den Kategorienamen ein',
  Enter_Code_category: 'Geben Sie den Kategoriecode ein',
  Enter_Name_Brand: 'Geben Sie die Namensmarke ein',
  Enter_Description_Brand: 'Geben Sie Beschreibung Marke ein',
  Enter_Code_Currency: 'Geben Sie die Codewährung ein',
  Enter_name_Currency: 'Geben Sie den Namen Währung ein',
  Enter_Symbol_Currency: 'Geben Sie die Symbolwährung ein',
  Enter_Name_Unit: 'Geben Sie den Einheitennamen ein',
  Enter_ShortName_Unit: 'Geben Sie den Kurznamen Unit ein',
  Choose_Base_Unit: 'Wählen Sie Basiseinheit',
  Choose_Operator: 'Wählen Sie den Operator',
  Enter_Operation_Value: 'Geben Sie den Betriebswert ein',
  Enter_Name_Warehouse: 'Geben Sie den Lagernamen ein',
  Enter_Phone_Warehouse: 'Geben Sie das Lagertelefon ein',
  Enter_Country_Warehouse: 'Geben Sie das Lagerland ein',
  Enter_City_Warehouse: 'Geben Sie die Lagerstadt ein',
  Enter_Email_Warehouse: 'Geben Sie die Lager E-Mail ein',
  Enter_ZipCode_Warehouse: 'Geben Sie die Postleitzahl des Lagers ein',
  Choose_Currency: 'Währung wählen',
  Thank_you_for_your_business: 'Vielen Dank für Ihr Geschäft!',
  Cancel: 'Stornieren',
  New_Customer: 'Neukunde',
  Incorrect_Login: 'Falsche Anmeldedaten',
  Successfully_Logged_In: 'Erfolgreich angemeldet',
  This_user_not_active: 'Dieser Benutzer ist nicht aktiv',
  SignIn: 'Einloggen',
  Create_an_account: 'Ein Konto erstellen',
  Forgot_Password: 'Passwort vergessen ?',
  Email_Address: 'E-Mail-Addresse',
  SignUp: 'Anmeldung',
  Already_have_an_account: 'Sie haben bereits ein Konto ?',
  Reset_Password: 'Passwort zurücksetzen',
  Failed_to_authenticate_on_SMTP_server: 'Fehler beim Authentifizieren auf dem SMTP-Server',
  We_cant_find_a_user_with_that_email_addres: 'Wir können keinen Benutzer mit dieser E-Mail-Adresse finden',
  We_have_emailed_your_password_reset_link: 'Wir haben Ihren Link zum Zurücksetzen Ihres Passworts per E-Mail gesendet',
  Please_fill_the_Email_Adress: 'Bitte geben Sie die E-Mail-Adresse ein',
  Confirm_password: 'Kennwort bestätigen',
  Your_Password_has_been_changed: 'Ihr Passwort wurde geändert',
  The_password_confirmation_does_not_match: 'Die Passwortbestätigung stimmt nicht überein',
  This_password_reset_token_is_invalid: 'Dieses Token zum Zurücksetzen des Passworts ist ungültig',
  Warehouse_report: 'Lagerbericht',
  All_Warehouses: 'Alle Lagerhäuser',
  Expense_List: 'Spesenliste',
  Expenses: 'Kosten',
  This_Week_Sales_Purchases: 'Diese Woche Verkäufe & Käufe',
  Top_Selling_Products: 'Meistverkaufte Produkte',
  View_all: 'Alle ansehen',
  Payment_Sent_Received: 'Zahlung gesendet und erhalten',
  Filter: 'Filter',
  Invoice_POS: 'Rechnung POS',
  Invoice: 'Rechnung',
  Customer_Info: 'Kundeninformation',
  Company_Info: 'Firmeninfo',
  Invoice_Info: 'Rechnungsinfo',
  Order_Summary: 'Bestellübersicht',
  Quote_Info: 'Angebotsinfo',
  Del: 'Löschen',
  SuppliersPaiementsReport: 'Lieferantenzahlungsbericht',
  Purchase_Info: 'Kaufinfo',
  Supplier_Info: 'Lieferanteninfo',
  Return_Info: 'Infos zur Rücksendung',
  Expense_Category: 'Ausgabenkategorie',
  Create_Expense: 'Kosten erstellen',
  Details: 'Einzelheiten',
  Discount_Method: 'Rabattmethode',
  Net_Unit_Cost: 'Netto-Stückkosten',
  Net_Unit_Price: 'Netto-Stückpreis',
  Edit_Expense: 'Kosten bearbeiten',
  All_Brand: 'Alle Marke',
  All_Category: 'Alle Kategorie',
  ListExpenses: 'Ausgaben auflisten',
  Create_Permission: 'Berechtigung erstellen',
  Edit_Permission: 'Berechtigung bearbeiten',
  Reports_payments_Sales: 'Meldet Zahlungen Verkäufe',
  Reports_payments_Purchases: 'Meldet Zahlungen Einkäufe',
  Reports_payments_Return_Customers: 'Berichte Zahlungen Kunden zurückgeben',
  Reports_payments_Return_Suppliers: 'Berichte Zahlungen Rücklieferanten',
  Expense_Deleted: 'Diese Ausgabe wurde gelöscht',
  Expense_Updated: 'Diese Ausgabe wurde aktualisiert',
  Expense_Created: 'Diese Ausgabe wurde erstellt',
  DemoVersion: 'Dies ist in der Demoversion nicht möglich',
  OrderStatistics: 'Verkaufsstatistik',
  AlreadyAdd: 'Dieses Produkt ist bereits hinzugefügt',
  AddProductToList: 'Bitte fügen Sie das Produkt der Liste hinzu',
  AddQuantity: 'Bitte addieren Sie die Menge',
  InvalidData: 'Ungültige Daten',
  LowStock: 'Menge übersteigt die auf Lager verfügbare Menge',
  WarehouseIdentical: 'Die beiden Repositorys können nicht identisch sein',
  VariantDuplicate: 'Diese Variable ist redundant',
  Filesize: 'Dateigröße',
  GenerateBackup: 'Backup generieren',
  BackupDatabase: 'Backup-Datenbank',
  Backup: 'Backup-Datenbank',
  Paid: 'Bezahlt',
  Unpaid: 'Unbezahlt',
  IncomeExpenses: 'Einnahmen & Ausgaben',
  dailySalesPurchases: 'tägliche Verkäufe und Einkäufe',
  ProductsExpired: 'Produkt abgelaufen',
  Today: 'heute',
  Income: 'Einkommen'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'Kosten'), "Sale", 'Verkauf'), "Actif", 'Aktiv'), "Inactif", 'Inaktiv'), "Customers", 'Kunden'), "Phone", 'Telefon'), "SearchByPhone", 'Suche per Telefon'), "Suppliers", 'Lieferanten'), "Quotations", 'Zitate'), "Sales", 'Der Umsatz'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'Einkäufe'), "Returns", 'Kehrt zurück'), "Settings", 'die Einstellungen'), "SystemSettings", 'Systemeinstellungen'), "Users", 'Benutzer'), "GroupPermissions", 'Gruppenberechtigungen'), "Currencies", 'Währungen'), "Warehouses", 'Lagerhäuser'), "Units", 'Einheiten'), "UnitsPrchases", 'Kauf von Einheiten'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Einheiten Vertrieb'), "Reports", 'Berichte'), "PaymentsReport", 'Zahlungsbericht'), "PaymentsPurchases", 'Zahlungen Einkäufe'), "PaymentsSales", 'Zahlungen Verkäufe'), "PaymentsReturns", 'Zahlung Rückgabe'), "ReturnsInvoices", 'Gibt Rechnungen zurück'), "ReturnsInvoicesData", 'Rechnungsdaten zurücksenden'), "ShowAll", 'Alle Datensätze aller Benutzer anzeigen'), "ProfitandLoss", 'Gewinn-und Verlust'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "WarehouseStockChart", 'Lagerbestandstabelle'), "SalesReport", 'Verkaufsbericht'), "PurchasesReport", 'Kaufbericht'), "CustomersReport", 'Kundenbericht'), "SuppliersReport", 'Lieferantenbericht'), "SupplierReport", 'Lieferantenbericht'), "DailySalesData", 'Tägliche Verkaufsdaten'), "DailyPurchasesData", 'Tägliche Kaufdaten'), "Derni\xE8rescinqrecords", 'Letzte fünf Datensätze'), "Filters", 'Filter'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "date", 'Datum'), "ManagementCurrencies", 'Management Währungen'), "CurrencyCode", 'Währungscode'), "CurrencyName", 'Währungsname'), "Symbol", 'Symbol'), "Reference", 'Referenz'), "Supplier", 'Lieferant'), "PaymentStatus", 'Zahlungsstatus'), "Customer", 'Kunde'), "CustomerCode", 'Kundennummer'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Status", 'Status'), "SupplierCode", 'Lieferantencode'), "Categorie", 'Kategorie'), "Categories", 'Kategorien'), "StockTransfers", 'Umlagerung'), "StockManagement", 'Lagerverwaltung'), "dashboard", 'Instrumententafel'), "Products", 'Produkte'), "productsList", 'Produktliste'), "ProductManagement", 'Produkt Management'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductQuantityAlerts", 'Produktmengen Warnungen'), "CodeProduct", 'Code Produkt'), "ProductTax", 'Produktsteuer'), "SubCategorie", 'Unterkategorie'), "Name_product", 'Bezeichnung'), "StockAlert", 'Lagerwarnung'), "warehouse", 'Warenhaus'), "Tax", 'MwSt'), "BuyingPrice", 'Kaufpreis'), "SellPrice", 'Verkaufspreis'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Quantity", 'Quantität'), "UnitSale", 'Einheiten verkaufen'), "UnitPurchase", 'Stückkauf'), "All", 'Alles'), "EditProduct", 'Produkt bearbeiten'), "AddProduct", 'Produkt hinzufügen'), "SearchByCode", 'Suche nach Code'), "SearchByName", 'Suche mit Name'), "ProductDetails", 'Produktdetails'), "CustomerName", 'Kundenname'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CustomerManagement", 'Kundenmanagement'), "Add", 'Hinzufügen'), "add", 'Hinzufügen'), "Edit", 'Bearbeiten'), "Close", 'Schließen'), "PleaseSelect", 'Bitte auswählen'), "Action", 'Aktion'), "Email", 'Email'), "EditCustomer", 'Kunden bearbeiten'), "AddCustomer", 'Kunden hinzufügen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Country", 'Land'), "City", 'Stadt'), "Adress", 'Adresse'), "CustomerDetails", 'Kundendetails'), "CustomersList", 'Kundenliste'), "SupplierCode", 'Lieferantencode'), "SupplierName", 'Name des Anbieters'), "SuppliersManagement", 'Lieferantenmanagement'), "SupplierDetails", 'Lieferantendetails'), "QuotationsManagement", 'Zitate management'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SubTotal", 'Zwischensumme'), "MontantReste", 'Restbetrag'), "complete", 'Komplett'), "EnAttendant", 'steht aus'), "Recu", 'Empfangen'), "partial", 'Teilweise'), "Retournee", 'Rückkehr'), "DetailQuote", 'Detaillierte Zita'), "EditQuote", 'bearbeiten zitat'), "CreateSale", 'Verkauf erstellen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "DownloadPdf", 'PDF Herunterladen'), "QuoteEmail", 'zitat per E-Mail senden'), "DeleteQuote", ' Löschen zitat'), "AddQuote", 'hinzufügen zitat'), "SelectProduct", 'Ausgewähltes Produkt'), "ProductCodeName", 'Produkt (Code - Name)'), "Price", 'Preis'), "CurrentStock", 'Lagerbestand'), "Total", 'Gesamt'), "Num", 'N°'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Unitcost", 'Kosten pro Einheit'), "to", 'zu'), "Subject", 'Gegenstand'), "Message", 'Botschaft'), "EmailCustomer", 'E-Mail an den Kunden'), "Sent", 'Senden'), "Quote", 'Zitat'), "Hello", 'Hallo'), "AttachmentQuote", 'Sie finden den Anhang zu Ihrem Zitat'), "AddProducts", 'Produkte zur Bestellliste hinzufügen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectWarehouse", 'Bitte Lager auswählen'), "SelectCustomer", 'Wählen Sie Kunde'), "SalesManagement", 'Verkaufsleitung'), "Balance", 'Balance'), "QtyBack", 'Mengenrückgabe'), "TotalReturn", 'Gesamtrendite'), "Amount", 'Menge'), "SaleDetail", 'Verkaufsdetail'), "EditSale", 'Verkauf bearbeiten'), "AddSale", 'Verkauf hinzufügen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ShowPayment", 'Zahlungen anzeigen'), "AddPayment", 'Zahlung hinzufügen'), "EditPayment", 'Zahlung bearbeiten'), "EmailSale", 'Verkauf per E-Mail senden'), "DeleteSale", 'Verkauf löschen'), "ModePaiement", 'Bezahlverfahren'), "Paymentchoice", 'Wahl der Zahlung'), "Note", 'Hinweis'), "PaymentComplete", 'Zahlung abgeschlossen!'), "PurchasesManagement", 'Einkaufsmanagement'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Ordered", 'Bestellt'), "DeletePurchase", 'Kauf löschen'), "EmailPurchase", 'Kauf per E-Mail senden'), "EditPurchase", 'Kauf bearbeiten'), "PurchaseDetail", 'Kaufdetail'), "AddPurchase", 'Kauf hinzufügen'), "EmailSupplier", 'Lieferanten-E-Mail'), "PurchaseInvoice", 'Kauft Zahlungen'), "PurchasesInvoicesData", 'Kauft Zahlungsdaten'), "SalesInvoice", 'Verkaufszahlungen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'Verkaufszahlungsdaten'), "UserManagement", 'Benutzerverwaltung'), "Firstname", 'Vorname'), "lastname", 'Nachname'), "username", 'NUTZERNAME'), "password", 'PASSWORT'), "Newpassword", 'Neues Kennwort'), "ChangeAvatar", 'Avatar ändern'), "LeaveBlank", 'Bitte lassen Sie dieses Feld leer, wenn Sie es nicht geändert haben'), "type", 'Typ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UserPermissions", 'Benutzerberechtigungen'), "RoleName", 'Rollenname'), "RoleDescription", 'Rollenbeschreibung'), "AddPermissions", 'Berechtigungen hinzufügen'), "View", 'ansehen'), "Del", 'Löschen'), "NewAdjustement", 'Neue Anpassung'), "EditAdjustement", 'Anpassung bearbeiten'), "CannotSubstraction", 'Sie können keine Produkte mit Lagerbestand 0 subtrahieren'), "Addition", 'Zusatz'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Subtraction", 'Subtraktion'), "profil", 'profil'), "logout", 'Ausloggen'), "PurchaseAlreadyPaid", 'Sie können keine Änderungen vornehmen, da dieser Kauf bereits bezahlt wurde'), "SaleAlreadyPaid", 'Sie können nicht ändern, da dieser Verkauf bereits bezahlt wurde'), "ReturnAlreadyPaid", 'Sie können keine Änderungen vornehmen, da diese Rücksendung bereits bezahlt wurde'), "QuoteAlready", 'Dieses Angebot hat bereits einen Verkauf generiert'), "QuotationComplete", 'Dieses Angebot ist abgeschlossen'), "SiteConfiguration", 'Standortkonfiguration'), "Language", 'Sprache'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "DefaultCurrency", 'Standardwährung'), "LoginCaptcha", 'Anmeldung Captcha'), "DefaultEmail", 'Standard-E-Mail'), "SiteName", 'Site-Name'), "ChangeLogo", 'Logo ändern'), "SMTPConfiguration", 'SMTP-Konfiguration'), "HOST", 'GASTGEBER'), "PORT", 'HAFEN'), "encryption", 'Verschlüsselung'), "SMTPIncorrect", 'SMTP-Konfiguration falsch'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", 'Rabatt'), "OrderTax", 'Bestellsteuer'), "Shipping", 'Versand'), "CompanyName", 'Name der Firma'), "CompanyPhone", 'Firmentelefon'), "CompanyAdress", 'Firmenanschrift'), "Code", 'Code'), "image", 'Bild'), "Printbarcode", 'Strichcode drucken'), "ReturnsCustomers", 'Gibt Kunden zurück'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Gibt Lieferanten zurück'), "FactureReturnCustomers", 'Rechnungen Gibt Verkäufe zurück'), "FactureReturnSuppliers", 'Rechnungen Gibt Einkäufe zurück'), "NodataAvailable", 'Keine Daten verfügbar'), "ProductImage", 'Produkt bild'), "Barcode", 'Strichcode'), "pointofsales", 'Verkaufsstelle'), "CustomUpload", 'Benutzerdefinierter Upload'), "pointofsaleManagement", 'Kasse Management'), "Adjustment", 'Änderung'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", 'Aktualisieren'), "Reset", 'Zurücksetzen'), "print", 'drucken'), "SearchByEmail", 'Suche per E-Mail'), "ChooseProduct", 'Wählen Sie Produkt'), "Qty", 'Menge'), "Items", 'Artikel'), "AmountHT", 'Betrag HT'), "AmountTTC", 'Betrag TTC'), "PleaseSelectSupplier", 'Bitte wählen Sie Lieferant'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Bitte wählen Sie Statut'), "PayeBy", 'bezahlt mit'), "ChooseWarehouse", 'Wählen Sie Lager'), "payNow", 'Zahlen Sie jetzt'), "ListofCategory", 'Liste der Kategorien'), "Description", 'Beschreibung'), "submit", 'einreichen'), "ProblemCreatingThisInvoice", 'Beim Erstellen dieser Rechnung ist ein Problem aufgetreten. Bitte versuche es erneut'), "ProblemPayment", 'Es gab ein Problem bei der Zahlung. Bitte versuche es erneut.'), "CreateAdjustment", 'Anpassung erstellen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Afewwords", 'ein paar Worte über ...'), "UserImage", 'Benutzerbild'), "UpdateProduct", 'Produkt aktualisieren'), "Brand", 'Marke'), "BarcodeSymbology", 'Barcode-Symbologie'), "ProductCost", 'Produktkosten'), "ProductPrice", 'Produktpreis'), "UnitProduct", 'Einheit Produkt'), "TaxMethod", 'Steuermethode'), "MultipleImage", 'Mehrfachbild'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'Produkt hat mehrere Varianten'), "ProductHasPromotion", 'Produkt hat Werbung'), "PromotionStart", 'Promotion Start'), "PromotionEnd", 'Promotion-Ende'), "PromotionPrice", 'Aktionspreis'), "Price", 'Preis'), "Cost", 'Kosten'), "Unit", 'Einheit'), "ProductVariant", 'Produktvariante'), "Variant", 'Variante'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'Stückpreis'), "CreateReturnCustomer", 'Rückgabekunden erstellen'), "EditReturnCustomer", 'Kundenretouren aktualisieren'), "CreateReturnSupplier", 'Rücklieferanten anlegen'), "Documentation", 'Dokumentation'), "EditReturnSupplier", 'Lieferantenrückgabe aktualisieren'), "FromWarehouse", 'Aus dem Lager'), "ToWarehouse", 'Zum Lager'), "EditTransfer", 'Übertragung bearbeiten'), "TransferDetail", 'Detail übertragen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Pending", 'steht aus'), "Received", 'Empfangen'), "Ordered", 'Bestellt'), "PermissionsManager", 'Berechtigungsmanagement'), "BrandManager", 'Markenführung'), "BrandImage", 'Markenzeichen'), "BrandName", 'Markenname'), "BrandDescription", 'Markenbeschreibung'), "BaseUnit", 'Grundeinheit'), "ManagerUnits", 'Verwaltungseinheiten'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "OperationValue", 'Betriebswert'), "Operator", 'Operator'), "Top5Products", 'Top 5 Produkte'), "Last5Sales", 'Letzte 5 Verkäufe'), "ListAdjustments", 'Anpassungslisten'), "ListTransfers", 'Übertragungen auflisten'), "CreateTransfer", 'Übertragung erstellen'), "OrdersManager", 'Auftragsverwaltung'), "ListQuotations", 'Zitate auflisten'), "ListPurchases", 'Einkäufe auflisten'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ListSales", 'Liste Verkäufe'), "ListReturns", 'Liste zurück'), "PeopleManager", 'Management Leute'), "ListofBrand", 'Markenliste'), "Delete", {
  Title: 'Bist du sicher?',
  Text: 'Sie können dies nicht rückgängig machen!',
  confirmButtonText: 'Ja, lösche es!',
  cancelButtonText: 'Stornieren',
  Deleted: 'Gelöscht!',
  Failed: 'Gescheitert!',
  Therewassomethingwronge: 'Etwas war falsch',
  CustomerDeleted: 'Dieser Client wurde gelöscht',
  SupplierDeleted: 'Dieser Lieferant wurde gelöscht',
  QuoteDeleted: 'Dieses Angebot wurde gelöscht',
  SaleDeleted: 'Dieser Verkauf wurde gelöscht',
  PaymentDeleted: 'Diese Zahlung wurde gelöscht',
  PurchaseDeleted: 'Dieser Kauf wurde gelöscht',
  ReturnDeleted: 'Diese Rückgabe wurde gelöscht',
  ProductDeleted: 'Dieses Produkt wurde gelöscht',
  ClientError: 'Dieser Client ist bereits mit einer anderen Operation verknüpft',
  ProviderError: 'Dieser Lieferant ist bereits mit anderen Vorgängen verbunden',
  UserDeleted: 'Dieser Benutzer wurde gelöscht',
  UnitDeleted: 'Diese Einheit wurde gelöscht',
  RoleDeleted: 'Diese Rolle wurde gelöscht',
  TaxeDeleted: 'Diese Steuer wurde gelöscht',
  SubCatDeleted: 'Diese Unterkategorie wurde gelöscht.',
  CatDeleted: 'Diese Kategorie wurde gelöscht',
  WarehouseDeleted: 'Dieses Warehouse wurde gelöscht',
  AlreadyLinked: 'Dieses Produkt ist bereits mit anderen Prozessen verknüpft',
  AdjustDeleted: 'Diese Anpassung wurde gelöscht',
  TitleCurrency: 'Diese Währung wurde erfolgreich gelöscht',
  TitleTransfer: 'Transfer wurde erfolgreich entfernt',
  BackupDeleted: 'Backup wurde erfolgreich entfernt',
  TitleBrand: 'Diese Marke wurde gelöscht'
}), "Update", {
  TitleBrand: 'Diese Marke wurde aktualisiert',
  TitleProfile: 'Dein Profil wurde erfolgreich aktualisiert',
  TitleAdjust: 'Anpassung Erfolgreich aktualisiert',
  TitleRole: 'Rolle erfolgreich aktualisiert',
  TitleUnit: 'Einheit erfolgreich aktualisiert',
  TitleUser: 'Benutzer erfolgreich aktualisiert',
  TitleCustomer: 'Kunde erfolgreich aktualisiert',
  TitleQuote: 'Angebot erfolgreich aktualisiert',
  TitleSale: 'Verkauf erfolgreich aktualisiert',
  TitlePayment: 'Zahlung erfolgreich aktualisiert',
  TitlePurchase: 'Kauf Erfolgreich aktualisiert',
  TitleReturn: 'Zurück Erfolgreich aktualisiert',
  TitleProduct: 'Produktaktualisierung erfolgreich',
  TitleSupplier: 'Lieferant erfolgreich aktualisiert',
  TitleTaxe: 'Steuer erfolgreich aktualisiert',
  TitleCat: 'Kategorie Erfolgreich aktualisiert',
  TitleWarhouse: 'Warehouse erfolgreich aktualisiert',
  TitleSetting: 'Einstellungen erfolgreich aktualisiert',
  TitleCurrency: 'Diese Währung wurde erfolgreich aktualisiert',
  TitleTransfer: 'Transfer wurde erfolgreich aktualisiert'
}), "Create", {
  TitleBrand: 'Diese Marke wurde erstellt',
  TitleTransfer: 'Transfer wurde erfolgreich erstellt',
  TitleRole: 'Rolle erfolgreich erstellt in',
  TitleUnit: 'Einheit erfolgreich erstellt in',
  TitleUser: 'Benutzer erfolgreich erstellt in',
  TitleCustomer: 'Kunde erfolgreich erstellt in',
  TitleQuote: 'Angebot erfolgreich erstellt in',
  TitleSale: 'Verkauf Erfolgreich erstellt in',
  TitlePayment: 'Zahlung erfolgreich erstellt in',
  TitlePurchase: 'Kauf erfolgreich erstellt in',
  TitleReturn: 'Rückgabe Erfolgreich erstellt in',
  TitleProduct: 'Produkt erfolgreich erstellt in',
  TitleSupplier: 'Lieferant Erfolgreich erstellt in',
  TitleTaxe: 'Steuer erfolgreich erstellt',
  TitleCat: 'Kategorie Erfolgreich erstellt in',
  TitleWarhouse: 'Warehouse erfolgreich erstellt in',
  TitleAdjust: 'Anpassung Erfolgreich erstellt in',
  TitleCurrency: 'Diese Münze wurde erfolgreich erstellt'
}), "Send", {
  TitleEmail: 'E-Mail Erfolgreich einsenden'
}), "return", {
  TitleSale: 'Dieser Verkauf ist bereits mit einer Rückgabe verbunden!'
}), "ReturnManagement", 'Rückgabeverwaltung'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'Detail zurückgeben'), "EditReturn", 'Rückgabe bearbeiten'), "AddReturn", 'Return hinzufügen'), "EmailReturn", 'Senden Sie die Rücksendung per E-Mail'), "DeleteReturn", 'Rückgabe löschen'), "Retoursurcharge", 'Rücknahmegebühr'), "Laivrison", 'Lieferung'), "SelectSale", 'Wählen Sie Verkauf'), "ZeroPardefault", 'Sie können den Artikel löschen oder den zurückgegebenen Betrag auf Null setzen, wenn er nicht zurückgegeben wird'), "Return", 'Rückkehr'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchase", 'Kauf'), "TotalSales", 'Gesamtumsatz'), "TotalPurchases", 'Gesamtkäufe'), "TotalReturns", 'Gesamtrendite'), "PaiementsNet", 'Zahlung netto'), "PaiementsSent", 'Zahlung senden'), "PaiementsReceived", 'Zahlung erhalten'), "Recieved", 'Empfangen'), "Sent", 'senden'), "ProductQuantityAlerts", 'Warnung vor Produktmengen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCode", 'Produktcode'), "ProductName", 'Produktname'), "AlertQuantity", 'Warnung Menge'), "WarehouseStockChart", 'Inventardiagramm'), "TotalProducts", 'Produkte insgesamt'), "TotalQuantity", 'Gesamtmenge'), "TopCustomers", 'Top 5 Kunden'), "TotalAmount", 'Gesamtmenge'), "TotalPaid", 'Ganz bezahlt'), "CustomerSalesReport", 'Kunden Verkaufsbericht'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'Kundenzahlungsbericht'), "CustomerQuotationsReport", 'KundenangeboteBericht'), "Payments", 'Zahlungen'), "TopSuppliers", 'Top 5 Lieferanten'), "SupplierPurchasesReport", 'Lieferanten Einkaufsbericht'), "SupplierPaiementsReport", 'Lieferanten Zahlungsbericht'), "Name", 'Name'), "Code", 'Code'), "ManagementWarehouse", 'Lagerverwaltung'), "ZipCode", 'Postleitzahl'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementCategories", 'Kategorienverwaltung'), "Codecategorie", 'Codekategorie'), "Namecategorie", 'Namenskategorie'), "Parentcategorie", 'Eltern-Kategorie'), "managementTax", 'Steuermanagement'), "TaxName", 'Steuername'), "TaxRate", 'Steuersatz'), "managementUnitPurchases", 'Käufe Einheitenverwaltung'), "managementUnitSales", 'Verkaufseinheit Management'), "ShortName", 'Kurzer Name'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'Bitte wählen Sie diese aus, bevor Sie ein Produkt hinzufügen'), "StockAdjustement", 'Bestandskorrektur'), "PleaseSelectWarehouse", 'Bitte wählen Sie das Lager aus, bevor Sie ein Produkt auswählen'), "StockTransfer", 'Umlagerung'), "SelectPeriod", 'Wählen Sie Periode'), "ThisYear", 'Dieses Jahr'), "ThisToday", 'Das heute'), "ThisMonth", 'Diesen Monat'), "ThisWeek", 'Diese Woche'), "AdjustmentDetail", 'Anpassungsdetail'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'Dieser Benutzer wurde aktiviert'), "DisActivateUser", 'Dieser Benutzer wurde deaktiviert'), "NotFound", 'Seite nicht gefunden.'), "oops", 'Error! Seite nicht gefunden.'), "couldNotFind", 'Wir konnten die gesuchte Seite nicht finden. In der Zwischenzeit können Sie'), "ReturnDashboard", 'Zurück zum Dashboard'), "hrm", 'HRM'), "Employees", 'Mitarbeiter'), "Attendance", 'Anwesenheit'), "Leave_request", 'Anfrage hinterlassen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Typ verlassen'), "Company", 'Gesellschaft'), "Departments", 'Abteilungen'), "Designations", 'Bezeichnungen'), "Office_Shift", 'Büroschicht'), "Holidays", 'Ferien'), "Enter_Company_Name", 'Geben Sie den Firmennamen ein'), "Enter_email_address", 'E-Mail Adresse eingeben'), "Enter_Company_Phone", 'Firmentelefon eingeben'), "Enter_Company_Country", 'Firmenland eingeben'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Wurde erfolgreich erstellt'), "Updated_in_successfully", 'Wurde erfolgreich aktualisiert'), "Deleted_in_successfully", 'Gelöscht in erfolgreich'), "department", 'Abteilung'), "Enter_Department_Name", 'Abteilungsname eingeben'), "Choose_Company", 'Wählen Sie Unternehmen'), "Department_Head", 'Abteilungsleiterin'), "Choose_Department_Head", 'Wählen Sie Abteilungsleiter'), "Enter_Shift_name", 'Geben Sie den Schichtnamen ein'), "Monday_In", 'Monday In'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'Ferien'), "Enter_title", 'Titel eingeben'), "title", 'Titel'), "start_date", 'Startdatum'), "Enter_Start_date", 'Startdatum eingeben'), "Finish_Date", 'Endtermin'), "Enter_Finish_date", 'Geben Sie das Enddatum ein'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Bitte geben Sie alle Details an'), "Attendances", 'Anwesenheiten'), "Enter_Attendance_date", 'Anwesenheitsdatum eingeben'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", 'Wählen Angestellter'), "Employee", 'Angestellter'), "Work_Duration", 'Arbeitsdauer'), "remaining_leaves_are_insufficient", 'Die verbleibenden Blätter sind unzureichend'), "Leave_Type", 'Typ verlassen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Days", 'Tage'), "Department", 'Abteilung'), "Choose_leave_type", 'Urlaubsart wählen'), "Choose_status", 'Wählen Sie den Status'), "Leave_Reason", 'Verlassen Sie die Vernunft'), "Enter_Reason_Leave", 'Geben Sie den Grund für das Verlassen ein'), "Add_Employee", 'Mitarbeiter hinzufügen'), "FirstName", 'Vorname'), "Enter_FirstName", 'Bitte Vornamen eingeben'), "LastName", 'Nachname'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Nachnamen eingeben'), "Gender", 'Geschlecht'), "Choose_Gender", 'Wählen Sie Geschlecht'), "Enter_Birth_date", 'Geburtsdatum eingeben'), "Birth_date", 'Geburtstag'), "Enter_Country", 'Land eingeben'), "Enter_Phone_Number", 'Telefonnummer eingeben'), "joining_date", 'Beitrittsdatum'), "Enter_joining_date", 'Beitrittsdatum eingeben'), "Choose_Designation", 'Wählen Sie Bezeichnung'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Designation", 'Bezeichnung'), "Office_Shift", 'Büroschicht'), "Choose_Office_Shift", 'Wählen Sie Büroschicht'), "Enter_Leaving_Date", 'Geben Sie das Austrittsdatum ein'), "Leaving_Date", 'Austrittsdatum'), "Annual_Leave", 'Jährlicher Urlaub'), "Enter_Annual_Leave", 'Geben Sie den Jahresurlaub ein'), "Remaining_leave", 'Resturlaub'), "Employee_Details", 'Mitarbeiterdetails'), "Basic_Information", 'Grundlegende Informationen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Family_status", 'Familienstatus'), "Choose_Family_status", 'Wählen Sie Familienstatus'), "Employment_type", 'Beschäftigungsart'), "Select_Employment_type", 'Wählen Sie Beschäftigungsart aus'), "Enter_City", 'Stadt betreten'), "Province", 'Provinz'), "Enter_Province", 'Geben Sie die Provinz ein'), "Enter_Address", 'Geben Sie die Adresse ein'), "Enter_Zip_code", 'Bitte Postleitzahl eingeben'), "Zip_code", 'Postleitzahl'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Stundensatz'), "Enter_Hourly_rate", 'Geben Sie den Stundensatz ein'), "Basic_salary", 'Grundgehalt'), "Enter_Basic_salary", 'Geben Sie das Grundgehalt ein'), "Social_Media", 'Sozialen Medien'), "Skype", 'Skypen'), "Enter_Skype", 'Geben Sie Skype ein'), "Facebook", 'Facebook'), "Enter_Facebook", 'Geben Sie Facebook ein'), "WhatsApp", 'Whats App'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Geben Sie WhatsApp ein'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", 'Geben Sie LinkedIn ein'), "Twitter", 'Twitter'), "Enter_Twitter", 'Geben Sie Twitter ein'), "Experiences", 'Erfahrungen'), "bank_account", 'Bankkonto'), "Company_Name", 'Name der Firma'), "Location", 'Standort'), "Enter_location", 'Ort eingeben'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Beschreibung eingeben'), "Bank_Name", 'Name der Bank'), "Enter_Bank_Name", 'Geben Sie den Banknamen ein'), "Bank_Branch", 'Bankfiliale'), "Enter_Bank_Branch", 'Geben Sie die Bankfiliale ein'), "Bank_Number", 'Bank Nummer'), "Enter_Bank_Number", 'Geben Sie die Banknummer ein'), "Assigned_warehouses", 'Zugewiesene Lager'), "Top_customers", 'Top-Kunden'), "Attachment", 'Anhang'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "view_employee", 'Mitarbeiter ansehen'), "edit_employee", 'Mitarbeiter bearbeiten'), "delete_employee", 'Mitarbeiter löschen'), "Created_by", 'Hinzugefügt von'), "Add_product_IMEI_Serial_number", 'Produkt-IMEI/Seriennummer hinzufügen'), "Product_Has_Imei_Serial_number", 'Produkt hat IMEI/Seriennummer'), "IMEI_SN", 'IMEI/SN'), "Shipments", 'Sendungen'), "delivered_to", 'Geliefert an'), "shipment_ref", 'Sendungsnummer'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Verkauf Ref'), "Edit_Shipping", 'Versand bearbeiten'), "Packed", 'Verpackt'), "Shipped", 'Versendet'), "Delivered", 'Geliefert'), "Cancelled", 'Annulliert'), "Shipping_status", 'Versandstatus'), "Users_Report", 'Benutzerbericht'), "stock_report", 'Bestandsbericht'), "TotalPurchases", 'Gesamteinkäufe'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Gesamtzitate'), "Total_return_sales", 'Gesamtretourenverkäufe'), "Total_return_purchases", 'Total Return-Käufe'), "Total_transfers", 'Gesamtüberweisungen'), "Total_adjustments", 'Gesamtanpassungen'), "User_report", 'Benutzerbericht'), "Current_stock", 'Aktueller Lagerbestand'), "product_name", 'Produktname'), "Total_Customers_Due", 'Gesamtschulden'), "Total_Suppliers_Due", 'Gesamtschulden'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'Einige Lager'), "All_Warehouses", 'Alle Lager'), "Product_Cost", 'Produktkosten'), "sms_settings", 'SMS-Einstellungen'), "pos_settings", 'POS-Einstellungen'), "payment_gateway", 'Zahlungs-Gateways'), "mail_settings", 'E-Mail-Einstellungen'), "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'Standard-SMS-Gateway'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "module_settings", 'Moduleinstellungen'), "Module_enabled_success", 'Modul erfolgreich aktiviert'), "Module_Disabled_success", 'Modul erfolgreich deaktiviert'), "update_settings", 'Update Einstellungen'), "Please_Upload_the_Correct_Module", 'Bitte laden Sie das richtige Modul hoch'), "Uploaded_Success", 'Erfolgreich hochgeladen'), "Customer_details", 'Kundendetails'), "Edit_Customer", 'Kunde bearbeiten'), "Delete_Customer", 'Kunde löschen'), "Pay_Due", 'alle Fälligen bezahlen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'Der Zahlungsbetrag ist größer als der fällige Gesamtbetrag'), "Customer_Invoice", 'Kundenrechnung'), "This_Product_Not_For_Selling", 'Dieses Produkt ist nicht zum Verkauf bestimmt'), "Welcome_to_your_Dashboard", 'Willkommen auf Ihrem Dashboard'), "Total_Payable", 'Gesamtzahlbar'), "Choose_Sale_Ref", 'Wählen Sie Verkaufsreferenz'), "Please_Select_Sale", 'Bitte wählen Sie Verkauf'), "Sale_Ref", 'Verkauf Ref'), "list_product_returns", 'Produktrückgaben auflisten'), "Qty_return", 'Menge zurück'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Wählen Sie Kauf-Ref'), "Purchase_Ref", 'Kauf-Ref'), "please_select_purchase", 'Bitte Kauf auswählen'), "qty_return_is_greater_than_qty_purchased", 'Die zurückgegebene Menge ist größer als die gekaufte Menge'), "qty_return_is_greater_than_qty_sold", 'Die zurückgegebene Menge ist größer als die verkaufte Menge'), "Quantity_sold", 'Menge verkauft'), "qty_purchased", 'Gekaufte Menge'), "Sender_Name", 'Absendername'), "The_module_must_be_uploaded_as_zip_file", 'Das Modul muss als Zip-Datei hochgeladen werden'), "Upload_Module", 'Modul hochladen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'Alle Module installiert'), "Current_Version", 'Aktuelle Version'), "You_already_have_the_latest_version", 'Sie haben bereits die neueste Version'), "Update_Available", 'Update verfügbar'), "Update_Log", 'Protokoll aktualisieren'), "Update_Now", 'Jetzt aktualisieren'), "View_Change_Log", 'Änderungsprotokoll anzeigen'), "invoice_footer", 'Rechnung Fußzeile'), "Please_Wait_for_the_update", 'HINWEIS: Bitte warten Sie, bis das Update vollständig abgeschlossen ist. Es wird nicht empfohlen, den Browser zu schließen oder ein Prozess-Upgrade zu stoppen'), "Note_update", 'Hinweis: Stellen Sie sicher, dass Sie Ihre aktuelle Version und Datenbank sichern, bevor Sie das Upgrade ausführen, um sie wiederherzustellen, wenn ein Fehler auftritt'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Zeitzone'), "Payment_note", 'Zahlungshinweis'), "sale_note", 'Verkaufsnotizen'), "Total_Sale_Due", 'Gesamtverkaufsschulden'), "Total_Sell_Return_Due", 'Total Sell Return Debt'), "pay_all_sell_due_at_a_time", 'alle Verkaufsschulden auf einmal bezahlen'), "pay_all_sell_return_due_at_a_time", 'Bezahlen Sie alle Verkaufsrenditeschulden auf einmal'), "Gross_Profit", 'Bruttogewinn'), "pay_all_purchase_due_at_a_time", 'Bezahlen Sie alle fälligen Einkäufe auf einmal'), "Delete_Provider", 'Anbieter löschen'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Anbieter bearbeiten'), "Provider_details", 'Anbieterdetails'), "Total_Purchase_Due", 'Gesamtschulden beim Kauf'), "Provider_Credit_Note", 'Gutschrift'), "Customer_Credit_Note", 'Gutschrift'), "Sell_Return", 'Rückgabe verkaufen'), "Purchase_Return", 'Kaufrückgabe'), "Tax_Number", 'Steuernummer'), "Please_add_return_quantity", 'Bitte Retourenmenge hinzufügen'), "Return_exist_for_the_Transaction", 'Rückgabe existiert für die Transaktion'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'Die zurückgegebene Menge ist größer als die verbleibende Menge'), "products_refunded_alert", 'Alle Produkte mit einer auf 0 gesetzten Menge werden nicht erstattet'), "pay_all_purchase_return_due_at_a_time", 'alle fälligen Kaufrückgaben auf einmal bezahlen'), "Total_Purchase_Return_Due", 'Gesamtkauf Retouren fällig'), "Purchase_return_due", 'Kaufrückgabe fällig'), "Sell_return_due", 'Verkaufe Rückgabe fällig'), "product_report", 'Produktbericht'), "product_sales_report", 'Produktverkaufsbericht'), "Product_purchases_report", 'Bericht über Produktkäufe'), "Qty_sold", 'Menge verkauft'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'Menge gekauft'), "Filter_by_warehouse", 'Nach Lager filtern'), "Enable_Print_Invoice", 'Rechnung automatisch drucken'), "Show_Warehouse", 'Lager ansehen'), "credit_card_info", 'Kreditkarteninformationen'), "Saved_Credit_Card_Info", 'Gespeicherte Kreditkarteninformationen'), "Credit_card_changed_successfully", 'Kreditkarte erfolgreich geändert'), "notification_template", 'Benachrichtigungsvorlage'), "email_notification", 'E-Mail Benachrichtigung'), "sms_notification", 'SMS-Benachrichtigung'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Produktdetails ändern'), "edit_tax_and_discount_and_shipping", 'Steuern, Rabatte und Versand bearbeiten'), "Create_Quotation_with_Stock", 'Angebot mit Lagerbestand erstellen'), "Variant_Name", 'Variantenname'), "Variant_cost", 'Variantenkosten'), "Variant_price", 'Variantenpreis'), "Variant_code", 'Variantencode'), "Please_wait_until_the_product_is_loaded", 'Bitte warten Sie, bis das Produkt geladen ist'), "Choose_SMS_Gateway", 'SMS-Gateway auswählen'), "Notification_Client", 'Benachrichtigung an den Kunden'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Verfügbare Tags'), "Email_Subject", 'E-Mail Betreff'), "Email_body", 'E-Mail Inhalt'), "Notification_Supplier", 'Benachrichtigung an den Lieferanten'), "sms_body", 'SMS-Inhalt'), "sms_templates", 'SMS-Vorlagen'), "email_templates", 'E-Mail-Vorlagen'));

/***/ }),

/***/ "./resources/src/translations/locales/en.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/en.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Anglais

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Receipt',
  Pos_Settings: 'Pos Settings (Receipt)',
  Note_to_customer: 'Note to customer',
  Show_Note_to_customer: 'Show Note to customer',
  Show_barcode: 'Show barcode',
  Show_Tax_and_Discount: 'Show Tax & Discount & Shipping',
  Show_Customer: 'Show Customer',
  Show_Email: 'Show Email',
  Show_Phone: 'Show Phone',
  Show_Address: 'Show Address',
  DefaultLanguage: 'Default Language',
  footer: 'footer',
  Received_Amount: 'Received Amount',
  Paying_Amount: 'Paying Amount',
  Change: 'Change Return',
  Paying_amount_is_greater_than_Received_amount: 'Paying amount is greater than received amount',
  Paying_amount_is_greater_than_Grand_Total: 'Paying amount is greater than Grand Total',
  code_must_be_not_exist_already: 'code must be not exist already',
  You_will_find_your_backup_on: 'You will find your backup on',
  and_save_it_to_your_pc: 'and save it to your pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Scan your barcode and select the correct symbology below',
  Scan_Search_Product_by_Code_Name: 'Scan/Search Product by Code Or Name',
  Paper_size: 'Paper size',
  Clear_Cache: 'Clear Cache',
  Cache_cleared_successfully: 'Cache cleared successfully',
  Failed_to_clear_cache: 'Failed to clear cache',
  Scan_Barcode: 'Barcode Scanner',
  Please_use_short_name_of_unit: 'Please use short name of unit',
  DefaultCustomer: 'Default Customer',
  DefaultWarehouse: 'Default Warehouse',
  Payment_Gateway: 'Payment Gateway',
  SMS_Configuration: 'SMS Configuration',
  Gateway: 'SMS Gateway',
  Choose_Gateway: 'Choose SMS Gateway',
  Send_SMS: 'Message sent successfully',
  sms_config_invalid: 'wrong sms config invalid',
  Remove_Stripe_Key_Secret: 'Delete Stripe API keys',
  credit_card_account_not_available: 'Credit card account not available',
  Credit_Card_Info: 'Credit Card Info',
  developed_by: 'Developed by',
  Unit_already_linked_with_sub_unit: 'Unit already linked with sub unit',
  Total_Items_Quantity: 'Total Items & Quantity',
  Value_by_Cost_and_Price: 'Value by Cost and Price',
  Search_this_table: 'Search this table',
  import_products: 'Import products',
  Field_optional: 'Field optional',
  Download_exemple: 'Download example',
  field_must_be_in_csv_format: 'Field must be in csv format',
  Successfully_Imported: 'Successfully Imported',
  file_size_must_be_less_than_1_mega: 'File size must be less than 1 mega',
  Please_follow_the_import_instructions: 'Please follow the import instructions',
  must_be_exist: 'unit must already be created',
  Import_Customers: 'Import Customers',
  Import_Suppliers: 'Import Suppliers',
  Recent_Sales: 'Recent Sales',
  Create_Transfer: 'Create Transfer',
  order_products: 'Order items',
  Search_Product_by_Code_Name: 'Search Product by code or name',
  Reports_payments_Purchase_Return: 'Reports Purchase Return Payments',
  Reports_payments_Sale_Return: 'Reports Sale Return Payments',
  payments_Sales_Return: 'Payments Sales Return',
  payments_Purchases_Return: 'Payments Purchases Return',
  CreateSaleReturn: 'Create Sale Return',
  EditSaleReturn: 'Edit Sale Return',
  SalesReturn: 'Sales Return',
  CreatePurchaseReturn: 'Create Purchase Return',
  EditPurchaseReturn: 'Edit Purchase Return',
  PurchasesReturn: 'Purchases Return',
  Due: 'Due',
  Profit: 'Profit',
  Revenue: 'Revenue',
  Sales_today: 'Today Sales',
  People: 'People',
  Successfully_Created: 'Successfully Created',
  Successfully_Updated: 'Successfully Updated',
  Success: 'Success',
  Failed: 'Failed',
  Warning: 'Warning',
  Please_fill_the_form_correctly: 'Please fill the form correctly',
  Field_is_required: 'This Field is required',
  Error: 'Error!',
  you_are_not_authorized: 'Sorry! you are not authorized.',
  Go_back_to_home: 'Go back to homepage',
  page_not_exist: 'Sorry! The page you were looking for doesn\'t exist.',
  Choose_Status: 'Choose Status',
  Choose_Method: 'Choose Method',
  Choose_Symbology: 'Choose symbology',
  Choose_Category: 'Choose Category',
  Choose_Customer: 'Choose Customer',
  Choose_Supplier: 'Choose Supplier',
  Choose_Unit_Purchase: 'Choose Purchase Unit',
  Choose_Sub_Category: 'Choose SubCategory',
  Choose_Brand: 'Choose Brand',
  Choose_Warehouse: 'Choose Warehouse',
  Choose_Unit_Sale: 'Choose Sale Unit',
  Enter_Product_Cost: 'Enter Product Cost',
  Enter_Stock_alert: 'Enter Stock alert',
  Choose_Unit_Product: 'Choose Product Unit',
  Enter_Product_Price: 'Enter Product Price',
  Enter_Name_Product: 'Enter Name Product',
  Enter_Role_Name: 'Enter Role Name',
  Enter_Role_Description: 'Enter Role Description',
  Enter_name_category: 'Enter category Name',
  Enter_Code_category: 'Enter category Code',
  Enter_Name_Brand: 'Enter Name Brand',
  Enter_Description_Brand: 'Enter Description Brand',
  Enter_Code_Currency: 'Enter Code Currency',
  Enter_name_Currency: 'Enter name Currency',
  Enter_Symbol_Currency: 'Enter Symbol Currency',
  Enter_Name_Unit: 'Enter Unit Name',
  Enter_ShortName_Unit: 'Enter shortname Unit',
  Choose_Base_Unit: 'Choose Base Unit',
  Choose_Operator: 'Choose Operator',
  Enter_Operation_Value: 'Enter Operation Value',
  Enter_Name_Warehouse: 'Enter Warehouse Name',
  Enter_Phone_Warehouse: 'Enter Warehouse Phone',
  Enter_Country_Warehouse: 'Enter Warehouse Country',
  Enter_City_Warehouse: 'Enter Warehouse City',
  Enter_Email_Warehouse: 'Enter Warehouse Email',
  Enter_ZipCode_Warehouse: 'Enter Warehouse Zip Code',
  Choose_Currency: 'Choose Currency',
  Thank_you_for_your_business: 'Thank you for shopping with us . Please come again',
  Cancel: 'Cancel',
  New_Customer: 'New Customer',
  Incorrect_Login: 'Incorrect Login',
  Successfully_Logged_In: 'Successfully Logged In',
  This_user_not_active: 'This user not active',
  SignIn: 'Sign In',
  Create_an_account: 'Create an account',
  Forgot_Password: 'Forgot Password ?',
  Email_Address: 'Email Address',
  SignUp: 'Sign Up',
  Already_have_an_account: 'Already have an account ?',
  Reset_Password: 'Reset Password',
  Failed_to_authenticate_on_SMTP_server: 'Failed to authenticate on SMTP server',
  We_cant_find_a_user_with_that_email_addres: 'We can\'t find a user with that email addres',
  We_have_emailed_your_password_reset_link: 'We have e-mailed your password reset link',
  Please_fill_the_Email_Adress: 'Please fill the Email Address',
  Confirm_password: 'Confirm password',
  Your_Password_has_been_changed: 'Your Password has been changed',
  The_password_confirmation_does_not_match: 'The password confirmation does not match',
  This_password_reset_token_is_invalid: 'This password reset token is invalid',
  Warehouse_report: 'Warehouse report',
  All_Warehouses: 'All Warehouses',
  Expense_List: 'All Expenses',
  Expenses: 'Expenses',
  This_Week_Sales_Purchases: 'This Week Sales & Purchases',
  Top_Selling_Products: 'Top Selling Products',
  View_all: 'View all',
  Payment_Sent_Received: 'Payment Sent & Received',
  Filter: 'Filter',
  Invoice_POS: 'Invoice POS',
  Invoice: 'Invoice',
  Customer_Info: 'Customer Info',
  Company_Info: 'Company Info',
  Invoice_Info: 'Invoice Info',
  Order_Summary: 'Order Summary',
  Quote_Info: 'Quotation Info',
  Del: 'Delete',
  SuppliersPaiementsReport: 'Suppliers Payments Report',
  Purchase_Info: 'Purchase Info',
  Supplier_Info: 'Supplier Info',
  Return_Info: 'Info of Return',
  Expense_Category: 'Expense Category',
  Create_Expense: 'Create Expense',
  Details: 'Details',
  Discount_Method: 'Discount Type',
  Net_Unit_Cost: 'Net Unit Cost',
  Net_Unit_Price: 'Net Unit Price',
  Edit_Expense: 'Edit Expense',
  All_Brand: 'All Brand',
  All_Category: 'All Category',
  ListExpenses: 'All Expenses',
  Create_Permission: 'Create Permission',
  Edit_Permission: 'Edit Permission',
  Reports_payments_Sales: 'Reports payments Sales',
  Reports_payments_Purchases: 'Reports payments Purchases',
  Reports_payments_Return_Customers: 'Payments Return Customers',
  Reports_payments_Return_Suppliers: 'Payments Return Suppliers',
  Expense_Deleted: 'This Expense has been deleted',
  Expense_Updated: 'This Expense has been Updated',
  Expense_Created: 'This Expense has been Created',
  DemoVersion: 'You cannot do this in the demo version',
  OrderStatistics: 'Sales Statistics',
  AlreadyAdd: 'This Product Already Added !!',
  AddProductToList: 'Please Add Product To List !!',
  AddQuantity: 'Please Add quantity of product !!',
  InvalidData: 'Invalid Data !!',
  LowStock: 'Quantity exceeds quantity available in stock',
  WarehouseIdentical: 'The two warehouses cannot be identical !!',
  VariantDuplicate: 'This Variant Is Duplicate !!',
  Filesize: 'File size',
  GenerateBackup: 'Generate Backup',
  BackupDatabase: 'Backup Database',
  Backup: 'Backup',
  Paid: 'Paid',
  Unpaid: 'Unpaid',
  Today: 'Today',
  Income: 'Income'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'Expenses'), "Sale", 'Sale'), "Actif", 'Active'), "Inactif", 'Inactive'), "Customers", 'Customers'), "Phone", 'Phone'), "SearchByPhone", 'Search by Phone'), "Suppliers", 'Suppliers'), "Quotations", 'Quotations'), "Sales", 'Sales'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'Purchases'), "Returns", 'Return'), "Settings", 'Settings'), "SystemSettings", 'System Settings'), "Users", 'Users'), "GroupPermissions", 'Group Permissions'), "Currencies", 'Currency'), "Warehouses", 'Warehouse'), "Units", 'Unit'), "UnitsPrchases", 'Purchases Units'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Sales Units'), "Reports", 'Reports'), "PaymentsReport", 'Payments Report'), "PaymentsPurchases", 'Payments Purchases'), "PaymentsSales", 'Payments Sales'), "ProfitandLoss", 'Profit and Loss'), "WarehouseStockChart", 'Warehouse Stock Chart'), "SalesReport", 'Sale Report'), "PurchasesReport", 'Purchase Report'), "CustomersReport", 'Customer Report'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Supplier Report'), "SupplierReport", 'Supplier Report'), "DailySalesData", 'Daily Sales Data'), "DailyPurchasesData", 'Daily Purchases Data'), "Derni\xE8rescinqrecords", 'Last five records'), "Filters", 'Filters'), "date", 'Date'), "Reference", 'Reference'), "Supplier", 'Supplier'), "PaymentStatus", 'Payment Status'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", 'Customer'), "CustomerCode", 'Customer Code'), "Status", 'Status'), "SupplierCode", 'Supplier Code'), "Categorie", 'Category'), "Categories", 'Category'), "StockTransfers", 'Transfer'), "StockManagement", 'Stock Management'), "dashboard", 'Dashboard'), "Products", 'Products'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'All Products'), "ProductManagement", 'Product Management'), "ProductQuantityAlerts", 'Product Quantity Alerts'), "CodeProduct", 'Code Product'), "ProductTax", 'Product Tax'), "SubCategorie", 'Sub Category'), "Name_product", 'Name'), "StockAlert", 'Stock Alert'), "warehouse", 'Warehouse'), "Tax", 'Tax'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Buying price'), "SellPrice", 'Sell price'), "Quantity", 'Quantity'), "UnitSale", 'Sale Unit'), "UnitPurchase", 'Purchase Unit'), "ManagementCurrencies", 'Currency Management'), "CurrencyCode", 'Currency Code'), "CurrencyName", 'Currency Name'), "Symbol", 'Symbol'), "All", 'All'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Edit Product'), "SearchByCode", 'Search by Code'), "SearchByName", 'Search by Name'), "ProductDetails", 'Product Details'), "CustomerName", 'Customer Name'), "CustomerManagement", 'Customer Management'), "Add", 'Create'), "add", 'Create'), "Edit", 'Edit'), "Close", 'Close'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Please Select'), "Action", 'Action'), "Email", 'Email'), "EditCustomer", 'Edit Customer'), "AddCustomer", 'Create Customer'), "Country", 'Country'), "City", 'City'), "Adress", 'Address'), "CustomerDetails", 'Customer Details'), "CustomersList", 'Customers'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Supplier Code'), "SupplierName", 'Supplier Name'), "SuppliersManagement", 'Suppliers Management'), "SupplierDetails", 'Supplier Details'), "QuotationsManagement", 'Quotations Management'), "SubTotal", 'Subtotal'), "MontantReste", 'Amount left'), "complete", 'Completed'), "EnAttendant", 'Pending'), "Recu", 'Received'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", 'Partial'), "Retournee", 'Return'), "DetailQuote", 'Detail Quotation'), "EditQuote", 'Edit Quotation'), "CreateSale", 'Create Sale'), "DownloadPdf", 'Download Pdf'), "QuoteEmail", 'Send Quotation on Email'), "DeleteQuote", 'Delete Quotation'), "AddQuote", 'Create Quotation'), "SelectProduct", 'Select Product'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Product (Code - Name)'), "Price", 'Price'), "CurrentStock", 'Stock'), "Total", 'Grand Total'), "Num", 'N°'), "Unitcost", 'Unit cost'), "to", 'To'), "Subject", 'Subject'), "Message", 'Message'), "EmailCustomer", 'Email Customer'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", 'Send'), "Quote", 'Quotation'), "Hello", 'Hello'), "AttachmentQuote", 'Please find the attachment for your Quotation'), "AddProducts", 'Add Products to the Order List'), "SelectWarehouse", 'Please Select warehouse'), "SelectCustomer", 'please Select Customer'), "SalesManagement", 'Sales Management'), "Balance", 'Balance'), "QtyBack", 'Qty Back'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Total Return'), "Amount", 'Amount'), "SaleDetail", 'Sale Detail'), "EditSale", 'Edit Sale'), "AddSale", 'Create Sale'), "ShowPayment", 'Show Payments'), "AddPayment", 'Create Payment'), "EditPayment", 'Edit Payment'), "EmailSale", 'Send Sale on Email'), "DeleteSale", 'Delete Sale'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Paid by'), "Paymentchoice", 'Payment choice'), "Note", 'Note'), "PaymentComplete", 'Payment complete!'), "PurchasesManagement", 'Purchases Management'), "Ordered", 'Ordered'), "DeletePurchase", 'Delete Purchase'), "EmailPurchase", 'Send Purchase on Email'), "EditPurchase", 'Edit Purchase'), "PurchaseDetail", 'Purchase Detail'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Create Purchase'), "EmailSupplier", 'Supplier Email'), "PurchaseInvoice", 'Purchases payments'), "PurchasesInvoicesData", 'Purchases payments data'), "SalesInvoice", 'Sales payments'), "SalesInvoicesData", 'Sales payments data'), "UserManagement", 'Users management'), "Firstname", 'First name'), "lastname", 'Last name'), "username", 'Username'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", 'Password'), "Newpassword", 'New password'), "ChangeAvatar", 'Change Avatar'), "LeaveBlank", 'Please leave this field blank if you haven\'t changed it'), "type", 'Type'), "UserPermissions", 'Users Permissions'), "RoleName", 'Role'), "RoleDescription", 'Role Description'), "AddPermissions", 'Create Permissions'), "View", 'View'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", 'Delete'), "NewAdjustement", 'New Adjustement'), "EditAdjustement", 'Edit Adjustement'), "CannotSubstraction", 'You cannot subtraction products which have stock 0'), "Addition", 'Addition'), "Subtraction", 'Subtraction'), "profil", 'Profile'), "logout", 'Logout'), "PurchaseAlreadyPaid", 'You cannot modify because this Purchase already paid'), "SaleAlreadyPaid", 'You cannot modify because this Sale already paid'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'You cannot modify because this Return already paid'), "QuoteAlready", 'This quote already has generate sale'), "AddProduct", 'Create product'), "QuotationComplete", 'This Quotation Complete'), "SiteConfiguration", 'Site Configuration'), "Language", 'Language'), "DefaultCurrency", 'Default Currency'), "LoginCaptcha", 'Login Captcha'), "DefaultEmail", 'Default Email'), "SiteName", 'Site Name'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Change Logo'), "SMTPConfiguration", 'SMTP Configuration'), "HOST", 'MAIL_HOST'), "PORT", 'MAIL_PORT'), "encryption", 'MAIL_ENCRYPTION'), "SMTPIncorrect", 'SMTP Configuration Incorrect'), "PaymentsReturns", 'Payments Returns'), "ReturnsInvoices", 'Returns Invoices'), "ReturnsInvoicesData", 'Returns Invoices Data'), "ShowAll", 'View all records of all Users'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", 'Discount'), "OrderTax", 'Order Tax'), "Shipping", 'Shipping'), "CompanyName", 'Company Name'), "CompanyPhone", 'Company Phone'), "CompanyAdress", 'Company Address'), "Code", 'Code'), "image", 'Image'), "Printbarcode", 'Print Labels'), "ReturnsCustomers", 'Returns Customer'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Returns Supplier'), "FactureReturnCustomers", 'Return Customer Invoice'), "FactureReturnSuppliers", 'Return Supplier Invoice'), "NodataAvailable", 'No data Available'), "ProductImage", 'Product Image'), "Barcode", 'Barcode'), "pointofsales", 'Point of Sales'), "CustomUpload", 'Custom Upload'), "pointofsaleManagement", 'Point of Sale Management'), "Adjustment", 'Adjustment'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", 'Update'), "Reset", 'Reset'), "print", 'Print'), "SearchByEmail", 'Search By Email'), "ChooseProduct", 'Choose Product'), "Qty", 'Qty'), "Items", 'Items'), "AmountHT", 'Amount HT'), "AmountTTC", 'Amount TTC'), "PleaseSelectSupplier", 'Please Select Supplier'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Please Select Status'), "PayeBy", 'Paid By'), "ChooseWarehouse", 'Choose Warehouse'), "payNow", 'Pay Now'), "ListofCategory", 'List of Category'), "Description", 'Description'), "submit", 'Submit'), "ProblemCreatingThisInvoice", 'There was a problem creating this Invoice. Please try again'), "ProblemPayment", 'There was a problem Payment. Please try again.'), "IncomeExpenses", 'Income & Expenses'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'Daily Sales & Purchases'), "ProductsExpired", 'Products Expired'), "ListofBrand", 'Brands'), "CreateAdjustment", 'Create Adjustment'), "Afewwords", 'A few words ...'), "UserImage", 'User Image'), "UpdateProduct", 'Update Product'), "Brand", 'Brand'), "BarcodeSymbology", 'Barcode Symbology'), "ProductCost", 'Product Cost'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Product Price'), "UnitProduct", 'Product Unit'), "TaxMethod", 'Tax Type'), "MultipleImage", 'Multiple Image'), "ProductHasMultiVariants", 'This Product Has Multi Variants'), "ProductHasPromotion", 'Product Has Promotion'), "PromotionStart", 'Promotion Start'), "PromotionEnd", 'Promotion End'), "PromotionPrice", 'Promotion Price'), "Price", 'Price'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Cost", 'Cost'), "Unit", 'Unit'), "ProductVariant", 'Product Variant'), "Variant", 'Variant'), "UnitPrice", 'Unit Price'), "CreateReturnCustomer", 'Create Return Customer'), "EditReturnCustomer", 'Edit Return Customer'), "CreateReturnSupplier", 'Create Return Supplier'), "Documentation", 'Doc'), "EditReturnSupplier", 'Edit Return Supplier'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'From Warehouse'), "ToWarehouse", 'To Warehouse'), "EditTransfer", 'Edit Transfer'), "TransferDetail", 'Transfer Detail'), "Pending", 'Pending'), "Received", 'Received'), "Ordered", 'Ordered'), "PermissionsManager", 'Permissions Management'), "BrandManager", 'Brand'), "BrandImage", 'Brand Image'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BrandName", 'Brand Name'), "BrandDescription", 'Brand Description'), "BaseUnit", 'Base Unit'), "ManagerUnits", 'Units Management'), "OperationValue", 'Operation Value'), "Operator", 'Operator'), "Top5Products", 'Top 5 Products'), "Last5Sales", 'Last 5 Sales'), "ListAdjustments", 'All Adjustments'), "ListTransfers", 'All Transfers'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Create Transfer'), "OrdersManager", 'Orders Management'), "ListQuotations", 'All Quotations'), "ListPurchases", 'All Purchases'), "ListSales", 'All Sales'), "ListReturns", 'All Returns'), "PeopleManager", 'People Management'), "Delete", {
  Title: 'Are you sure?',
  Text: 'You won\'t be able to revert this!',
  confirmButtonText: 'Yes, delete it!',
  cancelButtonText: 'Cancel',
  Deleted: 'Deleted!',
  Failed: 'Failed!',
  Therewassomethingwronge: 'There was something wronge',
  CustomerDeleted: 'This Client has been deleted.',
  SupplierDeleted: 'This Supplier has been deleted.',
  QuoteDeleted: 'This Quotation has been deleted.',
  SaleDeleted: 'This Sale has been deleted.',
  PaymentDeleted: 'This Payment has been deleted.',
  PurchaseDeleted: 'This Purchase has been deleted.',
  ReturnDeleted: 'This Return has been deleted.',
  ProductDeleted: 'This Product has been deleted.',
  ClientError: 'This Client already linked with other Operation',
  ProviderError: 'This Supplier already linked with other Operation',
  UserDeleted: 'This User has been deleted.',
  UnitDeleted: 'This Unit has been deleted.',
  RoleDeleted: 'This Role has been deleted.',
  TaxeDeleted: 'This Tax has been deleted.',
  SubCatDeleted: 'This Sub Category has been deleted.',
  CatDeleted: 'This Category has been deleted.',
  WarehouseDeleted: 'This Warehouse has been deleted.',
  AlreadyLinked: 'This product already linked with other Operation',
  AdjustDeleted: 'This Adjustement has been deleted.',
  TitleCurrency: 'This Currency has been deleted.',
  TitleTransfer: 'The Transfer has been removed successfully',
  BackupDeleted: 'Backup has been removed successfully',
  TitleBrand: 'This Brand has been deleted'
}), "Update", {
  TitleBrand: 'This Brand has been Updated',
  TitleProfile: 'Your Profile Updated in successfully',
  TitleAdjust: 'Adjustement Updated in successfully',
  TitleRole: 'Role Updated in successfully',
  TitleUnit: 'Unit Updated in successfully',
  TitleUser: 'User Updated in successfully',
  TitleCustomer: 'Customer Updated in successfully',
  TitleQuote: 'Quotation Updated in successfully',
  TitleSale: 'Sale Updated in successfully',
  TitlePayment: 'Payment Updated in successfully',
  TitlePurchase: 'Purchase Updated in successfully',
  TitleReturn: 'Return Updated in successfully',
  TitleProduct: 'Product Updated in successfully',
  TitleSupplier: 'Supplier Updated in successfully',
  TitleTaxe: 'Tax Updated in successfully',
  TitleCat: 'Category Updated in successfully',
  TitleWarhouse: 'Warhouse Updated in successfully',
  TitleSetting: 'Settings Updated in successfully',
  TitleCurrency: 'Currency Updated in successfully',
  TitleTransfer: 'Transfer Updated in successfully'
}), "Create", {
  TitleBrand: 'This Brand has been Created',
  TitleRole: 'Role Created in successfully',
  TitleUnit: 'Unit Created in successfully',
  TitleUser: 'User Created in successfully',
  TitleCustomer: 'Customer Created in successfully',
  TitleQuote: 'Quotation Created in successfully',
  TitleSale: 'Sale Created in successfully',
  TitlePayment: 'Payment Created in successfully',
  TitlePurchase: 'Purchase Created in successfully',
  TitleReturn: 'Return Created in successfully',
  TitleProduct: 'Product Created in successfully',
  TitleSupplier: 'Supplier Created in successfully',
  TitleTaxe: 'Tax Created in successfully',
  TitleCat: 'Category Created in successfully',
  TitleWarhouse: 'Warehouse Created in successfully',
  TitleAdjust: 'Adjustement Created in successfully',
  TitleCurrency: 'Currency Created in successfully',
  TitleTransfer: 'Transfer Created in successfully'
}), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'Email Send in successfully'
}), "return", {
  TitleSale: 'This sale already linked with a Return!'
}), "ReturnManagement", 'Return Management'), "ReturnDetail", 'Return Detail'), "EditReturn", 'Edit Return'), "AddReturn", 'Create Return'), "EmailReturn", 'Send Return on Email'), "DeleteReturn", 'Delete Return'), "Retoursurcharge", 'Return Surcharge'), "Laivrison", 'Delivery'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Select Sale'), "ZeroPardefault", 'You can delete the item or set the quantity returned to zero if it is not returned'), "Return", 'Return'), "Purchase", 'Purchase'), "TotalSales", 'Total Sales'), "TotalPurchases", 'Total Purchases'), "TotalReturns", 'Total Returns'), "PaiementsNet", 'Payments Net'), "PaiementsSent", 'Payments Sent'), "PaiementsReceived", 'Payments Received'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Recieved", 'Recieved'), "Sent", 'Sent'), "ProductQuantityAlerts", 'Product Quantity Alerts'), "ProductCode", 'Code'), "ProductName", 'Product'), "AlertQuantity", 'Alert Quantity'), "WarehouseStockChart", 'Warehouse Stock Chart'), "TotalProducts", 'Total Products'), "TotalQuantity", 'Total Quantity'), "TopCustomers", 'Top 5 Customers'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Total Amount'), "TotalPaid", 'Total Paid'), "CustomerSalesReport", 'Customer Sales Report'), "CustomerPaiementsReport", 'Customer Payments Report'), "CustomerQuotationsReport", 'Customer Quotations Report'), "Payments", 'Payments'), "TopSuppliers", 'Top 5 Suppliers'), "SupplierPurchasesReport", 'Supplier Purchases Report'), "SupplierPaiementsReport", 'Supplier Payments Report'), "Name", 'Name'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Code", 'Code'), "ManagementWarehouse", 'Warehouse Management'), "ZipCode", 'Zip Code'), "managementCategories", 'Categories management'), "Codecategorie", 'Category Code'), "Namecategorie", 'Category Name'), "Parentcategorie", 'Parent category'), "managementTax", 'Tax management'), "TaxName", 'Tax Name'), "TaxRate", 'Tax Rate'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Purchases Unit'), "managementUnitSales", 'Sales Unit'), "ShortName", 'Short Name'), "PleaseSelectThesebeforeaddinganyproduct", 'Please Select These before adding any product'), "StockAdjustement", 'Adjustment'), "PleaseSelectWarehouse", 'Please Select warehouse before choose any product'), "StockTransfer", 'Stock Transfer'), "SelectPeriod", 'Select Period'), "ThisYear", 'This Year'), "ThisToday", 'This Today'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'This Month'), "ThisWeek", 'This Week'), "AdjustmentDetail", 'Adjustment Detail'), "ActivateUser", 'This User Has been Activated'), "DisActivateUser", 'This User Has been Deactivated'), "NotFound", 'Page not found.'), "oops", 'Oops! Page not found.'), "couldNotFind", 'We could not find the page you were looking for.Meanwhile, you may'), "ReturnDashboard", 'Return to dashboard'), "hrm", 'HRM'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Employees", 'Employees'), "Attendance", 'Attendance'), "Leave_request", 'Leave Request'), "Leave_type", 'Leave Type'), "Company", 'Company'), "Departments", 'Departments'), "Designations", 'Designations'), "Office_Shift", 'Office Shift'), "Holidays", 'Holidays'), "Enter_Company_Name", 'Enter company name'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Enter email address'), "Enter_Company_Phone", 'Enter company phone'), "Enter_Company_Country", 'Enter company country'), "Created_in_successfully", 'Created in successfully'), "Updated_in_successfully", 'Updated in successfully'), "Deleted_in_successfully", 'Deleted in successfully'), "department", 'Department'), "Enter_Department_Name", 'Enter department name'), "Choose_Company", 'Choose Company'), "Department_Head", 'Department Head'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Choose Department Head'), "Enter_Shift_name", 'Enter Shift name'), "Monday_In", 'Monday In'), "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'Holiday'), "Enter_title", 'Enter title'), "title", 'title'), "start_date", 'Start date'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Enter start date'), "Finish_Date", 'Finish date'), "Enter_Finish_date", 'Enter finish date'), "Please_provide_any_details", 'Please provide any details'), "Attendances", 'Attendances'), "Enter_Attendance_date", 'Enter attendance date'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", 'Choose Employee'), "Employee", 'Employee'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Work Duration'), "remaining_leaves_are_insufficient", 'Remaining leaves are insufficient'), "Leave_Type", 'Leave Type'), "Days", 'Days'), "Department", 'Department'), "Choose_leave_type", 'Choose leave type'), "Choose_status", 'Choose status'), "Leave_Reason", 'Leave Reason'), "Enter_Reason_Leave", 'Enter Reason Leave'), "Add_Employee", 'Add Employee'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FirstName", 'First Name'), "Enter_FirstName", 'Enter First Name'), "LastName", 'Last Name'), "Enter_LastName", 'Enter Last Name'), "Gender", 'Gender'), "Choose_Gender", 'Choose Gender'), "Enter_Birth_date", 'Enter birth date'), "Birth_date", 'Birth date'), "Enter_Country", 'Enter Country'), "Enter_Phone_Number", 'Enter Phone Number'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "joining_date", 'Joining date'), "Enter_joining_date", 'Enter joining date'), "Choose_Designation", 'Choose Designation'), "Designation", 'Designation'), "Office_Shift", 'Office Shift'), "Choose_Office_Shift", 'Choose Office Shift'), "Enter_Leaving_Date", 'Enter Leaving Date'), "Leaving_Date", 'Leaving Date'), "Annual_Leave", 'Annual Leave'), "Enter_Annual_Leave", 'Enter Annual Leave'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Remaining leave'), "Employee_Details", 'Employee Details'), "Basic_Information", 'Basic Information'), "Family_status", 'Family Status'), "Choose_Family_status", 'Choose Family status'), "Employment_type", 'Employment type'), "Select_Employment_type", 'Select Employment type'), "Enter_City", 'Enter City'), "Province", 'Province'), "Enter_Province", 'Enter Province'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Enter Address'), "Enter_Zip_code", 'Enter Zip code'), "Zip_code", 'Zip code'), "Hourly_rate", 'Hourly rate'), "Enter_Hourly_rate", 'Enter Hourly rate'), "Basic_salary", 'Basic salary'), "Enter_Basic_salary", 'Enter Basic salary'), "Social_Media", 'Social Media'), "Skype", 'Skype'), "Enter_Skype", 'Enter Skype'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), "Enter_Facebook", 'Enter Facebook'), "WhatsApp", 'WhatsApp'), "Enter_WhatsApp", 'Enter WhatsApp'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", 'Enter LinkedIn'), "Twitter", 'Twitter'), "Enter_Twitter", 'Enter Twitter'), "Experiences", 'Experiences'), "bank_account", 'bank account'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Company_Name", 'Company Name'), "Location", 'Location'), "Enter_location", 'Enter location'), "Enter_Description", 'Enter Description'), "Bank_Name", 'Bank Name'), "Enter_Bank_Name", 'Enter Bank Name'), "Bank_Branch", 'Bank Branch'), "Enter_Bank_Branch", 'Enter Bank Branch'), "Bank_Number", 'Bank Number'), "Enter_Bank_Number", 'Enter Bank Number'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Access warehouses'), "Top_customers", 'Best customers'), "Attachment", 'Attachment'), "view_employee", 'view employee'), "edit_employee", 'Edit employee'), "delete_employee", 'Delete employee'), "Created_by", 'Added by'), "Add_product_IMEI_Serial_number", 'Add product IMEI/Serial Number'), "Product_Has_Imei_Serial_number", 'Product Has Imei/Serial Number'), "IMEI_SN", 'IMEI/SN'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Shipments", 'Shipments'), "delivered_to", 'Delivered To'), "shipment_ref", 'Shipment Ref'), "sale_ref", 'Sale Ref'), "Edit_Shipping", 'Edit Shipping'), "Packed", 'Packed'), "Shipped", 'Shipped'), "Delivered", 'Delivered'), "Cancelled", 'Cancelled'), "Shipping_status", 'Shipping Status'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Users Report'), "stock_report", 'Stock Report'), "TotalPurchases", 'Total Purchases'), "Total_quotations", 'Total Quotations'), "Total_return_sales", 'Total return sales'), "Total_return_purchases", 'Total return purchases'), "Total_transfers", 'Total transfers'), "Total_adjustments", 'Total adjustments'), "User_report", 'User Report'), "Current_stock", 'Current Stock'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_name", 'Product Name'), "Total_Customers_Due", 'Total Debt'), "Total_Suppliers_Due", 'Total Debt'), "Some_warehouses", 'Some Warehouses'), "All_Warehouses", 'All Warehouses'), "Product_Cost", 'Product Cost'), "sms_settings", 'Sms Settings'), "pos_settings", 'POS Settings'), "payment_gateway", 'Payment Gateway'), "mail_settings", 'Mail Settings'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'Default SMS Gateway'), "module_settings", 'Module Settings'), "Module_enabled_success", 'Module enabled successfully'), "Module_Disabled_success", 'Module Disabled successfully'), "update_settings", 'Upgrade'), "Please_Upload_the_Correct_Module", 'Please Upload the Correct Module'), "Uploaded_Success", 'Uploaded in successfully'), "Customer_details", 'Customer Details'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Edit Customer'), "Delete_Customer", 'Delete Customer'), "Pay_Due", 'Pay Due'), "Paying_amount_is_greater_than_Total_Due", 'Paying amount is greater than Total Due'), "Customer_Invoice", 'Customer Invoice'), "This_Product_Not_For_Selling", 'This Product Not For Selling'), "Welcome_to_your_Dashboard", 'Welcome to your Dashboard'), "Total_Payable", 'Total Payable'), "Choose_Sale_Ref", 'Choose Sale Ref'), "Please_Select_Sale", 'Please Select Sale'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Sale Ref'), "list_product_returns", 'list product returns'), "Qty_return", 'Qty return'), "Choose_Purchase_Ref", 'Choose Purchase Ref'), "Purchase_Ref", 'Purchase Ref'), "please_select_purchase", 'Please Select Purchase'), "qty_return_is_greater_than_qty_purchased", 'Qty return is greater than Qty purchased'), "qty_return_is_greater_than_qty_sold", 'Qty return is greater than Qty sold'), "Quantity_sold", 'Qty sold'), "qty_purchased", 'Qty purchased'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Sender Name'), "The_module_must_be_uploaded_as_zip_file", 'The module must be uploaded as zip file'), "Upload_Module", 'Upload Module'), "All_Modules_Installed", 'All Modules Installed'), "Current_Version", 'Current Version'), "You_already_have_the_latest_version", 'You already have the latest version'), "Update_Available", 'Update Available'), "Update_Log", 'Update Log'), "Update_Now", 'Update Now'), "View_Change_Log", 'View Change Log'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_Wait_for_the_update", 'NOTE:  Please Wait for the update to finish completely. It is not recommended to close the browser or stop a process Upgrade'), "Note_update", 'Note : Make sure you backup your Current version & database before you run the Upgrade , To restore it if there is an error'), "invoice_footer", 'Invoice footer'), "Time_Zone", 'Time Zone'), "Payment_note", 'Payment notes'), "sale_note", 'Sale notes'), "Total_Sale_Due", 'Total Sale Due'), "Total_Sell_Return_Due", 'Total Sell Return Due'), "pay_all_sell_due_at_a_time", 'pay all sell due at a time'), "pay_all_sell_return_due_at_a_time", 'pay all sell return due at a time'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Gross Profit'), "pay_all_purchase_due_at_a_time", 'pay all purchase due at a time'), "Delete_Provider", 'Delete Provider'), "Edit_Provider", 'Edit Provider'), "Provider_details", 'Provider details'), "Total_Purchase_Due", 'Total Purchase Due'), "Provider_Credit_Note", 'Provider Credit Note'), "Customer_Credit_Note", 'Customer Credit Note'), "Sell_Return", 'Sell Return'), "Purchase_Return", 'Purchase Return'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Tax Number'), "Please_add_return_quantity", 'Please add return quantity'), "Return_exist_for_the_Transaction", 'Return exist for the Transaction'), "qty_return_is_greater_than_Quantity_Remaining", 'Qty return is greater than Quantity Remaining'), "products_refunded_alert", 'Any products with a quantity set to 0 won\'t be refunded'), "pay_all_purchase_return_due_at_a_time", 'pay all purchase return due at a time'), "Total_Purchase_Return_Due", 'Total Purchase Return Due'), "Purchase_return_due", 'Purchase return due'), "Sell_return_due", 'Sell return due'), "product_report", 'Product report'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'Product sales report'), "Product_purchases_report", 'Product purchases report'), "Qty_sold", 'Qty sold'), "Qty_purchased", 'Qty purchased'), "Filter_by_warehouse", 'Filter by warehouse'), "Enable_Print_Invoice", 'Print Invoice automatically'), "Show_Warehouse", 'Show warehouse'), "credit_card_info", 'Credit card info'), "Saved_Credit_Card_Info", 'Saved Credit Card Info'), "Credit_card_changed_successfully", 'Credit card changed successfully'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "notification_template", 'Notification Template'), "email_notification", 'Email notification'), "sms_notification", 'SMS notification'), "Change_product_details", 'Change product details'), "edit_tax_and_discount_and_shipping", 'edit tax and discount and shipping'), "Create_Quotation_with_Stock", 'Create Quotation with Stock'), "Variant_Name", 'Variant Name'), "Variant_cost", 'Variant cost'), "Variant_price", 'Variant price'), "Variant_code", 'Variant code'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Please wait until the product is loaded'), "Choose_SMS_Gateway", 'Choose SMS Gateway'), "Notification_Client", 'Notification Client'), "Available_Tags", 'Available Tags'), "Email_Subject", 'Email Subject'), "Email_body", 'Email body'), "Notification_Supplier", 'Notification Supplier'), "sms_body", 'SMS body'), "sms_templates", 'SMS Templates'), "email_templates", 'Email Templates'));

/***/ }),

/***/ "./resources/src/translations/locales/es.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/es.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Espagnol

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Recibo',
  Pos_Settings: 'Configuración de punto de venta',
  Note_to_customer: 'Nota al cliente',
  Show_Note_to_customer: 'Mostrar nota al cliente',
  Show_barcode: 'Mostrar código de barras',
  Show_Tax_and_Discount: 'Mostrar impuestos, descuentos y envío',
  Show_Customer: 'Mostrar cliente',
  Show_Email: 'Mostrar correo electrónico',
  Show_Phone: 'Mostrar teléfono',
  Show_Address: 'Mostrar dirección',
  DefaultLanguage: 'Idioma predeterminado',
  footer: 'pie de página',
  Received_Amount: 'Cantidad recibida',
  Paying_Amount: 'Monto de pago',
  Change: 'cambiar',
  Paying_amount_is_greater_than_Received_amount: 'El monto a pagar es mayor que el monto recibido',
  Paying_amount_is_greater_than_Grand_Total: 'El monto a pagar es mayor que el total general',
  code_must_be_not_exist_already: 'el código no debe existir ya',
  You_will_find_your_backup_on: 'Encontrarás tu copia de seguridad en',
  and_save_it_to_your_pc: 'y guárdalo en tu pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Escanee su código de barras y seleccione la simbología correcta a continuación',
  Scan_Search_Product_by_Code_Name: 'Escanear / Buscar producto por nombre de código',
  Paper_size: 'Tamaño de papel',
  Clear_Cache: 'limpiar cache',
  Cache_cleared_successfully: 'Caché borrada con éxito',
  Failed_to_clear_cache: 'No se pudo borrar la caché',
  Scan_Barcode: 'Escáner de código de barras',
  Please_use_short_name_of_unit: 'Utilice el nombre corto de la unidad',
  DefaultCustomer: 'Cliente predeterminado',
  DefaultWarehouse: 'Almacén predeterminado',
  Payment_Gateway: 'Pasarela de pago',
  SMS_Configuration: 'Configuración de SMS',
  Gateway: 'Pasarela de pago',
  Choose_Gateway: 'Elija la pasarela de pago',
  Send_SMS: 'Mensaje enviado con éxito',
  sms_config_invalid: 'configuración de sms incorrecta no válida',
  Remove_Stripe_Key_Secret: 'Eliminar claves de API de Stripe',
  credit_card_account_not_available: 'Cuenta de tarjeta de crédito no disponible',
  Credit_Card_Info: 'Información de la tarjeta de crédito',
  developed_by: 'Desarrollado por',
  Unit_already_linked_with_sub_unit: 'Unidad ya vinculada con la subunidad',
  Total_Items_Quantity: 'Total de artículos y cantidad',
  Value_by_Cost_and_Price: 'Valor por costo y precio',
  Search_this_table: 'Buscar esta tabla',
  import_products: 'Importar productos',
  Field_optional: 'Campo opcional',
  Download_exemple: 'Descargar ejemplo',
  field_must_be_in_csv_format: 'El campo debe estar en formato csv',
  Successfully_Imported: 'Importada exitosamente',
  file_size_must_be_less_than_1_mega: 'El tamaño del archivo debe ser inferior a 1 mega',
  Please_follow_the_import_instructions: 'Siga las instrucciones de importación.',
  must_be_exist: 'la unidad ya debe estar creada',
  Import_Customers: 'Importar clientes',
  Import_Suppliers: 'Proveedores de importación',
  Recent_Sales: 'Ventas recientes',
  Create_Transfer: 'Crear transferencia',
  order_products: 'encargar artículos',
  Search_Product_by_Code_Name: 'Buscar producto por código o nombre',
  Reports_payments_Purchase_Return: 'Informes Pagos de devolución de compra',
  Reports_payments_Sale_Return: 'Informes Pagos de devolución de venta',
  payments_Sales_Return: 'pagos ventas Devolución',
  payments_Purchases_Return: 'pagos compras Devolución',
  CreateSaleReturn: 'Crear devolución de venta',
  EditSaleReturn: 'Editar devolución de venta Sale Return',
  SalesReturn: 'Devolución de ventas',
  CreatePurchaseReturn: 'Crear devolución de compra',
  EditPurchaseReturn: 'Editar devolución de compra',
  PurchasesReturn: 'Devolución de compras',
  Due: 'debido',
  Profit: 'Lucro',
  Revenue: 'Ingresos',
  Sales_today: 'Ventas hoy',
  People: 'Gente',
  Successfully_Created: 'Creado con éxito',
  Successfully_Updated: 'Actualizado exitosamente',
  Success: 'Éxito',
  Failed: 'fallido',
  Warning: 'Advertencia',
  Please_fill_the_form_correctly: 'Por favor complete el formulario correctamente',
  Field_is_required: 'Se requiere campo',
  Error: 'Error!',
  you_are_not_authorized: '¡Perdón! usted no está autorizado.',
  Go_back_to_home: 'Volver a la página principal',
  page_not_exist: '¡Perdón! La página que buscaba no existe.',
  Choose_Status: 'Elija estado',
  Choose_Method: 'Elija el método',
  Choose_Symbology: 'Elija simbología',
  Choose_Category: 'Elegir la categoría',
  Choose_Customer: 'Elija cliente',
  Choose_Supplier: 'Elija proveedor',
  Choose_Unit_Purchase: 'Elija unidad de compra',
  Choose_Sub_Category: 'Elija subcategoría',
  Choose_Brand: 'Elija marca',
  Choose_Warehouse: 'Elija Almacén',
  Choose_Unit_Sale: 'Elija la unidad de venta',
  Enter_Product_Cost: 'Ingrese el costo del producto',
  Enter_Stock_alert: 'Entrar alerta de stock',
  Choose_Unit_Product: 'Elija la unidad de producto',
  Enter_Product_Price: 'Ingrese el precio del producto',
  Enter_Name_Product: 'Ingrese el nombre del producto',
  Enter_Role_Name: 'Ingrese el nombre del rol',
  Enter_Role_Description: 'Ingrese la descripción del rol',
  Enter_name_category: 'Ingrese el nombre de la categoría',
  Enter_Code_category: 'Ingrese el código de la categoría',
  Enter_Name_Brand: 'Ingrese el nombre de la marca',
  Enter_Description_Brand: 'Ingrese la descripción de la marca',
  Enter_Code_Currency: 'Ingrese la moneda del código',
  Enter_name_Currency: 'Ingrese el nombre Moneda',
  Enter_Symbol_Currency: 'Ingrese la moneda del símbolo',
  Enter_Name_Unit: 'Ingrese el nombre de la unidad',
  Enter_ShortName_Unit: 'Introduzca la unidad de nombre corto',
  Choose_Base_Unit: 'Elija la unidad base',
  Choose_Operator: 'Elegir Operadora',
  Enter_Operation_Value: 'Ingrese el valor de la operación',
  Enter_Name_Warehouse: 'Ingrese el nombre del almacén',
  Enter_Phone_Warehouse: 'Ingrese el teléfono del almacén',
  Enter_Country_Warehouse: 'Ingrese el país del almacén',
  Enter_City_Warehouse: 'Ingrese la ciudad del almacén',
  Enter_Email_Warehouse: 'Ingrese el correo electrónico del almacén',
  Enter_ZipCode_Warehouse: 'Ingrese el código postal del almacén',
  Choose_Currency: 'Elegir Moneda',
  Thank_you_for_your_business: '¡Gracias por su negocios!',
  Cancel: 'Cancelar',
  New_Customer: 'Nueva cliente',
  Incorrect_Login: 'Inicio de sesión incorrecto',
  Successfully_Logged_In: 'Inicio de sesión exitoso',
  This_user_not_active: 'Esta usuaria no activa',
  SignIn: 'Registrarse',
  Create_an_account: 'Crea una cuenta',
  Forgot_Password: 'Has olvidado tu contraseña ?',
  Email_Address: 'Dirección de correo electrónico',
  SignUp: 'Inscribirse',
  Already_have_an_account: 'Ya tienes una cuenta ?',
  Reset_Password: 'Restablecer la contraseña',
  Failed_to_authenticate_on_SMTP_server: 'No se pudo autenticar en el servidor SMTP',
  We_cant_find_a_user_with_that_email_addres: 'No podemos encontrar un usuario con esa dirección de correo electrónico',
  We_have_emailed_your_password_reset_link: 'Hemos enviado su enlace de restablecimiento de contraseña por correo electrónico',
  Please_fill_the_Email_Adress: 'Por favor complete la dirección de correo electrónico',
  Confirm_password: 'Confirmar Contraseña',
  Your_Password_has_been_changed: 'Tu contraseña ha sido cambiada',
  The_password_confirmation_does_not_match: 'La confirmación de la contraseña no coincide',
  This_password_reset_token_is_invalid: 'Este token de restablecimiento de contraseña no es válido',
  Warehouse_report: 'Informe de almacén',
  All_Warehouses: 'Todos los almacenes',
  Expense_List: 'Lista de gastos',
  Expenses: 'Gastos',
  This_Week_Sales_Purchases: 'Ventas y compras de esta semana',
  Top_Selling_Products: 'Productos más vendidos',
  View_all: 'Ver todo',
  Payment_Sent_Received: 'Pago enviado y recibido',
  Filter: "Filtrar",
  Invoice_POS: "Factura POS",
  Invoice: "Factura",
  Customer_Info: "Información del cliente",
  Company_Info: "Información de la compañía",
  Invoice_Info: "Información de la factura",
  Order_Summary: "Resumen del pedido",
  Quote_Info: "Información de cotización",
  Del: "Eliminar",
  SuppliersPaiementsReport: "Informe de pagos a proveedores",
  Purchase_Info: "Información de compra",
  Supplier_Info: "Información del proveedor",
  Return_Info: "info de devolución",
  Expense_Category: "Categoría de gastos",
  Create_Expense: "Crear gasto",
  Details: "Detalles",
  Discount_Method: "Método de descuento",
  Net_Unit_Cost: "Costo unitario neto",
  Net_Unit_Price: "Precio unitario neto",
  Edit_Expense: "Editar gasto",
  All_Brand: "Toda la marca",
  All_Category: "Todas las categorías",
  ListExpenses: "Lista de gastos",
  Create_Permission: "Crear permiso",
  Edit_Permission: "Editar permiso",
  Reports_payments_Sales: "Reportes pagos Ventas",
  Reports_payments_Purchases: "Reporta pagos Compras",
  Reports_payments_Return_Customers: "Informes pagos Clientes devueltos",
  Reports_payments_Return_Suppliers: "Proveedores de vuelta de los pagos de los informes",
  stockyVersion: "No puede hacer esto en la versión de stockystración",
  Expense_Deleted: "Este gasto ha sido eliminado",
  Expense_Updated: "Este gasto se ha actualizado",
  Expense_Created: "Este gasto ha sido creado",
  Filesize: "Tamaño del archivo",
  GenerateBackup: "Generar respaldo",
  BackupDatabase: "Base de datos de respaldo",
  Backup: "Base de datos de respaldo",
  OrderStatistics: "Estadísticas de ventas",
  AlreadyAdd: "Este producto ya ha sido agregado",
  AddProductToList: "Agregue un producto a la lista",
  AddQuantity: "Agregue la cantidad",
  InvalidData: "Fecha inválida",
  LowStock: "la cantidad excede la cantidad disponible en stock",
  WarehouseIdentical: "Los almacenes no pueden ser iguales",
  VariantDuplicate: "Esta variante está duplicada",
  Paid: "Pagado",
  Unpaid: "No pagado",
  IncomeExpenses: "Ingresos y gastos",
  dailySalesPurchases: "Ventas y Compras diarias",
  ProductsExpired: "Productos caducados",
  Today: "hoy",
  Income: "Ingresos"
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", "Gastos"), "Sale", "rebaja"), "Actif", "Activo"), "Inactif", "Inactivo"), "Customers", "Clientes"), "Phone", "Teléfono"), "SearchByPhone", "Buscar por teléfono"), "Suppliers", "Proveedores"), "Quotations", "Citas"), "Sales", "Ventas"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", "Compras"), "Returns", "Devoluciones"), "Settings", "Configuraciones"), "SystemSettings", "Ajustes del sistema"), "Users", "Los usuarios"), "GroupPermissions", "Permisos de grupo"), "Currencies", "Monedas"), "Warehouses", "Almacenes"), "Units", "Unidades"), "UnitsPrchases", " Compra de unidades"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", "Ventas de unidades"), "Reports", "Informes"), "PaymentsReport", "Informe de pagos"), "PaymentsPurchases", "Compras de pagos"), "PaymentsSales", "Venta de pagos"), "PaymentsReturns", "Devolución de pagos"), "ProfitandLoss", "Ganancia y perdida"), "WarehouseStockChart", "Gráfico de acciones de almacén"), "SalesReport", "Reporte de ventas"), "PurchasesReport", "Informe de compras"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CustomersReport", "Informe de clientes"), "SuppliersReport", "Informe de proveedores"), "SupplierReport", "Informe del proveedor"), "DailySalesData", "Datos de ventas diarias"), "DailyPurchasesData", "Datos de compras diarias"), "Derni\xE8rescinqrecords", "Últimos cinco registros"), "Filters", "Filtros"), "date", "fecha"), "Reference", "Referencia"), "Supplier", "Proveedor"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PaymentStatus", "Estado de pago"), "Customer", "Cliente"), "CustomerCode", "Código de cliente"), "Status", "Estado"), "SupplierCode", "Código de proveedor"), "Categorie", "Categoría"), "Categories", "Categorias"), "StockTransfers", "Transferencias de stock"), "StockManagement", "Gestion de Stocks"), "dashboard", "Tablero"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Products", "Productos"), "productsList", "lista de productos"), "ProductManagement", "Gestion de producto"), "ProductQuantityAlerts", "Alertas de cantidad de producto"), "CodeProduct", "Código de producto"), "ProductTax", "Impuesto de producto"), "SubCategorie", "Subcategoría"), "Name_product", "Designacion"), "StockAlert", "Alerta de stock"), "warehouse", "almacén"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax", "Impuesto"), "BuyingPrice", "Precio de compra"), "SellPrice", "Precio de venta"), "Quantity", "Cantidad"), "UnitSale", "Venta de unidades"), "UnitPurchase", "Compra de unidad"), "All", "todos"), "EditProduct", "Editar producto"), "AddProduct", "Añadir Producto"), "SearchByCode", "Buscar por código"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SearchByName", "Buscar por nombre"), "ProductDetails", "Detalles de producto"), "CustomerName", "Nombre del cliente"), "CustomerManagement", "Gestión de clientes"), "Add", "Añadir"), "add", "Añadir"), "Edit", "Editar"), "Close", "Cerrar"), "PleaseSelect", "Por favor seleccione"), "Action", "Acción"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Email", "Email"), "EditCustomer", "Editar cliente"), "AddCustomer", "Agregar cliente"), "Country", "País"), "City", "Ciudad"), "Adress", "Dirección"), "CustomerDetails", "Detalles del cliente"), "CustomersList", "Lista de clientes"), "SupplierCode", "Código de proveedor"), "SupplierName", "Nombre del proveedor"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", "Gerencia de Proveedores"), "SupplierDetails", "Detalles del proveedor"), "QuotationsManagement", "Gestión de cotizaciones"), "SubTotal", "Total parcial"), "MontantReste", "Cantidad restante"), "complete", "completar"), "EnAttendant", "pendiente"), "Recu", "Recibido"), "partial", "Parcial"), "Retournee", "Regreso"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "DetailQuote", "Cotización detallada"), "EditQuote", "Editar cotización"), "CreateSale", "Crear venta"), "DownloadPdf", "Descargar PDF"), "QuoteEmail", "Presupuesto enviado por correo electrónico"), "DeleteQuote", "Eliminar cotización"), "AddQuote", "Agregar cotización"), "SelectProduct", "Seleccionar producto"), "ProductCodeName", "Producto (Código - Nombre)"), "Price", "Precio"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CurrentStock", "Stock"), "Total", "Total"), "Num", "N°"), "Unitcost", "Costo unitario"), "to", "a"), "Subject", "Sujeto"), "Message", "Mensaje"), "EmailCustomer", "Cliente de correo electrónico"), "Sent", "Enviar"), "Quote", "cotización"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Hello", "Hola"), "AttachmentQuote", "Encuentra el archivo adjunto para tu cotización"), "AddProducts", "Agregar productos a la lista de pedidos"), "SelectWarehouse", "Por favor seleccione almacén"), "SelectCustomer", "Seleccionar cliente"), "SalesManagement", "Gestión de ventas"), "Balance", "saldo"), "QtyBack", "regreso cantidad"), "TotalReturn", "Regreso total"), "Amount", "monto"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SaleDetail", "Detalle de venta"), "EditSale", "Editar venta"), "AddSale", "Añadir venta"), "ShowPayment", "Mostrar pagos"), "AddPayment", "Agregar pago"), "EditPayment", "Editar pago"), "EmailSale", "Enviar venta en correo electrónico"), "DeleteSale", "Eliminar venta"), "ModePaiement", "Modo de pago"), "Paymentchoice", "Opción de pago"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Note", "Nota"), "PaymentComplete", "¡Pago completo!"), "PurchasesManagement", "Gestión de compras"), "Ordered", "Ordenado"), "DeletePurchase", "Eliminar compra"), "EmailPurchase", "Enviar compra por correo electrónico"), "EditPurchase", "Editar compra"), "PurchaseDetail", "Detalle de compra"), "AddPurchase", "Añadir compra"), "EmailSupplier", "Correo electrónico del proveedor"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", "Compras pagos"), "PurchasesInvoicesData", "Datos de pagos de compras"), "SalesInvoice", "Pagos de ventas"), "SalesInvoicesData", "Datos de pagos de ventas"), "UserManagement", "gestión de usuarios"), "Firstname", "Primer nombre"), "lastname", "nombre de familia"), "username", "NOMBRE DE USUARIO"), "password", "CONTRASEÑA"), "Newpassword", "Nueva contraseña"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", "Cambiar avatar"), "LeaveBlank", "Deje este campo en blanco si no lo ha cambiado."), "type", "tipo"), "UserPermissions", "Permisos de usuarios"), "RoleName", "Nombre de rol"), "RoleDescription", "Descripción del rol"), "AddPermissions", "Agregar permisos"), "View", "Ver"), "Del", "Eliminar"), "NewAdjustement", "Nuevo ajuste"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditAdjustement", "Editar ajuste"), "CannotSubstraction", "No puede restar productos que tienen stock 0"), "Addition", "Adición"), "Subtraction", "Sustracción"), "profil", "perfil"), "logout", "cerrar sesión"), "PurchaseAlreadyPaid", "no puede modificar porque esta compra ya ha pagado"), "SaleAlreadyPaid", "no puede modificar porque esta venta ya pagó"), "ReturnAlreadyPaid", "no se puede modificar porque esta devolución ya ha pagado"), "QuoteAlready", "Este cotización ya ha generado ventas"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "QuotationComplete", "Esta cita completa"), "SiteConfiguration", "Configuración del sitio"), "Language", "Idioma"), "DefaultCurrency", "Moneda predeterminada"), "LoginCaptcha", "Captcha de inicio de sesión"), "DefaultEmail", "Email predeterminado"), "SiteName", "Nombre del sitio"), "ChangeLogo", "Cambiar logo"), "SMTPConfiguration", "Configuración SMTP"), "HOST", "hueste"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PORT", "PUERTO"), "encryption", "Cifrado"), "SMTPIncorrect", "Configuración SMTP incorrecta"), "ReturnsInvoices", "Devolver facturas"), "ReturnsInvoicesData", "Devolver datos de factura"), "ShowAll", "Mostrar todos los registros de todos los usuarios"), "Discount", "Descuento"), "OrderTax", "Impuesto de orden"), "Shipping", "Envío"), "ManagementCurrencies", "Monedas de gestión"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CurrencyCode", "Código de moneda"), "CurrencyName", "Nombre de moneda"), "Symbol", "Símbolo"), "CompanyName", "Nombre de empresa"), "CompanyPhone", "Teléfono de la empresa"), "CompanyAdress", "Dirección de la empresa"), "Code", "Código"), "image", "imagen"), "Printbarcode", "Imprimir código de barras"), "ReturnsCustomers", "Devuelve ventas"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", "Devoluciones de compras"), "FactureReturnCustomers", "facturas Ventas devolución"), "FactureReturnSuppliers", "facturas devoluciones compras"), "NodataAvailable", "Datos no disponibles"), "ProductImage", "Imagen del producto"), "Barcode", "Código de barras"), "pointofsales", "puntos de venta"), "CustomUpload", "Subida personalizada"), "pointofsaleManagement", "gestión punto de venta"), "Adjustment", "Ajustamiento"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", "Actualizar"), "Reset", "Reiniciar"), "print", "impresión"), "SearchByEmail", "Buscar por correo "), "ChooseProduct", "Elegir producto"), "Qty", "Cantidad"), "Items", "Artículos"), "AmountHT", "monto HT"), "AmountTTC", "monto TTC"), "PleaseSelectSupplier", "Seleccione Proveedor"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", "seleccione estado"), "PayeBy", "Pagado con"), "ChooseWarehouse", "Elija Almacén"), "payNow", "Pagar ahora"), "ListofCategory", "Lista de categoría"), "Description", "Descripción"), "submit", "guardar"), "ProblemCreatingThisInvoice", "Hubo un problema al crear esta factura. Inténtalo de nuevo"), "ProblemPayment", "Hubo un problema con el pago. Inténtalo de nuevo"), "CreateAdjustment", "Crear ajuste"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Afewwords", "unas palabras sobre ..."), "UserImage", "Imagen de usuario"), "UpdateProduct", "Actualizar producto"), "Brand", "Marca"), "BarcodeSymbology", "Simbología de códigos de barras"), "ProductCost", "Costo del producto"), "ProductPrice", "Precio del producto"), "UnitProduct", "Producto unitario"), "TaxMethod", "Método de impuestos"), "MultipleImage", "Imagen múltiple"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", "El producto tiene múltiples variantes"), "ProductHasPromotion", "El producto tiene promoción"), "PromotionStart", "Inicio de promoción"), "PromotionEnd", "Fin de la promoción"), "PromotionPrice", "Precio de promoción"), "Price", "Precio"), "Cost", "Costo"), "Unit", "Unidad"), "ProductVariant", "Variante de producto"), "Variant", "Variante"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitPrice", "Precio unitario"), "CreateReturnCustomer", "Crear devolución de cliente"), "EditReturnCustomer", "Editar devolución de cliente"), "CreateReturnSupplier", "Crear devolución de proveedor"), "Documentation", "Documentación"), "EditReturnSupplier", "Editar devolución de proveedor"), "FromWarehouse", "De almacén"), "ToWarehouse", "Al almacén"), "EditTransfer", "Editar transferencia"), "TransferDetail", "Detalle de transferencia"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Pending", "Pendiente"), "Received", "Recibido"), "Ordered", "Ordenado"), "PermissionsManager", "Administrador de permisos"), "BrandManager", "Gerente de marca"), "BrandImage", "Imagen de marca"), "BrandName", "Nombre de la marca"), "BrandDescription", "Descripción de marca"), "BaseUnit", "Unidad base"), "ManagerUnits", "Unidades gestoras"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "OperationValue", "Valor de operación"), "Operator", "Operador"), "Top5Products", "Los 5 mejores productos"), "Last5Sales", "Últimas 5 ventas"), "ListAdjustments", "Lista de ajustes"), "ListTransfers", "Lista de transferencias"), "CreateTransfer", "Crear transferencia"), "OrdersManager", "Gerente de pedidos"), "ListQuotations", "List Quotations"), "ListPurchases", "Lista de compras"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ListSales", "Lista de ventas"), "ListReturns", "Lista de devoluciones"), "PeopleManager", "Gerente de personas"), "ListofBrand", "Lista de marcas"), "Delete", {
  Title: "Estas seguro ?",
  Text: "¡No podrás revertir esto!",
  confirmButtonText: "Sí, bórralo!",
  cancelButtonText: "Cancelar",
  Deleted: "Eliminado!",
  Failed: "¡Ha fallado!",
  Therewassomethingwronge: "Algo andaba mal",
  CustomerDeleted: "Este cliente ha sido eliminado.",
  SupplierDeleted: "este proveedor ha sido eliminado.",
  QuoteDeleted: "esta cita ha sido eliminada.",
  SaleDeleted: "esta venta ha sido eliminada.",
  PaymentDeleted: "este pago ha sido eliminado.",
  PurchaseDeleted: "esta compra ha sido eliminada.",
  ReturnDeleted: "esta devolución ha sido eliminada.",
  ProductDeleted: "este producto ha sido eliminado.",
  ClientError: "Este cliente ya está vinculado con otra operación",
  ProviderError: "Este proveedor ya está vinculado con otra operación",
  UserDeleted: "Este usuario ha sido eliminado.",
  UnitDeleted: "Esta unidad ha sido eliminada.",
  RoleDeleted: "Este rol ha sido eliminado.",
  TaxeDeleted: "Este impuesto ha sido eliminado.",
  SubCatDeleted: "Esta subcategoría ha sido eliminada.",
  CatDeleted: "Esta categoría ha sido eliminada.",
  WarehouseDeleted: "Este almacén ha sido eliminado.",
  AlreadyLinked: "este producto ya está vinculado con otra Operación",
  AdjustDeleted: "Este ajuste ha sido eliminado.",
  TitleCurrency: "Esta moneda ha sido eliminada",
  TitleTransfer: "Transferir se ha eliminado correctamente",
  BackupDeleted: "La copia de seguridad se ha eliminado correctamente",
  TitleBrand: "Esta marca ha sido eliminada"
}), "Update", {
  TitleProfile: "Su perfil actualizado con éxito",
  TitleAdjust: "Ajuste actualizado con éxito",
  TitleRole: "Rol actualizado correctamente",
  TitleUnit: "Unidad actualizada con éxito",
  TitleUser: "Usuario actualizado con éxito",
  TitleCustomer: "Cliente actualizado con éxito",
  TitleQuote: "Presupuesto actualizado correctamente",
  TitleSale: "Venta actualizada con éxito",
  TitlePayment: "Pago actualizado correctamente",
  TitlePurchase: "Compra actualizada con éxito",
  TitleReturn: "Devolución actualizada con éxito",
  TitleProduct: "Producto actualizado con éxito",
  TitleSupplier: "Proveedor actualizado con éxito",
  TitleTaxe: "Impuesto actualizado con éxito",
  TitleCat: "Categoría actualizada con éxito",
  TitleWarhouse: "Almacén actualizado con éxito",
  TitleSetting: "Configuración  actualizado con éxito",
  TitleCurrency: "Esta moneda ha sido actualizada",
  TitleTransfer: "Transferir se actualizó correctamente",
  TitleBrand: "Esta marca ha sido actualizada"
}), "Create", {
  TitleBrand: "Esta marca ha sido creada",
  TitleTransfer: "Transferir se creó correctamente",
  TitleRole: "Rol creado con éxito",
  TitleUnit: "Unidad creada con éxito",
  TitleUser: "Usuario creado con éxito",
  TitleCustomer: "Cliente creado con éxito",
  TitleQuote: "Cita creada con éxito",
  TitleSale: "Venta creada con éxito",
  TitlePayment: "Pago creado con éxito",
  TitlePurchase: "Compra creada con éxito",
  TitleReturn: "retorno Creada con éxito",
  TitleProduct: "Producto creado con éxito",
  TitleSupplier: "Proveedor creado con éxito",
  TitleTaxe: "Impuesto creado con éxito",
  TitleCat: "Categoría creada con éxito",
  TitleWarhouse: "Almacén creado con éxito",
  TitleAdjust: "Ajuste creado con éxito",
  TitleCurrency: "Esta moneda ha sido creada"
}), "Send", {
  TitleEmail: "Enviar por correo electrónico con éxito"
}), "return", {
  TitleSale: "¡Esta venta ya está vinculada con una devolución!"
}), "ReturnManagement", "Gestión de retorno"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnDetail", "Detalle de retorno"), "EditReturn", "Editar retorno"), "AddReturn", "Agregar retorno"), "EmailReturn", "Enviar retorno en correo electrónico"), "DeleteReturn", "Eliminar retorno"), "Retoursurcharge", "Recargo de retorno"), "Laivrison", "entrega"), "SelectSale", "Seleccionar venta"), "ZeroPardefault", "Puede eliminar el artículo o establecer la cantidad devuelta a cero si no se devuelve"), "Return", "retorno"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchase", "Compra"), "TotalSales", "Ventas totales"), "TotalPurchases", "Compras totales"), "TotalReturns", "Devoluciones totales"), "PaiementsNet", "Pagos Netos"), "PaiementsSent", "Pagos enviados"), "PaiementsReceived", "Pagos recibidos"), "Recieved", "Recibido"), "Sent", "Expedido"), "ProductQuantityAlerts", "Alertas de cantidad de producto"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCode", "Código de producto"), "ProductName", "nombre del producto"), "AlertQuantity", "Cantidad de alerta"), "WarehouseStockChart", "Gráfico de acciones de almacén"), "TotalProducts", "Productos totales"), "TotalQuantity", "Cantidad total"), "TopCustomers", "Los 5 mejores clientes"), "TotalAmount", "monto total "), "TotalPaid", "Total pagado"), "CustomerSalesReport", "Informe de ventas del cliente"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", "Informe de pagos del cliente"), "CustomerQuotationsReport", "Informe de cotizaciones de clientes"), "Payments", "Pagos"), "TopSuppliers", "Los 5 mejores proveedores"), "SupplierPurchasesReport", "Informe de compras del proveedor"), "SupplierPaiementsReport", "Informe de pagos a proveedores"), "Name", "Nombre"), "Code", "Código"), "ManagementWarehouse", "Gestion de almacenes"), "ZipCode", "Código postal"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementCategories", "Gestión de categorías"), "Codecategorie", "Categoría de código"), "Namecategorie", "Categoría de nombre"), "Parentcategorie", "Categoría principal"), "managementTax", "Gestión fiscal"), "TaxName", "Nombre fiscal"), "TaxRate", "Tasa de impuesto"), "managementUnitPurchases", "Gestión de la Unidad de Compras"), "managementUnitSales", "Gerencia de Unidad de Ventas"), "ShortName", "Nombre corto"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", "Seleccione estos antes de agregar cualquier producto"), "StockAdjustement", "Ajuste de Stock"), "PleaseSelectWarehouse", "Seleccione almacén antes de elegir cualquier producto"), "StockTransfer", "Transferencia de acciones"), "SelectPeriod", "Seleccionar periodo"), "ThisYear", "Este año"), "ThisToday", "hoy"), "ThisMonth", "Este mes"), "ThisWeek", "Esta semana"), "AdjustmentDetail", "Detalle de ajuste"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ActivateUser", "Esta usuaria ha sido activada"), "DisActivateUser", "Esta usuaria ha sido desactivada"), "NotFound", "Página no encontrada."), "oops", "¡error! Página no encontrada."), "couldNotFind", "No pudimos encontrar la página que estaba buscando."), "ReturnDashboard", "volver al tablero"), "hrm", 'HRM'), "Employees", 'Empleados'), "Attendance", 'Asistencia'), "Leave_request", 'Dejar petición'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Tipo de licencia'), "Company", 'Compañía'), "Departments", 'Departamentos'), "Designations", 'Designaciones'), "Office_Shift", 'Turno de oficina'), "Holidays", 'Días festivos'), "Enter_Company_Name", 'Introduzca el nombre de la empresa'), "Enter_email_address", 'Introduzca la dirección de correo electrónico'), "Enter_Company_Phone", 'Introduce el teléfono de la empresa'), "Enter_Company_Country", 'Introduzca el país de la empresa'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Creado en con éxito'), "Updated_in_successfully", 'Actualizado en con éxito'), "Deleted_in_successfully", 'Eliminado en con éxito'), "department", 'Departamento'), "Enter_Department_Name", 'Ingrese el nombre del departamento'), "Choose_Company", 'Elija empresa'), "Department_Head", 'Jefe de departamento'), "Choose_Department_Head", 'Elegir jefe de departamento'), "Enter_Shift_name", 'Ingrese el nombre del turno'), "Monday_In", 'Monday In'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'Fiesta'), "Enter_title", 'Introduce el título'), "title", 'título'), "start_date", 'Fecha de inicio'), "Enter_Start_date", 'Introduce la fecha de inicio'), "Finish_Date", 'Fecha de finalización'), "Enter_Finish_date", 'Introduzca la fecha de finalización'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Proporcione cualquier detalle'), "Attendances", 'asistencias'), "Enter_Attendance_date", 'Ingrese la fecha de asistencia'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", 'Elegir empleado'), "Employee", 'Empleado'), "Work_Duration", 'Duración del trabajo'), "remaining_leaves_are_insufficient", 'Las hojas restantes son insuficientes'), "Leave_Type", 'Tipo de licencia'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Days", 'Días'), "Department", 'Departamento'), "Choose_leave_type", 'Elija el tipo de licencia'), "Choose_status", 'elegir estado'), "Leave_Reason", 'Razón de dejar'), "Enter_Reason_Leave", 'Ingrese el motivo de la licencia'), "Add_Employee", 'Agregar empleado'), "FirstName", 'Primer nombre'), "Enter_FirstName", 'Ingrese el nombre'), "LastName", 'Apellido'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Introduzca el apellido'), "Gender", 'Género'), "Choose_Gender", 'Elija género'), "Enter_Birth_date", 'Ingrese la fecha de nacimiento'), "Birth_date", 'Fecha de nacimiento'), "Enter_Country", 'Introducir país'), "Enter_Phone_Number", 'Ingresa número telefónico'), "joining_date", 'Dia de ingreso'), "Enter_joining_date", 'Introduce la fecha de incorporación'), "Choose_Designation", 'Elija Designación'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Designation", 'Designacion'), "Office_Shift", 'Turno de oficina'), "Choose_Office_Shift", 'Elija turno de oficina'), "Enter_Leaving_Date", 'Ingrese la fecha de salida'), "Leaving_Date", 'Fecha de salida'), "Annual_Leave", 'Vacaciones anuales'), "Enter_Annual_Leave", 'Ingresar vacaciones anuales'), "Remaining_leave", 'Licencia restante'), "Employee_Details", 'Detalles del empleado'), "Basic_Information", 'Información básica'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Family_status", 'Estado familiar'), "Choose_Family_status", 'Elija el estado de la familia'), "Employment_type", 'Tipo de empleo'), "Select_Employment_type", 'Seleccionar tipo de empleo'), "Enter_City", 'Ingresar ciudad'), "Province", 'Provincia'), "Enter_Province", 'Entrar Provincia'), "Enter_Address", 'Ingresa la direccion'), "Enter_Zip_code", 'Ingresa tu código postal'), "Zip_code", 'Código postal'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Tarifa por hora'), "Enter_Hourly_rate", 'Ingrese la tarifa por hora'), "Basic_salary", 'Salario base'), "Enter_Basic_salary", 'Ingrese salario base'), "Social_Media", 'Medios de comunicación social'), "Skype", 'Skype'), "Enter_Skype", 'Ingresa a Skype'), "Facebook", 'Facebook'), "Enter_Facebook", 'Ingresa a Facebook'), "WhatsApp", 'WhatsApp'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Ingresa a WhatsApp'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", 'Ingresa a LinkedIn'), "Twitter", 'Twitter'), "Enter_Twitter", 'Ingresa a Twitter'), "Experiences", 'Experiencias'), "bank_account", 'cuenta bancaria'), "Company_Name", 'nombre de empresa'), "Location", 'Ubicación'), "Enter_location", 'Introduce la ubicación'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Ingrese la descripción'), "Bank_Name", 'Nombre del banco'), "Enter_Bank_Name", 'Ingrese el nombre del banco'), "Bank_Branch", 'Sucursal bancaria'), "Enter_Bank_Branch", 'Ingresar Sucursal Bancaria'), "Bank_Number", 'Número de banco'), "Enter_Bank_Number", 'Ingrese el número de banco'), "Assigned_warehouses", 'Almacenes asignados'), "Top_customers", 'mejores clientes'), "Attachment", 'Adjunto archivo'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "view_employee", 'ver empleados'), "edit_employee", 'editar empleados'), "delete_employee", 'eliminar empleados'), "Created_by", 'Añadido por'), "Add_product_IMEI_Serial_number", 'Añadir producto IMEI/número de serie'), "Product_Has_Imei_Serial_number", 'El producto tiene Imei/Número de serie'), "IMEI_SN", 'IMEI/SN'), "Shipments", 'Envíos'), "delivered_to", 'Entregado a'), "shipment_ref", 'Referencia de envío'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Referencia de venta'), "Edit_Shipping", 'Editar envío'), "Packed", 'Lleno'), "Shipped", 'Enviado'), "Delivered", 'Entregado'), "Cancelled", 'Cancelado'), "Shipping_status", 'Estado del envío'), "Users_Report", 'Informe de usuarios'), "stock_report", 'Informe de existencias'), "TotalPurchases", 'Compras totales'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Cotizaciones totales'), "Total_return_sales", 'Ventas de devolución total'), "Total_return_purchases", 'Compras de devolución total'), "Total_transfers", 'Transferencias totales'), "Total_adjustments", 'Ajustes totales'), "User_report", 'Informe de usuario'), "Current_stock", 'Stock actual'), "product_name", 'nombre del producto'), "Total_Customers_Due", 'Deuda total'), "Total_Suppliers_Due", 'Deuda total'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'algunos almacenes'), "All_Warehouses", 'Todos los Almacenes'), "Product_Cost", 'Costo del producto'), "sms_settings", 'Configuraciones de SMS'), "pos_settings", 'Ajustes de POS'), "payment_gateway", 'Pasarela de pago'), "mail_settings", 'Configuración de correo'), "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'Puerta de enlace de SMS predeterminada'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "module_settings", 'Configuración del módulo'), "Module_enabled_success", 'Módulo habilitado con éxito'), "Module_Disabled_success", 'Módulo deshabilitado con éxito'), "update_settings", 'Ajustes de actualización'), "Please_Upload_the_Correct_Module", 'Por favor, suba el módulo correcto'), "Uploaded_Success", 'Cargado correctamente'), "Customer_details", 'Detalles del cliente'), "Edit_Customer", 'Editar cliente'), "Delete_Customer", 'Eliminar cliente'), "Pay_Due", 'Pagar adeudado'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'El monto a pagar es mayor que el total adeudado'), "Customer_Invoice", 'Factura del cliente'), "This_Product_Not_For_Selling", 'Este producto no para la venta'), "Welcome_to_your_Dashboard", 'Bienvenido a tu Tablero'), "Total_Payable", 'Total por Pagar'), "Choose_Sale_Ref", 'Elija Ref. de venta'), "Please_Select_Sale", 'Seleccione Venta'), "Sale_Ref", 'Referencia de venta'), "list_product_returns", 'enumerar las devoluciones de productos'), "Qty_return", 'devolución de cantidad'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Elija la referencia de compra'), "Purchase_Ref", 'Referencia de compra'), "please_select_purchase", 'Por favor seleccione Compra'), "qty_return_is_greater_than_qty_purchased", 'La cantidad devuelta es mayor que la cantidad comprada'), "qty_return_is_greater_than_qty_sold", 'La cantidad devuelta es mayor que la cantidad vendida'), "Quantity_sold", 'Cantidad vendida'), "qty_purchased", 'Cant. comprada'), "Sender_Name", 'Nombre del remitente'), "The_module_must_be_uploaded_as_zip_file", 'El módulo debe cargarse como archivo zip'), "Upload_Module", 'Subir módulo'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'Todos los módulos instalados'), "Current_Version", 'Versión actual'), "You_already_have_the_latest_version", 'Ya tienes la última versión'), "Update_Available", 'Actualización disponible'), "Update_Log", 'Registro de actualización'), "Update_Now", 'Actualizar ahora'), "View_Change_Log", 'Ver registro de cambios'), "invoice_footer", 'Pie de página de la factura'), "Please_Wait_for_the_update", 'NOTA: Espere a que la actualización finalice por completo. No se recomienda cerrar el navegador o detener un proceso Actualizar'), "Note_update", 'Nota: asegúrese de hacer una copia de seguridad de su versión y base de datos actuales antes de ejecutar la actualización, para restaurarla si hay un error'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Zona horaria'), "Payment_note", 'Nota de pago'), "sale_note", 'notas de venta'), "Total_Sale_Due", 'Deuda total de venta'), "Total_Sell_Return_Due", 'Deuda total de devolución de venta'), "pay_all_sell_due_at_a_time", 'pagar todas las deudas de venta a la vez'), "pay_all_sell_return_due_at_a_time", 'pagar toda la deuda de devolución de venta a la vez'), "Gross_Profit", 'Beneficio bruto'), "pay_all_purchase_due_at_a_time", 'pagar toda la deuda de compra a la vez'), "Delete_Provider", 'Eliminar proveedor'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Editar proveedor'), "Provider_details", 'Detalles del proveedor'), "Total_Purchase_Due", 'Deuda total de compra'), "Provider_Credit_Note", 'Nota de crédito'), "Customer_Credit_Note", 'Nota de crédito'), "Sell_Return", 'Vender Retorno'), "Purchase_Return", 'Devolución de compra'), "Tax_Number", 'Número de impuesto'), "Please_add_return_quantity", 'Por favor agregue la cantidad de devolución'), "Return_exist_for_the_Transaction", 'Existe devolución para la Transacción'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'La devolución de cantidad es mayor que la cantidad restante'), "products_refunded_alert", 'Cualquier producto con una cantidad establecida en 0 no será reembolsado'), "pay_all_purchase_return_due_at_a_time", 'pagar todas las devoluciones de compra adeudadas a la vez'), "Total_Purchase_Return_Due", 'Deuda total de devolución de compra'), "Purchase_return_due", 'Deuda de devolución de compra'), "Sell_return_due", 'deuda de devolución de venta'), "product_report", 'informe de producto'), "product_sales_report", 'informe de ventas de productos'), "Product_purchases_report", 'informe de compras de productos'), "Qty_sold", 'Cantidad vendida'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'cantidad comprada'), "Filter_by_warehouse", 'Filtrar por almacén'), "Enable_Print_Invoice", 'Imprimir factura automáticamente'), "Show_Warehouse", 'ver almacén'), "credit_card_info", 'Información de tarjeta de crédito'), "Saved_Credit_Card_Info", 'Información de tarjeta de crédito guardada'), "Credit_card_changed_successfully", 'Tarjeta de crédito cambiada exitosamente'), "notification_template", 'Plantilla de notificación'), "email_notification", 'Notificación por correo electrónico'), "sms_notification", 'Notificación por SMS'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Cambiar detalles del producto'), "edit_tax_and_discount_and_shipping", 'Editar impuestos, descuentos y envío'), "Create_Quotation_with_Stock", 'Crear cotización con stock'), "Variant_Name", 'Nombre de variante'), "Variant_cost", 'Costo de variante'), "Variant_price", 'Precio de variante'), "Variant_code", 'Código de variante'), "Please_wait_until_the_product_is_loaded", 'Por favor, espere hasta que el producto se cargue'), "Choose_SMS_Gateway", 'Elegir gateway de SMS'), "Notification_Client", 'Notificación al cliente'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Etiquetas disponibles'), "Email_Subject", 'Asunto del correo electrónico'), "Email_body", 'Contenido del correo electrónico'), "Notification_Supplier", 'Notificación al proveedor'), "sms_body", 'Contenido del SMS'), "sms_templates", 'Plantillas SMS'), "email_templates", 'Plantillas de correo electrónico'));

/***/ }),

/***/ "./resources/src/translations/locales/fr.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/fr.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Delete, _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Français

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Reçu',
  Pos_Settings: 'Paramètres du point de vente (Reçu)',
  Note_to_customer: 'Remarque au client',
  Show_Note_to_customer: 'Afficher la Remarque au client',
  Show_barcode: 'Afficher le code barre',
  Show_Tax_and_Discount: 'Afficher les taxes, les remises et les frais d\'expédition',
  Show_Customer: 'Afficher le client',
  Show_Email: 'Afficher l\'e-mail',
  Show_Phone: 'Afficher le téléphone',
  Show_Address: 'Afficher l\'adresse',
  DefaultLanguage: 'Langage par défaut',
  footer: 'bas de page',
  Received_Amount: 'Montant reçu',
  Paying_Amount: 'Montant à payer',
  Change: 'changement',
  Paying_amount_is_greater_than_Received_amount: 'Le montant à payer est supérieur au montant reçu',
  Paying_amount_is_greater_than_Grand_Total: 'Le montant à payer est supérieur au montant total',
  code_must_be_not_exist_already: 'le code ne doit pas déjà exister',
  You_will_find_your_backup_on: 'Vous trouverez votre sauvegarde sur',
  and_save_it_to_your_pc: 'et enregistrez-le sur votre pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Scannez votre code-barres et sélectionnez la symbologie correcte ci-dessous',
  Scan_Search_Product_by_Code_Name: 'Scannez/recherchez un produit par nom ou code',
  Paper_size: 'Taille de papier',
  Clear_Cache: 'Vider le cache',
  Cache_cleared_successfully: 'Cache vidé avec succès',
  Failed_to_clear_cache: 'Échec de vider du cache',
  Scan_Barcode: 'Scanner de code-barres',
  Please_use_short_name_of_unit: 'Veuillez utiliser le nom abrégé de l\'unité',
  DefaultCustomer: 'Client par défaut',
  DefaultWarehouse: 'Entrepôt par défaut',
  Payment_Gateway: 'Passerelle de paiement',
  SMS_Configuration: 'Configuration SMS',
  Gateway: 'Passerelle de paiement',
  Choose_Gateway: 'Choisissez la passerelle de paiement',
  Send_SMS: 'message envoyé avec succès',
  sms_config_invalid: 'configuration sms invalide',
  Remove_Stripe_Key_Secret: 'Supprimer les clés d\'API Stripe',
  credit_card_account_not_available: 'Compte de carte de crédit non disponible',
  Credit_Card_Info: 'Informations sur la carte de crédit',
  developed_by: 'Développé par',
  Unit_already_linked_with_sub_unit: 'Unité déjà liée à la sous-unité',
  Total_Items_Quantity: 'Total des articles et quantité',
  Value_by_Cost_and_Price: 'Valeur par coût et prix',
  Search_this_table: 'Rechercher dans ce tableau',
  import_products: 'Importer des produits',
  Field_optional: 'Champ facultatif',
  Download_exemple: 'Télécharger l\'exemple',
  field_must_be_in_csv_format: 'Le champ doit être au format csv',
  Successfully_Imported: 'Importé avec succès',
  file_size_must_be_less_than_1_mega: 'La taille du fichier doit être inférieure à 1 méga',
  Please_follow_the_import_instructions: 'Veuillez suivre les instructions d\'importation',
  must_be_exist: 'l\'unité doit déjà être créée',
  Import_Customers: 'Importer des clients',
  Import_Suppliers: 'Importer des fournisseurs',
  Recent_Sales: 'Ventes récentes',
  Create_Transfer: 'Créer un transfert',
  order_products: 'Products commandés',
  Search_Product_by_Code_Name: 'Rechercher un produit par code ou par nom',
  Reports_payments_Purchase_Return: 'Rapports sur les paiements de retour d\'achat',
  Reports_payments_Sale_Return: 'Rapports sur les paiements de retour de vente',
  payments_Sales_Return: 'Paiements retour de vente',
  payments_Purchases_Return: 'Paiements retour d\'achats',
  CreateSaleReturn: 'Créer un retour de vente',
  EditSaleReturn: 'Modifier le retour de vente',
  SalesReturn: 'Retour des ventes',
  CreatePurchaseReturn: 'Créer un retour d\'achat',
  EditPurchaseReturn: 'Modifier le retour d\'achat',
  PurchasesReturn: 'Retour des achats',
  Due: 'Dû',
  Profit: 'Profit',
  Revenue: 'Revenu',
  Sales_today: 'Ventes aujourd\'hui',
  People: 'Gens',
  Successfully_Created: 'Créé avec succès',
  Successfully_Updated: 'Mise à jour réussie',
  Success: 'Succès',
  Failed: 'Échec',
  Warning: 'Alert',
  Error: 'Erreur!',
  you_are_not_authorized: 'Pardon! vous n\'êtes pas autorisé.',
  Go_back_to_home: 'Retournez à la page d\'accueil',
  page_not_exist: 'Pardon! La page que vous recherchez n\'existe pas.',
  Please_fill_the_form_correctly: 'Veuillez remplir le formulaire correctement',
  Field_is_required: 'Champ requis',
  Choose_Status: 'Choisissez le statut',
  Choose_Method: 'Choisissez la méthode',
  Choose_Symbology: 'Choisissez la symbologie',
  Choose_Category: 'Choisissez la catégorie',
  Choose_Customer: 'Choisissez le client',
  Choose_Supplier: 'Choisissez un fournisseur',
  Choose_Unit_Purchase: 'Choisissez l\'unité d\'achat',
  Choose_Sub_Category: 'Choisissez la sous-catégorie',
  Choose_Brand: 'Choisissez la marque',
  Choose_Warehouse: 'Choisissez l\'entrepôt',
  Choose_Unit_Sale: 'Choisissez l\'unité de vente',
  Enter_Product_Cost: 'Entrez le prix d\'achat',
  Enter_Stock_alert: 'Entrer l\'alerte de stock',
  Choose_Unit_Product: 'Choisissez l\'unité de produit',
  Enter_Product_Price: 'Entrez le prix de vente',
  Enter_Name_Product: 'Entrez le nom du produit',
  Enter_Role_Name: 'Entrez le nom du rôle',
  Enter_Role_Description: 'Entrez la description du rôle',
  Enter_name_category: 'Entrez le nom de la catégorie',
  Enter_Code_category: 'Entrez le code de la catégorie',
  Enter_Name_Brand: 'Entrez le nom de la marque',
  Enter_Description_Brand: 'Entrez la description de la marque',
  Enter_Code_Currency: 'Entrez le code de devise',
  Enter_name_Currency: 'Entrez le nom Devise',
  Enter_Symbol_Currency: 'Entrez le symbole de la devise',
  Enter_Name_Unit: 'Entrez le nom de l`\'unité',
  Enter_ShortName_Unit: 'Entrez le nom abrégé de l\'unité',
  Choose_Base_Unit: 'Choisissez l\'unité de base',
  Choose_Operator: 'Choisissez un opérateur',
  Enter_Operation_Value: 'Entrez la valeur de l\'opération',
  Enter_Name_Warehouse: 'Entrez le nom de l\'entrepôt',
  Enter_Phone_Warehouse: 'Entrez le téléphone de l\'entrepôt',
  Enter_Country_Warehouse: 'Entrez le pays de l\'entrepôt',
  Enter_City_Warehouse: 'Entrez la ville de l\'entrepôt',
  Enter_Email_Warehouse: 'Entrez  e-mail de l\'entrepôt',
  Enter_ZipCode_Warehouse: 'Entrez le code postal de l\'entrepôt',
  Choose_Currency: 'Choisir la devise',
  Thank_you_for_your_business: 'Merci de votre confiance!',
  Cancel: 'Annuler',
  New_Customer: 'Nouveau client',
  Incorrect_Login: 'Login incorrect',
  Successfully_Logged_In: 'Connexion réussie',
  This_user_not_active: 'Cet utilisateur n\'est pas actif',
  SignIn: 'S\'identifier',
  Create_an_account: 'Créer un compte',
  Forgot_Password: 'Mot de passe oublié ?',
  Email_Address: 'Adresse e-mail',
  SignUp: 'S\'inscrire',
  Already_have_an_account: 'Vous avez déjà un compte ?',
  Reset_Password: 'réinitialiser le mot de passe',
  Failed_to_authenticate_on_SMTP_server: 'Échec de l\'authentification sur le serveur SMTP',
  We_cant_find_a_user_with_that_email_addres: 'Nous ne pouvons pas trouver un utilisateur avec cette adresse e-mail',
  We_have_emailed_your_password_reset_link: 'Nous avons envoyé votre lien de réinitialisation de mot de passe par e-mail',
  Please_fill_the_Email_Adress: 'Veuillez remplir l\'adresse e-mail',
  Confirm_password: 'Confirmez le mot de passe',
  Your_Password_has_been_changed: 'Votre mot de passe a été changé',
  The_password_confirmation_does_not_match: 'La confirmation du mot de passe ne correspond pas',
  This_password_reset_token_is_invalid: 'Ce jeton de réinitialisation de mot de passe n\'est pas valide',
  Warehouse_report: 'Rapport d\'entrepôt',
  All_Warehouses: 'Tous les entrepôts',
  Expense_List: 'Liste de dépenses',
  Expenses: 'dépenses',
  This_Week_Sales_Purchases: 'Ventes et achats de cette semaine',
  Top_Selling_Products: 'Produits les plus vendus',
  View_all: 'Voir tout',
  Payment_Sent_Received: 'Paiement envoyé et reçu',
  Filter: 'Filtre',
  Invoice_POS: 'Facture POS',
  Invoice: 'Facture',
  Customer_Info: 'Infos client',
  Company_Info: 'Infos société',
  Invoice_Info: 'Infos facture',
  Order_Summary: 'Résumé de la commande',
  Quote_Info: 'Devis Infos',
  Del: 'Effacer',
  SuppliersPaiementsReport: 'Fournisseurs Rapport Paiements',
  Purchase_Info: 'Infos d\'achat',
  Supplier_Info: 'Info fournisseur',
  Return_Info: 'Info de retour',
  Expense_Category: 'Catégorie de dépenses',
  Create_Expense: 'Créer une dépense',
  Details: 'Détails',
  Discount_Method: 'Méthode de remise',
  Net_Unit_Cost: 'Coût unitaire net',
  Net_Unit_Price: 'Prix unitaire net',
  Edit_Expense: 'Modifier les dépenses',
  All_Brand: 'Toute marque',
  All_Category: 'All Category',
  ListExpenses: 'Liste des dépenses',
  Create_Permission: 'Créer une autorisation',
  Edit_Permission: 'Modifier l\'autorisation',
  Reports_payments_Sales: 'Rapports des paiements des ventes',
  Reports_payments_Purchases: 'Rapports des achats de paiements',
  Reports_payments_Return_Customers: 'Rapports de paiements Clients de retour',
  Reports_payments_Return_Suppliers: 'Rapports des paiements Retour Fournisseurs',
  Expense_Deleted: 'Cette dépense a été supprimée',
  Expense_Updated: 'Cette dépense a été mise à jour',
  Expense_Created: 'Cette dépense a été créée',
  DemoVersion: 'Vous ne pouvez pas faire cela dans la version de démonstration',
  OrderStatistics: 'Statistiques de ventes',
  AlreadyAdd: 'Ce produit est déjà ajouté !!',
  AddProductToList: 'Veuillez ajouter le produit à la liste !!',
  AddQuantity: 'Veuillez ajouter la quantité de produit !!',
  InvalidData: 'Données invalides !!',
  LowStock: 'la quantité dépasse la quantité disponible en stock',
  WarehouseIdentical: 'Les deux magasins ne peuvent pas être identiques !!',
  VariantDuplicate: 'Cette variable est redondante !!',
  Filesize: 'Taille du fichier',
  GenerateBackup: 'Générer une sauvegarde',
  BackupDatabase: 'Sauvegarde de la base de données',
  Backup: 'Sauvegarde DB',
  Paid: 'Payé',
  Unpaid: 'Non payé',
  IncomeExpenses: 'Revenus et dépenses',
  dailySalesPurchases: 'Ventes et achats quotidiens',
  ProductsExpired: 'Produits expirés',
  Today: 'Aujourd\'hui',
  Income: 'Revenu'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'Dépenses'), "Sale", 'Vente'), "Phone", 'Télé'), "SearchByPhone", 'Filter par Télé'), "Actif", 'Active'), "Inactif", 'Inactive'), "CustomerName", 'Nom Client'), "StockManagement", 'Gestion Du Stock'), "dashboard", 'Tableau de bord'), "Products", 'Produits'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'Liste de produits'), "StockTransfers", 'Stock Transfers'), "Customers", 'Clients'), "Suppliers", 'Fournisseurs'), "Quotations", 'Devis'), "Sales", 'Ventes'), "Purchases", 'Achats'), "Returns", 'Returns'), "Settings", 'Paramètres'), "SystemSettings", 'Paramètres du système'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users", 'Utilisateurs'), "GroupPermissions", 'Autorisations de groupe'), "Currencies", 'Devises'), "ProductTax", 'Produits Taxe'), "Categories", 'Categories'), "Warehouses", 'Entrepôt'), "Units", 'Unités'), "UnitsPrchases", 'Unités Achats'), "UnitsSales", 'Unités Ventes'), "Reports", 'Rapports'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PaymentsReport", 'Paiements Rapports'), "PaymentsPurchases", 'Paiements Achats'), "PaymentsSales", 'Paiements Ventes'), "PaymentsReturns", 'Paiements Retours'), "ReturnsInvoices", 'Factures des retours'), "ReturnsInvoicesData", 'données des Factures de retours'), "ShowAll", 'Afficher tous les enregistrements de tous les utilisateurs'), "Discount", 'Remise'), "OrderTax", 'Taxe de commande'), "Shipping", 'livraison'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProfitandLoss", 'Profit et perte'), "ProductQuantityAlerts", 'Alertes de quantité'), "WarehouseStockChart", 'Warehouse Stock Chart'), "SalesReport", 'Ventes Rapports'), "PurchasesReport", 'Achats Rapports'), "CustomersReport", 'Clients Rapports'), "SuppliersReport", 'Fournisseurs Rapports'), "SupplierReport", 'Fournisseur Rapports'), "DailySalesData", 'Ventes quotidiens'), "DailyPurchasesData", 'Achats quotidiens'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Derni\xE8rescinqrecords", 'Dernières cinq records'), "Filters", 'Filtres'), "date", 'Date'), "Reference", 'Référence'), "Supplier", 'Fournisseur'), "PaymentStatus", 'Statut de Paiement'), "Customer", 'Client'), "CustomerCode", 'Client Code'), "Status", 'Statut'), "SupplierCode", 'Fournisseur Code'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductManagement", 'Gestion des Produits'), "CodeProduct", 'Code Produit'), "Categorie", 'Catégorie'), "SubCategorie", 'Sous-catégorie'), "Name_product", 'Désignation'), "StockAlert", 'Stock Alert'), "warehouse", 'Magasin'), "Tax", 'Taxe'), "BuyingPrice", 'Prix d\'achat'), "SellPrice", 'Prix de vente'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Quantity", 'Quantité'), "Action", 'Action'), "UnitSale", 'Unités de Vente'), "UnitPurchase", 'Unités d\'achat'), "ProductDetails", 'Détails Produit'), "All", 'Tous'), "EditProduct", 'Modifier Produit'), "AddProduct", 'Ajouter Produit'), "SearchByCode", 'Filter par Code'), "SearchByName", 'Filter par Nom'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Add", 'Ajouter'), "add", 'Ajouter'), "Edit", 'Modifier'), "Close", 'Fermer'), "PleaseSelect", 'Veuillez sélectionner'), "CustomerManagement", 'Gestion Du Clients'), "Email", 'Email'), "EditCustomer", 'Modifier Client'), "AddCustomer", 'Ajouter Client'), "Country", 'Pays'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "City", 'Ville'), "Adress", 'Adresse'), "CustomerDetails", 'Détails Client'), "CustomersList", 'Liste Des Clients'), "SupplierCode", 'Code Fournisseur'), "SupplierName", 'Nom Fournisseur'), "SuppliersManagement", 'Gestion des Fournisseurs'), "SupplierDetails", 'Détails Fournisseur'), "QuotationsManagement", 'Gestion des Devis'), "SubTotal", 'Grand Total'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "complete", 'completé'), "EnAttendant", 'En attente'), "Recu", 'Recu'), "partial", 'partial'), "Retournee", 'Retournée'), "DetailQuote", 'Détail Devis'), "EditQuote", 'Modifier Devis'), "CreateSale", 'Créer une vente'), "DownloadPdf", 'Télécharger le PDF'), "QuoteEmail", 'Envoyé Devis sur Email'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "DeleteQuote", 'Supprimé Devis'), "AddQuote", 'Ajouter Devis'), "SelectProduct", 'Sélectionnez un produit'), "ProductCodeName", 'Produit (Code - Nom)'), "Price", 'Prix'), "CurrentStock", 'Stock'), "Total", 'Total'), "Num", 'N°'), "Unitcost", 'Cout unitaire'), "to", 'à'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Subject", 'Sujet'), "Message", 'Message'), "EmailCustomer", 'Email Client'), "Sent", 'Envoyer'), "Quote", 'Devis'), "Hello", 'Bonjour'), "AttachmentQuote", 'Veuillez trouver la pièce jointe pour votre devis'), "AddProducts", 'Ajouter les Produits sur la liste des commandes'), "SelectWarehouse", 'Sélectionner un entrepôt'), "SelectCustomer", 'Sélectionner un client'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SalesManagement", 'Gestion  Des Ventes'), "Balance", 'Balance'), "QtyBack", 'Qté Retour'), "TotalReturn", 'Total Retour'), "MontantReste", 'Montant reste'), "SaleDetail", 'Détail de la vente'), "EditSale", 'Modifier la vente'), "AddSale", 'Ajouter Vente'), "ShowPayment", 'Afficher les paiements'), "AddPayment", 'Ajouter un paiement'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditPayment", 'Modifier le paiement'), "EmailSale", 'Envoyer la vente par e-mail'), "DeleteSale", 'Supprimer la vente'), "Amount", 'Montant'), "ModePaiement", 'Mode de paiement'), "Paymentchoice", 'Mode de règlement'), "Note", 'Remarque'), "PaymentComplete", 'Paiement compléte!'), "UserManagement", 'Gestion des utilisateurs'), "Firstname", 'Prénom'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "lastname", 'Nom'), "username", 'utilisateur'), "type", 'Type'), "password", 'Mot de Pass'), "Newpassword", 'Nouveau Mot Pass'), "ChangeAvatar", 'Changer d\'avatar'), "LeaveBlank", 'Veuillez laisser ce champ vide si vous ne l\'avez pas changé'), "UserPermissions", 'Permissions des utilisateurs'), "RoleName", 'Nom Role'), "RoleDescription", 'Discription Role'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPermissions", 'Ajouter des autorisations'), "View", 'Afficher'), "Del", 'Supprimer'), "NewAdjustement", 'Nouvel Ajustement'), "EditAdjustement", 'Modifier Ajustement'), "CannotSubstraction", 'Vous ne pouvez pas soustraire des produits en stock 0'), "Addition", 'Addition'), "Subtraction", 'Soustraction'), "profil", 'Profil'), "logout", 'Se déconnecter'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PurchaseAlreadyPaid", 'Vous ne pouvez pas modifier car cette Achat a déjà payé'), "SaleAlreadyPaid", 'Vous ne pouvez pas modifier car cette Vente a déjà payé'), "ReturnAlreadyPaid", 'Vous ne pouvez pas modifier car cette Retour a déjà payé'), "QuoteAlready", 'Ce devis a déjà généré une vente'), "QuotationComplete", 'Cette Devis terminée'), "SiteConfiguration", 'Configuration du site'), "Language", 'Langue'), "DefaultCurrency", 'Devise par défaut'), "LoginCaptcha", 'Captcha'), "DefaultEmail", 'Email par défaut'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SiteName", 'Nom du site'), "ChangeLogo", 'Changer le logo'), "SMTPConfiguration", 'Configuration SMTP'), "HOST", 'HÔTE'), "PORT", 'PORT'), "encryption", 'Chiffrement'), "SMTPIncorrect", 'Configuration SMTP incorrecte'), "ManagementCurrencies", 'Gestion de devises'), "CurrencyCode", 'Code de devise'), "CurrencyName", 'Nom de devise'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Symbol", 'Symbole'), "CompanyName", 'Nom de la société'), "CompanyPhone", 'Tele de la société'), "CompanyAdress", 'Adresse de la société'), "Code", 'Code'), "image", 'Image'), "Printbarcode", 'Imprimer le code-barres'), "ReturnsCustomers", 'Retours de ventes'), "ReturnsSuppliers", 'Retours d\'achats'), "FactureReturnCustomers", 'Facture Return Clients'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FactureReturnSuppliers", 'Facture Return Suppliers'), "NodataAvailable", 'Pas de données disponibles'), "ProductImage", 'Image du produit'), "Barcode", 'Code-barre'), "pointofsales", 'Point de vente'), "CustomUpload", 'Téléchargement personnalisé'), "pointofsaleManagement", 'Gestion des points de vente'), "Adjustment", 'Ajustement'), "Updat", 'Mettre à jour'), "Reset", 'Réinitialiser'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "print", 'Impression'), "SearchByEmail", 'Recherche par e-mail'), "ChooseProduct", 'Choisissez un produit'), "Qty", 'Qté'), "Items", 'Articles'), "AmountHT", 'Montant HT'), "AmountTTC", 'Montant TTC'), "PleaseSelectSupplier", 'Veuillez sélectionner un fournisseur'), "PleaseSelectStatut", 'Veuillez sélectionner le statut'), "PayeBy", 'Payé avec'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChooseWarehouse", 'Choisissez l\'entrepôt'), "payNow", 'Payez maintenant'), "ListofCategory", 'Liste de la catégorie'), "Description", 'Description'), "submit", 'Soumettre'), "ProblemCreatingThisInvoice", 'Un problème est survenu lors de la création de cette facture. Veuillez réessayer'), "ProblemPayment", 'Il y a eu un problème de paiement. Veuillez réessayer.'), "CreateAdjustment", 'Créer un ajustement'), "Afewwords", 'Quelques mots sur ...'), "UserImage", 'Image utilisateur'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UpdateProduct", 'Mettre à jour le produit'), "Brand", 'Marque'), "BarcodeSymbology", 'Symbologie des codes à barres'), "ProductCost", 'Prix d\'achat'), "ProductPrice", 'Prix de vente'), "UnitProduct", 'Unité du Produit'), "TaxMethod", 'Méthode fiscale'), "MultipleImage", 'Image multiple'), "ProductHasMultiVariants", 'Le produit a plusieurs variantes'), "ProductHasPromotion", 'Le produit a une promotion'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PromotionStart", 'Début de la promotion'), "PromotionEnd", 'Fin de la promotion'), "PromotionPrice", 'Prix de la promotion'), "Price", 'Prix'), "Cost", 'Coût'), "Unit", 'Unité'), "ProductVariant", 'Variante de produit'), "Variant", 'Variante'), "UnitPrice", 'Prix unitaire'), "CreateReturnCustomer", 'Créer un retour client'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditReturnCustomer", 'Modifier le retour client'), "CreateReturnSupplier", 'Créer le retour fournisseur'), "Documentation", 'Doc'), "EditReturnSupplier", 'Modifier le retour fournisseur'), "FromWarehouse", 'De l\'entrepôt'), "ToWarehouse", 'vers l\'entrepôt'), "EditTransfer", 'Modifier le transfert'), "TransferDetail", 'Détail du transfert'), "Pending", 'En attente'), "Received", 'Reçu'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Ordered", 'Commandé'), "PermissionsManager", 'Gestion des autorisations'), "BrandManager", 'Gestion de la marque'), "BrandImage", 'Image de marque'), "BrandName", 'Nom de marque'), "BrandDescription", 'Description de la marque'), "BaseUnit", 'Unité de base'), "ManagerUnits", 'Gestion des Unités'), "OperationValue", 'Valeur d\'opération'), "Operator", 'Opération'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Top5Products", 'Top 5 des produits'), "Last5Sales", '5 dernières ventes'), "ListAdjustments", 'liste des Ajustements'), "ListTransfers", 'Liste des transferts'), "CreateTransfer", 'Créer un transfert'), "OrdersManager", 'Gestion des commandes'), "ListQuotations", 'Liste des quotes'), "ListPurchases", 'Liste des achats'), "ListSales", 'Liste des ventes'), "ListReturns", 'Liste des retours'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PeopleManager", 'Gestion des personnes'), "ListofBrand", 'Liste des marques'), "Delete", (_Delete = {
  Title: 'Êtes-vous sûr?',
  Text: 'Vous ne pourrez pas revenir en arrière!',
  confirmButtonText: 'Oui, supprimez-le!',
  cancelButtonText: 'Annuler',
  Deleted: 'Supprimé!',
  Failed: 'Échec!',
  Therewassomethingwronge: 'Il y avait quelque chose de mal',
  CustomerDeleted: 'Ce client a été supprimé.'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Delete, "CustomerDeleted", 'Cet utilisateur a été supprimé.'), "SupplierDeleted", 'Fournisseur a été supprimé'), "QuoteDeleted", 'Cette Devis a été supprimée.'), "SaleDeleted", 'Cette Vente a été supprimée.'), "PaymentDeleted", 'Cette Paiement a été supprimée.'), "PurchaseDeleted", 'Cette Achat a été supprimée.'), "ReturnDeleted", 'Cette Retour a été supprimée.'), "ProductDeleted", 'Ce produit a été supprimé'), "ClientError", 'Ce Client déja lié avec autre Opération'), "ProviderError", 'Ce fournisseur déja lié avec autre Opération'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Delete, "UnitDeleted", 'Cette unités a été supprimé'), "RoleDeleted", 'Ce Role a été supprimé'), "TaxeDeleted", 'Cette Taxe a été supprimé'), "SubCatDeleted", 'Cette sous Categorie a été supprimé'), "CatDeleted", 'Cette Categorie a été supprimé'), "WarehouseDeleted", 'Ce magasin a été supprimé'), "AlreadyLinked", 'Ce produit déja lié avec autre Opération'), "AdjustDeleted", 'Cet Ajustement a été supprimé'), "TitleCurrency", 'Cet Devise a été supprimé'), "TitleTransfer", 'Transfer a été supprimée avec succès'), _defineProperty(_defineProperty(_Delete, "BackupDeleted", 'Sauvegarde a été supprimée avec succès'), "TitleBrand", 'Cette marque a été supprimée'))), "Update", {
  TitleSetting: 'Paramétres mis à jour avec succès',
  TitleProfile: 'Profil mis à jour avec succès',
  TitleAdjust: 'Adjustement mis à jour avec succès',
  TitleRole: 'Role mis à jour avec succès',
  TitleUnit: 'Unités mis à jour avec succès',
  TitleUser: 'Utilisateur mis à jour avec succès',
  TitleProduct: 'Produit mis à jour avec succès',
  TitleCustomer: 'Client mis à jour avec succès',
  TitleQuote: 'Devis mis à jour  avec succès',
  TitleSale: 'Vente mis à jour  avec succès',
  TitlePayment: 'Paiement mis à jour  avec succès',
  TitlePurchase: 'Achat  mis à jour  avec succès',
  TitleReturn: 'Retour  mis à jour  avec succès',
  TitleSupplier: 'Fournisseur  mis à jour  avec succès',
  TitleTaxe: 'Taxe  mis à jour  avec succès',
  TitleCat: 'Categorie mis à jour avec succès',
  TitleWarhouse: 'Magasin mis à jour avec succès',
  TitleCurrency: 'Devise mis à jour avec succès',
  TitleTransfer: 'Transfer mis à jour avec succès',
  TitleBrand: 'Cette marque a été mise à jour'
}), "Create", {
  TitleBrand: 'Cette marque a été créée',
  TitleTransfer: 'Transfer créé avec succès',
  TitleAdjust: 'Adjustement créé avec succès',
  TitleTaxe: 'Taxe créé avec succès',
  TitleRole: 'Role créé avec succès',
  TitleUnit: 'Unités créé avec succès',
  TitleUser: 'Utilisateur créé avec succès',
  TitleCustomer: 'Client créé avec succès',
  TitleQuote: 'Devis créé  avec succès',
  TitleSale: 'Vente créé  avec succès',
  TitlePayment: 'Paiement créé  avec succès',
  TitlePurchase: 'Achat créé  avec succès',
  TitleReturn: 'Retour créé  avec succès',
  TitleProduct: 'Produit créé avec succès',
  TitleSupplier: 'Fournisseur  créé  avec succès',
  TitleCat: 'Categorie  créé  avec succès',
  TitleWarhouse: 'Magasin créé avec succès',
  TitleCurrency: 'Devise créé avec succès'
}), "Send", {
  TitleEmail: 'Email Envoyé avec succès'
}), "return", {
  TitleSale: 'Cette vente déja liée avec un Retour!'
}), "PurchasesManagement", 'Gestion des achats'), "Ordered", 'Commandé'), "DeletePurchase", 'Supprimer l\'achat'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EmailPurchase", 'Envoyer l\'achat par e-mail'), "EditPurchase", 'Modifier l\'achat'), "PurchaseDetail", 'Détail d\'achat'), "AddPurchase", 'Ajouter d\'achat'), "EmailSupplier", 'Email Fournisseur'), "ReturnManagement", 'Gestion des retours'), "ReturnDetail", 'Détails du retour'), "EditReturn", 'Modifier le retour'), "AddReturn", 'Ajouter le retour'), "EmailReturn", 'Envoyer le retour par e-mail'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "DeleteReturn", 'Supprimer le retour'), "Retoursurcharge", 'Return Surcharge'), "Laivrison", 'Laivrison'), "SelectSale", 'Sélectionnez la vente'), "ZeroPardefault", 'Vous pouvez supprimer l\'élément ou définir la quantité retournée à zéro si elle n\'est pas retournée'), "Return", 'Retour'), "Purchase", 'Achat'), "PurchaseInvoice", 'Paiement des achats'), "PurchasesInvoicesData", 'Données Paiement d\'achat'), "SalesInvoices", 'Paiement des ventes'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SalesInvoicesData", 'Données Paiement de vente'), "TotalSales", 'Ventes totales'), "TotalPurchases", 'Total des achats'), "TotalReturns", 'Retours totaux'), "PaiementsNet", 'Paiement net'), "PaiementsSent", 'Paiements envoyés'), "PaiementsReceived", 'Paiements reçus'), "Recieved", 'Reçus'), "Sent", 'Envoyés'), "ProductQuantityAlerts", 'Alertes de quantité de produits'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCode", 'Code produit'), "ProductName", 'Produit'), "AlertQuantity", 'Quantité d\'alerte'), "WarehouseStockChart", 'Graphique du stock d\'entrepôt'), "TotalProducts", 'Total Produits'), "TotalQuantity", 'Total Quantity'), "TopCustomers", 'Top 5 des clients'), "TotalAmount", 'Montant total'), "TotalPaid", 'Total payé'), "CustomerSalesReport", 'Rapport des ventes'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'Rapport des paiements'), "CustomerQuotationsReport", 'Rapport des Devis'), "Payments", 'Paiements'), "TopSuppliers", 'Top 5 Providers'), "SupplierPurchasesReport", 'Rapport des achats'), "SupplierPaiementsReport", 'Rapport des paiements'), "Name", 'Nom'), "Code", 'Code'), "ManagementWarehouse", 'Gestion d\'entrepôt'), "ZipCode", 'Code postal'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementCategories", 'Gestion des catégories'), "Codecategorie", 'Code Catégorie'), "Namecategorie", 'Name Catégorie'), "Parentcategorie", 'Parente Catégorie'), "managementTax", 'Gestion fiscale'), "TaxName", 'Nom de la taxe'), "TaxRate", 'Taux de taxe'), "managementUnitPurchases", 'Gestion des unités d\'achats'), "managementUnitSales", 'Gestion des unités de vente'), "ShortName", 'Nom court'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'Veuillez les sélectionner avant d\'ajouter un produit'), "StockAdjustement", 'Ajustement des stocks'), "PleaseSelectWarehouse", 'Veuillez les sélectionner magasin avant de choisir un produit'), "StockTransfer", 'Transfert de stock'), "SelectPeriod", 'Sélectionnez la période'), "ThisYear", 'Cette année'), "ThisToday", 'Ce aujourd\'hui'), "ThisMonth", 'Ce mois-ci'), "ThisWeek", 'Cette semaine'), "AdjustmentDetail", 'Détail d\'ajustement'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'Cet utilisateur a été activé'), "DisActivateUser", 'Cet utilisateur a été désactivé'), "NotFound", 'Page non trouvée.'), "oops", 'Erreur! Page non trouvée.'), "couldNotFind", 'Nous n\'avons pas pu trouver la page que vous recherchiez.'), "ReturnDashboard", 'Retour au tableau de bord'), "hrm", 'HRM'), "Employees", 'Employés'), "Attendance", 'Présence'), "Leave_request", 'Demande de congé'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Type de congé'), "Company", 'Compagnie'), "Departments", 'Départements'), "Designations", 'Désignations'), "Office_Shift", 'Quart de bureau'), "Holidays", 'Vacances'), "Enter_Company_Name", 'Entrez le nom de l\'entreprise'), "Enter_email_address", 'Entrer l\'adresse e-mail'), "Enter_Company_Phone", 'Entrer le téléphone de l\'entreprise'), "Enter_Company_Country", 'Saisir le pays de l\'entreprise'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Créé en avec succès'), "Updated_in_successfully", 'Mis à jour avec succès'), "Deleted_in_successfully", 'Supprimé dans avec succès'), "department", 'Département'), "Enter_Department_Name", 'Entrez le nom du département'), "Choose_Company", 'Choisissez l\'entreprise'), "Department_Head", 'Chef de département'), "Choose_Department_Head", 'Choisissez le chef de département'), "Enter_Shift_name", 'Entrer le nom du quart'), "Monday_In", 'Monday In'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'Tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'Vacance'), "Enter_title", 'Entrez le titre'), "title", 'Titre'), "start_date", 'Date de début'), "Enter_Start_date", 'Entrez la date de début'), "Finish_Date", 'Date de fin'), "Enter_Finish_date", 'Entrez la date de fin'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Veuillez fournir des détails'), "Attendances", 'Présences'), "Enter_Attendance_date", 'Entrez la date de présence'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", 'Choisissez l\'employé'), "Employee", 'Employée'), "Work_Duration", 'Durée du travail'), "remaining_leaves_are_insufficient", 'Les Congés restantes sont insuffisantes'), "Leave_Type", 'Type de congé'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Days", 'Jours'), "Department", 'Département'), "Choose_leave_type", 'Choisissez le type de congé'), "Choose_status", 'Choisissez le statut'), "Leave_Reason", 'Raison du congé'), "Enter_Reason_Leave", 'Entrez la raison du congé'), "Add_Employee", 'Ajouter un employé'), "FirstName", 'Prénom'), "Enter_FirstName", 'Entrez votre prénom'), "LastName", 'Nom de famille'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Entrer le nom de famille'), "Gender", 'Le sexe'), "Choose_Gender", 'Choisissez le sexe'), "Enter_Birth_date", 'Entrez la date de naissance'), "Birth_date", 'Date de naissance'), "Enter_Country", 'Entrez le pays'), "Enter_Phone_Number", 'Entrez le numéro de téléphone'), "joining_date", 'Date d\'inscription'), "Enter_joining_date", 'Entrez la date d\'adhésion'), "Choose_Designation", 'Choisissez la désignation'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Designation", 'La désignation'), "Office_Shift", 'Quart de bureau'), "Choose_Office_Shift", 'Choisissez le quart de travail'), "Enter_Leaving_Date", 'Entrez la date de départ'), "Leaving_Date", 'Date de départ'), "Annual_Leave", 'Congé annuel'), "Enter_Annual_Leave", 'Saisir les congés annuels'), "Remaining_leave", 'Congé restant'), "Employee_Details", 'Détails de l\'employé'), "Basic_Information", 'Information basique'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Family_status", 'Situation familiale'), "Choose_Family_status", 'Choisissez le statut familial'), "Employment_type", 'Type d\'emploi'), "Select_Employment_type", 'Sélectionnez le type d\'emploi'), "Enter_City", 'Entrez la ville'), "Province", 'Province'), "Enter_Province", 'Entrez la province'), "Enter_Address", 'Entrer l\'adresse'), "Enter_Zip_code", 'Entrer le code postal'), "Zip_code", 'Code postal'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Tarif horaire'), "Enter_Hourly_rate", 'Entrez le taux horaire'), "Basic_salary", 'Salaire de base'), "Enter_Basic_salary", 'Entrez le salaire de base'), "Social_Media", 'Réseaux sociaux'), "Skype", 'Skype'), "Enter_Skype", 'Entrez Skype'), "Facebook", 'Facebook'), "Enter_Facebook", 'Entrez Facebook'), "WhatsApp", 'WhatsApp'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Entrez WhatsApp'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", 'Entrez LinkedIn'), "Twitter", 'Twitter'), "Enter_Twitter", 'Entrez Twitter'), "Experiences", 'Expériences'), "bank_account", 'compte bancaire'), "Company_Name", 'Nom de l\'entreprise'), "Location", 'l\'emplacement'), "Enter_location", 'Entrez l\'emplacement'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Entrez la description'), "Bank_Name", 'Nom de banque'), "Enter_Bank_Name", 'Entrez le nom de la banque'), "Bank_Branch", 'Agence bancaire'), "Enter_Bank_Branch", 'Entrer l\'agence bancaire'), "Bank_Number", 'Numéro de banque'), "Enter_Bank_Number", 'Entrez le numéro de banque'), "Assigned_warehouses", 'Entrepôts affectés'), "Top_customers", 'meilleurs clients'), "Attachment", 'Attachement'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "view_employee", 'voir les employés'), "edit_employee", 'modifier les employés'), "delete_employee", 'supprimer des employés'), "Created_by", 'Ajouté par'), "Add_product_IMEI_Serial_number", 'Ajouter le produit IMEI/numéro de série'), "Product_Has_Imei_Serial_number", 'Le produit a un numéro IMEI/série'), "IMEI_SN", 'IMEI/SN'), "Shipments", 'Expéditions'), "delivered_to", 'Livré à'), "shipment_ref", 'Réf d\'expédition'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Réf vente'), "Edit_Shipping", 'Modifier la livraison'), "Packed", 'Emballé'), "Shipped", 'Expédié'), "Delivered", 'Livré'), "Cancelled", 'Annulé'), "Shipping_status", 'Statut d\'envoi'), "Users_Report", 'Rapport des utilisateurs'), "stock_report", 'Rapport d\'inventaire'), "TotalPurchases", 'Total des achats'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Total des devis'), "Total_return_sales", 'Total des retours de vente'), "Total_return_purchases", 'Total des retours d\'achat'), "Total_transfers", 'Total des transferts'), "Total_adjustments", 'Total des ajustements'), "User_report", 'Rapport d\'utilisateur'), "Current_stock", 'Stock actuel'), "product_name", 'Nom du produit'), "Total_Customers_Due", 'Dette totale'), "Total_Suppliers_Due", 'Dette totale'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'Certains entrepôts'), "All_Warehouses", 'Tous les entrepôts'), "Product_Cost", 'Prix d\'achat'), "sms_settings", 'Paramètres SMS'), "pos_settings", 'Paramètres du point de vente'), "payment_gateway", 'Passerelle de paiement'), "mail_settings", 'Paramètres de messagerie'), "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'Passerelle SMS par défaut'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "module_settings", 'Paramètres des modules'), "Module_enabled_success", 'Module activé avec succès'), "Module_Disabled_success", 'Module désactivé avec succès'), "update_settings", 'Mettre à jour les paramètres'), "Please_Upload_the_Correct_Module", 'Veuillez télécharger le bon module'), "Uploaded_Success", 'Importé avec succès'), "Customer_details", 'Détails du client'), "Edit_Customer", 'Modifier le client'), "Delete_Customer", 'Supprimer le client'), "Pay_Due", 'payer dû'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'Le montant du paiement est supérieur au total dû'), "Customer_Invoice", 'Facture client'), "This_Product_Not_For_Selling", 'Ce produit n\'est pas à vendre'), "Welcome_to_your_Dashboard", 'Bienvenue sur votre tableau de bord'), "Total_Payable", 'Total à payer'), "Choose_Sale_Ref", 'Choisissez la référence de la vente'), "Please_Select_Sale", 'Veuillez sélectionner la vente'), "Sale_Ref", 'Réf vente'), "list_product_returns", 'list des retours de produits'), "Qty_return", 'Qté de retour'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Choisissez la référence d\'achat'), "Purchase_Ref", 'Réf d\'achat'), "please_select_purchase", 'Veuillez sélectionner l\'achat'), "qty_return_is_greater_than_qty_purchased", 'La quantité retournée est supérieure à la quantité achetée'), "qty_return_is_greater_than_qty_sold", 'La quantité retournée est supérieure à la quantité vendue'), "Quantity_sold", 'Qté vendue'), "qty_purchased", 'Qté achetée'), "Sender_Name", 'Nom expéditeur'), "The_module_must_be_uploaded_as_zip_file", 'Le module doit être téléchargé sous forme de fichier zip'), "Upload_Module", 'Télécharger le module'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'Tous les modules installés'), "Current_Version", 'Version actuelle'), "You_already_have_the_latest_version", 'Vous avez déjà la dernière version'), "Update_Available", 'Mise à jour disponible'), "Update_Log", 'Journal de mise à jour'), "Update_Now", 'Mettez à jour maintenant'), "invoice_footer", 'Pied de facture'), "View_Change_Log", 'Voir la log des modifications'), "Please_Wait_for_the_update", 'REMARQUE : Veuillez attendre que la mise à jour se termine complètement. Il n\'est pas recommandé de fermer le navigateur ou d\'arrêter un processus de mise à niveau'), "Note_update", 'Remarque : Assurez-vous de sauvegarder votre version actuelle et votre base de données avant d\'exécuter la mise à niveau, pour la restaurer en cas d\'erreur.'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Fuseau horaire'), "Payment_note", 'Paiement Remarque'), "sale_note", 'notes de vente'), "Total_Sale_Due", 'Vente totale dû'), "Total_Sell_Return_Due", 'Retour de vente total dû'), "pay_all_sell_due_at_a_time", 'payer toutes les dettes de vente à la fois'), "pay_all_sell_return_due_at_a_time", 'payer toutes les dettes de retour de vente à la fois'), "Gross_Profit", 'Bénéfice brut'), "pay_all_purchase_due_at_a_time", 'payer toutes les dettes d\'achat à la fois'), "Delete_Provider", 'Supprimer le fournisseur'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Modifier le fournisseur'), "Provider_details", 'Détails du fournisseur'), "Total_Purchase_Due", 'Dette d\'achat totale'), "Provider_Credit_Note", 'Note de crédit'), "Customer_Credit_Note", 'Note de crédit'), "Sell_Return", 'Retour de vente'), "Purchase_Return", 'Retour d\'achat'), "Tax_Number", 'Numéro de TVA'), "Please_add_return_quantity", 'Veuillez ajouter la quantité de retour'), "Return_exist_for_the_Transaction", 'Le retour existe pour la transaction'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'La quantité retournée est supérieure à la quantité restante'), "products_refunded_alert", 'Tous les produits dont la quantité est définie sur 0 ne seront pas remboursés'), "pay_all_purchase_return_due_at_a_time", 'payer tous les retours d\'achat dus à la fois'), "Total_Purchase_Return_Due", 'Total de la dette de retour d\'achat'), "Purchase_return_due", 'Retour d\'achat dû'), "Sell_return_due", 'Retour de vente dû'), "product_report", 'Rapport de produit'), "product_sales_report", 'Rapport de vente de produits'), "Product_purchases_report", 'Rapport d\'achat de produits'), "Qty_sold", 'Qté vendue'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'Qté achetée'), "Filter_by_warehouse", 'Filtrer par magasin'), "Enable_Print_Invoice", 'Imprimer la facture automatiquement'), "Show_Warehouse", 'voir l\'entrepôt'), "credit_card_info", 'Informations de carte de crédit'), "Saved_Credit_Card_Info", 'Informations de carte de crédit enregistrées'), "Credit_card_changed_successfully", 'Carte de crédit changée avec succès'), "notification_template", 'Modèle de notification'), "email_notification", 'Notification par email'), "sms_notification", 'Notification par SMS'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Modifier les détails du produit'), "edit_tax_and_discount_and_shipping", 'Modifier les taxes, remises et livraison'), "Create_Quotation_with_Stock", 'Créer une citation avec stock'), "Variant_Name", 'Nom de la variante'), "Variant_cost", 'Coût de la variante'), "Variant_price", 'Prix de la variante'), "Variant_code", 'Code de la variante'), "Please_wait_until_the_product_is_loaded", 'Veuillez patienter jusqu\'à ce que le produit soit chargé'), "Choose_SMS_Gateway", 'Choisir la passerelle SMS'), "Notification_Client", 'Notification au client'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Tags disponibles'), "Email_Subject", 'Objet de l\'email'), "Email_body", 'Corps de l\'email'), "Notification_Supplier", 'Notification au fournisseur'), "sms_body", 'Corps du SMS'), "sms_templates", 'Modèles de SMS'), "email_templates", 'Modèles d\'e-mails'));

/***/ }),

/***/ "./resources/src/translations/locales/hn.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/hn.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Hindi

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'रसीद',
  Pos_Settings: 'प्वाइंट डे वेंट सेटिंग्स',
  Note_to_customer: 'ग्राहक को नोट',
  Show_Note_to_customer: 'ग्राहक को नोट दिखाएं',
  Show_barcode: 'बरकोड़ दिखाओ',
  Show_Tax_and_Discount: 'टैक्स और छूट और शिपिंग दिखाएँ',
  Show_Customer: 'ग्राहक दिखाएँ',
  Show_Email: 'ईमेल दिखाएं',
  Show_Phone: 'फ़ोन दिखाएँ',
  Show_Address: 'पता दिखाएँ',
  DefaultLanguage: 'डिफ़ॉल्ट भाषा',
  footer: 'फ़ुटबाल',
  Received_Amount: 'प्राप्त राशि',
  Paying_Amount: 'भुगतान राशि',
  Change: 'परिवर्तन',
  Paying_amount_is_greater_than_Received_amount: 'भुगतान राशि प्राप्त राशि से अधिक है',
  Paying_amount_is_greater_than_Grand_Total: 'भुगतान राशि कुल योग से अधिक है',
  code_must_be_not_exist_already: 'कोड पहले से मौजूद नहीं होना चाहिए',
  You_will_find_your_backup_on: 'आपको अपना बैकअप इस पर मिलेगा',
  and_save_it_to_your_pc: 'और इसे अपने पीसी में सहेजें',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'अपना बारकोड स्कैन करें और नीचे सही सिम्बोलॉजी चुनें select',
  Scan_Search_Product_by_Code_Name: 'कोड नाम से उत्पाद स्कैन/खोजें',
  Paper_size: 'काग़ज़ का आकार',
  Clear_Cache: 'कैश को साफ़ करें',
  Cache_cleared_successfully: 'कैश सफलतापूर्वक साफ़ किया गया',
  Failed_to_clear_cache: 'कैशे साफ़ करने में विफल',
  Scan_Barcode: 'बारकोड स्कैनर',
  Please_use_short_name_of_unit: 'कृपया इकाई के संक्षिप्त नाम का प्रयोग करें',
  DefaultCustomer: 'डिफ़ॉल्ट ग्राहक',
  DefaultWarehouse: 'डिफ़ॉल्ट गोदाम',
  Payment_Gateway: 'अदायगी रास्ता',
  SMS_Configuration: 'एसएमएस कॉन्फ़िगरेशन',
  Gateway: 'अदायगी रास्ता',
  Choose_Gateway: 'पेमेंट गेटवे चुनें',
  Send_SMS: 'संदेश सफलतापूर्वक भेजा जा चुका है',
  sms_config_invalid: 'गलत sms कॉन्फिगर्ड अमान्य है',
  Remove_Stripe_Key_Secret: 'स्ट्राइप एपीआई कीज को डिलीट करें',
  credit_card_account_not_available: 'क्रेडिट कार्ड खाता उपलब्ध नहीं है',
  Credit_Card_Info: 'क्रेडिट कार्ड की जानकारी',
  developed_by: 'द्वारा विकसित',
  Unit_already_linked_with_sub_unit: 'यूनिट पहले से ही सब यूनिट के साथ जुड़ी हुई है',
  Total_Items_Quantity: 'कुल आइटम और मात्रा',
  Value_by_Cost_and_Price: 'मूल्य और मूल्य द्वारा मूल्य',
  Search_this_table: 'इस तालिका को खोजें',
  import_products: 'उत्पादों का आयात करें',
  Field_optional: 'क्षेत्र वैकल्पिक',
  Download_exemple: 'उदाहरण डाउनलोड करें',
  field_must_be_in_csv_format: 'फ़ील्ड सीएसवी प्रारूप में होनी चाहिए',
  Successfully_Imported: 'सफलतापूर्वक आयात किया गया',
  file_size_must_be_less_than_1_mega: 'फ़ाइल का आकार 1 मेगा से कम होना चाहिए',
  Please_follow_the_import_instructions: 'कृपया आयात निर्देशों का पालन करें',
  must_be_exist: 'इकाई पहले से ही बनाई जानी चाहिए',
  Import_Customers: 'ग्राहक आयात करें',
  Import_Suppliers: 'आयात आपूर्तिकर्ता',
  Recent_Sales: 'हाल की बिक्री',
  Create_Transfer: 'स्थानांतरण बनाएँ',
  order_products: 'चिजें मँगाओ',
  Search_Product_by_Code_Name: 'कोड या नाम से उत्पाद खोजें',
  Reports_payments_Purchase_Return: 'रिपोर्ट खरीद भुगतान',
  Reports_payments_Sale_Return: 'बिक्री विवरणी भुगतान रिपोर्ट',
  payments_Sales_Return: 'भुगतान बिक्री वापसी',
  payments_Purchases_Return: 'भुगतान खरीद वापसी',
  CreateSaleReturn: 'बिक्री वापसी बनाएँ',
  EditSaleReturn: 'बिक्री वापसी संपादित करें',
  SalesReturn: 'बिक्री वापसी',
  CreatePurchaseReturn: 'खरीद वापसी बनाएँ',
  EditPurchaseReturn: 'खरीद वापसी संपादित करें',
  PurchasesReturn: 'खरीद वापसी',
  Due: 'देय',
  Profit: 'फायदा',
  Revenue: 'राजस्व',
  Sales_today: 'आज बिक्री',
  People: 'लोग',
  Successfully_Created: 'सफलतापूर्वक बनाया गया',
  Successfully_Updated: 'सफलतापूर्वक उत्परिवर्तित',
  Success: 'सफलता',
  Failed: 'अनुत्तीर्ण होना',
  Warning: 'चेतावनी',
  Please_fill_the_form_correctly: 'कृपया फॉर्म सही से भरें',
  Field_is_required: 'ये स्थान भरा जाना है',
  Error: 'त्रुटि!',
  you_are_not_authorized: 'माफ़ करना! तुम अधिकृत नहीं हो।',
  Go_back_to_home: 'मुखपृष्ठ पर वापस जाएं',
  page_not_exist: 'माफ़ करना! जिस पृष्ठ को आप खोज रहे थे वह मौजूद नहीं है।',
  Choose_Status: 'स्थिति चुनें',
  Choose_Method: 'विधि चुनें',
  Choose_Symbology: 'सहजीवन चुनें',
  Choose_Category: 'वर्ग चुने',
  Choose_Customer: 'ग्राहक चुनें',
  Choose_Supplier: 'आपूर्तिकर्ता चुनें',
  Choose_Unit_Purchase: 'खरीद इकाई चुनें',
  Choose_Sub_Category: 'उपश्रेणी चुनें',
  Choose_Brand: 'ब्रांड चुनें',
  Choose_Warehouse: 'वेयरहाउस चुनें',
  Choose_Unit_Sale: 'बिक्री इकाई चुनें',
  Enter_Product_Cost: 'उत्पाद लागत दर्ज करें',
  Enter_Stock_alert: 'स्टॉक अलर्ट दर्ज करें',
  Choose_Unit_Product: 'उत्पाद इकाई चुनें',
  Enter_Product_Price: 'उत्पाद मूल्य दर्ज करें',
  Enter_Name_Product: 'नाम उत्पाद दर्ज करें',
  Enter_Role_Name: 'भूमिका का नाम दर्ज करें',
  Enter_Role_Description: 'भूमिका विवरण दर्ज करें',
  Enter_name_category: 'श्रेणी का नाम दर्ज करें',
  Enter_Code_category: 'श्रेणी कोड दर्ज करें',
  Enter_Name_Brand: 'नाम ब्रांड दर्ज करें',
  Enter_Description_Brand: 'विवरण ब्रांड दर्ज करें',
  Enter_Code_Currency: 'कोड करेंसी दर्ज करें',
  Enter_name_Currency: 'नाम दर्ज करें मुद्रा',
  Enter_Symbol_Currency: 'प्रतीक मुद्रा दर्ज करें',
  Enter_Name_Unit: 'इकाई का नाम दर्ज करें',
  Enter_ShortName_Unit: 'शॉर्टनेम यूनिट दर्ज करें',
  Choose_Base_Unit: 'बेस यूनिट चुनें',
  Choose_Operator: 'ऑपरेटर चुनें',
  Enter_Operation_Value: 'ऑपरेशन मान दर्ज करें',
  Enter_Name_Warehouse: 'वेयरहाउस का नाम दर्ज करें',
  Enter_Phone_Warehouse: 'वेयरहाउस फ़ोन दर्ज करें',
  Enter_Country_Warehouse: 'गोदाम देश दर्ज करें',
  Enter_City_Warehouse: 'वेयरहाउस सिटी दर्ज करें',
  Enter_Email_Warehouse: 'गोदाम ईमेल दर्ज करें',
  Enter_ZipCode_Warehouse: 'वेयरहाउस ज़िप कोड दर्ज करें',
  Choose_Currency: 'मुद्रा चुनिये',
  Thank_you_for_your_business: 'आपके व्यापार के लिए धन्यवाद!',
  Cancel: 'रद्द करना',
  New_Customer: 'नए ग्राहक',
  Incorrect_Login: 'गलत लॉगिन',
  Successfully_Logged_In: 'सफलतापूर्वक लॉग इन किया',
  This_user_not_active: 'यह उपयोगकर्ता सक्रिय नहीं है',
  SignIn: 'साइन इन करें',
  Create_an_account: 'खाता बनाएं',
  Forgot_Password: 'पासवर्ड भूल गए ?',
  Email_Address: 'ईमेल पता',
  SignUp: 'साइन अप करें',
  Already_have_an_account: 'क्या आपके पास पहले से एक खाता मौजूद है ?',
  Reset_Password: 'पासवर्ड रीसेट',
  Failed_to_authenticate_on_SMTP_server: 'SMTP सर्वर पर प्रमाणित करने में विफल',
  We_cant_find_a_user_with_that_email_addres: 'हमें उस ईमेल पते वाला उपयोगकर्ता नहीं मिल रहा है',
  We_have_emailed_your_password_reset_link: 'हमने आपका पासवर्ड रीसेट लिंक ई-मेल कर दिया है',
  Please_fill_the_Email_Adress: 'कृपया ईमेल पता भरें',
  Confirm_password: 'पासवर्ड की पुष्टि कीजिये',
  Your_Password_has_been_changed: 'आपका पासवर्ड बदल दिया गया है',
  The_password_confirmation_does_not_match: 'पासवर्ड की पुष्टि मेल नहीं खाती',
  This_password_reset_token_is_invalid: 'यह पासवर्ड रीसेट टोकन अमान्य है',
  Warehouse_report: 'वेयरहाउस की रिपोर्ट',
  All_Warehouses: 'सभी गोदाम',
  Expense_List: 'व्यय सूची',
  Expenses: 'व्यय',
  This_Week_Sales_Purchases: 'यह सप्ताह बिक्री और खरीद',
  Top_Selling_Products: 'शीर्ष बेचना उत्पाद',
  View_all: 'सभी देखें',
  Payment_Sent_Received: 'भुगतान भेजा और प्राप्त किया',
  Filter: 'फ़िल्टर',
  Invoice_POS: 'बीजक POS',
  Invoice: 'बीजक',
  Customer_Info: 'ग्राहक की जानकारी',
  Company_Info: 'कंपनी की जानकारी',
  Invoice_Info: 'चालान जानकारी',
  Order_Summary: 'आदेश सारांश',
  Quote_Info: 'उद्धरण जानकारी',
  Del: 'हटाएं',
  SuppliersPaiementsReport: 'आपूर्तिकर्ता भुगतान रिपोर्ट',
  Purchase_Info: 'खरीद जानकारी',
  Supplier_Info: 'आपूर्तिकर्ता जानकारी',
  Return_Info: 'वापसी की जानकारी',
  Expense_Category: 'व्यय की श्रेणी',
  Create_Expense: 'व्यय बनाएँ',
  Details: 'विवरण',
  Discount_Method: 'डिस्काउंट विधि',
  Net_Unit_Cost: 'नेट यूनिट लागत',
  Net_Unit_Price: 'शुद्ध इकाई मूल्य',
  Edit_Expense: 'व्यय संपादित करें',
  All_Brand: 'सभी ब्रांड',
  All_Category: 'सभी श्रेणी',
  ListExpenses: 'सूची व्यय',
  Create_Permission: 'अनुमति बनाएँ',
  Edit_Permission: 'अनुमति संपादित करें',
  Reports_payments_Sales: 'रिपोर्ट भुगतान बिक्री',
  Reports_payments_Purchases: 'रिपोर्ट भुगतान खरीद',
  Reports_payments_Return_Customers: 'रिपोर्ट भुगतान वापसी ग्राहकों',
  Reports_payments_Return_Suppliers: 'रिपोर्ट भुगतान वापसी आपूर्तिकर्ता',
  Expense_Deleted: 'यह व्यय हटा दिया गया है',
  Expense_Updated: 'यह व्यय अद्यतन किया गया है',
  Expense_Created: 'यह व्यय सृजित किया गया है',
  DemoVersion: 'आप डेमो संस्करण में ऐसा नहीं कर सकते',
  OrderStatistics: 'बिक्री के आँकड़े',
  AlreadyAdd: 'यह उत्पाद पहले से ही जोड़ा गया है',
  AddProductToList: 'कृपया सूची में उत्पाद जोड़ें',
  AddQuantity: 'कृपया विस्तार की मात्रा जोड़ें',
  InvalidData: 'अमान्य तथ्य',
  LowStock: 'मात्रा स्टॉक में उपलब्ध मात्रा से अधिक है',
  WarehouseIdentical: 'दो गोदाम समान नहीं हो सकते हैं',
  VariantDuplicate: 'ये वैरिएंट डुप्लीकेट है',
  Filesize: 'फाइल का आकार',
  GenerateBackup: 'बैकअप उत्पन्न करें',
  BackupDatabase: 'बैकअप डेटाबेस',
  Backup: 'बैकअप',
  Paid: 'भुगतान किया है',
  Unpaid: 'अवैतनिक',
  Today: 'आज',
  Income: 'आय'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'व्ययव्यय'), "Sale", 'बिक्री'), "Actif", 'सक्रिय'), "Inactif", 'निष्क्रिय'), "Customers", 'ग्राहकों'), "Phone", 'फ़ोन'), "SearchByPhone", 'फ़ोन द्वारा खोजें'), "Suppliers", 'आपूर्तिकर्ता'), "Quotations", 'कोटेशन'), "Sales", 'बिक्री'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'खरीद'), "Returns", 'रिटर्न'), "Settings", 'समायोजन'), "SystemSettings", 'प्रणाली व्यवस्था'), "Users", 'उपयोगकर्ता'), "GroupPermissions", 'समूह अनुमतियाँ'), "Currencies", 'मुद्राओं'), "Warehouses", 'गोदामों'), "Units", 'इकाइयों'), "UnitsPrchases", 'इकाइयाँ खरीदता है'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'इकाइयों की बिक्री'), "Reports", 'रिपोर्ट'), "PaymentsReport", 'भुगतान रिपोर्ट'), "PaymentsPurchases", 'भुगतान खरीद'), "PaymentsSales", 'भुगतान बिक्री'), "ProfitandLoss", 'लाभ और हानि'), "WarehouseStockChart", 'गोदाम स्टॉक चार्ट'), "SalesReport", 'बिक्री रिपोर्ट'), "PurchasesReport", 'खरीद रिपोर्ट'), "CustomersReport", 'ग्राहक रिपोर्ट'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'आपूर्तिकर्ता रिपोर्ट'), "SupplierReport", 'आपूर्तिकर्ता रिपोर्ट'), "DailySalesData", 'दैनिक बिक्री डेटा'), "DailyPurchasesData", 'दैनिक खरीद डेटा'), "Derni\xE8rescinqrecords", 'पिछले पांच रिकॉर्ड'), "Filters", 'फिल्टर'), "date", 'दिनांक'), "Reference", 'संदर्भ'), "Supplier", 'प्रदायक'), "PaymentStatus", 'भुगतान की स्थिति'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", 'ग्राहक'), "CustomerCode", 'ग्राहक क्रमांक'), "Status", 'स्थिति'), "SupplierCode", 'प्रदायक का कोड'), "Categorie", 'वर्ग'), "Categories", 'श्रेणियाँ'), "StockTransfers", 'स्टॉक ट्रांसफर'), "StockManagement", 'स्टाक प्रबंधन'), "dashboard", 'डैशबोर्ड'), "Products", 'उत्पाद'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'उत्पादों की सूची'), "ProductManagement", 'उत्पाद प्रबंधन'), "ProductQuantityAlerts", 'उत्पाद मात्रा अलर्ट'), "CodeProduct", 'कोड उत्पाद'), "ProductTax", 'उत्पाद कर'), "SubCategorie", 'उपश्रेणी'), "Name_product", 'पद'), "StockAlert", 'स्टॉक अलर्ट'), "warehouse", 'गोदाम'), "Tax", 'कर'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'खरीद मूल्य'), "SellPrice", 'विक्रय मूल्य'), "Quantity", 'मात्रा'), "UnitSale", 'इकाई बिक्री'), "UnitPurchase", 'यूनिट खरीद'), "ManagementCurrencies", 'मुद्रा प्रबंधन'), "CurrencyCode", 'मुद्रा कोड'), "CurrencyName", 'मुद्रा का नाम'), "Symbol", 'प्रतीक'), "All", 'सब'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", 'उत्पाद संपादित करें'), "SearchByCode", 'कोड द्वारा खोजें'), "SearchByName", 'नाम से खोजें'), "ProductDetails", 'उत्पाद विवरण'), "CustomerName", 'ग्राहक का नाम'), "CustomerManagement", 'ग्राहक प्रबंधन'), "Add", 'सृजन करना'), "add", 'सृजन करना'), "Edit", 'संपादित करें'), "Close", 'बंद करे'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'कृपया चुने'), "Action", 'कार्य'), "Email", 'ईमेल'), "EditCustomer", 'ग्राहक संपादित करें'), "AddCustomer", 'ग्राहक बनाएं'), "Country", 'देश'), "City", 'शहर'), "Adress", 'पता'), "CustomerDetails", 'उपभोक्ता विवरण'), "CustomersList", 'ग्राहक सूची'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'प्रदायक का कोड'), "SupplierName", 'आपूर्तिकर्ता का नाम'), "SuppliersManagement", 'आपूर्तिकर्ता प्रबंधन'), "SupplierDetails", 'आपूर्तिकर्ता विवरण'), "QuotationsManagement", 'उद्धरण प्रबंधन'), "SubTotal", 'उप-योग'), "MontantReste", 'बची हुई राशि'), "complete", 'पूरा कर लिया है'), "EnAttendant", 'अपूर्ण'), "Recu", 'प्राप्त किया'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", 'आंशिक'), "Retournee", 'वापसी'), "DetailQuote", 'विस्तार उद्धरण'), "EditQuote", 'उद्धरण संपादित करें'), "CreateSale", 'बिक्री बनाएँ'), "DownloadPdf", 'डाउनलोड पीडीऍफ़'), "QuoteEmail", 'ईमेल पर भेजा गया उद्धरण'), "DeleteQuote", 'उद्धरण हटाएं'), "AddQuote", 'उद्धरण बनाएँ'), "SelectProduct", 'उत्पाद का चयन करें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'उत्पाद (कोड - नाम)'), "Price", 'कीमत'), "CurrentStock", 'भण्डार'), "Total", 'संपूर्ण'), "Num", 'एन °'), "Unitcost", 'इकाई लागत'), "to", 'सेवा'), "Subject", 'विषय'), "Message", 'संदेश'), "EmailCustomer", 'ईमेल ग्राहक'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", 'संदेश'), "Quote", 'उद्धरण'), "Hello", 'नमस्कार'), "AttachmentQuote", 'कृपया अपने उद्धरण के लिए अनुलग्नक ढूंढें'), "AddProducts", 'उत्पादों को ऑर्डर सूची में जोड़ें'), "SelectWarehouse", 'कृपया गोदाम चुनें'), "SelectCustomer", 'कृपया ग्राहक चुनें'), "SalesManagement", 'बिक्री प्रबंधन'), "Balance", 'संतुलन'), "QtyBack", 'वापस मात्रा'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'कुल प्राप्ति'), "Amount", 'रकम'), "SaleDetail", 'बिक्री विवरण'), "EditSale", 'बिक्री संपादित करें'), "AddSale", 'बिक्री बनाएँ'), "ShowPayment", 'भुगतान दिखाएं'), "AddPayment", 'भुगतान बनाएं'), "EditPayment", 'भुगतान संपादित करें'), "EmailSale", 'ईमेल में बिक्री भेजें'), "DeleteSale", 'बिक्री हटाएं'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'द्वारा भुगतान'), "Paymentchoice", 'भुगतान का विकल्प'), "Note", 'ध्यान दें'), "PaymentComplete", 'भुगतान पूरा!'), "PurchasesManagement", 'खरीद प्रबंधन'), "Ordered", 'आदेश दिया'), "DeletePurchase", 'खरीद हटाएं'), "EmailPurchase", 'ईमेल में खरीद भेजें'), "EditPurchase", 'खरीद संपादित करें'), "PurchaseDetail", 'खरीद विवरण'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'खरीदारी बनाएँ'), "EmailSupplier", 'आपूर्तिकर्ता ईमेल'), "PurchaseInvoice", 'भुगतान खरीदता है'), "PurchasesInvoicesData", 'भुगतान डेटा खरीदता है'), "SalesInvoice", 'बिक्री भुगतान'), "SalesInvoicesData", 'बिक्री भुगतान डेटा'), "UserManagement", 'उपयोगकर्ता प्रबंधन'), "Firstname", 'पहला नाम'), "lastname", 'उपनाम'), "username", 'उपयोगकर्ता नाम'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", 'कुंजिका'), "Newpassword", 'नया पासवर्ड'), "ChangeAvatar", 'अवतार परिवर्तन'), "LeaveBlank", 'यदि आपने इसे नहीं बदला है तो कृपया इस फ़ील्ड को खाली छोड़ दें'), "type", 'प्रकार'), "UserPermissions", 'उपयोगकर्ता अनुमतियाँ'), "RoleName", 'भूमिका'), "RoleDescription", 'भूमिका विवरण'), "AddPermissions", 'अनुमतियाँ बनाएँ'), "View", 'राय'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", 'हटाएं'), "NewAdjustement", 'नया समायोजन'), "EditAdjustement", 'समायोजन संपादित करें'), "CannotSubstraction", 'आप उन उत्पादों को घटा नहीं सकते जिनके पास स्टॉक 0 है'), "Addition", 'इसके अलावा'), "Subtraction", 'घटाव'), "profil", 'प्रोफ़ाइल'), "logout", 'लॉग आउट'), "PurchaseAlreadyPaid", 'आप संशोधित नहीं कर सकते क्योंकि यह खरीद पहले ही भुगतान कर चुकी है'), "SaleAlreadyPaid", 'आप संशोधित नहीं कर सकते क्योंकि यह बिक्री पहले ही भुगतान कर चुकी है'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'आप संशोधित नहीं कर सकते क्योंकि यह रिटर्न पहले ही भुगतान कर चुका है'), "QuoteAlready", 'यह उद्धरण पहले ही बिक्री उत्पन्न कर चुका है'), "AddProduct", 'उत्पाद बनाएँ'), "QuotationComplete", 'यह उद्धरण पूरा हुआ'), "SiteConfiguration", 'साइट कॉन्फ़िगरेशन'), "Language", 'भाषा: हिन्दी'), "DefaultCurrency", 'डिफ़ॉल्ट मुद्रा'), "LoginCaptcha", 'कैप्चा लॉगिन करें'), "DefaultEmail", 'डिफ़ॉल्ट ईमेल'), "SiteName", 'साइट का नाम'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'लोगो बदलें'), "SMTPConfiguration", 'SMTP कॉन्फ़िगरेशन'), "HOST", 'मेज़बान'), "PORT", 'बंदरगाह'), "encryption", 'एन्क्रिप्शन'), "SMTPIncorrect", 'SMTP कॉन्फ़िगरेशन गलत है'), "PaymentsReturns", 'भुगतान रिटर्न'), "ReturnsInvoices", 'चालान लौटाता है'), "ReturnsInvoicesData", 'चालान डेटा लौटाता है'), "ShowAll", 'Show all records of all Users'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", 'छूट'), "OrderTax", 'आदेश कर'), "Shipping", 'शिपिंग'), "CompanyName", 'कंपनी का नाम'), "CompanyPhone", 'Company Phone'), "CompanyAdress", 'कंपनी का पता'), "Code", 'कोड'), "image", 'छवि'), "Printbarcode", 'प्रिंट बारकोड'), "ReturnsCustomers", 'ग्राहक लौटाता है'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'आपूर्तिकर्ता लौटाता है'), "FactureReturnCustomers", 'ग्राहकों का चालान वापस करें'), "FactureReturnSuppliers", 'आपूर्तिकर्ता लौटें चालान'), "NodataAvailable", 'कोई डेटा उपलब्ध नहीं है'), "ProductImage", 'उत्पाद का चित्र'), "Barcode", 'बारकोड'), "pointofsales", 'विक्रय पॉइंट'), "CustomUpload", 'कस्टम अपलोड'), "pointofsaleManagement", 'बिक्री प्रबंधन का बिंदु'), "Adjustment", 'समायोजन'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", 'अपडेट करें'), "Reset", 'रीसेट'), "print", 'छाप'), "SearchByEmail", 'ईमेल द्वारा खोजें'), "ChooseProduct", 'उत्पाद चुनें'), "Qty", 'मात्रा'), "Items", 'आइटम'), "AmountHT", 'संपूर्ण'), "AmountTTC", 'कुल रकम'), "PleaseSelectSupplier", 'कृपया आपूर्तिकर्ता का चयन करें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'कृपया स्थिति चुनें'), "PayeBy", 'द्वारा भुगतान'), "ChooseWarehouse", 'वेयरहाउस चुनें'), "payNow", 'अब भुगतान करें'), "ListofCategory", 'श्रेणी की सूची'), "Description", 'विवरण'), "submit", 'प्रस्तुत'), "ProblemCreatingThisInvoice", 'इस चालान को बनाने में एक समस्या थी। कृपया पुन: प्रयास करें'), "ProblemPayment", 'भुगतान की समस्या थी। कृपया पुन: प्रयास करें।'), "IncomeExpenses", 'आय और व्यय'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'दैनिक बिक्री और खरीद'), "ProductsExpired", 'उत्पाद समाप्त हो गए'), "ListofBrand", 'सूची ब्रांड'), "CreateAdjustment", 'समायोजन बनाएँ'), "Afewwords", 'कुछ शब्द ...'), "UserImage", 'उपयोगकर्ता छवि'), "UpdateProduct", 'अद्यतन उत्पाद'), "Brand", 'ब्रांड'), "BarcodeSymbology", 'बारकोड सिम्बोलॉजी'), "ProductCost", 'सामान का मूल्य'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'उत्पाद की कीमत'), "UnitProduct", 'यूनिट उत्पाद'), "TaxMethod", 'कर विधि'), "MultipleImage", 'एकाधिक छवि'), "ProductHasMultiVariants", 'उत्पाद में मल्टी वेरिएंट हैं'), "ProductHasPromotion", 'उत्पाद का प्रचार है'), "PromotionStart", 'प्रमोशन शुरू'), "PromotionEnd", 'प्रमोशन का अंत'), "PromotionPrice", 'प्रोन्नति मूल्य'), "Price", 'कीमत'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Cost", 'लागत'), "Unit", 'इकाई'), "ProductVariant", 'उत्पाद वेरिएंट'), "Variant", 'प्रकार'), "UnitPrice", 'यूनिट मूल्य'), "CreateReturnCustomer", 'ग्राहक बनाएँ'), "EditReturnCustomer", 'रिटर्न ग्राहक संपादित करें'), "CreateReturnSupplier", 'रिटर्न सप्लायर बनाएं'), "Documentation", 'प्रलेखन'), "EditReturnSupplier", 'रिटर्न प्रदायक संपादित करें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'वेयरहाउस से'), "ToWarehouse", 'वेयरहाउस के लिए'), "EditTransfer", 'स्थानांतरण संपादित करें'), "TransferDetail", 'ट्रांसफर डिटेल'), "Pending", 'विचाराधीन'), "Received", 'प्राप्त किया'), "Ordered", 'आदेश दिया'), "PermissionsManager", 'अनुमतियाँ प्रबंधन'), "BrandManager", 'ब्रांड'), "BrandImage", 'ब्रांड छवि'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BrandName", 'ब्रांड का नाम'), "BrandDescription", 'ब्रांड विवरण'), "BaseUnit", 'मूल इकाई'), "ManagerUnits", 'इकाइयाँ प्रबंधन'), "OperationValue", 'ऑपरेशन मान'), "Operator", 'ऑपरेटर'), "Top5Products", 'शीर्ष पांच उत्पाद'), "Last5Sales", 'पिछले पांच बिक्री'), "ListAdjustments", 'सूची समायोजन'), "ListTransfers", 'सूची स्थानांतरण'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'स्थानांतरण बनाएँ'), "OrdersManager", 'आदेश प्रबंधन'), "ListQuotations", 'सूची उद्धरण'), "ListPurchases", 'सूची खरीद'), "ListSales", 'सूची बिक्री'), "ListReturns", 'सूची रिटर्न'), "PeopleManager", 'जन प्रबंधन'), "Delete", {
  Title: 'क्या आपको यकीन है?',
  Text: 'आप इसे वापस नहीं कर पाएंगे!',
  confirmButtonText: 'हाँ, इसे हटा दें!',
  cancelButtonText: 'रद्द करना',
  Deleted: 'हटाए गए!',
  Failed: 'अनुत्तीर्ण होना!',
  Therewassomethingwronge: 'कुछ गड़बड़ थी',
  CustomerDeleted: 'इस ग्राहक को हटा दिया गया है।',
  SupplierDeleted: 'इस आपूर्तिकर्ता को हटा दिया गया है।',
  QuoteDeleted: 'यह उद्धरण हटा दिया गया है।',
  SaleDeleted: 'यह बिक्री हटा दी गई है।',
  PaymentDeleted: 'यह भुगतान हटा दिया गया है।',
  PurchaseDeleted: 'यह खरीद हटा दी गई है।',
  ReturnDeleted: 'यह रिटर्न हटा दिया गया है।',
  ProductDeleted: 'this Product has been deleted.',
  ClientError: 'यह क्लाइंट पहले से ही अन्य ऑपरेशन से जुड़ा हुआ है',
  ProviderError: 'यह आपूर्तिकर्ता पहले से ही अन्य ऑपरेशन से जुड़ा हुआ है',
  UserDeleted: 'यह उपयोगकर्ता हटा दिया गया है।',
  UnitDeleted: 'यह इकाई हटा दी गई है।',
  RoleDeleted: 'यह भूमिका हटा दी गई है।',
  TaxeDeleted: 'यह कर हटा दिया गया है।',
  SubCatDeleted: 'यह उप श्रेणी हटा दी गई है।',
  CatDeleted: 'यह श्रेणी हटा दी गई है।',
  WarehouseDeleted: 'यह वेयरहाउस हटा दिया गया है।',
  AlreadyLinked: 'यह उत्पाद पहले से ही अन्य ऑपरेशन से जुड़ा हुआ है',
  AdjustDeleted: 'यह समायोजन हटा दिया गया है।',
  TitleCurrency: 'यह मुद्रा हटा दी गई है।',
  TitleTransfer: 'स्थानांतरण सफलतापूर्वक हटा दिया गया है',
  BackupDeleted: 'बैकअप सफलतापूर्वक निकाल दिया गया है',
  TitleBrand: 'यह ब्रांड हटा दिया गया है'
}), "Update", {
  TitleProfile: 'आपका प्रोफ़ाइल सफलतापूर्वक में अपडेट किया गया',
  TitleAdjust: 'समायोजन सफलतापूर्वक में अद्यतन किया गया',
  TitleRole: 'सफलतापूर्वक में भूमिका निभाई',
  TitleUnit: 'यूनिट को सफलतापूर्वक अपडेट किया गया',
  TitleUser: 'उपयोगकर्ता को सफलतापूर्वक अपडेट किया गया',
  TitleCustomer: 'सफलतापूर्वक ग्राहक अपडेट',
  TitleQuote: 'उद्धरण सफलतापूर्वक अपडेट किया गया',
  TitleSale: 'सफलतापूर्वक बिक्री की गई',
  TitlePayment: 'भुगतान सफलतापूर्वक में अपडेट किया गया',
  TitlePurchase: 'सफलतापूर्वक में अद्यतन किया गया',
  TitleReturn: 'सफलतापूर्वक में नवीनीकृत करें',
  TitleProduct: 'उत्पाद अद्यतन सफलतापूर्वक',
  TitleSupplier: 'आपूर्तिकर्ता सफलतापूर्वक में अद्यतन किया गया',
  TitleTaxe: 'कर अद्यतन सफलतापूर्वक',
  TitleCat: 'कर अद्यतन सफलतापूर्वक',
  TitleWarhouse: 'वेयरहाउस अद्यतन सफलतापूर्वक',
  TitleSetting: 'सेटिंग्स को सफलतापूर्वक में अपडेट किया गया',
  TitleCurrency: 'मुद्रा अद्यतन सफलतापूर्वक',
  TitleTransfer: 'सफलतापूर्वक में स्थानांतरण',
  TitleBrand: 'यह ब्रांड अद्यतन किया गया है'
}), "Create", {
  TitleBrand: 'इस ब्रांड को बनाया गया है',
  TitleRole: 'भूमिका सफलतापूर्वक बनाई गई',
  TitleUnit: 'यूनिट सफलतापूर्वक बनाई गई',
  TitleUser: 'उपयोगकर्ता सफलतापूर्वक बनाया गया',
  TitleCustomer: 'सफलतापूर्वक बनाया गया ग्राहक',
  TitleQuote: 'उद्धरण सफलतापूर्वक बनाया गया',
  TitleSale: 'बिक्री सफलतापूर्वक बनाई गई',
  TitlePayment: 'भुगतान सफलतापूर्वक किया गया',
  TitlePurchase: 'सफलतापूर्वक खरीदी गई',
  TitleReturn: 'वापसी सफलतापूर्वक बनाई गई',
  TitleProduct: 'उत्पाद सफलतापूर्वक बनाया गया',
  TitleSupplier: 'आपूर्तिकर्ता सफलतापूर्वक बनाया गया',
  TitleTaxe: 'टैक्स सफलतापूर्वक बनाया गया',
  TitleCat: 'श्रेणी सफलतापूर्वक बनाई गई',
  TitleWarhouse: 'वेयरहाउस सफलतापूर्वक बनाया गया',
  TitleAdjust: 'समायोजन सफलतापूर्वक में बनाया गया',
  TitleCurrency: 'मुद्रा सफलतापूर्वक बनाई गई',
  TitleTransfer: 'सफलतापूर्वक में बनाया गया स्थानांतरण'
}), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'ईमेल सफलतापूर्वक भेजें'
}), "return", {
  TitleSale: 'यह बिक्री पहले ही एक रिटर्न के साथ जुड़ी हुई है!'
}), "ReturnManagement", 'वापसी प्रबंधन'), "ReturnDetail", 'विस्तार से लौटें'), "EditReturn", 'वापसी संपादित करें'), "AddReturn", 'रिटर्न बनाएँ'), "EmailReturn", 'ईमेल में रिटर्न भेजें'), "DeleteReturn", 'रिटर्न डिलीट करें'), "Retoursurcharge", 'सरचार्ज वापस करें'), "Laivrison", 'वितरण'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectSale", 'बिक्री का चयन करें'), "ZeroPardefault", 'आप आइटम को हटा सकते हैं या यदि वह वापस नहीं किया गया है तो शून्य पर वापस सेट की गई मात्रा सेट कर सकते हैं'), "Return", 'वापसी'), "Purchase", 'खरीद फरोख्त'), "TotalSales", 'संपूर्ण बिक्री'), "TotalPurchases", 'कुल खरीद'), "TotalReturns", 'कुल रिटर्न'), "PaiementsNet", 'नेट भुगतान'), "PaiementsSent", 'भुगतान भेजा गया'), "PaiementsReceived", 'भुगतान प्राप्त किया'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Recieved", 'प्राप्त किया'), "Sent", 'भेज दिया'), "ProductQuantityAlerts", 'उत्पाद मात्रा अलर्ट'), "ProductCode", 'कोड'), "ProductName", 'उत्पाद'), "AlertQuantity", 'चेतावनी मात्रा'), "WarehouseStockChart", 'गोदाम स्टॉक चार्ट'), "TotalProducts", 'कुल उत्पाद'), "TotalQuantity", 'कुल मात्रा'), "TopCustomers", 'शीर्ष पांच ग्राहक'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'कुल रकम'), "TotalPaid", 'कुल भुगतान हो गया'), "CustomerSalesReport", 'ग्राहक बिक्री रिपोर्ट'), "CustomerPaiementsReport", 'ग्राहक बिक्री रिपोर्ट'), "CustomerQuotationsReport", 'ग्राहक उद्धरण रिपोर्ट'), "Payments", 'भुगतान'), "TopSuppliers", 'शीर्ष पांच आपूर्तिकर्ता'), "SupplierPurchasesReport", 'आपूर्तिकर्ता खरीद रिपोर्ट'), "SupplierPaiementsReport", 'आपूर्तिकर्ता भुगतान रिपोर्ट'), "Name", 'नाम'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Code", 'कोड'), "ManagementWarehouse", 'गोदाम प्रबंधन'), "ZipCode", 'पिन कोड'), "managementCategories", 'श्रेणियाँ प्रबंधन'), "Codecategorie", 'कोड श्रेणी'), "Namecategorie", 'नाम श्रेणी'), "Parentcategorie", 'अभिभावक श्रेणी'), "managementTax", 'कर प्रबंधन'), "TaxName", 'कर का नाम'), "TaxRate", 'कर दर'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'क्रय इकाई'), "managementUnitSales", 'विक्रय इकाई'), "ShortName", 'संक्षिप्त नाम'), "PleaseSelectThesebeforeaddinganyproduct", 'कृपया किसी भी उत्पाद को जोड़ने से पहले इनका चयन करें'), "StockAdjustement", 'स्टॉक समायोजन'), "PleaseSelectWarehouse", 'कृपया किसी भी उत्पाद को चुनने से पहले गोदाम का चयन करें'), "StockTransfer", 'स्टाक ट्रान्स्फ़र'), "SelectPeriod", 'अवधि का चयन करें'), "ThisYear", 'इस साल'), "ThisToday", 'यह आज'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'इस महीने'), "ThisWeek", 'इस सप्ताह'), "AdjustmentDetail", 'समायोजन विवरण'), "ActivateUser", 'इस उपयोगकर्ता को सक्रिय किया गया है'), "DisActivateUser", 'इस उपयोगकर्ता को निष्क्रिय कर दिया गया है'), "NotFound", 'पृष्ठ नहीं मिला।'), "oops", 'त्रुटि! पृष्ठ नहीं मिला।'), "couldNotFind", 'आपको वह पृष्ठ नहीं मिला, जिसकी आप तलाश कर रहे थे। इसके अलावा, आप कर सकते हैं'), "ReturnDashboard", 'डैशबोर्ड पर लौटें'), "hrm", 'एचआरएम'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Employees", 'कर्मचारियों'), "Attendance", 'उपस्थिति'), "Leave_request", 'छुट्टी का अनुरोध'), "Leave_type", 'छुट्टी का प्रकार'), "Company", 'कंपनी'), "Departments", 'विभागों'), "Designations", 'पदनाम'), "Office_Shift", 'कार्यालय शिफ्ट'), "Holidays", 'छुट्टियां'), "Enter_Company_Name", 'कंपनी का नाम दर्ज करें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'ईमेल पता दर्ज'), "Enter_Company_Phone", 'कंपनी फोन दर्ज करें'), "Enter_Company_Country", 'कंपनी देश दर्ज करें'), "Created_in_successfully", 'सफलतापूर्वक बनाया गया'), "Updated_in_successfully", 'सफलतापूर्वक अपडेट किया गया'), "Deleted_in_successfully", 'सफलतापूर्वक हटा दिया गया'), "department", 'विभाग'), "Enter_Department_Name", 'विभाग का नाम दर्ज करें'), "Choose_Company", 'कंपनी चुनें'), "Department_Head", 'विभाग के प्रमुख'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'विभाग प्रमुख चुनें'), "Enter_Shift_name", 'शिफ्ट का नाम दर्ज करें'), "Monday_In", 'Monday In'), "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'छुट्टी'), "Enter_title", 'शीर्षक दर्ज करें'), "title", 'शीर्षक'), "start_date", 'आरंभ करने की तिथि'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'प्रारंभ तिथि दर्ज करें'), "Finish_Date", 'समाप्ति अवधि'), "Enter_Finish_date", 'समाप्ति तिथि दर्ज करें'), "Please_provide_any_details", 'कृपया कोई विवरण प्रदान करें'), "Attendances", 'उपस्थिति'), "Enter_Attendance_date", 'उपस्थिति तिथि दर्ज करें'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", 'कर्मचारी चुनें'), "Employee", 'कर्मचारी'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'कार्य अवधि'), "remaining_leaves_are_insufficient", 'शेष पत्ते अपर्याप्त'), "Leave_Type", 'छुट्टी का प्रकार'), "Days", 'दिन'), "Department", 'विभाग'), "Choose_leave_type", 'छुट्टी का प्रकार चुनें'), "Choose_status", 'स्थिति चुनें'), "Leave_Reason", 'कारण छोड़ें'), "Enter_Reason_Leave", 'कारण छुट्टी दर्ज करें'), "Add_Employee", 'कर्मचारी जोड़ें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FirstName", 'पहला नाम'), "Enter_FirstName", 'प्रथम नाम दर्ज करें'), "LastName", 'अंतिम नाम'), "Enter_LastName", 'अंतिम नाम दर्ज करो'), "Gender", 'लिंग'), "Choose_Gender", 'लिंग चुनें'), "Enter_Birth_date", 'जन्म तिथि दर्ज करें'), "Birth_date", 'जन्म दिन'), "Enter_Country", 'देश दर्ज करें'), "Enter_Phone_Number", 'फोन नंबर दर्ज'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "joining_date", 'में शामिल होने की तारीख'), "Enter_joining_date", 'शामिल होने की तिथि दर्ज करें'), "Choose_Designation", 'पदनाम चुनें'), "Designation", 'पदनाम'), "Office_Shift", 'कार्यालय शिफ्ट'), "Choose_Office_Shift", 'ऑफिस शिफ्ट चुनें'), "Enter_Leaving_Date", 'प्रस्थान तिथि दर्ज करें'), "Leaving_Date", 'प्रस्थान तिथि'), "Annual_Leave", 'वार्षिक छुट्टी'), "Enter_Annual_Leave", 'वार्षिक अवकाश दर्ज करें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'शेष छुट्टी'), "Employee_Details", 'कर्मचारी विवरण'), "Basic_Information", 'मूल जानकारी'), "Family_status", 'पारिवारिक स्थिति'), "Choose_Family_status", 'पारिवारिक स्थिति चुनें'), "Employment_type", 'रोजगार के प्रकार'), "Select_Employment_type", 'रोजगार प्रकार चुनें'), "Enter_City", 'शहर दर्ज करें'), "Province", 'प्रांत'), "Enter_Province", 'प्रांत दर्ज करें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'पता लिखिए'), "Enter_Zip_code", 'ज़िप कोड दर्ज करें'), "Zip_code", 'पिन कोड'), "Hourly_rate", 'प्रति घंटा - दर'), "Enter_Hourly_rate", 'प्रति घंटा दर दर्ज करें'), "Basic_salary", 'मूल वेतन'), "Enter_Basic_salary", 'मूल वेतन दर्ज करें'), "Social_Media", 'सामाजिक मीडिया'), "Skype", 'स्काइप'), "Enter_Skype", 'स्काइप दर्ज करें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Facebook", 'फेसबुक'), "Enter_Facebook", 'फेसबुक दर्ज करें'), "WhatsApp", 'व्हाट्सएप'), "Enter_WhatsApp", 'व्हाट्सएप दर्ज करें'), "LinkedIn", 'लिंक्डइन'), "Enter_LinkedIn", 'लिंक्डइन दर्ज करें'), "Twitter", 'ट्विटर'), "Enter_Twitter", 'ट्विटर दर्ज करें'), "Experiences", 'अनुभवों'), "bank_account", 'बैंक खाता'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Company_Name", 'कंपनी का नाम'), "Location", 'स्थान'), "Enter_location", 'स्थान दर्ज करें'), "Enter_Description", 'विवरण दर्ज करें'), "Bank_Name", 'बैंक का नाम'), "Enter_Bank_Name", 'बैंक का नाम दर्ज करें'), "Bank_Branch", 'बैंक शाखा'), "Enter_Bank_Branch", 'बैंक शाखा दर्ज करें'), "Bank_Number", 'बैंक नंबर'), "Enter_Bank_Number", 'बैंक नंबर दर्ज करें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'असाइन किए गए वेयरहाउस'), "Top_customers", 'शीर्ष ग्राहक'), "Attachment", 'अटैचमेंट'), "view_employee", 'कर्मचारियों को देखें'), "edit_employee", 'कर्मचारियों को संपादित करें'), "delete_employee", 'कर्मचारियों को हटाएं'), "Created_by", 'द्वारा जोड़ा'), "Add_product_IMEI_Serial_number", 'उत्पाद IMEI/सीरियल नंबर जोड़ें'), "Product_Has_Imei_Serial_number", 'उत्पाद में Imei/सीरियल नंबर है'), "IMEI_SN", 'IMEI/SN'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Shipments", 'लदान'), "delivered_to", 'को पहुंचा दिया गया'), "shipment_ref", 'शिपमेंट रेफरी'), "sale_ref", 'बिक्री संदर्भ'), "Edit_Shipping", 'शिपिंग संपादित करें'), "Packed", 'पैक्ड'), "Shipped", 'लादा गया'), "Delivered", 'पहुंचा दिया'), "Cancelled", 'रद्द'), "Shipping_status", 'शिपिंग की स्थिति'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users_Report", 'उपयोगकर्ता रिपोर्ट'), "stock_report", 'स्टॉक रिपोर्ट'), "TotalPurchases", 'कुल खरीद'), "Total_quotations", 'कुल कोटेशन'), "Total_return_sales", 'कुल वापसी बिक्री'), "Total_return_purchases", 'कुल वापसी खरीद'), "Total_transfers", 'कुल स्थानान्तरण'), "Total_adjustments", 'कुल समायोजन'), "User_report", 'उपयोगकर्ता रिपोर्ट'), "Current_stock", 'वर्तमान स्टॉक'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_name", 'प्रोडक्ट का नाम'), "Total_Customers_Due", 'कुल ऋण'), "Total_Suppliers_Due", 'कुल ऋण'), "Some_warehouses", 'कुछ गोदाम'), "All_Warehouses", 'सभी गोदाम'), "Product_Cost", 'सामान का मूल्य'), "sms_settings", 'एसएमएस सेटिंग्स'), "pos_settings", 'पीओएस सेटिंग्स'), "payment_gateway", 'भुगतान गेटवे'), "mail_settings", 'मेल सेटिंग्स'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'डिफ़ॉल्ट एसएमएस गेटवे'), "module_settings", 'मॉड्यूल सेटिंग्स'), "Module_enabled_success", 'मॉड्यूल सफलतापूर्वक सक्षम किया गया'), "Module_Disabled_success", 'मॉड्यूल सफलतापूर्वक अक्षम किया गया'), "update_settings", 'सेटिंग अपडेट करें'), "Please_Upload_the_Correct_Module", 'कृपया सही मॉड्यूल अपलोड करें'), "Uploaded_Success", 'सफलतापूर्वक अपलोड किया गया'), "Customer_details", 'ग्राहक विवरण'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'ग्राहक संपादित करें'), "Delete_Customer", 'ग्राहक हटाएं'), "Pay_Due", 'बकाया भुगतान करें'), "Paying_amount_is_greater_than_Total_Due", 'भुगतान राशि कुल देय राशि से अधिक है'), "Customer_Invoice", 'ग्राहक का बिल'), "This_Product_Not_For_Selling", 'यह उत्पाद बेचने के लिए नहीं'), "Welcome_to_your_Dashboard", 'आपके डैशबोर्ड में आपका स्वागत है'), "Total_Payable", 'कुल देय'), "Choose_Sale_Ref", 'बिक्री रेफरी चुनें'), "Please_Select_Sale", 'कृपया बिक्री का चयन करें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'बिक्री संदर्भ'), "list_product_returns", 'सूची उत्पाद रिटर्न'), "Qty_return", 'मात्रा वापसी'), "Choose_Purchase_Ref", 'खरीद रेफरी चुनें'), "Purchase_Ref", 'खरीद संदर्भ'), "please_select_purchase", 'कृपया खरीद का चयन करें'), "qty_return_is_greater_than_qty_purchased", 'मात्रा वापसी खरीदी गई मात्रा से अधिक है'), "qty_return_is_greater_than_qty_sold", 'मात्रा वापसी बेची गई मात्रा से अधिक है'), "Quantity_sold", 'बेची गई मात्रा'), "qty_purchased", 'खरीदी गई मात्रा'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'भेजने वाले का नाम'), "The_module_must_be_uploaded_as_zip_file", 'मॉड्यूल को ज़िप फ़ाइल के रूप में अपलोड किया जाना चाहिए'), "Upload_Module", 'मॉड्यूल अपलोड करें'), "All_Modules_Installed", 'सभी मॉड्यूल स्थापित'), "Current_Version", 'वर्तमान संस्करण'), "You_already_have_the_latest_version", 'आपके पास पहले से ही नवीनतम संस्करण है'), "Update_Available", 'उपलब्ध अद्यतन'), "Update_Log", 'लॉग अपडेट करें'), "Update_Now", 'अभी अद्यतन करें'), "View_Change_Log", 'परिवर्तन लॉग देखें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'चालान पाद लेख'), "Please_Wait_for_the_update", 'नोट: कृपया अपडेट के पूरी तरह से समाप्त होने की प्रतीक्षा करें। ब्राउज़र को बंद करने या किसी प्रक्रिया को रोकने की अनुशंसा नहीं की जाती है अपग्रेड'), "Note_update", 'नोट: सुनिश्चित करें कि आप अपग्रेड चलाने से पहले अपने वर्तमान संस्करण और डेटाबेस का बैकअप लें, यदि कोई त्रुटि है तो इसे पुनर्स्थापित करने के लिए'), "Time_Zone", 'समय क्षेत्र'), "Payment_note", 'भुगतान के नोट'), "sale_note", 'बिक्री नोट'), "Total_Sale_Due", 'कुल बिक्री कर्ज'), "Total_Sell_Return_Due", 'कुल बिक्री वापसी ऋण'), "pay_all_sell_due_at_a_time", 'एक बार में सभी बिक्री ऋण का भुगतान करें'), "pay_all_sell_return_due_at_a_time", 'एक बार में सभी बिक्री रिटर्न ऋण का भुगतान करें'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'सकल लाभ'), "pay_all_purchase_due_at_a_time", 'एक बार में सभी खरीद ऋण का भुगतान करें'), "Delete_Provider", 'प्रदाता हटाएं'), "Edit_Provider", 'प्रदाता संपादित करें'), "Provider_details", 'प्रदाता विवरण'), "Total_Purchase_Due", 'कुल खरीद कर्ज'), "Provider_Credit_Note", 'क्रेडिट नोट'), "Customer_Credit_Note", 'क्रेडिट नोट'), "Sell_Return", 'वापसी बेचें'), "Purchase_Return", 'खरीद रिटर्न'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'कर संख्या'), "Please_add_return_quantity", 'कृपया वापसी मात्रा जोड़ें'), "Return_exist_for_the_Transaction", 'लेन-देन के लिए वापसी मौजूद है'), "qty_return_is_greater_than_Quantity_Remaining", 'मात्रा का रिटर्न शेष मात्रा से अधिक है'), "products_refunded_alert", '0 पर सेट की गई मात्रा वाले किसी भी उत्पाद की धन-वापसी नहीं की जाएगी'), "pay_all_purchase_return_due_at_a_time", 'एक बार में सभी खरीद रिटर्न ऋण का भुगतान करें'), "Total_Purchase_Return_Due", 'कुल खरीद वापसी ऋण'), "Purchase_return_due", 'खरीद वापसी देय'), "Sell_return_due", 'रिटर्न कर्ज बेचें'), "product_report", 'उत्पाद रिपोर्ट'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'उत्पाद की बिक्री रिपोर्ट'), "Product_purchases_report", 'उत्पाद खरीद रिपोर्ट'), "Qty_sold", 'मात्रा बेची गई'), "Qty_purchased", 'खरीदी गई मात्रा'), "Filter_by_warehouse", 'गोदाम द्वारा फ़िल्टर करें'), "Enable_Print_Invoice", 'चालान स्वचालित रूप से प्रिंट करें'), "Show_Warehouse", 'गोदाम देखें'), "credit_card_info", 'क्रेडिट कार्ड की जानकारी'), "Saved_Credit_Card_Info", 'सहेजी गई क्रेडिट कार्ड की जानकारी'), "Credit_card_changed_successfully", 'क्रेडिट कार्ड सफलतापूर्वक बदल दिया गया'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "notification_template", 'सूचना टेम्पलेट'), "email_notification", 'ईमेल सूचना'), "sms_notification", 'एसएमएस सूचना'), "Change_product_details", 'उत्पाद विवरण बदलें'), "edit_tax_and_discount_and_shipping", 'टैक्स, डिस्काउंट और शिपिंग को संपादित करें'), "Create_Quotation_with_Stock", 'स्टॉक के साथ कोटेशन बनाएं'), "Variant_Name", 'वेरिएंट का नाम'), "Variant_cost", 'वेरिएंट का खर्च'), "Variant_price", 'वेरिएंट का मूल्य'), "Variant_code", 'वेरिएंट कोड'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'कृपया उत्पाद लोड होने तक प्रतीक्षा करें'), "Choose_SMS_Gateway", 'एसएमएस गेटवे चुनें'), "Notification_Client", 'ग्राहक को सूचित करना'), "Available_Tags", 'उपलब्ध टैग'), "Email_Subject", 'ईमेल विषय'), "Email_body", 'ईमेल शरीर'), "Notification_Supplier", 'आपूर्तिकर्ता को सूचित करना'), "sms_body", 'एसएमएस शरीर'), "sms_templates", 'एसएमएस टेम्पलेट्स'), "email_templates", 'ईमेल टेम्पलेट्स'));

/***/ }),

/***/ "./resources/src/translations/locales/it.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/it.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Italien

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Ricevuta',
  Pos_Settings: 'Impostazioni punto vendita',
  Note_to_customer: 'Nota per il cliente',
  Show_Note_to_customer: 'Mostra nota al cliente',
  Show_barcode: 'Mostra il codice a barre',
  Show_Tax_and_Discount: 'Mostra tasse e sconti e spedizione',
  Show_Customer: 'Mostra cliente',
  Show_Email: 'Mostra e-mail',
  Show_Phone: 'Mostra telefono',
  Show_Address: 'Mostra indirizzo',
  DefaultLanguage: 'Lingua di default',
  footer: 'piè di pagina',
  Received_Amount: 'Importo ricevuto',
  Paying_Amount: 'Importo da pagare',
  Change: 'Modificare',
  Paying_amount_is_greater_than_Received_amount: 'L\'importo del pagamento è maggiore dell\'importo ricevuto',
  Paying_amount_is_greater_than_Grand_Total: 'L\'importo del pagamento è maggiore del totale complessivo',
  code_must_be_not_exist_already: 'il codice non deve esistere già',
  You_will_find_your_backup_on: 'Troverai il tuo backup su',
  and_save_it_to_your_pc: 'e salvalo sul tuo pc',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Scansiona il tuo codice a barre e seleziona la simbologia corretta di seguito',
  Scan_Search_Product_by_Code_Name: 'Scansione/ricerca prodotto per nome in codice',
  Paper_size: 'Dimensioni del foglio',
  Clear_Cache: 'Cancella cache',
  Cache_cleared_successfully: 'Cache cancellata con successo',
  Failed_to_clear_cache: 'Impossibile svuotare la cache',
  Scan_Barcode: 'Scanner di codici a barre',
  Please_use_short_name_of_unit: 'Si prega di utilizzare il nome breve dell\'unità',
  DefaultCustomer: 'Cliente predefinito',
  DefaultWarehouse: 'Magazzino predefinito',
  Payment_Gateway: 'Casello stradale',
  SMS_Configuration: 'Configurazione SMS',
  Gateway: 'Casello stradale',
  Choose_Gateway: 'Scegli Payment Gateway',
  Send_SMS: 'messaggio inviato con successo',
  sms_config_invalid: 'configurazione sms errata non valida',
  Remove_Stripe_Key_Secret: 'Elimina le chiavi API Stripe',
  credit_card_account_not_available: 'Conto della carta di credito non disponibile',
  Credit_Card_Info: 'Informazioni sulla carta di credito',
  developed_by: 'Sviluppato da',
  Unit_already_linked_with_sub_unit: 'Unità già abbinata a sottounità',
  Total_Items_Quantity: 'Articoli totali e quantità',
  Value_by_Cost_and_Price: 'Valore per costo e prezzo',
  Search_this_table: 'Cerca in questa tabella',
  import_products: 'Importa prodotti',
  Field_optional: 'Campo facoltativo',
  Download_exemple: 'Scarica esempio',
  field_must_be_in_csv_format: 'Il campo deve essere in formato csv',
  Successfully_Imported: 'Importato con successo',
  file_size_must_be_less_than_1_mega: 'La dimensione del file deve essere inferiore a 1 mega',
  Please_follow_the_import_instructions: 'Segui le istruzioni per l\'importazione',
  must_be_exist: 'l\'unità deve essere già creata',
  Import_Customers: 'Importa clienti',
  Import_Suppliers: 'Fornitori di importazione',
  Recent_Sales: 'Vendite recenti',
  Create_Transfer: 'Crea trasferimento',
  order_products: 'articoli dell\'ordine',
  Search_Product_by_Code_Name: 'Cerca prodotto per codice o nome',
  Reports_payments_Purchase_Return: 'Rapporti sui pagamenti dei resi di acquisto',
  Reports_payments_Sale_Return: 'Rapporti sui pagamenti dei resi di vendita',
  payments_Sales_Return: 'ritorno delle vendite dei pagamenti',
  payments_Purchases_Return: 'ritorno acquisti pagamenti',
  CreateSaleReturn: 'Crea reso vendita',
  EditSaleReturn: 'Modifica reso vendita',
  SalesReturn: 'Reso di vendita',
  CreatePurchaseReturn: 'Crea reso acquisto',
  EditPurchaseReturn: 'Modifica reso acquisto',
  PurchasesReturn: 'Restituzione acquisti',
  Due: 'dovuto',
  Profit: 'Profitto',
  Revenue: 'Reddito',
  Sales_today: 'Vendite oggi',
  People: 'Persone',
  Successfully_Created: 'Creato con successo',
  Successfully_Updated: 'Aggiornato con successo',
  Success: 'Successo',
  Failed: 'Fallito',
  Warning: 'avvertimento',
  Please_fill_the_form_correctly: 'Si prega di compilare correttamente il modulo',
  Field_is_required: 'Il campo è obbligatiorio',
  Error: 'Errore!',
  you_are_not_authorized: 'Scusate! non sei autorizzato.',
  Go_back_to_home: 'Torna alla home page',
  page_not_exist: 'Scusate! La pagina che stavi cercando non esiste.',
  Choose_Status: 'Scegli Stato',
  Choose_Method: 'Scegli il metodo',
  Choose_Symbology: 'Scegli la simbologia',
  Choose_Category: 'Scegli la categoria',
  Choose_Customer: 'Scegli cliente',
  Choose_Supplier: 'Scegli fornitore',
  Choose_Unit_Purchase: 'Scegli unità di acquisto',
  Choose_Sub_Category: 'Scegli Sottocategoria',
  Choose_Brand: 'Scegli il marchio',
  Choose_Warehouse: 'Scegli Magazzino',
  Choose_Unit_Sale: 'Scegli unità di vendita',
  Enter_Product_Cost: 'Immettere il costo del prodotto',
  Enter_Stock_alert: 'Inserisci avviso di stock',
  Choose_Unit_Product: 'Scegli unità di prodotto',
  Enter_Product_Price: 'Immettere il prezzo del prodotto',
  Enter_Name_Product: 'Immettere il nome del prodotto',
  Enter_Role_Name: 'Immettere il nome del ruolo',
  Enter_Role_Description: 'Immettere la descrizione del ruolo',
  Enter_name_category: 'Immettere il nome della categoria',
  Enter_Code_category: 'Immettere il codice della categoria',
  Enter_Name_Brand: 'Immettere il nome del marchio',
  Enter_Description_Brand: 'Immettere il marchio della descrizione',
  Enter_Code_Currency: 'Immettere la valuta del codice',
  Enter_name_Currency: 'Immettere il nome Valuta',
  Enter_Symbol_Currency: 'Immettere la valuta del simbolo',
  Enter_Name_Unit: 'Immettere il nome dell\'unità',
  Enter_ShortName_Unit: 'Immettere il nome abbreviato Unità',
  Choose_Base_Unit: 'Scegli unità base',
  Choose_Operator: 'Scegli operatore',
  Enter_Operation_Value: 'Immettere il valore dell\'operazione',
  Enter_Name_Warehouse: 'Immettere il nome del magazzino',
  Enter_Phone_Warehouse: 'Inserisci il numero di telefono del magazzino',
  Enter_Country_Warehouse: 'Immettere il Paese magazzino',
  Enter_City_Warehouse: 'Inserisci la città del magazzino',
  Enter_Email_Warehouse: 'Inserisci l\'email del magazzino',
  Enter_ZipCode_Warehouse: 'Inserisci il codice postale del magazzino',
  Choose_Currency: 'Scegli Valuta',
  Thank_you_for_your_business: 'Grazie per il tuo business!',
  Cancel: 'Annulla',
  New_Customer: 'Nuovo cliente',
  Incorrect_Login: 'Accesso errato',
  Successfully_Logged_In: 'Accesso eseguito con successo',
  This_user_not_active: 'Questo utente non è attivo',
  SignIn: 'Registrati',
  Create_an_account: 'Crea un account',
  Forgot_Password: 'Ha dimenticato la password ?',
  Email_Address: 'Indirizzo e-mail',
  SignUp: 'Iscriviti',
  Already_have_an_account: 'Hai già un account ?',
  Reset_Password: 'Resetta la password',
  Failed_to_authenticate_on_SMTP_server: 'Autenticazione sul server SMTP non riuscita',
  We_cant_find_a_user_with_that_email_addres: 'Non riusciamo a trovare un utente con quell\'indirizzo email',
  We_have_emailed_your_password_reset_link: 'Abbiamo inviato per e-mail il tuo link per la reimpostazione della password',
  Please_fill_the_Email_Adress: 'Si prega di compilare l\'indirizzo e-mail',
  Confirm_password: 'Conferma password',
  Your_Password_has_been_changed: 'La tua password è stata modificata',
  The_password_confirmation_does_not_match: 'La conferma della password non corrisponde',
  This_password_reset_token_is_invalid: 'Questo token di reimpostazione della password non è valido',
  Warehouse_report: 'Rapporto di magazzino',
  All_Warehouses: 'Tutti i magazzini',
  Expense_List: 'Lista delle spese',
  Expenses: 'Spese',
  This_Week_Sales_Purchases: 'Vendite e acquisti di questa settimana',
  Top_Selling_Products: 'Prodotti più venduti',
  View_all: 'Mostra tutto',
  Payment_Sent_Received: 'Pagamento inviato e ricevuto',
  Filter: 'Filtro',
  Invoice_POS: 'Fattura POS',
  Invoice: 'Fattura',
  Customer_Info: 'Info clienti',
  Company_Info: 'azienda Info',
  Invoice_Info: 'Info fattura',
  Order_Summary: 'Riepilogo ordine',
  Quote_Info: 'Info quotazione',
  Del: 'Elimina',
  SuppliersPaiementsReport: 'Report pagamenti fornitori',
  Purchase_Info: 'Informazioni sull\'acquisto',
  Supplier_Info: 'Informazioni sul fornitore',
  Return_Info: 'informazioni di ritorno',
  Expense_Category: 'Categoria di spesa',
  Create_Expense: 'Crea spesa',
  Details: 'Dettagli',
  Discount_Method: 'Metodo di sconto',
  Net_Unit_Cost: 'Costo unitario netto',
  Net_Unit_Price: 'Prezzo unitario netto',
  Edit_Expense: 'Modifica spesa',
  All_Brand: 'Tutto il marchio',
  All_Category: 'Tutte le categorie',
  ListExpenses: 'Elenco delle spese',
  Create_Permission: 'Crea autorizzazione',
  Edit_Permission: 'Modifica autorizzazione',
  Reports_payments_Sales: 'Segnala i pagamenti delle vendite',
  Reports_payments_Purchases: 'Segnala pagamenti acquisti',
  Reports_payments_Return_Customers: 'Segnala pagamenti Resi clienti',
  Reports_payments_Return_Suppliers: 'Segnala pagamenti Resi Fornitori',
  Expense_Deleted: 'Questa spesa è stata cancellata',
  Expense_Updated: 'Questa spesa è stata aggiornata',
  Expense_Created: 'Questa spesa è stata creata',
  DemoVersion: 'Non puoi farlo nella versione demo',
  Filesize: 'Dimensione del file',
  GenerateBackup: 'Genera backup',
  BackupDatabase: 'Backup del database',
  Backup: 'Backup del database',
  OrderStatistics: 'Statistiche di vendita',
  AlreadyAdd: 'Este producto ya está agregado',
  AddProductToList: 'Agregue el producto a la lista',
  AddQuantity: 'Por favor agregue la cantidad',
  InvalidData: 'Datos inválidos',
  LowStock: 'la quantità supera la quantità disponibile in magazzino',
  WarehouseIdentical: 'Los dos repositorios no pueden ser idénticos',
  VariantDuplicate: 'Esta variable es redundante',
  Paid: 'Pagato',
  Unpaid: 'Non pagato',
  IncomeExpenses: 'Entrate e uscite',
  dailySalesPurchases: 'Vendite e acquisti giornalieri',
  ProductsExpired: 'Prodotti scaduti',
  Today: 'oggi',
  Income: 'Reddito'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'Spese'), "Sale", 'Vendita'), "Actif", 'Attivo'), "Inactif", 'Inattivo'), "Customers", 'I clienti'), "Phone", 'Telefono'), "SearchByPhone", 'Cerca per telefono'), "Suppliers", 'Fornitori'), "Quotations", 'Quotazione'), "Sales", 'I saldi'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'acquisti'), "Returns", 'ritorna'), "Settings", 'impostazioni'), "SystemSettings", 'Impostazioni di sistema'), "Users", 'utenti'), "GroupPermissions", 'Autorizzazioni di gruppo'), "Currencies", 'valute'), "Warehouses", 'magazzini'), "Units", 'unità'), "UnitsPrchases", 'Acquisti di unità'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Vendite di unità'), "Reports", 'Rapporti'), "PaymentsReport", 'Rapporto sui pagamenti'), "PaymentsPurchases", 'Pagamenti Acquisti'), "PaymentsSales", 'Vendite di pagamenti'), "ProfitandLoss", 'Profitti e perdite'), "WarehouseStockChart", 'Grafico azioni magazzino'), "SalesReport", 'Rapporto delle vendite'), "PurchasesReport", 'Rapporto d\'acquisto'), "CustomersReport", 'Rapporto dei clienti'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Rapporto fornitori'), "SupplierReport", 'Rapporto del fornitore'), "DailySalesData", 'Dati di vendita giornalieri'), "DailyPurchasesData", 'Dati di acquisto giornalieri'), "Derni\xE8rescinqrecords", 'Ultimi cinque record'), "Filters", 'filtri'), "date", 'Data'), "Reference", 'Riferimento'), "Supplier", 'Fornitore'), "PaymentStatus", 'Stato del pagamento'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", 'Cliente'), "CustomerCode", 'Codice Cliente'), "Status", 'Stato'), "SupplierCode", 'Codice fornitore'), "Categorie", 'Categoria'), "Categories", 'categorie'), "StockTransfers", 'Trasferimenti di azioni'), "StockManagement", 'Gestione delle scorte'), "dashboard", 'Pannello di controllo'), "Products", 'Prodotti'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'Elenco prodotti'), "ProductManagement", 'Gestione del prodotto'), "ProductQuantityAlerts", 'Avviso quantità prodotto'), "CodeProduct", 'Codice prodotto'), "ProductTax", 'Imposta sul prodotto'), "SubCategorie", 'sottocategoria'), "Name_product", 'Designazione'), "StockAlert", 'Avviso stock'), "warehouse", 'magazzino'), "Tax", 'Imposta'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Prezzo d\'acquisto'), "SellPrice", 'Prezzo di vendita'), "Quantity", 'Quantità'), "UnitSale", 'Vendita unitaria'), "UnitPurchase", 'Acquisto unitario'), "All", 'Tutti'), "EditProduct", 'Modifica prodotto'), "AddProduct", 'Aggiungi prodotto'), "SearchByCode", 'Cerca per codice'), "SearchByName", 'Ricerca per nome'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductDetails", 'Dettagli del prodotto'), "CustomerName", 'Nome del cliente'), "CustomerManagement", 'Gestione clienti'), "Add", 'Inserisci'), "add", 'Inserisci'), "Edit", 'modificare'), "Close", 'Vicino'), "PleaseSelect", 'Si prega di selezionare'), "Action", 'Azione'), "Email", 'E-mail'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditCustomer", 'Modifica cliente'), "AddCustomer", 'Aggiungi cliente'), "Country", 'Nazione'), "City", 'Città'), "Adress", 'Indirizzo'), "CustomerDetails", 'Dettagli cliente'), "CustomersList", 'Elenco clienti'), "SupplierCode", 'Codice fornitore'), "SupplierName", 'Nome del fornitore'), "SuppliersManagement", 'Gestione dei fornitori'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierDetails", 'Dettagli del fornitore'), "QuotationsManagement", 'Gestione delle quotazioni'), "SubTotal", 'totale parziale'), "MontantReste", 'Importo rimasto'), "complete", 'completare'), "EnAttendant", 'in attesa di'), "Recu", 'Ricevuto'), "partial", 'Parziale'), "Retournee", 'Ritorno'), "DetailQuote", 'Quotazione di dettaglio'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditQuote", 'Modifica Quotazione'), "CreateSale", 'Crea vendita'), "DownloadPdf", 'Scarica il pdf'), "QuoteEmail", 'Preventivo inviato via e-mail'), "DeleteQuote", 'Elimina Quotazione'), "AddQuote", 'Aggiungi Quotazione'), "SelectProduct", 'Seleziona prodotto'), "ProductCodeName", 'Prodotto (Codice - Nome)'), "Price", 'Prezzo'), "CurrentStock", 'Scorta'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Total", 'Totale'), "Num", 'N°'), "Unitcost", 'Costo unitario'), "to", 'per'), "Subject", 'Soggetto'), "Message", 'Messaggio'), "EmailCustomer", 'Email del cliente'), "Sent", 'Spedire'), "Quote", 'Quotazione'), "Hello", 'Ciao'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AttachmentQuote", 'Si prega di trovare l\'allegato per il preventivo'), "AddProducts", 'Aggiungi prodotti all\'elenco ordini'), "SelectWarehouse", 'Seleziona il magazzino'), "SelectCustomer", 'Seleziona cliente'), "SalesManagement", 'Direzione vendite'), "Balance", 'Equilibrio'), "QtyBack", 'Quantità ritorno'), "TotalReturn", 'Rendimento totale'), "Amount", 'somma'), "SaleDetail", 'Dettaglio di vendita'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditSale", 'Modifica vendita'), "AddSale", 'Aggiungi vendita'), "ShowPayment", 'Mostra pagamenti'), "AddPayment", 'Aggiungi pagamento'), "EditPayment", 'Modifica pagamento'), "EmailSale", 'Invia vendita via email'), "DeleteSale", 'Elimina vendita'), "ModePaiement", 'Modalità di pagamento'), "Paymentchoice", 'Scelta di pagamento'), "Note", 'Nota'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PaymentComplete", 'Pagamento completato!'), "PurchasesManagement", 'Gestione degli acquisti'), "Ordered", 'Ordinato'), "DeletePurchase", 'Elimina acquisto'), "EmailPurchase", 'Invia acquisto via e-mail'), "EditPurchase", 'Modifica acquisto'), "PurchaseDetail", 'Dettaglio d\'acquisto'), "AddPurchase", 'Aggiungi acquisto'), "EmailSupplier", 'Email del fornitore'), "PurchaseInvoice", 'Pagamenti acquisti'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PurchasesInvoicesData", 'Acquista i dati sui pagamenti'), "SalesInvoice", 'Pagamenti alle vendite'), "SalesInvoicesData", 'Dati di pagamento delle vendite'), "UserManagement", 'gestione degli utenti'), "Firstname", 'Nome di battesimo'), "lastname", 'cognome'), "username", 'NOME UTENTE'), "password", 'PASSWORD'), "Newpassword", 'Nuova password'), "ChangeAvatar", 'Cambia avatar'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "LeaveBlank", 'Si prega di lasciare vuoto questo campo se non è stato modificato'), "type", 'genere'), "UserPermissions", 'Autorizzazioni degli utenti'), "RoleName", 'Nome del ruolo'), "RoleDescription", 'Descrizione del ruolo'), "AddPermissions", 'Aggiungi autorizzazioni'), "View", 'Visualizza'), "Del", 'Elimina'), "NewAdjustement", 'Nuovo regolazione'), "EditAdjustement", 'Modifica regolazione'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CannotSubstraction", 'Non è possibile sottrarre prodotti con stock 0'), "Addition", 'aggiunta'), "Subtraction", 'Sottrazione'), "profil", 'profilo'), "logout", 'disconnettersi'), "PurchaseAlreadyPaid", 'non è possibile cambiare perché questo acquisto è già stato pagato'), "SaleAlreadyPaid", 'non puoi modificare perché questa vendita è già stata pagata'), "ReturnAlreadyPaid", 'non puoi modificare perché questa Ritorno è già stata pagata'), "QuoteAlready", 'Questa citazione ha già generato vendita'), "QuotationComplete", 'Questa citazione è completa'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SiteConfiguration", 'Configurazione del sito'), "Language", 'linguaggio'), "DefaultCurrency", 'Valuta predefinita'), "LoginCaptcha", 'Accedi Captcha'), "DefaultEmail", 'Email predefinita'), "SiteName", 'Nome del sito'), "ChangeLogo", 'Cambia logo'), "SMTPConfiguration", 'Configurazione SMTP'), "HOST", 'OSPITE'), "PORT", 'PORTA'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "encryption", 'crittografia'), "SMTPIncorrect", 'Configurazione SMTP errata'), "PaymentsReturns", 'Pagamenti di ritorno'), "ReturnsInvoices", 'fatture di ritorno'), "ReturnsInvoicesData", 'Dati di fatture di ritorno'), "ShowAll", 'Mostra tutti i record di tutti gli utenti'), "Discount", 'Sconto'), "OrderTax", 'Imposta sugli ordini'), "Shipping", 'spedizione'), "ManagementCurrencies", 'Valute di gestione'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CurrencyCode", 'Codice valuta'), "CurrencyName", 'Nome valuta'), "Symbol", 'Simbolo'), "CompanyName", 'Nome della ditta'), "CompanyPhone", 'Telefono aziendale'), "CompanyAdress", 'Indirizzo aziendale'), "Code", 'Codice'), "image", 'Immagine'), "Printbarcode", 'Stampa codice a barre'), "ReturnsCustomers", 'Vendite di ritorno'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Restituire gli acquisti'), "FactureReturnCustomers", 'fatture Vendite di reso'), "FactureReturnSuppliers", 'fatture Resi acquisti'), "NodataAvailable", 'Nessun dato disponibile'), "ProductImage", 'Immagine del prodotto'), "Barcode", 'codice a barre'), "pointofsales", 'punto vendita'), "CustomUpload", 'Caricamento personalizzato'), "pointofsaleManagement", 'Gestione punto vendita'), "Adjustment", 'Regolazione'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", 'Aggiornare'), "Reset", 'Ripristina'), "print", 'Stampa'), "SearchByEmail", 'Cerca per e-mail'), "ChooseProduct", 'Scegli il prodotto'), "Qty", 'Qtà'), "Items", 'Elementi'), "AmountHT", 'somma HT'), "AmountTTC", 'somma TTC'), "PleaseSelectSupplier", 'Seleziona il fornitore'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Seleziona lo stato'), "PayeBy", 'Pagato con'), "ChooseWarehouse", 'Scegli Magazzino'), "payNow", 'paga ora'), "ListofCategory", 'Elenco delle categorie'), "Description", 'Descrizione'), "submit", 'Invia'), "ProblemCreatingThisInvoice", 'Si è verificato un problema durante la creazione di questa fattura. Per favore riprova'), "ProblemPayment", 'Si è verificato un problema con il pagamento. Per favore riprova.'), "CreateAdjustment", 'Crea aggiustamento'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Afewwords", 'qualche parola in merito...'), "UserImage", 'Immagine dell\'utente'), "UpdateProduct", 'Aggiorna prodotto'), "Brand", 'Marca'), "BarcodeSymbology", 'Simbologia del codice a barre'), "ProductCost", 'costi del prodotto'), "ProductPrice", 'Prezzo del prodotto'), "UnitProduct", 'Prodotto unitario'), "TaxMethod", 'Metodo fiscale'), "MultipleImage", 'Immagine multipla'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", 'Il prodotto ha più varianti'), "ProductHasPromotion", 'Il prodotto ha una promozione'), "PromotionStart", 'Inizia la promozione'), "PromotionEnd", 'Fine promozione'), "PromotionPrice", 'Prezzo promozionale'), "Price", 'Prezzo'), "Cost", 'Costo'), "Unit", 'Unità'), "ProductVariant", 'Variante di prodotto'), "Variant", 'Variante'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitPrice", 'Prezzo unitario'), "CreateReturnCustomer", 'Crea cliente di reso'), "EditReturnCustomer", 'Modifica cliente di reso'), "CreateReturnSupplier", 'Crea fornitore di reso'), "Documentation", 'Documentazione'), "EditReturnSupplier", 'Modifica fornitore di reso'), "FromWarehouse", 'Dal magazzino'), "ToWarehouse", 'Al magazzino'), "EditTransfer", 'Modifica trasferimento'), "TransferDetail", 'Dettaglio trasferimento'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Pending", 'in attesa di'), "Received", 'Ricevuto'), "Ordered", 'Ordinato'), "PermissionsManager", 'Gestore delle autorizzazioni'), "BrandManager", 'Gestore di marchio'), "BrandImage", 'Immagine di marca'), "BrandName", 'Nome di marca'), "BrandDescription", 'Descrizione di marca'), "BaseUnit", 'Unità base'), "ManagerUnits", 'Gestione delle unità'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "OperationValue", 'Valore dell\'operazione'), "Operator", 'Operatore'), "Top5Products", 'I 5 migliori prodotti'), "Last5Sales", 'Ultime 5 vendite'), "ListAdjustments", 'Elenca le regolazioni'), "ListTransfers", 'Elenco trasferimenti'), "CreateTransfer", 'Crea trasferimento'), "OrdersManager", 'Gestione degli ordini'), "ListQuotations", 'Elenco citazioni'), "ListPurchases", 'Elenco acquisti'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ListSales", 'Elenco vendite'), "ListReturns", 'Elenco dei resi'), "PeopleManager", 'manager del personale'), "ListofBrand", 'Elenco dei marchi'), "Delete", {
  Title: 'Sei sicuro?',
  Text: 'Non sarai in grado di ripristinare questo!',
  confirmButtonText: 'Sì, cancellalo!',
  cancelButtonText: 'Annulla',
  Deleted: 'eliminare!',
  Failed: 'Mancato!',
  Therewassomethingwronge: 'C\'era qualcosa che non andava',
  CustomerDeleted: 'questo cliente è stato eliminato',
  SupplierDeleted: 'questo fornitore è stato eliminato',
  QuoteDeleted: 'questa citazione è stata eliminato',
  SaleDeleted: 'questa vendita è stata eliminata',
  PaymentDeleted: 'questo pagamento è stato eliminato',
  PurchaseDeleted: 'questo acquisto è stato eliminato',
  ReturnDeleted: 'questo ritorno è stato eliminato',
  ProductDeleted: 'questo prodotto è stato eliminato',
  ClientError: 'Questo cliente è già collegato ad altre operazioni',
  ProviderError: 'Questo fornitore è già collegato ad altre operazioni',
  UserDeleted: 'Questo utente è stato eliminato',
  UnitDeleted: 'Questa unità è stata eliminata',
  RoleDeleted: 'Questo ruolo è stato eliminato',
  TaxeDeleted: 'Questa imposta è stata eliminata',
  SubCatDeleted: 'Questa sottocategoria è stata eliminata',
  CatDeleted: 'Questa categoria è stata eliminata',
  WarehouseDeleted: 'Questo magazzino è stato eliminata',
  AlreadyLinked: 'questo prodotto è già collegato ad altre operazioni',
  AdjustDeleted: 'Questo adeguamento è stato eliminato',
  TitleCurrency: 'Questa valuta è stata eliminata',
  TitleTransfer: 'La trasferimento è stata rimossa con successo',
  BackupDeleted: 'Il backup è stato rimosso con successo',
  TitleBrand: 'Questo marchio è stato eliminato'
}), "Update", {
  TitleBrand: 'Questo marchio è stato aggiornato',
  TitleProfile: 'Il tuo profilo è stato aggiornato con successo',
  TitleAdjust: 'Aggiustamento aggiornato con successo',
  TitleRole: 'Ruolo aggiornato con successo',
  TitleUnit: 'L\'unità è stata aggiornata con successo',
  TitleUser: 'Aggiornamento utente eseguito correttamente',
  TitleCustomer: 'Il cliente è stato aggiornato con successo',
  TitleQuote: 'Preventivo aggiornato con successo',
  TitleSale: 'Vendita aggiornata con successo',
  TitlePayment: 'Pagamento aggiornato con successo',
  TitlePurchase: 'Acquisto aggiornato con successo',
  TitleReturn: 'Ritorno Aggiornato con successo',
  TitleProduct: 'Prodotto aggiornato con successo',
  TitleSupplier: 'Il fornitore è stato aggiornato con successo',
  TitleTaxe: 'Imposte aggiornate con successo',
  TitleCat: 'Categoria aggiornata con successo',
  TitleWarhouse: 'Magazzino aggiornato con successo',
  TitleSetting: 'Impostazioni aggiornate con successo',
  TitleCurrency: 'Questa valuta è stata aggiornata',
  TitleTransfer: 'La trasferimento è stata aggiornata con successo'
}), "Create", {
  TitleBrand: 'Questo marchio è stato creato',
  TitleTransfer: 'La trasferimento è stata aggiornata con successo',
  TitleRole: 'Ruolo creato con successo',
  TitleUnit: 'Unità creata con successo',
  TitleUser: 'Utente creato correttamente',
  TitleCustomer: 'Cliente creato con successo',
  TitleQuote: 'Citazione creata con successo',
  TitleSale: 'Vendita creata con successo',
  TitlePayment: 'Pagamento creato con successo',
  TitlePurchase: 'Acquisto creato con successo',
  TitleReturn: 'Ritorno Creato con successo',
  TitleProduct: 'Prodotto creato con successo',
  TitleSupplier: 'Fornitore creato con successo',
  TitleTaxe: 'Imposta creata con successo',
  TitleCat: 'Categoria creata con successo',
  TitleWarhouse: 'Magazzino creato con successo',
  TitleAdjust: 'Aggiustamento creato con successo',
  TitleCurrency: 'Questa valuta è stata creata'
}), "Send", {
  TitleEmail: 'Email Invia correttamente'
}), "return", {
  TitleSale: 'questa vendita già collegata con un ritorno!'
}), "ReturnManagement", 'Gestione dei ritorna'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnDetail", 'Dettagli di ritorno'), "EditReturn", 'Modifica ritorno'), "AddReturn", 'Aggiungi ritorno'), "EmailReturn", 'Invia Ritorno in e-mail'), "DeleteReturn", 'Elimina ritorno'), "Retoursurcharge", 'Supplemento per restituzione'), "Laivrison", 'consegna'), "SelectSale", 'Seleziona vendita'), "ZeroPardefault", 'È possibile eliminare l\'articolo o impostare la quantità restituita su zero se non viene restituita'), "Return", 'Ritorno'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchase", 'Acquista'), "TotalSales", 'Vendite totali'), "TotalPurchases", 'Acquisti totali'), "TotalReturns", 'Retorna totali'), "PaiementsNet", 'Pagamenti netti'), "PaiementsSent", 'Pagamenti inviati'), "PaiementsReceived", 'Pagamenti ricevuti'), "Recieved", 'ricevuti'), "Sent", 'inviati'), "ProductQuantityAlerts", 'Avvisi quantità prodotto'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCode", 'Codice prodotto'), "ProductName", 'nome del prodotto'), "AlertQuantity", 'Quantità di avviso'), "WarehouseStockChart", 'Grafico azioni magazzino'), "TotalProducts", 'Totale prodotti'), "TotalQuantity", 'Quantità totale'), "TopCustomers", 'I 5 migliori clienti'), "TotalAmount", 'Importo totale'), "TotalPaid", 'Totale pagato'), "CustomerSalesReport", 'Rapporto sulle vendite dei clienti'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", 'Rapporto sui pagamenti dei clienti'), "CustomerQuotationsReport", 'Rapporto sulle citazioni dei clienti'), "Payments", 'pagamenti'), "TopSuppliers", 'Primi 5 fornitori'), "SupplierPurchasesReport", 'Rapporto sugli acquisti dei fornitori'), "SupplierPaiementsReport", 'Rapporto sui pagamenti dei fornitori'), "Name", 'Nome'), "Code", 'Codice'), "ManagementWarehouse", 'Gestione del magazzino'), "ZipCode", 'Cap'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementCategories", 'Gestione delle categorie'), "Codecategorie", 'Categoria di codice'), "Namecategorie", 'Nome categoria'), "Parentcategorie", 'Categoria principale'), "managementTax", 'Gestione fiscale'), "TaxName", 'Nome fiscale'), "TaxRate", 'Aliquota fiscale'), "managementUnitPurchases", 'Gestione dell\'unità acquisti'), "managementUnitSales", 'Gestione dell\'unità di vendita'), "ShortName", 'Nome corto'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", 'Seleziona questi prima di aggiungere qualsiasi prodotto'), "StockAdjustement", 'Adeguamento delle scorte'), "PleaseSelectWarehouse", 'Seleziona il magazzino prima di scegliere qualsiasi prodotto'), "StockTransfer", 'Trasferimento stock'), "SelectPeriod", 'Seleziona Periodo'), "ThisYear", 'Quest\'anno'), "ThisToday", 'Questo oggi'), "ThisMonth", 'Questo mese'), "ThisWeek", 'Questa settimana'), "AdjustmentDetail", 'Dettaglio regolazione'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ActivateUser", 'Questo utente è stato attivato'), "DisActivateUser", 'Questo utente è stato disattivato'), "NotFound", 'Pagina non trovata.'), "oops", 'errore! Pagina non trovata.'), "couldNotFind", 'Non siamo riusciti a trovare la pagina che stavi cercando. Nel frattempo, potresti'), "ReturnDashboard", 'torna alla dashboard'), "hrm", 'HRM'), "Employees", 'Dipendenti'), "Attendance", 'Presenze'), "Leave_request", 'Lascia una richiesta'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Leave_type", 'Tipo di uscita'), "Company", 'Azienda'), "Departments", 'Dipartimenti'), "Designations", 'Designazioni'), "Office_Shift", 'Turno d\'ufficio'), "Holidays", 'Vacanze'), "Enter_Company_Name", 'Inserisci il nome dell\'azienda'), "Enter_email_address", 'Inserisci l\'indirizzo email'), "Enter_Company_Phone", 'Inserisci il telefono aziendale'), "Enter_Company_Country", 'Inserisci il paese dell\'azienda'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", 'Creato con successo'), "Updated_in_successfully", 'Aggiornato con successo'), "Deleted_in_successfully", 'Eliminato con successo'), "department", 'Dipartimento'), "Enter_Department_Name", 'Inserisci il nome del dipartimento'), "Choose_Company", 'Scegli Azienda'), "Department_Head", 'Capo dipartimento'), "Choose_Department_Head", 'Scegli Capo Dipartimento'), "Enter_Shift_name", 'Inserisci il nome del turno'), "Monday_In", 'Monday In'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'Vacanza'), "Enter_title", 'Inserisci il titolo'), "title", 'titolo'), "start_date", 'Data d\'inizio'), "Enter_Start_date", 'Inserire la data di inizio'), "Finish_Date", 'Data di fine'), "Enter_Finish_date", 'Inserisci la data di fine'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", 'Si prega di fornire tutti i dettagli'), "Attendances", 'Presenze'), "Enter_Attendance_date", 'Inserisci la data di presenza'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", 'Scegli Dipendente'), "Employee", 'Dipendente'), "Work_Duration", 'Durata del lavoro'), "remaining_leaves_are_insufficient", 'Le foglie rimanenti sono insufficienti'), "Leave_Type", 'Tipo di uscita'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Days", 'Giorni'), "Department", 'Dipartimento'), "Choose_leave_type", 'Scegli il tipo di permesso'), "Choose_status", 'Scegli lo stato'), "Leave_Reason", 'Lascia la ragione'), "Enter_Reason_Leave", 'Inserisci Motivo Congedo'), "Add_Employee", 'Aggiungi dipendente'), "FirstName", 'Nome di battesimo'), "Enter_FirstName", 'Inserisci il nome'), "LastName", 'Cognome'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_LastName", 'Inserisci il cognome'), "Gender", 'Genere'), "Choose_Gender", 'Scegli il genere'), "Enter_Birth_date", 'Inserisci la data di nascita'), "Birth_date", 'Data di nascita'), "Enter_Country", 'Inserisci Paese'), "Enter_Phone_Number", 'Inserisci il numero di telefono'), "joining_date", 'Data di adesione'), "Enter_joining_date", 'Inserisci la data di adesione'), "Choose_Designation", 'Scegli Designazione'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Designation", 'Designazione'), "Office_Shift", 'Turno di Ufficio'), "Choose_Office_Shift", 'Scegli Turno d\'ufficio'), "Enter_Leaving_Date", 'Inserisci la data di partenza'), "Leaving_Date", 'Data di partenza'), "Annual_Leave", 'Ferie annuali'), "Enter_Annual_Leave", 'Entra in ferie annuali'), "Remaining_leave", 'Congedo residuo'), "Employee_Details", 'Dettagli dei dipendenti'), "Basic_Information", 'Informazioni di base'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Family_status", 'Stato familiare'), "Choose_Family_status", 'Scegli lo stato di famiglia'), "Employment_type", 'Tipo di impiego'), "Select_Employment_type", 'Seleziona Tipo di impiego'), "Enter_City", 'Entra in Città'), "Province", 'Provincia'), "Enter_Province", 'Entra in Provincia'), "Enter_Address", 'Inserisci indirizzo'), "Enter_Zip_code", 'Inserisci il codice postale'), "Zip_code", 'Cap'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Hourly_rate", 'Tariffa oraria'), "Enter_Hourly_rate", 'Inserisci Tariffa oraria'), "Basic_salary", 'Salario di base'), "Enter_Basic_salary", 'Inserisci lo stipendio base'), "Social_Media", 'Social media'), "Skype", 'Skype'), "Enter_Skype", 'Inserisci un Skype'), "Facebook", 'Facebook'), "Enter_Facebook", 'Inserisci un Facebook'), "WhatsApp", 'WhatsApp'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Inserisci un WhatsApp'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", 'Inserisci un LinkedIn'), "Twitter", 'Twitter'), "Enter_Twitter", 'Inserisci un Twitter'), "Experiences", 'Esperienze'), "bank_account", 'conto bancario'), "Company_Name", 'Nome della ditta'), "Location", 'Posizione'), "Enter_location", 'Inserisci posizione'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Description", 'Immettere la descrizione'), "Bank_Name", 'Nome della banca'), "Enter_Bank_Name", 'Inserisci il nome della banca'), "Bank_Branch", 'Filiale bancaria'), "Enter_Bank_Branch", 'Entra in filiale della banca'), "Bank_Number", 'Numero di banca'), "Enter_Bank_Number", 'Immettere il numero di banca'), "Assigned_warehouses", 'Magazzini assegnati'), "Top_customers", 'I migliori clienti'), "Attachment", 'Allegato'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "view_employee", 'visualizzare i dipendenti'), "edit_employee", 'modificare i dipendenti'), "delete_employee", 'eliminare i dipendenti'), "Created_by", 'Aggiunto da'), "Add_product_IMEI_Serial_number", 'Aggiungi IMEI/Numero di serie del prodotto'), "Product_Has_Imei_Serial_number", 'Il prodotto ha un numero Imei/di serie'), "IMEI_SN", 'IMEI/SN'), "Shipments", 'Spedizioni'), "delivered_to", 'Spedito a'), "shipment_ref", 'Spedizione Rif'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "sale_ref", 'Vendita Rif'), "Edit_Shipping", 'Modifica spedizione'), "Packed", 'Confezionato'), "Shipped", 'Spedito'), "Delivered", 'Consegnato'), "Cancelled", 'Annullato'), "Shipping_status", 'Stato della spedizione'), "Users_Report", 'Rapporto utenti'), "stock_report", 'Rapporto sulle scorte'), "TotalPurchases", 'Acquisti totali'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Total_quotations", 'Citazioni totali'), "Total_return_sales", 'Vendite di ritorno totale'), "Total_return_purchases", 'Totale acquisti di ritorno'), "Total_transfers", 'Trasferimenti totali'), "Total_adjustments", 'Adeguamenti totali'), "User_report", 'Rapporto utente'), "Current_stock", 'Scorta attuale'), "product_name", 'nome del prodotto'), "Total_Customers_Due", 'Debito totale'), "Total_Suppliers_Due", 'Debito totale'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Some_warehouses", 'Alcuni Magazzini'), "All_Warehouses", 'Tutti i Magazzini'), "Product_Cost", 'Prezzo del prodotto'), "sms_settings", 'Impostazioni SMS'), "pos_settings", 'Impostazioni POS'), "payment_gateway", 'Gateway di pagamento'), "mail_settings", 'Impostazioni di posta'), "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'Gateway SMS predefinito'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "module_settings", 'Impostazioni del modulo'), "Module_enabled_success", 'Modulo abilitato con successo'), "Module_Disabled_success", 'Modulo disabilitato con successo'), "update_settings", 'Aggiorna impostazioni'), "Please_Upload_the_Correct_Module", 'Carica il modulo corretto'), "Uploaded_Success", 'Caricato con successo'), "Customer_details", 'Dettagli cliente'), "Edit_Customer", 'Modifica cliente'), "Delete_Customer", 'Elimina cliente'), "Pay_Due", 'pagare dovuto'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", 'L\'importo del pagamento è superiore al totale dovuto'), "Customer_Invoice", 'Fattura del cliente'), "This_Product_Not_For_Selling", 'Questo prodotto non è in vendita'), "Welcome_to_your_Dashboard", 'Benvenuto nella tua dashboard'), "Total_Payable", 'Totale pagabile'), "Choose_Sale_Ref", 'Scegli Rif. Vendita'), "Please_Select_Sale", 'Si prega di selezionare Vendita'), "Sale_Ref", 'Rif. Vendita'), "list_product_returns", 'elenca i resi dei prodotti'), "Qty_return", 'qty di ritorno'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", 'Scegli Acquisto Rif'), "Purchase_Ref", 'Acquisto Rif'), "please_select_purchase", 'Seleziona Acquisto'), "qty_return_is_greater_than_qty_purchased", 'La quantità restituita è maggiore della quantità acquistata'), "qty_return_is_greater_than_qty_sold", 'La quantità di ritorno è maggiore della quantità venduta'), "Quantity_sold", 'Quantità venduta'), "qty_purchased", 'Quantità acquistata'), "Sender_Name", 'Nome mittente'), "The_module_must_be_uploaded_as_zip_file", 'Il modulo deve essere caricato come file zip'), "Upload_Module", 'Modulo di caricamento'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", 'Tutti i moduli installati'), "Current_Version", 'Versione attuale'), "You_already_have_the_latest_version", 'Hai già l\'ultima versione'), "Update_Available", 'Aggiornamento disponibile'), "Update_Log", 'Aggiorna registro'), "Update_Now", 'Aggiorna ora'), "View_Change_Log", 'Visualizza registro modifiche'), "invoice_footer", 'Piè di pagina della fattura'), "Please_Wait_for_the_update", 'NOTA: attendere il completamento dell\'aggiornamento. Non è consigliabile chiudere il browser o interrompere un processo di aggiornamento'), "Note_update", 'Nota: assicurati di eseguire il backup della versione corrente e del database prima di eseguire l\'aggiornamento, per ripristinarlo in caso di errore'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Time_Zone", 'Fuso orario'), "Payment_note", 'note di pagamento'), "sale_note", 'note di vendita'), "Total_Sale_Due", 'Totale vendita dovuta'), "Total_Sell_Return_Due", 'Totale vendita di ritorno dovuto'), "pay_all_sell_due_at_a_time", 'pagare tutte le vendite dovute alla volta'), "pay_all_sell_return_due_at_a_time", 'pagare tutti i resi di vendita dovuti alla volta'), "Gross_Profit", 'Utile lordo'), "pay_all_purchase_due_at_a_time", 'pagare tutti gli acquisti dovuti alla volta'), "Delete_Provider", 'Elimina fornitore'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Provider", 'Modifica fornitore'), "Provider_details", 'Dettagli del fornitore'), "Total_Purchase_Due", 'Totale acquisto dovuto'), "Provider_Credit_Note", 'Nota di credito'), "Customer_Credit_Note", 'Nota di credito'), "Sell_Return", 'Vendi Ritorno'), "Purchase_Return", 'Acquisto di ritorno'), "Tax_Number", 'Codice Fiscale'), "Please_add_return_quantity", 'Si prega di aggiungere la quantità di reso'), "Return_exist_for_the_Transaction", 'Esiste un ritorno per la transazione'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", 'La quantità restituita è maggiore della quantità rimanente'), "products_refunded_alert", 'Tutti i prodotti con una quantità impostata su 0 non verranno rimborsati'), "pay_all_purchase_return_due_at_a_time", 'pagare tutti i resi di acquisto dovuti alla volta'), "Total_Purchase_Return_Due", 'Totale acquisto reso dovuto'), "Purchase_return_due", 'Acquisto di ritorno dovuto'), "Sell_return_due", 'Vendi reso dovuto'), "product_report", 'Rapporto sul prodotto'), "product_sales_report", 'rapporto di vendita del prodotto'), "Product_purchases_report", 'Report acquisti prodotti'), "Qty_sold", 'Qtà venduta'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Qty_purchased", 'Qtà acquistata'), "Filter_by_warehouse", 'Filtra per magazzino'), "Enable_Print_Invoice", 'Stampa fattura automaticamente'), "Show_Warehouse", 'visualizza magazzino'), "credit_card_info", 'Informazioni carta di credito'), "Saved_Credit_Card_Info", 'Informazioni carta di credito salvate'), "Credit_card_changed_successfully", 'Carta di credito modificata con successo'), "notification_template", 'Modello di notifica'), "email_notification", 'Notifica email'), "sms_notification", 'Notifica SMS'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Change_product_details", 'Modifica dettagli prodotto'), "edit_tax_and_discount_and_shipping", 'Modifica tasse, sconti e spedizione'), "Create_Quotation_with_Stock", 'Crea preventivo con magazzino'), "Variant_Name", 'Nome variante'), "Variant_cost", 'Costo variante'), "Variant_price", 'Prezzo variante'), "Variant_code", 'Codice variante'), "Please_wait_until_the_product_is_loaded", 'Attendere fino al caricamento del prodotto'), "Choose_SMS_Gateway", 'Scegli il gateway SMS'), "Notification_Client", 'Notifica al cliente'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Available_Tags", 'Tag disponibili'), "Email_Subject", 'Oggetto email'), "Email_body", 'Corpo email'), "Notification_Supplier", 'Notifica al fornitore'), "sms_body", 'Corpo SMS'), "sms_templates", 'SMS Templates'), "email_templates", 'Email Templates'));

/***/ }),

/***/ "./resources/src/translations/locales/kr.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/kr.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language coréen

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: '영수증',
  Pos_Settings: '판매 시점 구성',
  Note_to_customer: '고객참고',
  Show_Note_to_customer: '고객에게 참고 표시',
  Show_barcode: '바코드 표시',
  Show_Tax_and_Discount: '세금 및 할인 및 배송 표시',
  Show_Customer: '고객 표시',
  Show_Email: '이메일 표시',
  Show_Phone: '전화 표시',
  Show_Address: '주소 표시',
  DefaultLanguage: '기본 언어',
  footer: '풋터',
  Received_Amount: '받은 금액',
  Paying_Amount: '결제 금액',
  Change: '변화',
  Paying_amount_is_greater_than_Received_amount: '지급금액은 수령금액보다 크다',
  Paying_amount_is_greater_than_Grand_Total: '지급금액은 전체 총액보다 크다',
  code_must_be_not_exist_already: '코드가 더 이상 존재하지 않아야 합니다.',
  You_will_find_your_backup_on: '백업을 찾을 수 있습니다',
  and_save_it_to_your_pc: '그리고 당신의 PC에 저장',
  Scan_your_barcode_and_select_the_correct_symbology_below: '바코드를 스캔하고 아래의 올바른 상징을 선택하십시오.',
  Scan_Search_Product_by_Code_Name: '코드 이름으로 스캔/검색 제품',
  Paper_size: '종이 크기',
  Clear_Cache: '캐시 지우기',
  Cache_cleared_successfully: '캐시가 성공적으로 삭제',
  Failed_to_clear_cache: '캐시를 지울 수 없다',
  Scan_Barcode: '바코드 스캐너',
  Please_use_short_name_of_unit: '드라이브의 짧은 이름을 사용',
  DefaultCustomer: '기본 클라이언트',
  DefaultWarehouse: '기본 저장소',
  Payment_Gateway: '결제 게이트웨이',
  SMS_Configuration: 'SMS 설정',
  Gateway: '결제 게이트웨이',
  Choose_Gateway: '결제 게이트웨이 선택',
  Send_SMS: '성공적으로 보낸 메시지',
  sms_config_invalid: '잘못된 SMS 설정',
  Remove_Stripe_Key_Secret: '스트라이프 API 키 삭제',
  credit_card_account_not_available: '신용카드 계좌 이용 불가',
  Credit_Card_Info: '신용카드 정보',
  developed_by: '에 의해 개발',
  Unit_already_linked_with_sub_unit: '이미 하위 유닛에 연결된 유니티',
  Total_Items_Quantity: '총 품목 및 수량',
  Value_by_Cost_and_Price: '비용과 가격에 대한 가치',
  Search_this_table: '이 테이블 찾기',
  import_products: '수입 제품',
  Field_optional: '선택적 필드',
  Download_exemple: '예제 다운로드',
  field_must_be_in_csv_format: '필드는 csv 형식으로 해야 합니다.',
  Successfully_Imported: '성공적으로 가져오기',
  file_size_must_be_less_than_1_mega: '파일 크기는 1메가 미만이어야 한다',
  Please_follow_the_import_instructions: '가져오기 지침에 따라.',
  must_be_exist: '드라이브는 이미 만들어야 합니다.',
  Import_Customers: '고객 수입',
  Import_Suppliers: '수입 공급 업체',
  Recent_Sales: '최근 매출',
  Create_Transfer: '전송 만들기',
  order_products: '주문 아이템',
  Search_Product_by_Code_Name: '코드 나 이름으로 검색 제품',
  Reports_payments_Purchase_Return: '신고반지급',
  Reports_payments_Sale_Return: '판매 결제 신고',
  payments_Sales_Return: '결제 판매 반환',
  payments_Purchases_Return: '결제 는 반환 구매',
  CreateSaleReturn: '판매 관한 반품 만들기',
  EditSaleReturn: '판매 반품 수정',
  SalesReturn: '판매 반품',
  CreatePurchaseReturn: '반품 구매 만들기',
  EditPurchaseReturn: '반품 구매 편집',
  PurchasesReturn: '구매 반환',
  Due: '기한',
  Profit: '이익',
  Revenue: '소득',
  Sales_today: '오늘 판매',
  People: '사람들',
  Successfully_Created: '성공적으로 만든',
  Successfully_Updated: '성공적으로 업데이트',
  Success: '성공',
  Failed: '실패',
  Warning: '경고',
  Please_fill_the_form_correctly: '양식을 올바르게 작성하십시오',
  Field_is_required: '필드 필요',
  Error: '오류!',
  you_are_not_authorized: '죄송합니다 귀하는 권한이 없습니다.',
  Go_back_to_home: '메인 페이지로 돌아가기',
  page_not_exist: '죄송합니다! 원하는 페이지가 존재하지 않습니다.',
  Choose_Status: '상태 선택',
  Choose_Method: '방법을 선택',
  Choose_Symbology: '상징을 선택',
  Choose_Category: '카테고리 선택',
  Choose_Customer: '고객 선택',
  Choose_Supplier: '공급자 선택',
  Choose_Unit_Purchase: '구매 단위 선택',
  Choose_Sub_Category: '하위 카테고리 선택',
  Choose_Brand: '브랜드 선택',
  Choose_Warehouse: '창고 선택',
  Choose_Unit_Sale: '판매 단위를 선택',
  Enter_Product_Cost: '제품 비용 입력 제품 원가 입력',
  Enter_Stock_alert: '주식 경보 입력',
  Choose_Unit_Product: '제품 단위 선택',
  Enter_Product_Price: '상품의 가격을 입력',
  Enter_Name_Product: '상품의 이름을 입력',
  Enter_Role_Name: '역할의 이름을 입력',
  Enter_Role_Description: '역할 설명을 입력',
  Enter_name_category: '카테고리의 이름을 입력',
  Enter_Code_category: '카테고리 코드를 입력',
  Enter_Name_Brand: '브랜드 이름 입력',
  Enter_Description_Brand: '브랜드 설명 입력',
  Enter_Code_Currency: '코드의 통화를 입력',
  Enter_name_Currency: '통화 방식 입력',
  Enter_Symbol_Currency: '기호의 화폐를 입력',
  Enter_Name_Unit: '단위의 이름을 입력',
  Enter_ShortName_Unit: '짧은 이름 단위를 입력',
  Choose_Base_Unit: '베이스 유닛 선택',
  Choose_Operator: '연산자 선택',
  Enter_Operation_Value: '무역의 가치를 입력',
  Enter_Name_Warehouse: '창고의 이름을 입력',
  Enter_Phone_Warehouse: '창고 전화 입력',
  Enter_Country_Warehouse: '창고의 나라로 들어가라',
  Enter_City_Warehouse: '창고 도시 진입',
  Enter_Email_Warehouse: '창고 이메일 입력',
  Enter_ZipCode_Warehouse: '창고의 우편 번호를 입력',
  Choose_Currency: '통화 선택',
  Thank_you_for_your_business: '당신의 사업에 감사드립니다!',
  Cancel: '취소',
  New_Customer: '신규 고객',
  Incorrect_Login: '로그인 실패',
  Successfully_Logged_In: '성공적인 로그인',
  This_user_not_active: '이 사용자는 활성 상태가 아닙니다.',
  SignIn: '등록기 로그인 하세요',
  Create_an_account: '계정 만들기',
  Forgot_Password: '비밀번호를 잊어버렸나요?',
  Email_Address: '이메일 주소',
  SignUp: '가입',
  Already_have_an_account: '이미 계정이 있습니까?',
  Reset_Password: '암호 재설정',
  Failed_to_authenticate_on_SMTP_server: 'SMTP 서버로 인증할 수 없습니다.',
  We_cant_find_a_user_with_that_email_addres: '우리는 그 이메일 주소가있는 사용자를 찾을 수 없습니다',
  We_have_emailed_your_password_reset_link: '이메일을 통해 암호 재설정 링크를 보냈습니다.',
  Please_fill_the_Email_Adress: '이메일 주소를 기입해 주세요',
  Confirm_password: '비밀번호 확인',
  Your_Password_has_been_changed: '비밀번호가 변경되었습니다',
  The_password_confirmation_does_not_match: '암호 확인이 일치하지 않습니다',
  This_password_reset_token_is_invalid: '이 암호 재설정 토큰은 유효하지 않습니다.',
  Warehouse_report: '창고 보고서',
  All_Warehouses: '모든 창고',
  Expense_List: '경비 목록',
  Expenses: '비용 / 지출',
  This_Week_Sales_Purchases: '이번 주 매출 및 구매',
  Top_Selling_Products: '베스트 셀러 제품',
  View_all: '모두 보기',
  Payment_Sent_Received: '송수신된 결제 /결제 배송 받음 ',
  Filter: "필터",
  Invoice_POS: "POS 송장",
  Invoice: "송장 /영수증",
  Customer_Info: "고객 정보",
  Company_Info: "회사 정보",
  Invoice_Info: "송장 정보",
  Order_Summary: "주문 요약",
  Quote_Info: "견적 정보",
  Del: "삭제",
  SuppliersPaiementsReport: "공급업체 지불 보고서",
  Purchase_Info: "구매 정보",
  Supplier_Info: "공급업체 정보",
  Return_Info: "반송 정보",
  Expense_Category: "비용 범주",
  Create_Expense: "지출 창출",
  Details: "세부 사항",
  Discount_Method: "할인 방법",
  Net_Unit_Cost: "순 단가",
  Net_Unit_Price: "순 단가",
  Edit_Expense: "지출 편집",
  All_Brand: "전체 브랜드",
  All_Category: "모든 카테고리",
  ListExpenses: "비용 목록",
  Create_Permission: "권한 만들기",
  Edit_Permission: "권한 편집",
  Reports_payments_Sales: "판매 유료 보고서",
  Reports_payments_Purchases: "결제 신고",
  Reports_payments_Return_Customers: "고객반환 신고",
  Reports_payments_Return_Suppliers: "보고서 지불의 반환 공급자",
  stockyVersion: "당신은 스타킹 버전에서이 작업을 수행 할 수 없습니다",
  Expense_Deleted: "이 비용은 제거되었습니다.",
  Expense_Updated: "이 지출이 업데이트되었습니다",
  Expense_Created: "이 비용이 만들어졌습니다.",
  Filesize: "파일 크기",
  GenerateBackup: "백업 생성",
  BackupDatabase: "백업 데이터베이스",
  Backup: "백업 데이터베이스",
  OrderStatistics: "판매 통계",
  AlreadyAdd: "이 제품은 이미 추가되었습니다.",
  AddProductToList: "목록에 제품을 추가",
  AddQuantity: "수량 추가",
  InvalidData: "유효하지 않은 날짜",
  LowStock: "수량은 재고에서 사용할 수 있는 양을 초과",
  WarehouseIdentical: "창고는 동일할 수 없습니다.",
  VariantDuplicate: "이 변형은 중복됩니다.",
  Paid: "유료",
  Unpaid: "지불하지 않음",
  IncomeExpenses: "소득과 비용",
  dailySalesPurchases: "일일 판매 및 구매",
  ProductsExpired: "만료된 제품",
  Today: "오늘",
  Income: "소득"
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", "비용"), "Sale", "리베이트"), "Actif", "액티브"), "Inactif", "비활성"), "Customers", "클라이언트 /손님 / 고객"), "Phone", "전화"), "SearchByPhone", "전화로 검색"), "Suppliers", "공급업체"), "Quotations", "견적"), "Sales", "판매"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", '쇼핑'), "Returns", "반환"), "Settings", "설정"), "SystemSettings", "시스템 설정"), "Users", "사용자"), "GroupPermissions", "그룹 사용 권한"), "Currencies", "동전"), "Warehouses", "창고"), "Units", "단위"), "UnitsPrchases", '「단위 구매」'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", "단위 판매"), "Reports", "보고서"), "PaymentsReport", "지불 보고서"), "PaymentsPurchases", "결제 구매"), "PaymentsSales", "지불 의 판매"), "PaymentsReturns", "지불 의 환불"), "ProfitandLoss", "이익과 손실"), "WarehouseStockChart", "창고 주식 차트"), "SalesReport", "판매 보고서"), "PurchasesReport", "구매 보고서"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CustomersReport", "고객 보고서"), "SuppliersReport", "공급업체 보고서"), "SupplierReport", "공급업체 보고서"), "DailySalesData", "일일 판매 데이터"), "DailyPurchasesData", "일일 쇼핑 데이터"), "Derni\xE8rescinqrecords", "마지막 5개의 기록"), "Filters", "필터"), "date", "날짜"), "Reference", "참조"), "Supplier", "공급업체"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PaymentStatus", "지불 상태"), "Customer", "고객"), "CustomerCode", "클라이언트 코드"), "Status", "상태"), "SupplierCode", "공급업체 코드"), "Categorie", "카테고리"), "Categories", "카테고리"), "StockTransfers", "주식 송금"), "StockManagement", "주식 관리"), "dashboard", "보드"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Products", "제품"), "productsList", "제품 목록"), "ProductManagement", "제품 관리"), "ProductQuantityAlerts", "제품 수량 경고"), "CodeProduct", "제품 코드"), "ProductTax", "제품세"), "SubCategorie", "하위 범주"), "Name_product", "지정"), "StockAlert", "주식 경보"), "warehouse", "창고"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax", "세금"), "BuyingPrice", '「구매 가격」'), "SellPrice", "판매 가격"), "Quantity", "수량"), "UnitSale", "단위의 판매"), "UnitPurchase", '「단위 구매」'), "All", "모두"), "EditProduct", '「제품 편집」'), "AddProduct", "제품 추가"), "SearchByCode", "코드로 검색"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SearchByName", "이름으로 검색"), "ProductDetails", "제품 세부 사항"), "CustomerName", "고객 이름"), "CustomerManagement", "고객 관리"), "Add", "더하다 추가"), "add", "추가"), "Edit", "편집"), "Close", "닫기"), "PleaseSelect", "선택해 주세요"), "Action", "액션"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Email", "이메일"), "EditCustomer", "클라이언트 편집  고객 수정"), "AddCustomer", "클라이언트 추가  고객 추가"), "Country", "국가"), "City", "도시"), "Adress", "주소"), "CustomerDetails", "고객 세부 사항"), "CustomersList", "고객 목록"), "SupplierCode", "공급업체 코드"), "SupplierName", "공급자 이름"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersManagement", "공급업체 관리"), "SupplierDetails", "공급업체 세부 정보"), "QuotationsManagement", "견적 관리"), "SubTotal", "부분 합계"), "MontantReste", "남은 수량"), "complete", "완전"), "EnAttendant", "보류 중"), "Recu", "수신"), "partial", "부분"), "Retournee", "반환"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "DetailQuote", "상세한 견적"), "EditQuote", "견적 편집"), "CreateSale", "판매 만들기"), "DownloadPdf", "PDF 다운로드"), "QuoteEmail", "이메일로 보낸 견적"), "DeleteQuote", "견적 삭제"), "AddQuote", "견적 추가"), "SelectProduct", '제품 선택'), "ProductCodeName", "제품(코드 - 이름)"), "Price", "가격"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CurrentStock", "주식 / 제고"), "Total", "총"), "Num", "N°"), "Unitcost", "단가"), "to", "a"), "Subject", "주제"), "Message", "메시지"), "EmailCustomer", "이메일 클라이언트"), "Sent", "보내기"), "Quote", "견적"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Hello", "안녕하세요"), "AttachmentQuote", "견적첨부 파일 찾기"), "AddProducts", "주문 목록에 제품을 추가"), "SelectWarehouse", "창고를 선택해 주세요"), "SelectCustomer", "고객 선택"), "SalesManagement", "영업 관리"), "Balance", "저울  순이익"), "QtyBack", '반품 수량'), "TotalReturn", "총 반환"), "Amount", "금액"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SaleDetail", '판매 상세'), "EditSale", "판매 편집"), "AddSale", "판매 추가"), "ShowPayment", "지불 표시"), "AddPayment", "지불 추가"), "EditPayment", "결제 편집"), "EmailSale", "이메일로 판매 보내기"), "DeleteSale", "판매 제거"), "ModePaiement", "결제 방법"), "Paymentchoice", "지불 옵션"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Note", "참고"), "PaymentComplete", "완전 결제!"), "PurchasesManagement", "구매 관리"), "Ordered", "깔끔한"), "DeletePurchase", "구매 삭제"), "EmailPurchase", '이메일로 구매 보내기'), "EditPurchase", "구매 편집"), "PurchaseDetail", '구매 세부 사항'), "AddPurchase", "구매 추가"), "EmailSupplier", "공급자 이메일"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PurchaseInvoice", "유료 구매"), "PurchasesInvoicesData", "구매 결제 데이터"), "SalesInvoice", "판매 지불"), "SalesInvoicesData", "판매 지불 데이터"), "UserManagement", "사용자 관리"), "Firstname", "이름"), "lastname", "가족 이름"), "username", "사용자 이름"), "password", "암호"), "Newpassword", "새 암호"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeAvatar", "아바타 변경"), "LeaveBlank", "변경하지 않은 경우 이 필드를 비워 둡니다."), "type", "유형"), "UserPermissions", "사용자 권한"), "RoleName", "역할 이름"), "RoleDescription", "역할 설명"), "AddPermissions", "권한 추가"), "View", "보다/보기"), "Del", "삭제"), "NewAdjustement", "새로운 설정"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditAdjustement", "설정 편집"), "CannotSubstraction", "재고가 있는 제품을 빼는 것은 할 수 없습니다"), "Addition", "추가"), "Subtraction", "뺄셈"), "profil", "프로필"), "logout", "로그 아웃"), "PurchaseAlreadyPaid", "이 구매가 이미 지불했기 때문에 수정할 수 없습니다"), "SaleAlreadyPaid", "이 판매는 이미 지불했기 때문에 수정할 수 없습니다."), "ReturnAlreadyPaid", "이 환불은 이미 지불했기 때문에 수정할 수 없습니다."), "QuoteAlready", "이 견적은 이미 매출을 창출했습니다."), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "QuotationComplete", "이 완전한 견적"), "SiteConfiguration", "사이트 설정"), "Language", "언어"), "DefaultCurrency", "기본 통화"), "LoginCaptcha", "로그인 캡차"), "DefaultEmail", "기본 이메일"), "SiteName", "사이트 이름"), "ChangeLogo", "로고 변경"), "SMTPConfiguration", "SMTP 설정"), "HOST", "호스트"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PORT", "포트"), "encryption", "암호화"), "SMTPIncorrect", "잘못된 SMTP 설정"), "ReturnsInvoices", "리턴 송장"), "ReturnsInvoicesData", "송장 데이터 반환"), "ShowAll", "모든 사용자에 관한 정보  표시"), "Discount", "할인"), "OrderTax", "주문세"), "Shipping", '「배송」'), "ManagementCurrencies", "관리 통화"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CurrencyCode", "통화 코드"), "CurrencyName", "통화 이름"), "Symbol", "기호"), "CompanyName", "회사 이름"), "CompanyPhone", "회사 전화"), "CompanyAdress", "회사 주소"), "Code", "코드"), "image", "이미지"), "Printbarcode", "바코드 인쇄"), "ReturnsCustomers", "반품 판매"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", "구매 수익"), "FactureReturnCustomers", "송장 판매 반환"), "FactureReturnSuppliers", "송장은 구매를 반환합니다"), "NodataAvailable", "사용할 수 없는 데이터"), "ProductImage", "제품 이미지"), "Barcode", "바코드"), "pointofsales", "판매 지점"), "CustomUpload", "사용자 정의 업로드"), "pointofsaleManagement", "판매 관리 지점"), "Adjustment", "조정"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", "업데이트"), "Reset", "다시 시작"), "print", "인쇄"), "SearchByEmail", "우편으로 검색"), "ChooseProduct", "제품 선택"), "Qty", "양/장수"), "Items", "기사"), "AmountHT", "HT 금액"), "AmountTTC", "TTC 금액"), "PleaseSelectSupplier", "공급자 선택"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", "상태 선택"), "PayeBy", "유료"), "ChooseWarehouse", "창고 선택"), "payNow", "지금 지불"), "ListofCategory", "카테고리 목록 /제품목록"), "Description", "묘사 /제품설명"), "submit", "구해내다 /저장/보관"), "ProblemCreatingThisInvoice", "이 송장을 만드는 데 문제가 있었습니다. 다시 시도해 주세요."), "ProblemPayment", "지불에 문제가 있었습니다. 다시 시도해 주세요."), "CreateAdjustment", "맞춤 만들기"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Afewwords", "에 대한 몇 마디 ..."), "UserImage", "사용자 이미지"), "UpdateProduct", "제품 업데이트"), "Brand", "낙인 /브렌드 /메이커"), "BarcodeSymbology", "바코드 상징"), "ProductCost", "제품 비용"), "ProductPrice", "제품 가격"), "UnitProduct", "단위 제품 은"), "TaxMethod", "세금 방법"), "MultipleImage", "여러 이미지"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductHasMultiVariants", "제품에는 여러 가지 변형이 있습니다"), "ProductHasPromotion", "상품에 프로모션이 있습니다"), "PromotionStart", "프로모션 시작 /할인 시작"), "PromotionEnd", "프로모션 종료 /할인종료"), "PromotionPrice", "프로모션 가격 /할인가격"), "Price", " 값"), "Cost", "비용"), "Unit", "단합"), "ProductVariant", "제품 변형"), "Variant", "변형"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitPrice", "단가"), "CreateReturnCustomer", "고객 반품 만들기"), "EditReturnCustomer", "고객 반품 편집"), "CreateReturnSupplier", "공급업체 반환 만들기"), "Documentation", "문서"), "EditReturnSupplier", "공급업체 반환 편집"), "FromWarehouse", "창고"), "ToWarehouse", "창고에"), "EditTransfer", "전송 편집"), "TransferDetail", "전송 세부 사항"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Pending", "보류 중"), "Received", "수신"), "Ordered", "깔끔한"), "PermissionsManager", "권한 관리자"), "BrandManager", "브랜드 매니저"), "BrandImage", "브랜드 이미지"), "BrandName", "브랜드 이름"), "BrandDescription", "브랜드 설명"), "BaseUnit", "베이스 유닛"), "ManagerUnits", "관리 단위"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "OperationValue", "운영 가치"), "Operator", "연산자"), "Top5Products", "5 최고의 제품"), "Last5Sales", "마지막 5 판매"), "ListAdjustments", "설정 목록"), "ListTransfers", "전송 목록"), "CreateTransfer", "전송 만들기"), "OrdersManager", "주문 관리자"), "ListQuotations", "견적 목록"), "ListPurchases", "쇼핑 목록"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ListSales", "판매 목록"), "ListReturns", "반환 목록"), "PeopleManager", "사람 관리자"), "ListofBrand", "브랜드 목록"), "Delete", {
  Title: "확실한가요?",
  Text: "이것을 되돌릴 수 없습니다!",
  confirmButtonText: "예, 삭제!",
  cancelButtonText: "취소",
  Deleted: "제거!",
  Failed: "실패했습니다!",
  Therewassomethingwronge: "뭔가 잘못됐다.",
  CustomerDeleted: "이 고객님이 삭제되었습니다.",
  SupplierDeleted: "이 공급자가 제거되었습니다.",
  QuoteDeleted: "이 견적이 삭제되었습니다.",
  SaleDeleted: "이 판매는 제거되었습니다.",
  PaymentDeleted: "이 지불은 제거되었습니다.",
  PurchaseDeleted: "이 구매는 제거되었습니다.",
  ReturnDeleted: "이 반환이 제거되었습니다.",
  ProductDeleted: "이 쪽의 상품은 제거되었습니다.",
  ClientError: "이 고객은 이미 다른 작업에 연결되어 있습니다.",
  ProviderError: "이 공급자는 이미 다른 작업에 연결되어 있습니다.",
  UserDeleted: "이 사용자가 삭제되었습니다.",
  UnitDeleted: "이 유닛이 제거되었습니다.",
  RoleDeleted: "이 역할이 제거되었습니다.",
  TaxeDeleted: "이 세금은 제거되었습니다.",
  SubCatDeleted: "이 하위 범주가 제거되었습니다.",
  CatDeleted: "이 범주가 삭제되었습니다.",
  WarehouseDeleted: "이 창고가 제거되었습니다.",
  AlreadyLinked: "이 제품은 이미 다른 작업에 연결되어 있습니다",
  AdjustDeleted: "이 조정이 제거되었습니다.",
  TitleCurrency: "이 동전은 제거되었습니다.",
  TitleTransfer: "전송이 성공적으로 삭제되었습니다",
  BackupDeleted: "백업이 성공적으로 삭제되었습니다.",
  TitleBrand: "이 표시가 제거되었습니다."
}), "Update", {
  TitleProfile: "프로필이 성공적으로 업데이트되었습니다",
  TitleAdjust: "조정이 성공적으로 업데이트되었습니다",
  TitleRole: "역할이 성공적으로 업데이트되었습니다",
  TitleUnit: "유닛이 성공적으로 업데이트되었습니다",
  TitleUser: "성공적으로 업데이트 된 사용자",
  TitleCustomer: "고객이 성공적으로 업그레이드",
  TitleQuote: "예산이 올바르게 업데이트되었습니다",
  TitleSale: "판매가 성공적으로 업데이트되었습니다",
  TitlePayment: "결제가 성공적으로 업데이트되었습니다",
  TitlePurchase: "성공적으로 업데이트 된 구매",
  TitleReturn: "성공적으로 업데이트된 반환",
  TitleProduct: "제품이 성공적으로 업데이트되었습니다",
  TitleSupplier: "공급업체가 성공적으로 업데이트되었습니다",
  TitleTaxe: "세금이 성공적으로 업데이트되었습니다",
  TitleCat: "카테고리가 성공적으로 업데이트되었습니다",
  TitleWarhouse: "창고가 성공적으로 업데이트되었습니다",
  TitleSetting: "구성이 성공적으로 업데이트되었습니다",
  TitleCurrency: "이 동전이 업데이트되었습니다.",
  TitleTransfer: "전송이 성공적으로 업데이트되었습니다",
  TitleBrand: "이 브랜드는 업데이트되었습니다."
}), "Create", {
  TitleBrand: "이 브랜드는 만들어졌습니다",
  TitleTransfer: "전송이 성공적으로 만들어졌습니다",
  TitleRole: "역할이 성공적으로 만들어졌습니다",
  TitleUnit: "유닛이 성공적으로 만들어졌습니다",
  TitleUser: "성공적으로 만든 사용자",
  TitleCustomer: "고객이 성공적으로 창조",
  TitleQuote: "약속이 성공적으로 만들어졌습니다",
  TitleSale: "판매가 성공적으로 만들어졌습니다",
  TitlePayment: "결제가 성공적으로 만들어졌습니다",
  TitlePurchase: "성공적으로 만든 구매",
  TitleReturn: "성공적으로 만든 반환",
  TitleProduct: "성공적으로 만든 제품",
  TitleSupplier: "공급업체가 성공적으로 만들어졌습니다",
  TitleTaxe: "세금이 성공적으로 생성",
  TitleCat: "카테고리가 성공적으로 만들어졌습니다",
  TitleWarhouse: "창고가 성공적으로 만들어졌습니다",
  TitleAdjust: "성공적으로 맞춤 제작",
  TitleCurrency: "이 통화가 만들어졌습니다."
}), "Send", {
  TitleEmail: "타이틀 이메일"
}), "return", {
  TitleSale: "이 판매는 이미 반환에 연결되어 있습니다!"
}), "RReturnManagement", "반품 관리"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnDetail", "반품 세부 사항"), "EditReturn", "반환 편집"), "AddReturn", "반품 추가"), "EmailReturn", "이메일로 반품 보내기"), "DeleteReturn", "반환 삭제"), "Retoursurcharge", "반납 할증료"), "Laivrison", "배송"), "SelectSale", "판매 선택"), "ZeroPardefault", "항목을 삭제하거나 반환되지 않은 경우 반환된 금액을 0으로 설정할 수 있습니다."), "Return", "반환"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchase", "구매"), "TotalSales", "총 판매"), "TotalPurchases", "총 구매"), "TotalReturns", "총 반환"), "PaiementsNet", "순 결제"), "PaiementsSent", "전송된 결제"), "PaiementsReceived", "파이멘트 수령"), "Recieved", "수신"), "Sent", "발행"), "ProductQuantityAlerts", "제품 수량 경고"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCode", "제품 코드"), "ProductName", "상품명"), "AlertQuantity", "경고 금액"), "WarehouseStockChart", "창고 주식 차트"), "TotalProducts", "총 제품"), "TotalQuantity", "총 수량"), "TopCustomers", "5 최고의 고객"), "TotalAmount", "총 금액"), "TotalPaid", "총 지불"), "CustomerSalesReport", "고객 판매 보고서"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CustomerPaiementsReport", "고객 지불 보고서"), "CustomerQuotationsReport", "고객 견적 보고서"), "Payments", "지불"), "TopSuppliers", "상위 5개 공급업체"), "SupplierPurchasesReport", "공급업체 구매 보고서"), "SupplierPaiementsReport", "공급업체 지불 보고서"), "Name", "이름"), "Code", "코드"), "ManagementWarehouse", "창고 관리"), "ZipCode", "우편 번호"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementCategories", "카테고리 관리"), "Codecategorie", "코드 범주"), "Namecategorie", "이름 카테고리"), "Parentcategorie", "주요 카테고리"), "managementTax", "재정 관리"), "TaxName", "세금 이름"), "TaxRate", "세율"), "managementUnitPurchases", "구매 단위의 관리"), "managementUnitSales", "영업 단위 관리"), "ShortName", "짧은 이름"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectThesebeforeaddinganyproduct", "제품을 추가하기 전에 선택하십시오."), "StockAdjustement", "주식 조정"), "PleaseSelectWarehouse", "어떤 제품을 선택하기 전에 창고를 선택"), "StockTransfer", "주식 양도"), "SelectPeriod", "기간 선택"), "ThisYear", "금년"), "ThisToday", "오늘"), "ThisMonth", "이번 달"), "ThisWeek", "이번 주"), "AdjustmentDetail", "조정 세부 사항"), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ActivateUser", "이 사용자가 활성화되었습니다."), "DisActivateUser", "이 사용자가 비활성화되었습니다."), "NotFound", "페이지를 찾을 수 없습니다."), "oops", "실수! 페이지를 찾을 수 없습니다."), "couldNotFind", "찾고 있던 페이지를 찾을 수 없었습니다."), "ReturnDashboard", "보드로 돌아가기"), "hrm", '인적자원관리'), "Employees", '직원'), "Attendance", '출석'), "Leave_request", '탈퇴신청'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Leave_type", '휴가 유형'), "Company", '회사'), "Departments", '부서'), "Designations", '명칭'), "Office_Shift", '사무실 교대'), "Holidays", '긴 휴가'), "Enter_Company_Name", '회사명을 입력하세요'), "Enter_email_address", '이메일 주소 입력'), "Enter_Company_Phone", '회사 전화번호 입력'), "Enter_Company_Country", '회사 국가 입력'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Created_in_successfully", '에 성공적으로 생성됨'), "Updated_in_successfully", '에 성공적으로 업데이트되었습니다.'), "Deleted_in_successfully", '에 성공적으로 삭제되었습니다.'), "department", '부서'), "Enter_Department_Name", '부서 이름 입력'), "Choose_Company", '회사 선택'), "Department_Head", '부서장'), "Choose_Department_Head", '부서장 선택'), "Enter_Shift_name", '시프트 이름 입력'), "Monday_In", '월요일 인'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Monday_Out", '월요일 아웃'), "Tuesday_In", '화요일 인'), "tuesday_out", '화요일 아웃'), "wednesday_in", '수요일'), "wednesday_out", '수요일 외출'), "thursday_in", '목요일 인'), "thursday_out", '목요일 아웃'), "friday_in", '금요일 인'), "friday_out", '금요일 아웃'), "saturday_in", '토요일 인'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "saturday_out", '토요일 아웃'), "sunday_in", '일요일 인'), "sunday_out", '일요일 외출'), "Holiday", '휴일'), "Enter_title", '제목 입력'), "title", '제목'), "start_date", '시작일'), "Enter_Start_date", '시작일 입력'), "Finish_Date", '종료일'), "Enter_Finish_date", '종료일 입력'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_provide_any_details", '세부정보를 제공하세요.'), "Attendances", '출석'), "Enter_Attendance_date", '출석일 입력'), "Time_In", '타임 인'), "Time_Out", '타임아웃'), "Choose_Employee", '직원을 선택하십시오'), "Employee", '직원'), "Work_Duration", '작업 시간'), "remaining_leaves_are_insufficient", '남은 잎사귀가 부족하다'), "Leave_Type", '휴가 유형'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Days", '하루'), "Department", '부서'), "Choose_leave_type", '휴가 유형 선택'), "Choose_status", '상태를 선택하십시오'), "Leave_Reason", '이유를 남겨주세요'), "Enter_Reason_Leave", '휴직 사유 입력'), "Add_Employee", '사원 추가'), "FirstName", '이름'), "Enter_FirstName", '이름을 입력하십시오'), "LastName", '수리남'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_LastName", '성을 입력'), "Gender", '성별'), "Choose_Gender", '성별 선택'), "Enter_Birth_date", '생년월일 입력'), "Birth_date", '생년월일'), "Enter_Country", '국가 입력'), "Enter_Phone_Number", '전화번호 입력'), "joining_date", '가입 날짜'), "Enter_joining_date", '가입 날짜 입력'), "Choose_Designation", '지정을 선택하십시오'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Designation", '명칭'), "Office_Shift", '사무실 교대'), "Choose_Office_Shift", '사무실 교대를 선택하십시오'), "Enter_Leaving_Date", '출발일 입력'), "Leaving_Date", '출발일'), "Annual_Leave", '연차 휴가'), "Enter_Annual_Leave", '연차휴가 입력'), "Remaining_leave", '남은 휴가'), "Employee_Details", '직원 세부 정보'), "Basic_Information", '기본 정보'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Family_status", '가족 상태'), "Choose_Family_status", '가족 상태 선택'), "Employment_type", '고용 유형'), "Select_Employment_type", '고용 유형 선택'), "Enter_City", '도시를 입력하십시오'), "Province", '지방'), "Enter_Province", '귀하의 지역을 입력하십시오'), "Enter_Address", '주소를 입력하십시오'), "Enter_Zip_code", '우편 번호를 입력하세요'), "Zip_code", '우편 번호'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Hourly_rate", '시간당 요금'), "Enter_Hourly_rate", '시간당 요금 입력'), "Basic_salary", '기본 급여'), "Enter_Basic_salary", '기본급을 입력하세요.'), "Social_Media", '소셜 미디어'), "Skype", '스카이프'), "Enter_Skype", '스카이프를 입력하세요.'), "Facebook", '페이스북'), "Enter_Facebook", '당신의 페이스 북을 입력'), "WhatsApp", '왓츠앱'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_WhatsApp", 'Whatsapp을 입력하십시오.'), "LinkedIn", '링크드인'), "Enter_LinkedIn", '링크드인을 입력하세요'), "Twitter", '트위터'), "Enter_Twitter", '귀하의 트위터를 입력'), "Experiences", '경험담'), "bank_account", '은행 계좌'), "Company_Name", '회사 명'), "Location", '위치'), "Enter_location", '위치를 입력하십시오'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Description", '설명을 입력하십시오'), "Bank_Name", '은행 이름'), "Enter_Bank_Name", '은행 이름 입력'), "Bank_Branch", '은행 지점'), "Enter_Bank_Branch", '은행 지점 입력'), "Bank_Number", '은행 번호'), "Enter_Bank_Number", '은행 번호 입력'), "Assigned_warehouses", '지정된 창고'), "Top_customers", '상위 고객'), "Attachment", '부착'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "view_employee", '직원보기'), "edit_employee", '직원 편집'), "delete_employee", '직원 삭제'), "Created_by", '추가한 사람'), "Add_product_IMEI_Serial_number", '제품 IMEI/일련번호 추가'), "Product_Has_Imei_Serial_number", '제품에 Imei/일련 번호가 있음'), "IMEI_SN", 'IMEI/SN'), "Shipments", '배송'), "delivered_to", '배달'), "shipment_ref", '배송 참조'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "sale_ref", '판매 참조'), "Edit_Shipping", '배송 수정'), "Packed", '포장 된'), "Shipped", '배송됨'), "Delivered", '배달됨'), "Cancelled", '취소 된'), "Shipping_status", '배송 상태'), "Users_Report", '사용자 보고서'), "stock_report", '주식 보고서'), "TotalPurchases", '총 구매'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Total_quotations", '총 견적'), "Total_return_sales", '총 반품 판매'), "Total_return_purchases", '총 반품 구매'), "Total_transfers", '총 이체'), "Total_adjustments", '총 조정'), "User_report", '사용자 보고서'), "Current_stock", '현재 재고'), "product_name", '상품명'), "Total_Customers_Due", '총 부채'), "Total_Suppliers_Due", '총 부채'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Some_warehouses", '일부 창고'), "All_Warehouses", '모든 창고'), "Product_Cost", '제품 비용'), "sms_settings", 'SMS 설정'), "pos_settings", 'POS 설정'), "payment_gateway", '결제 게이트웨이'), "mail_settings", '메일 설정'), "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", '기본 SMS 게이트웨이'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "module_settings", '모듈 설정'), "Module_enabled_success", '모듈이 성공적으로 활성화되었습니다.'), "Module_Disabled_success", '모듈이 성공적으로 비활성화되었습니다.'), "update_settings", '설정 업데이트'), "Please_Upload_the_Correct_Module", '올바른 모듈을 업로드하십시오'), "Uploaded_Success", '에 성공적으로 업로드됨'), "Customer_details", '고객 세부 정보'), "Edit_Customer", '고객 편집'), "Delete_Customer", '삭제'), "Pay_Due", '모든 납입금을 지불하다'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Paying_amount_is_greater_than_Total_Due", '지불 금액이 총액보다 큽니다.'), "Customer_Invoice", '고객 송장'), "This_Product_Not_For_Selling", '이 제품은 판매용이 아닙니다.'), "Welcome_to_your_Dashboard", '대시보드에 오신 것을 환영합니다'), "Total_Payable", '총액'), "Choose_Sale_Ref", '판매 참조를 선택하십시오'), "Please_Select_Sale", '세일을 선택해주세요'), "Sale_Ref", '판매 참고 자료'), "list_product_returns", '제품 반품 나열'), "Qty_return", '반품 수량'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Purchase_Ref", '구매 참조 선택'), "Purchase_Ref", '구매 참조'), "please_select_purchase", '구매를 선택해주세요'), "qty_return_is_greater_than_qty_purchased", '반품 수량은 구매 수량보다 많습니다.'), "qty_return_is_greater_than_qty_sold", '반품 수량은 판매 수량보다 많습니다.'), "Quantity_sold", '판매 수량'), "qty_purchased", '구매 수량'), "Sender_Name", '보내는 사람 이름'), "The_module_must_be_uploaded_as_zip_file", '모듈은 zip 파일로 업로드해야 합니다.'), "Upload_Module", '업로드 모듈'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "All_Modules_Installed", '설치된 모든 모듈'), "Current_Version", '현재 버전'), "You_already_have_the_latest_version", '당신은 이미 최신 버전을 가지고 있습니다'), "Update_Available", '사용 가능한 업데이트'), "Update_Log", '업데이트 로그'), "Update_Now", '지금 업데이트'), "View_Change_Log", '변경 로그 보기'), "invoice_footer", '인보이스 바닥글'), "Please_Wait_for_the_update", '참고: 업데이트가 완전히 완료될 때까지 기다리십시오. 브라우저를 닫거나 프로세스를 중지하지 않는 것이 좋습니다. 업그레이드'), "Note_update", '참고: 업그레이드를 실행하기 전에 현재 버전 및 데이터베이스를 백업했는지 확인하십시오. 오류가 있는 경우 복원하려면'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Time_Zone", '시간대'), "Payment_note", '지불 메모'), "sale_note", '판매 노트'), "Total_Sale_Due", '총 판매 부채'), "Total_Sell_Return_Due", '총 판매 반환 부채'), "pay_all_sell_due_at_a_time", '한 번에 모든 판매 부채를 지불'), "pay_all_sell_return_due_at_a_time", '한 번에 모든 판매 반환 부채를 지불'), "Gross_Profit", '총 이익'), "pay_all_purchase_due_at_a_time", '한 번에 모든 구매 부채를 갚다'), "Delete_Provider", '공급자 삭제'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Provider", '제공자 편집'), "Provider_details", '제공업체 세부정보'), "Total_Purchase_Due", '총 구매 부채'), "Provider_Credit_Note", '신용 노트'), "Customer_Credit_Note", '신용 노트'), "Sell_Return", '반품 판매'), "Purchase_Return", '구매 반품'), "Tax_Number", '세금 번호'), "Please_add_return_quantity", '반품 수량을 추가해주세요'), "Return_exist_for_the_Transaction", '거래에 대한 반품이 있습니다.'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "qty_return_is_greater_than_Quantity_Remaining", '반품 수량은 남은 수량보다 큽니다.'), "products_refunded_alert", '수량을 0으로 설정한 제품은 환불되지 않습니다.'), "pay_all_purchase_return_due_at_a_time", '한 번에 모든 구매 반환을 지불'), "Total_Purchase_Return_Due", '총 구매 반환 부채'), "Purchase_return_due", '반환 부채를 구입'), "Sell_return_due", '반환 부채를 팔다'), "product_report", '제품 보고서'), "product_sales_report", '제품 판매 보고서'), "Product_purchases_report", '제품 구매 보고서'), "Qty_sold", '판매 수량'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Qty_purchased", '구입한 수량'), "Filter_by_warehouse", '창고로 필터링'), "Enable_Print_Invoice", '인보이스 자동 인쇄'), "Show_Warehouse", '보기 창고'), "credit_card_info", '신용카드 정보'), "Saved_Credit_Card_Info", '저장된 신용카드 정보'), "Credit_card_changed_successfully", '신용카드가 성공적으로 변경되었습니다'), "notification_template", '알림 템플릿'), "email_notification", '이메일 알림'), "sms_notification", 'SMS 알림'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Change_product_details", '제품 상세 정보 수정'), "edit_tax_and_discount_and_shipping", '세금, 할인 및 배송 수정'), "Create_Quotation_with_Stock", '재고를 활용한 견적서 생성'), "Variant_Name", '변형 이름'), "Variant_cost", '변형 비용'), "Variant_price", '변형 가격'), "Variant_code", '변형 코드'), "Please_wait_until_the_product_is_loaded", '제품 로딩이 완료될 때까지 기다려주십시오'), "Choose_SMS_Gateway", 'SMS 게이트웨이 선택'), "Notification_Client", '고객 알림'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Available_Tags", '사용 가능한 태그'), "Email_Subject", '이메일 제목'), "Email_body", '이메일 본문'), "Notification_Supplier", '공급 업체 알림'), "sms_body", 'SMS 본문'), "sms_templates", 'SMS Templates'), "email_templates", 'Email Templates'));

/***/ }),

/***/ "./resources/src/translations/locales/ru.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/ru.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Russian

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Чек',
  Pos_Settings: 'Настройки точки продаж',
  Note_to_customer: 'Примечание для покупателя',
  Show_Note_to_customer: 'Показать заметку покупателю',
  Show_barcode: 'Показать штрих-код',
  Show_Tax_and_Discount: 'Показать налог, скидки и доставка',
  Show_Customer: 'Показать клиента',
  Show_Email: 'Показать электронную почту',
  Show_Phone: 'Показать телефон',
  Show_Address: 'Показать адрес',
  DefaultLanguage: 'Язык по умолчанию',
  footer: 'нижний колонтитул',
  Received_Amount: 'Полученная сумма',
  Paying_Amount: 'Сумма платежа',
  Change: 'Изменять',
  Paying_amount_is_greater_than_Received_amount: 'Сумма платежа больше полученной суммы',
  Paying_amount_is_greater_than_Grand_Total: 'Сумма платежа превышает общую сумму',
  code_must_be_not_exist_already: 'код уже не должен существовать',
  You_will_find_your_backup_on: 'Вы найдете резервную копию на',
  and_save_it_to_your_pc: 'и сохраните на свой компьютер',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Отсканируйте свой штрих-код и выберите правильную символику ниже',
  Scan_Search_Product_by_Code_Name: 'Сканирование / поиск продукта по кодовому названию',
  Paper_size: 'Размер бумаги',
  Clear_Cache: 'Очистить кэш',
  Cache_cleared_successfully: 'Кеш успешно очищен',
  Failed_to_clear_cache: 'Не удалось очистить кеш',
  Scan_Barcode: 'Сканер штрих-кода',
  Please_use_short_name_of_unit: 'Пожалуйста, используйте короткое название единицы',
  DefaultCustomer: 'Клиент по умолчанию',
  DefaultWarehouse: 'Склад по умолчанию',
  Payment_Gateway: 'Платежный шлюз',
  SMS_Configuration: 'Конфигурация SMS',
  Gateway: 'Платежный шлюз',
  Choose_Gateway: 'Выберите платежный шлюз',
  Send_SMS: 'Сообщение успешно отправлено',
  sms_config_invalid: 'неверная конфигурация смс недействительна',
  Remove_Stripe_Key_Secret: 'Удалить ключи API Stripe',
  credit_card_account_not_available: 'Счет кредитной карты недоступен',
  Credit_Card_Info: 'Информация о кредитной карте',
  developed_by: 'Разработан',
  Unit_already_linked_with_sub_unit: 'Объект уже связан с дополнительным блоком',
  Total_Items_Quantity: 'Итого и количество',
  Value_by_Cost_and_Price: 'Соотношение затрат и цен',
  Search_this_table: 'Искать в этой таблице',
  import_products: 'Импортные товары',
  Field_optional: 'Поле необязательно',
  Download_exemple: 'Скачать пример',
  field_must_be_in_csv_format: 'Поле должно быть в формате csv.',
  Successfully_Imported: 'Успешно импортировано',
  file_size_must_be_less_than_1_mega: 'Размер файла не должен превышать 1 мегабайт.',
  Please_follow_the_import_instructions: 'Следуйте инструкциям по импорту',
  must_be_exist: 'юнит уже должен быть создан',
  Import_Customers: 'Импортные клиенты',
  Import_Suppliers: 'Поставщики импорта',
  Recent_Sales: 'Последние продажи',
  Create_Transfer: 'Создать перевод',
  order_products: 'элементы заказа',
  Search_Product_by_Code_Name: 'Поиск продукта по коду или названию',
  Reports_payments_Purchase_Return: 'Отчеты о возвратных платежах за покупку',
  Reports_payments_Sale_Return: 'Отчеты о продажах и возвратах платежей',
  payments_Sales_Return: 'возврат платежей',
  payments_Purchases_Return: 'платежи покупки возврат',
  CreateSaleReturn: 'Создать возврат продажи',
  EditSaleReturn: 'Изменить возврат продажи',
  SalesReturn: 'Возвращение продаж',
  CreatePurchaseReturn: 'Создать возврат покупки',
  EditPurchaseReturn: 'Изменить возврат покупки',
  PurchasesReturn: 'Покупки Возврат',
  Due: 'должный',
  Profit: 'Выгода',
  Revenue: 'Доход',
  Sales_today: 'Продажи сегодня',
  People: 'Люди',
  Successfully_Created: 'Успешно создано',
  Successfully_Updated: 'Успешно обновлено',
  Success: 'Успех',
  Failed: 'Не удалось',
  Warning: 'Warning',
  Please_fill_the_form_correctly: 'Пожалуйста, заполните форму правильно',
  Field_is_required: 'Поле, обязательное для заполнения',
  Error: 'Ошибка!',
  you_are_not_authorized: 'Извини! вы не авторизованы.',
  Go_back_to_home: 'Вернуться на главную',
  page_not_exist: 'Извини! Страница, которую вы искали, не существует.',
  Choose_Status: 'Выберите статус',
  Choose_Method: 'Выберите метод',
  Choose_Symbology: 'Выберите символы',
  Choose_Category: 'Выберите категорию',
  Choose_Customer: 'Выберите клиента',
  Choose_Supplier: 'Выберите поставщика',
  Choose_Unit_Purchase: 'Выберите покупную единицу',
  Choose_Sub_Category: 'Выберите подкатегорию',
  Choose_Brand: 'Выберите марку',
  Choose_Warehouse: 'Выберите склад',
  Choose_Unit_Sale: 'Выберите единицу продажи',
  Enter_Product_Cost: 'Введите стоимость продукта',
  Enter_Stock_alert: 'Введите оповещение о наличии акций',
  Choose_Unit_Product: 'Выберите единицу продукции',
  Enter_Product_Price: 'Введите цену продукта',
  Enter_Name_Product: 'Введите название продукта',
  Enter_Role_Name: 'Введите имя роли',
  Enter_Role_Description: 'Введите описание роли',
  Enter_name_category: 'Введите название категории',
  Enter_Code_category: 'Введите код категории',
  Enter_Name_Brand: 'Введите название бренда',
  Enter_Description_Brand: 'Введите описание бренда',
  Enter_Code_Currency: 'Введите валюту кода',
  Enter_name_Currency: 'Введите имя Валюта',
  Enter_Symbol_Currency: 'Введите валюту символа',
  Enter_Name_Unit: 'Введите название объекта',
  Enter_ShortName_Unit: 'Введите короткое имя',
  Choose_Base_Unit: 'Выберите базовый блок',
  Choose_Operator: 'Выберите оператора',
  Enter_Operation_Value: 'Введите значение операции',
  Enter_Name_Warehouse: 'Введите название склада',
  Enter_Phone_Warehouse: 'Введите телефон склада',
  Enter_Country_Warehouse: 'Укажите страну склада',
  Enter_City_Warehouse: 'Введите город склада',
  Enter_Email_Warehouse: 'Введите адрес электронной почты склада',
  Enter_ZipCode_Warehouse: 'Введите почтовый индекс склада',
  Choose_Currency: 'Выберите Валюту',
  Thank_you_for_your_business: 'Спасибо за ваш бизнес!',
  Cancel: 'Отмена',
  New_Customer: 'Новый покупатель',
  Incorrect_Login: 'Неправильный логин',
  Successfully_Logged_In: 'Успешный вход в систему',
  This_user_not_active: 'Этот пользователь не активен',
  SignIn: 'Войти',
  Create_an_account: 'Завести аккаунт',
  Forgot_Password: 'Забыл пароль ?',
  Email_Address: 'Адрес электронной почты',
  SignUp: 'Зарегистрироваться',
  Already_have_an_account: 'Уже есть аккаунт?',
  Reset_Password: 'Сброс пароля',
  Failed_to_authenticate_on_SMTP_server: 'Не удалось пройти аутентификацию на SMTP-сервере',
  We_cant_find_a_user_with_that_email_addres: 'Мы не можем найти пользователя с таким адресом электронной почты',
  We_have_emailed_your_password_reset_link: 'Мы отправили вам ссылку для сброса пароля по электронной почте',
  Please_fill_the_Email_Adress: 'Пожалуйста, заполните адрес электронной почты',
  Confirm_password: 'Подтвердить Пароль',
  Your_Password_has_been_changed: 'Ваш пароль был изменен',
  The_password_confirmation_does_not_match: 'Подтверждение пароля не совпадает',
  This_password_reset_token_is_invalid: 'Этот токен сброса пароля недействителен',
  Warehouse_report: 'Отчет о складе',
  All_Warehouses: 'Все склады',
  Expense_List: 'Список расходов',
  Expenses: 'Затраты',
  This_Week_Sales_Purchases: 'Продажи и покупки на этой неделе',
  Top_Selling_Products: 'Самые продаваемые товары',
  View_all: 'Посмотреть все',
  Payment_Sent_Received: 'Платеж отправлен и получен',
  Filter: 'Фильтр',
  Invoice_POS: 'Счет-фактура POS',
  Invoice: 'Выставленный счет',
  Customer_Info: 'Информация о клиенте',
  Company_Info: 'информация о компании',
  Invoice_Info: 'Информация о счете',
  Order_Summary: 'итог заказа',
  Quote_Info: 'Ценовая информация',
  Del: 'удалять',
  SuppliersPaiementsReport: 'Отчет о платежах поставщикам',
  Purchase_Info: 'Информация о покупке',
  Supplier_Info: 'Информация о поставщиках',
  Return_Info: 'информация о возврате',
  Expense_Category: 'Категория расходов',
  Create_Expense: 'Создать расход',
  Details: 'Детали',
  Discount_Method: 'Метод скидки',
  Net_Unit_Cost: 'Чистая стоимость единицы',
  Net_Unit_Price: 'Чистая цена за единицу',
  Edit_Expense: 'Изменить расходы',
  All_Brand: 'Все марки',
  All_Category: 'Все категории',
  ListExpenses: 'Перечислить расходы',
  Create_Permission: 'Создать разрешение',
  Edit_Permission: 'Изменить разрешение',
  Reports_payments_Sales: 'Отчеты о платежах Продажи',
  Reports_payments_Purchases: 'Отчеты о платежах Покупки',
  Reports_payments_Return_Customers: 'Отчеты о платежах Возврат клиентов',
  Reports_payments_Return_Suppliers: 'Отчеты о платежах Возврат Поставщикам',
  Expense_Deleted: 'Этот расход был удален',
  Expense_Updated: 'Этот расход был обновлен',
  Expense_Created: 'Этот расход был создан',
  DemoVersion: 'Вы не можете этого сделать в демо-версии',
  OrderStatistics: 'Статистика продаж',
  AlreadyAdd: 'Этот продукт уже добавлен!',
  AddProductToList: 'Пожалуйста, добавьте товар в список!',
  AddQuantity: 'Пожалуйста, добавьте количество деталей !!',
  InvalidData: 'Неверные данные !!',
  LowStock: 'количество превышает количество на складе',
  WarehouseIdentical: 'Два склада не могут быть идентичными !!',
  VariantDuplicate: 'Этот вариант дублируется !!',
  Filesize: 'Размер файла',
  GenerateBackup: 'Создать резервную копию',
  BackupDatabase: 'Резервная база данных',
  Backup: 'резервное копирование',
  Paid: 'Платный',
  Unpaid: 'Неоплаченный',
  Today: 'Cегодня',
  Income: 'Доход'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'Затраты'), "Sale", 'распродажа'), "Actif", 'Активный'), "Inactif", 'Неактивный'), "Customers", 'Клиенты'), "Phone", 'Телефон'), "SearchByPhone", 'Поиск по телефону'), "Suppliers", 'Поставщики'), "Quotations", 'Котировки'), "Sales", 'Продажи'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'Покупки'), "Returns", 'Возврат'), "Settings", 'Настройки'), "SystemSettings", 'Системные настройки'), "Users", 'Пользователи'), "GroupPermissions", 'Групповые разрешения'), "Currencies", 'Валюты'), "Warehouses", 'Склады'), "Units", 'Единицы'), "UnitsPrchases", 'Покупка единиц'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Единицы продаж'), "Reports", 'Отчеты'), "PaymentsReport", 'Отчет о платежах'), "PaymentsPurchases", 'Платежи Покупки'), "PaymentsSales", 'Платежи Продажи'), "ProfitandLoss", 'Прибыль и убыток'), "WarehouseStockChart", 'График складских запасов'), "SalesReport", 'Отчет о продажах'), "PurchasesReport", 'Отчет о закупках'), "CustomersReport", 'Отчет клиентов'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Отчет о поставщиках'), "SupplierReport", 'Отчет поставщика'), "DailySalesData", 'Ежедневные данные о продажах'), "DailyPurchasesData", 'Данные о ежедневных покупках'), "Derni\xE8rescinqrecords", 'Последние пять рекордов'), "Filters", 'Фильтры'), "date", 'Дата'), "Reference", 'Справка'), "Supplier", 'Поставщик'), "PaymentStatus", 'Статус платежа'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", 'Покупатель'), "CustomerCode", 'Код клиента'), "Status", 'Положение дел'), "SupplierCode", 'Код поставщиком'), "Categorie", 'Категория'), "Categories", 'Категории'), "StockTransfers", 'Передача запасов'), "StockManagement", 'Управление запасами'), "dashboard", 'Щиток приборов'), "Products", 'Товары'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'Список продуктов'), "ProductManagement", 'Управление продуктом'), "ProductQuantityAlerts", 'Оповещения о количестве товаров'), "CodeProduct", 'Код продукта'), "ProductTax", 'Налог на продукцию'), "SubCategorie", 'Подкатегория'), "Name_product", 'Обозначение'), "StockAlert", 'Уведомление о наличии запасов'), "warehouse", 'склад'), "Tax", 'Налог'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Цена покупки'), "SellPrice", 'Цена продажи'), "Quantity", 'Количество'), "UnitSale", 'Продажа единиц'), "UnitPurchase", 'Покупка единицы'), "ManagementCurrencies", 'Валютный менеджмент'), "CurrencyCode", 'Код валюты'), "CurrencyName", 'Название валюты'), "Symbol", 'Символ'), "All", 'Все'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Редактировать продукт'), "SearchByCode", 'Поиск по коду'), "SearchByName", 'Поиск по имени'), "ProductDetails", 'информация о продукте'), "CustomerName", 'Имя Клиента'), "CustomerManagement", 'Управление клиентами'), "Add", 'Создайте'), "add", 'Создайте'), "Edit", 'редактировать'), "Close", 'близко'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Пожалуйста выберите'), "Action", 'Действие'), "Email", 'Электронное письмо'), "EditCustomer", 'Изменить клиента'), "AddCustomer", 'Создать клиента'), "Country", 'Страна'), "City", 'город'), "Adress", 'Адрес'), "CustomerDetails", 'Детали клиента'), "CustomersList", 'Список клиентов'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Код поставщиком'), "SupplierName", 'наименование поставщика'), "SuppliersManagement", 'Управление поставщиками'), "SupplierDetails", 'Детали поставщика'), "QuotationsManagement", 'Управление котировками'), "SubTotal", 'Промежуточный итог'), "MontantReste", 'Осталась сумма'), "complete", 'завершено'), "EnAttendant", 'в ожидании'), "Recu", 'Получила'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", 'Частичное'), "Retournee", 'Возвращение'), "DetailQuote", 'Подробная цитата'), "EditQuote", 'Изменить цитату'), "CreateSale", 'Создать распродажу'), "DownloadPdf", 'Скачать Pdf'), "QuoteEmail", 'Предложение отправлено по электронной почте'), "DeleteQuote", 'Удалить предложение'), "AddQuote", 'Создать предложение'), "SelectProduct", 'Выбрать продукт'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Продукт (Код - Название)'), "Price", 'Цена'), "CurrentStock", 'Склад'), "Total", 'Общее'), "Num", '№'), "Unitcost", 'стоимость единицы'), "to", 'к'), "Subject", 'Предмет'), "Message", 'Сообщение'), "EmailCustomer", 'Электронная почта клиента'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", 'послать'), "Quote", 'Цитата'), "Hello", 'Здравствуйте'), "AttachmentQuote", 'Пожалуйста, найдите приложение к вашему предложению'), "AddProducts", 'Добавить товары в список заказов'), "SelectWarehouse", 'Пожалуйста, выберите склад'), "SelectCustomer", 'пожалуйста, выберите клиента'), "SalesManagement", 'Управление продажами'), "Balance", 'Остаток средств'), "QtyBack", 'Назад Количество'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Общий доход'), "Amount", 'Количество'), "SaleDetail", 'Детали продажи'), "EditSale", 'Изменить распродажу'), "AddSale", 'Создать распродажу'), "ShowPayment", 'Показать платежи'), "AddPayment", 'Создать платеж'), "EditPayment", 'Изменить платеж'), "EmailSale", 'Отправить распродажу по электронной почте'), "DeleteSale", 'Удалить распродажу'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Оплачивается'), "Paymentchoice", 'Выбор платежа'), "Note", 'Заметка'), "PaymentComplete", 'Оплата завершена!'), "PurchasesManagement", 'Управление закупками'), "Ordered", 'Упорядоченный'), "DeletePurchase", 'Удалить покупку'), "EmailPurchase", 'Отправить покупку по электронной почте'), "EditPurchase", 'Изменить покупку'), "PurchaseDetail", 'Детали покупки'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Создать покупку'), "EmailSupplier", 'Электронная почта поставщика'), "PurchaseInvoice", 'Оплата покупок'), "PurchasesInvoicesData", 'Данные о платежах покупок'), "SalesInvoice", 'Платежи за продажу'), "SalesInvoicesData", 'Данные о продажах'), "UserManagement", 'управление пользователями'), "Firstname", 'Имя'), "lastname", 'фамилия'), "username", 'Имя пользователя'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", 'пароль'), "Newpassword", 'Новый пароль'), "ChangeAvatar", 'Сменить аватар'), "LeaveBlank", 'Оставьте это поле пустым, если вы его не меняли'), "type", 'тип'), "UserPermissions", 'Разрешения пользователей'), "RoleName", 'Роль'), "RoleDescription", 'Описание роли'), "AddPermissions", 'Создать разрешения'), "View", 'Посмотреть'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", 'удалять'), "NewAdjustement", 'Новая корректировка'), "EditAdjustement", 'Изменить настройку'), "CannotSubstraction", 'Вы не можете вычесть продукты, у которых есть запас 0'), "Addition", 'Дополнение'), "Subtraction", 'Вычитание'), "profil", 'профиль'), "logout", 'выйти'), "PurchaseAlreadyPaid", 'вы не можете изменить, потому что эта покупка уже оплачена'), "SaleAlreadyPaid", 'вы не можете изменить, потому что эта Распродажа уже оплачена'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'вы не можете изменить, потому что этот возврат уже оплачен'), "QuoteAlready", 'Эта цитата уже привела к продаже'), "AddProduct", 'Создать продукт'), "QuotationComplete", 'Цитата завершена'), "SiteConfiguration", 'Конфигурация сайта'), "Language", 'Язык'), "DefaultCurrency", 'Валюта по умолчанию'), "LoginCaptcha", 'Войти Captcha'), "DefaultEmail", 'Почта по умолчанию'), "SiteName", 'Название сайта'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Изменить логотип'), "SMTPConfiguration", 'Конфигурация SMTP'), "HOST", 'ВЕДУЩИЙ'), "PORT", 'ПОРТ'), "encryption", 'Шифрование'), "SMTPIncorrect", 'Неправильная конфигурация SMTP'), "PaymentsReturns", 'Платежи Возврат'), "ReturnsInvoices", 'Возврат счетов'), "ReturnsInvoicesData", 'Возвращает данные счетов-фактур'), "ShowAll", 'Показать все записи всех пользователей'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", 'Скидка'), "OrderTax", 'Налог на заказ'), "Shipping", 'Перевозка'), "CompanyName", 'Название компании'), "CompanyPhone", 'Телефон компании'), "CompanyAdress", 'Адрес компании'), "Code", 'Код'), "image", 'образ'), "Printbarcode", 'Распечатать штрих-код'), "ReturnsCustomers", 'Возвращает клиентов'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'Возврат Поставщикам'), "FactureReturnCustomers", 'Возврат счета-фактуры клиента'), "FactureReturnSuppliers", 'Счет-фактура возврата поставщика'), "NodataAvailable", 'Данные недоступны'), "ProductImage", 'Изображение продукта'), "Barcode", 'Штрих-код'), "pointofsales", 'Точка продаж'), "CustomUpload", 'Пользовательская загрузка'), "pointofsaleManagement", 'точка управления продажами'), "Adjustment", 'Регулировка'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", 'Обновить'), "Reset", 'Сброс настроек'), "print", 'Распечатать'), "SearchByEmail", 'Поиск по почте'), "ChooseProduct", 'Выберите продукт'), "Qty", 'Кол-во'), "Items", 'Предметы'), "AmountHT", 'Количество'), "AmountTTC", 'общая сумма'), "PleaseSelectSupplier", 'Пожалуйста, выберите поставщика'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Пожалуйста, выберите статус'), "PayeBy", 'Оплачивается'), "ChooseWarehouse", 'Выберите склад'), "payNow", 'Заплатить сейчас'), "ListofCategory", 'Список категорий'), "Description", 'Описание'), "submit", 'представить'), "ProblemCreatingThisInvoice", 'При создании этого счета возникла проблема. Пожалуйста, попробуйте еще раз'), "ProblemPayment", 'Возникла проблема с оплатой. Пожалуйста, попробуйте еще раз.'), "IncomeExpenses", 'Доходы и расходы'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'Ежедневные продажи и покупки'), "ProductsExpired", 'Срок действия продуктов истек'), "ListofBrand", 'Список брендов'), "CreateAdjustment", 'Создать корректировку'), "Afewwords", 'Несколько слов ...'), "UserImage", 'Изображение пользователя'), "UpdateProduct", 'Обновить продукт'), "Brand", 'Марка'), "BarcodeSymbology", 'Символика штрих-кода'), "ProductCost", 'Стоимость продукта'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Цена продукта'), "UnitProduct", 'Единица продукта'), "TaxMethod", 'Налоговый метод'), "MultipleImage", 'Несколько изображений'), "ProductHasMultiVariants", 'Продукт имеет несколько вариантов'), "ProductHasPromotion", 'У продукта есть продвижение'), "PromotionStart", 'Начало продвижения'), "PromotionEnd", 'Конец акции'), "PromotionPrice", 'Цена акции'), "Price", 'Цена'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Cost", 'Стоимость'), "Unit", 'Ед. изм'), "ProductVariant", 'Вариант продукта'), "Variant", 'Вариант'), "UnitPrice", 'Цена за единицу'), "CreateReturnCustomer", 'Создать возвратного клиента'), "EditReturnCustomer", 'Изменить возвратного клиента'), "CreateReturnSupplier", 'Создать поставщика возврата'), "Documentation", 'Документация'), "EditReturnSupplier", 'Изменить поставщика возврата'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'Со склада'), "ToWarehouse", 'На склад'), "EditTransfer", 'Редактировать перевод'), "TransferDetail", 'Детали перевода'), "Pending", 'В ожидании'), "Received", 'Получила'), "Ordered", 'Упорядоченный'), "PermissionsManager", 'Управление разрешениями'), "BrandManager", 'Марка'), "BrandImage", 'Фирменное изображение'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BrandName", 'Имя бренда'), "BrandDescription", 'Описание бренда'), "BaseUnit", 'Базовый блок'), "ManagerUnits", 'Управление подразделениями'), "OperationValue", 'Значение операции'), "Operator", 'Оператор'), "Top5Products", 'Пять лучших продуктов'), "Last5Sales", 'Последние пять продаж'), "ListAdjustments", 'Список корректировок'), "ListTransfers", 'Список переводов'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Создать перевод'), "OrdersManager", 'Управление заказами'), "ListQuotations", 'Список котировок'), "ListPurchases", 'Список покупок'), "ListSales", 'Список продаж'), "ListReturns", 'Список возвратов'), "PeopleManager", 'Управление персоналом'), "Delete", {
  Title: 'Ты уверен?',
  Text: 'Вы не сможете отменить это!',
  confirmButtonText: 'Да удалите!',
  cancelButtonText: 'Отмена',
  Deleted: 'Удалено!',
  Failed: 'Не удалось!',
  Therewassomethingwronge: 'Что-то было не так',
  CustomerDeleted: 'этот Клиент был удален.',
  SupplierDeleted: 'этот поставщик был удален.',
  QuoteDeleted: 'Цитата удалена.',
  SaleDeleted: 'эта распродажа была удалена.',
  PaymentDeleted: 'этот Платеж был удален.',
  PurchaseDeleted: 'эта покупка была удалена.',
  ReturnDeleted: 'этот возврат был удален.',
  ProductDeleted: 'этот продукт был удален.',
  ClientError: 'Этот клиент уже связан с другой операцией',
  ProviderError: 'Этот поставщик уже связан с другой операцией',
  UserDeleted: 'Этот пользователь был удален.',
  UnitDeleted: 'Этот блок был удален.',
  RoleDeleted: 'Эта роль удалена.',
  TaxeDeleted: 'Этот налог был удален.',
  SubCatDeleted: 'Эта подкатегория была удалена.',
  CatDeleted: 'Эта категория была удалена.',
  WarehouseDeleted: 'Этот склад был удален.',
  AlreadyLinked: 'этот продукт уже связан с другой операцией',
  AdjustDeleted: 'Эта корректировка была удалена.',
  TitleCurrency: 'Эта валюта была удалена.',
  TitleTransfer: 'Перевод успешно удален',
  BackupDeleted: 'Резервная копия была успешно удалена',
  TitleBrand: 'Этот бренд был удален'
}), "Update", {
  TitleBrand: 'Этот бренд был обновлен',
  TitleProfile: 'Ваш профиль успешно обновлен',
  TitleAdjust: 'Настройка успешно обновлена',
  TitleRole: 'Роль обновлена успешно',
  TitleUnit: 'Объект успешно обновлен',
  TitleUser: 'Пользователь успешно обновлен',
  TitleCustomer: 'Обновление клиента успешно',
  TitleQuote: 'Предложение обновлено успешно',
  TitleSale: 'Распродажа успешно обновлена',
  TitlePayment: 'Платеж успешно обновлен',
  TitlePurchase: 'Покупка успешно обновлена',
  TitleReturn: 'Возврат Обновлено успешно',
  TitleProduct: 'Обновление продукта успешно выполнено',
  TitleSupplier: 'Поставщик успешно обновлен',
  TitleTaxe: 'Налог обновлен успешно',
  TitleCat: 'Категория обновлена успешно',
  TitleWarhouse: 'Склад успешно обновлен',
  TitleSetting: 'Настройки обновлены успешно',
  TitleCurrency: 'Обновление валюты успешно',
  TitleTransfer: 'Перенос успешно обновлен'
}), "Create", {
  TitleBrand: 'Этот бренд был создан',
  TitleRole: 'Роль успешно создана',
  TitleUnit: 'Объект успешно создан',
  TitleUser: 'Пользователь успешно создан в',
  TitleCustomer: 'Клиент успешно создан',
  TitleQuote: 'Предложение создано в успешно',
  TitleSale: 'Распродажа успешно создана',
  TitlePayment: 'Платеж успешно создан',
  TitlePurchase: 'Покупка успешно создана',
  TitleReturn: 'Возврат успешно создан',
  TitleProduct: 'Продукт успешно создан',
  TitleSupplier: 'Поставщик успешно создан',
  TitleTaxe: 'Налог создан в успешно',
  TitleCat: 'Категория создана в успешно',
  TitleWarhouse: 'Склад успешно создан',
  TitleAdjust: 'Корректировка успешно создана',
  TitleCurrency: 'Валюта успешно создана',
  TitleTransfer: 'Перевод успешно создан'
}), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'Электронная почта отправлена успешно'
}), "return", {
  TitleSale: 'эта распродажа уже связана с возвратом!'
}), "ReturnManagement", 'Управление возвратом'), "ReturnDetail", 'Деталь возврата'), "EditReturn", 'Изменить возврат'), "AddReturn", 'Создать возврат'), "EmailReturn", 'Отправить возврат по почте'), "DeleteReturn", 'Удалить возврат'), "Retoursurcharge", 'Return Surcharge'), "Laivrison", 'Доставка'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Выбрать распродажу'), "ZeroPardefault", 'Вы можете удалить товар или установить возвращаемое количество равным нулю, если оно не возвращается.'), "Return", 'Возвращение'), "Purchase", 'Покупка'), "TotalSales", 'Тотальная распродажа'), "TotalPurchases", 'Всего покупок'), "TotalReturns", 'Общая прибыль'), "PaiementsNet", 'Чистые платежи'), "PaiementsSent", 'Отправленные платежи'), "PaiementsReceived", 'Платежи получены'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Recieved", 'Получила'), "Sent", 'Отправлено'), "ProductQuantityAlerts", 'Оповещения о количестве товаров'), "ProductCode", 'Код'), "ProductName", 'Товар'), "AlertQuantity", 'Количество предупреждений'), "WarehouseStockChart", 'График складских запасов'), "TotalProducts", 'Всего продуктов'), "TotalQuantity", 'Общая численность'), "TopCustomers", 'Пятерка крупнейших клиентов'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Итого'), "TotalPaid", 'Общая сумма'), "CustomerSalesReport", 'Отчет о продажах клиентов'), "CustomerPaiementsReport", 'Отчет о платежах клиентов'), "CustomerQuotationsReport", 'Отчет о предложениях клиентов'), "Payments", 'Платежи'), "TopSuppliers", 'Пятерка лучших поставщиков'), "SupplierPurchasesReport", 'Отчет о закупках поставщика'), "SupplierPaiementsReport", 'Отчет о платежах поставщикам'), "Name", 'название'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Code", 'Код'), "ManagementWarehouse", 'Управление складом'), "ZipCode", 'Почтовый Индекс'), "managementCategories", 'Управление категориями'), "Codecategorie", 'Категория кода'), "Namecategorie", 'Категория имени'), "Parentcategorie", 'Родительская категория'), "managementTax", 'Налоговый менеджмент'), "TaxName", 'Название налога'), "TaxRate", 'Ставка налога'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Единица закупок'), "managementUnitSales", 'Отдел продаж'), "ShortName", 'Короткое имя'), "PleaseSelectThesebeforeaddinganyproduct", 'Пожалуйста, выберите их перед добавлением любого продукта'), "StockAdjustement", 'Регулировка запаса'), "PleaseSelectWarehouse", 'Пожалуйста, выберите склад, прежде чем выбрать любой продукт'), "StockTransfer", 'Передача запасов'), "SelectPeriod", 'Выберите период'), "ThisYear", 'В этом году'), "ThisToday", 'Это сегодня'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'Этот месяц'), "ThisWeek", 'Эта неделя'), "AdjustmentDetail", 'Детали настройки'), "ActivateUser", 'Этот пользователь был активирован'), "DisActivateUser", 'Этот пользователь был деактивирован'), "NotFound", 'Страница не найдена.'), "oops", 'ошибка! Страница не найдена.'), "couldNotFind", 'Мы не смогли найти страницу, которую вы искали. Тем временем вы можете'), "ReturnDashboard", 'вернуться на панель управления'), "hrm", 'УЧР'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Employees", 'Сотрудники'), "Attendance", 'Посещаемость'), "Leave_request", 'Оставьте запрос'), "Leave_type", 'Оставить Тип'), "Company", 'Компания'), "Departments", 'Департаменты'), "Designations", 'Обозначения'), "Office_Shift", 'Офисная смена'), "Holidays", 'Праздники'), "Enter_Company_Name", 'Введите название компании'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Введите адрес электронной почты'), "Enter_Company_Phone", 'Введите телефон компании'), "Enter_Company_Country", 'Введите страну компании'), "Created_in_successfully", 'Создано успешно'), "Updated_in_successfully", 'Обновлено успешно'), "Deleted_in_successfully", 'Удален в успешно'), "department", 'отделение'), "Enter_Department_Name", 'Введите название отдела'), "Choose_Company", 'Выберите компанию'), "Department_Head", 'Начальник отдела'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Выбрать начальника отдела'), "Enter_Shift_name", 'Введите название смены'), "Monday_In", 'Monday In'), "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'Праздничный день'), "Enter_title", 'Введите название'), "title", 'заглавие'), "start_date", 'Дата начала'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Введите дату начала'), "Finish_Date", 'Дата окончания'), "Enter_Finish_date", 'Введите дату окончания'), "Please_provide_any_details", 'Пожалуйста, предоставьте любую информацию'), "Attendances", 'Посещаемость'), "Enter_Attendance_date", 'Введите дату присутствия'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", 'Выберите сотрудника'), "Employee", 'Сотрудник'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Длительность работы'), "remaining_leaves_are_insufficient", 'Остальные листья недостаточны'), "Leave_Type", 'Оставить Тип'), "Days", 'Дней'), "Department", 'отделение'), "Choose_leave_type", 'Выберите тип отпуска'), "Choose_status", 'Выберите статус'), "Leave_Reason", 'Оставить причину'), "Enter_Reason_Leave", 'Укажите причину Оставить'), "Add_Employee", 'Добавить сотрудника'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FirstName", 'имя'), "Enter_FirstName", 'Введите имя'), "LastName", 'Фамилия'), "Enter_LastName", 'Введите фамилию'), "Gender", 'гендер'), "Choose_Gender", 'Выберите пол'), "Enter_Birth_date", 'Введите дату рождения'), "Birth_date", 'Дата рождения'), "Enter_Country", 'Введите страну'), "Enter_Phone_Number", 'Введите номер телефона'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "joining_date", 'Дата вступления'), "Enter_joining_date", 'Введите дату присоединения'), "Choose_Designation", 'Выберите обозначение'), "Designation", 'Обозначение'), "Office_Shift", 'Офисная смена'), "Choose_Office_Shift", 'Выбрать офисную смену'), "Enter_Leaving_Date", 'Введите дату отъезда'), "Leaving_Date", 'Дата отъезда'), "Annual_Leave", 'Ежегодный отпуск'), "Enter_Annual_Leave", 'Введите ежегодный отпуск'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'Оставшийся отпуск'), "Employee_Details", 'Сведения о сотруднике'), "Basic_Information", 'Основная информация'), "Family_status", 'Семейный статус'), "Choose_Family_status", 'Выберите семейный статус'), "Employment_type", 'Вид занятости'), "Select_Employment_type", 'Выберите тип занятости'), "Enter_City", 'Введите город'), "Province", 'Область'), "Enter_Province", 'Введите провинцию'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Введите адрес'), "Enter_Zip_code", 'Введите почтовый индекс'), "Zip_code", 'Почтовый индекс'), "Hourly_rate", 'Почасовая ставка'), "Enter_Hourly_rate", 'Введите почасовую ставку'), "Basic_salary", 'Базовая заработная плата'), "Enter_Basic_salary", 'Введите базовую заработную плату'), "Social_Media", 'Социальные сети'), "Skype", 'Скайп'), "Enter_Skype", 'Введите свой скайп'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Facebook", 'Фейсбук'), "Enter_Facebook", 'Введите свой Фейсбук'), "WhatsApp", 'ватсап'), "Enter_WhatsApp", 'Введите свой ватсап'), "LinkedIn", 'ЛинкедИн'), "Enter_LinkedIn", 'Введите свой ЛинкедИн'), "Twitter", 'Твиттер'), "Enter_Twitter", 'Введите свой Твиттер'), "Experiences", 'Опыт'), "bank_account", 'банковский счет'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Company_Name", 'название компании'), "Location", 'положение'), "Enter_location", 'Введите местоположение'), "Enter_Description", 'Введите описание'), "Bank_Name", 'Имя банка'), "Enter_Bank_Name", 'Введите название банка'), "Bank_Branch", 'Филиал банка'), "Enter_Bank_Branch", 'Филиал банка'), "Bank_Number", 'Номер банка'), "Enter_Bank_Number", 'Номер банка'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Присвоенные склады'), "Top_customers", 'Лучшие клиенты'), "Attachment", 'Вложение'), "view_employee", 'просмотреть сотрудников'), "edit_employee", 'редактировать сотрудников'), "delete_employee", 'удалить сотрудников'), "Created_by", 'Добавлено'), "Add_product_IMEI_Serial_number", 'Добавить IMEI/серийный номер продукта'), "Product_Has_Imei_Serial_number", 'Продукт имеет IMEI/серийный номер'), "IMEI_SN", 'IMEI/SN'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Shipments", 'Отгрузки'), "delivered_to", 'Доставлен в'), "shipment_ref", 'Отгрузка'), "sale_ref", 'Продажа Реф.'), "Edit_Shipping", 'Изменить доставку'), "Packed", 'упакованный'), "Shipped", 'Отправленный'), "Delivered", 'Доставленный'), "Cancelled", 'Отменено'), "Shipping_status", 'Статус отправки'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Отчет пользователей'), "stock_report", 'Отчет о запасах'), "TotalPurchases", 'Всего покупок'), "Total_quotations", 'Всего котировок'), "Total_return_sales", 'Общий возврат продаж'), "Total_return_purchases", 'Всего возвращенных покупок'), "Total_transfers", 'Всего переводов'), "Total_adjustments", 'Всего корректировок'), "User_report", 'Пользовательский отчет'), "Current_stock", 'Текущий запас'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_name", 'наименование товара'), "Total_Customers_Due", 'Общая задолженность'), "Total_Suppliers_Due", 'Общая задолженность'), "Some_warehouses", 'Некоторые склады'), "All_Warehouses", 'Все склады'), "Product_Cost", 'Стоимость продукта'), "sms_settings", 'Настройки смс'), "pos_settings", 'Настройки POS'), "payment_gateway", 'Платежный шлюз'), "mail_settings", 'Настройки почты'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'SMS-шлюз по умолчанию'), "module_settings", 'Настройки модуля'), "Module_enabled_success", 'Модуль успешно включен'), "Module_Disabled_success", 'Модуль успешно отключен'), "update_settings", 'Обновить настройки'), "Please_Upload_the_Correct_Module", 'Пожалуйста, загрузите правильный модуль'), "Uploaded_Success", 'Загружено успешно'), "Customer_details", 'Сведения о клиенте'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Редактировать заказчика'), "Delete_Customer", 'Удалить клиента'), "Pay_Due", 'Оплатить должный'), "Paying_amount_is_greater_than_Total_Due", 'Сумма платежа больше общей суммы платежа'), "Customer_Invoice", 'счет-фактура клиента'), "This_Product_Not_For_Selling", 'Этот продукт не для продажи'), "Welcome_to_your_Dashboard", 'Добро пожаловать в вашу панель инструментов'), "Total_Payable", 'Итого к оплате'), "Choose_Sale_Ref", 'Выберите номер продажи'), "Please_Select_Sale", 'Пожалуйста, выберите Распродажа'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Продажа Реф.'), "list_product_returns", 'список возвратов продукции'), "Qty_return", 'Кол-во возврата'), "Choose_Purchase_Ref", 'Выберите покупку реф.'), "Purchase_Ref", 'покупка реф'), "please_select_purchase", 'Пожалуйста, выберите Покупка'), "qty_return_is_greater_than_qty_purchased", 'Кол-во возврата больше, чем куплено'), "qty_return_is_greater_than_qty_sold", 'Возврат количества больше, чем количество продано'), "Quantity_sold", 'Кол-во продано'), "qty_purchased", 'Кол-во куплено'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Имя отправителя'), "The_module_must_be_uploaded_as_zip_file", 'Модуль должен быть загружен в виде zip-файла'), "Upload_Module", 'Выгрузить модуль'), "All_Modules_Installed", 'Все модули установлены'), "Current_Version", 'Текущая версия'), "You_already_have_the_latest_version", 'У вас уже есть последняя версия'), "Update_Available", 'Обновления доступны'), "Update_Log", 'Журнал обновлений'), "Update_Now", 'Обновить сейчас'), "View_Change_Log", 'Просмотр журнала изменений'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'Нижний колонтитул счета'), "Please_Wait_for_the_update", 'ПРИМЕЧАНИЕ. Дождитесь полного завершения обновления. Не рекомендуется закрывать браузер или останавливать процесс обновления.'), "Note_update", 'Примечание. Обязательно сделайте резервную копию текущей версии и базы данных перед запуском обновления, чтобы восстановить их в случае ошибки.'), "Time_Zone", 'Часовой пояс'), "Payment_note", 'отмечает оплату'), "sale_note", 'примечания к продаже'), "Total_Sale_Due", 'Общая задолженность по продаже'), "Total_Sell_Return_Due", 'Общий долг по возврату продаж'), "pay_all_sell_due_at_a_time", 'погасить весь долг за один раз'), "pay_all_sell_return_due_at_a_time", 'оплатить всю задолженность по возврату продажи за один раз'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Валовая прибыль'), "pay_all_purchase_due_at_a_time", 'погасить всю задолженность по покупке единовременно'), "Delete_Provider", 'Удалить провайдера'), "Edit_Provider", 'Изменить провайдера'), "Provider_details", 'Сведения о поставщике'), "Total_Purchase_Due", 'Общий долг покупки'), "Provider_Credit_Note", 'Кредитная нота'), "Customer_Credit_Note", 'Кредитная нота'), "Sell_Return", 'Продать Возврат'), "Purchase_Return", 'Возврат покупки'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Налоговый номер'), "Please_add_return_quantity", 'Пожалуйста, добавьте количество возврата'), "Return_exist_for_the_Transaction", 'Возврат существует для транзакции'), "qty_return_is_greater_than_Quantity_Remaining", 'Возврат количества больше, чем оставшееся количество'), "products_refunded_alert", 'Любые продукты с количеством, установленным на 0, не будут возвращены'), "pay_all_purchase_return_due_at_a_time", 'оплатить всю задолженность по возврату покупки единовременно'), "Total_Purchase_Return_Due", 'Общая задолженность по возврату покупки'), "Purchase_return_due", 'Задолженность по возврату покупки'), "Sell_return_due", 'Продать возврат из-за'), "product_report", 'Отчет о продукте'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'отчет о продажах продукции'), "Product_purchases_report", 'Отчет о покупках продуктов'), "Qty_sold", 'Кол-во продано'), "Qty_purchased", 'Кол-во куплено'), "Filter_by_warehouse", 'Отфильтровать по складу'), "Enable_Print_Invoice", 'Распечатать счет автоматически'), "Show_Warehouse", 'посмотреть склад'), "credit_card_info", 'Информация о кредитной карте'), "Saved_Credit_Card_Info", 'Сохраненная информация о кредитной карте'), "Credit_card_changed_successfully", 'Кредитная карта успешно изменена'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "notification_template", 'Шаблон уведомления'), "email_notification", 'Уведомление по электронной почте'), "sms_notification", 'Уведомление по SMS'), "Change_product_details", 'Изменить детали продукта'), "edit_tax_and_discount_and_shipping", 'Изменить налог, скидку и доставку'), "Create_Quotation_with_Stock", 'Создать квоту со складом'), "Variant_Name", 'Название варианта'), "Variant_cost", 'Стоимость варианта'), "Variant_price", 'Цена варианта'), "Variant_code", 'Код варианта'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Пожалуйста, подождите, пока продукт загружается'), "Choose_SMS_Gateway", 'Выберите шлюз SMS'), "Notification_Client", 'Уведомление клиента'), "Available_Tags", 'Доступные теги'), "Email_Subject", 'Тема письма'), "Email_body", 'Тело электронного письма'), "Notification_Supplier", 'Уведомление поставщика'), "sms_body", 'Текст SMS'), "sms_templates", 'SMS Templates'), "email_templates", 'Email Templates'));

/***/ }),

/***/ "./resources/src/translations/locales/sm_ch.js":
/*!*****************************************************!*\
  !*** ./resources/src/translations/locales/sm_ch.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Simplified Chinese

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: '收据',
  Pos_Settings: '销售点设置',
  Note_to_customer: '客户须知',
  Show_Note_to_customer: '向客户显示备注',
  Show_barcode: '显示条形码',
  Show_Tax_and_Discount: '显示税收、折扣和运费',
  Show_Customer: '显示客户',
  Show_Email: '显示电子邮件',
  Show_Phone: '显示电话',
  Show_Address: '显示地址',
  DefaultLanguage: '默认语言',
  footer: '页脚',
  Received_Amount: '收到金额',
  Paying_Amount: '支付金额',
  Change: '改变',
  Paying_amount_is_greater_than_Received_amount: '支付金额大于收到金额',
  Paying_amount_is_greater_than_Grand_Total: '支付金额大于总计',
  code_must_be_not_exist_already: '代码必须不存在',
  You_will_find_your_backup_on: '你会发现你的备份',
  and_save_it_to_your_pc: '并将其保存到您的电脑',
  Scan_your_barcode_and_select_the_correct_symbology_below: '扫描您的条形码并在下方选择正确的符号',
  Scan_Search_Product_by_Code_Name: '按代码名称扫描/搜索产品',
  Paper_size: '纸张尺寸',
  Clear_Cache: '清除缓存',
  Cache_cleared_successfully: '缓存清除成功',
  Failed_to_clear_cache: '清除缓存失败',
  Scan_Barcode: '条形码扫描器',
  Please_use_short_name_of_unit: '请使用单位简称',
  DefaultCustomer: '默认客户',
  DefaultWarehouse: '默认仓库',
  Payment_Gateway: '支付网关',
  SMS_Configuration: '短信配置',
  Gateway: '支付网关',
  Choose_Gateway: '选择支付网关',
  Send_SMS: '消息已成功发送',
  sms_config_invalid: '错误的短信配置无效',
  Remove_Stripe_Key_Secret: '删除Stripe API密钥',
  credit_card_account_not_available: '信用卡帐户不可用',
  Credit_Card_Info: '信用卡资料',
  developed_by: '由开发',
  Unit_already_linked_with_sub_unit: '单元已与子单元链接',
  Total_Items_Quantity: '项目总数和数量',
  Value_by_Cost_and_Price: '按成本和价格的价值',
  Search_this_table: '搜索此表',
  import_products: '进口产品',
  Field_optional: '字段可选',
  Download_exemple: '下载范例',
  field_must_be_in_csv_format: '字段必须为csv格式',
  Successfully_Imported: '成功导入',
  file_size_must_be_less_than_1_mega: '档案大小必须小于1兆',
  Please_follow_the_import_instructions: '请遵循导入说明',
  must_be_exist: '单位必须已经创建',
  Import_Customers: '导入客户',
  Import_Suppliers: '进口供应商',
  Recent_Sales: '最近的销售',
  Create_Transfer: '创建转移',
  order_products: '订购物品',
  Search_Product_by_Code_Name: '按代码或名称搜索产品',
  Reports_payments_Purchase_Return: '报告购买退货付款',
  Reports_payments_Sale_Return: '报告销售退货付款',
  payments_Sales_Return: '付款销售退货',
  payments_Purchases_Return: '付款购买退货',
  CreateSaleReturn: '创建销售退货',
  EditSaleReturn: '编辑销售退货',
  SalesReturn: '销售退货',
  CreatePurchaseReturn: '创建采购退货',
  EditPurchaseReturn: '编辑购买退货',
  PurchasesReturn: '采购退货',
  Due: '到期的',
  Profit: '利润',
  Revenue: '收入',
  Sales_today: '今日销量',
  People: '人们',
  Successfully_Created: '成功创建',
  Successfully_Updated: '成功更新',
  Success: '成功',
  Failed: '失败的',
  Warning: '警告',
  Please_fill_the_form_correctly: '请正确填写表格',
  Field_is_required: '必填项',
  Error: '错误!',
  you_are_not_authorized: '对不起！ 您没有权限。',
  Go_back_to_home: '返回首页',
  page_not_exist: '对不起！ 您要查找的页面不存在。',
  Choose_Status: '选择状态',
  Choose_Method: '选择方法',
  Choose_Symbology: '选择符号',
  Choose_Category: '选择类别',
  Choose_Customer: '选择客户',
  Choose_Supplier: '选择供应商',
  Choose_Unit_Purchase: '选择采购单位',
  Choose_Sub_Category: '选择子类别',
  Choose_Brand: '选择品牌',
  Choose_Warehouse: '选择仓库',
  Choose_Unit_Sale: '选择销售单位',
  Enter_Product_Cost: '输入产品成本',
  Enter_Stock_alert: '输入库存警报',
  Choose_Unit_Product: '选择产品单位',
  Enter_Product_Price: '输入产品价格',
  Enter_Name_Product: '输入名称产品',
  Enter_Role_Name: '输入角色名称',
  Enter_Role_Description: '输入角色描述',
  Enter_name_category: '输入类别名称',
  Enter_Code_category: '输入类别代码',
  Enter_Name_Brand: '输入名称品牌',
  Enter_Description_Brand: '输入描述品牌',
  Enter_Code_Currency: '输入代码货币',
  Enter_name_Currency: '输入名称货币',
  Enter_Symbol_Currency: '输入符号货币',
  Enter_Name_Unit: '输入单位名称',
  Enter_ShortName_Unit: '输入简称单位',
  Choose_Base_Unit: '选择基本单位',
  Choose_Operator: '选择运营商',
  Enter_Operation_Value: '输入操作值',
  Enter_Name_Warehouse: '输入仓库名称',
  Enter_Phone_Warehouse: '输入仓库电话',
  Enter_Country_Warehouse: '输入仓库国家',
  Enter_City_Warehouse: '进入仓库城市',
  Enter_Email_Warehouse: '输入仓库电子邮件',
  Enter_ZipCode_Warehouse: '输入仓库邮政编码',
  Choose_Currency: '选择货币',
  Thank_you_for_your_business: '感谢您的业务！',
  Cancel: '取消',
  New_Customer: '新客户',
  Incorrect_Login: '登陆错误',
  Successfully_Logged_In: '成功登录',
  This_user_not_active: '该用户不活跃',
  SignIn: '登入',
  Create_an_account: '创建一个帐户',
  Forgot_Password: '忘记密码 ？',
  Email_Address: '电子邮件地址',
  SignUp: '报名',
  Already_have_an_account: '已经有帐号了？',
  Reset_Password: '重设密码',
  Failed_to_authenticate_on_SMTP_server: '无法在SMTP服务器上进行身份验证',
  We_cant_find_a_user_with_that_email_addres: '我们找不到使用该电子邮件地址的用户',
  We_have_emailed_your_password_reset_link: '我们已经通过电子邮件发送了您的密码重置链接',
  Please_fill_the_Email_Adress: '请填写电子邮件地址',
  Confirm_password: '确认密码',
  Your_Password_has_been_changed: '您的密码已被更改',
  The_password_confirmation_does_not_match: '密码确认不匹配',
  This_password_reset_token_is_invalid: '此密码重置令牌无效',
  Warehouse_report: '仓库报告',
  All_Warehouses: '所有仓库',
  Expense_List: '费用清单',
  Expenses: '花费',
  This_Week_Sales_Purchases: '本周买卖',
  Top_Selling_Products: '畅销产品',
  View_all: '查看全部',
  Payment_Sent_Received: '已发送并已收到付款',
  Filter: '过滤',
  Invoice_POS: '发票POS',
  Invoice: '发票',
  Customer_Info: '客户信息',
  Company_Info: '公司介绍',
  Invoice_Info: '发票信息',
  Order_Summary: '订单摘要',
  Quote_Info: '报价信息',
  Del: '删除',
  SuppliersPaiementsReport: '供应商付款报告',
  Purchase_Info: '购买信息',
  Supplier_Info: '供应商信息',
  Return_Info: '退货信息',
  Expense_Category: '费用类别',
  Create_Expense: '创建费用',
  Details: '细节',
  Discount_Method: '优惠方式',
  Net_Unit_Cost: '净单位成本',
  Net_Unit_Price: '净单价',
  Edit_Expense: '编辑费用',
  All_Brand: '所有品牌',
  All_Category: '所有类别',
  ListExpenses: '清单费用',
  Create_Permission: '建立权限',
  Edit_Permission: '编辑权限',
  Reports_payments_Sales: '报告付款销售',
  Reports_payments_Purchases: '报告付款购买',
  Reports_payments_Return_Customers: '报告付款返回客户',
  Reports_payments_Return_Suppliers: '报表付款退货供应商',
  Expense_Deleted: '该费用已被删除',
  Expense_Updated: '此费用已更新',
  Expense_Created: '费用已创建',
  DemoVersion: '您无法在演示版中执行此操作',
  OrderStatistics: '销售统计',
  AlreadyAdd: '该产品已添加！',
  AddProductToList: '请添加产品到列表！',
  AddQuantity: '请添加详细数量！',
  InvalidData: '无效数据 ！！',
  LowStock: '数量超过库存可用数量',
  WarehouseIdentical: '两个仓库不能完全相同！',
  VariantDuplicate: '这个变种是重复的！',
  Filesize: '文件大小',
  GenerateBackup: '产生备份',
  BackupDatabase: '备份资料库',
  Backup: '后备',
  Paid: '已付费',
  Unpaid: '未付',
  Today: '今天',
  Income: '收入'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", '花费'), "Sale", '特卖'), "Actif", '活性'), "Inactif", '不活跃'), "Customers", '顾客'), "Phone", '电话'), "SearchByPhone", '通过电话搜索'), "Suppliers", '供应商'), "Quotations", '报价单'), "Sales", '营业额'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", '采购'), "Returns", '退货'), "Settings", '设定值'), "SystemSettings", '系统设置'), "Users", '用户数'), "GroupPermissions", '组权限'), "Currencies", '货币'), "Warehouses", '货仓'), "Units", '单位'), "UnitsPrchases", '单位购买'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", '单位销售'), "Reports", '报告书'), "PaymentsReport", '付款报告'), "PaymentsPurchases", '付款购买'), "PaymentsSales", '付款销售'), "ProfitandLoss", '收益与损失'), "WarehouseStockChart", '仓库库存图'), "SalesReport", '销售报告'), "PurchasesReport", '采购报告'), "CustomersReport", '客户报告'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", '供应商报告'), "SupplierReport", '供应商报告'), "DailySalesData", '每日销售数据'), "DailyPurchasesData", '每日购买数据'), "Derni\xE8rescinqrecords", '最近五条记录'), "Filters", '筛选器'), "date", '日期'), "Reference", '参考'), "Supplier", '供应商'), "PaymentStatus", '支付状态'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", '顾客'), "CustomerCode", '客户代码'), "Status", '状态'), "SupplierCode", '供应商代码'), "Categorie", '类别'), "Categories", '分类目录'), "StockTransfers", '库存转移'), "StockManagement", '库存管理'), "dashboard", '仪表板'), "Products", '产品展示'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", '产品清单'), "ProductManagement", '产品管理'), "ProductQuantityAlerts", '产品数量警报'), "CodeProduct", '代码产品'), "ProductTax", '产品税'), "SubCategorie", '子类别'), "Name_product", '指定'), "StockAlert", '库存警报'), "warehouse", '仓库'), "Tax", '税'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", '买价'), "SellPrice", '卖价'), "Quantity", '数量'), "UnitSale", '单位销售'), "UnitPurchase", '单位购买'), "ManagementCurrencies", '货币管理'), "CurrencyCode", '货币代码'), "CurrencyName", '货币名称'), "Symbol", '符号'), "All", '所有'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", '编辑产品'), "SearchByCode", '按代码搜索'), "SearchByName", '按名称搜索'), "ProductDetails", '产品详情'), "CustomerName", '顾客姓名'), "CustomerManagement", '用户管理'), "Add", '创建'), "add", '创建'), "Edit", '编辑'), "Close", '关'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", '请选择'), "Action", '行动'), "Email", '电子邮件'), "EditCustomer", '编辑客户'), "AddCustomer", '建立客户'), "Country", '国家'), "City", '市'), "Adress", '地址'), "CustomerDetails", '顾客信息'), "CustomersList", '客户名单'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierCode", '供应商代码'), "SupplierName", '供应商名称'), "SuppliersManagement", '供应商管理'), "SupplierDetails", '供应商详细信息'), "QuotationsManagement", '报价管理'), "SubTotal", '小计'), "MontantReste", '剩余金额'), "complete", '已完成'), "EnAttendant", '待定'), "Recu", '已收到'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", '部分的'), "Retournee", '返回'), "DetailQuote", '详细报价'), "EditQuote", '编辑报价'), "CreateSale", '建立销售'), "DownloadPdf", '下载PDF'), "QuoteEmail", '电子邮件发送报价'), "DeleteQuote", '删除报价'), "AddQuote", '创建报价'), "SelectProduct", '选择产品'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", '产品（代码-名称）'), "Price", '价钱'), "CurrentStock", '股票'), "Total", '总'), "Num", 'N°'), "Unitcost", '单位成本'), "to", '至'), "Subject", '学科'), "Message", '信息'), "EmailCustomer", '电邮客户'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", '发送'), "Quote", '报价单'), "Hello", '你好'), "AttachmentQuote", '请找到您的报价附件'), "AddProducts", '将产品添加到订单清单'), "SelectWarehouse", '请选择仓库'), "SelectCustomer", '请选择客户'), "SalesManagement", '销售管理'), "Balance", '平衡'), "QtyBack", '退货数量'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", '总回报'), "Amount", '量'), "SaleDetail", '销售明细'), "EditSale", '编辑销售'), "AddSale", '建立销售'), "ShowPayment", '显示付款'), "AddPayment", '创建付款'), "EditPayment", '编辑付款'), "EmailSale", '通过电子邮件发送销售'), "DeleteSale", '删除销售'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", '由...支付'), "Paymentchoice", '付款方式'), "Note", '注意'), "PaymentComplete", '付款完成！'), "PurchasesManagement", '采购管理'), "Ordered", '已订购'), "DeletePurchase", '删除购买'), "EmailPurchase", '通过邮件发送购买'), "EditPurchase", '编辑购买'), "PurchaseDetail", '采购明细'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", '创建购买'), "EmailSupplier", '供应商邮件'), "PurchaseInvoice", '购买付款'), "PurchasesInvoicesData", '购买付款数据'), "SalesInvoice", '销售付款'), "SalesInvoicesData", '销售付款数据'), "UserManagement", '用户管理'), "Firstname", '名字'), "lastname", '姓'), "username", '用户名'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", '密码'), "Newpassword", '新密码'), "ChangeAvatar", '更改头像'), "LeaveBlank", '如果尚未更改，请将该字段留空'), "type", '类型'), "UserPermissions", '用户权限'), "RoleName", '角色'), "RoleDescription", '角色描述'), "AddPermissions", '创建权限'), "View", '视图'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", '删除'), "NewAdjustement", '新调整'), "EditAdjustement", '编辑调整'), "CannotSubstraction", '您不能减去有库存0的产品'), "Addition", '加成'), "Subtraction", '减法'), "profil", '概况'), "logout", '登出'), "PurchaseAlreadyPaid", '您无法修改，因为此购买已付款'), "SaleAlreadyPaid", '您无法修改，因为此销售已经付款'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", '您无法修改，因为此退货已经支付'), "QuoteAlready", '此报价已产生销售'), "AddProduct", '创建产品'), "QuotationComplete", '报价完成'), "SiteConfiguration", '网站配置'), "Language", '语言'), "DefaultCurrency", '预设货币'), "LoginCaptcha", '登录验证码'), "DefaultEmail", '默认电子邮件'), "SiteName", '网站名称'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeLogo", '变更标志'), "SMTPConfiguration", 'SMTP配置'), "HOST", '主办'), "PORT", '港口'), "encryption", '加密'), "SMTPIncorrect", 'SMTP配置不正确'), "PaymentsReturns", '付款退货'), "ReturnsInvoices", '退回发票'), "ReturnsInvoicesData", '退回发票数据'), "ShowAll", '显示所有用户的所有记录'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", '折扣'), "OrderTax", '订单税'), "Shipping", '运输'), "CompanyName", '公司名'), "CompanyPhone", '公司电话'), "CompanyAdress", '公司地址'), "Code", '码'), "image", '图片'), "Printbarcode", '打印条形码'), "ReturnsCustomers", '回头客'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", '退货供应商'), "FactureReturnCustomers", '退货客户发票'), "FactureReturnSuppliers", '退货供应商发票'), "NodataAvailable", '没有可用数据'), "ProductImage", '产品图片'), "Barcode", '条码'), "pointofsales", '销售点'), "CustomUpload", '自定义上传'), "pointofsaleManagement", '销售点管理'), "Adjustment", '调整'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", '更新资料'), "Reset", '重启'), "print", '打印'), "SearchByEmail", '通过电子邮件搜索'), "ChooseProduct", '选择产品'), "Qty", '数量'), "Items", '物品'), "AmountHT", '量'), "AmountTTC", '合计金额'), "PleaseSelectSupplier", '请选择供应商'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", '请选择状态'), "PayeBy", '由...支付'), "ChooseWarehouse", '选择仓库'), "payNow", '现在付款'), "ListofCategory", '类别清单'), "Description", '描述'), "submit", '提交'), "ProblemCreatingThisInvoice", '创建此发票时出现问题. Please try again'), "ProblemPayment", '付款有问题。 请再试一次.'), "IncomeExpenses", '收入与支出'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", '每日销售与购买'), "ProductsExpired", '产品过期'), "ListofBrand", '列出品牌'), "CreateAdjustment", '创建调整'), "Afewwords", '几句话 ...'), "UserImage", '用户图片'), "UpdateProduct", '更新产品'), "Brand", '牌'), "BarcodeSymbology", '条码符号'), "ProductCost", '产品成本'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductPrice", '产品价格'), "UnitProduct", '单位产品'), "TaxMethod", '税法'), "MultipleImage", '多张图片'), "ProductHasMultiVariants", '产品具有多种变体'), "ProductHasPromotion", '产品促销'), "PromotionStart", '促销开始'), "PromotionEnd", '促销结束'), "PromotionPrice", '促销价'), "Price", '价钱'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Cost", '成本'), "Unit", '单元'), "ProductVariant", '产品变体'), "Variant", '变体'), "UnitPrice", '单价'), "CreateReturnCustomer", '创建退货客户'), "EditReturnCustomer", '编辑退货客户'), "CreateReturnSupplier", '创建退货供应商'), "Documentation", '文献资料'), "EditReturnSupplier", '编辑退货供应商'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FromWarehouse", '从仓库'), "ToWarehouse", '到仓库'), "EditTransfer", '编辑转移'), "TransferDetail", '转账明细'), "Pending", '待定'), "Received", '已收到'), "Ordered", '已订购'), "PermissionsManager", '权限管理'), "BrandManager", '牌'), "BrandImage", '品牌形象'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BrandName", '品牌'), "BrandDescription", '品牌描述'), "BaseUnit", '基本单位'), "ManagerUnits", '单位管理'), "OperationValue", '运营价值'), "Operator", '操作员'), "Top5Products", '前五名产品'), "Last5Sales", '最近五次销售'), "ListAdjustments", '清单调整'), "ListTransfers", '清单转移'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CreateTransfer", '创建转移'), "OrdersManager", '订单管理'), "ListQuotations", '清单报价'), "ListPurchases", '列出购买'), "ListSales", '清单销售'), "ListReturns", '清单退货'), "PeopleManager", '人事管理'), "Delete", {
  Title: 'Are you sure?',
  Text: '您将无法还原它！',
  confirmButtonText: '是的，删除它！',
  cancelButtonText: '取消',
  Deleted: '已删除！',
  Failed: '失败了！',
  Therewassomethingwronge: '出事了',
  CustomerDeleted: '该客户端已被删除。',
  SupplierDeleted: '该供应商已被删除.',
  QuoteDeleted: '此报价已被删除。',
  SaleDeleted: '此销售已被删除。',
  PaymentDeleted: '此付款已被删除。',
  PurchaseDeleted: '此购买已被删除。',
  ReturnDeleted: '此退货已被删除。',
  ProductDeleted: '该产品已被删除。',
  ClientError: '该客户端已经与其他操作链接',
  ProviderError: '该供应商已与其他运营部门链接',
  UserDeleted: '该用户已被删除。',
  UnitDeleted: '该单位已被删除。',
  RoleDeleted: '该角色已被删除。',
  TaxeDeleted: '该税项已被删除.',
  SubCatDeleted: '该子类别已被删除。',
  CatDeleted: '此类别已被删除。',
  WarehouseDeleted: '该仓库已被删除。',
  AlreadyLinked: '该产品已经与其他操作链接',
  AdjustDeleted: '此调整已被删除。',
  TitleCurrency: '该货币已被删除。',
  TitleTransfer: '转移已成功删除',
  BackupDeleted: '备份已成功删除',
  TitleBrand: '该品牌已被删除'
}), "Update", {
  TitleBrand: '该品牌已更新',
  TitleProfile: '您的个人资料已成功更新',
  TitleAdjust: '调整已成功更新',
  TitleRole: '角色更新成功',
  TitleUnit: '单位更新成功',
  TitleUser: '用户已成功更新',
  TitleCustomer: '客户更新成功',
  TitleQuote: '报价已成功更新',
  TitleSale: '销售已成功更新',
  TitlePayment: '付款已成功更新',
  TitlePurchase: '购买已成功更新',
  TitleReturn: '返回成功更新',
  TitleProduct: '产品更新成功',
  TitleSupplier: '供应商更新成功',
  TitleTaxe: '税务更新成功',
  TitleCat: '分类成功更新',
  TitleWarhouse: '仓库已成功更新',
  TitleSetting: '设置已成功更新',
  TitleCurrency: '货币更新成功',
  TitleTransfer: '转移成功更新'
}), "Create", {
  TitleBrand: '该品牌已创建',
  TitleRole: '角色创建成功',
  TitleUnit: '单位创建成功',
  TitleUser: '用户创建成功',
  TitleCustomer: '客户创建成功',
  TitleQuote: '报价创建成功',
  TitleSale: '销售成功创建',
  TitlePayment: '付款成功创建',
  TitlePurchase: '购买成功创建',
  TitleReturn: '返回创建成功',
  TitleProduct: '产品创建成功',
  TitleSupplier: '供应商创建成功',
  TitleTaxe: '税收创建成功',
  TitleCat: '分类成功创建',
  TitleWarhouse: '成功创建仓库',
  TitleAdjust: '调整已成功创建',
  TitleCurrency: '货币创建成功',
  TitleTransfer: '转移成功创建'
}), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: '电子邮件发送成功'
}), "return", {
  TitleSale: '此销售已经与退货相关！'
}), "ReturnManagement", '退货管理'), "ReturnDetail", '退货明细'), "EditReturn", '编辑退货'), "AddReturn", '创建退货'), "EmailReturn", '发送邮件退回'), "DeleteReturn", '删除退货'), "Retoursurcharge", '回程附加费'), "Laivrison", '交货'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectSale", '选择销售'), "ZeroPardefault", '您可以删除该项目或将未退回的数量设置为零'), "Return", '返回'), "Purchase", '采购'), "TotalSales", '总销售额'), "TotalPurchases", '总购买'), "TotalReturns", '总回报'), "PaiementsNet", '净付款'), "PaiementsSent", '已付款'), "PaiementsReceived", '付款已收到'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Recieved", '已收到'), "Sent", '已发送'), "ProductQuantityAlerts", '产品数量警报'), "ProductCode", '码'), "ProductName", '产品'), "AlertQuantity", '警报数量'), "WarehouseStockChart", '仓库库存图'), "TotalProducts", '产品总数'), "TotalQuantity", '总数（量'), "TopCustomers", '前五名客户'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalAmount", '总金额'), "TotalPaid", '总支付'), "CustomerSalesReport", '客户销售报告'), "CustomerPaiementsReport", '客户付款报告'), "CustomerQuotationsReport", '客户报价报告'), "Payments", '付款方式'), "TopSuppliers", '前五名供应商'), "SupplierPurchasesReport", '供应商采购报告'), "SupplierPaiementsReport", '供应商付款报告'), "Name", '名称'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Code", '码'), "ManagementWarehouse", '仓库管理'), "ZipCode", '邮政编码'), "managementCategories", '分类管理'), "Codecategorie", '代码类别'), "Namecategorie", '名称类别'), "Parentcategorie", '父类别'), "managementTax", '税务管理'), "TaxName", '税名'), "TaxRate", '税率'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", '采购单位'), "managementUnitSales", '销售单位'), "ShortName", '简称'), "PleaseSelectThesebeforeaddinganyproduct", '请在添加任何产品之前选择这些'), "StockAdjustement", '库存调整'), "PleaseSelectWarehouse", '选择任何产品之前，请先选择仓库'), "StockTransfer", '库存转移'), "SelectPeriod", '选择时期'), "ThisYear", '今年'), "ThisToday", '今天'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ThisMonth", '这个月'), "ThisWeek", '本星期'), "AdjustmentDetail", '调整细节'), "ActivateUser", '该用户已被激活'), "DisActivateUser", '此用户已被停用'), "NotFound", '找不到网页。'), "oops", '错误！ 找不到网页。'), "couldNotFind", '我们找不到您想要的页面。与此同时，您可能'), "ReturnDashboard", '返回仪表板'), "hrm", '人力资源管理'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Employees", '雇员'), "Attendance", '出勤率'), "Leave_request", '离开请求'), "Leave_type", '休假类型'), "Company", '公司'), "Departments", '部门'), "Designations", '名称'), "Office_Shift", '办公室班次'), "Holidays", '节假日'), "Enter_Company_Name", '输入公司名称'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_email_address", '输入电邮地址'), "Enter_Company_Phone", '输入公司电话'), "Enter_Company_Country", '输入公司国家'), "Created_in_successfully", '创建成功'), "Updated_in_successfully", '更新成功'), "Deleted_in_successfully", '已成功删除'), "department", '部'), "Enter_Department_Name", '输入部门名称'), "Choose_Company", '选择公司'), "Department_Head", '部门负责人'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", '选择部门负责人'), "Enter_Shift_name", '输入班次名称'), "Monday_In", 'Monday In'), "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", '假期'), "Enter_title", '输入标题'), "title", '标题'), "start_date", '开始日期'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", '输入开始日期'), "Finish_Date", '结束时间'), "Enter_Finish_date", '请输入结束日期'), "Please_provide_any_details", '请提供任何详细信息'), "Attendances", '出勤率'), "Enter_Attendance_date", '输入出席日期'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", '选择员工'), "Employee", '雇员'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Work_Duration", '工作时间'), "remaining_leaves_are_insufficient", '剩余的叶子不足'), "Leave_Type", '休假类型'), "Days", '天数'), "Department", '部'), "Choose_leave_type", '选择休假类型'), "Choose_status", '地位'), "Leave_Reason", '离职原因'), "Enter_Reason_Leave", '输入原因请假'), "Add_Employee", '添加员工'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FirstName", '名'), "Enter_FirstName", '输入名字'), "LastName", '姓氏'), "Enter_LastName", '输入姓氏'), "Gender", '性别'), "Choose_Gender", '选择性别'), "Enter_Birth_date", '输入出生日期'), "Birth_date", '出生日期'), "Enter_Country", '进入国家/地区'), "Enter_Phone_Number", '输入电话号码'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "joining_date", '加盟日期'), "Enter_joining_date", '输入入会日期'), "Choose_Designation", '选择指定'), "Designation", '指定'), "Office_Shift", '办公室班次'), "Choose_Office_Shift", '选择办公室班次'), "Enter_Leaving_Date", '输入离开日期'), "Leaving_Date", '离开日期'), "Annual_Leave", '年假'), "Enter_Annual_Leave", '输入年假'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Remaining_leave", '剩余假期'), "Employee_Details", '员工详情'), "Basic_Information", '基本信息'), "Family_status", '家庭状况'), "Choose_Family_status", '选择家庭状态'), "Employment_type", '雇佣类型'), "Select_Employment_type", '选择就业类型'), "Enter_City", '进入城市'), "Province", '省份'), "Enter_Province", '输入省份'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Address", '输入地址'), "Enter_Zip_code", '输入邮政编号'), "Zip_code", '邮政编码'), "Hourly_rate", '每小时费率'), "Enter_Hourly_rate", '输入每小时费率'), "Basic_salary", '基础工资'), "Enter_Basic_salary", '输入基本工资'), "Social_Media", '社交媒体'), "Skype", 'Skype'), "Enter_Skype", '进入 Skype'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), "Enter_Facebook", '进入 Facebook'), "WhatsApp", 'WhatsApp'), "Enter_WhatsApp", '进入 WhatsApp'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", '进入 LinkedIn'), "Twitter", 'Twitter'), "Enter_Twitter", '进入 Twitter'), "Experiences", '经验'), "bank_account", '银行户口'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Company_Name", '公司名'), "Location", '位置'), "Enter_location", '输入地点'), "Enter_Description", '输入描述'), "Bank_Name", '银行名'), "Enter_Bank_Name", '输入银行名称'), "Bank_Branch", '银行支行'), "Enter_Bank_Branch", '进入银行分行'), "Bank_Number", '银行号码'), "Enter_Bank_Number", '输入银行号码'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", '指定仓库'), "Top_customers", '顶级客户'), "Attachment", '附件'), "view_employee", '查看员工'), "edit_employee", '编辑员工'), "delete_employee", '删除员工'), "Created_by", '添加者'), "Add_product_IMEI_Serial_number", '添加产品 IMEI/序列号'), "Product_Has_Imei_Serial_number", '产品有Imei/序列号'), "IMEI_SN", 'IMEI/SN'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Shipments", '出货量'), "delivered_to", '送到了（送去了'), "shipment_ref", '装运参考'), "sale_ref", '销售参考'), "Edit_Shipping", '编辑运输'), "Packed", '包装好的'), "Shipped", '已发货'), "Delivered", '发表'), "Cancelled", '取消'), "Shipping_status", '发货状态'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users_Report", '用户报告'), "stock_report", '库存报告'), "TotalPurchases", '总购买量'), "Total_quotations", '总报价'), "Total_return_sales", '退货总销售额'), "Total_return_purchases", '总退货购买'), "Total_transfers", '总转帐'), "Total_adjustments", '总调整'), "User_report", '用户报告'), "Current_stock", '当前库存'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_name", '产品名称'), "Total_Customers_Due", '总债务'), "Total_Suppliers_Due", '总债务'), "Some_warehouses", '一些仓库'), "All_Warehouses", '所有仓库'), "Product_Cost", '产品成本'), "sms_settings", '短信设置'), "pos_settings", '销售点设置'), "payment_gateway", '支付网关'), "mail_settings", '邮件设置'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", '默认短信网关'), "module_settings", '模块设置'), "Module_enabled_success", '模块启用成功'), "Module_Disabled_success", '模块禁用成功'), "update_settings", '更新设置'), "Please_Upload_the_Correct_Module", '请上传正确的模块'), "Uploaded_Success", '上传成功'), "Customer_details", '顾客信息'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Customer", '编辑客户'), "Delete_Customer", '删除客户'), "Pay_Due", '支付所有应付款'), "Paying_amount_is_greater_than_Total_Due", '支付金额大于到期总额'), "Customer_Invoice", '客户发票'), "This_Product_Not_For_Selling", '本产品不卖'), "Welcome_to_your_Dashboard", '欢迎来到您的仪表板'), "Total_Payable", '应付总额'), "Choose_Sale_Ref", '选择销售参考'), "Please_Select_Sale", '请选择销售'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sale_Ref", '销售参考'), "list_product_returns", '列出产品退货'), "Qty_return", '数量退货'), "Choose_Purchase_Ref", '选择购买参考'), "Purchase_Ref", '购买参考'), "please_select_purchase", '请选择采购'), "qty_return_is_greater_than_qty_purchased", '退货数量大于购买数量'), "qty_return_is_greater_than_qty_sold", '退货数量大于售出数量'), "Quantity_sold", '售出数量'), "qty_purchased", '购买数量'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sender_Name", '发件者姓名'), "The_module_must_be_uploaded_as_zip_file", '模块必须上传为 zip 文件'), "Upload_Module", '上传模块'), "All_Modules_Installed", '已安装的所有模块'), "Current_Version", '当前版本'), "You_already_have_the_latest_version", '您已经拥有最新版本'), "Update_Available", '更新可用'), "Update_Log", '升级'), "Update_Now", '现在更新'), "View_Change_Log", '查看更改日志'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "invoice_footer", '发票页脚'), "Please_Wait_for_the_update", '注意：请等待更新完全完成。 不建议关闭浏览器或停止进程升级'), "Note_update", '注意：确保在运行升级之前备份您的当前版本和数据库，如果出现错误，请恢复它'), "Time_Zone", '时区'), "Payment_note", '备注付款'), "sale_note", '销售说明'), "Total_Sale_Due", '总销售债务'), "Total_Sell_Return_Due", '总销售回报债务'), "pay_all_sell_due_at_a_time", '一次偿还所有出售债务'), "pay_all_sell_return_due_at_a_time", '一次支付所有的卖出回报债务'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Gross_Profit", '毛利'), "pay_all_purchase_due_at_a_time", '一次支付所有购买债务'), "Delete_Provider", '删除提供者'), "Edit_Provider", '编辑提供者'), "Provider_details", '提供者详细信息'), "Total_Purchase_Due", '购买债务总额'), "Provider_Credit_Note", '贷方通知单'), "Customer_Credit_Note", '贷方通知单'), "Sell_Return", '卖出回报'), "Purchase_Return", '购买退货'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax_Number", '税务号码'), "Please_add_return_quantity", '请添加退货数量'), "Return_exist_for_the_Transaction", '交易存在退货'), "qty_return_is_greater_than_Quantity_Remaining", '数量回报大于剩余数量'), "products_refunded_alert", '任何数量设置为 0 的产品将不予退款'), "pay_all_purchase_return_due_at_a_time", '一次支付所有购买回报债务'), "Total_Purchase_Return_Due", '总采购退货到期'), "Purchase_return_due", '购买回报债务'), "Sell_return_due", '出售回报债务'), "product_report", '产品报告'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_sales_report", '产品销售报告'), "Product_purchases_report", '产品采购报告'), "Qty_sold", '售出数量'), "Qty_purchased", '购买数量'), "Filter_by_warehouse", '按仓库筛选'), "Enable_Print_Invoice", '自动打印发票'), "Show_Warehouse", '查看仓库'), "credit_card_info", '信用卡信息'), "Saved_Credit_Card_Info", '已保存的信用卡信息'), "Credit_card_changed_successfully", '信用卡更改成功'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "notification_template", '通知模板'), "email_notification", '电子邮件通知'), "sms_notification", '短信通知'), "Change_product_details", '更改产品详细信息'), "edit_tax_and_discount_and_shipping", '编辑税收、折扣和运费'), "Create_Quotation_with_Stock", '使用库存创建报价'), "Variant_Name", '变体名称'), "Variant_cost", '变体成本'), "Variant_price", '变体价格'), "Variant_code", '变体代码'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", '请等待产品加载完成'), "Choose_SMS_Gateway", '选择短信网关'), "Notification_Client", '客户通知'), "Available_Tags", '可用标签'), "Email_Subject", '电子邮件主题'), "Email_body", '电子邮件正文'), "Notification_Supplier", '供应商通知'), "sms_body", '短信正文'), "sms_templates", 'SMS Templates'), "email_templates", 'Email Templates'));

/***/ }),

/***/ "./resources/src/translations/locales/thai.js":
/*!****************************************************!*\
  !*** ./resources/src/translations/locales/thai.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Taiwan

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'ใบเสร็จ',
  Pos_Settings: 'การตั้งค่าจุดขาย',
  Note_to_customer: 'หมายเหตุถึงลูกค้า',
  Show_Note_to_customer: 'แสดงหมายเหตุให้กับลูกค้า',
  Show_barcode: 'แสดงบาร์โค้ด',
  Show_Tax_and_Discount: 'แสดงภาษี & ส่วนลด & การจัดส่ง',
  Show_Customer: 'แสดงลูกค้า',
  Show_Email: 'แสดงอีเมล',
  Show_Phone: 'แสดงโทรศัพท์',
  Show_Address: 'แสดงที่อยู่',
  DefaultLanguage: 'ภาษาเริ่มต้น',
  footer: 'ส่วนท้าย',
  Received_Amount: 'จำนวนเงินที่ได้รับ',
  Paying_Amount: 'จำนวนเงินที่จ่าย',
  Change: 'เปลี่ยน',
  Paying_amount_is_greater_than_Received_amount: 'จำนวนเงินที่จ่ายมากกว่าจำนวนเงินที่ได้รับ',
  Paying_amount_is_greater_than_Grand_Total: 'จำนวนเงินที่จ่ายมากกว่ายอดรวม',
  code_must_be_not_exist_already: 'รหัสจะต้องไม่มีอยู่แล้ว',
  You_will_find_your_backup_on: 'คุณจะพบข้อมูลสำรองของคุณบน',
  and_save_it_to_your_pc: 'และบันทึกลงในพีซีของคุณ',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'สแกนบาร์โค้ดของคุณและเลือกสัญลักษณ์ที่ถูกต้องด้านล่าง',
  Scan_Search_Product_by_Code_Name: 'สแกน/ค้นหาสินค้าด้วยชื่อรหัส',
  Paper_size: 'ขนาดกระดาษ',
  Clear_Cache: 'ล้างแคช',
  Cache_cleared_successfully: 'ล้างแคชเรียบร้อยแล้ว',
  Failed_to_clear_cache: 'ไม่สามารถล้างแคช',
  Scan_Barcode: 'เครื่องสแกนบาร์โค้ด',
  Please_use_short_name_of_unit: 'โปรดใช้ชื่อย่อของหน่วย',
  DefaultCustomer: 'ลูกค้าเริ่มต้น',
  DefaultWarehouse: 'คลังสินค้าเริ่มต้น',
  Payment_Gateway: 'ช่องทางการชำระเงิน',
  SMS_Configuration: 'การกำหนดค่า SMS',
  Gateway: 'ช่องทางการชำระเงิน',
  Choose_Gateway: 'เลือกช่องทางการชำระเงิน',
  Send_SMS: 'ข้อความที่ส่งประสบความสำเร็จ',
  sms_config_invalid: 'การกำหนดค่า sms ผิดไม่ถูกต้อง',
  Remove_Stripe_Key_Secret: 'ลบคีย์ Stripe API',
  credit_card_account_not_available: 'ไม่มีบัญชีบัตรเครดิต',
  Credit_Card_Info: 'ข้อมูลบัตรเครดิต',
  developed_by: 'พัฒนาโดย',
  Unit_already_linked_with_sub_unit: 'เชื่อมโยงหน่วยกับหน่วยย่อยแล้ว',
  Total_Items_Quantity: 'รายการและปริมาณทั้งหมด',
  Value_by_Cost_and_Price: 'คุ้มค่าตามต้นทุนและราคา',
  Search_this_table: 'ค้นหาตารางนี้',
  import_products: 'นำเข้าสินค้า',
  Field_optional: 'ฟิลด์ไม่บังคับ',
  Download_exemple: 'ดาวน์โหลดตัวอย่าง',
  field_must_be_in_csv_format: 'ฟิลด์ต้องอยู่ในรูปแบบ csv',
  Successfully_Imported: 'นำเข้าสำเร็จ',
  file_size_must_be_less_than_1_mega: 'ขนาดไฟล์ต้องน้อยกว่า 1 เมกะไบต์',
  Please_follow_the_import_instructions: 'โปรดปฏิบัติตามคำแนะนำการนำเข้า',
  must_be_exist: 'ต้องสร้างหน่วยแล้ว',
  Import_Customers: 'นำเข้าลูกค้า',
  Import_Suppliers: 'นำเข้าซัพพลายเออร์',
  Recent_Sales: 'ยอดขายล่าสุด',
  Create_Transfer: 'สร้างการโอน',
  order_products: 'รายการสั่งซื้อ',
  Search_Product_by_Code_Name: 'ค้นหาสินค้าตามรหัสหรือชื่อ',
  Reports_payments_Purchase_Return: 'รายงานการชำระเงินคืนการซื้อ',
  Reports_payments_Sale_Return: 'รายงานการชำระเงินคืนการขาย',
  payments_Sales_Return: 'การชำระเงินการขายคืน',
  payments_Purchases_Return: 'การชำระเงินการซื้อสินค้าคืน',
  CreateSaleReturn: 'สร้างผลตอบแทนจากการขาย',
  EditSaleReturn: 'แก้ไขการขายคืน',
  SalesReturn: 'ผลตอบแทนจากการขาย',
  CreatePurchaseReturn: 'สร้างผลตอบแทนการซื้อ',
  EditPurchaseReturn: 'แก้ไขการคืนสินค้า',
  PurchasesReturn: 'การซื้อคืน',
  Due: 'ครบกำหนด',
  Profit: 'กำไร',
  Revenue: 'รายได้',
  Sales_today: 'ขายวันนี้',
  People: 'คน',
  Successfully_Created: 'สร้างสำเร็จแล้ว',
  Successfully_Updated: 'อัปเดตเรียบร้อยแล้ว',
  Success: 'ประสบความสำเร็จ',
  Failed: 'ล้มเหลว',
  Warning: 'คำเตือน',
  Please_fill_the_form_correctly: 'กรุณากรอกแบบฟอร์มให้ถูกต้อง',
  Field_is_required: 'ต้องระบุฟิลด์',
  Error: 'ข้อผิดพลาด!',
  you_are_not_authorized: 'ขออภัย! คุณไม่ได้รับอนุญาต',
  Go_back_to_home: 'กลับไปที่หน้าแรก',
  page_not_exist: 'ขออภัย! ไม่มีหน้าที่คุณค้นหา',
  Choose_Status: 'เลือกสถานะ',
  Choose_Method: 'เลือกวิธีการ',
  Choose_Symbology: 'เลือกสัญลักษณ์',
  Choose_Category: 'เลือกหมวดหมู่',
  Choose_Customer: 'เลือกลูกค้า',
  Choose_Supplier: 'เลือกซัพพลายเออร์',
  Choose_Unit_Purchase: 'เลือกหน่วยซื้อ',
  Choose_Sub_Category: 'เลือกหมวดหมู่ย่อย',
  Choose_Brand: 'เลือกยี่ห้อ',
  Choose_Warehouse: 'เลือกคลังสินค้า',
  Choose_Unit_Sale: 'เลือกหน่วยขาย',
  Enter_Product_Cost: 'ป้อนต้นทุนผลิตภัณฑ์',
  Enter_Stock_alert: 'เข้าสู่การแจ้งเตือนสต็อก',
  Choose_Unit_Product: 'เลือกหน่วยผลิตภัณฑ์',
  Enter_Product_Price: 'ป้อนราคาสินค้า',
  Enter_Name_Product: 'ป้อนชื่อผลิตภัณฑ์',
  Enter_Role_Name: 'ป้อนชื่อบทบาท',
  Enter_Role_Description: 'ป้อนคำอธิบายบทบาท',
  Enter_name_category: 'ป้อนชื่อหมวดหมู่',
  Enter_Code_category: 'ป้อนรหัสหมวดหมู่',
  Enter_Name_Brand: 'ใส่ชื่อยี่ห้อ',
  Enter_Description_Brand: 'ป้อนคำอธิบายยี่ห้อ',
  Enter_Code_Currency: 'ป้อนรหัสสกุลเงิน',
  Enter_name_Currency: 'ป้อนชื่อสกุล',
  Enter_Symbol_Currency: 'ป้อนสัญลักษณ์สกุลเงิน',
  Enter_Name_Unit: 'ป้อนชื่อหน่วย',
  Enter_ShortName_Unit: 'ใส่ชื่อย่อหน่วย',
  Choose_Base_Unit: 'เลือกหน่วยฐาน',
  Choose_Operator: 'เลือกตัวดำเนินการ',
  Enter_Operation_Value: 'ป้อนค่าการดำเนินการ',
  Enter_Name_Warehouse: 'ป้อนชื่อคลังสินค้า',
  Enter_Phone_Warehouse: 'ป้อนโทรศัพท์คลังสินค้า',
  Enter_Country_Warehouse: 'เข้าสู่ประเทศคลังสินค้า',
  Enter_City_Warehouse: 'เข้าสู่เมืองคลังสินค้า',
  Enter_Email_Warehouse: 'ป้อนอีเมลคลังสินค้า',
  Enter_ZipCode_Warehouse: 'ป้อนรหัสไปรษณีย์ของคลังสินค้า',
  Choose_Currency: 'เลือกสกุลเงิน',
  Thank_you_for_your_business: 'ขอบคุณสำหรับธุรกิจของคุณ!',
  Cancel: 'ยกเลิก',
  New_Customer: 'ลูกค้าใหม่',
  Incorrect_Login: 'การเข้าสู่ระบบไม่ถูกต้อง',
  Successfully_Logged_In: 'เข้าสู่ระบบเรียบร้อยแล้ว',
  This_user_not_active: 'ผู้ใช้รายนี้ไม่ได้ใช้งาน',
  SignIn: 'เข้าสู่ระบบ',
  Create_an_account: 'สร้างบัญชี',
  Forgot_Password: 'ลืมรหัสผ่าน ?',
  Email_Address: 'ที่อยู่อีเมล',
  SignUp: 'ลงชื่อ',
  Already_have_an_account: 'มีบัญชีอยู่แล้ว?',
  Reset_Password: 'รีเซ็ตรหัสผ่าน',
  Failed_to_authenticate_on_SMTP_server: 'ไม่สามารถตรวจสอบสิทธิ์บนเซิร์ฟเวอร์ SMTP',
  We_cant_find_a_user_with_that_email_addres: 'เราไม่พบผู้ใช้ที่มีที่อยู่อีเมลดังกล่าว',
  We_have_emailed_your_password_reset_link: 'เราได้ส่งลิงค์รีเซ็ตรหัสผ่านของคุณไปทางอีเมลแล้ว',
  Please_fill_the_Email_Adress: 'กรุณากรอกที่อยู่อีเมล',
  Confirm_password: 'ยืนยันรหัสผ่าน',
  Your_Password_has_been_changed: 'รหัสผ่านของคุณถูกเปลี่ยน',
  The_password_confirmation_does_not_match: 'การยืนยันรหัสผ่านไม่ตรงกัน',
  This_password_reset_token_is_invalid: 'โทเค็นการรีเซ็ตรหัสผ่านนี้ไม่ถูกต้อง',
  Warehouse_report: 'รายงานคลังสินค้า',
  All_Warehouses: 'คลังสินค้าทั้งหมด',
  Expense_List: 'รายการค่าใช้จ่าย',
  Expenses: 'ค่าใช้จ่าย',
  This_Week_Sales_Purchases: 'ยอดขายและการซื้อประจำสัปดาห์นี้',
  Top_Selling_Products: 'สินค้าขายดี',
  View_all: 'ดูทั้งหมด',
  Payment_Sent_Received: 'การชำระเงินที่ส่งและรับ',
  Filter: 'กรอง',
  Invoice_POS: 'POS ใบแจ้งหนี้',
  Invoice: 'ใบแจ้งหนี้',
  Customer_Info: 'ข้อมูลลูกค้า',
  Company_Info: 'ข้อมูล บริษัท',
  Invoice_Info: 'ข้อมูลใบแจ้งหนี้',
  Order_Summary: 'สรุปคำสั่งซื้อ',
  Quote_Info: 'ข้อมูลใบเสนอราคา',
  Del: 'ลบ',
  SuppliersPaiementsReport: 'รายงานการชำระเงินของซัพพลายเออร์',
  Purchase_Info: 'ข้อมูลการซื้อ',
  Supplier_Info: 'ข้อมูลซัพพลายเออร์',
  Return_Info: 'ข้อมูลการกลับมา',
  Expense_Category: 'หมวดค่าใช้จ่าย',
  Create_Expense: 'สร้างค่าใช้จ่าย',
  Details: 'รายละเอียด',
  Discount_Method: 'วิธีส่วนลด',
  Net_Unit_Cost: 'ต้นทุนต่อหน่วยสุทธิ',
  Net_Unit_Price: 'ราคาต่อหน่วยสุทธิ',
  Edit_Expense: 'แก้ไขค่าใช้จ่าย',
  All_Brand: 'ทุกยี่ห้อ',
  All_Category: 'หมวดหมู่ทั้งหมด',
  ListExpenses: 'รายการค่าใช้จ่าย',
  Create_Permission: 'สร้างสิทธิ์',
  Edit_Permission: 'แก้ไขการอนุญาต',
  Reports_payments_Sales: 'รายงานการชำระเงินการขาย',
  Reports_payments_Purchases: 'รายงานการชำระเงินการซื้อ',
  Reports_payments_Return_Customers: 'รายงานการชำระเงินคืนลูกค้า',
  Reports_payments_Return_Suppliers: 'รายงานการชำระเงินที่ส่งคืนซัพพลายเออร์',
  Expense_Deleted: 'ลบค่าใช้จ่ายนี้แล้ว',
  Expense_Updated: 'ค่าใช้จ่ายนี้ได้รับการอัปเดต',
  Expense_Created: 'สร้างค่าใช้จ่ายนี้แล้ว',
  DemoVersion: 'คุณไม่สามารถทำได้ในเวอร์ชันสาธิต',
  OrderStatistics: 'สถิติการขาย',
  AlreadyAdd: 'สินค้านี้เข้าแล้ว !!',
  AddProductToList: 'กรุณาเพิ่มสินค้าในรายการ !!',
  AddQuantity: 'กรุณาเพิ่มจำนวนรายละเอียด !!',
  InvalidData: 'ข้อมูลไม่ถูกต้อง !!',
  LowStock: 'ปริมาณเกินกว่าปริมาณที่มีอยู่ในสต็อก',
  WarehouseIdentical: 'โกดังทั้งสองแห่งไม่สามารถเหมือนกันได้ !!',
  VariantDuplicate: 'ตัวแปรนี้ซ้ำกัน !!',
  Filesize: 'ขนาดไฟล์',
  GenerateBackup: 'สร้างการสำรองข้อมูล',
  BackupDatabase: 'ฐานข้อมูลสำรอง',
  Backup: 'การสำรองข้อมูล',
  Paid: 'จ่าย',
  Unpaid: 'ยังไม่ได้ชำระ',
  Today: 'วันนี้',
  Income: 'รายได้'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'ค่าใช้จ่าย'), "Sale", 'ขาย'), "Actif", 'คล่องแคล่ว'), "Inactif", 'ไม่ใช้งาน'), "Customers", 'ลูกค้า'), "Phone", 'โทรศัพท์'), "SearchByPhone", 'ค้นหาทางโทรศัพท์'), "Suppliers", 'ซัพพลายเออร์'), "Quotations", 'ใบเสนอราคา'), "Sales", 'ฝ่ายขาย'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'การซื้อ'), "Returns", 'ผลตอบแทน'), "Settings", 'การตั้งค่า'), "SystemSettings", 'การตั้งค่าระบบ'), "Users", 'ผู้ใช้'), "GroupPermissions", 'สิทธิ์กลุ่ม'), "Currencies", 'สกุลเงิน'), "Warehouses", 'โกดัง'), "Units", 'หน่วย'), "UnitsPrchases", 'หน่วยการซื้อ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'หน่วยการขาย'), "Reports", 'รายงาน'), "PaymentsReport", 'รายงานการชำระเงิน'), "PaymentsPurchases", 'การซื้อการชำระเงิน'), "PaymentsSales", 'การชำระเงินการขาย'), "ProfitandLoss", 'กำไรและขาดทุน'), "WarehouseStockChart", 'แผนภูมิสต็อคคลังสินค้า'), "SalesReport", 'รายงานการขาย'), "PurchasesReport", 'รายงานการซื้อ'), "CustomersReport", 'รายงานลูกค้า'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'รายงานซัพพลายเออร์'), "SupplierReport", 'รายงานซัพพลายเออร์'), "DailySalesData", 'ข้อมูลการขายรายวัน'), "DailyPurchasesData", 'ข้อมูลการซื้อรายวัน'), "Derni\xE8rescinqrecords", 'ห้าบันทึกล่าสุด'), "Filters", 'ฟิลเตอร์'), "date", 'วันที่'), "Reference", 'ข้อมูลอ้างอิง'), "Supplier", 'ผู้ผลิต'), "PaymentStatus", 'สถานะการชำระเงิน'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", 'ลูกค้า'), "CustomerCode", 'รหัสลูกค้า'), "Status", 'สถานะ'), "SupplierCode", 'รหัสผู้จัดจำหน่าย'), "Categorie", 'ประเภท'), "Categories", 'หมวดหมู่'), "StockTransfers", 'การโอนหุ้น'), "StockManagement", 'การจัดการสต็อก'), "dashboard", 'แผงควบคุม'), "Products", 'ผลิตภัณฑ์'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'รายการสินค้า'), "ProductManagement", 'การจัดการผลิตภัณฑ์'), "ProductQuantityAlerts", 'การแจ้งเตือนปริมาณสินค้า'), "CodeProduct", 'รหัสสินค้า'), "ProductTax", 'ภาษีสินค้า'), "SubCategorie", 'หมวดหมู่ย่อย'), "Name_product", 'การกำหนด'), "StockAlert", 'แจ้งเตือนสต๊อก'), "warehouse", 'คลังสินค้า'), "Tax", 'Taxภาษี'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'ราคาซื้อ'), "SellPrice", 'ราคาขาย'), "Quantity", 'ปริมาณ'), "UnitSale", 'ขายหน่วย'), "UnitPurchase", 'ซื้อหน่วย'), "ManagementCurrencies", 'การจัดการสกุลเงิน'), "CurrencyCode", 'รหัสสกุลเงิน'), "CurrencyName", 'ชื่อสกุล'), "Symbol", 'สัญลักษณ์'), "All", 'ทั้งหมด'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", 'แก้ไขผลิตภัณฑ์'), "SearchByCode", 'ค้นหาตามรหัส'), "SearchByName", 'ค้นหาตามชื่อ'), "ProductDetails", 'รายละเอียดสินค้า'), "CustomerName", 'ชื่อลูกค้า'), "CustomerManagement", 'การจัดการลูกค้า'), "Add", 'สร้าง'), "add", 'สร้าง'), "Edit", 'แก้ไข'), "Close", 'ปิด'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'โปรดเลือก'), "Action", 'หนังบู๊'), "Email", 'อีเมล์'), "EditCustomer", 'แก้ไขลูกค้า'), "AddCustomer", 'สร้างลูกค้า'), "Country", 'ประเทศ'), "City", 'เมือง'), "Adress", 'ที่อยู่'), "CustomerDetails", 'รายละเอียดลูกค้า'), "CustomersList", 'รายชื่อลูกค้า'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'รหัสผู้จัดจำหน่าย'), "SupplierName", 'ชื่อผู้ผลิต'), "SuppliersManagement", 'การจัดการซัพพลายเออร์'), "SupplierDetails", 'รายละเอียดซัพพลายเออร์'), "QuotationsManagement", 'การจัดการใบเสนอราคา'), "SubTotal", 'ผลรวมย่อย'), "MontantReste", 'เหลือจำนวน'), "complete", 'เสร็จสมบูรณ์'), "EnAttendant", 'รอดำเนินการ'), "Recu", 'ได้รับ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", 'บางส่วน'), "Retournee", 'กลับ'), "DetailQuote", 'ใบเสนอราคารายละเอียด'), "EditQuote", 'แก้ไขใบเสนอราคา'), "CreateSale", 'สร้างการขาย'), "DownloadPdf", 'ดาวน์โหลด Pdf'), "QuoteEmail", 'ส่งใบเสนอราคาทางอีเมล'), "DeleteQuote", 'ลบใบเสนอราคา'), "AddQuote", 'สร้างใบเสนอราคา'), "SelectProduct", 'เลือกผลิตภัณฑ์'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'สินค้า (รหัส - ชื่อ)'), "Price", 'ราคา'), "CurrentStock", 'คลังสินค้า'), "Total", 'รวม'), "Num", 'ไม่มี'), "Unitcost", 'ต้นทุนต่อหน่วย'), "to", 'ถึง'), "Subject", 'เรื่อง'), "Message", 'ข้อความ'), "EmailCustomer", 'ส่งอีเมลถึงลูกค้า'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", 'ส่ง'), "Quote", 'คำอ้างอิง'), "Hello", 'สวัสดี'), "AttachmentQuote", 'โปรดดูไฟล์แนบสำหรับใบเสนอราคาของคุณ'), "AddProducts", 'เพิ่มสินค้าในรายการสั่งซื้อ'), "SelectWarehouse", 'กรุณาเลือกคลังสินค้า'), "SelectCustomer", 'กรุณาเลือกลูกค้า'), "SalesManagement", 'การบริหารการขาย'), "Balance", 'สมดุล'), "QtyBack", 'ปริมาณกลับ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'ผลตอบแทนรวม'), "Amount", 'จำนวน'), "SaleDetail", 'รายละเอียดการขาย'), "EditSale", 'แก้ไขการขาย'), "AddSale", 'สร้างการขาย'), "ShowPayment", 'แสดงการชำระเงิน'), "AddPayment", 'สร้างการชำระเงิน'), "EditPayment", 'แก้ไขการชำระเงิน'), "EmailSale", 'ส่งการขายทางอีเมล'), "DeleteSale", 'ลบการขาย'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'จ่ายโดย'), "Paymentchoice", 'ทางเลือกในการชำระเงิน'), "Note", 'บันทึก'), "PaymentComplete", 'ชำระเงินเรียบร้อย!'), "PurchasesManagement", 'การจัดการการซื้อ'), "Ordered", 'สั่งซื้อ'), "DeletePurchase", 'ลบการซื้อ'), "EmailPurchase", 'ส่งคำสั่งซื้อทางอีเมล'), "EditPurchase", 'แก้ไขการซื้อ'), "PurchaseDetail", 'รายละเอียดการซื้อ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'สร้างการซื้อ'), "EmailSupplier", 'อีเมลซัพพลายเออร์'), "PurchaseInvoice", 'ซื้อการชำระเงิน'), "PurchasesInvoicesData", 'ซื้อข้อมูลการชำระเงิน'), "SalesInvoice", 'การชำระเงินการขาย'), "SalesInvoicesData", 'ข้อมูลการชำระเงินการขาย'), "UserManagement", 'การจัดการผู้ใช้'), "Firstname", 'ชื่อจริง'), "lastname", 'นามสกุล'), "username", 'ชื่อผู้ใช้'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", 'รหัสผ่าน'), "Newpassword", 'รหัสผ่านใหม่'), "ChangeAvatar", 'เปลี่ยนภาพ'), "LeaveBlank", 'โปรดเว้นฟิลด์นี้ว่างไว้หากคุณยังไม่ได้เปลี่ยนแปลง'), "type", 'ชนิด'), "UserPermissions", 'สิทธิ์ของผู้ใช้'), "RoleName", 'บทบาท'), "RoleDescription", 'คำอธิบายบทบาท'), "AddPermissions", 'สร้างสิทธิ์'), "View", 'ดู'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", 'ลบ'), "NewAdjustement", 'การปรับใหม่'), "EditAdjustement", 'แก้ไขการปรับปรุง'), "CannotSubstraction", 'คุณไม่สามารถลบสินค้าที่มีสต็อก 0 ได้'), "Addition", 'ส่วนที่เพิ่มเข้าไป'), "Subtraction", 'การลบ'), "profil", 'ประวัติ'), "logout", 'ออกจากระบบ'), "PurchaseAlreadyPaid", 'คุณไม่สามารถแก้ไขได้เนื่องจากการซื้อนี้ชำระเงินแล้ว'), "SaleAlreadyPaid", 'คุณไม่สามารถแก้ไขได้เนื่องจากการขายนี้ชำระเงินแล้ว'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'คุณไม่สามารถแก้ไขได้เนื่องจากการส่งคืนนี้ชำระเงินแล้ว'), "QuoteAlready", 'คำพูดนี้สร้างยอดขายแล้ว'), "AddProduct", 'สร้างผลิตภัณฑ์'), "QuotationComplete", 'ใบเสนอราคานี้สมบูรณ์'), "SiteConfiguration", 'การกำหนดค่าไซต์'), "Language", 'ภาษา'), "DefaultCurrency", 'สกุลเงินเริ่มต้น'), "LoginCaptcha", 'เข้าสู่ระบบ Captcha'), "DefaultEmail", 'อีเมลเริ่มต้น'), "SiteName", 'ชื่อไซต์'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'เปลี่ยนโลโก้'), "SMTPConfiguration", 'การกำหนดค่า SMTP'), "HOST", 'โฮสต์'), "PORT", 'ท่าเรือ'), "encryption", 'การเข้ารหัส'), "SMTPIncorrect", 'การกำหนดค่า SMTP ไม่ถูกต้อง'), "PaymentsReturns", 'การคืนเงิน'), "ReturnsInvoices", 'ส่งคืนใบแจ้งหนี้'), "ReturnsInvoicesData", 'ส่งคืนข้อมูลใบแจ้งหนี้'), "ShowAll", 'แสดงบันทึกทั้งหมดของผู้ใช้ทั้งหมด'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", 'ส่วนลด'), "OrderTax", 'ภาษีการสั่งซื้อ'), "Shipping", 'การส่งสินค้า'), "CompanyName", 'ชื่อ บริษัท'), "CompanyPhone", 'โทรศัพท์ บริษัท'), "CompanyAdress", 'ที่อยู่ บริษัท'), "Code", 'รหัส'), "image", 'ภาพ'), "Printbarcode", 'พิมพ์บาร์โค้ด'), "ReturnsCustomers", 'ส่งคืนลูกค้า'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'ส่งคืนซัพพลายเออร์'), "FactureReturnCustomers", 'ส่งคืนใบแจ้งหนี้ของลูกค้า'), "FactureReturnSuppliers", 'ส่งคืนใบแจ้งหนี้ของซัพพลายเออร์'), "NodataAvailable", 'ไม่มีข้อมูลที่สามารถใช้ได้'), "ProductImage", 'รูปภาพสินค้า'), "Barcode", 'บาร์โค้ด'), "pointofsales", 'จุดขาย'), "CustomUpload", 'อัปโหลดแบบกำหนดเอง'), "pointofsaleManagement", 'การจัดการจุดขาย'), "Adjustment", 'การปรับ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", 'อัปเดต'), "Reset", 'รีเซ็ต'), "print", 'พิมพ์'), "SearchByEmail", 'ค้นหาทางอีเมล'), "ChooseProduct", 'เลือกผลิตภัณฑ์'), "Qty", 'จำนวน'), "Items", 'รายการ'), "AmountHT", 'จำนวน'), "AmountTTC", 'จำนวนเงินทั้งหมด'), "PleaseSelectSupplier", 'กรุณาเลือกซัพพลายเออร์'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'กรุณาเลือกสถานะ'), "PayeBy", 'จ่ายโดย'), "ChooseWarehouse", 'เลือกคลังสินค้า'), "payNow", 'จ่ายตอนนี้'), "ListofCategory", 'รายการหมวดหมู่'), "Description", 'คำอธิบาย'), "submit", 'ส่ง'), "ProblemCreatingThisInvoice", 'เกิดปัญหาในการสร้างใบแจ้งหนี้นี้ กรุณาลองอีกครั้ง'), "ProblemPayment", 'เกิดปัญหาในการชำระเงิน กรุณาลองอีกครั้ง.'), "IncomeExpenses", 'รายได้และค่าใช้จ่าย'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'การขายและการซื้อรายวัน'), "ProductsExpired", 'สินค้าหมดอายุ'), "ListofBrand", 'รายชื่อแบรนด์'), "CreateAdjustment", 'สร้างการปรับปรุง'), "Afewwords", 'ไม่กี่คำ ...'), "UserImage", 'รูปภาพผู้ใช้'), "UpdateProduct", 'อัปเดตผลิตภัณฑ์'), "Brand", 'ยี่ห้อ'), "BarcodeSymbology", 'สัญลักษณ์บาร์โค้ด'), "ProductCost", 'ต้นทุนสินค้า'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'ราคาสินค้า'), "UnitProduct", 'ผลิตภัณฑ์หน่วย'), "TaxMethod", 'วิธีการเสียภาษี'), "MultipleImage", 'หลายภาพ'), "ProductHasMultiVariants", 'สินค้ามีหลายตัวแปร'), "ProductHasPromotion", 'สินค้ามีโปรโมชั่น'), "PromotionStart", 'เริ่มโปรโมชั่น'), "PromotionEnd", 'สิ้นสุดโปรโมชั่น'), "PromotionPrice", 'ราคาโปรโมชั่น'), "Price", 'ราคา'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Cost", 'ค่าใช้จ่าย'), "Unit", 'หน่วย'), "ProductVariant", 'ตัวเลือกสินค้า'), "Variant", 'ตัวแปร'), "UnitPrice", 'ราคาต่อหน่วย'), "CreateReturnCustomer", 'สร้างลูกค้าที่กลับมา'), "EditReturnCustomer", 'แก้ไขลูกค้าที่กลับมา'), "CreateReturnSupplier", 'สร้างผู้ส่งคืนสินค้า'), "Documentation", 'เอกสารประกอบ'), "EditReturnSupplier", 'แก้ไขผู้ส่งคืนสินค้า'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'จากคลังสินค้า'), "ToWarehouse", 'ไปยังคลังสินค้า'), "EditTransfer", 'แก้ไขการโอน'), "TransferDetail", 'รายละเอียดการโอน'), "Pending", 'รอดำเนินการ'), "Received", 'ได้รับ'), "Ordered", 'สั่งซื้อ'), "PermissionsManager", 'การจัดการสิทธิ์'), "BrandManager", 'ยี่ห้อ'), "BrandImage", 'ภาพลักษณ์ของแบรนด์'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BrandName", 'ชื่อแบรนด์'), "BrandDescription", 'คำอธิบายแบรนด์'), "BaseUnit", 'หน่วยฐาน'), "ManagerUnits", 'การจัดการหน่วย'), "OperationValue", 'มูลค่าการดำเนินการ'), "Operator", 'ตัวดำเนินการ'), "Top5Products", 'ผลิตภัณฑ์ห้าอันดับแรก'), "Last5Sales", 'การขายห้าครั้งสุดท้าย'), "ListAdjustments", 'การปรับเปลี่ยนรายการ'), "ListTransfers", 'รายการโอน'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'สร้างการโอน'), "OrdersManager", 'การจัดการคำสั่งซื้อ'), "ListQuotations", 'รายการใบเสนอราคา'), "ListPurchases", 'แสดงรายการซื้อ'), "ListSales", 'แสดงรายการขาย'), "ListReturns", 'รายการส่งคืน'), "PeopleManager", 'การบริหารคน'), "Delete", {
  Title: 'คุณแน่ใจไหม?',
  Text: 'คุณจะไม่สามารถเปลี่ยนกลับได้!',
  confirmButtonText: 'ใช่ลบมัน!',
  cancelButtonText: 'ยกเลิก',
  Deleted: 'ลบแล้ว!',
  Failed: 'ล้มเหลว!',
  Therewassomethingwronge: 'มีบางอย่างผิดปกติ',
  CustomerDeleted: 'ลูกค้ารายนี้ถูกลบ',
  SupplierDeleted: 'ซัพพลายเออร์รายนี้ถูกลบ',
  QuoteDeleted: 'ใบเสนอราคานี้ถูกลบ',
  SaleDeleted: 'การลดราคานี้ถูกลบ',
  PaymentDeleted: 'การชำระเงินนี้ถูกลบ',
  PurchaseDeleted: 'การซื้อนี้ถูกลบ',
  ReturnDeleted: 'ผลตอบแทนนี้ถูกลบ',
  ProductDeleted: 'สินค้านี้ถูกลบ',
  ClientError: 'ลูกค้ารายนี้เชื่อมโยงกับการดำเนินการอื่นแล้ว',
  ProviderError: 'ซัพพลายเออร์รายนี้เชื่อมโยงกับการดำเนินการอื่นแล้ว',
  UserDeleted: 'ผู้ใช้รายนี้ถูกลบ.',
  UnitDeleted: 'หน่วยนี้ถูกลบแล้ว',
  RoleDeleted: 'บทบาทนี้ถูกลบ',
  TaxeDeleted: 'ภาษีนี้ถูกลบแล้ว.',
  SubCatDeleted: 'หมวดหมู่ย่อยนี้ถูกลบ.',
  CatDeleted: 'หมวดหมู่นี้ถูกลบ',
  WarehouseDeleted: 'คลังสินค้านี้ถูกลบ',
  AlreadyLinked: 'ผลิตภัณฑ์นี้เชื่อมโยงกับการทำงานอื่นแล้ว',
  AdjustDeleted: 'การปรับปรุงนี้ถูกลบ',
  TitleCurrency: 'สกุลเงินนี้ถูกลบ',
  TitleTransfer: 'ลบการโอนเรียบร้อยแล้ว',
  BackupDeleted: 'ลบข้อมูลสำรองเรียบร้อยแล้ว',
  TitleBrand: 'แบรนด์นี้ถูกลบ'
}), "Update", {
  TitleBrand: 'แบรนด์นี้ได้รับการอัปเดต',
  TitleProfile: 'อัปเดตโปรไฟล์ของคุณเรียบร้อยแล้ว',
  TitleAdjust: 'อัปเดตการปรับปรุงเรียบร้อยแล้ว',
  TitleRole: 'อัปเดตบทบาทในเรียบร้อยแล้ว',
  TitleUnit: 'อัปเดตหน่วยในเรียบร้อยแล้ว',
  TitleUser: 'อัปเดตผู้ใช้เรียบร้อยแล้ว',
  TitleCustomer: 'การอัปเดตลูกค้าในเรียบร้อยแล้ว',
  TitleQuote: 'อัปเดตใบเสนอราคาเรียบร้อยแล้ว',
  TitleSale: 'อัปเดตการขายเรียบร้อยแล้ว',
  TitlePayment: 'อัปเดตการชำระเงินเรียบร้อยแล้ว',
  TitlePurchase: 'อัปเดตการซื้อในเรียบร้อยแล้ว',
  TitleReturn: 'กลับอัปเดตในเรียบร้อยแล้ว',
  TitleProduct: 'อัปเดตผลิตภัณฑ์เรียบร้อยแล้ว',
  TitleSupplier: 'อัปเดตซัพพลายเออร์เรียบร้อยแล้ว',
  TitleTaxe: 'อัปเดตภาษีเรียบร้อยแล้ว',
  TitleCat: 'อัปเดตหมวดหมู่เรียบร้อยแล้ว',
  TitleWarhouse: 'อัปเดตคลังสินค้าเรียบร้อยแล้ว',
  TitleSetting: 'อัปเดตการตั้งค่าเรียบร้อยแล้ว',
  TitleCurrency: 'อัปเดตสกุลเงินสำเร็จแล้ว',
  TitleTransfer: 'อัปเดตการโอนเข้าเรียบร้อยแล้ว'
}), "Create", {
  TitleBrand: 'แบรนด์นี้ถูกสร้างขึ้น',
  TitleRole: 'สร้างบทบาทในสำเร็จแล้ว',
  TitleUnit: 'สร้างหน่วยในสำเร็จแล้ว',
  TitleUser: 'สร้างผู้ใช้ในสำเร็จแล้ว',
  TitleCustomer: 'สร้างลูกค้าสำเร็จแล้ว',
  TitleQuote: 'สร้างใบเสนอราคาสำเร็จแล้ว',
  TitleSale: 'สร้างการขายสำเร็จแล้ว',
  TitlePayment: 'สร้างการชำระเงินในเรียบร้อยแล้ว',
  TitlePurchase: 'สร้างในการซื้อเรียบร้อยแล้ว',
  TitleReturn: 'ส่งคืนสร้างในเรียบร้อยแล้ว',
  TitleProduct: 'สร้างผลิตภัณฑ์สำเร็จแล้ว',
  TitleSupplier: 'สร้างซัพพลายเออร์ในเรียบร้อยแล้ว',
  TitleTaxe: 'สร้างภาษีเรียบร้อยแล้ว',
  TitleCat: 'สร้างหมวดหมู่สำเร็จแล้ว',
  TitleWarhouse: 'สร้างคลังสินค้าในเรียบร้อยแล้ว',
  TitleAdjust: 'สร้างการปรับปรุงในสำเร็จแล้ว',
  TitleCurrency: 'สร้างสกุลเงินสำเร็จแล้ว',
  TitleTransfer: 'โอนสร้างในเรียบร้อยแล้ว'
}), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'ส่งอีเมลเรียบร้อยแล้ว'
}), "return", {
  TitleSale: 'การขายนี้เชื่อมโยงกับการคืนสินค้าแล้ว!'
}), "ReturnManagement", 'การจัดการผลตอบแทน'), "ReturnDetail", 'รายละเอียดการคืนสินค้า'), "EditReturn", 'แก้ไขผลตอบแทน'), "AddReturn", 'สร้างผลตอบแทน'), "EmailReturn", 'ส่งผลตอบแทนทางอีเมล'), "DeleteReturn", 'ลบผลตอบแทน'), "Retoursurcharge", 'คืนเงินเพิ่ม'), "Laivrison", 'จัดส่ง'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectSale", 'เลือกลดราคา'), "ZeroPardefault", 'คุณสามารถลบรายการหรือตั้งค่าปริมาณที่ส่งคืนเป็นศูนย์หากไม่มีการส่งคืน'), "Return", 'กลับ'), "Purchase", 'ซื้อ'), "TotalSales", 'ยอดขายทั้งหมด'), "TotalPurchases", 'การซื้อทั้งหมด'), "TotalReturns", 'ผลตอบแทนรวม'), "PaiementsNet", 'การชำระเงินสุทธิ'), "PaiementsSent", 'ส่งการชำระเงิน'), "PaiementsReceived", 'การชำระเงินที่ได้รับ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Recieved", 'ได้รับ'), "Sent", 'ส่งแล้ว'), "ProductQuantityAlerts", 'การแจ้งเตือนปริมาณสินค้า'), "ProductCode", 'รหัส'), "ProductName", 'สินค้า'), "AlertQuantity", 'ปริมาณการแจ้งเตือน'), "WarehouseStockChart", 'แผนภูมิสต็อคคลังสินค้า'), "TotalProducts", 'ผลิตภัณฑ์ทั้งหมด'), "TotalQuantity", 'ปริมาณรวม'), "TopCustomers", 'ลูกค้าห้าอันดับแรก'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'จำนวนเงินทั้งหมด'), "TotalPaid", 'ทั้งหมดที่จ่าย'), "CustomerSalesReport", 'รายงานการขายของลูกค้า'), "CustomerPaiementsReport", 'รายงานการชำระเงินของลูกค้า'), "CustomerQuotationsReport", 'รายงานใบเสนอราคาของลูกค้า'), "Payments", 'การชำระเงิน'), "TopSuppliers", 'ซัพพลายเออร์ห้าอันดับแรก'), "SupplierPurchasesReport", 'รายงานการซื้อของซัพพลายเออร์'), "SupplierPaiementsReport", 'รายงานการชำระเงินของซัพพลายเออร์'), "Name", 'ชื่อ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Code", 'รหัส'), "ManagementWarehouse", 'การจัดการคลังสินค้า'), "ZipCode", 'รหัสไปรษณีย์'), "managementCategories", 'การจัดการหมวดหมู่'), "Codecategorie", 'หมวดรหัส'), "Namecategorie", 'หมวดหมู่ชื่อ'), "Parentcategorie", 'หมวดหมู่ผู้ปกครอง'), "managementTax", 'การจัดการภาษี'), "TaxName", 'ชื่อผู้เสียภาษี'), "TaxRate", 'อัตราภาษี'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'หน่วยการซื้อ'), "managementUnitSales", 'หน่วยขาย'), "ShortName", 'ชื่อสั้น'), "PleaseSelectThesebeforeaddinganyproduct", 'โปรดเลือกสิ่งเหล่านี้ก่อนเพิ่มผลิตภัณฑ์ใด ๆ'), "StockAdjustement", 'การปรับหุ้น'), "PleaseSelectWarehouse", 'กรุณาเลือกคลังสินค้าก่อนเลือกสินค้า'), "StockTransfer", 'การโอนหุ้น'), "SelectPeriod", 'เลือกช่วงเวลา'), "ThisYear", 'ปีนี้'), "ThisToday", 'วันนี้'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'เดือนนี้'), "ThisWeek", 'ในสัปดาห์นี้'), "AdjustmentDetail", 'รายละเอียดการปรับ'), "ActivateUser", 'ผู้ใช้นี้ได้รับการเปิดใช้งานแล้ว'), "DisActivateUser", 'ผู้ใช้รายนี้ถูกปิดใช้งาน'), "NotFound", 'ไม่พบหน้านี้.'), "oops", 'ผิดพลาด! ไม่พบหน้านี้.'), "couldNotFind", 'เราไม่พบหน้าที่คุณกำลังค้นหาในขณะเดียวกันคุณอาจ'), "ReturnDashboard", 'กลับไปที่แดชบอร์ด'), "hrm", 'HRM'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Employees", 'พนักงาน'), "Attendance", 'การเข้าร่วมประชุม'), "Leave_request", 'ใบลา'), "Leave_type", 'ออกจาก ประเภท'), "Company", 'บริษัท'), "Departments", 'แผนก'), "Designations", 'สมญา'), "Office_Shift", 'ออฟฟิศกะ'), "Holidays", 'วันหยุดพักผ่อน'), "Enter_Company_Name", 'ใส่ชื่อบริษัท'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'ใส่ที่อยู่อีเมล'), "Enter_Company_Phone", 'ใส่โทรศัพท์บริษัท'), "Enter_Company_Country", 'ใส่ประเทศบริษัท'), "Created_in_successfully", 'สร้างสำเร็จแล้ว'), "Updated_in_successfully", 'อัพเดทเรียบร้อย'), "Deleted_in_successfully", 'ลบเรียบร้อยแล้ว'), "department", 'แผนก'), "Enter_Department_Name", 'ใส่ชื่อแผนก'), "Choose_Company", 'เลือกบริษัท'), "Department_Head", 'หัวหน้าแผนก'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'เลือกหัวหน้าแผนก'), "Enter_Shift_name", 'ใส่ชื่อกะ'), "Monday_In", 'Monday In'), "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'ฮอลิเดย์'), "Enter_title", 'ใส่ชื่อเรื่อง'), "title", 'ชื่อเรื่อง'), "start_date", 'วันที่เริ่มต้น'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'ใส่วันที่เริ่มต้น'), "Finish_Date", 'วันที่สิ้นสุด'), "Enter_Finish_date", 'ใส่วันที่สิ้นสุด'), "Please_provide_any_details", 'กรุณาให้รายละเอียดใด ๆ'), "Attendances", 'การเข้าร่วมประชุม'), "Enter_Attendance_date", 'ใส่วันที่'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", 'เลือกลูกจ้าง'), "Employee", 'พนักงาน'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'เวลางาน'), "remaining_leaves_are_insufficient", 'ใบที่เหลืออยู่ไม่เพียงพอ'), "Leave_Type", 'ออกจาก ประเภท'), "Days", 'วัน'), "Department", 'แผนก'), "Choose_leave_type", 'เลือกประเภทการลา'), "Choose_status", 'เลือกสถานะ'), "Leave_Reason", 'ทิ้งเหตุผล'), "Enter_Reason_Leave", 'ป้อนเหตุผล ลา'), "Add_Employee", 'เพิ่มลูกจ้าง'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FirstName", 'ชื่อ'), "Enter_FirstName", 'ใส่ชื่อ'), "LastName", 'นามสกุล'), "Enter_LastName", 'ใส่นามสกุล'), "Gender", 'เพศ'), "Choose_Gender", 'เลือกเพศ'), "Enter_Birth_date", 'ใส่วันเดือนปีเกิด'), "Birth_date", 'วันเดือนปีเกิด'), "Enter_Country", 'ป้อนประเทศ'), "Enter_Phone_Number", 'ใส่หมายเลขโทรศัพท์'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "joining_date", 'วันที่เข้าร่วม'), "Enter_joining_date", 'เข้า วันที่เข้าร่วม'), "Choose_Designation", 'เลือกการกำหนด'), "Designation", 'สมญา'), "Office_Shift", 'กะที่ทำงาน'), "Choose_Office_Shift", 'เลือกกะสำนักงาน'), "Enter_Leaving_Date", 'ใส่วันที่ออกเดินทาง'), "Leaving_Date", 'วันที่ออกเดินทาง'), "Annual_Leave", 'ลาหยุดประจำปี'), "Enter_Annual_Leave", 'เข้าสู่วันหยุดประจำปี'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'วันลาที่เหลือ'), "Employee_Details", 'รายละเอียดพนักงาน'), "Basic_Information", 'ข้อมูลพื้นฐาน'), "Family_status", 'สถานะครอบครัว'), "Choose_Family_status", 'เลือกสถานะครอบครัว'), "Employment_type", 'ประเภทการจ้างงาน'), "Select_Employment_type", 'เลือกประเภทการจ้างงาน'), "Enter_City", 'ใส่เมือง'), "Province", 'จังหวัด'), "Enter_Province", 'ใส่จังหวัด'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'ใส่ที่อยู่'), "Enter_Zip_code", 'กรอกรหัสไปรษณีย์'), "Zip_code", 'รหัสไปรษณีย์'), "Hourly_rate", 'อัตราชั่วโมง'), "Enter_Hourly_rate", 'ป้อนอัตรารายชั่วโมง'), "Basic_salary", 'เงินเดือนพื้นฐาน'), "Enter_Basic_salary", 'ใส่เงินเดือนพื้นฐาน'), "Social_Media", 'สื่อสังคม'), "Skype", 'สไกป์'), "Enter_Skype", 'เข้า Skype'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), "Enter_Facebook", 'เข้า Facebook'), "WhatsApp", 'WhatsApp'), "Enter_WhatsApp", 'เข้า WhatsApp'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", 'เข้า LinkedIn'), "Twitter", 'Twitter'), "Enter_Twitter", 'เข้า Twitter'), "Experiences", 'ประสบการณ์'), "bank_account", 'บัญชีธนาคาร'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Company_Name", 'ชื่อ บริษัท'), "Location", 'ที่ตั้ง'), "Enter_location", 'เข้า ที่ตั้ง'), "Enter_Description", 'ใส่คำอธิบาย'), "Bank_Name", 'ชื่อธนาคาร'), "Enter_Bank_Name", 'ใส่ชื่อธนาคาร'), "Bank_Branch", 'สาขาธนาคาร'), "Enter_Bank_Branch", 'ใส่สาขาธนาคาร'), "Bank_Number", 'เลขที่ธนาคาร'), "Enter_Bank_Number", 'ใส่หมายเลขธนาคาร'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'คลังสินค้าที่ได้รับมอบหมาย'), "Top_customers", 'ลูกค้าชั้นยอด'), "Attachment", 'เอกสารแนบ'), "view_employee", 'ดูพนักงาน'), "edit_employee", 'แก้ไขพนักงาน'), "delete_employee", 'ลบพนักงาน'), "Created_by", 'เพิ่มโดย'), "Add_product_IMEI_Serial_number", 'เพิ่มผลิตภัณฑ์ IMEI/หมายเลขซีเรียล'), "Product_Has_Imei_Serial_number", 'สินค้ามี Imei/หมายเลขซีเรียล'), "IMEI_SN", 'IMEI/SN'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Shipments", 'การจัดส่ง'), "delivered_to", 'ส่งถึง'), "shipment_ref", 'อ้างอิงการจัดส่ง'), "sale_ref", 'อ้างอิงการขาย'), "Edit_Shipping", 'แก้ไขการจัดส่ง'), "Packed", 'บรรจุ'), "Shipped", 'จัดส่งแล้ว'), "Delivered", 'ส่ง'), "Cancelled", 'ยกเลิก'), "Shipping_status", 'สถานะการจัดส่งสินค้า'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users_Report", 'รายงานผู้ใช้'), "stock_report", 'รายงานสต็อค'), "TotalPurchases", 'ยอดซื้อทั้งหมด'), "Total_quotations", 'ใบเสนอราคาทั้งหมด'), "Total_return_sales", 'ผลตอบแทนรวมของยอดขาย'), "Total_return_purchases", 'ยอดซื้อคืน'), "Total_transfers", 'ยอดโอน'), "Total_adjustments", 'การปรับทั้งหมด'), "User_report", 'รายงานผู้ใช้'), "Current_stock", 'หุ้นปัจจุบัน'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_name", 'ชื่อผลิตภัณฑ์'), "Total_Customers_Due", 'หนี้สินรวม'), "Total_Suppliers_Due", 'หนี้สินรวม'), "Some_warehouses", 'โกดังบางส่วน'), "All_Warehouses", 'คลังสินค้าทั้งหมด'), "Product_Cost", 'ต้นทุนสินค้า'), "sms_settings", 'การตั้งค่า SMS'), "pos_settings", 'การตั้งค่า POS'), "payment_gateway", 'ช่องทางการชำระเงิน'), "mail_settings", 'การตั้งค่าเมล'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'เกตเวย์ SMS เริ่มต้น'), "module_settings", 'การตั้งค่าโมดูล'), "Module_enabled_success", 'เปิดใช้งานโมดูลเรียบร้อยแล้ว'), "Module_Disabled_success", 'โมดูลปิดการใช้งานเรียบร้อยแล้ว'), "update_settings", 'ปรับปรุงการตั้งค่า'), "Please_Upload_the_Correct_Module", 'โปรดอัปโหลดโมดูลที่ถูกต้อง'), "Uploaded_Success", 'อัพโหลดเรียบร้อยแล้ว'), "Customer_details", 'รายละเอียดลูกค้า'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'แก้ไขลูกค้า'), "Delete_Customer", 'ลบลูกค้า'), "Pay_Due", 'จ่ายครบกำหนด'), "Paying_amount_is_greater_than_Total_Due", 'จำนวนเงินที่ชำระมากกว่าครบกำหนดทั้งหมด'), "Customer_Invoice", 'ใบแจ้งหนี้ลูกค้า'), "This_Product_Not_For_Selling", 'สินค้านี้ไม่ได้สำหรับขาย'), "Welcome_to_your_Dashboard", 'ยินดีต้อนรับสู่แดชบอร์ดของคุณ'), "Total_Payable", 'เจ้าหนี้รวม'), "Choose_Sale_Ref", 'เลือก อ้างอิงการขาย'), "Please_Select_Sale", 'กรุณาเลือก Sale'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'อ้างอิงการขาย'), "list_product_returns", 'รายการคืนสินค้า'), "Qty_return", 'ปริมาณที่ส่งคืน'), "Choose_Purchase_Ref", 'เลือกอ้างอิงการซื้อ'), "Purchase_Ref", 'อ้างอิงการซื้อ'), "please_select_purchase", 'กรุณาเลือกซื้อสินค้า'), "qty_return_is_greater_than_qty_purchased", 'จำนวนการคืนสินค้ามากกว่าจำนวนที่ซื้อ'), "qty_return_is_greater_than_qty_sold", 'จำนวนผลตอบแทนมากกว่าจำนวนที่ขายได้'), "Quantity_sold", 'จำนวน ขายแล้ว'), "qty_purchased", 'ปริมาณที่ซื้อ'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'ชื่อผู้ส่ง'), "The_module_must_be_uploaded_as_zip_file", 'ต้องอัปโหลดโมดูลเป็นไฟล์ zip'), "Upload_Module", 'อัปโหลดโมดูล'), "All_Modules_Installed", 'ติดตั้งโมดูลทั้งหมดแล้ว'), "Current_Version", 'เวอร์ชันปัจจุบัน'), "You_already_have_the_latest_version", 'คุณมีเวอร์ชันล่าสุดแล้ว'), "Update_Available", 'อัพเดทพร้อมใช้งาน'), "Update_Log", 'อัปเดต'), "Update_Now", 'อัพเดทตอนนี้'), "View_Change_Log", 'ดูบันทึกการเปลี่ยน'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'ส่วนท้ายของใบแจ้งหนี้'), "Please_Wait_for_the_update", 'หมายเหตุ: โปรดรอให้การอัปเดตเสร็จสิ้นโดยสมบูรณ์ ไม่แนะนำให้ปิดเบราว์เซอร์หรือหยุดกระบวนการอัพเกรด'), "Note_update", 'หมายเหตุ: ตรวจสอบให้แน่ใจว่าคุณได้สำรองเวอร์ชันปัจจุบันและฐานข้อมูลของคุณก่อนที่จะเรียกใช้การอัปเกรด หากต้องการกู้คืนหากมีข้อผิดพลาด'), "Time_Zone", 'เขตเวลา'), "Payment_note", 'หมายเหตุการชำระเงิน'), "sale_note", 'หมายเหตุการขาย'), "Total_Sale_Due", 'หนี้ขายทั้งหมด'), "Total_Sell_Return_Due", 'ผลตอบแทนรวมที่ครบกำหนด'), "pay_all_sell_due_at_a_time", 'จ่ายหนี้ขายทั้งหมดพร้อมๆ กัน'), "pay_all_sell_return_due_at_a_time", 'จ่ายทั้งหมด คืนครบกำหนด'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'กำไรขั้นต้น'), "pay_all_purchase_due_at_a_time", 'ชำระเงินที่ซื้อทั้งหมดในคราวเดียว'), "Delete_Provider", 'ลบผู้ให้บริการ'), "Edit_Provider", 'อัปเดตผู้ให้บริการ'), "Provider_details", 'รายละเอียดซัพพลายเออร์'), "Total_Purchase_Due", 'หนี้ซื้อทั้งหมด'), "Provider_Credit_Note", 'ใบลดหนี้'), "Customer_Credit_Note", 'ใบลดหนี้'), "Sell_Return", 'ส่งคืน'), "Purchase_Return", 'ส่งคืน'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'หมายเลขภาษี'), "Please_add_return_quantity", 'กรุณาเพิ่มปริมาณการคืนสินค้า'), "Return_exist_for_the_Transaction", 'ส่งคืนสำหรับธุรกรรม'), "qty_return_is_greater_than_Quantity_Remaining", 'จำนวนการคืนสินค้ามากกว่าปริมาณคงเหลือ'), "products_refunded_alert", 'สินค้าใด ๆ ที่มีการกำหนดจำนวนเป็น 0 จะไม่ได้รับการคืนเงิน'), "pay_all_purchase_return_due_at_a_time", 'จ่ายผลตอบแทนทั้งหมดในคราวเดียว'), "Total_Purchase_Return_Due", 'ผลตอบแทนรวมที่ครบกำหนด'), "Purchase_return_due", 'หนี้ผลตอบแทน'), "Sell_return_due", 'หนี้ผลตอบแทน'), "product_report", 'รายงานสินค้า'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'รายงานการขายสินค้า'), "Product_purchases_report", 'รายงานการซื้อผลิตภัณฑ์'), "Qty_sold", 'จำนวน'), "Qty_purchased", 'ปริมาณที่ซื้อ'), "Filter_by_warehouse", 'กรองตามคลังสินค้า'), "Enable_Print_Invoice", 'พิมพ์ใบแจ้งหนี้โดยอัตโนมัติ'), "Show_Warehouse", 'ดูคลังสินค้า'), "credit_card_info", 'ข้อมูลบัตรเครดิต'), "Saved_Credit_Card_Info", 'ข้อมูลบัตรเครดิตที่บันทึกไว้'), "Credit_card_changed_successfully", 'เปลี่ยนแปลงบัตรเครดิตเรียบร้อยแล้ว'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "notification_template", 'แม่แบบการแจ้งเตือน'), "email_notification", 'การแจ้งเตือนทางอีเมล'), "sms_notification", 'การแจ้งเตือนทาง SMS'), "Change_product_details", 'เปลี่ยนรายละเอียดสินค้า'), "edit_tax_and_discount_and_shipping", 'แก้ไขภาษี ส่วนลด และการจัดส่งสินค้า'), "Create_Quotation_with_Stock", 'สร้างใบเสนอราคาพร้อมสต็อก'), "Variant_Name", 'ชื่อตัวแปร'), "Variant_cost", 'ต้นทุนตัวแปร'), "Variant_price", 'ราคาตัวแปร'), "Variant_code", 'รหัสตัวแปร'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'กรุณารอจนกว่าสินค้าจะโหลดเสร็จ'), "Choose_SMS_Gateway", 'เลือก SMS Gateway'), "Notification_Client", 'ผู้รับการแจ้งเตือน'), "Available_Tags", 'แท็กที่มีอยู่'), "Email_Subject", 'หัวข้ออีเมล'), "Email_body", 'เนื้อหาอีเมล'), "Notification_Supplier", 'ผู้จัดส่งการแจ้งเตือน'), "sms_body", 'เนื้อหา SMS'), "sms_templates", 'SMS Templates'), "email_templates", 'Email Templates'));

/***/ }),

/***/ "./resources/src/translations/locales/tr_ch.js":
/*!*****************************************************!*\
  !*** ./resources/src/translations/locales/tr_ch.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Traditional Chinese

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: '收據',
  Pos_Settings: '銷售點設置',
  Note_to_customer: '客戶須知',
  Show_Note_to_customer: '向客戶顯示備註',
  Show_barcode: '顯示條形碼',
  Show_Tax_and_Discount: '顯示稅收、折扣和運費',
  Show_Customer: '顯示客戶',
  Show_Email: '顯示電子郵件',
  Show_Phone: '顯示電話',
  Show_Address: '顯示地址',
  DefaultLanguage: '默認語言',
  footer: '頁腳',
  Received_Amount: '收到金額',
  Paying_Amount: '支付金額',
  Change: '改變',
  Paying_amount_is_greater_than_Received_amount: '支付金額大於收到金額',
  Paying_amount_is_greater_than_Grand_Total: '支付金額大於總計',
  code_must_be_not_exist_already: '代碼必須不存在',
  You_will_find_your_backup_on: '你會發現你的備份',
  and_save_it_to_your_pc: '並將其保存到您的電腦',
  Scan_your_barcode_and_select_the_correct_symbology_below: '掃描您的條形碼並在下方選擇正確的符號',
  Scan_Search_Product_by_Code_Name: '按代碼名稱掃描/搜索產品',
  Paper_size: '紙張尺寸',
  Clear_Cache: '清除緩存',
  Cache_cleared_successfully: '緩存清除成功',
  Failed_to_clear_cache: '清除緩存失敗',
  Scan_Barcode: '條形碼掃描器',
  Please_use_short_name_of_unit: '請使用單位簡稱',
  DefaultCustomer: '默認客戶',
  DefaultWarehouse: '默認倉庫',
  Payment_Gateway: '支付網關',
  SMS_Configuration: '短信配置',
  Gateway: '支付網關',
  Choose_Gateway: '選擇支付網關',
  Send_SMS: '消息已成功發送',
  sms_config_invalid: '錯誤的短信配置無效',
  Remove_Stripe_Key_Secret: '刪除Stripe API密鑰',
  credit_card_account_not_available: '信用卡帳戶不可用',
  Credit_Card_Info: '信用卡資料',
  developed_by: '由開發',
  Unit_already_linked_with_sub_unit: '單元已與子單元鏈接',
  Total_Items_Quantity: '項目總數和數量',
  Value_by_Cost_and_Price: '按成本和價格的價值',
  Search_this_table: '搜索此表',
  import_products: '進口產品',
  Field_optional: '字段可選',
  Download_exemple: '下載範例',
  field_must_be_in_csv_format: '字段必須為csv格式',
  Successfully_Imported: '成功導入',
  file_size_must_be_less_than_1_mega: '檔案大小必須小於1兆',
  Please_follow_the_import_instructions: '請遵循導入說明',
  must_be_exist: '單位必須已經創建',
  Import_Customers: '導入客戶',
  Import_Suppliers: '進口供應商',
  Recent_Sales: '最近的銷售',
  Create_Transfer: '創建轉移',
  order_products: '訂購物品',
  Search_Product_by_Code_Name: '按代碼或名稱搜索產品',
  Reports_payments_Purchase_Return: '報告購買退貨付款',
  Reports_payments_Sale_Return: '報告銷售退貨付款',
  payments_Sales_Return: '付款銷售退貨',
  payments_Purchases_Return: '付款購買退貨',
  CreateSaleReturn: '創建銷售退貨',
  EditSaleReturn: '編輯銷售退貨',
  SalesReturn: '銷售退貨',
  CreatePurchaseReturn: '創建採購退貨',
  EditPurchaseReturn: '編輯購買退貨',
  PurchasesReturn: '採購退貨',
  Due: '到期的',
  Profit: '利潤',
  Revenue: '收入',
  Sales_today: '今日銷量',
  People: '人們',
  Successfully_Created: '成功創建',
  Successfully_Updated: '成功更新',
  Success: '成功',
  Failed: '失敗的',
  Warning: '警告',
  Please_fill_the_form_correctly: '請正確填寫表格',
  Field_is_required: '必填項',
  Error: '錯誤!',
  you_are_not_authorized: '對不起！ 您沒有權限。',
  Go_back_to_home: '返回首頁',
  page_not_exist: '對不起！ 您要查找的頁面不存在。',
  Choose_Status: '選擇狀態',
  Choose_Method: '選擇方法',
  Choose_Symbology: '選擇符號',
  Choose_Category: '選擇類別',
  Choose_Customer: '選擇客戶',
  Choose_Supplier: '選擇供應商',
  Choose_Unit_Purchase: '選擇採購單位',
  Choose_Sub_Category: '選擇子類別',
  Choose_Brand: '選擇品牌',
  Choose_Warehouse: '選擇倉庫',
  Choose_Unit_Sale: '選擇銷售單位',
  Enter_Product_Cost: '輸入產品成本',
  Enter_Stock_alert: '輸入庫存警報',
  Choose_Unit_Product: '選擇產品單位',
  Enter_Product_Price: '輸入產品價格',
  Enter_Name_Product: '輸入名稱產品',
  Enter_Role_Name: '輸入角色名稱',
  Enter_Role_Description: '輸入角色描述',
  Enter_name_category: '輸入類別名稱',
  Enter_Code_category: '輸入類別代碼',
  Enter_Name_Brand: '輸入名稱品牌',
  Enter_Description_Brand: '輸入描述品牌',
  Enter_Code_Currency: '輸入代碼貨幣',
  Enter_name_Currency: '輸入名稱貨幣',
  Enter_Symbol_Currency: '輸入符號貨幣',
  Enter_Name_Unit: '輸入單位名稱',
  Enter_ShortName_Unit: '輸入簡稱單位',
  Choose_Base_Unit: '選擇基本單位',
  Choose_Operator: '選擇運營商',
  Enter_Operation_Value: '輸入操作值',
  Enter_Name_Warehouse: '輸入倉庫名稱',
  Enter_Phone_Warehouse: '輸入倉庫電話',
  Enter_Country_Warehouse: '輸入倉庫國家',
  Enter_City_Warehouse: '進入倉庫城市',
  Enter_Email_Warehouse: '輸入倉庫電子郵件',
  Enter_ZipCode_Warehouse: '輸入倉庫郵政編碼',
  Choose_Currency: '選擇貨幣',
  Thank_you_for_your_business: '感謝您的業務！',
  Cancel: '取消',
  New_Customer: '新客戶',
  Incorrect_Login: '登陸錯誤',
  Successfully_Logged_In: '成功登錄',
  This_user_not_active: '該用戶不活躍',
  SignIn: '登入',
  Create_an_account: '創建一個帳戶',
  Forgot_Password: '忘記密碼 ？',
  Email_Address: '電子郵件地址',
  SignUp: '報名',
  Already_have_an_account: '已經有帳號了？',
  Reset_Password: '重設密碼',
  Failed_to_authenticate_on_SMTP_server: '無法在SMTP服務器上進行身份驗證',
  We_cant_find_a_user_with_that_email_addres: '我們找不到使用該電子郵件地址的用戶',
  We_have_emailed_your_password_reset_link: '我們已經通過電子郵件發送了您的密碼重置鏈接',
  Please_fill_the_Email_Adress: '請填寫電子郵件地址',
  Confirm_password: '確認密碼',
  Your_Password_has_been_changed: '您的密碼已被更改',
  The_password_confirmation_does_not_match: '密碼確認不匹配',
  This_password_reset_token_is_invalid: '此密碼重置令牌無效',
  Warehouse_report: '倉庫報告',
  All_Warehouses: '所有倉庫',
  Expense_List: '費用清單',
  Expenses: '花費',
  This_Week_Sales_Purchases: '本週銷售與購買',
  Top_Selling_Products: '暢銷產品',
  View_all: '查看全部',
  Payment_Sent_Received: '已發送並已收到付款',
  Filter: '過濾',
  Invoice_POS: '發票POS',
  Invoice: '發票',
  Customer_Info: '客戶信息',
  Company_Info: '公司介紹',
  Invoice_Info: '發票信息',
  Order_Summary: '訂單摘要',
  Quote_Info: '報價信息',
  Del: '刪除',
  SuppliersPaiementsReport: '供應商付款報告',
  Purchase_Info: '購買信息',
  Supplier_Info: '供應商信息',
  Return_Info: '退貨信息',
  Expense_Category: '費用類別',
  Create_Expense: '創建費用',
  Details: '細節',
  Discount_Method: '優惠方式',
  Net_Unit_Cost: '淨單位成本',
  Net_Unit_Price: '淨單價',
  Edit_Expense: '編輯費用',
  All_Brand: '所有品牌',
  All_Category: '所有類別',
  ListExpenses: '清單費用',
  Create_Permission: '建立權限',
  Edit_Permission: '編輯權限',
  Reports_payments_Sales: '報告付款銷售',
  Reports_payments_Purchases: '報告付款購買',
  Reports_payments_Return_Customers: '報告付款返回客戶',
  Reports_payments_Return_Suppliers: '報表付款退貨供應商',
  Expense_Deleted: '該費用已被刪除',
  Expense_Updated: '此費用已更新',
  Expense_Created: '費用已創建',
  DemoVersion: '您無法在演示版中執行此操作',
  OrderStatistics: '銷售統計',
  AlreadyAdd: '該產品已添加！',
  AddProductToList: '請添加產品到列表！',
  AddQuantity: '請添加詳細數量！',
  InvalidData: '無效數據 ！！',
  LowStock: '數量超過庫存可用數量',
  WarehouseIdentical: '兩個倉庫不能完全相同！',
  VariantDuplicate: '這個變種是重複的！',
  Filesize: '文件大小',
  GenerateBackup: '產生備份',
  BackupDatabase: '備份資料庫',
  Backup: '後備',
  Paid: '已付費',
  Unpaid: '未付',
  Today: '今天',
  Income: '收入'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", '花費'), "Sale", '特賣'), "Actif", '活性'), "Inactif", '不活躍'), "Customers", '顧客'), "Phone", '電話'), "SearchByPhone", '通過電話搜索'), "Suppliers", '供應商'), "Quotations", '報價單'), "Sales", '營業額'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", '採購'), "Returns", '退貨'), "Settings", '設定值'), "SystemSettings", '系統設置'), "Users", '用戶數'), "GroupPermissions", '組權限'), "Currencies", '貨幣'), "Warehouses", '貨倉'), "Units", '單位'), "UnitsPrchases", '單位購買'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", '單位銷售'), "Reports", '報告書'), "PaymentsReport", '付款報告'), "PaymentsPurchases", '付款購買'), "PaymentsSales", '付款銷售'), "ProfitandLoss", '收益與損失'), "WarehouseStockChart", '倉庫庫存圖'), "SalesReport", '銷售報告'), "PurchasesReport", '採購報告'), "CustomersReport", '客戶報告'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", '供應商報告'), "SupplierReport", '供應商報告'), "DailySalesData", '每日銷售數據'), "DailyPurchasesData", '每日購買數據'), "Derni\xE8rescinqrecords", '最近五條記錄'), "Filters", '篩選器'), "date", '日期'), "Reference", '參考'), "Supplier", '供應商'), "PaymentStatus", '支付狀態'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", '顧客'), "CustomerCode", '客戶代碼'), "Status", '狀態'), "SupplierCode", '供應商代碼'), "Categorie", '類別'), "Categories", '分類目錄'), "StockTransfers", '庫存轉移'), "StockManagement", '庫存管理'), "dashboard", '儀表板'), "Products", '產品展示'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", '產品清單'), "ProductManagement", '產品管理'), "ProductQuantityAlerts", '產品數量警報'), "CodeProduct", '代碼產品'), "ProductTax", '產品稅'), "SubCategorie", '子類別'), "Name_product", '指定'), "StockAlert", '庫存警報'), "warehouse", '倉庫'), "Tax", '稅'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", '買價'), "SellPrice", '賣價'), "Quantity", '數量'), "UnitSale", '單位銷售'), "UnitPurchase", '單位購買'), "ManagementCurrencies", '貨幣管理'), "CurrencyCode", '貨幣代碼'), "CurrencyName", '貨幣名稱'), "Symbol", '符號'), "All", '所有'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", '編輯產品'), "SearchByCode", '按代碼搜索'), "SearchByName", '按名稱搜索'), "ProductDetails", '產品詳情'), "CustomerName", '顧客姓名'), "CustomerManagement", '用戶管理'), "Add", '創建'), "add", '創建'), "Edit", '編輯'), "Close", '關'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", '請選擇'), "Action", '行動'), "Email", '電子郵件'), "EditCustomer", '編輯客戶'), "AddCustomer", '建立客戶'), "Country", '國家'), "City", '市'), "Adress", '地址'), "CustomerDetails", '顧客信息'), "CustomersList", '客戶名單'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierCode", '供應商代碼'), "SupplierName", '供應商名稱'), "SuppliersManagement", '供應商管理'), "SupplierDetails", '供應商詳細信息'), "QuotationsManagement", '報價管理'), "SubTotal", '小計'), "MontantReste", '剩餘金額'), "complete", '已完成'), "EnAttendant", '待定'), "Recu", '已收到'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", '部分的'), "Retournee", '返回'), "DetailQuote", '詳細報價'), "EditQuote", '編輯報價'), "CreateSale", '建立銷售'), "DownloadPdf", '下載pdf'), "QuoteEmail", '電子郵件發送報價'), "DeleteQuote", '刪除報價'), "AddQuote", '創建報價'), "SelectProduct", '選擇產品'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", '產品（代碼-名稱）'), "Price", '價錢'), "CurrentStock", '股票'), "Total", '總'), "Num", 'N°'), "Unitcost", '單位成本'), "to", '至'), "Subject", '學科'), "Message", '信息'), "EmailCustomer", '電郵客戶'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", '發送'), "Quote", '報價單'), "Hello", '你好'), "AttachmentQuote", '請找到您的報價附件'), "AddProducts", '將產品添加到訂單清單'), "SelectWarehouse", '請選擇倉庫'), "SelectCustomer", '請選擇客戶'), "SalesManagement", '銷售管理'), "Balance", '平衡'), "QtyBack", '數量返還'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", '總回報'), "Amount", '量'), "SaleDetail", '銷售明細'), "EditSale", '編輯銷售'), "AddSale", '建立銷售'), "ShowPayment", '顯示付款'), "AddPayment", '創建付款'), "EditPayment", '編輯付款'), "EmailSale", '通過電子郵件發送銷售'), "DeleteSale", '刪除銷售'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", '由...支付'), "Paymentchoice", '付款方式'), "Note", '注意'), "PaymentComplete", '付款完成！'), "PurchasesManagement", '採購管理'), "Ordered", '已訂購'), "DeletePurchase", '刪除購買'), "EmailPurchase", '通過電子郵件發送購買'), "EditPurchase", '編輯購買'), "PurchaseDetail", '採購明細'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", '創建購買'), "EmailSupplier", '供應商電子郵件'), "PurchaseInvoice", '購買付款'), "PurchasesInvoicesData", '購買付款數據'), "SalesInvoice", '銷售付款'), "SalesInvoicesData", '銷售付款數據'), "UserManagement", '用戶管理'), "Firstname", '名字'), "lastname", '姓'), "username", '用戶名'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", '密碼'), "Newpassword", '新密碼'), "ChangeAvatar", '更改頭像'), "LeaveBlank", '如果尚未更改，請將該字段留空'), "type", '類型'), "UserPermissions", '用戶權限'), "RoleName", '角色'), "RoleDescription", '角色描述'), "AddPermissions", '創建權限'), "View", '視圖'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", '刪除'), "NewAdjustement", '新調整'), "EditAdjustement", '編輯調整'), "CannotSubstraction", '您不能減去有庫存0的產品'), "Addition", '加成'), "Subtraction", '減法'), "profil", '概況'), "logout", '登出'), "PurchaseAlreadyPaid", '您無法修改，因為此購買已付款'), "SaleAlreadyPaid", '您無法修改，因為此銷售已經付款'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", '您無法修改，因為此退貨已經支付'), "QuoteAlready", '此報價已產生銷售'), "AddProduct", '創建產品'), "QuotationComplete", '報價完成'), "SiteConfiguration", '網站配置'), "Language", '語言'), "DefaultCurrency", '預設貨幣'), "LoginCaptcha", '登錄驗證碼'), "DefaultEmail", '默認電子郵件'), "SiteName", '網站名稱'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeLogo", '變更標誌'), "SMTPConfiguration", 'SMTP配置'), "HOST", '主辦'), "PORT", '港口'), "encryption", '加密'), "SMTPIncorrect", 'SMTP配置不正確'), "PaymentsReturns", '付款退貨'), "ReturnsInvoices", '退回發票'), "ReturnsInvoicesData", '退回發票數據'), "ShowAll", '顯示所有用戶的所有記錄'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", '折扣'), "OrderTax", '訂單稅'), "Shipping", '運輸'), "CompanyName", '公司名'), "CompanyPhone", '公司電話'), "CompanyAdress", '公司地址'), "Code", '碼'), "image", '圖片'), "Printbarcode", '打印條形碼'), "ReturnsCustomers", '回頭客'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", '退貨供應商'), "FactureReturnCustomers", '退貨客戶發票'), "FactureReturnSuppliers", '退貨供應商發票'), "NodataAvailable", '沒有可用數據'), "ProductImage", '產品圖片'), "Barcode", '條碼'), "pointofsales", '銷售點'), "CustomUpload", '自定義上傳'), "pointofsaleManagement", '銷售點管理'), "Adjustment", '調整'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", '更新資料'), "Reset", '重啟'), "print", '打印'), "SearchByEmail", '通過電子郵件搜索'), "ChooseProduct", '選擇產品'), "Qty", '數量'), "Items", '物品'), "AmountHT", '量'), "AmountTTC", '合計金額'), "PleaseSelectSupplier", '請選擇供應商'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", '請選擇狀態'), "PayeBy", '由...支付'), "ChooseWarehouse", '選擇倉庫'), "payNow", '現在付款'), "ListofCategory", '類別清單'), "Description", '描述'), "submit", '提交'), "ProblemCreatingThisInvoice", '創建此發票時出現問題。 請再試一次'), "ProblemPayment", '付款有問題。 請再試一次。'), "IncomeExpenses", '收入與支出'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", '每日銷售與購買'), "ProductsExpired", '產品過期'), "ListofBrand", '列出品牌'), "CreateAdjustment", '創建調整'), "Afewwords", '幾句話 ...'), "UserImage", '用戶圖片'), "UpdateProduct", '更新產品'), "Brand", '牌'), "BarcodeSymbology", '條碼符號'), "ProductCost", '產品成本'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductPrice", '產品價格'), "UnitProduct", '單位產品'), "TaxMethod", '稅法'), "MultipleImage", '多張圖片'), "ProductHasMultiVariants", '產品具有多種變體'), "ProductHasPromotion", '產品促銷'), "PromotionStart", '促銷開始'), "PromotionEnd", '促銷結束'), "PromotionPrice", '促銷價'), "Price", '價錢'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Cost", '成本'), "Unit", '單元'), "ProductVariant", '產品變體'), "Variant", '變體'), "UnitPrice", '單價'), "CreateReturnCustomer", '創建退貨客戶'), "EditReturnCustomer", '編輯退貨客戶'), "CreateReturnSupplier", '創建退貨供應商'), "Documentation", '文獻資料'), "EditReturnSupplier", '編輯退貨供應商'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FromWarehouse", '從倉庫'), "ToWarehouse", '到倉庫'), "EditTransfer", '編輯轉移'), "TransferDetail", '轉賬明細'), "Pending", '待定'), "Received", '已收到'), "Ordered", '已訂購'), "PermissionsManager", '權限管理'), "BrandManager", '牌'), "BrandImage", '品牌形象'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BrandName", '品牌'), "BrandDescription", '品牌描述'), "BaseUnit", '基本單位'), "ManagerUnits", '單位管理'), "OperationValue", '運營價值'), "Operator", '操作員'), "Top5Products", '前五名產品'), "Last5Sales", '最近五次銷售'), "ListAdjustments", '清單調整'), "ListTransfers", '清單轉移'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CreateTransfer", '創建轉移'), "OrdersManager", '訂單管理'), "ListQuotations", '清單報價'), "ListPurchases", '列出購買'), "ListSales", '清單銷售'), "ListReturns", '清單退貨'), "PeopleManager", '人事管理'), "Delete", {
  Title: '你確定嗎？',
  Text: '您將無法還原它！',
  confirmButtonText: '是的，刪除它！',
  cancelButtonText: '取消',
  Deleted: '已刪除！',
  Failed: '失敗了！',
  Therewassomethingwronge: '出事了',
  CustomerDeleted: '該客戶端已被刪除。',
  SupplierDeleted: '該供應商已被刪除。',
  QuoteDeleted: '此報價已被刪除。',
  SaleDeleted: '此銷售已被刪除。',
  PaymentDeleted: '此付款已被刪除。',
  PurchaseDeleted: '此購買已被刪除。',
  ReturnDeleted: '此退貨已被刪除。',
  ProductDeleted: '該產品已被刪除',
  ClientError: '該客戶端已經與其他操作鏈接',
  ProviderError: '該供應商已與其他運營部門鏈接',
  UserDeleted: '該用戶已被刪除。',
  UnitDeleted: '該單位已被刪除。',
  RoleDeleted: '該角色已被刪除。',
  TaxeDeleted: '該稅項已被刪除。',
  SubCatDeleted: '該子類別已被刪除。',
  CatDeleted: '此類別已被刪除。',
  WarehouseDeleted: '該倉庫已被刪除。',
  AlreadyLinked: '該產品已經與其他操作鏈接',
  AdjustDeleted: '此調整已被刪除。',
  TitleCurrency: '該貨幣已被刪除。',
  TitleTransfer: '轉移已成功刪除',
  BackupDeleted: '備份已成功刪除',
  TitleBrand: '該品牌已被刪除'
}), "Update", {
  TitleProfile: '您的個人資料已成功更新',
  TitleAdjust: '調整已成功更新',
  TitleRole: '角色更新成功',
  TitleUnit: '單位更新成功',
  TitleUser: '用戶已成功更新',
  TitleCustomer: '客戶更新成功',
  TitleQuote: '報價已成功更新',
  TitleSale: '銷售已成功更新',
  TitlePayment: '付款已成功更新',
  TitlePurchase: '購買已成功更新',
  TitleReturn: '返回成功更新',
  TitleProduct: '產品更新成功',
  TitleSupplier: '供應商更新成功',
  TitleTaxe: '稅務更新成功',
  TitleCat: '分類成功更新',
  TitleWarhouse: '倉庫已成功更新',
  TitleSetting: '設置已成功更新',
  TitleCurrency: '貨幣更新成功',
  TitleTransfer: '轉移成功更新',
  TitleBrand: '該品牌已更新'
}), "Create", {
  TitleBrand: '該品牌已創建',
  TitleRole: '角色創建成功',
  TitleUnit: '單位創建成功',
  TitleUser: '用戶創建成功',
  TitleCustomer: '客戶創建成功',
  TitleQuote: '報價創建成功',
  TitleSale: '銷售成功創建',
  TitlePayment: '付款成功創建',
  TitlePurchase: '購買成功創建',
  TitleReturn: '返回創建成功',
  TitleProduct: '產品創建成功',
  TitleSupplier: '供應商創建成功',
  TitleTaxe: '稅收創建成功',
  TitleCat: '分類成功創建',
  TitleWarhouse: '成功創建倉庫',
  TitleAdjust: '調整已成功創建',
  TitleCurrency: '貨幣創建成功',
  TitleTransfer: '轉移成功創建'
}), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: '電子郵件發送成功'
}), "return", {
  TitleSale: '此銷售已經與退貨相關！'
}), "ReturnManagement", '退貨管理'), "ReturnDetail", '退貨明細'), "EditReturn", '編輯退貨'), "AddReturn", '創建退貨'), "EmailReturn", '通過電子郵件發送退貨'), "DeleteReturn", '刪除退貨'), "Retoursurcharge", '回程附加費'), "Laivrison", '交貨'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectSale", '選擇銷售'), "ZeroPardefault", '您可以刪除該項目或將未退回的數量設置為零'), "Return", '返回'), "Purchase", '採購'), "TotalSales", '總銷售額'), "TotalPurchases", '總購買'), "TotalReturns", '總回報'), "PaiementsNet", '淨付款'), "PaiementsSent", '已付款'), "PaiementsReceived", '付款已收到'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Recieved", '已收到'), "Sent", '已發送'), "ProductQuantityAlerts", '產品數量警報'), "ProductCode", '碼'), "ProductName", '產品'), "AlertQuantity", '警報數量'), "WarehouseStockChart", '倉庫庫存圖'), "TotalProducts", '產品總數'), "TotalQuantity", '總數（量'), "TopCustomers", '前五名客戶'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalAmount", '總金額'), "TotalPaid", '總支付'), "CustomerSalesReport", '客戶銷售報告'), "CustomerPaiementsReport", '客戶付款報告'), "CustomerQuotationsReport", '客戶報價報告'), "Payments", '付款方式'), "TopSuppliers", '前五名供應商'), "SupplierPurchasesReport", '供應商採購報告'), "SupplierPaiementsReport", '供應商付款報告'), "Name", '名稱'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Code", '碼'), "ManagementWarehouse", '倉庫管理'), "ZipCode", '郵政編碼'), "managementCategories", '分類管理'), "Codecategorie", '代碼類別'), "Namecategorie", '名稱類別'), "Parentcategorie", '父類別'), "managementTax", '稅務管理'), "TaxName", '稅名'), "TaxRate", '稅率'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", '採購單位'), "managementUnitSales", '銷售單位'), "ShortName", '簡稱'), "PleaseSelectThesebeforeaddinganyproduct", '請在添加任何產品之前選擇這些'), "StockAdjustement", '庫存調整'), "PleaseSelectWarehouse", '選擇任何產品之前，請先選擇倉庫'), "StockTransfer", '庫存轉移'), "SelectPeriod", '選擇時期'), "ThisYear", '今年'), "ThisToday", '今天'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ThisMonth", '這個月'), "ThisWeek", '本星期'), "AdjustmentDetail", '調整細節'), "ActivateUser", '該用戶已被激活'), "DisActivateUser", '此用戶已被停用'), "NotFound", '找不到網頁。'), "oops", '錯誤！ 找不到網頁。'), "couldNotFind", '我們找不到您想要的頁面。與此同時，您可能'), "ReturnDashboard", '返回儀表板'), "hrm", '人力資源管理'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Employees", '僱員'), "Attendance", '出勤率'), "Leave_request", '離開請求'), "Leave_type", '休假類型'), "Company", '公司'), "Departments", '部門'), "Designations", '名稱'), "Office_Shift", '辦公室班次'), "Holidays", '節假日'), "Enter_Company_Name", '輸入公司名稱'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_email_address", '輸入電郵地址'), "Enter_Company_Phone", '輸入公司電話'), "Enter_Company_Country", '輸入公司國家'), "Created_in_successfully", '已成功創建'), "Updated_in_successfully", '已成功更新'), "Deleted_in_successfully", '刪除成功'), "department", '部'), "Enter_Department_Name", '輸入部門名稱'), "Choose_Company", '選擇公司'), "Department_Head", '部门负责人'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", '選擇部門負責人'), "Enter_Shift_name", '輸入班次名稱'), "Monday_In", 'Monday In'), "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", '假期'), "Enter_title", '輸入標題'), "title", '標題'), "start_date", '開始日期'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", '輸入開始日期'), "Finish_Date", '结束时间'), "Enter_Finish_date", '请输入结束日期'), "Please_provide_any_details", '請提供任何詳細信息'), "Attendances", '出勤率'), "Enter_Attendance_date", '輸入出席日期'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", '選擇員工'), "Employee", '僱員'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Work_Duration", '工作時間'), "remaining_leaves_are_insufficient", '剩余的叶子不足'), "Leave_Type", '休假類型'), "Days", '天數'), "Department", '部'), "Choose_leave_type", '選擇休假類型'), "Choose_status", '地位'), "Leave_Reason", '離職原因'), "Enter_Reason_Leave", '輸入原因請假'), "Add_Employee", '添加員工'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FirstName", '名'), "Enter_FirstName", '輸入名字'), "LastName", '姓氏'), "Enter_LastName", '輸入姓氏'), "Gender", '性別'), "Choose_Gender", '選擇性別'), "Enter_Birth_date", '輸入出生日期'), "Birth_date", '出生日期'), "Enter_Country", '进入国家/地区'), "Enter_Phone_Number", '輸入電話號碼'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "joining_date", '加盟日期'), "Enter_joining_date", '输入入会日期'), "Choose_Designation", '选择指定'), "Designation", '稱號'), "Office_Shift", '辦公室班次'), "Choose_Office_Shift", '选择办公室轮班'), "Enter_Leaving_Date", '输入出发日期'), "Leaving_Date", '離開日期'), "Annual_Leave", '年假'), "Enter_Annual_Leave", '輸入年假'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Remaining_leave", '剩余休假'), "Employee_Details", '員工詳情'), "Basic_Information", '基本信息'), "Family_status", '家庭狀況'), "Choose_Family_status", '選擇家庭狀態'), "Employment_type", '僱傭類型'), "Select_Employment_type", '選擇就業類型'), "Enter_City", '進入城市'), "Province", '省份'), "Enter_Province", '輸入省份'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Address", '輸入地址'), "Enter_Zip_code", '輸入郵政編碼'), "Zip_code", '郵政編碼'), "Hourly_rate", '每小時費率'), "Enter_Hourly_rate", '輸入每小時費率'), "Basic_salary", '基礎工資'), "Enter_Basic_salary", '輸入基本工資'), "Social_Media", '社交媒體'), "Skype", 'Skype'), "Enter_Skype", '進入 Skype'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), "Enter_Facebook", '進入 Facebook'), "WhatsApp", 'WhatsApp'), "Enter_WhatsApp", '進入 WhatsApp'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", '進入 LinkedIn'), "Twitter", 'Twitter'), "Enter_Twitter", '進入 Twitter'), "Experiences", '經驗'), "bank_account", '銀行戶口'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Company_Name", '公司名'), "Location", '位置'), "Enter_location", '输入地点'), "Enter_Description", '輸入描述'), "Bank_Name", '銀行名'), "Enter_Bank_Name", '輸入銀行名稱'), "Bank_Branch", '銀行支行'), "Enter_Bank_Branch", '進入銀行分行'), "Bank_Number", '銀行號碼'), "Enter_Bank_Number", '輸入銀行號碼'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", '指定倉庫'), "Top_customers", '頂級客戶'), "Attachment", '附件'), "view_employee", '查看員工'), "edit_employee", '編輯員工'), "delete_employee", '刪除員工'), "Created_by", '添加者'), "Add_product_IMEI_Serial_number", '添加產品 IMEI/序列號'), "Product_Has_Imei_Serial_number", '添加產品 IMEI/序列號'), "IMEI_SN", 'IMEI/SN'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Shipments", '出貨量'), "delivered_to", '送到了（送去了'), "shipment_ref", '裝運參考'), "sale_ref", '銷售參考'), "Edit_Shipping", '編輯運輸'), "Packed", '包裝好的'), "Shipped", '已發貨'), "Delivered", '發表'), "Cancelled", '取消'), "Shipping_status", '發貨狀態'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users_Report", '用戶報告'), "stock_report", '庫存報告'), "TotalPurchases", '總購買量'), "Total_quotations", '报价总额'), "Total_return_sales", '退貨總銷售額'), "Total_return_purchases", '總退貨購買'), "Total_transfers", '總轉帳'), "Total_adjustments", '總調整'), "User_report", '用戶報告'), "Current_stock", '當前庫存'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_name", '產品名稱'), "Total_Customers_Due", '總債務'), "Total_Suppliers_Due", '總債務'), "Some_warehouses", '一些倉庫'), "All_Warehouses", '所有倉庫'), "Product_Cost", '產品成本'), "sms_settings", '短信設置'), "pos_settings", 'POS 設置'), "payment_gateway", '支付網關'), "mail_settings", '郵件設置'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", '默認短信網關'), "module_settings", '模塊設置'), "Module_enabled_success", '模塊啟用成功'), "Module_Disabled_success", '模塊禁用成功'), "update_settings", '更新設置'), "Please_Upload_the_Correct_Module", '請上傳正確的模塊'), "Uploaded_Success", '上傳成功'), "Customer_details", '客戶詳情'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Customer", '編輯客戶'), "Delete_Customer", '刪除客戶'), "Pay_Due", '支付所有应付款'), "Paying_amount_is_greater_than_Total_Due", '支付金額大於到期總額'), "Customer_Invoice", '客戶發票'), "This_Product_Not_For_Selling", '本產品不賣'), "Welcome_to_your_Dashboard", '歡迎來到您的儀表板'), "Total_Payable", '應付總額'), "Choose_Sale_Ref", '選擇銷售參考'), "Please_Select_Sale", '請選擇銷售'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sale_Ref", '銷售參考'), "list_product_returns", '列出產品退貨'), "Qty_return", '數量退貨'), "Choose_Purchase_Ref", '選擇購買參考'), "Purchase_Ref", '購買參考'), "please_select_purchase", '请选择采购'), "qty_return_is_greater_than_qty_purchased", '退貨數量大於購買數量'), "qty_return_is_greater_than_qty_sold", '退貨數量大於售出數量'), "Quantity_sold", '售出數量'), "qty_purchased", '購買數量'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sender_Name", '發件者姓名'), "The_module_must_be_uploaded_as_zip_file", '模塊必須上傳為 zip 文件'), "Upload_Module", '上傳模塊'), "All_Modules_Installed", '已安裝的所有模塊'), "Current_Version", '當前版本'), "You_already_have_the_latest_version", '您已經擁有最新版本'), "Update_Available", '可用更新'), "Update_Log", '升级'), "Update_Now", '現在更新'), "View_Change_Log", '查看更改日誌'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "invoice_footer", '發票頁腳'), "Please_Wait_for_the_update", '注意：請等待更新完全完成。 不建議關閉瀏覽器或停止進程升級'), "Note_update", '注意：確保在運行升級之前備份您的當前版本和數據庫，如果出現錯誤，請恢復它'), "Time_Zone", '時區'), "Payment_note", '付款票据'), "sale_note", '銷售說明'), "Total_Sale_Due", '到期銷售總額'), "Total_Sell_Return_Due", '總銷售回報債務'), "pay_all_sell_due_at_a_time", '一次償還所有出售債務'), "pay_all_sell_return_due_at_a_time", '一次支付所有的賣出回報債務'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Gross_Profit", '毛利'), "pay_all_purchase_due_at_a_time", '一次支付所有購買債務'), "Delete_Provider", '刪除提供者'), "Edit_Provider", '編輯提供者'), "Provider_details", '提供者詳細信息'), "Total_Purchase_Due", '購買債務總額'), "Provider_Credit_Note", '贷方通知单'), "Customer_Credit_Note", '贷方通知单'), "Sell_Return", '賣出回報'), "Purchase_Return", '購買退貨'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax_Number", '税务号码'), "Please_add_return_quantity", '請添加退貨數量'), "Return_exist_for_the_Transaction", '交易存在退貨'), "qty_return_is_greater_than_Quantity_Remaining", '數量回報大於剩餘數量'), "products_refunded_alert", '任何數量設置為 0 的產品將不予退款'), "pay_all_purchase_return_due_at_a_time", '一次支付所有到期的購買退貨'), "Total_Purchase_Return_Due", '總採購退貨到期'), "Purchase_return_due", '購買回報債務'), "Sell_return_due", '出售回報債務'), "product_report", '產品報告'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_sales_report", '產品銷售報告'), "Product_purchases_report", '產品採購報告'), "Qty_sold", '售出數量'), "Qty_purchased", '購買數量'), "Filter_by_warehouse", '按倉庫篩選'), "Enable_Print_Invoice", '自動打印發票'), "Show_Warehouse", '查看倉庫'), "credit_card_info", '信用卡資訊'), "Saved_Credit_Card_Info", '已儲存的信用卡資訊'), "Credit_card_changed_successfully", '信用卡變更成功'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "notification_template", '通知模板'), "email_notification", '電子郵件通知'), "sms_notification", '簡訊通知'), "Change_product_details", '更改產品詳情'), "edit_tax_and_discount_and_shipping", '編輯稅金、折扣、運費'), "Create_Quotation_with_Stock", '建立擁有庫存的報價單'), "Variant_Name", '變體名稱'), "Variant_cost", '變體成本'), "Variant_price", '變體價格'), "Variant_code", '變體代碼'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", '請等待產品載入'), "Choose_SMS_Gateway", '選擇簡訊網關'), "Notification_Client", '客戶通知'), "Available_Tags", '可用標籤'), "Email_Subject", '電子郵件主旨'), "Email_body", '電子郵件內容'), "Notification_Supplier", '供應商通知'), "sms_body", '簡訊內容'), "sms_templates", 'SMS Templates'), "email_templates", 'Email Templates'));

/***/ }),

/***/ "./resources/src/translations/locales/tur.js":
/*!***************************************************!*\
  !*** ./resources/src/translations/locales/tur.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Turc

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Fiş',
  Pos_Settings: 'Satış noktası Ayarları',
  Note_to_customer: 'Müşteriye Notu',
  Show_Note_to_customer: 'Müşteriye Notu Göster',
  Show_barcode: 'Barkodu göster',
  Show_Tax_and_Discount: 'Vergi ve İndirim ve Nakliyeyi Göster',
  Show_Customer: 'Müşteriyi Göster',
  Show_Email: 'E-postayı Göster',
  Show_Phone: 'Telefonu Göster',
  Show_Address: 'Adresi Göster',
  DefaultLanguage: 'Varsayılan dil',
  footer: 'altbilgi',
  Received_Amount: 'Alınan miktar',
  Paying_Amount: 'Ödeme Tutarı',
  Change: 'Değişiklik',
  Paying_amount_is_greater_than_Received_amount: 'Ödeme tutarı alınan tutardan fazla',
  Paying_amount_is_greater_than_Grand_Total: 'Ödeme tutarı Genel Toplam\'dan büyük',
  code_must_be_not_exist_already: 'kod zaten mevcut olmamalı',
  You_will_find_your_backup_on: 'Yedeklemenizi şurada bulacaksınız:',
  and_save_it_to_your_pc: 've bilgisayarınıza kaydedin',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Barkodunuzu tarayın ve aşağıdan doğru sembolojiyi seçin',
  Scan_Search_Product_by_Code_Name: 'Ürünü Kod Adına Göre Tara/Ara',
  Paper_size: 'Kağıt boyutu',
  Clear_Cache: 'Önbelleği Temizle',
  Cache_cleared_successfully: 'Önbellek başarıyla temizlendi',
  Failed_to_clear_cache: 'Önbellek temizlenemedi',
  Scan_Barcode: 'Barkod okuyucu',
  Please_use_short_name_of_unit: 'Lütfen birimin kısa adını kullanın',
  DefaultCustomer: 'Varsayılan Müşteri',
  DefaultWarehouse: 'Varsayılan Depo',
  Payment_Gateway: 'Ödeme Sağlayıcı',
  SMS_Configuration: 'SMS Yapılandırması',
  Gateway: 'Ödeme Sağlayıcı',
  Choose_Gateway: 'Ödeme Ağ Geçidini Seçin',
  Send_SMS: 'Mesaj başarıyla gönderildi',
  sms_config_invalid: 'yanlış sms yapılandırması geçersiz',
  Remove_Stripe_Key_Secret: 'Stripe API anahtarlarını silin',
  credit_card_account_not_available: 'Kredi kartı hesabı mevcut değil',
  Credit_Card_Info: 'Kredi Kartı Bilgileri',
  developed_by: 'Tarafından geliştirilmiş',
  Unit_already_linked_with_sub_unit: 'Birim zaten alt birime bağlı',
  Total_Items_Quantity: 'Toplam Öğeler ve Miktar',
  Value_by_Cost_and_Price: 'Maliyet ve Fiyata Göre Değer',
  Search_this_table: 'Bu tabloda ara',
  import_products: 'Ürünleri içe aktar',
  Field_optional: 'İsteğe bağlı alan',
  Download_exemple: 'Örneği indirin',
  field_must_be_in_csv_format: 'Alan, csv biçiminde olmalıdır',
  Successfully_Imported: 'Başarıyla İçe Aktarıldı',
  file_size_must_be_less_than_1_mega: 'Dosya boyutu 1 mega\'dan küçük olmalıdır',
  Please_follow_the_import_instructions: 'Lütfen içe aktarma talimatlarını izleyin',
  must_be_exist: 'birim zaten oluşturulmuş olmalıdır',
  Import_Customers: 'Müşterileri İçe Aktar',
  Import_Suppliers: 'İthalat Tedarikçileri',
  Recent_Sales: 'Son Satışlar',
  Create_Transfer: 'Transfer Oluştur',
  order_products: 'sipariş öğeleri',
  Search_Product_by_Code_Name: 'Koda veya Ada Göre Ürün Ara',
  Reports_payments_Purchase_Return: 'Raporlar Satın Alma İade Ödemeleri',
  Reports_payments_Sale_Return: 'Raporlar Satış İadesi Ödemeleri',
  payments_Sales_Return: 'ödemeler satış iadesi',
  payments_Purchases_Return: 'ödemeler satın alma iadesi',
  CreateSaleReturn: 'Satış İadesi Oluştur',
  EditSaleReturn: 'Satış İadesini Düzenle',
  SalesReturn: 'Satış İadesi',
  CreatePurchaseReturn: 'Satın Alma İadesi Oluştur',
  EditPurchaseReturn: 'Satın Alma İadesini Düzenle',
  PurchasesReturn: 'Satın Alma İadesi',
  Due: 'vadesi dolmuş',
  Profit: 'Kar',
  Revenue: 'gelir',
  Sales_today: 'Bugün satış',
  People: 'İnsanlar',
  Successfully_Created: 'Başarıyla Oluşturuldu',
  Successfully_Updated: 'Başarıyla güncellendi',
  Success: 'Başarı',
  Failed: 'Başarısız oldu',
  Warning: 'Uyarı',
  Please_fill_the_form_correctly: 'Lütfen formu doğru doldurunuz',
  Field_is_required: 'Alan gereklidir',
  Error: 'Hata!',
  you_are_not_authorized: 'Afedersiniz! yetkili değilsin.',
  Go_back_to_home: 'Ana sayfaya geri dön',
  page_not_exist: 'Afedersiniz! Aradığınız sayfa mevcut değil.',
  Choose_Status: 'Durum Seçin',
  Choose_Method: 'Yöntem Seçin',
  Choose_Symbology: 'Semboloji seçin',
  Choose_Category: 'Kategori Seçin',
  Choose_Customer: 'Müşteri Seçin',
  Choose_Supplier: 'Tedarikçi Seçin',
  Choose_Unit_Purchase: 'Satın Alma Birimini Seçin',
  Choose_Sub_Category: 'Alt Kategori Seçin',
  Choose_Brand: 'Marka Seçin',
  Choose_Warehouse: 'Depo Seçin',
  Choose_Unit_Sale: 'Satış Birimini Seçin',
  Enter_Product_Cost: 'Ürün Maliyetini Girin',
  Enter_Stock_alert: 'Stok uyarısını girin',
  Choose_Unit_Product: 'Ürün Birimini Seçin',
  Enter_Product_Price: 'Ürün Fiyatını Girin',
  Enter_Name_Product: 'Ürün Adını Girin',
  Enter_Role_Name: 'Rol Adını Girin',
  Enter_Role_Description: 'Rol Açıklamasını Girin',
  Enter_name_category: 'Kategori adını girin',
  Enter_Code_category: 'Kategori kodunu girin',
  Enter_Name_Brand: 'İsim Markasını Girin',
  Enter_Description_Brand: 'Açıklama Markasını Girin',
  Enter_Code_Currency: 'Kod Para Birimi Girin',
  Enter_name_Currency: 'Adı girin Para birimi',
  Enter_Symbol_Currency: 'Sembol Para Birimi Girin',
  Enter_Name_Unit: 'Birim Adını Girin',
  Enter_ShortName_Unit: 'Kısa ad Birimi girin',
  Choose_Base_Unit: 'Baz Ünitesini Seçin',
  Choose_Operator: 'Operatör Seçin',
  Enter_Operation_Value: 'İşlem Değerini Girin',
  Enter_Name_Warehouse: 'Depo Adını Girin',
  Enter_Phone_Warehouse: 'Depo Telefonunu Girin',
  Enter_Country_Warehouse: 'Depo Ülkesini Girin',
  Enter_City_Warehouse: 'Depo Şehrini Girin',
  Enter_Email_Warehouse: 'Depo E-postasını Girin',
  Enter_ZipCode_Warehouse: 'Depo Posta Kodunu Girin',
  Choose_Currency: 'Para Birimini Seç',
  Thank_you_for_your_business: 'İşiniz için teşekkür ederim!',
  Cancel: 'İptal etmek',
  New_Customer: 'Yeni müşteri',
  Incorrect_Login: 'Yanlış giriş',
  Successfully_Logged_In: 'Başarıyla Giriş Yapıldı',
  This_user_not_active: 'Bu kullanıcı aktif değil',
  SignIn: 'Oturum aç',
  Create_an_account: 'Bir hesap oluşturun',
  Forgot_Password: 'Parolanızı mı unuttunuz ?',
  Email_Address: 'e-posta adresi',
  SignUp: 'Kaydol',
  Already_have_an_account: 'Zaten hesabınız var mı ?',
  Reset_Password: 'Şifreyi yenile',
  Failed_to_authenticate_on_SMTP_server: 'SMTP sunucusunda kimlik doğrulanamadı',
  We_cant_find_a_user_with_that_email_addres: 'Bu e-posta adresine sahip bir kullanıcı bulamıyoruz',
  We_have_emailed_your_password_reset_link: 'şifre sıfırlama bağlantınızı e-postayla gönderdim',
  Please_fill_the_Email_Adress: 'Lütfen E-posta Adresini doldurun',
  Confirm_password: 'Şifreyi Onayla',
  Your_Password_has_been_changed: 'Şifreniz değiştirildi',
  The_password_confirmation_does_not_match: 'Parola onayı eşleşmiyor',
  This_password_reset_token_is_invalid: 'Bu şifre sıfırlama jetonu geçersiz',
  Warehouse_report: 'Depo raporu',
  All_Warehouses: 'Tüm Depolar',
  Expense_List: 'Gider Listesi',
  Expenses: 'Masraflar',
  This_Week_Sales_Purchases: 'Bu Hafta Satışlar ve Satın Alımlar',
  Top_Selling_Products: 'En Çok Satan Ürünler',
  View_all: 'Hepsini gör',
  Payment_Sent_Received: 'Gönderilen ve Alınan Ödeme',
  Filter: 'Filtrele',
  Invoice_POS: 'Fatura POS',
  Invoice: 'Fatura',
  Customer_Info: 'Müşteri Bilgisi',
  Company_Info: 'Şirket bilgileri',
  Invoice_Info: 'Fatura Bilgileri',
  Order_Summary: 'sipariş özeti',
  Quote_Info: 'Teklif Bilgisi',
  Del: 'Sil',
  SuppliersPaiementsReport: 'Tedarikçi Ödemeleri Raporu',
  Purchase_Info: 'Satın Alma Bilgileri',
  Supplier_Info: 'Tedarikçi Bilgileri',
  Return_Info: 'Dönüş bilgisi',
  Expense_Category: 'Gider Kategorisi',
  Create_Expense: 'Gider Yaratın',
  Details: 'DetDetaylarails',
  Discount_Method: 'İndirim Yöntemi',
  Net_Unit_Cost: 'Net Birim Maliyeti',
  Net_Unit_Price: 'Net Birim Fiyatı',
  Edit_Expense: 'Gider Düzenle',
  All_Brand: 'Tüm Marka',
  All_Category: 'Tüm Kategori',
  ListExpenses: 'Giderleri Listele',
  Create_Permission: 'İzin Oluştur',
  Edit_Permission: 'İzni Düzenle',
  Reports_payments_Sales: 'Rapor ödemeleri Satış',
  Reports_payments_Purchases: 'Rapor ödemeleri Satın alma işlemleri',
  Reports_payments_Return_Customers: 'Rapor ödemeleri İade Müşterileri',
  Reports_payments_Return_Suppliers: 'Rapor ödemeleri İade Tedarikçileri',
  Expense_Deleted: 'Bu Gider silindi',
  Expense_Updated: 'Bu Gider Güncellendi',
  Expense_Created: 'Bu Gider Oluşturuldu',
  DemoVersion: 'Bunu demo sürümünde yapamazsınız',
  OrderStatistics: 'Satış İstatistikleri',
  AlreadyAdd: 'Bu Ürün Zaten Eklendi !!',
  AddProductToList: 'Lütfen Ürünü Listeye Ekleyin !!',
  AddQuantity: 'Lütfen Detay Miktarı Ekleyin !!',
  InvalidData: 'Geçersiz veri !!',
  LowStock: 'miktar stokta bulunan miktarı aşıyor',
  WarehouseIdentical: 'İki depo aynı olamaz !!',
  VariantDuplicate: 'Bu Varyant Yineleniyor !!',
  Filesize: 'Dosya boyutu',
  GenerateBackup: 'Yedek Oluştur',
  BackupDatabase: 'Yedek veritabanı',
  Backup: 'Destek olmak',
  Paid: 'Ücretli',
  Unpaid: 'Ödenmemiş',
  Today: 'Bugün',
  Income: 'Gelir'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'Masraflar'), "Sale", 'Satış'), "Actif", 'Aktif'), "Inactif", 'Etkin değil'), "Customers", 'Müşteriler'), "Phone", 'Telefon'), "SearchByPhone", 'Telefonla Ara'), "Suppliers", 'Tedarikçiler'), "Quotations", 'Alıntılar'), "Sales", 'Satış'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'Satın alma'), "Returns", 'İadeler'), "Settings", 'Ayarlar'), "SystemSettings", 'Sistem ayarları'), "Users", 'Kullanıcılar'), "GroupPermissions", 'Grup İzinleri'), "Currencies", 'Para birimleri'), "Warehouses", 'Depolar'), "Units", 'Birimler'), "UnitsPrchases", 'Birimler Alımları'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Satış Birimleri'), "Reports", 'Raporlar'), "PaymentsReport", 'Ödemeler Raporu'), "PaymentsPurchases", 'Payments Satın Alımları'), "PaymentsSales", 'Ödemeler Satış'), "ProfitandLoss", 'Kar ve zarar'), "WarehouseStockChart", 'Wdepo Stok Tablosu'), "SalesReport", 'Satış raporu'), "PurchasesReport", 'Satın Alma Raporu'), "CustomersReport", 'Müşteriler Raporu'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Tedarikçiler Raporu'), "SupplierReport", 'Tedarikçi Raporu'), "DailySalesData", 'Günlük Satış Verileri'), "DailyPurchasesData", 'Günlük Satın Alma Verileri'), "Derni\xE8rescinqrecords", 'Son beş kayıt'), "Filters", 'Filtreler'), "date", 'tarih'), "Reference", 'Referans'), "Supplier", 'Tedarikçi'), "PaymentStatus", 'Ödeme Durumu'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", 'Müşteri'), "CustomerCode", 'Müşteri kodu'), "Status", 'Durum'), "SupplierCode", 'Tedarikçi Kodu'), "Categorie", 'Kategori'), "Categories", 'Kategoriler'), "StockTransfers", 'Stok Transferleri'), "StockManagement", 'Stok yönetimi'), "dashboard", 'Gösterge Paneli'), "Products", 'Ürün:% s'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'ürün listesi'), "ProductManagement", 'Ürün Yönetimi'), "ProductQuantityAlerts", 'Ürün Miktarı Uyarıları'), "CodeProduct", 'Kod Ürün'), "ProductTax", 'Ürün Vergisi'), "SubCategorie", 'Alt kategori'), "Name_product", 'Tanımlama'), "StockAlert", 'Stok Uyarısı'), "warehouse", 'depo'), "Tax", 'Vergi'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Alım fiyati'), "SellPrice", 'Satış fiyatı'), "Quantity", 'Miktar'), "UnitSale", 'Birim Satışı'), "UnitPurchase", 'Birim Satın Alma'), "ManagementCurrencies", 'Para Birimi Yönetimi'), "CurrencyCode", 'Para Birimi Kodu'), "CurrencyName", 'Para Birimi Adı'), "Symbol", 'Sembol'), "All", 'Herşey'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Ürünü Düzenle'), "SearchByCode", 'Koda göre ara'), "SearchByName", 'İsme Göre Ara'), "ProductDetails", 'Ürün Detayları'), "CustomerName", 'müşteri adı'), "CustomerManagement", 'Müşteri yönetimi'), "Add", 'Oluşturmak'), "add", 'Oluşturmak'), "Edit", 'Düzenle'), "Close", 'Kapat'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Lütfen seçin'), "Action", 'Aksiyon'), "Email", 'E-posta adresi'), "EditCustomer", 'Müşteriyi Düzenle'), "AddCustomer", 'Müşteri Yaratın'), "Country", 'Ülke'), "City", 'Kent'), "Adress", 'Adres'), "CustomerDetails", 'Müşteri detayları'), "CustomersList", 'Müşteri Listesi'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Tedarikçi Kodu'), "SupplierName", 'sağlayıcı adı'), "SuppliersManagement", 'Tedarikçi Yönetimi'), "SupplierDetails", 'Tedarikçi Detayları'), "QuotationsManagement", 'Teklif Yönetimi'), "SubTotal", 'ara toplam'), "MontantReste", 'Kalan miktar'), "complete", 'Tamamlandı'), "EnAttendant", 'Bekliyor'), "Recu", 'Alınan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", 'Kısmi'), "Retournee", 'Dönüş'), "DetailQuote", 'Detay Teklifi'), "EditQuote", 'Teklifi Düzenle'), "CreateSale", 'Satış Oluşturun'), "DownloadPdf", 'PDF İndir'), "QuoteEmail", 'Postayla Gönderilen Teklif'), "DeleteQuote", 'Teklifi Sil'), "AddQuote", 'Teklif Oluştur'), "SelectProduct", 'Ürünü seç'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Ürün (Kod - İsim)'), "Price", 'Fiyat'), "CurrentStock", 'Stok'), "Total", 'Toplam'), "Num", 'N°'), "Unitcost", 'Birim maliyet'), "to", '-e'), "Subject", 'Konu'), "Message", 'İleti'), "EmailCustomer", 'Müşteriye E-posta Gönder'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", 'Gönder'), "Quote", 'Teklif'), "Hello", 'Merhaba'), "AttachmentQuote", 'Lütfen Teklifiniz için eki bulun'), "AddProducts", 'Sipariş Listesine Ürün Ekleme'), "SelectWarehouse", 'Lütfen depo seçin'), "SelectCustomer", 'lütfen Müşteri Seçiniz'), "SalesManagement", 'Satış Yönetimi'), "Balance", 'Denge'), "QtyBack", 'Miktar Geri'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Toplam getiri'), "Amount", 'Miktar'), "SaleDetail", 'Satış Detayı'), "EditSale", 'İndirimi Düzenle'), "AddSale", 'Satış Oluşturun'), "ShowPayment", 'Ödemeleri Göster'), "AddPayment", 'Ödeme Oluştur'), "EditPayment", 'Ödemeyi Düzenle'), "EmailSale", 'E-postayla Satış Gönder'), "DeleteSale", 'Satışı Sil'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Ödeyen'), "Paymentchoice", 'Ödeme seçimi'), "Note", 'Not'), "PaymentComplete", 'Ödeme tamamlandı!'), "PurchasesManagement", 'Satın Alma Yönetimi'), "Ordered", 'Sipariş verildi'), "DeletePurchase", 'Satın Almayı Sil'), "EmailPurchase", 'Satın Almayı postayla gönder'), "EditPurchase", 'Satın Almayı Düzenle'), "PurchaseDetail", 'Satın Alma Detayı'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Satın Alma Oluştur'), "EmailSupplier", 'Tedarikçi E-postası'), "PurchaseInvoice", 'Satın alma ödemeleri'), "PurchasesInvoicesData", 'Ödeme verilerini satın alır'), "SalesInvoice", 'Satış ödemeleri'), "SalesInvoicesData", 'Satış ödemeleri verileri'), "UserManagement", 'kullanıcı yönetimi'), "Firstname", 'İsim'), "lastname", 'Soyadı'), "username", 'Kullanıcı adı'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", 'Parola'), "Newpassword", 'Yeni Şifre'), "ChangeAvatar", 'Avatarı değiştir'), "LeaveBlank", 'Değiştirmediyseniz lütfen bu alanı boş bırakın'), "type", 'tip'), "UserPermissions", 'Kullanıcı İzinleri'), "RoleName", 'Rol'), "RoleDescription", 'Rol Tanımı'), "AddPermissions", 'İzin Oluşturun'), "View", 'Görünüm'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", 'Sil'), "NewAdjustement", 'Yeni Düzenleme'), "EditAdjustement", 'Ayarı Düzenle'), "CannotSubstraction", 'Stokta 0 olan ürünleri çıkaramazsınız'), "Addition", 'İlave'), "Subtraction", 'Çıkarma'), "profil", 'profil'), "logout", 'çıkış Yap'), "PurchaseAlreadyPaid", 'bu Satın Alma zaten ödendiği için değişiklik yapamazsınız'), "SaleAlreadyPaid", 'bu Satış zaten ödendiği için değişiklik yapamazsınız'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnAlreadyPaid", 'bu İade zaten ödendiği için değiştiremezsiniz'), "QuoteAlready", 'Bu teklif zaten satış sağladı'), "AddProduct", 'Ürün oluştur'), "QuotationComplete", 'Bu Teklif Tamamlandı'), "SiteConfiguration", 'Site yapılandırması'), "Language", 'Dil'), "DefaultCurrency", 'Varsayılan Para Birimi'), "LoginCaptcha", 'Giriş Captcha'), "DefaultEmail", 'Varsayılan E-posta'), "SiteName", 'Site adı'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ChangeLogo", 'Logoyu Değiştir'), "SMTPConfiguration", 'SMTP Yapılandırması'), "HOST", 'ev sahibi'), "PORT", 'LİMAN'), "encryption", 'Şifreleme'), "SMTPIncorrect", 'SMTP Yapılandırması Yanlış'), "PaymentsReturns", 'Ödeme İadeleri'), "ReturnsInvoices", 'Faturaları döndürür'), "ReturnsInvoicesData", 'Fatura Verilerini döndürür'), "ShowAll", 'Tüm Kullanıcıların tüm kayıtlarını göster'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Discount", 'İndirim'), "OrderTax", 'Sipariş Vergisi'), "Shipping", 'Nakliye'), "CompanyName", 'Şirket Adı'), "CompanyPhone", 'Şirket Telefonu'), "CompanyAdress", 'şirket adresi'), "Code", 'Kod'), "image", 'görüntü'), "Printbarcode", 'Barkod yazdır'), "ReturnsCustomers", 'İade Müşterileri'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ReturnsSuppliers", 'İade Tedarikçileri'), "FactureReturnCustomers", 'Müşteri Faturasını İade Et'), "FactureReturnSuppliers", 'İade Tedarikçileri Faturası'), "NodataAvailable", 'Veri yok'), "ProductImage", 'Ürün resmi'), "Barcode", 'Barkod'), "pointofsales", 'satış noktaları'), "CustomUpload", 'Özel Yükleme'), "pointofsaleManagement", 'Satış Noktası Yönetimi'), "Adjustment", 'Ayarlama'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Updat", 'Güncelleme'), "Reset", 'Sıfırla'), "print", 'Yazdır'), "SearchByEmail", 'E-postayla Ara'), "ChooseProduct", 'Ürün Seçin'), "Qty", 'Adet'), "Items", 'Öğeler'), "AmountHT", 'Miktar'), "AmountTTC", 'Toplam Tutar'), "PleaseSelectSupplier", 'Lütfen Tedarikçi Seçiniz'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelectStatut", 'Lütfen Durum Seçiniz'), "PayeBy", 'Ödeyen'), "ChooseWarehouse", 'Depo Seçin'), "payNow", 'Şimdi öde'), "ListofCategory", 'Kategori Listesi'), "Description", 'Açıklama'), "submit", 'Sunmak'), "ProblemCreatingThisInvoice", 'Bu Fatura oluşturulurken bir sorunla karşılaşıldı. Lütfen tekrar deneyin'), "ProblemPayment", 'Ödeme ile ilgili bir sorun oluştu. Lütfen tekrar deneyin.'), "IncomeExpenses", 'Gelir ve Giderler'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "dailySalesPurchases", 'Günlük Satışlar ve Satın Alımlar'), "ProductsExpired", 'Ürünlerin Süresi Doldu'), "ListofBrand", 'Marka Listesi'), "CreateAdjustment", 'Düzenleme Oluştur'), "Afewwords", 'Bir kaç kelime ...'), "UserImage", 'Kullanıcı Resmi'), "UpdateProduct", 'Ürünü Güncelle'), "Brand", 'Marka'), "BarcodeSymbology", 'Barkod Sembolojisi '), "ProductCost", 'Ürün maliyeti'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductPrice", 'Ürün fiyatı'), "UnitProduct", 'Birim Ürün'), "TaxMethod", 'Vergi Yöntemi'), "MultipleImage", 'Çoklu Resim'), "ProductHasMultiVariants", 'Ürünün Çok Varyantı Var'), "ProductHasPromotion", 'Ürün Promosyonludur'), "PromotionStart", 'Promosyon Başlangıcı'), "PromotionEnd", 'Promosyon Sonu'), "PromotionPrice", 'Promosyon fiyatı'), "Price", 'Fiyat'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Cost", 'Maliyet'), "Unit", 'Birim'), "ProductVariant", 'Ürün Varyantı'), "Variant", 'Varyant'), "UnitPrice", 'Birim fiyat'), "CreateReturnCustomer", 'İade Müşterisi Oluşturun'), "EditReturnCustomer", 'İade Müşterisini Düzenle'), "CreateReturnSupplier", 'İade Tedarikçisi Oluştur'), "Documentation", 'Dokümantasyon'), "EditReturnSupplier", 'İade Tedarikçisini Düzenle'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FromWarehouse", 'Depodan'), "ToWarehouse", 'Depoya'), "EditTransfer", 'Transferi Düzenle'), "TransferDetail", 'Transfer ayrıntıları'), "Pending", 'Bekliyor'), "Received", 'Alınan'), "Ordered", 'Sipariş verildi'), "PermissionsManager", 'İzin Yönetimi'), "BrandManager", 'Marka'), "BrandImage", 'Marka imajı'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BrandName", 'Marka adı'), "BrandDescription", 'Marka Tanımı'), "BaseUnit", 'Ana ünite'), "ManagerUnits", 'Birim Yönetimi'), "OperationValue", 'Operasyon Değeri'), "Operator", 'Şebeke'), "Top5Products", 'En İyi Beş Ürün'), "Last5Sales", 'Son beş Satış'), "ListAdjustments", 'Ayarlamaları Listele'), "ListTransfers", 'Transferleri Listele'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "CreateTransfer", 'Transfer Oluştur'), "OrdersManager", 'Sipariş Yönetimi'), "ListQuotations", 'Alıntıları Listele'), "ListPurchases", 'Satın Alma İşlemlerini Listele'), "ListSales", 'Satışları Listele'), "ListReturns", 'İade Listesi'), "PeopleManager", 'İnsan yönetimi'), "Delete", {
  Title: 'Emin misiniz?',
  Text: 'Bunu geri alamayacaksın!',
  confirmButtonText: 'Evet, silin!',
  cancelButtonText: 'İptal etmek',
  Deleted: 'Silindi!',
  Failed: 'Başarısız oldu!',
  Therewassomethingwronge: 'Yanlış bir şeyler vardı',
  CustomerDeleted: 'bu Müşteri silindi.',
  SupplierDeleted: 'bu Tedarikçi silindi.',
  QuoteDeleted: 'bu Teklif silinmiştir.',
  SaleDeleted: 'bu Satış silindi.',
  PaymentDeleted: 'bu Ödeme silindi.',
  PurchaseDeleted: 'bu Satın Alma silindi.',
  ReturnDeleted: 'bu İade silindi.',
  ProductDeleted: 'bu Ürün silinmiştir.',
  ClientError: 'Bu Müşteri zaten başka bir Operasyona bağlı',
  ProviderError: 'Bu Tedarikçi zaten diğer Operasyonla bağlantılı',
  UserDeleted: 'Bu Kullanıcı silinmiştir.',
  UnitDeleted: 'Bu Birim silindi.',
  RoleDeleted: 'Bu Rol silindi.',
  TaxeDeleted: 'Bu Vergi silinmiştir.',
  SubCatDeleted: 'Bu Alt Kategori silinmiştir.',
  CatDeleted: 'Bu Kategori silindi.',
  WarehouseDeleted: 'Bu Depo silindi.',
  AlreadyLinked: 'bu ürün zaten diğer Operasyon ile bağlantılı',
  AdjustDeleted: 'Bu Ayar silindi.',
  TitleCurrency: 'Bu Para Birimi silindi. ',
  TitleTransfer: 'Transfer başarıyla kaldırıldı',
  BackupDeleted: 'Yedek başarıyla kaldırıldı',
  TitleBrand: 'Bu Marka silindi'
}), "Update", {
  TitleProfile: 'Profiliniz başarıyla güncellendi',
  TitleAdjust: 'Ayar başarıyla güncellendi',
  TitleRole: 'Rol başarıyla güncellendi',
  TitleUnit: 'Birim başarıyla güncellendi',
  TitleUser: 'Kullanıcı başarıyla güncellendi',
  TitleCustomer: 'Başarıyla Müşteri Güncellemesi',
  TitleQuote: 'Teklif başarıyla güncellendi',
  TitleSale: 'Satış başarıyla güncellendi',
  TitlePayment: 'Ödeme başarıyla güncellendi',
  TitlePurchase: 'Satın Alma Başarıyla Güncellendi',
  TitleReturn: 'İade Başarıyla güncellendi',
  TitleProduct: 'Ürün Güncellemesi başarıyla yapıldı',
  TitleSupplier: 'Tedarikçi başarıyla güncellendi',
  TitleTaxe: 'Vergi başarıyla güncellendi',
  TitleCat: 'Kategori başarıyla güncellendi',
  TitleWarhouse: 'Depo başarıyla güncellendi',
  TitleSetting: 'Ayarlar başarıyla güncellendi',
  TitleCurrency: 'Para Birimi Güncellemesi başarıyla yapıldı',
  TitleTransfer: 'Transfer başarıyla güncellendi',
  TitleBrand: 'Bu Marka Oluşturuldu'
}), "Create", {
  TitleBrand: 'Bu Marka Oluşturuldu',
  TitleRole: 'Başarıyla Oluşturulan Rol',
  TitleUnit: 'Birim Başarıyla Oluşturuldu',
  TitleUser: 'Kullanıcı başarıyla oluşturuldu',
  TitleCustomer: 'Müşteri başarıyla oluşturuldu',
  TitleQuote: 'Başarıyla Oluşturulan Teklif',
  TitleSale: 'Satış başarıyla oluşturuldu',
  TitlePayment: 'Ödeme başarıyla oluşturuldu',
  TitlePurchase: 'Başarıyla Oluşturulan Satın Alma',
  TitleReturn: 'İade Başarıyla Oluşturuldu',
  TitleProduct: 'Ürün Başarıyla Oluşturuldu',
  TitleSupplier: 'Tedarikçi Başarıyla Oluşturuldu',
  TitleTaxe: 'Başarıyla Oluşturulan Vergi',
  TitleCat: 'Başarıyla Oluşturulan Kategori',
  TitleWarhouse: 'Depo Başarıyla Oluşturuldu',
  TitleAdjust: 'Ayar başarıyla oluşturuldu',
  TitleCurrency: 'Para Birimi Başarıyla Oluşturuldu',
  TitleTransfer: 'Transfer başarıyla oluşturuldu'
}), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Send", {
  TitleEmail: 'E-posta başarıyla gönderildi'
}), "return", {
  TitleSale: 'bu satış zaten bir İade ile bağlantılı!'
}), "ReturnManagement", 'İade Yönetimi'), "ReturnDetail", 'Dönüş Detayı'), "EditReturn", 'İadeyi Düzenle'), "AddReturn", 'İade Oluştur'), "EmailReturn", 'E-postayla İade Gönder'), "DeleteReturn", 'İadeyi Sil'), "Retoursurcharge", 'İade Ek Ücreti'), "Laivrison", 'teslimat'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SelectSale", 'Satış Seçiniz'), "ZeroPardefault", 'Kalemi silebilir veya iade edilmezse iade edilen miktarı sıfıra ayarlayabilirsiniz.'), "Return", 'Dönüş'), "Purchase", 'Satın alma'), "TotalSales", 'Toplam satış'), "TotalPurchases", 'Toplam Satın Alma'), "TotalReturns", 'Toplam İade'), "PaiementsNet", 'Net Ödemeler'), "PaiementsSent", 'Gönderilen Ödemeler'), "PaiementsReceived", 'Ödemeler alındı'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Recieved", 'Alınan'), "Sent", 'Gönderildi'), "ProductQuantityAlerts", 'Ürün Miktarı Uyarıları'), "ProductCode", 'Kod'), "ProductName", 'Ürün'), "AlertQuantity", 'Uyarı Miktarı'), "WarehouseStockChart", 'Depo Stok Tablosu'), "TotalProducts", 'Toplam Ürünler'), "TotalQuantity", 'Toplam miktar'), "TopCustomers", 'İlk beş Müşteri'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalAmount", 'Toplam tutar'), "TotalPaid", 'Toplam Ödenen'), "CustomerSalesReport", 'Müşteri Satış Raporu'), "CustomerPaiementsReport", 'Müşteri Ödemeleri Raporu'), "CustomerQuotationsReport", 'Müşteri Teklifleri Raporu'), "Payments", 'Ödemeler'), "TopSuppliers", 'İlk beş Tedarikçi'), "SupplierPurchasesReport", 'Tedarikçi Satın Alma Raporu'), "SupplierPaiementsReport", 'Tedarikçi Ödemeleri Raporu'), "Name", 'İsim'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Code", 'Kod'), "ManagementWarehouse", 'Depo yönetimi'), "ZipCode", 'Posta kodu'), "managementCategories", 'Kategori yönetimi'), "Codecategorie", 'Kod kategorisi'), "Namecategorie", 'İsim kategorisi'), "Parentcategorie", 'Aile kategorisi'), "managementTax", 'Vergi yönetimi'), "TaxName", 'Vergi Adı'), "TaxRate", 'Vergi oranı'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "managementUnitPurchases", 'Satın Alma Birimi'), "managementUnitSales", 'Satış Birimi'), "ShortName", 'Kısa isim'), "PleaseSelectThesebeforeaddinganyproduct", 'Lütfen herhangi bir ürün eklemeden önce Bunları seçin'), "StockAdjustement", 'Stok Ayarı'), "PleaseSelectWarehouse", 'Lütfen herhangi bir ürün seçmeden önce depoyu seçin'), "StockTransfer", 'Stok Transferi'), "SelectPeriod", 'Dönem Seçin'), "ThisYear", 'Bu yıl'), "ThisToday", 'Bu Bugün'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ThisMonth", 'Bu ay'), "ThisWeek", 'Bu hafta'), "AdjustmentDetail", 'Ayar Detayı'), "ActivateUser", 'Bu Kullanıcı Etkinleştirildi'), "DisActivateUser", 'Bu Kullanıcı Devre Dışı Bırakıldı'), "NotFound", 'Sayfa bulunamadı.'), "oops", 'hata! Sayfa bulunamadı.'), "couldNotFind", 'Aradığınız sayfayı bulamadık.'), "ReturnDashboard", 'kontrol paneline dön'), "hrm", 'İKY'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Employees", 'Çalışanlar'), "Attendance", 'katılım'), "Leave_request", 'İstekten Ayrıl'), "Leave_type", 'Ayrılma Türü'), "Company", 'Şirket'), "Departments", 'Departmanlar'), "Designations", 'atama'), "Office_Shift", 'Ofis Vardiyası'), "Holidays", 'tatiller'), "Enter_Company_Name", 'Şirket adını girin'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_email_address", 'Email adresini gir'), "Enter_Company_Phone", 'Şirket telefonunu girin'), "Enter_Company_Country", 'Şirket ülkesini girin'), "Created_in_successfully", 'Başarıyla oluşturuldu'), "Updated_in_successfully", 'Başarıyla güncellendi'), "Deleted_in_successfully", 'Başarıyla silindi'), "department", 'departman'), "Enter_Department_Name", 'Departman adını girin'), "Choose_Company", 'Şirket Seçin'), "Department_Head", 'Daire Başkanı'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Choose_Department_Head", 'Bölüm Başkanını Seçin'), "Enter_Shift_name", 'Vardiya adını girin'), "Monday_In", 'Monday In'), "Monday_Out", 'Monday Out'), "Tuesday_In", 'Tuesday In'), "tuesday_out", 'tuesday Out'), "wednesday_in", 'Wednesday In'), "wednesday_out", 'Wednesday Out'), "thursday_in", 'Thursday In'), "thursday_out", 'Thursday Out'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "friday_in", 'Friday In'), "friday_out", 'Friday Out'), "saturday_in", 'Saturday In'), "saturday_out", 'Saturday Out'), "sunday_in", 'Sunday In'), "sunday_out", 'Sunday Out'), "Holiday", 'Tatil'), "Enter_title", 'Başlık girin'), "title", 'Başlık'), "start_date", 'Başlangıç ​​tarihi'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Start_date", 'Başlangıç tarihini girin'), "Finish_Date", 'Bitiş tarihi'), "Enter_Finish_date", 'Bitiş tarihini girin'), "Please_provide_any_details", 'Lütfen herhangi bir ayrıntı sağlayın'), "Attendances", 'katılımlar'), "Enter_Attendance_date", 'Katılım tarihini girin'), "Time_In", 'Time In'), "Time_Out", 'Time Out'), "Choose_Employee", 'Çalışan Seçin'), "Employee", 'Çalışan'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Work_Duration", 'Çalışma Süresi'), "remaining_leaves_are_insufficient", 'Kalan yapraklar yetersiz'), "Leave_Type", 'Ayrılma Türü'), "Days", 'günler'), "Department", 'departman'), "Choose_leave_type", 'seçinAyrılma Türü'), "Choose_status", 'Durum seçin'), "Leave_Reason", 'Nedeni Bırak'), "Enter_Reason_Leave", 'Ayrılma Sebebi Girin'), "Add_Employee", 'Çalışan Ekle'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "FirstName", 'İlk adı'), "Enter_FirstName", 'Adınızı Girin'), "LastName", 'Soy isim'), "Enter_LastName", 'Soy adını gir'), "Gender", 'Cinsiyet'), "Choose_Gender", 'Cinsiyet Seç'), "Enter_Birth_date", 'Doğum tarihini girin'), "Birth_date", 'Doğum tarihi'), "Enter_Country", 'Ülkeyi Girin'), "Enter_Phone_Number", 'Telefon Numarasını Girin'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "joining_date", 'katılma tarihi'), "Enter_joining_date", 'Katılma tarihini girin'), "Choose_Designation", 'Atama atama'), "Designation", 'atama'), "Office_Shift", 'Ofis Vardiyası'), "Choose_Office_Shift", 'Office Shift\'i seçin'), "Enter_Leaving_Date", 'Ayrılma Tarihini Girin'), "Leaving_Date", 'Ayrılma tarihi'), "Annual_Leave", 'yıllık izni'), "Enter_Annual_Leave", 'Yıllık İzin Girin'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Remaining_leave", 'kalan izin'), "Employee_Details", 'Çalışan Ayrıntıları'), "Basic_Information", 'Temel Bilgi'), "Family_status", 'Aile durumu'), "Choose_Family_status", 'Aile durumunu seçin'), "Employment_type", 'İstihdam Tipi'), "Select_Employment_type", 'İstihdam türünü seçin'), "Enter_City", 'Şehir Girin'), "Province", 'Vilayet'), "Enter_Province", 'İl Girin'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Enter_Address", 'Adresi girin'), "Enter_Zip_code", 'Posta kodu gir'), "Zip_code", 'Zip kodu'), "Hourly_rate", 'Saatlik oran'), "Enter_Hourly_rate", 'Saatlik ücreti girin'), "Basic_salary", 'Temel maaş'), "Enter_Basic_salary", 'Temel maaşı girin'), "Social_Media", 'Sosyal medya'), "Skype", 'Skype'), "Enter_Skype", 'girin Skype'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Facebook", 'Facebook'), "Enter_Facebook", 'girin Facebook'), "WhatsApp", 'WhatsApp'), "Enter_WhatsApp", 'girin WhatsApp'), "LinkedIn", 'LinkedIn'), "Enter_LinkedIn", 'girin LinkedIn'), "Twitter", 'Twitter'), "Enter_Twitter", 'girin Twitter'), "Experiences", 'deneyimler'), "bank_account", 'banka hesabı'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Company_Name", 'Şirket Adı'), "Location", 'Konum'), "Enter_location", 'Konum girin'), "Enter_Description", 'Açıklama Girin'), "Bank_Name", 'Banka adı'), "Enter_Bank_Name", 'Banka Adını Girin'), "Bank_Branch", 'Banka şubesi'), "Enter_Bank_Branch", 'Banka Şubesine Girin'), "Bank_Number", 'Banka numarası'), "Enter_Bank_Number", 'Banka Numarasını Girin'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Assigned_warehouses", 'Atanmış depolar'), "Top_customers", 'En iyi müşteriler'), "Attachment", 'Ek'), "view_employee", 'çalışanları görüntüle'), "edit_employee", 'çalışanları düzenle'), "delete_employee", 'çalışanları sil'), "Created_by", 'Tarafından eklendi'), "Add_product_IMEI_Serial_number", 'Ürün IMEI/Seri Numarası ekleyin'), "Product_Has_Imei_Serial_number", 'Üründe Imei/Seri Numarası Var'), "IMEI_SN", 'IMEI/SN'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Shipments", 'gönderiler'), "delivered_to", 'Teslim edildi'), "shipment_ref", 'Sevkiyat Referansı'), "sale_ref", 'Satış Referansı'), "Edit_Shipping", 'Gönderiyi Düzenle'), "Packed", 'paketlenmiş'), "Shipped", 'sevk edildi'), "Delivered", 'Teslim edilmiş'), "Cancelled", 'İptal edildi'), "Shipping_status", 'Nakliye durumu'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Users_Report", 'Kullanıcı Raporu'), "stock_report", 'Stok Raporu'), "TotalPurchases", 'Toplam Satın Alma'), "Total_quotations", 'Toplam Fiyat Teklifi'), "Total_return_sales", 'Toplam iade satışları'), "Total_return_purchases", 'Toplam iade alımları'), "Total_transfers", 'Toplam transferler'), "Total_adjustments", 'Toplam düzenlemeler'), "User_report", 'Kullanıcı Raporu'), "Current_stock", 'Mevcut stok'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_name", 'Ürün adı'), "Total_Customers_Due", 'Toplam borç'), "Total_Suppliers_Due", 'Toplam borç'), "Some_warehouses", 'Bazı Depolar'), "All_Warehouses", 'Tüm Depolar'), "Product_Cost", 'Ürün maliyeti'), "sms_settings", 'SMS Ayarları'), "pos_settings", 'POS Ayarları'), "payment_gateway", 'Ödeme Ağ Geçidi'), "mail_settings", 'Posta Ayarları'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Nexmo_SMS", 'Nexmo SMS'), "TWILIO_SMS", 'TWILIO SMS'), "Default_SMS_Gateway", 'Varsayılan SMS Ağ Geçidi'), "module_settings", 'Modül Ayarları'), "Module_enabled_success", 'Modül başarıyla etkinleştirildi'), "Module_Disabled_success", 'Modül Başarıyla Devre Dışı Bırakıldı'), "update_settings", 'Ayarları güncelle'), "Please_Upload_the_Correct_Module", 'Lütfen Doğru Modülü Yükleyin'), "Uploaded_Success", 'Başarıyla yüklendi'), "Customer_details", 'Müşteri detayları'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Edit_Customer", 'Müşteriyi Düzenle'), "Delete_Customer", 'Müşteriyi Sil'), "Pay_Due", 'borç ödemek'), "Paying_amount_is_greater_than_Total_Due", 'Ödeme tutarı Toplam borçtan fazla'), "Customer_Invoice", 'müşteri faturası'), "This_Product_Not_For_Selling", 'Bu Ürün Satılmamaktadır'), "Welcome_to_your_Dashboard", 'Kontrol Panelinize hoş geldiniz'), "Total_Payable", 'Toplam Ödenecek'), "Choose_Sale_Ref", 'Satış Referansını Seçin'), "Please_Select_Sale", 'Lütfen Satış Seçiniz'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sale_Ref", 'Satış Referansı'), "list_product_returns", 'ürün iadelerini listele'), "Qty_return", 'miktar dönüşü'), "Choose_Purchase_Ref", 'Satın Alma Referansını Seçin'), "Purchase_Ref", 'Satın Alma Ref'), "please_select_purchase", 'Lütfen Satın Al\'ı seçin'), "qty_return_is_greater_than_qty_purchased", 'Miktar getirisi, satın alınan Miktardan büyük'), "qty_return_is_greater_than_qty_sold", 'Miktar getirisi, satılan Miktardan büyük'), "Quantity_sold", 'Satılan miktar'), "qty_purchased", 'satın alınan miktar'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sender_Name", 'Gönderen adı'), "The_module_must_be_uploaded_as_zip_file", 'Modül zip dosyası olarak yüklenmelidir'), "Upload_Module", 'Modülü yükleyin'), "All_Modules_Installed", 'Kurulu Tüm Modüller'), "Current_Version", 'Şimdiki versiyonu'), "You_already_have_the_latest_version", 'Zaten en son sürüme sahipsiniz'), "Update_Available", 'Güncelleme uygun'), "Update_Log", 'Günlüğü Güncelle'), "Update_Now", 'Şimdi güncelle'), "View_Change_Log", 'Değişiklik Günlüğünü Görüntüle'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "invoice_footer", 'fatura altbilgisi'), "Please_Wait_for_the_update", 'NOT: Lütfen güncellemenin tamamen bitmesini bekleyin. Tarayıcıyı kapatmanız veya Yükseltme işlemini durdurmanız önerilmez.'), "Note_update", 'Not : Yükseltmeyi çalıştırmadan önce Mevcut sürümünüzü ve veritabanınızı yedeklediğinizden emin olun, Bir hata varsa geri yüklemek için'), "Time_Zone", 'Saat dilimi'), "Payment_note", 'ödeme notları'), "sale_note", 'satış notları'), "Total_Sale_Due", 'Toplam Satış borcu'), "Total_Sell_Return_Due", 'Toplam Satış İade borcu'), "pay_all_sell_due_at_a_time", 'bir seferde tüm satış borçlarını öde'), "pay_all_sell_return_due_at_a_time", 'bir seferde tüm satış iade borcunu öde'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Gross_Profit", 'Brüt kazanç'), "pay_all_purchase_due_at_a_time", 'tüm satın alma borcunu bir kerede öde'), "Delete_Provider", 'Sağlayıcıyı Sil'), "Edit_Provider", 'Sağlayıcıyı Düzenle'), "Provider_details", 'Sağlayıcı ayrıntıları'), "Total_Purchase_Due", 'Toplam Satın Alma borcu'), "Provider_Credit_Note", 'alacak notu'), "Customer_Credit_Note", 'alacak notu'), "Sell_Return", 'Satış İadesi'), "Purchase_Return", 'Satın alım iadesi'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Tax_Number", 'Vergi numarası'), "Please_add_return_quantity", 'Lütfen iade miktarını ekleyin'), "Return_exist_for_the_Transaction", 'İşlem için iade var'), "qty_return_is_greater_than_Quantity_Remaining", 'Miktar getirisi Kalan Miktardan daha büyük'), "products_refunded_alert", 'Miktarı 0 olarak ayarlanmış hiçbir ürün iade edilmeyecektir.'), "pay_all_purchase_return_due_at_a_time", 'vadesi gelen tüm satın alma iadelerini tek seferde ödeyin'), "Total_Purchase_Return_Due", 'Toplam Satın Alma İadesi Vadesi Gelen'), "Purchase_return_due", 'Satın alma iadesi vadesi geldi'), "Sell_return_due", 'İade borcunu sat'), "product_report", 'Ürün raporu'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "product_sales_report", 'ürün satış raporu'), "Product_purchases_report", 'Ürün satın alma raporu'), "Qty_sold", 'Satılan miktar'), "Qty_purchased", 'satın alınan miktar'), "Filter_by_warehouse", 'Mağazaya göre filtrele'), "Enable_Print_Invoice", 'Faturayı otomatik olarak yazdır'), "Show_Warehouse", 'ambarı göster'), "credit_card_info", 'Kredi kartı bilgileri'), "Saved_Credit_Card_Info", 'Kaydedilen Kredi Kartı Bilgileri'), "Credit_card_changed_successfully", 'Kredi kartı başarıyla değiştirildi'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "notification_template", 'Bildirim Şablonu'), "email_notification", 'E-posta Bildirimi'), "sms_notification", 'SMS Bildirimi'), "Change_product_details", 'Ürün detaylarını değiştir'), "edit_tax_and_discount_and_shipping", 'Vergi, indirim ve kargo bilgilerini düzenle'), "Create_Quotation_with_Stock", 'Stokla birlikte teklif oluştur'), "Variant_Name", 'Varyant Adı'), "Variant_cost", 'Varyant maliyeti'), "Variant_price", 'Varyant fiyatı'), "Variant_code", 'Varyant kodu'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Please_wait_until_the_product_is_loaded", 'Lütfen ürün yüklene kadar bekleyin'), "Choose_SMS_Gateway", 'SMS ağ geçidini seçin'), "Notification_Client", 'Müşteri Bildirimi'), "Available_Tags", 'Mevcut Etiketler'), "Email_Subject", 'E-posta Konusu'), "Email_body", 'E-posta İçeriği'), "Notification_Supplier", 'Tedarikçi Bildirimi'), "sms_body", 'SMS İçeriği'), "sms_templates", 'SMS Templates'), "email_templates", 'Email Templates'));

/***/ }),

/***/ "./resources/src/translations/locales/vn.js":
/*!**************************************************!*\
  !*** ./resources/src/translations/locales/vn.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var _Receipt$Pos_Settings;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
//Language Vietnamien

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Receipt$Pos_Settings = {
  Receipt: 'Biên nhận',
  Pos_Settings: 'Cài đặt điểm bán hàng',
  Note_to_customer: 'Lưu ý cho khách hàng',
  Show_Note_to_customer: 'Hiển thị ghi chú cho khách hàng',
  Show_barcode: 'Chương trình mã vạch',
  Show_Tax_and_Discount: 'Hiển thị thuế & chiết khấu & giao hàng',
  Show_Customer: 'Cho khách hàng xem',
  Show_Email: 'Hiển thị Email',
  Show_Phone: 'Hiển thị điện thoại',
  Show_Address: 'Hiển thị địa chỉ',
  DefaultLanguage: 'Ngôn ngữ mặc định',
  footer: 'chân trang',
  Received_Amount: 'Số tiền đã nhận',
  Paying_Amount: 'Số tiền thanh toán',
  Change: 'Biến đổi',
  Paying_amount_is_greater_than_Received_amount: 'Số tiền thanh toán lớn hơn số tiền đã nhận',
  Paying_amount_is_greater_than_Grand_Total: 'Số tiền thanh toán lớn hơn Tổng số tiền',
  code_must_be_not_exist_already: 'mã phải không tồn tại rồi',
  You_will_find_your_backup_on: 'Bạn sẽ tìm thấy bản sao lưu của mình trên',
  and_save_it_to_your_pc: 'và lưu nó vào máy tính của bạn',
  Scan_your_barcode_and_select_the_correct_symbology_below: 'Quét mã vạch của bạn và chọn mã ký hiệu chính xác bên dưới',
  Scan_Search_Product_by_Code_Name: 'Quét / Tìm kiếm sản phẩm theo tên mã',
  Paper_size: 'Khổ giấy',
  Clear_Cache: 'Xóa bộ nhớ cache',
  Cache_cleared_successfully: 'Đã xóa bộ nhớ cache thành công',
  Failed_to_clear_cache: 'Không xóa được bộ nhớ cache',
  Scan_Barcode: 'Máy quét mã vạch',
  Please_use_short_name_of_unit: 'Vui lòng sử dụng tên ngắn của đơn vị',
  DefaultCustomer: 'Khách hàng mặc định',
  DefaultWarehouse: 'Kho mặc định',
  Payment_Gateway: 'Cổng thanh toán',
  SMS_Configuration: 'Cấu hình SMS',
  Gateway: 'Cổng thanh toán',
  Choose_Gateway: 'Chọn Cổng thanh toán',
  Send_SMS: 'Đã gửi tin nhắn thành công',
  sms_config_invalid: 'sai cấu hình sms không hợp lệ',
  Remove_Stripe_Key_Secret: 'Xóa các khóa API sọc',
  credit_card_account_not_available: 'Tài khoản thẻ tín dụng không khả dụng',
  Credit_Card_Info: 'Thông tin thẻ tín dụng',
  developed_by: 'Được phát triển bởi',
  Unit_already_linked_with_sub_unit: 'Đơn vị đã được liên kết với đơn vị phụ',
  Total_Items_Quantity: 'Tổng số mặt hàng và số lượng',
  Value_by_Cost_and_Price: 'Giá trị theo Chi phí và Giá cả',
  Search_this_table: 'Tìm kiếm bảng này',
  import_products: 'Nhập sản phẩm',
  Field_optional: 'Trường tùy chọn',
  Download_exemple: 'Tải xuống ví dụ',
  field_must_be_in_csv_format: 'Trường phải ở định dạng csv',
  Successfully_Imported: 'Đã nhập thành công',
  file_size_must_be_less_than_1_mega: 'Kích thước tệp phải nhỏ hơn 1 mega',
  Please_follow_the_import_instructions: 'Vui lòng làm theo hướng dẫn nhập',
  must_be_exist: 'đơn vị phải được tạo',
  Import_Customers: 'Nhập khách hàng',
  Import_Suppliers: 'Các nhà cung cấp nhập khẩu',
  Recent_Sales: 'Bán hàng gần đây',
  Create_Transfer: 'Tạo chuyển khoản',
  order_products: 'đặt hàng',
  Search_Product_by_Code_Name: 'Tìm kiếm sản phẩm theo mã hoặc tên',
  Reports_payments_Purchase_Return: 'Báo cáo Mua hàng Trả lại Thanh toán',
  Reports_payments_Sale_Return: 'Báo cáo các khoản thanh toán trả lại hàng bán',
  payments_Sales_Return: 'thanh toán bán hàng trả lại',
  payments_Purchases_Return: 'thanh toán mua hàng trả lại',
  CreateSaleReturn: 'Tạo lợi nhuận bán hàng',
  EditSaleReturn: 'Chỉnh sửa lợi nhuận bán hàng',
  SalesReturn: 'Lợi nhuận bán hàng',
  CreatePurchaseReturn: 'Tạo lợi tức mua hàng',
  EditPurchaseReturn: 'Chỉnh sửa lợi tức mua hàng',
  PurchasesReturn: 'Mua hàng trả lại',
  Due: 'đến hạn',
  Profit: 'Lợi nhuận',
  Revenue: 'Doanh thu',
  Sales_today: 'Bán hàng hôm nay',
  People: 'Mọi người',
  Successfully_Created: 'Thành công trong việc tạo ra',
  Successfully_Updated: 'Cập nhật thành công',
  Success: 'Sự thành công',
  Failed: 'Thất bại',
  Warning: 'Cảnh báo',
  Please_fill_the_form_correctly: 'Vui lòng điền vào biểu mẫu một cách chính xác',
  Field_is_required: 'Lĩnh vực được yêu cầu',
  Error: 'lỗi!',
  you_are_not_authorized: 'Lấy làm tiếc! Bạn không được ủy quyền.',
  Go_back_to_home: 'Quay lại trang chủ',
  page_not_exist: 'Lấy làm tiếc! Trang bạn đang tìm kiếm không tồn tại.',
  Choose_Status: 'Chọn trạng thái',
  Choose_Method: 'Chọn phương pháp',
  Choose_Symbology: 'Chọn ký hiệu',
  Choose_Category: 'Chọn danh mục',
  Choose_Customer: 'Chọn khách hàng',
  Choose_Supplier: 'Chọn nhà cung cấp',
  Choose_Unit_Purchase: 'Chọn đơn vị mua hàng',
  Choose_Sub_Category: 'Chọn Danh mục con',
  Choose_Brand: 'Chọn thương hiệu',
  Choose_Warehouse: 'Chọn nhà kho',
  Choose_Unit_Sale: 'Chọn đơn vị bán hàng',
  Enter_Product_Cost: 'Nhập giá thành sản phẩm',
  Enter_Stock_alert: 'Nhập cảnh báo còn hàng',
  Choose_Unit_Product: 'Chọn đơn vị sản phẩm',
  Enter_Product_Price: 'Nhập giá sản phẩm',
  Enter_Name_Product: 'Nhập Tên Sản phẩm',
  Enter_Role_Name: 'Nhập tên vai trò',
  Enter_Role_Description: 'Nhập mô tả vai trò',
  Enter_name_category: 'Nhập tên danh mục',
  Enter_Code_category: 'Nhập mã danh mục',
  Enter_Name_Brand: 'Nhập tên thương hiệu',
  Enter_Description_Brand: 'Nhập nhãn hiệu mô tả',
  Enter_Code_Currency: 'Nhập tiền tệ mã',
  Enter_name_Currency: 'Nhập tên Đơn vị tiền tệ',
  Enter_Symbol_Currency: 'Nhập tiền tệ ký hiệu',
  Enter_Name_Unit: 'Nhập tên đơn vị',
  Enter_ShortName_Unit: 'Nhập tên viết tắt Đơn vị',
  Choose_Base_Unit: 'Chọn đơn vị cơ sở',
  Choose_Operator: 'Chọn nhà điều hành',
  Enter_Operation_Value: 'Nhập giá trị hoạt động',
  Enter_Name_Warehouse: 'Nhập tên kho',
  Enter_Phone_Warehouse: 'Nhập số điện thoại kho hàng',
  Enter_Country_Warehouse: 'Nhập quốc gia kho hàng',
  Enter_City_Warehouse: 'Nhập thành phố kho hàng',
  Enter_Email_Warehouse: 'Nhập Email Kho hàng',
  Enter_ZipCode_Warehouse: 'Nhập mã Zip kho hàng',
  Choose_Currency: 'Chọn tiền tệ',
  Thank_you_for_your_business: 'Cảm ơn bạn cho doanh nghiệp của bạn!',
  Cancel: 'Huỷ bỏ',
  New_Customer: 'Khách hàng mới',
  Incorrect_Login: 'Đăng nhập không chính xác',
  Successfully_Logged_In: 'Đã đăng nhập thành công',
  This_user_not_active: 'Người dùng này không hoạt động',
  SignIn: 'Đăng nhập',
  Create_an_account: 'Tạo một tài khoản',
  Forgot_Password: 'Quên mật khẩu ?',
  Email_Address: 'Địa chỉ email',
  SignUp: 'Đăng ký',
  Already_have_an_account: 'Bạn co săn san để tạo một tai khoản ?',
  Reset_Password: 'Đặt lại mật khẩu',
  Failed_to_authenticate_on_SMTP_server: 'Không xác thực được trên máy chủ SMTP',
  We_cant_find_a_user_with_that_email_addres: 'Chúng tôi không thể tìm thấy người dùng có địa chỉ email đó',
  We_have_emailed_your_password_reset_link: 'Chúng tôi đã gửi qua e-mail liên kết đặt lại mật khẩu của bạn',
  Please_fill_the_Email_Adress: 'Vui lòng điền vào Địa chỉ Email',
  Confirm_password: 'Xác nhận mật khẩu',
  Your_Password_has_been_changed: 'Mật khẩu của bạn đã được thay đổi',
  The_password_confirmation_does_not_match: 'Xác nhận mật khẩu không khớp',
  This_password_reset_token_is_invalid: 'Mã thông báo đặt lại mật khẩu này không hợp lệ',
  Warehouse_report: 'Báo cáo kho hàng',
  All_Warehouses: 'Tất cả các kho hàng',
  Expense_List: 'Danh sách chi phí',
  Expenses: 'Chi phí',
  This_Week_Sales_Purchases: 'Bán hàng và mua hàng trong tuần này',
  Top_Selling_Products: 'Sản phẩm bán chạy nhất',
  View_all: 'Xem tất cả',
  Payment_Sent_Received: 'Thanh toán đã Gửi và Nhận',
  Filter: 'Bộ lọc',
  Invoice_POS: 'POS xuất hóa đơn',
  Invoice: 'Hóa đơn',
  Customer_Info: 'thông tin khách hàng',
  Company_Info: 'Thông tin công ty',
  Invoice_Info: 'Thông tin hóa đơn',
  Order_Summary: 'Tóm tắt theo thứ tự',
  Quote_Info: 'Thông tin báo giá',
  Del: 'Xóa bỏ',
  SuppliersPaiementsReport: 'Báo cáo thanh toán cho nhà cung cấp',
  Purchase_Info: 'Thông tin mua hàng',
  Supplier_Info: 'Thông tin nhà cung cấp',
  Return_Info: 'thông tin về sự trở lại',
  Expense_Category: 'Hạng mục Chi phí',
  Create_Expense: 'Tạo chi phí',
  Details: 'Chi tiết',
  Discount_Method: 'Phương thức chiết khấu',
  Net_Unit_Cost: 'Đơn giá ròng',
  Net_Unit_Price: 'Đơn giá ròng',
  Edit_Expense: 'Chỉnh sửa chi phí',
  All_Brand: 'Tất cả thương hiệu',
  All_Category: 'Tất cả các loại',
  ListExpenses: 'Liệt kê chi phí',
  Create_Permission: 'Tạo quyền',
  Edit_Permission: 'Chỉnh sửa quyền',
  Reports_payments_Sales: 'Báo cáo thanh toán Bán hàng',
  Reports_payments_Purchases: 'Báo cáo thanh toán Mua hàng',
  Reports_payments_Return_Customers: 'Báo cáo thanh toán Khách hàng trả lại',
  Reports_payments_Return_Suppliers: 'Báo cáo thanh toán Trả lại nhà cung cấp',
  Expense_Deleted: 'Chi phí này đã bị xóa',
  Expense_Updated: 'Chi phí này đã được cập nhật',
  Expense_Created: 'Chi phí này đã được tạo',
  DemoVersion: 'Bạn không thể làm điều này trong phiên bản demo',
  OrderStatistics: 'Thống kê bán hàng',
  AlreadyAdd: 'Sản phẩm này đã được thêm vào !!',
  AddProductToList: 'Vui lòng thêm sản phẩm vào danh sách !!',
  AddQuantity: 'Vui lòng thêm số lượng Chi tiết !!',
  InvalidData: 'Dữ liệu không hợp lệ !!',
  LowStock: 'số lượng vượt quá số lượng có sẵn trong kho',
  WarehouseIdentical: 'Hai kho không thể giống hệt nhau !!',
  VariantDuplicate: 'Biến thể này là trùng lặp !!',
  Filesize: 'Kích thước tập tin',
  GenerateBackup: 'Tạo bản sao lưu',
  BackupDatabase: 'Cơ sở dữ liệu sao lưu',
  Backup: 'Sao lưu',
  Paid: 'Đã thanh toán',
  Unpaid: 'Chưa thanh toán',
  Today: 'Hôm nay',
  Income: 'Thu nhập'
}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Expenses", 'Chi phí'), "Sale", 'Giảm giá'), "Actif", 'Hoạt động'), "Inactif", 'Không hoạt động'), "Customers", 'Khách hàng'), "Phone", 'Điện thoại'), "SearchByPhone", 'Tìm kiếm bằng điện thoại'), "Suppliers", 'Các nhà cung cấp'), "Quotations", 'Báo giá'), "Sales", 'Bán hàng'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Purchases", 'Mua hàng'), "Returns", 'Lợi nhuận'), "Settings", 'Cài đặt'), "SystemSettings", 'Cài đặt hệ thống'), "Users", 'Người dùng'), "GroupPermissions", 'Quyền nhóm'), "Currencies", 'Tiền tệ'), "Warehouses", 'Nhà kho'), "Units", 'Các đơn vị'), "UnitsPrchases", 'Đơn vị mua hàng'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "UnitsSales", 'Đơn vị bán hàng'), "Reports", 'Báo cáo'), "PaymentsReport", 'Báo cáo thanh toán'), "PaymentsPurchases", 'Thanh toán Mua hàng'), "PaymentsSales", 'Thanh toán Bán hàng'), "ProfitandLoss", 'Lợi nhuận và thua lỗ'), "WarehouseStockChart", 'Biểu đồ kho hàng'), "SalesReport", 'Báo cáo bán hàng'), "PurchasesReport", 'Báo cáo mua hàng'), "CustomersReport", 'Báo cáo khách hàng'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SuppliersReport", 'Báo cáo nhà cung cấp'), "SupplierReport", 'Báo cáo nhà cung cấp'), "DailySalesData", 'Dữ liệu bán hàng hàng ngày'), "DailyPurchasesData", 'Daily Purchases Data'), "Derni\xE8rescinqrecords", 'Năm bản ghi cuối cùng'), "Filters", 'Bộ lọc'), "date", 'ngày'), "Reference", 'Tài liệu tham khảo'), "Supplier", 'Nhà cung cấp'), "PaymentStatus", 'Tình trạng thanh toán'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Customer", 'khách hàng'), "CustomerCode", 'Mã khách hàng'), "Status", 'Trạng thái'), "SupplierCode", 'Mã nhà cung cấp'), "Categorie", 'thể loại'), "Categories", 'Thể loại'), "StockTransfers", 'Chuyển kho'), "StockManagement", 'Quản lý chứng khoán'), "dashboard", 'bảng điều khiển'), "Products", 'Các sản phẩm'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "productsList", 'danh sách sản phẩm'), "ProductManagement", 'Quản lý sản phẩm'), "ProductQuantityAlerts", 'Cảnh báo số lượng sản phẩm'), "CodeProduct", 'Mã sản phẩm'), "ProductTax", 'Thuế sản phẩm'), "SubCategorie", 'Danh mục con'), "Name_product", 'Chỉ định'), "StockAlert", 'Cảnh báo hàng tồn kho'), "warehouse", 'Kho'), "Tax", 'Thuế'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "BuyingPrice", 'Giá mua'), "SellPrice", 'Giá bán'), "Quantity", 'Định lượng'), "UnitSale", 'Bán đơn vị'), "UnitPurchase", 'Mua đơn vị'), "ManagementCurrencies", 'Quản lý tiền tệ'), "CurrencyCode", 'Mã tiền tệ'), "CurrencyName", 'Tên tiền tệ'), "Symbol", 'Biểu tượng'), "All", 'Tất cả'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "EditProduct", 'Chỉnh sửa sản phẩm'), "SearchByCode", 'Tìm kiếm theo mã'), "SearchByName", 'Tìm kiếm theo tên'), "ProductDetails", 'Thông tin chi tiết sản phẩm'), "CustomerName", 'tên khách hàng'), "CustomerManagement", 'Quản lý khách hàng'), "Add", 'Tạo nên'), "add", 'Tạo nên'), "Edit", 'Biên tập'), "Close", 'Đóng'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "PleaseSelect", 'Vui lòng chọn'), "Action", 'Hoạt động'), "Email", 'thư'), "EditCustomer", 'Chỉnh sửa khách hàng'), "AddCustomer", 'Tạo khách hàng'), "Country", 'Quốc gia'), "City", 'Tp.'), "Adress", 'Địa chỉ'), "CustomerDetails", 'Chi tiết khách hàng'), "CustomersList", 'Danh sách khách hàng'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "SupplierCode", 'Mã nhà cung cấp'), "SupplierName", 'tên đệm'), "SuppliersManagement", 'Quản lý nhà cung cấp'), "SupplierDetails", 'Thông tin chi tiết về nhà cung cấp'), "QuotationsManagement", 'Quản lý Báo giá'), "SubTotal", 'Tổng phụ'), "MontantReste", 'Số tiền còn lại'), "complete", 'hoàn thành'), "EnAttendant", 'đang chờ xử lý'), "Recu", 'Nhận'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "partial", 'Một phần'), "Retournee", 'Trở về'), "DetailQuote", 'Báo giá chi tiết'), "EditQuote", 'Chỉnh sửa Báo giá'), "CreateSale", 'Tạo bán hàng'), "DownloadPdf", 'Tải PDF'), "QuoteEmail", 'Báo giá đã gửi qua thư'), "DeleteQuote", 'Xóa báo giá'), "AddQuote", 'Tạo Báo giá'), "SelectProduct", 'Chọn sản phẩm'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ProductCodeName", 'Product (Code - Name)'), "Price", 'Giá bán'), "CurrentStock", 'cổ phần'), "Total", 'Toàn bộ'), "Num", 'N°'), "Unitcost", 'Đơn giá'), "to", 'đến'), "Subject", 'Môn học'), "Message", 'Thông điệp'), "EmailCustomer", 'Gửi email cho khách hàng'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Sent", 'Gửi'), "Quote", 'Bảng báo giá'), "Hello", 'xin chào'), "AttachmentQuote", 'Vui lòng tìm tệp đính kèm cho Báo giá của bạn'), "AddProducts", 'Thêm sản phẩm vào danh sách đặt hàng'), "SelectWarehouse", 'Vui lòng chọn kho'), "SelectCustomer", 'vui lòng chọn khách hàng'), "SalesManagement", 'Quản lý bán hàng'), "Balance", 'Thăng bằng'), "QtyBack", 'Số lượng trở lại'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "TotalReturn", 'Bắt đầu lại từ đầu'), "Amount", 'Số tiền'), "SaleDetail", 'Chi tiết giảm giá'), "EditSale", 'Chỉnh sửa giảm giá'), "AddSale", 'Tạo bán hàng'), "ShowPayment", 'Hiển thị các khoản thanh toán'), "AddPayment", 'Tạo thanh toán'), "EditPayment", 'Chỉnh sửa Thanh toán'), "EmailSale", 'Send Sale in Email'), "DeleteSale", 'Xóa giảm giá'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "ModePaiement", 'Được trả bởi'), "Paymentchoice", 'Lựa chọn thanh toán'), "Note", 'Ghi chú'), "PaymentComplete", 'Hoàn tất thanh toán!'), "PurchasesManagement", 'Quản lý mua hàng'), "Ordered", 'Đã đặt hàng'), "DeletePurchase", 'Xóa giao dịch mua'), "EmailPurchase", 'Gửi đơn mua hàng qua thư'), "EditPurchase", 'Chỉnh sửa giao dịch mua'), "PurchaseDetail", 'Chi tiết Mua hàng'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "AddPurchase", 'Tạo giao dịch mua'), "EmailSupplier", 'Thư nhà cung cấp'), "PurchaseInvoice", 'Thanh toán mua hàng'), "PurchasesInvoicesData", 'Mua dữ liệu thanh toán'), "SalesInvoice", 'Thanh toán bán hàng'), "SalesInvoicesData", 'Dữ liệu thanh toán bán hàng'), "UserManagement", 'quản lý người dùng'), "Firstname", 'Tên đầu tiên'), "lastname", 'họ'), "username", 'tên tài khoản'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "password", 'Mật khẩu'), "Newpassword", 'Mật khẩu mới'), "ChangeAvatar", 'Thay đổi hình đại diện'), "LeaveBlank", 'Vui lòng để trống trường này nếu bạn chưa thay đổi'), "type", 'kiểu'), "UserPermissions", 'Quyền của người dùng'), "RoleName", 'Vai trò'), "RoleDescription", 'Mô tả vai trò'), "AddPermissions", 'Tạo quyền'), "View", 'Lượt xem'), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_Receipt$Pos_Settings, "Del", 'Xóa bỏ'), "NewAdjustement", 'Điều chỉnh mới'), "EditAdjustement", 'Chỉnh sửa điều chỉnh'), "CannotSubstraction", 'Bạn không thể trừ các sản phẩm có hàng 0'), "Addition", 'Thêm vào'), "Subtraction", 'Phép trừ'), "profil", 'hồ sơ'), "logout", 'đăng xuất'), "PurchaseAlre